-- MOD for DCS WORLD 
-- AU Daring Class Destroyer Vampire (D11), post 1970 refit.

----- Shapes --------------------------------------------------
mount_vfs_model_path	(current_mod_path.."/Shapes/")

----- Textures ---------------------------------------------------
--mount_vfs_texture_path  (current_mod_path.."/Textures/");
mount_vfs_texture_path  (current_mod_path.."/Textures/vampire.zip");

mount_vfs_liveries_path (current_mod_path.."/Liveries");
--dofile(current_mod_path..'/HMAS_Vampire_Ammo.lua');


GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship);

GT.visual = {};
GT.visual.shape = "audaringclass";
GT.visual.shape_dstr = "";

GT.animation_arguments.radar1_rotation = 11; -- Flag Animation
GT.radar1_period = 1;
GT.animation_arguments.radar2_rotation = 2; -- Radar 2 Rotation
GT.radar2_period = 9;
GT.animation_arguments.radar3_rotation = 3; -- Radar 3 Rotation
GT.radar2_period = 6;
GT.animation_arguments.luna_lights = -1; -- Running Lights (Disabled)


--GT.animation_arguments.water_propeller = 8;

---------- General Ship Parameters ---------------------------
GT.life = 6000;
GT.mass = 7.25e+006;
GT.max_velocity = 55;
GT.race_velocity = 40;
GT.economy_velocity = 30;
GT.economy_distance = 1.59272e+007;
GT.race_distance = 1.59272e+007;
GT.shipLength = 106.6;
GT.Width = 12;      	-- set this - Total Ship max width
GT.Height = 21.5;    	-- set this - Total Ship Height above 0
GT.Length = 114.76;   	-- set this - Total Ship Length
GT.DeckLevel = 5.5;		-- set this - Height of the main deck (mainly for Aircraft Carriers)
GT.X_nose = 55.000;		-- set this - Position of the bow ref. ship datum 0
GT.X_tail = -56.000;	-- set this - Position of the stern ref. ship datum 0
GT.Tail_Width = 11;		-- set this - Width of the stern (used to caclulate wake width?  Usually the width of the propellors)
GT.Gamma_max = 0.35;
GT.Om = 0.05;
GT.speedup = 0.0814062;
GT.R_min = 208.4;
GT.distFindObstacles = 350.6;

GT.airWeaponDist = 100000;
GT.airFindDist = 150000;


GT.exhaust = 	-- set this
{
	[1] = { size = 0.45 , pos = {0.306 , 16.8, 0.0 } },
	[2] = { size = 0.45 , pos = {-19.195 , 14.2, 0.0 } },
}


----------------------------------------------------------------------------------------------------------------------------
--------------  Damage Model 
---------------------------------------------------------------------------------------------------------------------------
-----------  Attenzione: gli argument devono essere unici.
GT.DM = {
----- Hull.
	{ area_name = "Hull_Bow_Port",			area_arg = 72,	area_life = 70, area_fire = { pos = {29.96, 3.0, 3.7}, size = 1.5}},
	{ area_name = "Hull_Bow_Stbd", 			area_arg = 73,	area_life = 70, area_fire = { pos = {32.0, 3.0,-3.3}, size = 1.5}},
	{ area_name = "Hull_Stern_Port", 		area_arg = 74,	area_life = 60, area_fire = { pos = {-35.772, 0.3, 5.8}, size = 1.5}},
    { area_name = "Hull_Stern_Stbd", 		area_arg = 75,	area_life = 60, area_fire = { pos = {-43.008, 0.3, -5.8}, size = 1.5}},
	{ area_name = "Hull_Deck_Forward", 		area_arg = 76,	area_life = 60, area_fire = { pos = {43.684, 5.0, 3.0}, size = 1.5}},
 	{ area_name = "Hull_Stern_Transom", 	area_arg = 77,	area_life = 60, area_fire = { pos = {-57.0, 2.6, 0.0}, size = 1.5}},
-------- Superstructure	
	{ area_name = "Rear-Superstructure",	area_arg = 82,	area_life = 80, area_fire = { pos = {-35.0, 4.0, 0.0}, size = 1.5}},
	{ area_name = "Bridge",					area_arg = 83,	area_life = 80, area_fire = { pos = {12.6, 5.0, 0.0}, size = 1.5}},
-------- 3x 4.5in Turrets	
	{ area_name = "Turret_A",				area_arg = 96,	area_life = 60, area_fire = { pos = {34.4, 6.6, 0.0}, size =  1.5}},
 	{ area_name = "Turret_B",				area_arg = 97,	area_life = 60, area_fire = { pos = {24.2, 8.4, 0.0}, size =  1.5}},
	{ area_name = "Turret_Y",				area_arg = 98,	area_life = 60, area_fire = { pos = {-36.8, 6.2, 0.0}, size =  1.5}},
---- Sink	
	{ area_name = "Daring_Destroyed",		area_arg = 77,	area_life = 60, area_fire = { pos = {-2.1, 2, 0.0}, size = 3}},

}


---------------------------------------------------------------------------------------------------------------------
------------          Armament Definitions
---------------------------------------------------------------------------------------------------------------------

-- 4.5 in Main Turrets (A, B, Y)

-- Source for modifications: https://en.wikipedia.org/wiki/North_Carolina-class_battleship
-- Oerlikon (20 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/Oerlikon_20_mm_cannon
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations

GT_t.WS_t.ship_Oerlikon_20 = {name = "20 mm Oerlikon"};
GT_t.WS_t.ship_Oerlikon_20.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-15), math.rad(90)},
                    };
GT_t.WS_t.ship_Oerlikon_20.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_Oerlikon_20.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_Oerlikon_20.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Oerlikon_20.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Oerlikon_20.reference_angle_Z = 0
GT_t.WS_t.ship_Oerlikon_20.LN = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1] = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1].type = 3
GT_t.WS_t.ship_Oerlikon_20.LN[1].distanceMin = 10
GT_t.WS_t.ship_Oerlikon_20.LN[1].distanceMax = 1500 -- effective shooting with 3600 meters
GT_t.WS_t.ship_Oerlikon_20.LN[1].max_trg_alt = 1000
GT_t.WS_t.ship_Oerlikon_20.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_Oerlikon_20.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_Oerlikon_20.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_Oerlikon_20.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1] = {}
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].shell_name = {"Rh202_20_AP", "Rh202_20_HE"};
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].shot_delay = 60/450 -- 450 rounds per minute average
GT_t.WS_t.ship_Oerlikon_20.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_Oerlikon_20.LN[1].BR = { {pos = {3.478, 0, 0} }, }



-- Bofors Mk 12 (40 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/Bofors_40_mm_gun
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations

GT_t.WS_t.ship_Bofors_40_Mk_12 = {name = "40 mm Bofors Mk 12"};
GT_t.WS_t.ship_Bofors_40_Mk_12.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-5), math.rad(90)},
                    };
GT_t.WS_t.ship_Bofors_40_Mk_12.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_Bofors_40_Mk_12.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_Bofors_40_Mk_12.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Bofors_40_Mk_12.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Bofors_40_Mk_12.reference_angle_Z = 0
GT_t.WS_t.ship_Bofors_40_Mk_12.LN = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1] = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].type = 3
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].distanceMin = 10
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].distanceMax = 7160 -- effective shooting
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].max_trg_alt = 3800
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1] = {}
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].ammo_capacity = 560;
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].shell_name = {"Bofors_40_Mk12_HE"};
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].shell_display_name = "40mm HE";
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].shot_delay = 60/120 -- 120 rpm
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_Bofors_40_Mk_12.LN[1].BR = { {pos = {3.478, 0, 0} }, }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 150mm
-------------------------------------------------------------------------------------------------
-- 38 Caliber Mark 12 (127 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/5%22/38_caliber_gun
-- Used default FMC5 MK45 127mm Navy artillery weapon system as template with alterations

GT_t.WS_t.ship_38cal_Mk12 = {name = "127 mm Mark 12"}
GT_t.WS_t.ship_38cal_Mk12.angles = {
					{math.rad(164.25), math.rad(-164.25), math.rad(-15), math.rad(85)},
					};
GT_t.WS_t.ship_38cal_Mk12.omegaY = 0.6
GT_t.WS_t.ship_38cal_Mk12.omegaZ = 0.6
GT_t.WS_t.ship_38cal_Mk12.reference_angle_Z = 0
GT_t.WS_t.ship_38cal_Mk12.LN = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1] = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1].type = 6
GT_t.WS_t.ship_38cal_Mk12.LN[1].xc = 3
GT_t.WS_t.ship_38cal_Mk12.LN[1].distanceMin = 50
GT_t.WS_t.ship_38cal_Mk12.LN[1].max_trg_alt = 7500
GT_t.WS_t.ship_38cal_Mk12.LN[1].reactionTime = 15
GT_t.WS_t.ship_38cal_Mk12.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_38cal_Mk12.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1] = {}
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1].ammo_capacity = 240 -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1].shell_name = {"MK45_127"}; -- Currently uses MK45 127 mm shells (127 mm ammo is WIP)
GT_t.WS_t.ship_38cal_Mk12.LN[1].PL[1].shot_delay = 60/15 -- (15 rounds per minute per barrel - average)
GT_t.WS_t.ship_38cal_Mk12.LN[1].automaticLoader = false;
GT_t.WS_t.ship_38cal_Mk12.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_38cal_Mk12.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 406mm
-------------------------------------------------------------------------------------------------
-- 45 Caliber Mark 6 (406 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/16%22/45_caliber_Mark_6_gun
-- Used default AK130 130mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_45cal_Mk6 = {name = "406 mm Mark 6"}
GT_t.WS_t.ship_45cal_Mk6.angles = {
					{math.rad(150), math.rad(-150), math.rad(-2), math.rad(45)},
					};
GT_t.WS_t.ship_45cal_Mk6.omegaY = 0.6
GT_t.WS_t.ship_45cal_Mk6.omegaZ = 0.6
GT_t.WS_t.ship_45cal_Mk6.reference_angle_Z = 0
GT_t.WS_t.ship_45cal_Mk6.LN = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1] = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1].type = 6
GT_t.WS_t.ship_45cal_Mk6.LN[1].distanceMin = 50
GT_t.WS_t.ship_45cal_Mk6.LN[1].max_trg_alt = 20
GT_t.WS_t.ship_45cal_Mk6.LN[1].reactionTime = 15
GT_t.WS_t.ship_45cal_Mk6.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_45cal_Mk6.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1] = {}
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].ammo_capacity = 240
GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].shell_name = {"A222_130"}; -- Currently uses A222 130 mm shells (406 mm ammo is WIP)
--GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].shell_name = {"Shell_406mm"};

GT_t.WS_t.ship_45cal_Mk6.LN[1].PL[1].shot_delay = 60/24 -- (24 rounds per minute per barrel - average)
GT_t.WS_t.ship_45cal_Mk6.LN[1].automaticLoader = false;
GT_t.WS_t.ship_45cal_Mk6.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_45cal_Mk6.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, 0.0} }, {pos = {8, 0, -0.1} } }


-------------------------------------------------------------------------------------------
--  Armi
-------------------------------------------------------------------------------------------
-- weapon systems
GT.WS = {};
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102;


------------------------------------------------------------------------------------------------
-- 3 Torrette to 410mm                                                                     --  
--------------  Turret A -----------------------------------------------
------------------------------------------------------------------------------------------------
-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.

ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_45cal_Mk6 );
GT.WS[ws].area = 'Turret_A'; 				-- Value that coresponds to the DM entry for this area of the ship.  May be the turret itself, or the area the turret is in.  Can be any descriptive value, so long as there is a "GT.DM =" area name definition with that name.
GT.WS[ws].center = 'CENTER_TOWER_01';		-- Name of the Helper object at the base of the Turret/gun that it rotates horizontally on.  May have reserved values (ie CENTER_TOWER_XX, and some others.  This needs testing).
GT.WS[ws].drawArgument1 = 41;				-- Horizontal Rotation Arg. Tested with args 0,1,13,14,17,18,40-60. Others may work.  Must match animation of turret/gun rotation in .max model.
GT.WS[ws].drawArgument2 = 51;				-- Gun Elevation Arg. Tested with args 0,1,13,14,17,18,40-60. Others may work.  Must match animation of gun elevaton in .max model.
GT.WS[ws].angles[1][1] = math.rad(140);		-- Gun/Turret max anti-clockwise angle, reference to ship datum. Zero = forward '+' = Anti-clockwise from zero, '-' = Clockwise from zero.
GT.WS[ws].angles[1][2] = math.rad(-140);	-- Gun/Turret max clockwise angle, reference to ship datum. Zero = forward '+' = Anti-clockwise from zero, '-' = Clockwise from zero
GT.WS[ws].reference_angle_Y = math.rad(0);	-- Gun turret resting direction.  Calculated as above.
GT.WS[ws].reference_angle_Z = math.rad(10);	-- Gun Barrel resting elevaton. 0 = hotizontal, '-' = below horizontal, '+' = above horizontal.
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 						-- Defines barrel count.  Must match helper names in .max for this gun/turret.
{
	{
		connector_name = 'POINT_NC_01_1',	-- NC is Naval Cannon - ie larger shells with big flame and smoke at the barrel (not an auto-cannon or machine gun).
		recoilArgument = 33,				-- This is the argument for the recoil animation for this gun barrel (if there is one).
	},
	{
		connector_name = 'POINT_NC_01_2',	-- This needs to be named differently to the first one.
		recoilArgument = 33,
	}
}
--   Any extra barrels defined here over the number actually modelled in the ship will appear to originate from the next helper object up
--			 in the gun/turret model heirachy (usually the one defined by "GT.WS[ws].center =", and extra shells will be fired than guns available to fire them.
--			It will work, but it won't be realistic.  Untested if this works for more than 4 barrels.  If the heirachy in the model runs out of helper objects this
--			 chain of guns seems to end without firing the extra barrels defined above the numebr of helper objects.
--   For rotation entries:
--		1) all angles are reference to the forward direction.
--				  i) 0 = forward in the direction of travel, in line with the ships datum.
--				 ii) + = angles to port from the ships londgitudinal datum.
--				iii) - = angles to starboard from the ships londgitudinal datum.
--				 iv) rotation direction is referenced top down, bow at the front
--     2) the .angles property of the gun/missile emplacment is an array that takes the following in order:
--		GT.WS[ws].angles[1][1] = math.rad(140);.angles[1][1] = math.rad(Xac);	Xac is the most anti-clockwise limit of rotation in degrees from 0.
--		GT.WS[ws].angles[1][1] = math.rad(140);.angles[1][2] = math.rad(Xc);	Xc is the most clockwise limit of rotation in degrees from 0.
--		GT.WS[ws].angles[1][1] = math.rad(140);.angles[1][3] = math.rad(Yl);	Y1 is the lowest angle of barrel elevation relative to the horizontal.
--		GT.WS[ws].angles[1][1] = math.rad(140);.angles[1][4] = math.rad(Yh);	Yh is the highest angle of barrel elevation relative to the horizontal.

-------------------------------------------------------------------------------------------------------------
-------------  Turret B -------------------------------------------------------------

-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_45cal_Mk6 );
GT.WS[ws].area = 'Turret_B'; -- Turret B
GT.WS[ws].center = 'CENTER_TOWER_02';
--GT.WS[ws].drawArgument1 = 13
--GT.WS[ws].drawArgument2 = 14
GT.WS[ws].drawArgument1 = 42;					-- Horizontal Rotation Arg
GT.WS[ws].drawArgument2 = 52;					-- Gun Elevation Arg
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].reference_angle_Y = math.rad(0);
GT.WS[ws].reference_angle_Z = math.rad(20);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_NC_02_1',
		recoilArgument = 34,
	},
	{
		connector_name = 'POINT_NC_02_2',
		recoilArgument = 34,
	}
}

-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
--- Turret Y ----------------------------------------------------------------------
---   Stern cannon turret
-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_45cal_Mk6 );
--GT.WS[ws].area = 'Torre_380_Dora' 
GT.WS[ws].area = 'Turret_Y'; -- Turret Y
GT.WS[ws].center = 'CENTER_TOWER_03';
--GT.WS[ws].drawArgument1 = 17;
--GT.WS[ws].drawArgument2 = 18;
GT.WS[ws].drawArgument1 = 43;					-- Horizontal Rotation Arg
GT.WS[ws].drawArgument2 = 53;					-- Gun Elevation Arg
GT.WS[ws].reference_angle_Y = math.rad(180);
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
--GT.WS[ws].angles = {
--					{math.rad(-45), math.rad(-180), math.rad(2), math.rad(80)},
--					{math.rad(180), math.rad(45), math.rad(2), math.rad(80)},
--}
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_NC_03_1',
		recoilArgument = 35,
	},
	{
		connector_name = 'POINT_NC_03_2',
		recoilArgument = 35,
	}
}

--- 1)  Single Bofors 40 mm gun - Fwd Superstructure Port
ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 );
GT.WS[ws].area = 'Bridge';
GT.WS[ws].center = 'CENTER_TOWER_14';
GT.WS[ws].drawArgument1 = 44;
GT.WS[ws].drawArgument2 = 54;
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].angles[1][3] = math.rad(-5);
GT.WS[ws].angles[1][4] = math.rad(70);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_1_1',
		recoilArgument = 150,
	}
}

--- 2)  Single Bofors 40 mm gun - Fwd Superstructure Starboard
ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 );
GT.WS[ws].area = 'Bridge';
GT.WS[ws].center = 'CENTER_TOWER_15';
GT.WS[ws].drawArgument1 = 45;
GT.WS[ws].drawArgument2 = 55;
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].angles[1][3] = math.rad(-5);
GT.WS[ws].angles[1][4] = math.rad(70);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_2_1',
		recoilArgument = 152,
	}
}

--- 3)  Single Bofors 40 mm gun - Aft Superstructure Starboard
ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 );
GT.WS[ws].area = 'Rear-Superstructure';
GT.WS[ws].center = 'CENTER_TOWER_16';
GT.WS[ws].drawArgument1 = 46;
GT.WS[ws].drawArgument2 = 56;
GT.WS[ws].angles[1][1] = math.rad(-10);
GT.WS[ws].angles[1][2] = math.rad(-180);
GT.WS[ws].angles[1][3] = math.rad(-5);
GT.WS[ws].angles[1][4] = math.rad(70);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].reference_angle_Z = math.rad(5);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_3_1',
		recoilArgument = 151,
	},
	{
		connector_name = 'POINT_Bofors_3_2',
		recoilArgument = 151,
	}
}

--- 4)  Single Bofors 40 mm gun - Aft Superstructure Port
ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Bofors_40_Mk_12 );
GT.WS[ws].area = 'Rear-Superstructure';
GT.WS[ws].center = 'CENTER_TOWER_17';
GT.WS[ws].drawArgument1 = 47;
GT.WS[ws].drawArgument2 = 57;
GT.WS[ws].angles[1][1] = math.rad(180);
GT.WS[ws].angles[1][2] = math.rad(10);
GT.WS[ws].angles[1][3] = math.rad(-5);
GT.WS[ws].angles[1][4] = math.rad(70);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].reference_angle_Z = math.rad(5);  
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bofors_4_1',
		recoilArgument = 153,
	},
	{
		connector_name = 'POINT_Bofors_4_2',
		recoilArgument = 153,
	}
}

----------------------------------------------------------------------------------------------------------------------------------
---  The Final Code
----------------------------------------------------------------------------------------------------------------------------------

GT.Name = "hmas_vampire";
GT.DisplayName = _("HMAS Vampire II (D11) post 1970");
GT.Rate = 4000;

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
                RADAR = {
                    "ticonderoga search radar",
                }
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";

GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,
		
                    "Cruisers",
                    "RADAR_BAND1_FOR_ARM",
                    "DetectionByAWACS",
				};
			

GT.Categories = {
					{name = "Armed Ship"},
				};

add_surface_unit(GT);