#ifndef _NVD_COMMON_
#define _NVD_COMMON_

#include "common/context.hlsl"

float NVG_SIZE = 0.9; //Taz1004 NVG size.  Default is 1.  Higher is smaller
float NVG_VERT_POS = -0.2; //Taz1004 NVG Vertical position.  Default is 0.  Positive value will raise up.  Negative value will lower.

#define MASK_SIZE ((1.0/0.8) * NVG_SIZE)

float getMask(float2 c, float mul)
{
	return saturate(mul*(1 - sqrt(dot(c, c))));
}

float2 calcMaskCoord(float2 projPos)
{
	return float2((projPos.x - gNVDpos.x) * gNVDaspect, projPos.y - (gNVDpos.y + NVG_VERT_POS)) * MASK_SIZE;
}

float getNVDMask(float2 projPos) {
	float2 uvm = calcMaskCoord(projPos);
	return getMask(uvm, 10);
}

float getMask2(float d, float mul)
{
	return 1 - saturate(mul * (1 - d));
}

float2 calcMaskCoord2(float2 projPos)
{
	float4 vp = mul(float4(projPos, 1, 1), gProjInv);
	float3 vp3 = normalize(vp.xyz / vp.w);
	float mul = sqrt(gNVDmul);
	return float2(dot(gNVDdir, vp3) * gNVDmul, sqrt(1.0 - 1.0 / (gNVDmul * gNVDmul)));
}

float getNVDMask2(float2 projPos)
{
	float2 d = calcMaskCoord(projPos);
	return getMask(d.x, 10 * d.x / d.y);
}

#endif
