
local mig35_r37m_name = 'R-37M (AA-13 Axehead) - Active Rdr'
local mig35_r37m_mass = 510
local pylon_mass = 1.0

local mig35_r37m_warhead = enhanced_a2a_warhead(9, 178)

local mig35_r37m_AA = {
    category        = CAT_AIR_TO_AIR,
    name            = mig35_r37m_name,
    model           = 'R37M',
    user_name       = _(mig35_r37m_name),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    mass            = mig35_r37m_mass,

	Escort 			= 0,
    Head_Type 		= 2,
	sigma 			= {5, 5, 5},
    M 				= mig35_r37m_mass,
    H_max 			= 25000.0,
    H_min 			= 1.0,
    Diam			= 380.0,
    Cx_pil 			= 2.5,
    D_max 			= 55000.0,
    D_min 			= 800.0,
    Head_Form 		= 1,
    Life_Time 		= 215.0,
    Nr_max 			= 30,
    v_min 			= 140.0,
    v_mid 			= 700.0,
    Mach_max 		= 6.2,
    t_b 			= 0.0,
    t_acc 			= 5.0,
    t_marsh 		= 9.0,
    Range_max 		= 230000.0,
    H_min_t 		= 1.0,
    Fi_start 		= 0.5,
    Fi_rak 			= 3.14152,
    Fi_excort 		= 1.05,
    Fi_search 		= 1.05,
    OmViz_max 		= 0.52,
    exhaust 		= {0.8, 0.8, 0.8, 0.05 };
    X_back 			= -1.435,
    Y_back 			= -0.193,
    Z_back 			= 0.0,
    Reflection 		= 0.1,
    KillDistance 	= 19.0,
    display_name_short = "R-37M",
	Damage = 142,
	loft 			= 1,
	hoj 			= 1,
	ccm_k0 			= 0.1,
	loft_factor 	= 1.0,

	active_radar_lock_dist	= 32000.0,
	go_active_by_default	= 1,
        sens_near_dist              = 100,
        sens_far_dist               = 38000,
        FOV                         = math.rad(140),
        max_w_LOS                   = math.rad(35),
	
	PN_coeffs = {3, 				-- Number of Entries	
				15000.0 ,1.0,		-- Less 5 km to target Pn = 1
				25000.0, 0.5,		-- Between 10 and 5 km  to target, Pn smoothly changes from 0.5 to 1.0. 
				40000.0, 0.25};		-- Between 15 and 10 km  to target, Pn smoothly changes from 0.2 to 0.5. Longer then 15 km Pn = 0.2.

    warhead         = mig35_r37m_warhead,
    warhead_air     = mig35_r37m_warhead,

    shape_table_data = {
        {
            name     = mig35_r37m_name,
            file     = 'R37M',
            life     = 1,
            fire     = {0, 1},
            username = "37M",		--Shortened name for cockpit displays
            index    = WSTYPE_PLACEHOLDER,
        },
    },

	ModelData = {   58 ,  -- model params count
					0.4 ,   -- characteristic square (характеристическая площадь)
					
					-- параметры зависимости Сx
					0.029 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
					0.06 , -- Cx_k1 высота пика волнового кризиса
					0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
					-0.245, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
					0.08 , -- Cx_k4 крутизна спада за волновым кризисом 
					0.7 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
					
					-- параметры зависимости Cy
					1.2 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
					0.5	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
					1.1  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
					
					0.5 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
					0.0, --угловая скорость создаваймая моментом газовых рулей
					
				-- Engine data. Time, fuel flow, thrust.	
				--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
					-1.0,		0.0,	5.0,  		9.0,		90.0,			0.0,		1.0e9,         -- time of stage, sec
					 0.0,		0.0,	4.5,		3.6,		1.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
					 0.0,		0.0,	44000.0,	44000.0,		0.0,			0.0,		0.0,           -- thrust, newtons
				
					 214, -- таймер самоликвидации, сек
					 215.0, -- время работы энергосистемы, сек
					 0, -- абсолютная высота самоликвидации, м
					 1.0, -- время задержки включения управления (маневр отлета, безопасности), сек
					 25000, --40000 -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
					 15000, --40000 -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
					 0.52356,--0.17, -- синус угла возвышения траектории набора горки
					 50.0, -- продольное ускорения взведения взрывателя
					 0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
					 1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
					 1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
					 2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

					  -- DLZ. Данные для рассчета дальностей пуска (индикация на прицеле)
					 21.0, 
					 -23.0, 
					 -3.0, 
					 137500, 
					 30500, 
					 228000,
					 78500, 
					 37000, 
					 15000, 
					 5000, 
					 0.4, 
					 -0.015, 
					 0.5,	
    },
}

declare_weapon(mig35_r37m_AA)

declare_loadout({
	category		=	CAT_AIR_TO_AIR,
	CLSID			= 	"{mig35_r37m}",
	Picture			=	"r33.png",
	wsTypeOfWeapon	=	mig35_r37m_AA.wsTypeOfWeapon,
	displayName		=	_(mig35_r37m_name),
	attribute		=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
	Count			=	1,
	Weight			=	mig35_r37m_mass + pylon_mass,
	Elements		=	
	{
		{
		
			ShapeName	=	"R37M",
			Position	=	{0,	0,	0}
		},
	}, 	
	
})