local RAIL 	= 0
local CATAPULT = 1

local function BD3(clsid)
	return {CLSID = clsid, arg_value = 0.15 }
end

local function MBD(clsid)
	return {CLSID = clsid, arg_value = 0.25 }
end

Mig_29K =  {
	Name = 'Mig-29K',
	DisplayName	= _('MiG-29K AI'),
    EmptyWeight = "11222", --11300 - unusable fuel 78kg 
	MaxFuelWeight = "3493",
	MaxHeight = "18000",
	MaxSpeed = "2450",
	MaxTakeOffWeight = "19700",
	Picture = "MIG-29M2.png",
	Rate = "50",
	Shape = "Mig-29M2",
	WingSpan = 14.7,
    WorldID = 50,
	shape_table_data 	= 
	{
		{
			file  	 	= 'Mig-29M2';
			life  	 	= 30; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'mig-29-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'Mig-29M2';
			index    	=  5000;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "mig-29-oblomok";
			file  = "mig-29-oblomok";
			fire  = { 240, 2};
		},
	},

	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
		
	mapclasskey = "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, Mig_29M2, "Multirole fighters", "Refuelable", "Datalink"},
	Categories			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	-------------------------	
		M_empty = 10922, --11000 - unusable fuel 78kg 
		M_nominal	=	13240,
		M_max	=	19700,
		M_fuel_max	=	3376,
		H_max	=	18000,
		average_fuel_consumption	=	0.2743,
		CAS_min	=	60,
		V_opt	=	222,
		V_take_off	=	67,
		V_land	=	70,
		has_afteburner	=	true,
		has_speedbrake	=	true,
		radar_can_see_ground	=	true,
		AOA_take_off	=	0.17,
		stores_number	=	7,
		bank_angle_max	=	60,
		Ny_min	=	-3,
		Ny_max	=	8,
		tand_gear_max	=	0.577,
		V_max_sea_level	=	416.7,
		V_max_h	=	680.6,
		wing_area	=	38.1,
		wing_span	=	11.36,
		thrust_sum_max	=	10160,
		thrust_sum_ab	=	16680,
		Vy_max	=	330,
		length	=	20.32,
		height	=	4.73,
		flaps_maneuver	=	1,
		Mach_max	=	2.3,
		range	=	1500,
		RCS	=	3,
		Ny_max_e	=	8,
		detection_range_max	=	180,
		IR_emission_coeff	=	0.77,
		IR_emission_coeff_ab	=	3,
		engines_count	=	2,
		wing_tip_pos = 	{-3.8,	0.14,	5.8},
		
		nose_gear_pos 								= {3.295,	-1.849,	0},
		nose_gear_amortizer_direct_stroke			= 0,  -- down from nose_gear_pos !!!
		nose_gear_amortizer_reversal_stroke			= 1.517 - 1.794,  -- up 
		nose_gear_amortizer_normal_weight_stroke	= -0.07,-- down from nose_gear_pos
		nose_gear_wheel_diameter					=	0.57,
		
		main_gear_pos 							 = {-0.928,-1.789,	1.523},
		main_gear_amortizer_direct_stroke		 = 0, --  down from main_gear_pos !!!
		main_gear_amortizer_reversal_stroke		 = 1.395 - 1.689, --  up 
		main_gear_amortizer_normal_weight_stroke = -0.1,-- down from main_gear_pos
		main_gear_wheel_diameter				 =	0.84,
		
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-5.534,	-0.063,	-0.909},
				elevation	=	-1.5,
				diameter	=	0.949,
				exhaust_length_ab	=	8.629,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				azimuth      = 2.5,
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-5.534,	-0.063, 0.909},
				elevation	=	-1.5,
				diameter	=	0.949,
				exhaust_length_ab	=	8.629,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				azimuth      = -2.5,
			}, -- end of [2]
		}, -- end of engines_nozzles
		crew_memb1ers = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	48,
				pos = 	{4.403,	1.209,	0},
			}, -- end of [1]
		}, -- end of crew_members
		
		crew_members = 
		{
			[1] = 
			{
					ejection_seat_name	=	9,
					drop_canopy_name	=	48,
					pos = 	{4.403,	1.209,	0},
					ejection_order 		= 2,
					canopy_arg          = 38, 
					pilot_body_arg 		= 540,
					can_be_playable 	= true,
					ejection_added_speed = {-5,15,0},
					role 				 = "pilot",
					role_display_name    = _("Pilot"),
					--ejection_through_canopy = true, --no openbeta usare mechanimations
			
				g_suit 			   =  2.2,
				bailout_arg = -1, --abilitare su openbeta con mechanimations
			}, -- end of [1]
			[2] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	48,
				pos = 	{5.38,	1.209,	0},
				canopy_arg          = 38, 
				can_be_playable 	= true,
				pilot_body_arg = 541,
				ejection_order 		= 1,
				ejection_added_speed = {-5,15,0},
				role 				 = "navigator",
				role_display_name    = _("Navigator pilot"),
				g_suit 			   =  2.2,
				bailout_arg = -1, --abilitare su openbeta con mechanimations
			},-- end of [2]
		}, -- end of crew_members
		
		brakeshute_name	=	4,
		tanker_type	=	4,
		air_refuel_receptacle_pos     =   {7.4358,    0.548,  -0.7762},
		fires_pos = 
		{
			[1] = 	{-1.36,	-0.185,	0},
			[2] = 	{-0.595,	0.294,	2.66},
			[3] = 	{-1.743,	0.234,	-3.769},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-4.471,	-0.059,	0.91},
			[9] = 	{-4.471,	-0.059,	-0.91},
			[10] = 	{-0.491,	0.629,	2.03},
			[11] = 	{-0.491,	-0.019,	0},
		}, -- end of fires_pos
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	0.999,	0.052},
				pos = 	{-0.937,	1.645,	-1.726},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	0.999,	-0.052},
				pos = 	{-0.937,	1.645,	1.726},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser
	--    mechanimations openbeta ok
	passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 96,
			-- PPR-26
			chaff = {default = 48, increment = 12, chargeSz = 1},
			-- PPI-26
			flare = {default = 48, increment = 12, chargeSz = 1}
        },
        
    mechanimations = {
            Door0 = {
                {Transition = {"Close", "Open"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 0.6, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 1.0, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 0.3, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 1.0, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                    }, Flags = {"Reversible"}},
                {Transition = {"Open", "Close"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.00 * 0.9, "at", 0.6}}},
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 1.0, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 0.3, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 1.0, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 0.5, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.25, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.95 * 0.9, "at", 0.125, "sign" , -1}}},
                    }, Flags = {"Reversible", "StepsBackwards"}},
                {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0}}}}},
            },
        },

	-- add model draw args for network transmitting to this draw_args table (16 limit)
	net_animation = 
	{
		 13, --[[right LE flap]]
		 14, --[[left LE flap]]
		 23, --[[chocks]]
		 25, --[[hoook]]
		 35, --[[drag chute]]
		 36, --[[drag chute]]
		 37, --[[drag chute]]
		181,     --	Canopy Ext
		190,
		191,
		192,
		274, --[[left aux inlet]]
		275, --[[right aux inlet]]
		327, --[[left up gun door]]
		328, --[[right up gun door]]
		329, --[[left down gun door]]
		419, --[[right down gun door]]
		427, --[[right down gun door]]
		470, --[[nose strut]]
		450, --[[nose strut]]
		2215, --[[right thrust v]]
		2216, --[[left thrust v]]
		3322,
		3480,
		3481,
		3482,
		2016,
		2015,
	},
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),
	EPLRS = true,
	Sensors = {
		RADAR =  "KLJ-7"  ,
		IRST  = "OLS-27",
		RWR   = "Abstract RWR",
	},
	Countermeasures = {
	ECM 			= "AN/ALQ-165",
	},	
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio	= {
		frequency	= 124.0,
		editable	= true,
		minFrequency	= 118.000,
		maxFrequency	= 399.975,
	    rangeFrequency = {
			{min = 118.0, max = 155.995},
			{min = 225.0, max = 399.975}
		},
		modulation	= MODULATION_AM,
	},
	panelRadio	= {
		[1] = {  
		    name = _("COMM 1: R-800"),
		    range = {
				{min = 30.0, max = 87.995},
				{min = 108.0, max = 173.995},
				{min = 225.0, max = 399.975}
			},
			channels = {
				[1] = { name = _("Channel 1"),		default = 305.0, modulation = _("AM/FM"), connect = true}, -- default
				[2] = { name = _("Channel 2"),		default = 264.0, modulation = _("AM/FM")},	-- min. water : 135.0, 264.0
				[3] = { name = _("Channel 3"),		default = 265.0, modulation = _("AM/FM")},	-- nalchik : 136.0, 265.0
				[4] = { name = _("Channel 4"),		default = 256.0, modulation = _("AM/FM")},	-- sochi : 127.0, 256.0
				[5] = { name = _("Channel 5"),		default = 254.0, modulation = _("AM/FM")},	-- maykop : 125.0, 254.0
				[6] = { name = _("Channel 6"),		default = 250.0, modulation = _("AM/FM")},	-- anapa : 121.0, 250.0
				[7] = { name = _("Channel 7"),		default = 270.0, modulation = _("AM/FM")},	-- beslan : 141.0, 270.0
				[8] = { name = _("Channel 8"),		default = 257.0, modulation = _("AM/FM")},	-- krasnodar-pashk. : 128.0, 257.0
				[9] = { name = _("Channel 9"),		default = 255.0, modulation = _("AM/FM")},	-- gelenjik : 126.0, 255.0
				[10] = { name = _("Channel 10"),	default = 262.0, modulation = _("AM/FM")},	-- kabuleti : 133.0, 262.0
				[11] = { name = _("Channel 11"),	default = 259.0, modulation = _("AM/FM")},	-- gudauta : 130.0, 259.0
				[12] = { name = _("Channel 12"),	default = 268.0, modulation = _("AM/FM")},	-- soginlug : 139.0, 268.0
				[13] = { name = _("Channel 13"),	default = 269.0, modulation = _("AM/FM")},	-- vaziani : 140.0, 269.0
				[14] = { name = _("Channel 14"),	default = 260.0, modulation = _("AM/FM")},	-- batumi : 131.0, 260.0
				[15] = { name = _("Channel 15"),	default = 263.0, modulation = _("AM/FM")},	-- kutaisi : 134.0, 263.0
				[16] = { name = _("Channel 16"),	default = 261.0, modulation = _("AM/FM")},	-- senaki : 132.0, 261.0
				[17] = { name = _("Channel 17"),	default = 267.0, modulation = _("AM/FM")},	-- lochini : 138.0, 267.0
				[18] = { name = _("Channel 18"),	default = 251.0, modulation = _("AM/FM")},	-- krasnodar-center : 122.0, 251.0
				[19] = { name = _("Channel 19"),	default = 253.0, modulation = _("AM/FM")},	-- krymsk : 124.0, 253.0
				[20] = { name = _("Channel 20"),	default = 266.0, modulation = _("AM/FM")},	-- mozdok : 137.0, 266.0
			}
		},
		[2] = {  
		    name = _("COMM 2: R-800"),
		    range = {
				{min = 30.0, max = 87.995},
				{min = 108.0, max = 173.995},
				{min = 225.0, max = 399.975}
			},
			channels = {
				[1] = { name = _("Channel 1"),		default = 305.0, modulation = _("AM/FM"), connect = true}, -- default
				[2] = { name = _("Channel 2"),		default = 264.0, modulation = _("AM/FM")},	-- min. water : 135.0, 264.0
				[3] = { name = _("Channel 3"),		default = 265.0, modulation = _("AM/FM")},	-- nalchik : 136.0, 265.0
				[4] = { name = _("Channel 4"),		default = 256.0, modulation = _("AM/FM")},	-- sochi : 127.0, 256.0
				[5] = { name = _("Channel 5"),		default = 254.0, modulation = _("AM/FM")},	-- maykop : 125.0, 254.0
				[6] = { name = _("Channel 6"),		default = 250.0, modulation = _("AM/FM")},	-- anapa : 121.0, 250.0
				[7] = { name = _("Channel 7"),		default = 270.0, modulation = _("AM/FM")},	-- beslan : 141.0, 270.0
				[8] = { name = _("Channel 8"),		default = 257.0, modulation = _("AM/FM")},	-- krasnodar-pashk. : 128.0, 257.0
				[9] = { name = _("Channel 9"),		default = 255.0, modulation = _("AM/FM")},	-- gelenjik : 126.0, 255.0
				[10] = { name = _("Channel 10"),	default = 262.0, modulation = _("AM/FM")},	-- kabuleti : 133.0, 262.0
				[11] = { name = _("Channel 11"),	default = 259.0, modulation = _("AM/FM")},	-- gudauta : 130.0, 259.0
				[12] = { name = _("Channel 12"),	default = 268.0, modulation = _("AM/FM")},	-- soginlug : 139.0, 268.0
				[13] = { name = _("Channel 13"),	default = 269.0, modulation = _("AM/FM")},	-- vaziani : 140.0, 269.0
				[14] = { name = _("Channel 14"),	default = 260.0, modulation = _("AM/FM")},	-- batumi : 131.0, 260.0
				[15] = { name = _("Channel 15"),	default = 263.0, modulation = _("AM/FM")},	-- kutaisi : 134.0, 263.0
				[16] = { name = _("Channel 16"),	default = 261.0, modulation = _("AM/FM")},	-- senaki : 132.0, 261.0
				[17] = { name = _("Channel 17"),	default = 267.0, modulation = _("AM/FM")},	-- lochini : 138.0, 267.0
				[18] = { name = _("Channel 18"),	default = 251.0, modulation = _("AM/FM")},	-- krasnodar-center : 122.0, 251.0
				[19] = { name = _("Channel 19"),	default = 253.0, modulation = _("AM/FM")},	-- krymsk : 124.0, 253.0
				[20] = { name = _("Channel 20"),	default = 266.0, modulation = _("AM/FM")},	-- mozdok : 137.0, 266.0
			}
		},
	},
	TACAN_AA	= true,
	Guns = {gun_mount("GSh_30_1", { count = 150 },{muzzle_pos = {6.44,   0.34,  1.0}}),
	},

--	pylons_enumeration = {12, 1, 11, 2, 3, 10, 4, 9, 5, 8, 7, 6}

	Pylons =     {                                    --      -atras    arriba    -izq 
		pylon(1, 0, -2.175, -0.218, 4.734, --1, 0, -1.943000, 0.173000, -7.280000,
            {
			arg_value = 1, FiZ = -1, --clean be default
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.55, -0.05, 0}, Type = 0 },	--R-73
                { CLSID = "{mig29m2-r73m}", attach_point_position = {0.1, 0, 0}, Type = 0 },	--R-73M
				
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },	--Smoke Generator - orange
            }
        ),
        pylon(2, 0, -2.535000, -0.165000, -6.120000,  --2, 0, -2.535000, -0.165000, -6.168000,
            {
			arg_value = 1, FiZ = -1, --clean be default
            },
            {
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", Type = 0 }, --R-73
                { CLSID = "{mig29m2-r73m}", Type = 0 },	--R-73M
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-77
				{ CLSID = "{mig29m2-r771}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-771
				--{ CLSID = "{Su30_ASTRA}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --Astra
				
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", attach_point_position = {0.7, 0, 0}, arg_value = 0.1 		 }, -- FAB-250
				
				{ CLSID = '{P-50T}'								  , attach_point_position = {0.7, 0, 0}, arg_value = 0.1 }, -- p-50t
            }
        ),
        pylon(3, 0, -1.137000, -0.321000, -4.489000, --
            {
			arg_value = 1, FiZ = -1, --clean be default
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", Type = 0 },	--R-73
                { CLSID = "{mig29m2-r73m}", Type = 0 },	--R-73M
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, 	--R-77
				{ CLSID = "{mig29m2-r771}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-771
				--{ CLSID = "{Su30_ASTRA}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --Astra
				
				--{ CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", attach_point_position = {0.1, 0.03, 0.02}, arg_value = 0.2, Type = 1}, --Kh-29L
				--{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", attach_point_position = {0.1, 0.03, 0.02}, arg_value = 0.2, Type = 1}, --Kh-29T
				
                --{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500Kr
                --{ CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500L

                { CLSID = "{S_25_O}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-OFM
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.1 		 }, -- B-8M1
				
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", attach_point_position = {0.7, 0, 0}, arg_value = 0.1 		 }, -- FAB-250
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.1 		 }, -- RBK-500 PTAB-10-5
				
				{ CLSID = '{P-50T}'								  , attach_point_position = {0.7, 0, 0}, arg_value = 0.1 }, -- p-50t
				
            }
        ),
		pylon(4, 0, -0.091000, -0.321000, -3.228400, --
            {
			arg_value = 1, FiZ = -1, --clean be default
            },
            {
                { CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", Type = 0 },	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", Type = 0 },	--R-27T
                { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0 },	--R-27ET
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 },	--R-27ER
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, 	--R-77
				{ CLSID = "{mig29m2-r771}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-771
				--{ CLSID = "{Su30_ASTRA}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --Astra
				
                { CLSID = "{D8F2C90B-887B-4B9E-9FE2-996BC9E9AF03}", arg_value = 0.2, attach_point_position = {0.1, 0.03, 0.01}, Type = 1},	--Kh-31P
                { CLSID = "{4D13E282-DF46-4B23-864A-A9423DFDE50A}", arg_value = 0.2, attach_point_position = {0.1, 0.03, 0.01}, Type = 1}, --Kh-31A
                { CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", arg_value = 0.2, attach_point_position = {0.1, 0.03, 0.01}, Type = 1}, --Kh-29L
                { CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.2, attach_point_position = {0.1, 0.03, 0.01}, Type = 1}, --Kh-29T
				{ CLSID = "{KH_35}"							  	  , arg_value = 0.2, Type = 1}, -- Kh-35
				
                { CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500Kr
                { CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500L

                { CLSID = "{S_25_O}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-OFM
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.1 		 }, -- B-8M1

				{ CLSID = "{KAB_1500Kr_LOADOUT}" , attach_point_position = {0.1, -0.28, 0}				     }, -- KAB-1500Kr
				
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", attach_point_position = {0.7, 0, 0}, arg_value = 0.1 		 }, -- FAB-250
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.1 		 }, -- RBK-500 PTAB-10-5
				
				--{ CLSID = "{C0FF4842-FBAC-11d5-9190-00A0249B6F00}" , arg_value = 0.1},--fuel tank
				{ CLSID = "{PTB_800_MIG21}" , attach_point_position = {0, 0.02, 0}, arg_value = 0.1},--fuel tank
            }
        ),
        pylon(5, 1, -0.783000, -0.150000, 0.000000, --
            {
                -- FiZ = -2,
				arg_value = 1,--clean be default
            },
            {
				{ CLSID = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}", attach_point_position = {0.5, 0, 0} },--fuel tank
				
            }
        ),
        pylon(6, 1, -4.000000, -0.500000, 0.000000,  ---0.520000
            {
				FiZ = -1,
				arg_value = 1,--clean be default
            },
            {
                { CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", Type = 0 },	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", Type = 0 },	--R-27T
                { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 0 },	--R-27ET
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 0 },	--R-27ER
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , attach_point_position = {0.1, 0.03, 0}, Type = 0}, 	--R-77
				{ CLSID = "{mig29m2-r771}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-771
				--{ CLSID = "{Su30_ASTRA}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --Astra
				
                { CLSID = "{D8F2C90B-887B-4B9E-9FE2-996BC9E9AF03}", arg_value = 0.2, attach_point_position = {0.1, 0.03, -0.01}, Type = 1},	--Kh-31P
                { CLSID = "{4D13E282-DF46-4B23-864A-A9423DFDE50A}", arg_value = 0.2, attach_point_position = {0.1, 0.03, -0.01}, Type = 1}, --Kh-31A
                { CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", arg_value = 0.2, attach_point_position = {0.1, 0.03, -0.01}, Type = 1}, --Kh-29L
               { CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.2, attach_point_position = {0.1, 0.03, -0.01}, Type = 1}, --Kh-29T
				{ CLSID = "{KH_35}"							  	  , arg_value = 0.2, Type = 1}, -- Kh-35
				
                { CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500Kr
                { CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500L

                { CLSID = "{S_25_O}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-OFM
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.1 		 }, -- B-8M1

				{ CLSID = "{KAB_1500Kr_LOADOUT}" , attach_point_position = {0.1, -0.28, 0}				     }, -- KAB-1500Kr
				
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", attach_point_position = {0.7, 0, 0}, arg_value = 0.1 		 }, -- FAB-250
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.1 		 }, -- RBK-500 PTAB-10-5
				
				--{ CLSID = "{C0FF4842-FBAC-11d5-9190-00A0249B6F00}" , arg_value = 0.1},--fuel tank
				{ CLSID = "{PTB_800_MIG21}" , attach_point_position = {0, 0.02, 0}, arg_value = 0.1},--fuel tank
            }
        ),
        pylon(7, 1, 0.8500000, -0.500000, 0.000000,
            {
				arg_value = 1, FiZ = -1, --clean be default
            },
            {
               { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", Type = 0 },	--R-73
                { CLSID = "{mig29m2-r73m}", Type = 0 },	--R-73M
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, 	--R-77
				{ CLSID = "{mig29m2-r771}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-771
				--{ CLSID = "{Su30_ASTRA}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --Astra
				
				{ CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", attach_point_position = {0.1, 0.03, -0.02}, arg_value = 0.2, Type = 1}, --Kh-29L
				{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", attach_point_position = {0.1, 0.03, -0.02}, arg_value = 0.2, Type = 1}, --Kh-29T
				
                { CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500Kr
                { CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.1, 0.03, 0}, arg_value = 0.1 		 }, -- KAB-500L

                { CLSID = "{S_25_O}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.9, 0.05, 0}, arg_value = 0.1 		 }, -- S-25-OFM
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.1 		 }, -- B-8M1
				
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", attach_point_position = {0.7, 0, 0}, arg_value = 0.1 		 }, -- FAB-250
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.1 		 }, -- RBK-500 PTAB-10-5
				
				{ CLSID = '{P-50T}'								  , attach_point_position = {0.7, 0, 0}, arg_value = 0.1 }, -- p-50t		
            }
        ),
		 pylon(8, 0,  -0.075000, -1.218000, 1.145000,  --2, 0, -2.535000, -0.165000, -6.168000,
            {
			arg_value = 1, FiZ = -1, --clean be default
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", Type = 0 }, --R-73
                { CLSID = "{mig29m2-r73m}", Type = 0 },	--R-73M
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-77
				{ CLSID = "{mig29m2-r771}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --R-771
				--{ CLSID = "{Su30_ASTRA}", attach_point_position = {0.1, 0.03, 0}, Type = 0 }, --Astra
				
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", attach_point_position = {0.7, 0, 0}, arg_value = 0.1 		 }, -- FAB-250
				
				{ CLSID = '{P-50T}'								  , attach_point_position = {0.7, 0, 0}, arg_value = 0.1 }, -- p-50t
            }
        ),
        pylon(9, 1, -0.075000, -1.218000, 1.145000,
             {
			arg_value = 1, FiZ = -1, --clean be default
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.55, -0.05, 0}, Type = 0 },	--R-73
                { CLSID = "{mig29m2-r73m}", attach_point_position = {0.1, 0, 0}, Type = 0 },	--R-73M
				
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" },	--Smoke Generator - orange
            }
        ),
       
},
	
	Tasks = {
        aircraft_task(AFAC),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
        aircraft_task(CAS),
        aircraft_task(PinpointStrike),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
		aircraft_task(CAP),
     	aircraft_task(Escort),
        aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
		
		aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.75,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.032,
			cx_flap	=	0.035,
			cy_flap	=	0.24,
			cx_brk	=	0.06,
			table_data = 
			{
				[1] = 	{0,	0.024,	0.07,	0.075,	0.12,	0.2,	30,	1.2},
				[2] = 	{0.2,	0.024,	0.07,	0.075,	0.12,	0.8,	30,	1.2},
				[3] = 	{0.4,	0.024,	0.07,	0.075,	0.12,	1.8,	30,	1.2},
				[4] = 	{0.6,	0.0239,	0.073,	0.075,	0.12,	2.5,	30,	1.2},
				[5] = 	{0.7,	0.024,	0.076,	0.075,	0.12,	2.634,	28.666666666667,	1.18},
				[6] = 	{0.8,	0.0235,	0.079,	0.075,	0.12,	2.5,	27.333333333333,	1.16},
				[7] = 	{0.9,	0.025,	0.083,	0.075,	0.125,	1.9,	26,	1.14},
				[8] = 	{1,	0.044,	0.085,	0.14,	0.1,	1.43,	24.666666666667,	1.12},
				[9] = 	{1.05,	0.0465,	0.0855,	0.1775,	0.125,	1.047,	24,	1.11},
				[10] = 	{1.1,	0.049,	0.086,	0.215,	0.15,	0.9,	18,	1.1},
				[11] = 	{1.2,	0.049,	0.083,	0.228,	0.17,	0.8,	17,	1.05},
				[12] = 	{1.3,	0.049,	0.077,	0.237,	0.2,	0.7,	16,	1},
				[13] = 	{1.5,	0.0475,	0.062,	0.251,	0.2,	0.7,	13,	0.9},
				[14] = 	{1.7,	0.045166666666667,	0.051333333333333,	0.24366666666667,	0.32,	0.7,	12,	0.7},
				[15] = 	{1.8,	0.044,	0.046,	0.24,	0.38,	0.7,	11.4,	0.64},
				[16] = 	{2,	0.043,	0.039,	0.222,	2.5,	0.7,	10.2,	0.52},
				[17] = 	{2.2,	0.041,	0.034,	0.227,	3.2,	0.7,	9,	0.4},
				[18] = 	{2.5,	0.04,	0.033,	0.25,	4.5,	0.7,	9,	0.4},
				[19] = 	{3.9,	0.035,	0.033,	0.35,	6,	0.7,	9,	0.4},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	60.00001,--67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19,
			dcx_eng	=	0.0144,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	6600,
			dpdh_f	=	13200,
			table_data = 
			{
				[1] = 	{0,	88000,	141000},
				[2] = 	{0.2,	80000,	143000},
				[3] = 	{0.4,	79000,	150000},
				[4] = 	{0.6,	82000,	165000},
				[5] = 	{0.7,	90000,	177000},
				[6] = 	{0.8,	94000,	193000},
				[7] = 	{0.9,	96000,	200000},
				[8] = 	{1,	100000,	205000},
				[9] = 	{1.1,	100000,	214000},
				[10] = 	{1.2,	98000,	222000},
				[11] = 	{1.3,	100000,	235000},
				[12] = 	{1.5,	98000,	258000},
				[13] = 	{1.8,	94000,	266000},
				[14] = 	{2,	88000,	273000},
				[15] = 	{2.2,	82000,	275000},
				[16] = 	{2.5,	80000,	277000},
				[17] = 	{3.9,	50000,	200000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	
Damage = {
	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 8,  args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 2,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 1,  args = {183}},
	[23] = {critical_damage = 5,  args = {223}},
	[24] = {critical_damage = 5,  args = {213}},
	[27] = {critical_damage = 3,  args = {231}},
	[28] = {critical_damage = 3,  args = {221}},
	[29] = {critical_damage = 6,  args = {224}, deps_cells = {23}},
	[30] = {critical_damage = 6,  args = {214}, deps_cells = {24}},
	[35] = {critical_damage = 6,  args = {225}, deps_cells = {23, 29, 27, 37}},
	[36] = {critical_damage = 6,  args = {215}, deps_cells = {24, 30, 28, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}}, 
	[40] = {critical_damage = 2,  args = {241}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[55] = {critical_damage = 2,  args = {159}},
	[58] = {critical_damage = 2,  args = {156}},
	[59] = {critical_damage = 2,  args = {148}},
	[82] = {critical_damage = 2,  args = {152}},
	[83] = {critical_damage = 3, args = {134}}, -- nose wheel                                  
	[84] = {critical_damage = 3, args = {136}}, -- left wheel                                  
	[85] = {critical_damage = 3, args = {135}}, -- right wheel                                 

	},
	DamageParts = 
	{  
		[1] = "mig-29c-oblomok-wing-r", -- wing R
		[2] = "mig-29c-oblomok-wing-l", -- wing L
	},
	

	lights_data = {
	typename = "collection",
	lights = {
    [1] = { typename = "collection",
						lights = {
								  -- Tail Anticollision Light
								  {typename = "natostrobelight",
								   connector = "BANO_0_BACK",
								   argument_1 = 192,
								   period = 1.2,
								   phase_shift = 0
								  }
								 }
									  },
	[2] = { typename = "collection",
							lights = {-- Landing light
									  {typename = "spotlight",
									   connector = "MAIN_SPOT_PTR",
									   argument = 209,
									   dir_correction = {elevation = math.rad(-1)}
									  },
									  {-- Landing/Taxi light
									   typename = "spotlight",
									   connector = "MAIN_SPOT_PTR_01",
									   argument = 208,
									   dir_correction = {elevation = math.rad(3)}
									  }
									 }
						},
    [3]	= {	typename = "collection",
								lights = {-- Left Position Light (red)
								{typename = "omnilight",
								 connector = "BANO_1",
								 color = {0.99, 0.11, 0.3},
								 intensity_max = 5.0,
								 pos_correction  = {0.1, 0, -0.2},
								 argument  = 190
								},
								 -- Right Position Light (green)
								{typename = "omnilight",
								connector = "BANO_2",
								color = {0, 0.894, 0.6},
								intensity_max = 4.0,
								pos_correction = {0.1, 0, 0.2},
								argument  = 191
								},
								-- Tail Position Light (white)
								{typename = "omnilight",
								connector = "BANO_0",
								color = {1, 1, 1},
								intensity_max = 4,
								pos_correction  = {0, 0, 0},
								argument  = 192
								}}
							},
		}
	},	
	
}
add_aircraft(Mig_29K)