package.path = package.path ..';./Scripts/DemoScenes/?.lua;'
local sceneEnvironment = require("demosceneEnvironment")

scene = {} --     

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	sceneAPI:setUpdateFunc('sceneVRUpdate')
	sceneAPI:setEnvironmentMap("Bazar/Graphics/VRMainScene.dds",0.9);
	sceneAPI:setSun(math.rad(-90), math.rad(0)) --       

--  scene.m			= sceneAPI:addModel("fa-18c", 0, 2.2, 0);
	scene.m			= sceneAPI:addModel("f-16c_bl50", 2, 2, -1);
	scene.m:setLivery("IAF_115th_Aggressors_Squadron", "F-16C_50");
	scene.m:setArgument(0, 1);
	scene.m:setArgument(3, 1);
	scene.m:setArgument(5, 1);
	scene.m:setArgument(4, 0.25);
	scene.m:setArgument(6, 0.25);
	scene.m:setArgument(115, 1);
	scene.m:setArgument(116, 1);
	scene.m:setArgument(117, 1);
	scene.m:setArgument(310, 0.5);
	scene.m:setArgument(314, 0.5);
	
	scene.m:setArgument(1000, -1);
	scene.m:setArgument(1001, -1);
	scene.m:setArgument(1002, -1);
	scene.m:setArgument(1003, -1);
	
		--f16 01 Loadout
	scene.aim9x1 = sceneAPI:addModel("aim-9x", 0, 0, 0);
	scene.aim9x1:attachTo(scene.m, "Pylon1");
	scene.aim9x2 = sceneAPI:addModel("aim-9x", 0, 0, 0);
	scene.aim9x2:attachTo(scene.m, "Pylon9");
	scene.aim1201 = sceneAPI:addModel("aim-120c", 0, 0, 0);
	scene.aim1201:attachTo(scene.m, "Pylon2");
	scene.aim1202 = sceneAPI:addModel("aim-120c", 0, 0, 0);
	scene.aim1202:attachTo(scene.m, "Pylon8");
	scene.aim1203 = sceneAPI:addModel("aim-120c", 0, 0, 0);
	scene.aim1203:attachTo(scene.m, "Pylon3");
	scene.aim1204 = sceneAPI:addModel("aim-120c", 0, 0, 0);
	scene.aim1204:attachTo(scene.m, "Pylon7");
	scene.ft3701 = sceneAPI:addModel("fuel_tank_370gal", -0.5, 0, 0);
	scene.ft3701:attachTo(scene.m, "Pylon4");
	scene.ft3702 = sceneAPI:addModel("fuel_tank_370gal", -0.5, 0, 0);
	scene.ft3702:attachTo(scene.m, "Pylon6");

	local cam_level = 1.8

	scene.cam		= sceneAPI:addCamera(10, cam_level , 6)
	scene.cam:setFarClip(1000.0)
	scene.cam:setFov(90)
	scene.cam.transform:lookAtPoint(-10, cam_level, 20);


	scene.flr		= sceneAPI:addModel("shelter_floor", 0,0,0);
	scene.flr:drawToEnvironment(true);
	scene.flr.transform:scale(2,1.5,1.5);

	scene.sh		= sceneAPI:addModel("ukrytie", 0,0,0); 
	scene.sh:drawToEnvironment(true);
	scene.sh.transform:scale(2,2,2);

	scene.L1			= sceneAPI:addLightOmni(0, 25, 0,	1,0.8,0.5);
	scene.L1:setRadius(200);
	scene.L1:setAmount(1);

	scene.cam:setActive()
end

--[0;1]
local function pingpong(length, t)
	local tt = (t%length)*2/length
	if tt>1 then tt = 2-tt end
	return tt
end


function sceneVRUpdate(t, dt)

end



