--mounting 3d model paths and texture paths 

mount_vfs_texture_path	(current_mod_path ..  "/Theme/ME")	--for simulator loading window
mount_vfs_texture_path  (current_mod_path ..  "/Cockpit/Resources/Model/Textures/F-5E3-CPT-TEXTURES")
mount_vfs_model_path    (current_mod_path ..  "/Cockpit/Resources/Model/Shape")
mount_vfs_model_path	(current_mod_path ..  "/Shapes")
mount_vfs_liveries_path (current_mod_path..	  "/Liveries")
mount_vfs_texture_path  (current_mod_path..   "/Textures")


dofile(current_mod_path.."/Views.lua")



local tips =
{
    { CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}", Cx_gain = 1/2.91},-- AIM_9P
    { CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}" },-- Smokewinder red
    { CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}" },-- Smokewinder green
    { CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}" },-- Smokewinder blue
    { CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}" },-- Smokewinder white
    { CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}" },-- Smokewinder yellow
    { CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}" },-- Smokewinder orange
    { CLSID = "{AIS_ASQ_T50}", attach_point_position = {0.40,  0.0,  0.0}},-- AIS POD
}
local outboard =
{
    { CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}", Cx_gain = 1/2.91},-- AIM_9P
	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	{ CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
	{ CLSID = "{00F5DAC4-0466-4122-998F-B1A298E34113}",	arg_value = 0.0}, -- M-117
	{ CLSID = "{CBU-52B}", arg_value = 0.0}, -- CBU-52
	{ CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}", arg_value = 0.0}, -- LAU-68-MK1
	{ CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}", arg_value = 0.0}, -- LAU-68-MK5
	{ CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}", arg_value = 0.0}, -- LAU-68-MK61
	{ CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}", arg_value = 0.0}, -- LAU-68-M151
	{ CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}", arg_value = 0.0}, -- LAU-68-MK156
	{ CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}", arg_value = 0.0}, -- LAU-68-WTU1B
	{ CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}", arg_value = 0.0}, -- LAU-68-M257
	{ CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}", arg_value = 0.0}, -- LAU-68-W274
	{ CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.0}, -- LAU-61 - 19 MK151 HE / LAU-3/-60
	{ CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}", arg_value = 0.0}, -- LAU-61 - 19 MK156 WP
	{ CLSID = "{CAE48299-A294-4bad-8EE6-89EFC5DCDF00}", arg_value = 0.0}, -- SUU-25 8 LUU-2
	{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", arg_value = 0.0,attach_point_position = { 0.0, -0.010, 0.0}}, -- GBU-12
}
local inboard =
{
	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	{ CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
	{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83
	{ CLSID = "{00F5DAC4-0466-4122-998F-B1A298E34113}", arg_value = 0.0}, -- M-117
	{ CLSID = "{CBU-52B}", arg_value = 0.0}, -- CBU-52
	{ CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}", arg_value = 0.0}, -- LAU-68-MK1
	{ CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}", arg_value = 0.0}, -- LAU-68-MK5
	{ CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}", arg_value = 0.0}, -- LAU-68-MK61
	{ CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}", arg_value = 0.0}, -- LAU-68-M151
	{ CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}", arg_value = 0.0}, -- LAU-68-MK156
	{ CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}", arg_value = 0.0}, -- LAU-68-WTU1B
	{ CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}", arg_value = 0.0}, -- LAU-68-M257
	{ CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}", arg_value = 0.0}, -- LAU-68-W274
	{ CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", arg_value = 0.0}, -- LAU-61 - 19 MK151 HE / LAU-3/-60
	{ CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}", arg_value = 0.0}, -- LAU-61 - 19 MK156 WP
	{ CLSID = "{0395076D-2F77-4420-9D33-087A4398130B}", arg_value = 0.0}, -- 275 gal drop tank
	{ CLSID = "{PTB-150GAL}",							arg_value = 0.0}, -- 150 gal drop tank
	{ CLSID = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", arg_value = 0.0,attach_point_position = { 0.0, -0.013, 0.0}}, -- GBU-12
	{ CLSID = "MXU-648-TP", arg_value = 0.0}, -- MXU-648-TP
}
local centerline =
{
	{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", arg_value = 0.0,attach_point_position = { -0.10, -0.008, 0.0}}, -- Mk-82	*
	{ CLSID = "{Mk82SNAKEYE}",							arg_value = 0.0,attach_point_position = { -0.10,  0.012, 0.0}}, -- Mk-82 Snakeye	*
	{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", arg_value = 0.0}, -- Mk-83
	{ CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", arg_value = 0.0}, -- Mk-84
	{ CLSID = "{00F5DAC4-0466-4122-998F-B1A298E34113}", arg_value = 0.0}, -- M-117
	{ CLSID = "{CBU-52B}", arg_value = 0.0}, -- CBU-52
	{ CLSID = "{0395076D-2F77-4420-9D33-087A4398130B}", arg_value = 0.0}, -- 275 gal drop tank
	{ CLSID = "{PTB-150GAL}",							arg_value = 0.0}, -- 150 gal drop tank
	{ CLSID = "{MER-5E_MK82x5}"						  , arg_value = 0.0,attach_point_position = {0.0, -0.005, 0.0}}, -- MER-5E 5xMk-82
	{ CLSID = "{MER-5E_Mk82SNAKEYEx5}"				  , arg_value = 0.0,attach_point_position = {0.0, -0.005, 0.0}}, -- MER-5E 5xMk-82 Snakeye
	{ CLSID = "MXU-648-TP", arg_value = 0.0}, -- MXU-648-TP
}


F_5E3 =  {
        
	Name 				=   'F-5E3',
	DisplayName			= _('F-5E3'),
	Cannon = "yes",
	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	
	Picture 			= "F-5E.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "f-5e3",
	
	shape_table_data 	= 
	{
		{
			file  	 	= 'f-5e3';
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    		= 'f-5e_oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'F-5E3';
			index    	=  WSTYPE_PLACEHOLDER;
		},
		{
			name  = "f-5e3_oblomok";
			file  = "f-5e3_oblomok";
			fire  = { 240, 2};
		},

	},
	mapclasskey 		= "P0091000024",
        attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, MiG_29C,
        "Fighters",
        },
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
    CanopyGeometry = {
            azimuth = {-145.0, 145.0},
            elevation = {-50.0, 90.0}
    },

	nose_gear_pos 							 = 	{ 4.406, -1.898, 0},
	nose_gear_amortizer_direct_stroke        =  0,
	nose_gear_amortizer_reversal_stroke      = -0.502,  -- up 
	nose_gear_amortizer_normal_weight_stroke = -0.050-0.325,
	nose_gear_wheel_diameter				 =	0.460,
	
	main_gear_pos 							 = 	{-0.8546, -1.702458, 1.914661},
	main_gear_amortizer_direct_stroke	     =  0,
	main_gear_amortizer_reversal_stroke      = -0.215084, --  up 
	main_gear_amortizer_normal_weight_stroke = -0.165,
	main_gear_wheel_diameter				 =	0.600,

	radar_can_see_ground						=	false,
	range										=	2112,
	tand_gear_max								=	1.1917,
	tanker_type									=	0,
	thrust_sum_ab								=	7500,
	thrust_sum_max								=	4534,
	wing_area									=	17.3,
	wing_span									=	8.53,
	wing_tip_pos 								= 	{-2.784,	-0.393,	4.037},
	IR_emission_coeff							=	0.4,
	IR_emission_coeff_ab						=	2,
	M_empty										=	4835, 
	M_fuel_max									=	2046,
	M_max										=	11187,
	M_nominal									=	7800,
	Mach_max									=	1.61,
	MaxFuelWeight								=	2046,
	MaxHeight									=	18000,
	MaxSpeed									=	1700,
	MaxTakeOffWeight							=	11187,
	Ny_max										=	7.5,
	Ny_max_e									=	7,
	Ny_min										=	-2,
	RCS											=	5,
	EmptyWeight									=	4835,
	defFuelRatio								=	0.84, -- топливо по умолчанию в долях от полного
	H_max										=	11000,
	V_land										=	68,
	V_max_h										=	484,
	V_max_sea_level								=	374,
	V_opt										=	174,
	V_take_off									=	65,
	Vy_max										=	200,
	WingSpan									=	8.53,
	average_fuel_consumption					=	0.06,
	bank_angle_max								=	60,
	bigParkingRamp								=	false,
	brakeshute_name								=	3,
	detection_range_max							=	60,
	engines_count								=	2,
	flaps_maneuver								=	1,
	has_afteburner								=	true,
	has_differential_stabilizer					=	false,
	has_speedbrake								=	true,
	height										=	4.06,
	is_tanker									=	false,
	air_refuel_receptacle_pos					= 	{0,	0,	0},
	length										=	14.68,
	stores_number								=	7,
	
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name	=	17,
			drop_canopy_name	=	43,
			pos = 	{2.112,	-0.369,	0},
		}, -- end of [1]
	}, -- end of crew_members
	
	-- add model draw args for network transmitting to this draw_args table (16 limit)
	net_animation = 
	{
		474, --[[nose strut]]
		475, --[[nose strut]]
	},
	
	Pylons =	{
        pylon(1, 0, -1.319000, -0.332000, -4.099000,
			{
				use_full_connector_position = true,
				connector = "Pylon1",
			},
			tips
		),
        pylon(2, 0, -1.122000, -0.861000, -3.132000,
			{
				use_full_connector_position = true,
				connector = "Pylon2",
				arg				= 309,
				arg_value		= 1,
			},
			outboard
		),
        pylon(3, 0, -1.190000, -0.922000, -2.334000,
			{
				use_full_connector_position = true,
				connector = "Pylon3",
				arg				= 310,
				arg_value		= 1,
			},
			inboard
		),
        pylon(4, 0,  0.065000, -0.930000,  0.000000,
			{
				use_full_connector_position = true,
				connector = "Pylon4",
				arg				= 311,
				arg_value		= 1,
			},
			centerline
		),
        pylon(5, 0, -1.190000, -0.922000,  2.334000,
			{
				use_full_connector_position = true,
				connector = "Pylon5",
				arg				= 312,
				arg_value		= 1,
			},
			inboard
		),
        pylon(6, 0, -1.122000, -0.861000,  3.132000,
			{
				use_full_connector_position = true,
				connector = "Pylon6",
				arg				= 313,
				arg_value		= 1,
			},
			outboard
		),
        pylon(7, 0, -1.319000, -0.332000,  4.099000,
			{
				use_full_connector_position = true,
				connector = "Pylon7",
			},
			tips
		),
	},
	
	Guns = {
	    gun_mount("M_39",
		{ count = 280 },
		{
			muzzle_pos				= {4.904,  0.239,-0.248},
			muzzle_pos_connector	= "Gun_point_00",
			supply_position			= {4.8753, 0, -0.2},	-- approx
			drop_cartridge 			= 204,		-- cartridge_50cal
			ejector_pos_connector	= "ejector_1",
			ejector_dir 			= {-2,0,0},
			effects = {
				{name = "FireEffect", arg = 432,duration = 0.02, attenuation = 2 , light_pos = {0.5,0,0}},
				{name = "SmokeEffect"},
			},
			smoke_dir = {0, -3, 10},
			gas_deflector = true,
		}
		),			-- LEFT
		gun_mount("M_39",
			{ count = 280 },
			{
				muzzle_pos				= {4.904,  0.239, 0.242},
				muzzle_pos_connector	= "Gun_point_01",
				supply_position			= {4.8753, 0,  0.2},	-- approx
				drop_cartridge 			= 204,		-- cartridge_50cal
				ejector_pos_connector	= "ejector_2",
				ejector_dir 			= {-2,0,0},
				effects = {
					{name = "FireEffect", arg = 433,duration = 0.02, attenuation = 2 , light_pos = {0.5,0,0}},
					{name = "SmokeEffect"},
				},
				smoke_dir = {0, 3, 10},
				gas_deflector = true,
			}
		)			-- RIGHT
	},
	
	ammo_type ={_("HEI High Explosive Incendiary"),
				_("CM Combat Mix"),
				_("AP Armor Piercing"),
				_("TP Target Practice"),
	},

        Sensors = {
            RADAR = "N-019M",
            IRST = "KOLS",
            RWR = "Abstract RWR"
        },
		
        Countermeasures = {
            ECM = "Gardenia"
        },

		Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'ecm',  	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		},
		
	HumanRadio = {
		frequency = 124.0,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},
	mapclasskey = "P0091000024",

        LandRWCategories = 
        {
            [1] = 
            {
                Name = "AircraftCarrier",
            }, -- end of [1]
        }, -- end of LandRWCategories
        MaxFuelWeight = "2046",
        MaxHeight = "18000",
        MaxSpeed = "1700",
        MaxTakeOffWeight = "11187",
        Picture = "F-5e.png",
        Rate = "50",
        Shape = "F-5e",
        TakeOffRWCategories = 
        {
            [1] = 
            {
                Name = "AircraftCarrier With Catapult",
            }, -- end of [1]
			[2] = 
            {
				Name = "AircraftCarrier With Tramplin",
            }, -- end of [2]
        }, -- end of TakeOffRWCategories
        WingSpan = "8.53",
        WorldID = F_5E3,
	
	-- Countermeasures, 
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 60,
		-- MJU-13/A - 30 cartridges per magazine
		chaff = {default = 30, increment = 30, chargeSz = 1},
		-- MJU-14/A - 15 cartridges per magazine
		flare = {default = 15, increment = 15, chargeSz = 2}
	},

	chaff_flare_dispenser = 
	{
		[1] = 
		{
			dir = 	{0, -1, 0},
			pos = 	{-1.3,	-0.506,	-0.496},
		}, -- end of [1]
	}, -- end of chaff_flare_dispenser

	DamageParts 	= 	{
		[1] = "f-5e3_oblomok_wing_l",
		[2] = "f-5e3_oblomok_wing_r",
	},
		
	DefaultTask =   aircraft_task(CAP),
	Tasks 		= 
	{
        aircraft_task(CAS),
        aircraft_task(GroundAttack),
        aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
        --aircraft_task(GAI),
        aircraft_task(AFAC),
        aircraft_task(Reconnaissance),
	},-- end of Tasks
	
	Damage = 
	{
		[0] = 
		{
			args = 	{146},
			critical_damage	=	5,
			deps_cells = 	{83},
		},-- end of [0]
		[3] = 
		{
			args = 	{65},
			critical_damage	=	10,
		},-- end of [3]
		[4] = 
		{
			args = 	{150},
			critical_damage	=	5,
		},-- end of [4]
		[5] = 
		{
			args = 	{147},
			critical_damage	=	5,
		},-- end of [5]
		[7] = 
		{
			args = 	{249},
			critical_damage	=	2,
		},-- end of [7]
		[9] = 
		{
			args = 	{154},
			critical_damage	=	3,
		},-- end of [9]
		[10] = 
		{
			args = 	{153},
			critical_damage	=	3,
		},-- end of [10]
		[23] = 
		{
			args = 	{223},
			critical_damage	=	3,
		},-- end of [23]
		[24] = 
		{
			args = 	{213},
			critical_damage	=	3,
		},-- end of [24]
		[25] = 
		{
			args = 	{226},
			critical_damage	=	3,
		},-- end of [25]
		[26] = 
		{
			args = 	{216},
			critical_damage	=	3,
		},-- end of [26]
		[29] = 
		{
			args = 	{224},
			critical_damage	=	10,
			deps_cells = 	{23,	25},
		},-- end of [29]
		[30] = 
		{
			args = 	{214},
			critical_damage	=	10,
			deps_cells = 	{24,	26},
		},-- end of [30]
		[35] = 
		{
			args = 	{225},
			critical_damage	=	10,
			deps_cells = 	{29,	37,	84},
		},-- end of [35]
		[36] = 
		{
			args = 	{215},
			critical_damage	=	10,
			deps_cells = 	{30,	38,	85},
		},-- end of [36]
		[37] = 
		{
			args = 	{229},
			critical_damage	=	3,
		},-- end of [37]
		[38] = 
		{
			args = 	{217},
			critical_damage	=	3,
		},-- end of [38]
		[40] = 
		{
			args = 	{241},
			critical_damage	=	10,
			deps_cells = 	{54},
		},-- end of [40]
		[45] = 
		{
			args = 	{235},
			critical_damage	=	7,
			deps_cells = 	{51},
		},-- end of [45]
		[46] = 
		{
			args = 	{233},
			critical_damage	=	7,
			deps_cells = 	{52},
		},-- end of [46]
		[51] = 
		{
			args = 	{239},
			critical_damage	=	3,
		},-- end of [51]
		[52] = 
		{
			args = 	{237},
			critical_damage	=	3,
		},-- end of [52]
		[54] = 
		{
			args = 	{247},
			critical_damage	=	3,
		},-- end of [54]
		[55] = 
		{
			args = 	{81},
			critical_damage	=	20,
			deps_cells = 	{40,	45,	46},
		},-- end of [55]
		[59] = 
		{
			args = 	{148},
			critical_damage	=	3,
		},-- end of [59]
		[82] = 
		{
			args = 	{152},
			critical_damage	=	4,
		},-- end of [82]
		[83] = 
		{
			args = 	{134},
			critical_damage	=	5,
		},-- end of [83]
		[84] = 
		{
			args = 	{136},
			critical_damage	=	5,
		},-- end of [84]
		[85] = 
		{
			args = 	{135},
			critical_damage	=	5,
		},-- end of [85]
	},-- end of Damage

	DamageParts 	=
 	{
			[1] = "f-5e_oblomok_wing_l",
			[2] = "f-5e_oblomok_wing_r",
	},

	SFM_Data =
	{
		aerodynamics =
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.75,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.0268,
			cx_flap	=	0.05,
			cy_flap	=	0.52,
			cx_brk	=	0.06,
			table_data = 
			{
				[1] = 	{0,	0.017,	0.07,	0.1,	0.0001,	0.5,	30,	1.2},
				[2] = 	{0.2,	0.017,	0.07,	0.1,	0.0001,	1.5,	30,	1.2},
				[3] = 	{0.4,	0.017,	0.07,	0.1,	0.0001,	2.5,	30,	1.2},
				[4] = 	{0.6,	0.017,	0.073,	0.1,	0.0001,	3.5,	30,	1.2},
				[5] = 	{0.7,	0.017,	0.076,	0.1,	0.0001,	3.5,	28.666666666667,	1.18},
				[6] = 	{0.8,	0.017,	0.079,	0.1,	0.0001,	3.5,	27.333333333333,	1.16},
				[7] = 	{0.9,	0.02,	0.083,	0.14,	0.0001,	3.5,	26,	1.14},
				[8] = 	{1,	0.03,	0.085,	0.16,	0.0001,	3.5,	24.666666666667,	1.12},
				[9] = 	{1.05,	0.036,	0.0855,	0.18,	0.0001,	3.5,	24,	1.11},
				[10] = 	{1.1,	0.042,	0.086,	0.2,	0.0001,	3.15,	18,	1.1},
				[11] = 	{1.2,	0.043,	0.083,	0.23,	0.0001,	2.45,	17,	1.05},
				[12] = 	{1.3,	0.042,	0.077,	0.25,	0.0001,	1.75,	16,	1},
				[13] = 	{1.5,	0.04,	0.062,	0.3,	0.0001,	1.5,	13,	0.9},
				[14] = 	{1.7,	0.036666666666667,	0.051333333333333,	0.348,	0.0001,	0.9,	12,	0.7},
				[15] = 	{1.8,	0.035,	0.046,	0.372,	0.0001,	0.86,	11.4,	0.64},
				[16] = 	{2,	0.032,	0.039,	0.42,	9.9999999999999e-006,	0.78,	10.2,	0.52},
				[17] = 	{2.2,	0.032,	0.034,	0.458,	1e-005,	0.7,	9,	0.4},
				[18] = 	{2.5,	0.03,	0.033,	0.515,	1e-005,	0.7,	9,	0.4},
				[19] = 	{3,	0.03,	0.033,	0.61,	1e-005,	0.7,	9,	0.4},
				[20] = 	{3.9,	0.03,	0.033,	0.61,	1e-005,	0.7,	9,	0.4},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine =
		{
			Nmg	=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			typeng	=	1,
			hMaxEng	=	19,
			dcx_eng	=	0.0144,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	1650,
			dpdh_f	=	2950,
			table_data = 
			{
				[1] = 	{0,	28311.1,	44492},
				[2] = 	{0.2,	26133.3,	41016.1},
				[3] = 	{0.4,	25044.4,	39800},
				[4] = 	{0.6,	24500,	40600},
				[5] = 	{0.7,	24500,	41500},
				[6] = 	{0.8,	24500,	42700},
				[7] = 	{0.9,	25044.4,	45200},
				[8] = 	{1,	25316.7,	49400},
				[9] = 	{1.1,	25588.9,	54500},
				[10] = 	{1.2,	26133.3,	56500},
				[11] = 	{1.3,	26677.8,	58200},
				[12] = 	{1.5,	28311.1,	62400},
				[13] = 	{1.8,	30488.9,	62000},
				[14] = 	{2,	31577.8,	56500},
				[15] = 	{2.2,	31033.3,	55700},
				[16] = 	{2.5,	29944.4,	53000},
				[17] = 	{3,	27222.2,	55000},
			}, -- end of table_data
		}, -- end of engine
	},-- end of SFM_Data

	engines_nozzles =
	{
		[1] =
		{
			pos = 	{-6.922,	-0.084,	-0.226},
			elevation			=	0.5,
			azimuth				=	-2.08,
			diameter			=	0.5,
			exhaust_length_ab	=	4.5,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.3, 
		}, -- end of [1]
		[2] =
		{
			pos 				= 	{-6.922,	-0.084,	0.226},
			elevation			=	0.5,
			azimuth				=	2.08,
			diameter			=	0.5,
			exhaust_length_ab	=	4.5,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.3, 
		}, -- end of [2]
	}, -- end of engines_nozzles
	fires_pos =
	{
		[1] = 	{-1.801,	-0.633,	0},
		[2] = 	{-1.161,	-0.311,	0.91},
		[3] = 	{-1.161,	-0.311,	-0.91},
		[4] = 	{-0.82,	0.265,	2.774},
		[5] = 	{-0.82,	0.265,	-2.774},
		[6] = 	{-0.82,	0.255,	4.274},
		[7] = 	{-0.82,	0.255,	-4.274},
		[8] = 	{-5.922,	-0.084,	0.226},
		[9] = 	{-5.922,	-0.084,	-0.226},
		[10] = 	{-0.088,	0.55,	0},
		[11] = 	{-0.023,	-0.61,	0},
	}, -- end of fires_pos

	lights_data =
	{
		typename =	"collection",
		lights 	 = 
		{
			[1]				= {
					typename	=	"collection",
					lights = {	{typename = "natostrobelight", argument_1 = 192, period = 1.2, phase_shift = 0, connector = "BANO_022",color = {0.8,0,0}},	-- beacon light right
								{typename = "natostrobelight", argument_1 = 192, period = 1.2, phase_shift = 0, connector = "BANO_021",color = {0.8,0,0}},	-- beacon light left
					},
			},--must be collection
			[2]				= {
					typename = "collection",
					lights = {	{typename  = "spotlight",	connector = "MAIN_SPOT_L",	argument  = 208},			-- left ldg & taxi
								{typename  = "spotlight",	connector = "MAIN_SPOT_R",	argument  = 209},			-- right ldg & taxi
								{typename  = "argumentlight",	argument  = 51,	 speed  = 1.0},
					},
			},--must be collection
			[3]			= {
					typename = "collection",
					lights = {	{typename  = "collection",
								 lights    = {	{typename  = "argumentlight", argument  = 191},		-- wings
												{typename  = "argumentlight", argument  = 193}		-- tail
											},	},
								{typename  = "argumentlight",	argument  = 194},		-- inlet
								{typename  = "argumentlight",	argument  = 196},		-- fuselage
					},
			},--must be collection
			[4]	= {
					typename = "collection",
					lights = {	{typename  = "argumentlight",	argument  = 88},		-- cockpit
								{typename  = "argumentlight",	argument  = 190},		-- tips
					},
			},--must be collection
			[5]			= {},--must be collection
		}, -- end of lights
	},-- end of lights_data
	
	Countries = {"USA","Turkey","Norway","Israel","Georgia",},	
}

add_aircraft(F_5E3)