
MIG29M =  {
      
		Name 			= 'MIG29M',--AG
		DisplayName		= _('MiG-29M AI'),--AG
        Picture 		= "MIG29M.png",
        Rate 			= "50",
        Shape			= "MIG29M",--AG	
        WorldID			=  50, 
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'MIG29M';--AG
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'f-4e-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; 			-- Fire on the ground after destoyed: 300sec 2m
			username	= 'MIG29M';--AG
			index       =  50;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "f-4e-oblomok";
			file  		= "f-4e-oblomok";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, 50, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	13380,	-- kg  with pilot and nose load, F15
		M_nominal					=	17380,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	26500,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	4000,	-- kg (Internal Fuel Only)
		H_max						=	16500,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.19,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	220,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	65,		-- Take off speed in m/s (for AI)
		V_land						=	75,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,
		input_profile_entry = 	"MIG29M",

		nose_gear_pos 				                = {2.917, -1.644, 0},   -- nosegear coord 
	    nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	    nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	    nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	    nose_gear_wheel_diameter 	                =  0.57, -- in m
	
	    main_gear_pos 						 	    = {-0.68, -1.525, 1.55}, -- main gear coords 
	    main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	    main_gear_amortizer_reversal_stroke  	    =   0, --  up 
	    main_gear_amortizer_normal_weight_stroke    =   0,-- down from main_gear_pos
	    main_gear_wheel_diameter 				    =   0.84, -- in m

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	12,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	403,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	38.2,	-- wing area in m2
		thrust_sum_max				=	10147,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	16652,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	2.2,	-- Max speed in Mach (for AI)
		range						=	2240,	-- Max range in km (for AI)
		RCS							=	3,		-- Radar Cross Section m2 (def 3)
		Ny_max_e					=	8,		-- Max G (for AI)
		detection_range_max			=	200,
		IR_emission_coeff			=	0.71,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	3,		-- With afterburner
		tand_gear_max				=	3.73,--XX  1.732 FA18 3.73, 
		tanker_type					=	0,--F14=2/S33=4/ M29=0/S27=0/F15=1/ F16=1/To=0/F18=2/A10A=1/ M29K=4/F4=0/
		wing_span					=	11.4,--XX  wing spain in m
		wing_type 					= 	1,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	20.32,
		height						=	4.73,
		crew_size					=	1, --XX
		engines_count				=	2, --XX
		wing_tip_pos 				= 	{-3.8, 0.14, 5.8},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
        },
        FoldableWings = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
        },
		ServiceHatches = {--Parkposition
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        LaunchBar = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.881, "in", 4.4}}}}},
            {Transition = {"Retract", "Stage"},  Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.815, "in", 4.4}}}}},
			{Transition = {"Any", "Retract"},  Sequence = {{C = {{"ChangeDriveTo", "Hydraulic"}, {"VelType", 2}, {"Arg", 85, "to", 0.000, "in", 4.5}}}}},
            {Transition = {"Extend", "Stage"},   Sequence = {
                    {C = {{"ChangeDriveTo", "Mechanical"}, {"Sleep", "for", 0.000}}},
                    {C = {{"Arg", 85, "from", 0.881, "to", 0.766, "in", 0.600}}},
                    {C = {{"Arg", 85, "from", 0.766, "to", 0.753, "in", 0.300}}},
                    {C = {{"Sleep", "for", 0.45}}},
                    {C = {{"Arg", 85, "from", 0.753, "to", 0.784, "in", 0.1, "sign", 2}}},
                    {C = {{"Arg", 85, "from", 0.784, "to", 0.881, "in", 1.0}}},
                },
            },
			{Transition = {"Stage", "Pull"},  Sequence = {
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85,"from", 0.881, "to", launch_bar_connected_arg_value_, "in", 0.15}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.78, "speed", 0.1}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.7792, "speed", 0.02}}},
					}
			},
            {Transition = {"Stage", "Extend"},   Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "from", 0.815, "to", 0.881, "in", 0.2}}}}},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-5.534, -0.063, -0.909},
				elevation	=	-2.8,--3.7
				diameter	=	0.945,--0.965
				exhaust_length_ab	=	7.5,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				afterburner_effect_texture = "afterburner_f-16c",
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-5.534, -0.063, 0.909},
				elevation	=	-2.8,--3.7
				diameter	=	0.945,--0.965
				exhaust_length_ab	=	7.5,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				afterburner_effect_texture = "afterburner_f-16c",
			}, -- end of [2]
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	41,
				pos = 	{4.403, 1.209, 0},
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	0,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{0,	0,	0},
		fires_pos = 
		{
			[1] = 	{-0.664,	-0.496,	0},
			[2] = 	{0.173,	-0.307,	1.511},
			[3] = 	{0.173,	-0.307,	-1.511},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-3.899,	-0.212,	0.611},
			[9] = 	{-3.899,	-0.212,	-0.611},
			[10] = 	{-0.896,	1.118,	0},
			[11] = 	{0.445,	-0.436,	0},
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/MIG29M_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0, 0.999, 0.052},
				pos = 	{-0.937, 1.645, -1.726},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0, 0.999, -0.052},
				pos = 	{-0.937, 1.645, 1.726},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 96,
chaff 				= {default = 48, increment = 12, chargeSz = 1},
flare 				= {default = 48, increment = 12, chargeSz = 1}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 	= "KLJ-7",--JF17
OPTIC = "OLS-27",--Su27
RWR 	= "Abstract RWR"--F15
},
laserEquipment = {
		laserDesignator = true,
		laserRangefinder = true
	},
Countermeasures = {
ECM 			= "AN/ALQ-135"--F15
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 124.1,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns = {gun_mount("M_61", { count = 480 },{muzzle_pos = {5.435, 0.268, -0.559}}),--3.906000, 0.768000, -0.975000
},

pylons_enumeration = {1, 7, 2, 6, 3, 5, 4},

	Pylons =     {

        pylon(1, 0, -1.671, -0.121, -3.927,
            {
                arg = 308,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
                { CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
                { CLSID = "{mig29m-r771}", attach_point_position = {0.1, 0, 0} }, --R771
                { CLSID = "{mig29m-r73m}", attach_point_position = {0.1, 0, 0} }, --R73M
            }
        ),
		pylon(2, 0, -1.09, -0.097, -3.245,
            {
                arg = 309,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
                { CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
                { CLSID = "{mig29m-r771}", attach_point_position = {0.1, 0, 0} }, --R771
                { CLSID = "{mig29m-r73m}", attach_point_position = {0.1, 0, 0} }, --R73M
                { CLSID = "{FAB_250_M62}", attach_point_position = {0.3, -0.15, 0} }, --FAB250
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", attach_point_position = {0.3, -0.2, 0} }, --FAB500
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {0.4, -0.02, 0} }, --BETAB500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {0.3, -0.15, 0} }, --BETAB500-SMP
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {0.3, -0.2, 0} }, --RBK500-255
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {0.3, -0.15, 0} }, --RBK250
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", attach_point_position = {0.12, -0.25, 0} }, --B8M1
                { CLSID = "{S_25_O}", attach_point_position = {0.5, 0, 0} }, --S25O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.5, 0, 0} }, --S25OFM
                --{ CLSID = "{KAB_500S_LOADOUT}", attach_point_position = {0.08, 0, 0} }, --KAB500S
                { CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.02, 0, 0} }, --KAB500Kr
                { CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.02, 0, 0} }, --KAB500L
            }
        ),
        pylon(3, 0, -0.553, -0.122, -2.44,
            {
                arg = 310,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
                { CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", attach_point_position = {0.1, -0.1, 0} }, --R27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", attach_point_position = {0.1, -0.1, 0} }, --R27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", attach_point_position = {0.1, -0.1, 0} }, --R27ER
                { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", attach_point_position = {0.1, -0.1, 0} }, --R27ET
                { CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.1, 0} }, --R77
                { CLSID = "{mig29m-r771}", attach_point_position = {0.1, 0, 0} }, --R771
                { CLSID = "{mig29m-r73m}", attach_point_position = {0.1, 0, 0} }, --R73M
                { CLSID = "{FAB_250_M62}", attach_point_position = {0.3, -0.15, 0} }, --FAB250
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", attach_point_position = {0.3, -0.2, 0} }, --FAB500
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {0.4, -0.02, 0} }, --BETAB500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {0.3, -0.15, 0} }, --BETAB500-SMP
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {0.3, -0.2, 0} }, --RBK500-255
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {0.3, -0.15, 0} }, --RBK250
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", attach_point_position = {0.12, -0.25, 0} }, --B8M1
                { CLSID = "{S_25_O}", attach_point_position = {0.5, 0, 0} }, --S25O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.5, 0, 0} }, --S25OFM
                { CLSID = "{X-29L}", attach_point_position = {0.02, 0, 0} }, --Kh29L
                { CLSID = "{X-29T}", attach_point_position = {0.02, 0, 0} }, --Kh29T
                { CLSID = "{X-31A}", attach_point_position = {0.02, 0, 0} }, --Kh31A
                { CLSID = "{X-31P}", attach_point_position = {0.02, 0, 0} }, --Kh31P
                { CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.02, 0, 0} }, --KAB500Kr
                { CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.02, 0, 0} }, --KAB500L
                --{ CLSID = "{KAB_500S_LOADOUT}", attach_point_position = {0.08, 0, 0} }, --KAB500S
            }
        ),
        pylon(4, 0, -0.783, -0.15, 0,
            {
            },
            {
                { CLSID = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}" }, --Fuel_1400L
            }
        ),
        pylon(5, 0, -0.553, -0.122, 2.44,
            {
                arg = 312,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
                { CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}", attach_point_position = {0.1, -0.1, 0} }, --R27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}", attach_point_position = {0.1, -0.1, 0} }, --R27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", attach_point_position = {0.1, -0.1, 0} }, --R27ER
                { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", attach_point_position = {0.1, -0.1, 0} }, --R27ET
                { CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.1, 0} }, --R77
                { CLSID = "{mig29m-r771}", attach_point_position = {0.1, 0, 0} }, --R771
                { CLSID = "{mig29m-r73m}", attach_point_position = {0.1, 0, 0} }, --R73M
                { CLSID = "{FAB_250_M62}", attach_point_position = {0.3, -0.15, 0} }, --FAB250
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", attach_point_position = {0.3, -0.2, 0} }, --FAB500
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {0.4, -0.02, 0} }, --BETAB500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {0.3, -0.15, 0} }, --BETAB500-SMP
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {0.3, -0.2, 0} }, --RBK500-255
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {0.3, -0.15, 0} }, --RBK250
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", attach_point_position = {0.12, -0.25, 0} }, --B8M1
                { CLSID = "{S_25_O}", attach_point_position = {0.5, 0, 0} }, --S25O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.5, 0, 0} }, --S25OFM
                { CLSID = "{X-29L}", attach_point_position = {0.02, 0, 0} }, --Kh29L
                { CLSID = "{X-29T}", attach_point_position = {0.02, 0, 0} }, --Kh29T
                { CLSID = "{X-31A}", attach_point_position = {0.02, 0, 0} }, --Kh31A
                { CLSID = "{X-31P}", attach_point_position = {0.02, 0, 0} }, --Kh31P
                { CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.02, 0, 0} }, --KAB500Kr
                { CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.02, 0, 0} }, --KAB500L
                --{ CLSID = "{KAB_500S_LOADOUT}", attach_point_position = {0.08, 0, 0} }, --KAB500S
            }
        ),
        pylon(6, 0, -1.09, -0.097, 3.245,
            {
                arg = 313,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
                { CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
                { CLSID = "{mig29m-r771}", attach_point_position = {0.1, 0, 0} }, --R771
                { CLSID = "{mig29m-r73m}", attach_point_position = {0.1, 0, 0} }, --R73M
                { CLSID = "{FAB_250_M62}", attach_point_position = {0.3, -0.15, 0} }, --FAB250
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", attach_point_position = {0.3, -0.2, 0} }, --FAB500
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {0.4, -0.02, 0} }, --BETAB500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {0.3, -0.15, 0} }, --BETAB500-SMP
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {0.3, -0.2, 0} }, --RBK500-255
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {0.3, -0.15, 0} }, --RBK250
                { CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", attach_point_position = {0.12, -0.25, 0} }, --B8M1
                { CLSID = "{S_25_O}", attach_point_position = {0.5, 0, 0} }, --S25O
                { CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", attach_point_position = {0.5, 0, 0} }, --S25OFM
                --{ CLSID = "{KAB_500S_LOADOUT}", attach_point_position = {0.08, 0, 0} }, --KAB500S
                { CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", attach_point_position = {0.02, 0, 0} }, --KAB500Kr
                { CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}", attach_point_position = {0.02, 0, 0} }, --KAB500L
            }
        ),
        pylon(7, 0, -1.671, -0.121, 3.927,
            {
                arg = 314,
                arg_value = 0,
                use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", attach_point_position = {0.1, -0.05, 0} }, --R73
                { CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", attach_point_position = {0.1, 0.15, 0} }, --R77
                { CLSID = "{mig29m-r771}", attach_point_position = {0.1, 0, 0} }, --R771
                { CLSID = "{mig29m-r73m}", attach_point_position = {0.1, 0, 0} }, --R73M
            }
        ),
},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
      	aircraft_task(Intercept),
      	aircraft_task(Reconnaissance),
    	aircraft_task(GroundAttack),
     	aircraft_task(CAS),
        aircraft_task(AFAC),
        aircraft_task(RunwayAttack),
        aircraft_task(SEAD),
        aircraft_task(PinpointStrike),
        aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
	aerodynamics = --F15
		{
			Cy0	=	0,
			Mzalfa	=	4.35,
			Mzalfadt	=	0.8,
			kjx = 2.75,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.032,
			cx_flap = 0.035,
			cy_flap = 0.24,
			cx_brk = 0.06,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0, 0.024, 0.07, 0.075, 0.12, 0.5, 30, 1.2 }, { 0.2, 0.024, 0.07, 0.075, 0.12, 1.5, 30, 1.2 }, { 0.4, 0.024, 0.07, 0.075, 0.12, 2.5, 30, 1.2 }, { 0.6, 0.0239, 0.073, 0.075, 0.12, 3.5, 30, 1.2 }, { 0.7, 0.024, 0.076, 0.075, 0.12, 3.5, 28.666666666667, 1.18 }, { 0.8, 0.0235, 0.079, 0.075, 0.12, 3.5, 27.333333333333, 1.16 }, { 0.9, 0.025, 0.083, 0.075, 0.125, 3.5, 26, 1.14 }, { 1, 0.044, 0.085, 0.14, 0.1, 3.5, 24.666666666667, 1.12 }, { 1.05, 0.0465, 0.0855, 0.1775, 0.125, 3.5, 24, 1.11 }, { 1.1, 0.049, 0.086, 0.215, 0.15, 3.15, 18, 1.1 }, { 1.2, 0.049, 0.083, 0.228, 0.17, 2.45, 17, 1.05 }, { 1.3, 0.049, 0.077, 0.237, 0.2, 1.75, 16, 1 }, { 1.5, 0.0475, 0.062, 0.251, 0.2, 1.5, 13, 0.9 }, { 1.7, 0.045166666666667, 0.051333333333333, 0.24366666666667, 0.32, 0.9, 12, 0.7 }, { 1.8, 0.044, 0.046, 0.24, 0.38, 0.86, 11.4, 0.64 }, { 2, 0.043, 0.039, 0.222, 2.5, 0.78, 10.2, 0.52 }, { 2.2, 0.041, 0.034, 0.227, 3.2, 0.7, 9, 0.4 }, { 2.5, 0.04, 0.033, 0.25, 4.5, 0.7, 9, 0.4 }, { 3.9, 0.035, 0.033, 0.35, 6, 0.7, 9, 0.4 },
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	71,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19,
			dcx_eng	=	0.0144,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	6500,
			dpdh_f	=	12500.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0, 88000, 141000 }, { 0.2, 80000, 143000 }, { 0.4, 79000, 150000 }, { 0.6, 82000, 165000 }, { 0.7, 90000, 177000 }, { 0.8, 94000, 193000 }, { 0.9, 96000, 200000 }, { 1, 100000, 205000 }, { 1.1, 100000, 214000 }, { 1.2, 98000, 222000 }, { 1.3, 100000, 235000 }, { 1.5, 98000, 258000 }, { 1.8, 94000, 276000 }, { 2, 88000, 283000 }, { 2.2, 82000, 285000 }, { 2.5, 80000, 287000 }, { 3.9, 50000, 200000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 8, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 6, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 6, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
	DamageParts = 
	{  
		[1] = "MIG-29C-OBLOMOK-WING-R", -- wing R
		[2] = "MIG-29C-OBLOMOK-WING-L", -- wing L
--		[3] = "f-4e-oblomok-noise", -- nose
--		[4] = "f-4e-oblomok-tail-r", -- tail
--		[5] = "f-4e-oblomok-tail-l", -- tail
	},
	
	lights_data = { typename = "collection", lights = {
		
	    [WOLALIGHT_NAVLIGHTS] = {
         typename = "argumentlight",
         argument = 190, },

        [WOLALIGHT_SPOTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_P_27_600,
                        },
                    },
                },
            }
        },
        [WOLALIGHT_TAXI_LIGHTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_R_27_180,},
                        },
                    },
                },
            }
        },
	},
}

add_aircraft(MIG29M) --AG
