
local mig29m_r771_name = 'R-77-1 (AA-12 Adder B) - Active Rdr'
local mig29m_r771_mass = 185.0
local pylon_mass = 10.0

local mig29m_r771_warhead = enhanced_a2a_warhead(9, 178)

local mig29m_r771_AA = {
    category        = CAT_AIR_TO_AIR,
    name            = mig29m_r771_name,
    model           = 'r-77',
    user_name       = _(mig29m_r771_name),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    mass            = mig29m_r771_mass,

	Escort 			= 0,
    Head_Type 		= 2,
	sigma 			= {5, 5, 5},
    M 				= mig29m_r771_mass,
    H_max 			= 20000.0,
    H_min 			= 1.0,
    Diam			= 178.0,
    Cx_pil 			= 2.5,
    D_max 			= 20000.0,
    D_min 			= 700.0,
    Head_Form 		= 1,
    Life_Time 		= 98.0,
    Nr_max 			= 30,
    v_min 			= 140.0,
    v_mid 			= 700.0,
    Mach_max 		= 4.0,
    t_b 			= 0.0,
    t_acc 			= 5.0,
    t_marsh 		= 9.0,
    Range_max 		= 80000.0,
    H_min_t 		= 1.0,
    Fi_start 		= 0.5,
    Fi_rak 			= 3.14152,
    Fi_excort 		= 1.05,
    Fi_search 		= 1.05,
    OmViz_max 		= 0.52,
    exhaust 		= {0.8, 0.8, 0.8, 0.05 };
    X_back 			= -1.25,
    Y_back 			= -0.1,
    Z_back 			= 0.005,
    Reflection 		= 0.04,
    KillDistance 	= 15.0,
    display_name_short = "R-77-1",
	loft 			= 1,
	hoj 			= 1,
	ccm_k0 			= 0.15,
	loft_factor 	= 2.0,

	active_radar_lock_dist	= 18000.0,
	go_active_by_default	= 1,
	
	PN_coeffs = {3, 				-- Number of Entries	
				15000.0 ,1.0,		-- Less 5 km to target Pn = 1
				25000.0, 0.5,		-- Between 10 and 5 km  to target, Pn smoothly changes from 0.5 to 1.0. 
				40000.0, 0.25};		-- Between 15 and 10 km  to target, Pn smoothly changes from 0.2 to 0.5. Longer then 15 km Pn = 0.2.

    warhead         = mig29m_r771_warhead,
    warhead_air     = mig29m_r771_warhead,

    shape_table_data = {
        {
            name     = mig29m_r771_name,
            file     = 'r-77',
            life     = 1,
            fire     = {0, 1},
            username = "771",		--Shortened name for cockpit displays
            index    = WSTYPE_PLACEHOLDER,
        },
    },

	ModelData = {   58 ,  -- model params count
					0.4 ,   -- characteristic square (характеристическая площадь)
					
					-- параметры зависимости Сx
					0.029 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
					0.06 , -- Cx_k1 высота пика волнового кризиса
					0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
					-0.245, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
					0.08 , -- Cx_k4 крутизна спада за волновым кризисом 
					0.7 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
					
					-- параметры зависимости Cy
					1.4 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
					0.6	 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
					1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
					
					0.4 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
					0.0, --угловая скорость создаваймая моментом газовых рулей
					
				-- Engine data. Time, fuel flow, thrust.	
				--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
					-1.0,		-1.0,	5.0,  		9.0,		30.0,			0.0,		1.0e9,         -- time of stage, sec
					 0.0,		0.0,	4.5,		4.5,		0.4,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
					 0.0,		0.0,	14000.0,	7220.0,		1000.0,			0.0,		0.0,           -- thrust, newtons
				
					 97, -- таймер самоликвидации, сек
					 98.0, -- время работы энергосистемы, сек
					 0, -- абсолютная высота самоликвидации, м
					 1.0, -- время задержки включения управления (маневр отлета, безопасности), сек
					 25000, --40000 -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
					 15000, --40000 -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
					 0.52356,--0.17, -- синус угла возвышения траектории набора горки
					 50.0, -- продольное ускорения взведения взрывателя
					 0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
					 1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
					 1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
					 2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

					  -- DLZ. Данные для рассчета дальностей пуска (индикация на прицеле)
					 21.0, -- производная дальности по скорости носителя на высоте 1км, ППС
					 -23.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
					 -3.0, -- производная по высоте производной дальности по скорости цели, ЗПС
					 47500, 
					 13500, 
					 72000,
					 25500, 
					 29000, 
					 7800, 
					 4000, 
					 0.4,
					 -0.015,
					 0.5,
    },
}

declare_weapon(mig29m_r771_AA)

declare_loadout({
	category		=	CAT_AIR_TO_AIR,
	CLSID			= 	"{mig29m-r771}",
	Picture			=	"r77.png",
	wsTypeOfWeapon	=	mig29m_r771_AA.wsTypeOfWeapon,
	displayName		=	_(mig29m_r771_name),
	attribute		=	{4,	4,	32, WSTYPE_PLACEHOLDER},
	Count			=	1,
	Weight			=	mig29m_r771_mass + pylon_mass,
	Elements		=	
	{
		{
		
			ShapeName	=	"r-77",
			Position	=	{0,	0,	0}
		},
	}, 			
})