
local mig29m_r73m_name = 'R-73M (AA-11 Archer) - Infra Red'
local mig29m_r73m_mass = 109.0
local pylon_mass = 1.0

local mig29m_r73m_warhead = enhanced_a2a_warhead(11, 178)

local MIG29M_R73M_AA = {
    category        = CAT_AIR_TO_AIR,
    name            = mig29m_r73m_name,
    model           = 'r-73',
    user_name       = _(mig29m_r73m_name),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    mass            = mig29m_r73m_mass,

    Escort          = 0,
    Head_Type       = 1,
    sigma           = {5, 5, 5},
    M               = mig29m_r73m_mass,
    H_max           = 20000.0,
    H_min           = 1.0,
    Diam            = 178.0,
    Cx_pil          = 2.2,
    D_max           = 4000.0,
    D_min           = 300.0,
    Head_Form       = 1,
    Life_Time       = 30.0,
    Nr_max          = 30,
    v_min           = 140.0,
    v_mid           = 400.0,
    Mach_max        = 3.5,
    t_b             = 0.0,
    t_acc           = 2.0,
    t_marsh         = 3.0,
    Range_max       = 26000.0,
    H_min_t         = 1.0,
    Fi_start        = 0.8,
    Fi_rak          = 3.14152,
    Fi_excort       = 1.25,
    Fi_search       = 0.05,
    OmViz_max       = 1.05,
    exhaust         = { 0.9, 0.9, 0.9, 0.05 };
	X_back          = -1.5,
    Y_back          = 0.0,
    Z_back          = 0.0,
    Reflection      = 0.04,
    KillDistance    = 5.0,
    display_name_short = "R-73M",
	Loft			= 1,
	Hoj 			= 1,
	ccm_k0 			= 0.2,
	loft_factor 	= 0.9,	

	SeekerSensivityDistance = 30000,
	SeekerCooled = true,

	PN_coeffs = {3, 				-- Number of Entries	
				15000.0 ,1.0,		-- Less 5 km to target Pn = 1
				25000.0, 0.5,		-- Between 10 and 5 km  to target, Pn smoothly changes from 0.5 to 1.0. 
				40000.0, 0.25};		-- Between 15 and 10 km  to target, Pn smoothly changes from 0.2 to 0.5. Longer then 15 km Pn = 0.2.

    warhead         = mig29m_r73m_warhead,
    warhead_air     = mig29m_r73m_warhead,

    shape_table_data = {
        {
            name     = mig29m_r73m_name,
            file     = 'r-73',
            life     = 1,
            fire     = {0, 1},
            username = "73M",		--Shortened name for cockpit displays
            index    = WSTYPE_PLACEHOLDER,
        },
    },

    proximity_fuze = {
        radius      = 10.0,
        arm_delay   = 1.2,
    },   

    ModelData = {
        58 ,  -- model params count
        0.5 ,   -- characteristic square (характеристическая площадь) -- 9

        -- параметры зависимости Сx
        0.046 , -- планка Сx0 на дозвуке ( M << 1) cx_k0
        0.093 , -- высота пика волнового кризиса cx_k1
        0.02 , -- крутизна фронта на подходе к волновому кризису cx_k2
        -0.445 , -- планка Cx0 на сверхзвуке ( M >> 1) cx_k3
        0.145  , -- крутизна спада за волновым кризисом cx_k4
        0.7  , -- коэффициент отвала поляры

        -- параметры зависимости Cy
        1.0 , -- планка Сy0 на дозвуке ( M << 1)
        0.4 , -- планка Cy0 на сверхзвуке ( M >> 1)
        0.8 , -- крутизна спада(фронта) за волновым кризисом

        0.5 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
        0.00, --угловая скорость создаваймая моментом газовых рулей

        --    t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
        -1.0,   -1.0,       2.0,     2.0,      24.0,          0.0,      30.0,           -- time interval
        0.0,    0.0,       9.69,     8.94,      -5.0,          0.0,        0.0,           -- fuel flow rate in second kg/sec(секундный расход массы топлива кг/сек)
        0.0,    0.0,   19800.0,  19645.0,      -2500.0,          0.0,        0.0,           -- thrust

        29, -- таймер самоликвидации, сек  Self-destructive time, sec
        80.0, -- время работы энергосистемы, сек  Working time of power system, sec
        0, -- абсолютная высота самоликвидации, м  Absolute height of self-destruction, M
        1.0, -- время задержки включения управления (маневр отлета, безопасности), сек  Connection delay time (shunting departure, safety), sec
        25000, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр 'горка', м
        15000, -- дальность до цели, при которой маневр 'горка' завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м
        0.52356,  -- синус угла возвышения траектории набора горки
        50.0, -- продольное ускорения взведения взрывателя  Longitudinal acceleration of fuze arming
        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
        1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
        1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
        2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

        -- DLZ. Данные для рассчета дальностей пуска (индикация на прицеле)
		21.0, 
		-23.0, 
		-3.0, 
		18750.0, 
		7600.0, 
		22400.0,
		9700.0, 
		14500.0, 
		3850.0, 
		2500.0, 
		0.4, 
		-0.015, 
		0.5,
    },
}

declare_weapon(MIG29M_R73M_AA)

declare_loadout({
    category    = CAT_AIR_TO_AIR,
    CLSID       = "{mig29m-r73m}",
    Picture     = 'r73.png',
    wsTypeOfWeapon   = MIG29M_R73M_AA.wsTypeOfWeapon,
    displayName = _(mig29m_r73m_name),
	attribute	=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
    Count       = 1,
    Weight      = mig29m_r73m_mass + pylon_mass,
    Elements    = 
	{
		{
		
			ShapeName	=	"r-73",
			Position	=	{0,	0,	0}
		},
	}, 	
})