--
-- file prepared:  2025 18:29:59.214, using fd653a
--
--SFM_characteristics.lua (file 2 for assembly)

hawker_hunter = {

	Name = 'hawker_hunter',

	DisplayName = _('hawker_hunter'),
	ViewSettings = ViewSettings,
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada","China",
			 "Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France","Georgia",
			 "German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents","Iran",
			 "Iraq","Israel","Italy","Japan","Kazakhstan","NASA","North Korea","Norway",
			 "Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia","South Korea",
			 "South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey","UK",
			 "Ukraine","USA","USAF Aggressors","USSR","Vietnam"},

	HumanCockpit = false,
	HumanCockpitPath = current_mod_path..'/Cockpit/',
	Picture = "hawker_hunter.png",
	Rate = 50,
	Shape = "hawker_hunter",

	shape_table_data =
	{
		{
			file = 'hawker_hunter';
			life = 20;
			vis = 3;
			fire = { 300, 2};
			username = 'hawker_hunter';
			index = WSTYPE_PLACEHOLDER;
		},
	},
	------------------------ -
	mapclasskey = "P0091000024",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink", "Link16"},
	Categories = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	---------	General	Characteristics	---------
	length = 13.983,
	height = 4.01,
	wing_area = 32.4,
	wing_span = 10.26,
	wing_tip_pos = { -2.5, 0.6, 5.2},
	RCS = 3.3,											-- (estimated from height, length and wing surface area)
	air_refuel_receptacle_pos = { 5, 0.75, 1},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 6406,
	M_nominal = 8051,
	M_max = 11158,
	M_fuel_max = 3200,
	H_max = 15240,										-- (calculated from service_ceiling)
	CAS_min = 56,
	average_fuel_consumption = 1,						-- default

	----------_ AI Flight Parameters -----------
	V_opt = 226,
	V_take_off = 58,
	V_land = 58,
	V_max_sea_level = 149,
	V_max_h = 167,
	Vy_max = 87,
	Mach_max = 0.944,
	Ny_min = -3,										-- default
	Ny_max = 8,											-- default
	Ny_max_e = 8,										-- default
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 60,								-- default
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 4, -0.5, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { 0, -0.5, 2},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = false,
	thrust_sum_max = 4604.8,
	thrust_sum_ab = 4604.8,
	engines_count = 1,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy",
			canopy_pos = {4, 0.45, 0},
			canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {4, -0.5, 0},
		}, --end of[1]
		--[2] =
		--{
			--ejection_seat_name = 9,
			--drop_canopy_name = "aircraft_canopy_2",
			--canopy_pos = {4, 0.45, 0},
			--canopy_ejection_dir = {0.0, 0.5, 0.5},
			--pos = {4, -0.5, 0},
			--canopy_arg = 421,
		--}, --end of[2]
	}, --end of crew_members

---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {-6.25, 0.75, 0},
			elevation = 0.75,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.125,
		}, -- end of [1]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
		ADEN({ muzzle_pos = {4, 0.2, 0.4},_connector =  "Point_Gun_01",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		ADEN({ muzzle_pos = {4.05, 0.3, 0.5},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		ADEN({ muzzle_pos = {4.05, 0.3, -0.5},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		ADEN({ muzzle_pos = {4, 0.2, -0.4},_connector =  "Point_Gun_04",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, 0.5, 0.85, 3, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
			} 
		),
		pylon(4, 0, 0.5, 0.875, 2, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
			} 
		),
		pylon(5, 0, 0.5, 0.875, -2, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
			} 
		),
		pylon(6, 0, 0.5, 0.85, -3, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
				{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" }, --AIM-9M
				{ CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" }, --AIM-9P
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
				{ CLSID = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}" }, --MK-83 
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},

	chaff_flare_dispenser =
	{
		[1] =
		{
			dir = {0, 1, 0},
			pos = {-4.75, 0.625, 0.75},
		}, --end of[1]
	}, --end of chaff_flare_dispenser

	--Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 144,
		chaff = {default = 72, increment = 3, chargeSz = 1},
		flare = {default = 72, increment = 3, chargeSz = 1}
	},


---------------------------------------------------------------------------------------------------------------------------------------------


	fires_pos =
	{
		[1] = { -1.5625, 0.6, 0.0},
		[2] = { -0.625, 0.6, 0.5},
		[3] = { -0.9375, 0.6, -0.5},
		[4] = { 0.5, 0.6, 1.3},
		[5] = { 0.5, 0.6, -1.3},
		[6] = { 0.5, 0.6, 4.16},
		[7] = { 0.5, 0.6, -4.16},
		[8] = { -6.25, 0.75, 0.5},
		[9] = { -6.25, 0.75, -0.5},
		[10] = { -3.125, 0.6, 0.5},
		[11] = { -3.125, 0.6, -0.5},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------


--(file 3 for aessembly)

	--[[
	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	]]--

	--[[

	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		-- PPR-26
		chaff = {default = 64, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 64, increment = 3, chargeSz = 1}
	},
	]]--

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	
	--[[
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},
	]]--

	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(CAP),

	--SFM_aerodynamics.lua (file 4 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.0426,	0.0559,	0.00829,	2.3,	12.8,	0.545,		},
				{0.1,	0.015,	0.0385,	0.0559,	0.00829,	6.25,	14.1,	0.545,		},
				{0.2,	0.015,	0.0477,	0.0559,	0.00829,	6.25,	15.6,	0.745,		},
				{0.3,	0.015,	0.0893,	0.0559,	0.00829,	6.25,	17.3,	1.4,		},
				{0.4,	0.015,	0.131,	0.0559,	0.00829,	6.25,	19.1,	2,		},
				{0.5,	0.015,	0.105,	0.0531,	0.0123,	6.25,	19.1,	2,		},
				{0.6,	0.015,	0.0881,	0.0487,	0.0159,	6.25,	19.1,	1.72,		},
				{0.7,	0.015,	0.0768,	0.0433,	0.0186,	6.25,	19.1,	1.5,		},
				{0.8,	0.0213,	0.0593,	0.0396,	0.0286,	2.3,	19.1,	1.16,		},
				{0.9,	0.035,	0.03,	0.00172,	0.00124,	2.01,	19.1,	1,		},
				{1,		0.0428,	0.03,	0.00181,	0.00131,	1.76,	18.2,	0.951,		},
				{1.1,	0.0575,	0.03,	0.0019,	0.00137,	1.54,	17.3,	0.905,		},
				{1.2,	0.0675,	0.03,	0.002,	0.00144,	1.35,	16.4,	0.861,		},
				{1.3,	0.0775,	0.03,	0.0021,	0.00151,	1.18,	15.6,	0.819,		},
			}, --end of table_data
		}, --end of aerodynamics
		engine = 
		{
			Nmg = 50,					-- default
			MinRUD = 0,
			MaxRUD = 1,
			MaksRUD  = 1,
			ForsRUD  = 1,
			typeng  = 0,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,
			dpdh_f = 2000,

			--[[			table_data = {
				--M 	Pmax	Pafb
				{0,	20383,	20383,		},
				{0.2,	30574,	30574,		},
				{0.4,	40766,	40766,		},
				{0.6,	40766,	40766,		},
				{0.8,	40766,	40766,		},
				{1,	40766,	40766,		},
				{1.2,	40766,	40766,		},
				{1.4,	40766,	40766,		},
				{1.6,	40766,	40766,		},
				{1.8,	40766,	40766,		},
				{2,	30574,	30574,		},
				{2.2,	20383,	20383,		},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				32 k ft		0.m		adj:+/-
				33 k ft		0.m		adj:+/-
				41 k ft		0.m		adj:+/-
				46 k ft		0.m		adj:+/-
				50 k ft		0.m		adj:+/-
				52 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9753, 10241, 12546, 14114, 15369, 16075 }, 
					thrust = {
						{ 22572,  33858,  45145,  45145,  45145,  45145,  45145,  45145,  45145,  45145,  45145,  45145  }, 
						{ 20392,  30588,  40784,  40784,  40784,  40784,  40784,  40784,  40784,  40784,  40784,  40784  }, 
						{ 15362,  23044,  30725,  30725,  30725,  30725,  30725,  30725,  30725,  30725,  30725,  30725  }, 
						{ 12925,  19387,  25850,  25850,  25850,  25850,  25850,  25850,  25850,  25850,  25850,  25850  }, 
						{ 8974,   13462,  17949,  17949,  17949,  17949,  17949,  17949,  17949,  17949,  17949,  17949  }, 
						{ 8464,   12697,  16929,  16929,  16929,  16929,  16929,  16929,  16929,  16929,  16929,  16929  }, 
						{ 7453,   11180,  14906,  14906,  14906,  14906,  14906,  14906,  14906,  14906,  14906,  14906  }, 
						{ 902,    1354,   1805,   1805,   1805,   1805,   1805,   1805,   1805,   1805,   1805,   1805   }, 
					}, -- thrust = {

				}, --thrust_max = {

				thrust_afterburner  = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9753, 10241, 12546, 14114, 15369, 16075 }, 
					thrust = {
						{ 22572,  33858,  45145,  45145,  45145,  45145,  45145,  45145,  45145,  45145,  45145,  45145  }, 
						{ 20392,  30588,  40784,  40784,  40784,  40784,  40784,  40784,  40784,  40784,  40784,  40784  }, 
						{ 15362,  23044,  30725,  30725,  30725,  30725,  30725,  30725,  30725,  30725,  30725,  30725  }, 
						{ 12925,  19387,  25850,  25850,  25850,  25850,  25850,  25850,  25850,  25850,  25850,  25850  }, 
						{ 8974,   13462,  17949,  17949,  17949,  17949,  17949,  17949,  17949,  17949,  17949,  17949  }, 
						{ 8464,   12697,  16929,  16929,  16929,  16929,  16929,  16929,  16929,  16929,  16929,  16929  }, 
						{ 7453,   11180,  14906,  14906,  14906,  14906,  14906,  14906,  14906,  14906,  14906,  14906  }, 
						{ 902,    1354,   1805,   1805,   1805,   1805,   1805,   1805,   1805,   1805,   1805,   1805   }, 
					}, -- thrust = {

				}, --thrust_afterburner = {

			}, -- extended = {

		}, --end of engine

	},

	DamageParts =
	{
		[1] = "hawker_hunter-collision",
	},

	-- (file 5 for aessembly)

	-- new
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		[0]		= {critical_damage = 5, args = {146}},
		[3]		= {critical_damage = 20,args = {65}}  ,
		[4]		= {critical_damage = 20, args = {150}},
		[5]		= {critical_damage = 20, args = {147}},
		[7]		= {critical_damage = 4, args = {249}} ,
		[9]		= {critical_damage = 3, args = {154}},
		[10]	= {critical_damage = 3, args = {153}},
		[11]	= {critical_damage = 3, args = {167}},
		[12]	= {critical_damage = 3, args = {161}},
		[15]	= {critical_damage = 5, args = {267}},
		[16]	= {critical_damage = 5, args = {266}},
		[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
		[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
		[25]	= {critical_damage = 3, args = {226}},
		[26]	= {critical_damage = 3, args = {216}},
		[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
		[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
		[31]	= {critical_damage = 4, args = {229}},
		[32]	= {critical_damage = 4, args = {219}},
		[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
		[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
		[37]	= {critical_damage = 4, args = {227}},
		[38]	= {critical_damage = 4, args = {217}},
		[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
		[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
		[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
		[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
		[51]	= {critical_damage = 3, args = {239}},
		[52]	= {critical_damage = 3, args = {237}},
		[53]	= {critical_damage = 3, args = {248}},
		[54]	= {critical_damage = 3, args = {247}},
		[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
		[59]	= {critical_damage = 5, args = {148}},
		[60]	= {critical_damage = 1, args = {144}},

		[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
		[84]	= {critical_damage = 3, args = {136}}, -- left wheel
		[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},


	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},  --SolveTriangles


}



--SFM_add.lua (file 6 for assembly)

add_aircraft(hawker_hunter)


