--
--
------------------------------------------------------------------------------------------------------- 
-- Miguel Fichier Revision M33.d
------------------------------------------------------------------------------------------------------- 
-- Miguel21 modification M33.d VOR + NDB Custom Briefing (d: Divert)

--[[ db_airbases Entry Example ----------------------------------------------------------------------------
	--FOR TF CAMPAIGNS
	--example for an air base
	['Kerman Airbase'] = {
		x =	454116.78125,
		y = 71096.058594,
		elevation = 1751,
		airdromeId = 18,
		ATC_frequency = "250.300",
		--startup = 300,							-- (secondes) Timing for take-off, generally used for small runways to give time for all aircraft to gather together
		side = "red",								-- side : Required information for the divert
		divert = true,								-- divert : Required information for the divert)
		--VOR = "112.00",							-- optional information
		--NDB = "",									-- optional information
		--TACAN = "97X",							-- TACAN : optional information
		--ILS = "RWY 30R/111.95 RWY 12L/108.55",	-- ILS : optional information
		LimitedParkNb = 3,							-- number of parking spaces available
	},
	--example for an airplane carrier
	['CVN-71 Theodore Roosevelt'] = {                            
		unitname = "CVN-71 Theodore Roosevelt",
		startup = 300,								-- (secondes) Timing for take-off, generally used for small runways to give time for all aircraft to gather together
		ATC_frequency = "255.500",					-- Optional information, if absent, the base_mission frequency will be used.
	},	
	--example for a FARP
	['As Salamah FARP'] = {
		x =	-74348.375716192,
		y = -67705.331836707,
		elevation = 0,
		airdromeId = 837,							--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 837,
		ATC_frequency = "128.600",
		side = "blue",								-- side : Required information for the divert
		divert = false,								-- divert : Required information for the divert)
	},	
	--example for a Virtual Base
	['Reserves'] = {								--dummy airbase to place virtual reserves
		inactive = true,
		x =	9999999999,								--position far away will make all range checks negative
		y = 9999999999,
		elevation = 0,
		airdromeId = nil,							--no id makes sure that no static aircraft are to be placed at this air base
		ATC_frequency = "0",
	},

]]-----------------------------------------------------------------------------------------------------



db_airbases = {
	['Anapa-Vityazevo'] = {
		ATC_frequency = {250.00, 121.00, 38.4, 3.75},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 92,
		LimitedSmallParkNb = '',
		airdromeId = 12,
		NDB = '443.00 215.00',
		code = {
			ICAO = 'URKA',
		},
		divert = false,
		elevation = 43,			
		parkAlertSAR = {
			{
				["y"] = 242676.82634304,
                ["x"] = -5676.7727009153,
			},
			{
				["y"] = 242750.25006327,
                ["x"] = -5589.133300887,
			},			
			{
				["y"] = 242831.52410969,
                ["x"] = -5498.6235673726,
			},
			{
				["y"] = 242970.05941609,
                ["x"] = -5352.6997112985,
			},
			{
				["y"] = 243055.02773735,
                ["x"] = -5254.8014281095,
			},
			{
				["y"] = 243134.45464635,
                ["x"] = -5158.7502823392,
			},
			{
				["y"] = 243219.42296761,
                ["x"] = -5064.5462739875,
			},
			{
				["y"] = 243304.39128887,
                ["x"] = -4972.1894030545,
			},
		},
		runways = {
			{
				hdg = 221,
				true_hdg = true,
				length = 2700,
				name = '04-22',
				x =	-4447.7905273438,
				y = 244021.984375,
			},
		},
		side = 'red',
		startup = 800,
		x =	-4447.7905273438,
		y = 244021.984375,
	},
	['Batumi'] = {
		ATC_frequency = {260.00, 131.00, 40.4, 4.25},
		ILS = 'RNW 120 : 110.30 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 10,
		LimitedSmallParkNb = '',
		airdromeId = 22,
		NDB = '430',
		TACAN = '16X',	
		code = {
			ICAO = 'UGSB',
		},
		divert = false,
		elevation = 43,
		parkAlertSAR = {
			{
				["y"] = 617669.44470758,
                ["x"] = -355872.6514812,
			},
			{
				["y"] = 617820.37678931,
                ["x"] = -355984.70711764,
			},			
			{
				["y"] = 617539.09427335,
                ["x"] = -355769.74324365,
			},
			{
				["y"] = 618046.77491192,
                ["x"] = -356153.93399716,
			},			
			{
				["y"] = 617742.62389872,
                ["x"] = -355925.24902484,
			},
			{
				["y"] = 617902.70337935,
                ["x"] = -356039.591511,
			},			
			{
				["y"] = 617971.30887105,
                ["x"] = -356092.18905464,
			},
			{
				["y"] = 617600.83921588,
                ["x"] = -355822.34078729,
			},
		},
		runways = {
			{
				hdg = 305.5,
				true_hdg = true,
				length = 2250,
				name = '13-31',
				x =	-356437.15625,
				y = 618210.875,
			},
		},
		side = 'red',
		startup = 800,
		x =	-356437.15625,
		y = 618210.875,
	},	
	['Beslan'] = {
		ATC_frequency = {270.00, 141.00, 42.4, 4.75},
		ILS = 'RNW 086 : 110.50 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 15,
		LimitedSmallParkNb = '',
		airdromeId = 32,
		NDB = '1050.00 250.00',
		code = {
			ICAO = 'URMO',
		},
		divert = false,
		elevation = 525,		
		parkAlertSAR = {
			{
				["y"] = 843621.16086842,
                ["x"] = -148685.84349908,
			},
			{
				["y"] = 843720.78808281,
                ["x"] = -148691.79139247,
			},			
			{
				["y"] = 843804.05859036,
                ["x"] = -148657.59100544,
			},
			{
				["y"] = 843802.57161701,
                ["x"] = -148769.11400663,
			},
			{
				["y"] = 843937.88619179,
                ["x"] = -148670.97376558,
			},			
			{
				["y"] = 843931.93829839,
                ["x"] = -148782.49676677,
			},
			{
				["y"] = 844070.22681986,
                ["x"] = -148679.89560568,
			},			
			{
				["y"] = 844071.71379321,
                ["x"] = -148786.95768682,
			},
		},
		runways = {
			{
				hdg = 093.5,--101,--86--266
				true_hdg = true,
				length = 2900,
				name = '10-28',
				x =	-148472.40625,
				y = 842251.75,
			},
		},
		side = 'red',
		startup = 800,
		x =	-148472.40625,
		y = 842251.75,
	},
	['Gelendzhik'] = {
		ATC_frequency = {255.00, 126.00, 39.4, 4.00},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 13,
		LimitedSmallParkNb = '',
		airdromeId = 17,
		NDB = '1000',
		VOR = '114.3',
		code = {
			ICAO = 'URKG',
		},
		divert = false,
		elevation = 22,
		parkAlertSAR = {
			{
				["y"] = 298065.88510741,
                ["x"] = -50687.096152999,
			},
			{
				["y"] = 298132.06923438,
                ["x"] = -50606.434248257,
			},			
			{
				["y"] = 298192.04859944,
                ["x"] = -50534.045359387,
			},
			{
				["y"] = 298252.02796451,
                ["x"] = -50463.724724483,
			},
			{
				["y"] = 298316.14383751,
                ["x"] = -50391.335835613,
			},
			{
				["y"] = 298380.25971051,
                ["x"] = -50312.742184839,
			},
			{
				["y"] = 298448.51209144,
                ["x"] = -50227.943772161,
			},
			{
				["y"] = 298518.83272634,
                ["x"] = -50145.213613452,
			},
		},
		runways = {
			{
				hdg = 040, --032,
				true_hdg = true,
				length = 1600,
				name = '01-19',
				x =	-50995.6328125,
				y = 297848.84375,
			},
		},
		side = 'red',
		startup = 800,
		x =	-50995.6328125,
		y = 297848.84375,
	},	
	['Gudauta'] = {
		ATC_frequency = {259.00, 130.00, 40.2, 4.2},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 31,
		LimitedSmallParkNb = '',
		airdromeId = 31,
		NDB = '395',
		code = {
			ICAO = 'UG23',
		},
		divert = false,
		elevation = 21,		
		parkAlertSAR = {
			{
				["y"] = 516319.76977576,
                ["x"] = -197495.72418873,
			},
			{
				["y"] = 516597.39598666,
                ["x"] = -197647.49318402,
			},			
			{
				["y"] = 515982.91663987,
                ["x"] = -196118.69818267,
			},
			{
				["y"] = 515823.42448296,
                ["x"] = -195761.16103741,
			},
			{
				["y"] = 515913.47874121,
                ["x"] = -195956.7266281,
			},
			{
				["y"] = 516728.80572649,
                ["x"] = -197710.42179183,
			},
			{
				["y"] = 515866.43547198,
                ["x"] = -195851.21529567,
			},
			{
				["y"] = 516451.17951559,
                ["x"] = -197571.60868638,
			},
		},
		runways = {
			{
				hdg = 151,--144,--324
				true_hdg = true,
				length = 2300,
				name = '15-33',
				x =	-195650.515625,
				y = 515898.75,
			},
		},
		side = 'red',
		startup = 800,
		x =	-195650.515625,
		y = 515898.75,
	},
	['Kobuleti'] = {
		ATC_frequency = {262.00, 133.00, 40.8, 4.35},
		ILS = 'RNW 063 : 111.50 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 42,
		LimitedSmallParkNb = '',
		airdromeId = 24,
		NDB = '870.00 490.00',
		TACAN = '67X',
		code = {
			ICAO = 'UG5X',
		},
		divert = false,
		elevation = 18,		
		parkAlertSAR = {
			{
				["y"] = 636720.64244444,
                ["x"] = -317664.79003164,
			},
			{
				["y"] = 636664.12918287,
                ["x"] = -317682.15651235,
			},			
			{
				["y"] = 636603.84625676,
                ["x"] = -317704.02384829,
			},
			{
				["y"] = 636512.83085852,
                ["x"] = -317737.71136582,
			},
			{
				["y"] = 634989.19485326,
                ["x"] = -318279.08227214,
			},			
			{
				["y"] = 635065.07465778,
                ["x"] = -318255.47522185,
			},
			{
				["y"] = 635154.44420532,
                ["x"] = -318226.80951792,
			},			
			{
				["y"] = 635247.18618862,
                ["x"] = -318199.83003187,
			},
		},
		runways = {
			{
				hdg = 250,--243,--063
				true_hdg = true,
				length = 2250,
				name = '07-25',
				x =	-317604.90625,
				y = 636704.125,
			},
		},
		side = 'red',
		startup = 800,
		x =	-317604.90625,
		y = 636704.125,
	},	
	['Krasnodar-Center'] = {
		ATC_frequency = {251.00, 122.00, 38.6, 3.8},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 56,
		LimitedSmallParkNb = '',
		airdromeId = 13,
		NDB = '625.00 303.00',
		code = {
			ICAO = 'URKL',
		},
		divert = false,
		elevation = 30,		
		parkAlertSAR = {
			{
				["y"] = 367274.17557538,
                ["x"] = 11400.121999384,
			},
			{
				["y"] = 367478.30168244,
                ["x"] = 11416.131890133,
			},			
			{
				["y"] = 367690.43273486,
                ["x"] = 11424.136835508,
			},
			{
				["y"] = 367874.54647848,
                ["x"] = 11440.146726257,
			},
			{
				["y"] = 368042.65033135,
                ["x"] = 11460.159089694,
			},
			{
				["y"] = 368230.76654765,
                ["x"] = 11464.161562381,
			},
			{
				["y"] = 368398.87040052,
                ["x"] = 11480.17145313,
			},
			{
				["y"] = 368558.96930801,
                ["x"] = 11496.181343879,
			},
		},
		runways = {
			{
				hdg = 087,--079,--259
				true_hdg = true,
				length = 2300,
				name = '09-27',
				x =	11652.913085938,
				y = 366766.3125,
			},
		},
		side = 'red',
		startup = 800,
		x =	11652.913085938,
		y = 366766.3125,
	},
	['Krasnodar-Pashkovsky'] = {
		ATC_frequency = {257.00, 128.00, 39.8, 4.1},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 19,
		LimitedSmallParkNb = '',
		airdromeId = 19,
		NDB = '493.00 240.00',
		VOR = '115.8',
		code = {
			ICAO = 'URKK',
		},
		divert = false,
		elevation = 34,		
		parkAlertSAR = {
			{
				["y"] = 386783.79763081,
                ["x"] = 6798.8126331949,
			},
			{
				["y"] = 386857.75248518,
                ["x"] = 6863.2144386069,
			},			
			{
				["y"] = 386923.80987658,
                ["x"] = 6928.4356605013,
			},
			{
				["y"] = 386984.85025092,
                ["x"] = 6984.4590177696,
			},
			{
				["y"] = 387057.59699842,
                ["x"] = 7084.7993591456,
			},
			{
				["y"] = 387200.58198488,
                ["x"] = 7213.5694639115,
			},
			{
				["y"] = 387262.45852873,
                ["x"] = 7273.7736687371,
			},
			{
				["y"] = 387314.30103844,
                ["x"] = 7326.4523479595,
			},
		},
		runways = {
			{
				hdg = 227, --219,--039
				true_hdg = true,
				length = 2900,
				name = '05-23',
				x =	8706.8193359375,
				y = 388985.71875,
			},
		},
		side = 'red',
		startup = 800,
		x =	8706.8193359375,
		y = 388985.71875,
	},
	['Krymsk'] = {
		ATC_frequency = {253.00, 124.00, 39.0, 3.9},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 57,
		LimitedSmallParkNb = '',
		airdromeId = 15,
		NDB = '408.00 803.00',
		code = {
			ICAO = 'URKW',
		},
		divert = false,
		elevation = 20,		
		parkAlertSAR = {
			{
				["y"] = 294181.3987619,
                ["x"] = -7004.6426834157,
			},
			{
				["y"] = 294280.16778406,
                ["x"] = -6868.8352779501,
			},			
			{
				["y"] = 294373.99835511,
                ["x"] = -6755.2509024698,
			},
			{
				["y"] = 294475.23660282,
                ["x"] = -6624.3819481121,
			},
			{
				["y"] = 294583.88252719,
                ["x"] = -6510.7975726318,
			},
			{
				["y"] = 294682.65154935,
                ["x"] = -6392.2747460437,
			},
			{
				["y"] = 294774.01289485,
                ["x"] = -6288.567272779,
			},
			{
				["y"] = 294941.92023251,
                ["x"] = -6231.7750850389,
			},
		},
		runways = {
			{
				hdg = 039,--032,--212
				true_hdg = true,
				length = 2400,
				name = '04-22',
				x =	-7349.0327148438,
				y = 293711.96875,
			},
		},
		side = 'red',
		startup = 800,
		x =	-7349.0327148438,
		y = 293711.96875,
	},
	['Kutaisi'] = {
		ATC_frequency = {263.00, 134.00, 41.0, 4.4},
		ILS = 'RNW 068 : 109.75 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 58,
		LimitedSmallParkNb = '',
		airdromeId = 25,
		NDB = '477.00',
		TACAN = '44X',
		VOR = '113.6',
		code = {
			ICAO = 'UGKO',
		},
		divert = false,
		elevation = 45,		
		parkAlertSAR = {
			{
				["y"] = 683998.53455045,
                ["x"] = -284704.857027,
			},
			{
				["y"] = 683548.47291933,
                ["x"] = -284851.8623752,
			},			
			{
				["y"] = 683279.10931008,
                ["x"] = -284927.12573661,
			},
			{
				["y"] = 684311.13494061,
                ["x"] = -284615.54262981,
			},
			{
				["y"] = 683846.96766876,
                ["x"] = -284755.24959268,
			},			
			{
				["y"] = 683405.86865561,
                ["x"] = -284891.47467068,
			},
			{
				["y"] = 684158.02454543,
                ["x"] = -284660.19982841,
			},			
			{
				["y"] = 684609.28418267,
                ["x"] = -284543.86491994,
			},
		},
		runways = {
			{
				hdg = 254, --247,
				true_hdg = true,
				length = 2300,
				name = '07-25',
				x =	-284582.8125,
				y = 685029.625,
			},
		},
		side = 'red',
		startup = 800,
		x =	-284582.8125,
		y = 685029.625,
	},
	['Maykop-Khanskaya'] = {
		ATC_frequency = {254.00, 125.00, 39.2, 3.95},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 57,
		LimitedSmallParkNb = '',
		airdromeId = 16,
		NDB = '289.00 591.00',
		code = {
			ICAO = 'URKH',
		},
		divert = false,
		elevation = 180,
		parkAlertSAR = {
			{
				["y"] = 457660.5074932,
                ["x"] = -27118.897954197,
			},
			{
				["y"] = 457774.4871358,
                ["x"] = -26991.145986872,
			},			
			{
				["y"] = 457872.41851412,
                ["x"] = -26867.601786528,
			},
			{
				["y"] = 457961.3100729,
                ["x"] = -26753.097405721,
			},
			{
				["y"] = 458166.21264908,
                ["x"] = -26509.022278211,
			},
			{
				["y"] = 458264.29469106,
                ["x"] = -26369.959720993,
			},
			{
				["y"] = 458345.45548944,
                ["x"] = -26482.913392927,
			},
			{
				["y"] = 458006.74687415,
                ["x"] = -26908.100803611,
			},
		},
		runways = {
			{
				hdg = 039, --031,--211
				true_hdg = true,
				length = 3050,
				name = '04-22',
				x =	-27625.943359375,
				y = 457047.6875,
			},
		},
		side = 'red',
		startup = 800,
		x =	-27625.943359375,
		y = 457047.6875,
	},
	['Mineralnye-Vody'] = {
		ATC_frequency = {264.00, 135.00, 41.2, 4.45},
		ILS = 'RNW 109 : 109.75 || RNW 289 : 109.30 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 28,
		LimitedSmallParkNb = '',
		airdromeId = 26,
		NDB = '583.00 283.00',
		VOR = '117.1',
		code = {
			ICAO = 'URMM',
		},
		divert = false,
		elevation = 320,
		parkAlertSAR = {
			{
				["y"] = 705010.02517975,
                ["x"] = -51074.665776991,
			},
			{
				["y"] = 705191.18644287,
                ["x"] = -51170.27866586,
			},			
			{
				["y"] = 705372.34770599,
                ["x"] = -51255.827040112,
			},
			{
				["y"] = 705568.60574104,
                ["x"] = -51346.407671672,
			},
			{
				["y"] = 705890.67020881,
                ["x"] = -51507.439905557,
			},
			{
				["y"] = 706102.02501578,
                ["x"] = -51603.052794426,
			},
			{
				["y"] = 706273.12176428,
                ["x"] = -51683.568911369,
			},
			{
				["y"] = 706504.60560049,
                ["x"] = -51754.020513694,
			},
		},
		runways = {
			{
				hdg = 295.5, --288,--108
				true_hdg = true,
				length = 3850,
				name = '12-30',
				x =	-52064,
				y = 707369,
			},
		},
		side = 'red',
		startup = 800,
		x =	-51251.551717591,
		y = 705718.47981263,
	},
	['Mozdok'] = {
		ATC_frequency = {266.00, 137.00, 41.6, 4.55},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 39,
		LimitedSmallParkNb = '',
		airdromeId = 28,
		NDB = '525.00 1065.00',
		code = {
			ICAO = 'XRMF',
		},
		divert = false,
		elevation = 155,		
		parkAlertSAR = {
			{
				["y"] = 833906.98106162,
                ["x"] = -83878.218209969,
			},
			{
				["y"] = 834060.24970301,
                ["x"] = -83857.580831159,
			},			
			{
				["y"] = 834229.56410996,
                ["x"] = -83833.042511312,
			},
			{
				["y"] = 834410.79872597,
                ["x"] = -83807.157150827,
			},
			{
				["y"] = 834623.5899095,
                ["x"] = -83776.075292558,
			},
			{
				["y"] = 834845.94474173,
                ["x"] = -83744.993434289,
			},
			{
				["y"] = 835030.6957255,
                ["x"] = -83682.443778272,
			},
			{
				["y"] = 835161.35935153,
                ["x"] = -83722.554472776,
			},
		},
		runways = {
			{
				hdg = 262.5, --255,--075
				true_hdg = true,
				length = 2850,
				name = '08-26',
				x =	-83329.7890625,
				y = 835634.6875,
			},
		},
		side = 'red',
		startup = 800,
		x =	-83329.7890625,
		y = 835634.6875,
	},
	['Nalchik'] = {
		ATC_frequency = {265.00, 136.00, 41.4, 4.5},
		ILS = 'RNW 228 : 110.5 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 14,
		LimitedSmallParkNb = '',
		airdromeId = 27,
		NDB = '718.00 350.00',
		code = {
			ICAO = 'URMN',
		},
		divert = false,
		elevation = 430,		
		parkAlertSAR = {
			{
				["y"] = 760184.09771698,
                ["x"] = -125205.81849879,
			},
			{
				["y"] = 760326.59877601,
                ["x"] = -125113.98448297,
			},			
			{
				["y"] = 760451.68303893,
                ["x"] = -125031.65053775,
			},
			{
				["y"] = 760570.43392146,
                ["x"] = -124957.23331804,
			},
			{
				["y"] = 760312.34867011,
                ["x"] = -125258.0688871,
			},
			{
				["y"] = 760410.51606633,
                ["x"] = -125186.81835758,
			},
			{
				["y"] = 760529.26694885,
                ["x"] = -125102.90106727,
			},
			{
				["y"] = 760625.85099997,
                ["x"] = -125034.81722795,
			},
		},
		runways = {
			{
				hdg = 055.2,--048,--228
				true_hdg = true,
				length = 2100,
				name = '06-24',
				x =	-125487.578125,
				y = 759560.125,
			},
		},
		side = 'red',
		startup = 800,
		x =	-125487.578125,
		y = 759560.125,
	},
	['Novorossiysk'] = {
		ATC_frequency = {252.00, 123.00, 38.8, 3.85},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 37,
		LimitedSmallParkNb = '',
		airdromeId = 14,
		code = {
			ICAO = 'URKN',
		},
		divert = false,
		elevation = 40,		
		parkAlertSAR = {
			{
				["y"] = 278701.45142128,
                ["x"] = -41439.214081369,
			},
			{
				["y"] = 278778.79069748,
                ["x"] = -41343.162547772,
			},			
			{
				["y"] = 278853.71534806,
                ["x"] = -41252.07767844,
			},
			{
				["y"] = 278912.47977988,
                ["x"] = -41169.807473882,
			},
			{
				["y"] = 278975.6515441,
                ["x"] = -41096.351934099,
			},
			{
				["y"] = 279095.69241711,
                ["x"] = -40961.287755875,
			},
			{
				["y"] = 279164.88933556,
                ["x"] = -40874.459378468,
			},
			{
				["y"] = 279227.40655992,
                ["x"] = -40804.017435523,
			},
		},
		runways = {
			{
				hdg = 222, --214,--034
				true_hdg = true,
				length = 1600,
				name = '04-22',
				x =	-40299.0234375,
				y = 279853.5,
			},
		},
		side = 'red',
		startup = 800,
		x =	-40299.0234375,
		y = 279853.5,
	},
	['Senaki-Kolkhi'] = {
		ATC_frequency = {261.00, 132.00, 40.6, 4.3},
		ILS = 'RNW 088 : 108.9 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 67,
		LimitedSmallParkNb = '',
		airdromeId = 23,
		NDB = '335.00 688.00',
		TACAN = '31X',
		code = {
			ICAO = 'UGKS',
		},
		divert = false,
		elevation = 13,		
		parkAlertSAR = {
			{
				["y"] = 646554.5103126,
                ["x"] = -281629.31951802,
			},
			{
				["y"] = 646652.33773427,
                ["x"] = -281635.21273619,
			},			
			{
				["y"] = 646753.70108684,
                ["x"] = -281641.10595436,
			},
			{
				["y"] = 646866.85087576,
                ["x"] = -281645.8205289,
			},
			{
				["y"] = 646974.1074465,
                ["x"] = -281654.07103434,
			},			
			{
				["y"] = 647088.43587906,
                ["x"] = -281663.50018342,
			},
			{
				["y"] = 647330.05782414,
                ["x"] = -281687.07305611,
			},			
			{
				["y"] = 647467.95912938,
                ["x"] = -281696.50220519,
			},
		},
		runways = {
			{
				hdg = 275,--268,
				true_hdg = true,
				length = 2250,
				name = '09-27',
				x =	-281903.125,
				y = 648379.125,
			},
		},
		side = 'red',
		startup = 800,
		x =	-281903.125,
		y = 648379.125,
	},
	['Sochi-Adler'] = {
		ATC_frequency = {256.00, 127.00, 39.6, 4.05},
		ILS = 'RNW 055 : 111.1 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 68,
		LimitedSmallParkNb = '',
		airdromeId = 18,
		NDB = '761.00',
		code = {
			ICAO = 'URSS',
		},
		divert = false,
		elevation = 30,		
		parkAlertSAR = {
			{
				["y"] = 461470.53209448,
                ["x"] = -164799.65646746,
			},
			{
				["y"] = 461606.82710553,
                ["x"] = -164723.93701688,
			},			
			{
				["y"] = 461758.26600669,
                ["x"] = -164650.74154798,
			},
			{
				["y"] = 461970.28046832,
                ["x"] = -164534.63839043,
			},
			{
				["y"] = 462086.38362588,
                ["x"] = -164476.58681165,
			},			
			{
				["y"] = 462207.53474681,
                ["x"] = -164408.43930612,
			},
			{
				["y"] = 462374.11753808,
                ["x"] = -164320.09994711,
			},			
			{
				["y"] = 462485.17273227,
                ["x"] = -164262.04836833,
			},
		},
		runways = {
			{
				hdg = 062,--055,--235
				true_hdg = true,
				length = 2950,
				name = '06-24',
				x =	-165163.28125,
				y = 460901.53125,
			},
		},
		side = 'red',
		startup = 800,
		x =	-165163.28125,
		y = 460901.53125,
	},
	['Soganlug'] = {
		ATC_frequency = {268.00, 139.00, 42.0, 4.65},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 05,
		LimitedSmallParkNb = '',
		airdromeId = 30,
		TACAN = '25X',
		code = {
			ICAO = 'UG24',
		},
		divert = false,
		elevation = 458,		
		parkAlertSAR = {
			{
				["y"] = 894500.87096054,
                ["x"] = -317128.83924058,
			},
			{
				["y"] = 894610.51095662,
                ["x"] = -317230.56707199,
			},			
			{
				["y"] = 894742.75713745,
                ["x"] = -317344.72830502,
			},
			{
				["y"] = 894877.26393676,
                ["x"] = -317467.93201194,
			},
			{
				["y"] = 895020.81320997,
                ["x"] = -317599.04788354,
			},			
			{
				["y"] = 895128.19258757,
                ["x"] = -317697.38478723,
			},
			{
				["y"] = 895249.3408149,
                ["x"] = -317816.67698767,
			},			
			{
				["y"] = 895347.95358703,
                ["x"] = -317901.96370952,
			},
		},
		runways = {
			{
				hdg = 312,--305,--125
				true_hdg = true,
				length = 1950,
				name = '14-32',
				x =	-318656.96875,
				y = 896274.9375,
			},
		},
		side = 'red',
		startup = 800,
		x =	-318656.96875,
		y = 896274.9375,
	},
	['Sukhumi-Babushara'] = {
		ATC_frequency = {258.00, 139.00, 40.0, 4.15},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 20,
		LimitedSmallParkNb = '',
		airdromeId = 20,
		NDB = '489.00 995.00',
		code = {
			ICAO = 'UGSS',
		},
		divert = false,
		elevation = 13,		
		parkAlertSAR = {
			{
				["y"] = 565345.39665733,
				["x"] = -220947.26636645,
			},
			{
				["y"] = 565464.06279509,
                ["x"] = -221011.09436479,
			},			
			{
				["y"] = 565780.95532206,
                ["x"] = -221169.76537475,
			},
			{
				["y"] = 565903.21740339,
                ["x"] = -221232.6943872,
			},
			{
				["y"] = 565225.38204073,
                ["x"] = -220890.63025525,
			},
			{
				["y"] = 565684.31433866,
                ["x"] = -221118.97267185,
			},
			{
				["y"] = 565583.17842579,
                ["x"] = -221065.93250421,
			},
			{
				["y"] = 565127.84207144,
                ["x"] = -220834.44363699,
			},
		},
		runways = {
			{
				hdg = 296.5,--289,
				true_hdg = true,
				length = 3450,
				name = '12-30',
				x =	-221381.6875,
				y = 565908.75,
			},
		},
		side = 'red',
		startup = 800,
		x =	-221381.6875,
		y = 565908.75,
	},
	['Tbilisi-Lochini'] = {
		ATC_frequency = {267.00, 138.00, 41.8, 4.6},
		ILS = 'RNW 121 : 110.3 || RNW 301 : 108.9 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 73,
		LimitedSmallParkNb = '',
		airdromeId = 29,
		NDB = '342.00 923.00 211.00 435.00',
		VOR = '113.7',
		TACAN = '25X',
		code = {
			ICAO = 'UGTB',
		},
		divert = false,
		elevation = 480,		
		parkAlertSAR = {
			{
				["y"] = 895841.51839731,
                ["x"] = -314942.92224964,
			},
			{
				["y"] = 895950.40108751,
                ["x"] = -315030.0284018,
			},			
			{
				["y"] = 896064.72791223,
                ["x"] = -315111.69041946,
			},
			{
				["y"] = 896181.7768042,
                ["x"] = -315198.79657162,
			},
			{
				["y"] = 896301.54776342,
                ["x"] = -315291.34685829,
			},			
			{
				["y"] = 896527.47934559,
                ["x"] = -315449.22675909,
			},
			{
				["y"] = 896695.28848785,
                ["x"] = -315566.47802177,
			},			
			{
				["y"] = 896884.21524845,
                ["x"] = -315708.17309223,
			},
		},
		runways = {
			{
				hdg = 128,--121,--301
				true_hdg = true,
				length = 2500,
				name = '13-31',
				x =	-314926.25,
				y = 895724,
			},
		},
		side = 'red',
		startup = 800,
		x =	-314926.25,
		y = 895724,
	},	
	['Vaziani'] = {
		ATC_frequency = {269.00, 140.00, 42.2, 4.7},
		ILS = 'RNW 135 : 108.75 || RNW 315 : 108.75 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 91,
		LimitedSmallParkNb = '',
		airdromeId = 31,
		TACAN = '22X',
		code = {
			ICAO = 'UG27',
		},
		divert = false,
		elevation = 465,		
		parkAlertSAR = {
			{
				["y"] = 902622.66468491,
                ["x"] = -318356.64853624,
			},
			{
				["y"] = 902728.74895163,
                ["x"] = -318466.66184987,
			},			
			{
				["y"] = 902830.90417144,
                ["x"] = -318572.74611659,
			},
			{
				["y"] = 902929.13034433,
                ["x"] = -318678.83038331,
			},
			{
				["y"] = 903263.09933215,
                ["x"] = -318993.15413656,
			},			
			{
				["y"] = 903349.5383643,
                ["x"] = -319095.30935636,
			},
			{
				["y"] = 903443.83549027,
                ["x"] = -319185.67743542,
			},			
			{
				["y"] = 903549.91975699,
                ["x"] = -319303.54884289,
			},
		},
		runways = {
			{
				hdg = 135.5,--129,--309
				true_hdg = true,
				length = 2300,
				name = '13-31',
				x =	-318191.71875,
				y = 902331.75,
			},
		},
		side = 'red',
		startup = 800,
		x =	-318191.71875,
		y = 902331.75,
	},
	['CVN-73 George Washington'] = {                            
		unitname = "CVN-73 George Washington",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		LimitedParkNb  = 9,
		divert = true,
	},
	['CVN-71 Theodore Roosevelt'] = {                            
		unitname = "CVN-71 Theodore Roosevelt",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		LimitedParkNb  = 9, 
		divert = true,
	},	
	['LHA_Tarawa'] = {
		unitname = "LHA_Tarawa",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		LimitedParkNb  = 4,
	},
	['Dyess AFB'] = {
		x = -298118.0120668,
		y = -89509.223854664, 
		elevation = 0,
		airdromeId = nil,
		ATC_frequency = "0",
		side = "blue",							-- side : info obligatoire
		BaseAirStart = true,
	},	
	['Reserves'] = {						--dummy airbase to place virtual reserves
		inactive = true,
		x =	9999999999,						--position far away will make all range checks negative
		y = 9999999999,
		elevation = 0,
		airdromeId = nil,					--no id makes sure that no static aircraft are to be placed at this air base
		ATC_frequency = "0",
	},
}
	