--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--
--Action.AddCampFlag(flag-n, number)														--
--Action.AddImage("filname.jpg")															--
--Action.CampaignEnd("win"/"draw"/"loss")													--
--Action.TargetActive("TargetName", boolean)												--
--Action.AirUnitActive("UnitName", boolean)													--
--Action.AirUnitBase("UnitName", "BaseName")												--
--Action.AirUnitPlayer("UnitName", boolean)													--
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--
--Action.AirUnitRepair()																	--
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--
--Action.GroupHidden("GroupName", boolean)													--
--Action.GroupProbability("GroupName", number 0-1)											--
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			'Action.Text("Georgia has been invaded by russian forces in few days despite courageous fight of poor trained Georgian ground forces. United Nations were not able to stop russians invasion and the United States of America decided to do something to convince Russia to remove its forces from Georgia. Turkish government was not ready to open his bases to US attack planes and only one Navy Task Force can be sent near Georgian coasts to show Russia they have to leave Georgian country.")',
			'Action.Text("The US Navy has sent considerable forces near Georgia. The Task Force 71 is leaded by the brand new CVN-71 Theodore Roosevelt. At the forefront are the F/A-18C of the VFA-106 and VMFA-312 who are tasked to attack Russian air defenses, Airbases and many strategical targets in Georgia like bridges train stations and Harbors. Air superiority and strikers escort will be the mission of the VF-101 and VF-143 with their Legendary F-14B Tomcats. E-2D will provide AWACS constant cover. Together these squadrons form a powerful and mighty force. For the first few days you will receive a precious help from B-52H of 69th BS based in UK. They will concentrate their attacks on SAM Systems, VMA-311 on LHA-Tarawa will wait for enemy weakeness to close from Georgian Coasts and launch ground attacks")',
			'Action.Text("The Russian Air Force is flying a mix of MiG-29, MiG-31, Su-27 and Su-25TM fighters directed by ground based early warning radar. Air bases and target complexes of high value are protected by a variety of surface-air missile systems, such as the Sa-2 Guindeline, SA-6 Gainful, the SA-8 Gecko and the SA-3 Goa, as well as short-range IR-SAMs and AAA. Few new SA-10 systems are in Georgia too. It seems that A-50 AWACS are present over Georgian territory too and it should be a priority target for us. Russian had time to build a powerful SAM defense system in Georgia and it will be our main target in the first missions. Our goal will be to gain air superiority over Georgia by neutralizing main bases in the country and destroying SAM systems. Russia Homeland is strictly forbidden. You are not allowed to attack ground target in Russia but air to air combat can be initiated near and over Russia")',
			'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
		},
	},
	
	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("The US Navy units deployed off the coasts of Georgia have successfully destroyed all the targets that they were assigned by US Central Command. With the complete destruction of the Russian airforce over Georgia, the air campaign of this war comes to an end. Russian will soon begin to withdraw from Georgia. Well done.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.totalAirUnitAliveBySide("red") < 10',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("Russian forces are completly defeated. After repeated air strikes and disastrous losses in air-air combat, the russians are no longer able to produce any sorties or offer any resistance. The US Navy now owns complete air superiority. With the disappearance of the air threat, we hope that russians will decide to leave Georgia quickly. Well done.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("VFA-106") < 2 or Return.AirUnitActive("VFA-106") == false',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Ongoing combat operations have exhausted your squadron. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Allied Air Force to attain air superiority, US Central Command has decided to call of the air campaign against the Russians. Without destroying Russians airbases it seems unlikely that the coalition will be able to win this war.")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = true,
		condition = 'Return.UnitDead("CVN-71 Theodore Roosevelt") and Return.UnitDead("CVN-73 George Washington")',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("After the CVN-71 Theodore Roosevelt and CVN-73 George Washington has been hit by air strikes and sunk, Squadrons are no longer able to fly. Most of its planes are deep into the Caucasian waters and it will need a long time to restore this unit s capabilities. This is a bitter failure for the Navy")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},	
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 40',
		action = {
			'Action.CampaignEnd("draw")',
			'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Russian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Russians will convince them to withdraw from Georgia")',
			'NoMoreNewspaper = true',
		},
	},
	
----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 35 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 65',
		action = {
			'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	
	----- CARRIER MOVEMENT -----
	["TF-71 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("TF-71", {{"Indy 1-1", "Indy 1-2", "Indy 1-3", "Indy 1-4"}}, 10, 8, nil)',
	},
	["TF-73 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("TF-73", {{"Indy 2-1", "Indy 2-2", "Indy 2-3", "Indy 2-4"}}, 10, 8, nil)',
	},
	["LHA-Group Far from Georgian Coasts"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = {
			'Action.ShipMission("LHA-Group", {{"Indy 3-1", "Indy 3-2", "Indy 3-3", "Indy 3-4"}}, 10, 8, nil)',
		}	
	},
	["LHA Group Close to Georgian Coasts"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("368.ShAP") + Return.AirUnitReady("559.BAP") + Return.AirUnitReady("52.TBAP") + Return.AirUnitReady("959.BAP") + Return.AirUnitReady("79.TBAP") < 10',
		action = {
			'Action.ShipMission("LHA-Group", {{"Indy 3-5", "Indy 3-6", "Indy 3-7", "Indy 3-8"}}, 10, 8, nil)',
			'Action.Text("After the estimated near destruction of all the enemy anti-ship air squadrons, LHA Group is allowed to move closer of Georgian coast.")',
		}	
	},
----- CVN Air Patrols -----
	["CVN fligth patrols after CVN-71 Destroyed"] = {
		active = true,
		condition = 'Return.UnitDead("CVN-71 Theodore Roosevelt")',
		action = {
			'Action.TargetActive("CVN-71 Theodore Roosevelt Interception", false)',
			'Action.TargetActive("CVN-71 CAP", false)',
			'Action.TargetActive("CVN-71 CAP 2", false)',
			'Action.TargetActive("CVN-71 AEW", false)',
			'Action.TargetActive("CVN-71 Mission Support Tanker", false)',
			'Action.TargetActive("CVN-71 Recovery Tanker", false)',
		},
	},	
	["CVN fligth patrols after CVN-73 Destroyed"] = {
		active = true,
		condition = 'Return.UnitDead("CVN-73 George Washington")',
		action = {
			'Action.TargetActive("CVN-73 Theodore Roosevelt Interception", false)',
			'Action.TargetActive("CVN-73 CAP", false)',
			'Action.TargetActive("CVN-73 CAP 2", false)',
			'Action.TargetActive("CVN-73 AEW", false)',
			'Action.TargetActive("CVN-73 Mission Support Tanker", false)',
			'Action.TargetActive("CVN-73 Recovery Tanker", false)',
		},
	},	

----- CONVOY MOVEMENT -----
	["Cargo convoy 1 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Cargo convoy 1", {{"Ships 1-1", "Ships 1-2", "Ships 1-3", "Ships 1-4"}}, 8, 5, nil)',
	},
	["Cargo convoy 2 Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Cargo convoy 2", {{"Ships 1-5", "Ships 1-6", "Ships 1-7", "Ships 1-8"}}, 8, 5, nil)',
	},	
	
	----- UNIT DESACTIVATION -----
	["Unit Desactivate B-52H and B-1B"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >= 5',
		action = {
			'Action.AirUnitActive("69 BS", false)',
			'Action.Text("After intensive flights against Russians SAM sites, B-52H from 96 BS and B-1B from 69 BS have reduced significantly SAM sites effectiveness. They have to stop their missions but it should be easier for TF-71 to attack strategics targets in Georgia")',
		},
	},
	["LHA_Tarawa"] = {
		active = true,
		condition = 'Return.UnitDead("LHA_Tarawa")',
		action = {
			--'db_airbases["LHA_Tarawa"].inactive = true',
			--'Action.moveToAnotherBaseOrDeactivate("VMA 311", { "CVN-73 George Washington", "CVN-71 Theodore Roosevelt"})',
			'Action.Text("After the LHA_Tarawa has been hit by air strikes and sunk, VMA 311 will try to find a place in CVN or will not be able to fly anymore")',
		}
	},	
	["CVN-73 George Washington sunk"] = {
		active = true,
		condition = 'Return.UnitDead("CVN-73 George Washington")',
		action = {
			-- 'db_airbases["CVN-73 George Washington"].inactive = true',
			-- 'Action.moveToAnotherBaseOrDeactivate("VMFA-312", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("VF-143", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("VAW-125-2", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("174 ARW-2", { "CVN-71 Theodore Roosevelt"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("175 ARW-2", { "CVN-71 Theodore Roosevelt"})',
			'Action.Text("After the CVN-73 George Washington has been hit by air strikes and sunk, Squadrons will try to transfert to CVN-71 or will not be able to fly anymore")',
		}
	},	
	["CVN-71 Theodore Roosevelt sunk"] = {
		active = true,
		condition = 'Return.UnitDead("CVN-71 Theodore Roosevelt")',
		action = {
			-- 'db_airbases["CVN-71 Theodore Roosevelt"].inactive = true',
			-- 'Action.moveToAnotherBaseOrDeactivate("VFA-106", { "CVN-73 George Washington"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("VF-101", { "CVN-73 George Washington"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("VAW-125", { "CVN-73 George Washington"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("174 ARW", { "CVN-73 George Washington"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("175 ARW", { "CVN-73 George Washington"})',
			'Action.Text("After the CVN-71 Theodore Roosevelt has been hit by air strikes and sunk, Squadrons will try to transfert to CVN-73 or will not be able to fly anymore")',
		}
	},
		
	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		condition = 'Return.TargetAlive("EWR 1 501") == 0 and Return.TargetAlive("EWR 2 502") == 0 and Return.TargetAlive("EWR 3 503") == 0 and Return.AirUnitAlive("2457 SDRLO") == 0',
		action = {
			'Action.TargetActive("CAP Red North", true)',
			'Action.TargetActive("CAP Red Center", true)',
			'Action.TargetActive("CAP Red South", true)',
			'Action.TargetActive("Batumi Interception 1", false)',
			'Action.TargetActive("Sukhumi Interception 1", false)',
			'Action.TargetActive("Kobuleti Interception 1", false)',
			'Action.TargetActive("Kutaisi Interception 1", false)',
			'Action.TargetActive("Mozdok Interception 1", false)',
			'Action.TargetActive("CAP_AWACS", false)',
			'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},	
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
}

