------------------
-- Confguration --
------------------

-- defaults
-- do not change
-- use /confgs/tooltips.cfg instead
devicePriorities = {
  ["keyboard"] = 3,
  ["joystick"] = 2,
  ["mouse"] = 1,
  ["trackir"] = 0
}
singleShortcut = false

comboHyphen = " or "
keyHyphen = " + "
shortcutHyphen = "   "
keyCase = "default"
modifierCase = "default"
functionNameCase = "default"
commandFormat = "[ $COMBOS ]"
functionFormat = "$NAME $COMMAND"
tooltipFormat = "$TOOLTIP   $SHORTCUTS"

-- load user configuration
dofile('config/tooltips.cfg')

----------------------------------
-- User control keys collection --
----------------------------------
package.path = package.path .. ';./blackshark/modules/?.lua'

local NewInput = require('NewInput')

dofile('scripts/input/layout.lua')
dofile('scripts/input/aircrafts.lua')

local oldGetDeviceType = getDeviceType

function getDeviceType(device)
    deviceCode = NewInput.getDeviceType(device) or 1
    return DEVICETYPES[deviceCode] or DEVICETYPES[1]
end

DEVICETYPES =
{
    [1] = 'keyboard',
    [2] = 'mouse',
    [3] = 'joystick',
    [4] = 'trackir'
}

local function addDeviceCommandCombos(commands, devicePriority)
   for j, command in pairs(commands or {}) do
      if inputToShortcutsMap[command.name] == nil then
         inputToShortcutsMap[command.name] = {}
      else
          if inputShortcutsDeviceSource[command.name] ~= nil then
         if inputShortcutsDeviceSource[command.name] > devicePriority then
            return
         end
     end 
      end
      local commandMapTable = inputToShortcutsMap[command.name]
      for k, combo in pairs(command.combos or {}) do
         local shortcut = ''
         for l, reformer in pairs(combo.reformers or {}) do
            if modifierCase == "upper" then
                reformer = string.upper(reformer)
            elseif modifierCase == "lower" then
                reformer = string.lower(reformer)
            end
            shortcut = shortcut .. reformer .. keyHyphen
         end
         local key = combo.key
         if keyCase == "upper" then
             key = string.upper(key)
         elseif keyCase == "lower" then
             key = string.lower(key)
         end
         shortcut = shortcut .. key
         table.insert(commandMapTable, shortcut)
         inputShortcutsDeviceSource[command.name] = devicePriority
      end
   end
end

local cfg_path = 'Config/Input/Aircrafts/'
local aircraftName = "ka-50"
local devices = NewInput.getDevices()
table.sort(devices, function(d1, d2)
   if ( d1 == nil ) or ( d2 == nil ) then
       return false
   end
   local d1Type = getDeviceType(d1)
   local d2Type = getDeviceType(d2)
   return devicePriorities[string.lower(d1Type)] > devicePriorities[string.lower(d2Type)]
end
)

inputToShortcutsMap = {}
inputShortcutsDeviceSource = {}
for i, device in pairs(devices) do
   local deviceType = getDeviceType(device)
   devicePriority = devicePriorities[deviceType]
   if devicePriority == 0 then
       break
   end
   local path = getLayoutPath(aircraftName, device)
   if path ~= nil then
      local layout = Layout()
      layout:open(path)
      addDeviceCommandCombos(layout.keyCommands, devicePriority)
      addDeviceCommandCombos(layout.axisCommands, devicePriority)
  end
end
getDeviceType = oldGetDeviceType

---------------------------
-- Hint - input mappings --
---------------------------
hintToInputsMap = {}

-- CPT MECH
hintToInputsMap["Gear lever"] = {"Gear lever"}
hintToInputsMap["Main/Common hydraulics for emergency gear"] = {["Switch"]="Emeregency gear", ["Cover"]="Emeregency gear cover"}
hintToInputsMap["Accelerometer reset"] = {"G-meter reset"}

-- SYSTEM CONTROLLER
hintToInputsMap["Master caution push-light"] = {"Master caution push-light"}
hintToInputsMap["Lamps test"] = {"Lamps test"}
hintToInputsMap["Rotor RPM warning push-light"] = {"Rotor RPM warning push-light"}
hintToInputsMap["MWS operation mode (not functional)"] = {}

--laser ranger ( front panel)
hintToInputsMap["Laser rangefinder / designator - mode switch"] = {["Switch"]="Laser range finder-designator mode switch", ["Cover"]="Laser range finder-designator mode switch cover"}
hintToInputsMap["Laser designator reset"] = {"Laser designater reset button"}

-- Right Side Panel (Правый Боковой Пульт) 
-- ELECTRICS POWER
hintToInputsMap["DC ground power"] = {["Switch"]="Electrical power ground power DC", ["Cover"]="Electrical power ground power DC cover"}
hintToInputsMap["Battery 2"] = {["Switch"]="Electrical power battery 2", ["Cover"]="Electrical power battery 2 cover"}
hintToInputsMap["Battery 1"] = {["Switch"]="Electrical power battery 1", ["Cover"]="Electrical power battery 1 cover"}
hintToInputsMap["AC ground power"] = {"Electrical power ground power AC"}
hintToInputsMap["AC left generator"] = {"Electrical power generator left"}
hintToInputsMap["AC right generator"] = {"Electrical power generator right"}
hintToInputsMap["DC/AC inverter"] = {"Electrical power inverter AUTO/OFF/MAN"}

-- FUEL PUMPS POWER AND VALVES
hintToInputsMap["Forward fuel tank pumps"] = {"Fuel pumps tank forward"}
hintToInputsMap["Rear fuel tank pumps"] = {"Fuel pumps tank rear"}
hintToInputsMap["Inner external fuel tanks pumps"] = {"Fuel pumps external tanks inner"}
hintToInputsMap["Outer external fuel tanks pumps"] = {"Fuel pumps external tanks outer"}
hintToInputsMap["Fuelmeter power"] = {"Fuel meter power"}
hintToInputsMap["Left engine fuel shutoff valve"] = {["Switch"]="Shutoff valve left engine fuel", ["Cover"]="Shutoff valve left engine fuel cover"}
hintToInputsMap["Right engine fuel shutoff valve"] = {["Switch"]="Shutoff valve right engine fuel ", ["Cover"]="Shutoff valve right engine fuel cover"}
hintToInputsMap["APU fuel shutoff valve"] = {["Switch"]="Shutoff valve APU fuel", ["Cover"]="Shutoff valve APU fuel cover"}
hintToInputsMap["Fuel crossfeed valve"] = {["Switch"]="Fuel bypass valve", ["Cover"]="Fuel bypass valve cover"}
hintToInputsMap["Fuel quantity indicator self test button"] = {"Fuel quantity indicator self test button"}

-- COMMS POWER
hintToInputsMap["Intercom"] = {"Radio equipment AVSK (SPU-9) intercom"}
hintToInputsMap["VHF-1 (R828) power switch"] = {"Radio equipment VHF-1 (R-828)"}
hintToInputsMap["VHF-2 (R-800) power switch"] = {"Radio equipment VHF-2 (R-800)"}
hintToInputsMap["Radio equipment datalink TLK power switch"] = {"Radio equipment datalink TLK"}
hintToInputsMap["Radio equipment datalink UHF TLK power switch"] = {"Radio equipment datalink UHF TLK"}
hintToInputsMap["Radio equipment datalink SA-TLF power switch"] = {}

-- WEAPON SYS
hintToInputsMap["Weapons сontrol system"] = {["Switch"]="Weapons control system", ["Cover"]="Weapons control system cover"}

-- EJECT SYSTEM
hintToInputsMap["Ejecting system power 1"] = {"Ejecting system power 1"}
hintToInputsMap["Ejecting system power 2"] = {"Ejecting system power 2"}
hintToInputsMap["Ejecting system power 3"] = {"Ejecting system power 3"}
hintToInputsMap["Ejecting system power"] = {"Ejecting system power cover"}
hintToInputsMap["Ejecting system circuit test"] = {"Eject system circuit test button"}
hintToInputsMap["Ejecting system circuit selector"] = {["Left"]="Eject system circuit check selector left", ["Right"]="Eject system circuit check selector right"}

-- HYDRAULICS
hintToInputsMap["Main hydraulics"] = {["Switch"]="Main hydraulics", ["Cover"]="Main hydraulics cover"}

-- IFF
hintToInputsMap["IFF power"] = {["Switch"]="IFF power", ["Cover"]="IFF power cover"}

-- ENGINES
hintToInputsMap["EEG Left engine Electronic Engine Governor"] = {["Switch"]="EEG Electronic Engine Governor left engine", ["Cover"]="EEG Electronic Engine Governor left engine cover"}
hintToInputsMap["EEG Right engine Electronic Engine Governor"] = {["Switch"]="EEG Electronic Engine Governor right engine", ["Cover"]="EEG Electronic Engine Governor right engine cover"}
hintToInputsMap["EEG power turbine channel 1 test – Operate – EEG power turbine channel 2 test, three-switch contactor"] = {}
hintToInputsMap["EEG gas generator test – Operate switch"] = {["Switch"]="EEG power turbine channel 1 test / channel 2 test three-switch contactor", ["Cover"]="EEG power turbine channel 1 test / channel 2 test three-switch contactor cover"}
hintToInputsMap["Left EGT control threshold governor button"] = {"EGT left threshold governor button"}
hintToInputsMap["Right EGT control threshold governor button"] = {"EGT right threshold governor button"}
hintToInputsMap["Engines vibrations monitoring system control button"] = {"Engine vibration monitor system button"}

-- NAV SYSTEM
hintToInputsMap["Navigation system power"] = {"Targeting-Navigation system power"}
hintToInputsMap["Gyro/Mag/Manual heading"] = {"Gyro/Mag/Manual heading"}

-- SHKVAL windscreen wiper
hintToInputsMap["SHKVAL windscreen wiper"] = {"Shkval windshield wiper"}


-- ABRIS Display (Дисплей АБРИС) 
hintToInputsMap["ABRIS Pushbutton 1"] = {"ABRIS Button 1"}
hintToInputsMap["ABRIS Pushbutton 2"] = {"ABRIS Button 2"}
hintToInputsMap["ABRIS Pushbutton 3"] = {"ABRIS Button 3"}
hintToInputsMap["ABRIS Pushbutton 4"] = {"ABRIS Button 4"}
hintToInputsMap["ABRIS Pushbutton 5"] = {"ABRIS Button 5"}
hintToInputsMap["ABRIS Cursor сontrol (rot/push)"] = {["Push"]="ABRIS Axis Push", ["Decrease"]="ABRIS Axis Decrease", ["Increase"]="ABRIS Axis Increase"}
hintToInputsMap["ABRIS Brightness"] = {["Decrease"]="ABRIS Brightness Decrease", ["Increase"]="ABRIS Brightness Increase"}
hintToInputsMap["ABRIS Power"] = {"ABRIS Power"}

-- HUD (ИЛС)
hintToInputsMap["HUD Brightness"] = {["Decrease"]="HUD Brightness down", ["Increase"]="HUD Brightness up"}
hintToInputsMap["HUD Modes Reticle/Night/Day"] = {"HUD Modes Reticle/Night/Day"}
hintToInputsMap["HUD Test"] = {"HUD Test"}
hintToInputsMap["HUD Filter"] = {"Raise/Lower Colour Filter On HUD"}

-- PVI NAV Panel (ПВИ - Пульт Ввода и Индикации)
hintToInputsMap["NAV '0' Btn"] = {"PVI Pushbutton 0"}
hintToInputsMap["NAV '1' Btn"] = {"PVI Pushbutton 1"}
hintToInputsMap["NAV '2' Btn"] = {"PVI Pushbutton 2"}
hintToInputsMap["NAV '3' Btn"] = {"PVI Pushbutton 3"}
hintToInputsMap["NAV '4' Btn"] = {"PVI Pushbutton 4"}
hintToInputsMap["NAV '5' Btn"] = {"PVI Pushbutton 5"}
hintToInputsMap["NAV '6' Btn"] = {"PVI Pushbutton 6"}
hintToInputsMap["NAV '7' Btn"] = {"PVI Pushbutton 7"}
hintToInputsMap["NAV '8' Btn"] = {"PVI Pushbutton 8"}
hintToInputsMap["NAV '9' Btn"] = {"PVI Pushbutton 9"}
hintToInputsMap["NAV Waypoints"] = {"PVI Waypoint Mode"}
hintToInputsMap["NAV Inflight INU Realignment"] = {"PVI In-flight INU Realignment"}
hintToInputsMap["NAV Fixpoints"] = {"PVI Navpos Correction Mode"}
hintToInputsMap["NAV Precise INU Alignment"] = {"PVI Precise INU Alignment"}
hintToInputsMap["NAV Airfields"] = {"PVI Airfields Mode"}
hintToInputsMap["NAV Normal INU Alignment"] = {"PVI Normal INU Alignment"}
hintToInputsMap["NAV Targets"] = {"PVI Targets Mode"}
hintToInputsMap["NAV Enter"] = {"PVI Enter"}
hintToInputsMap["NAV Cancel"] = {"PVI Cancel"}
hintToInputsMap["NAV Initial Nav Pos"] = {"PVI Initial NAV Position"}
hintToInputsMap["NAV Self coordinates"] = {"PVI Self Coordinates"}
hintToInputsMap["NAV Course:Course Deviation/Time/Range to WPT"] = {"PVI Course / Time / Range"}
hintToInputsMap["NAV Wind Heading/Speed"] = {"PVI Wind Heading / Speed"}
hintToInputsMap["NAV True Heading/Time/Range to final WPT"] = {"PVI True Heading / Time / Range to Final STP"}
hintToInputsMap["NAV Bearing/Range to target"] = {"PVI Bearing / Range to Target"}
hintToInputsMap["NAV Master modes"] = {["Left"]="PVI Change Master Mode (to left)", ["Right"]="PVI Change Master Mode (to right)"}
hintToInputsMap["NAV INU fixtaking method"] = {"PVI Set Fixtaking Method"}
hintToInputsMap["NAV Datalink power"] = {"PVI Datalink Power"}
hintToInputsMap["NAV Brightness"] = {["Decrease"]="PVI Lighting down", ["Increase"]="PVI Lighting up"}

-- UV-26 CMD Control Panel (УВ-26 - Устройство Выброса ЛТЦ)
hintToInputsMap["CMD Select Left/Both/Right board flares dispensers"] = {"UV-26 Change dispensing board Left-Both-Right"}
hintToInputsMap["CMD Amount flares counter/Programming"] = {"UV-26 Amount flares counter / Programming"}
hintToInputsMap["CMD Num of sequences"] = {"UV-26 Number of flare sequences"}
hintToInputsMap["CMD Num in sequence"] = {"UV-26 Number of flares in sequence"}
hintToInputsMap["CMD Dispense interval"] = {"UV-26 Delay between sequences"}
hintToInputsMap["CMD Start dispense"] = {"UV-26 Start dispensing"}
hintToInputsMap["CMD Reset to default program"] = {"UV-26 Reset current program"}
hintToInputsMap["CMD Stop dispense"] = {"UV-26 Stop dispensing"}

-- UV-26 related (BACK CONTROL PANEL)
hintToInputsMap["CMD Power"] = {["Switch"]="CMD UV-26 power switch", ["Cover"]="CMD UV-26 power switch cover"}
hintToInputsMap["CMD BIT"] = {["Switch"]="CMD UV-26 BIT switch", ["Cover"]="CMD UV-26 BIT switch cover"}

-- Datalink Control Panel
hintToInputsMap["DLNK Send/Memory"] = {"PRTs Send / Memory"}
hintToInputsMap["DLNK Ingress to target"] = {"PRTs Ingress to Target"}
hintToInputsMap["DLNK Erase"] = {"PRTs Erase Entering Data"}
hintToInputsMap["N/A"] = {"PRTs void button"}
hintToInputsMap["DLNK to ALL"] = {"PRTs To All"}
hintToInputsMap["DLNK to Wingman 1"] = {"PRTs To Wingman 1"}
hintToInputsMap["DLNK to Wingman 2"] = {"PRTs To Wingman 2"}
hintToInputsMap["DLNK to Wingman 3"] = {"PRTs To Wingman 3"}
hintToInputsMap["DLNK to Wingman 4"] = {"PRTs To Wingman 4"}
hintToInputsMap["DLNK Target #1/Vehicle"] = {"PRTs Target 1 / Vehicle"}
hintToInputsMap["DLNK Target #2/SAM"] = {"PRTs Target 2 / SAM"}
hintToInputsMap["DLNK Target #3/Other Type"] = {"PRTs Target 3 / Other"}
hintToInputsMap["DLNK Ingress point"] = {"PRTs Reference point"}

-- Datalink Mode Controls
hintToInputsMap["Datalink self ID"] = {"Self ID"}
hintToInputsMap["Datalink Master mode"] = {"Datalink mode"}

-- PUI-800 Weapons Control Panel (ПУИ-800 Пульт Управления и Индикации)
hintToInputsMap["Master Arm"] = {"Master arm on/off"}
hintToInputsMap["Not implemented"] = {}
hintToInputsMap["External stores jettison"] = {"External stores jettison"}
hintToInputsMap["Manual/Auto weapon system control switch"] = {"Weapon system control switch Manual/Auto "}
hintToInputsMap["Cannon round selector switch HE/AP"] = {"Cannon round selector switch"}
hintToInputsMap["Weapon mode switch - Burst Length"] = {"Weapon mode switch"}
hintToInputsMap["Cannon rate of fire setting"] = {"Cannon rate of fire setting"}
hintToInputsMap["Jettison arm mode - arm fuse/disarm fuse"] = {"Jettison arm mode - explosive/unexplosive"}
hintToInputsMap["Expedite emergency ATGM launch"] = {"Expedite emergency ATGM launch"}

-- PUR Weapons Aux Panel (ПУР Пульт Управления Режимом)
hintToInputsMap["IT-23 Black-White indication switch"] = {"IT-23 Black-White indication switch"}
hintToInputsMap["IT-23 display brightness"] = {["Decrease"]="IT-23 brightness Down", ["Increase"]="IT-23 brightness Up"}
hintToInputsMap["IT-23 display contrast"] = {["Decrease"]="IT-23 contrast Down", ["Increase"]="IT-23 contrast Up"}
hintToInputsMap["SHKVAL Optics adjustment"] = {}
hintToInputsMap["Helmet device brightness"] = {["Decrease"]="Helmet device brightness Down", ["Increase"]="Helmet device brightness Up"}
hintToInputsMap["Laser code selector"] = {["Left"]="Laser code selector left", ["Right"]="Laser code selector right"}
hintToInputsMap["HUD/TV declutter switch"] = {"HUD Scales Reject On/Off"}

-- Auxiliary panel - Preflight Set and Check Panel (ППК - Пульт Подготовки и Контроля)
hintToInputsMap["ATGM Temperature selector"] = {}
hintToInputsMap["Unguided rocket and gun pods ballistics data settings selector"] = {}
hintToInputsMap["Systems BIT selector"] = {}
hintToInputsMap["Control computers BIT switch"] = {}
hintToInputsMap["INU Power switch"] = {"INU power switch"}
hintToInputsMap["INU Heater switch"] = {"INU heater switch"}
hintToInputsMap["Self test system push-button"] = {}
hintToInputsMap["Emergency INU alignment switch"] = {}
hintToInputsMap["Stabilisation and indication of hanger cable switch"] = {}
hintToInputsMap["Video Tape Recorder switch"] = {}
hintToInputsMap["Power plant, hydraulics, EKRAN self-test systems switch"] = {["Switch"]="Power plant, hydraulics, EKRAN self-test systems switch", ["Cover"]="Power plant, hydraulics, EKRAN self-test systems switch cover"}

-- PPR - Autopilot Control Panel (ППР - Пульт Пилотажных Режимов)
hintToInputsMap["Autopilot Bank hold"] = {"Autopilot Bank hold"}
hintToInputsMap["Autopilot Heading hold"] = {"Autopilot Heading hold"}
hintToInputsMap["Autopilot Pitch hold"] = {"Autopilot Pitch hold"}
hintToInputsMap["Autopilot Altitude hold"] = {"Autopilot Altitude hold"}
hintToInputsMap["Autopilot Director control"] = {"Autopilot Director control"}
hintToInputsMap["Autopilot BARO/RALT altitude hold mode"] = {"Autopilot BARO/RALT altitude hold mode"}
hintToInputsMap["Autopilot Desired heading - Desired track"] = {"Autopilot Desired heading - Desired track"}

-- CLOCK (часы)
hintToInputsMap["Mech clock left lever"] = {["Down"]="Mech clock. Left lever Down", ["Up"]="Mech clock. Left lever Up", ["Left"]="Mech clock. Left lever turning left", ["Right"]="Mech clock. Left lever turning right"}
hintToInputsMap["Mech clock right lever"] = {["Press"]="Mech clock. Right lever Down", ["Left"]="Mech clock. Right lever Rotate left", ["Right"]="Mech clock. Right lever Rotate right"}

-- OVERHEAD PANEL
hintToInputsMap["Brightness"] = {}
hintToInputsMap["Rotor de-icing system switch"] = {"Rotor de-icing system switch"}
hintToInputsMap["Engines de-icing / dust-protection systems switch"] = {"Engines de-icing / dust-protection systems switch"}
hintToInputsMap["Navigation Lights 10\% / 30\% / 100\% / Off"] = {["Permanent"]="Lights navigation 10%/30%/100%/Off", ["Morse"]="Lights navigation Code Mode"}
hintToInputsMap["Windshield wiper switch"] = {"Windshield wiper switch"}
hintToInputsMap["Windshield washer fluid switch"] = {}
hintToInputsMap["Pitot static port and AoA sensors heat switch"] = {"Pitot static port and AoA sensors heat switch"}
hintToInputsMap["Pitot ram air and clock heat switch"] = {"Pitot ram air and clock heat switch"}
hintToInputsMap["Pitot heat system test"] = {"Pitot system heat test"}

-- HSI (ПНП)
hintToInputsMap["HSI Commanded course rotary"] = {["Left"]="HSI Commanded course rotary left" ,["Right"]="HSI Commanded course rotary right"}
hintToInputsMap["HSI Commanded heading rotary"] = {["Left"]="HSI Commanded heading rotary left" ,["Right"]="HSI Commanded heading rotary right"}
hintToInputsMap["HSI test"] = {"HSI Test"}
hintToInputsMap["HSI Desired track angle - Desired heading, Auto - Manual"] = {"HSI Desired track angle - Desired heading, Auto - Manual"}

-- ADI (ИКП)
hintToInputsMap["ADI Zero pitch trim"] = {["Left"]="ADI Zero pitch trim left" ,["Right"]="ADI Zero pitch trim right"}
hintToInputsMap["ADI Test"] = {["Button"]="ADI Test button", ["Cover"]="ADI Test button cover"}

-- SAI (АГР-81)
hintToInputsMap["Standby Attitude Indicator Cage/control test handle"] = {["Up"]="SAI Standby Attitude Indicator Cage/control test handle up", ["Left"]="SAI Standby Attitude Indicator Cage/control test handle left", ["Right"]="SAI Standby Attitude Indicator Cage/control test handle right"}
hintToInputsMap["Standby Attitude Indicator power switch"] = {"SAI Standby Attitude Indicator power switch"}

-- RADIOALTIMETER
hintToInputsMap["Dangerous RALT set rotary"] = {["Left"]="Radar altimeter dangerous RALT set rotary left" ,["Right"]="Radar altimeter dangerous RALT set rotary right"}
hintToInputsMap["Radar altimeter test"] = {"Radar altimeter test button"}

-- BARO ALTIMETER
hintToInputsMap["Baro pressure QFE knob"] = {["Decrease"]="Altimeter QFE knob pressure Decrease", ["Increase"]="Altimeter QFE knob pressure increase"}

-- PVR (ПВР - Пульт Выбора Режимов К-041)
hintToInputsMap["Training mode"] = {"Training mode switch"}
hintToInputsMap["Automatic turn on target mode"] = {"Button Automatic turn on target mode"}
hintToInputsMap["Airborne Target"] = {"Button Airborne target"}
hintToInputsMap["Forward hemisphere (head-on) air target aspect"] = {"Button Head-on airborne target aspect"}
hintToInputsMap["Ground moving target"] = {"Button Ground moving target"}
hintToInputsMap["Weapon system mode selector"] = {["Left"]="Weapon system mode selector (to left)", ["Right"]="Weapon system mode selector (to right)"}
hintToInputsMap["Targeting mode reset"] = {"Button Targeting mode reset"}
hintToInputsMap["Automatic Tracking / gun sight"] = {"Automatic tracking/gun sight"}
hintToInputsMap["K-041 Targeting-navigation system power switch"] = {"K-041 Targeting system power switch"}
hintToInputsMap["Laser standby ON/OFF switch"] = {"Laser standby On/Off switch"}
hintToInputsMap["Helmet-mounted sight system power switch"] = {"Helmet-mounted system On/Off"}
hintToInputsMap["Shkval scan rate"] = {["Decrease"]="Shkval auto scan rate dial down", ["Increase"]="Shkval auto scan rate dial up"}


-- Laser Warning System (Л-140)
hintToInputsMap["LWS Reset button"] = {"L-140 Laser warning system reset button"}
hintToInputsMap["LWS Power switch"] = {"LWS L-140 power switch"}
hintToInputsMap["LWS self-test button"] = {"LWS L-140 self-test button"}

-- Engines Start Control Panel
hintToInputsMap["Start-up selected engine button"] = {"Start-up engine"}
hintToInputsMap["Interrupt start-up button"] = {"Interrupt start-up sequence"}
hintToInputsMap["Stop APU button"] = {"Stop APU button"}
hintToInputsMap["Engine selector"] = {"Engine selector"}
hintToInputsMap["Engine work mod selector"] = {}
hintToInputsMap["Left engine cut-off valve"] = {"Cut-off valve left engine"}
hintToInputsMap["Right engine cut-off valve"] = {"Cut-off valve right engine"}
hintToInputsMap["Rotor brake"] = {"Rotor brake"}
hintToInputsMap["Engine Startup/Crank/False Start selector"] = {"Engine Startup/Crank/False Start selector"}

hintToInputsMap["Running engines exhaust gas temperature indicator test button"] = {"Exhaust gas temperature running engines indicator test button"}
hintToInputsMap["Stopped engines exhaust gas temperature indicator test button"] = {"Exhaust gas temperature stopped engines indicator test button"}

--Radio switcher
hintToInputsMap["SPU-9 Radio communicator selector"] = {"SPU-9 Radio communicator selector"}

-- Fire Extinguishers Control Panel
hintToInputsMap["Left engine extinguisher"] = {"Fire extinguisher left engine "}
hintToInputsMap["APU extinguisher"] = {"Fire extinguisher APU"}
hintToInputsMap["Right engine extinguisher"] = {"Fire extinguisher right engine"}
hintToInputsMap["Ventilator extinguisher"] = {"Fire extinguisher oil cooling fan"}
hintToInputsMap["Fire extinguisher Work – Off – Test switch"] = {["Switch"]="Fire extinguishers WORK - OFF - TEST", ["Cover"]="Fire extinguishers WORK - OFF - TEST cover"}
hintToInputsMap["Fire signaling"] = {"Fire signaling"}
hintToInputsMap["Fire extinguisher First (Auto) / Second (Manual) selector"] = {["Switch"]="Fire extinguisher First (Auto) / Second (Manual) selector", ["Cover"]="Fire extinguisher First (Auto) / Second (Manual) selector cover"}
hintToInputsMap["1st fire warning sensors group BIT"] = {}
hintToInputsMap["2nd fire warning sensors group BIT"] = {}
hintToInputsMap["3rd fire warning sensors group BIT"] = {}

-- Misc. systems
hintToInputsMap["Reducing gear box oil pressure indication selector"] = {}
hintToInputsMap["Sling load Auto/Manual"] = {}

-- Lighting
hintToInputsMap["Lighting cockpit interior lamp switch"] = {"Lighting cockpit interior lamp switch"}
hintToInputsMap["Lighting cockpit panel switch"] = {"Lighting cockpit panel switch"}
hintToInputsMap["Lighting night vision cockpit switch"] = {"Lighting night vision cockpit switch"}
hintToInputsMap["Lighting ADI and SAI switch"] = {"Lighting HSI and ADI switch"}
hintToInputsMap["Lighting night vision cockpit brightness knob"] = {["Decrease"]="Lighting night vision cockpit brightness knob Down", ["Increase"]="Lighting night vision cockpit brightness knob Up"}
hintToInputsMap["Lighting cockpit panel brightness knob"] = {["Decrease"]="Lighting cockpit panel brightness knob Down", ["Increase"]="Lighting cockpit panel brightness knob Up"}
hintToInputsMap["Lighting HSI and ADI brightness knob"] = {["Decrease"]="Lighting HSI and ADI brightness knob Down", ["Increase"]="Lighting HSI and ADI brightness knob  Up"}
hintToInputsMap["Lighting auxiliary panel switch"] = {"Lighting auxiliary panel switch"}
hintToInputsMap["Lighting auxiliary panel brightness knob"] = {["Decrease"]="Lighting auxiliary panel brightness knob Down", ["Increase"]="Lighting auxiliary panel brightness knob  Up"}

-- Outside illumination
hintToInputsMap["Light landing-search. On/Retraction/Off"] = {"Light landing search On/Retraction/Off"}
hintToInputsMap["Lights landing-search change. Main/Reserved"] = {"Lights landing search change Main/Reserved"}
hintToInputsMap["Tip Lights"] = {"Lights rotor tip"}
hintToInputsMap["Anticollision Light"] = {"Light anti-collision"}
hintToInputsMap["Navigation Lights 10\%/30\%/100\%/Off"] = {["Permanent"]="Lights navigation 10%/30%/100%/Off", ["Morse"]="Lights navigation Code Mode"}
hintToInputsMap["Formation Lights"] = {"Lights formation 10%/30%/100%/Off"}

--ARK-22
hintToInputsMap["ADF Inner-Auto-Outer NDB switch"] = {"ADF Beacon select"}
hintToInputsMap["ADF channel switch"] = {["Previous"]="ADF Channel prevous", ["Next"]="ADF Channel next"}
hintToInputsMap["COMPASS-ANTENNA modes"] = {"ADF Mode change"}
hintToInputsMap["TLF-TLG modes"] = {"ADF Receiver mode change"}
hintToInputsMap["ADF Volume"] = {["Down"]="ADF Volume down" ,["Up"]="ADF Volume up"}
hintToInputsMap["ADF Test"] = {"ADF Self test"}

-- Betty ("ALMAZ" system)
hintToInputsMap["Voice message system messages off"] = {"Voice message cease"}
hintToInputsMap["Voice message system emergency on"] = {"Voice message emergency mode"}
hintToInputsMap["Voice message system messages repeat"] = {"Voice message repeat"}
hintToInputsMap["Voice message system check"] = {"ALMAZ Voice alert system test button"}

--R-800 Radio
hintToInputsMap["R-800 (VHF-2) BIT button"] = {"Test button"}
hintToInputsMap["R-800 (VHF-2) AM-FM toggle switch"] = {"R-800 AM-FM Mode switch"}
hintToInputsMap["R-800 (VHF-2) Emergency receiver"] = {"Emergency receiver"}
hintToInputsMap["R-800 (VHF-2) ADF switch"] = {"ADF switch"}
hintToInputsMap["R-800 (VHF-2) Data transfer rate switch"] = {"Data transfer rate switch"}
hintToInputsMap["R-800 (VHF-2) Squelch"] = {"R-800 Squelch"}
hintToInputsMap["R-800 (VHF-2) 1st rotary"] = {["Down"]="R-800 Rotary 1 Down" ,["Up"]="R-800 Rotary 1 Up"}
hintToInputsMap["R-800 (VHF-2) 2nd rotary"] = {["Down"]="R-800 Rotary 2 Down" ,["Up"]="R-800 Rotary 2 Up"}
hintToInputsMap["R-800 (VHF-2) 3rd rotary"] = {["Down"]="R-800 Rotary 3 Down" ,["Up"]="R-800 Rotary 3 Up"}
hintToInputsMap["R-800 (VHF-2) 4th rotary"] = {["Down"]="R-800 Rotary 4 Down" ,["Up"]="R-800 Rotary 4 Up"}

--R-828 Radio
hintToInputsMap["R-828 (VHF-1) Radio channel selector"] = {["Previous"]="Channel selector previous", ["Next"]="Channel selector next"}
hintToInputsMap["R-828 (VHF-1) Radio Volume"] = {["Down"]="Volume down", ["Up"]="Volume up"}
hintToInputsMap["R-828 (VHF-1) Tuner button"] = {"Tuner button"}
hintToInputsMap["R-828 (VHF-1) Squelch"] = {"R-828 Squelch"}

--Signal Flares
hintToInputsMap["Signal flare system power"] = {"Signal flares power"}
hintToInputsMap["Signal flare red"] = {"Signal flares - red flare"}
hintToInputsMap["Signal flare green"] = {"Signal flares - green flare"}
hintToInputsMap["Signal flare white"] = {"Signal flares - white flare"}
hintToInputsMap["Signal flare yellow"] = {"Signal flares - yellow flare"}

-- PShK_7 (Latitude Entry Panel) Пульт широтной коррекции
hintToInputsMap["Latitude selection rotaty"] = {}
hintToInputsMap["North/South latitude selection"] = {}

-- ZMS_3 (Magnetic Variation Entry Panel) Задатчик магнитного склонения
hintToInputsMap["Magnetic variation selection rotaty"] = {["Left"]="Magnetic variation knob left", ["Right"]="Magnetic variation knob right"}

---------------------------
-- LOCALISATION override --
---------------------------
local function getInputShortcuts(input, key)
   local result = ''
   local deviceCommands = inputToShortcutsMap[input] or {}
   if #deviceCommands == 0 then
      return result
   end
   if singleShortcut == true then
      result = result .. deviceCommands[1]
   else
      for j = 1, #deviceCommands - 1 do
         result = result .. deviceCommands[j] .. comboHyphen
      end
      result = result .. deviceCommands[#deviceCommands]
   end
   local command = replace(commandFormat, "$COMBOS", result)
   if key == 1 or key == "1" then
      return command
   else
      if functionNameCase == "upper" then
          key = string.upper(key)
      elseif functionNameCase == "lower" then
          key = string.lower(key)
      end
      command = replace(functionFormat, "$COMMAND", command)
      command = replace(command, "$NAME", key)
      return command
   end
end

local OLD_LOCALIZE_REALIZATION = LOCALIZE

function LOCALIZE(hintText)
   local hint = OLD_LOCALIZE_REALIZATION(hintText)
   local shortcuts = ''
   local inputNames = hintToInputsMap[hintText] or {}
   local loopCount = 0
   for key, input in pairs(inputNames) do
      loopCount = loopCount + 1
      local shortcut = getInputShortcuts(input, key)
      if loopCount == 1 then
          shortcuts = shortcut
      else
          shortcuts = shortcuts .. shortcutHyphen .. shortcut
      end
   end
   if shortcuts == nil or shortcuts == "" then
       return hint
   end
   result = replace(tooltipFormat, "$TOOLTIP", hint)
   result = replace(result, "$SHORTCUTS", shortcuts)
   return result
end

function replace(format, marker, value)
    local index = string.find(format, marker)
    if index == nil then
        return format
    end
    local result = ''
    if index > 1 then
        result = string.sub(format, 1, index - 1)
    end
   result = result .. value
   if (index + string.len(marker) ) <= string.len(format) then
       result = result .. string.sub(format, index + string.len(marker))
   end
   return result
end

