
local base = _G

module('me_options_form')


local Window = base.require('Window')
local Widget = base.require('Widget')
local Container = base.require('Container')
local Theme = base.require('Theme')
local ToggleButton = base.require('ToggleButton')
local Button = base.require('Button')
local CheckBox = base.require('CheckBox')
local ComboBox = base.require('ComboBox')
local HSlider = base.require('HSlider')
local EditBox = base.require('EditBox')
local i18n = base.require('i18n')
local loader = base.require('dialog_loader')
local form = base.require('me_dialog_template_form');


i18n.setup(_M)

mtab = { __index = form}
base.setmetatable(_M, mtab)
-- resources for localization
cdata = {
    
    options = _("OPTIONS"),
    leftBtn = _("CANCEL"),
    rightBtn = _("OK"),
    middleBtn = _("DEFAULT"),
    exit = _("CANCEL"),
    system = _("SYSTEM"),
    controls = _("CONTROLS"),
    gameplay = _("GAMEPLAY"),

    --videoAudio = {
        title = _("VIDEO/AUDIO"),
        graphics = _("Graphics"),
        audio = _("Audio"),

        presets = _("PRESETS"),
        low = _("LOW"),
        medium = _("MEDIUM"),
        high = _("HIGH"),
        custom = _("CUSTOM"),

        textures = _("TEXTURES"),
        scenes = _("SCENES"),
        terrPreload = _("TERR PRELOAD"),
        civTraffic = _("CIV TRAFFIC"),
        water = _("WATER"),
        visibRange = _("VISIB RANGE"),
        effects = _("EFFECTS"),
        heatBlur = _("HEAT BLUR"),
        shadows = _("SHADOWS"),
        resolution = _("RESOLUTION"),
        fullScreen = _("FULL SCREEN"),
        aspect = _("ASPECT"),
        multiMonitorSetup = _("MONITORS"),

        volume = _("VOLUME"),
        music = _("MUSIC"),
        gui = _("GUI"),
        world = _("WORLD"),
        cockpit = _("COCKPIT"),
        headphones = _("HEADPHONES"),
        --radio = _("RADIO"),
        --engines = _("ENGINES"),
        --mech = _("MECH"),
        --effects = _("EFFECTS"),
        --wind = _("WIND"),
        --warnings = _("WARNINGS"),
        --inCockpit = _("IN-COCKPIT"),
        
        sound = _("SOUND"),
        music = _("MUSIC"),
        radioSpeech = _("RADIO SPEECH"),
        subtitles = _("SUBTITLES"),		
    --},

    --controllers = {
        title = _("CONTROLLERS"),
        saveProfileAs = _("SAVE PROFILE AS"),
        ffTune = _("FF TUNE"),
        axisTune = _("AXIS TUNE"),
        axisAssign = _("AXIS ASSIGN"),
        loadProfile = _("LOAD PROFILE"),
        test = _("TEST"),
        aircraft = _("Aircraft"),
        clear = _("CLEAR"),
        saveProfile = _("SAVE PROFILES"),
        default = _("DEFAULT"),
        category = _("Category"),
        clearCategory = _("CLEAR CATEGORY"),
        modifiers = _("MODIFIERS"),
        add = _("ADD"),
        
    --},

    --customization = {
        title = _("CUSTOMIZATION"),
        presets = _("PRESETS"),
        novice = _("NOVICE"),
        veteran = _("VETERAN"),
        ace = _("ACE"),
        custom = _("CUSTOM"),
        simulation = _('SIMULATION'),
        game = _('GAME'),
        
        main = _("MAIN"),
        
        setGlobal = _("USE THESE OPTIONS FOR ANY MISSION"),
        aftSwitching = _("AIRCRAFT SWITCHING"),
        permitCrash = _("PERMIT CRASH RCVR"),
        externalViews = _("EXTERNAL VIEWS"),

        difficulties = _("Difficulties"),
        
        padlock = _("PADLOCK"),
        unlimitedFuel = _("UNLIMITED FUEL"),
        unlimitedWeapons = _("UNLIMITED WEAPONS"),
        radioAssist = _("RADIO ASSIST"),
        tooltips = _("TOOL TIPS"),
        tooltipsSize = _("TOOL TIPS SIZE"),
        tooltipsLifetime = _("TOOL TIPS LIFETIME"),
        immortal = _("IMMORTAL"),
        miniHUD = _("MINI HUD"),
        labels = _("LABELS"),
        easyFlight = _("EASY FLIGHT"),
        easyRadar = _("EASY AVIONICS"),
        altTrimmingMethod = _('CENTRAL POSITION TRIMMER MODE'),
        
        f10opt = _("F10 VIEW OPTIONS"),

        myAC	= _("MY A/C"),
		all		= _("ALL"),
        allies 	= _("ALLIES"),
		mapOnly	= _("MAP ONLY"),
        --enemies = _("ENEMIES UNITS"),

        reflections = _("REFLECTIONS"),

        units = _("UNITS"),
        geffect = _("G-EFFECT"),
        mirrors = _("MIRRORS"),
        avionics = _("AVIONICS"),
        cockpitLanguage = _("COCKPIT LANGUAGE"),
        editorIconsStyle = _("EDITOR ICONS STYLE"),
        resOfCockpitDisplays = _('RES. OF COCKPIT DISPLAYS'),
		birds = _('Birds'),
    --},
}

-- create options dialog
function create(x, y, w, h)
    window = form.create(x, y, w, h, cdata)
    
    window:setTitleHeight(0);
    window.container_top.widgetText:setText(cdata.options)

    --SwitchButton.newGroup();
    local Dlg = loader.spawnDialogFromFile( base.dialogsDir .. "me_options_main.dlg", cdata)
    base.assert(Dlg);
    window.containerMain = Dlg.containerMain;--Container.new();
    containerMain = Dlg.containerMain;--Container.new();
    window:insertWidget(window.containerMain);
    local theme = window.containerMain:getTheme();
    theme.image.file = '';
    window.containerMain:setTheme(theme);
    --Dlg:removeWidget(window.containerMain);
    
   
    tabs = {};

    Dlg = loader.spawnDialogFromFile( base.dialogsDir .. "me_options_system.dlg", cdata)
    window.containerMain:insertWidget(Dlg.containerMain.containerSystem);
    tabs[1] = Dlg.containerMain.containerSystem;
    containerSystem = tabs[1];

    Dlg = loader.spawnDialogFromFile( base.dialogsDir .. "me_options_controls.dlg", cdata)
    tabs[2] = Dlg.containerMain.containerControls;
    window.containerMain:insertWidget(tabs[2]);
    tabs[2]:setVisible(false);
    containerControls = tabs[2];

    Dlg = loader.spawnDialogFromFile( base.dialogsDir .. "me_options_gameplay.dlg", cdata)
    tabs[3] = Dlg.containerMain.containerGameplay;
    window.containerMain:insertWidget(tabs[3]);
    tabs[3]:setVisible(false);
    containerGameplay = tabs[3];
    
	if (base.__LOP__ == true) then
        tabs[3].tipsCheckbox:setVisible(false)
    else
        tabs[3].tipsCheckbox:setVisible(true)
    end;
	
    -- containerGameplay.widget411:setVisible(true);
    -- containerGameplay.geffectCombo:setVisible(true);
    -- containerGameplay.aftSwitchingCheckbox:setVisible(false);

    window.containerMain.containerTabs.radiobuttonSystem:setState(true);
    window.containerMain.containerTabs.radiobuttonSystem.tab = tabs[1];
    window.containerMain.containerTabs.radiobuttonControls.tab = tabs[2];
    window.containerMain.containerTabs.radiobuttonGameplay.tab = tabs[3];
    
    
    
    for i = 1,#tabs do 
        for k,v in base.pairs(tabs[i]) do 
            _M[k] = v;
        end
    end
    
    pages = { 
        { page=containerSystem, button=tabs[1] }, 
        { page=containerControls, button=tabs[2] }, 
        { page=containerGameplay, button=tabs[3] }, 
    }
    
    local theme = window:getTheme();
    theme.image.file = Theme.getImage('options-window-background.png');
    theme.color = {0,0,0};
    window:setTheme(theme);
   
    --x,y,w,h = containerMain:getBounds();
   
    local leftOffset = {55,0}
    local rightOffset = {-55,0}
    local leftAlign = {'left', 'center'}
    local rightAlign = {'right', 'center'}
    

    theme = window.container_bottom.containerBottomButtons.leftBtn:getTheme();
    local picFile = theme.upTheme.image.file;
    theme.upTheme.image.rect = {0,150,50,50};
    theme.downTheme.image.rect = {150,150,50,50};
    theme.hoverUpTheme.image.rect = {50,150,50,50};
    theme.upTheme.text.offset = leftOffset;
    theme.downTheme.text.offset = leftOffset;
    theme.hoverUpTheme.text.offset = leftOffset;
    theme.upTheme.text.align = leftAlign;
    theme.downTheme.text.align = leftAlign;
    theme.hoverUpTheme.text.align = leftAlign;
    window.container_bottom.containerBottomButtons.leftBtn:setTheme(theme);

    theme = window.container_bottom.containerBottomButtons.rightBtn:getTheme();
    theme.upTheme.image.rect = {0,200,50,50};
    theme.downTheme.image.rect = {150,200,50,50};
    theme.hoverUpTheme.image.rect = {50,200,50,50};
    theme.upTheme.image.file = picFile;
    theme.downTheme.image.file = picFile;
    theme.hoverUpTheme.image.file = picFile;
    theme.upTheme.text.offset = rightOffset;
    theme.downTheme.text.offset = rightOffset;
    theme.hoverUpTheme.text.offset = rightOffset;
    theme.upTheme.text.align = rightAlign;
    theme.downTheme.text.align = rightAlign;
    theme.hoverUpTheme.text.align = rightAlign;
    window.container_bottom.containerBottomButtons.rightBtn:setTheme(theme);
		
    
    
    --theme = window.container_bottom.containerBottomButtons.rightBtn:setVisible(false);

    window.container_bottom.containerBottomButtons.middleBtn:setVisible(false);

    resize();

    return window     
end



function resize()
    form.resize();
    local _tmp,_tmp1,client_w,client_h = window:getClientRect();
    local top_container = {window.container_top:getBounds()};
    local bottom_container = {window.container_bottom:getBounds()};
    local container_main_w, container_main_h, container_main_shift = 1024, 650, 19
    
    -- window.containerMain:setBounds(  0, 
                                     -- top_container[4], 
                                     -- client_w, 
                                     -- client_h - top_container[4] - bottom_container[4]);
            
    local _x = (client_w - container_main_w)/2;
    local _y = (client_h - container_main_h)/2-container_main_shift;
    -- base.print('client_w,client_h',client_w,client_h);
    -- base.print('container_main_w, container_main_h',container_main_w, container_main_h);
    -- base.print('_x, _y', _x, _y);
    window.containerMain:setBounds(  _x, 
                                     _y, 
                                     container_main_w, 
                                     container_main_h+2);
                                     
end;

