local base = _G

module('me_options')


local ComboBox = base.require('ComboBox')
form = base.require('me_options_form')
local assignmentPanel = base.require('me_options_assignment')
local axisTunePanel = base.require('me_options_axis_tune')
local modifiersPanel = base.require('me_options_modifiers')
local forcefeedbackPanel = base.require('me_options_forcefeedback')
local S = base.require('Serializer')
local U = base.require('me_utilities')
local T = base.require('tools')
local Factory = base.require('Factory')
local Gui = base.require('gui5')
local Theme = base.require('Theme')
local NewInput = base.require('NewInput')
local lfs = base.require('lfs')
local i18n = base.require('i18n')
local Widget = base.require('Widget')
local ComboBox = base.require('ComboBox')
local Tooltip = base.require('Tooltip')
local FileDlg = base.require('me_file_dialog');
local MsgWindow = base.require('me_msg_dialog')
local Menu = base.require('Menu')
local gettext = base.require('i_18n')


i18n.setup(_M)

local cdata = {
    openProfile = _('Load profile'),
    saveProfileAs = _('Save profile as'),
    error_reading_profile = _('Error reading options'), 
    message = _('Error reading profile'), 
    ok = _('Ok'),
    yes = _('Yes'),
    no = _('No'),
    warning = _('Warning'),
    invalidActionsWarning = _('%d invalid actions present in "%s", aborting save\n'),
    invalidActionsList = _('invalid actions list:\n'),
    savingProfile = _(' saving profile '),
    axisCommands = _('Axis Commands'),
    action = _('Action'),
    All = _('All'),
    clearAssignments = _('Clear all assignments in category'),
    confirmClear = _('Are you sure you want to clear all assignments for device "%s" in category "%s"?'),		
	optionsView = _('optionsView'),
	}


	
local optionsDataFile = base.getFileName(base.mainPath .. './data/scripts/optionsData.lua')
local optionsFile = base.getFileName(base.mainPath .. './data/scripts/options.lua')

local f, err = base.loadfile(optionsDataFile)
if f then
    local env = {
        _ = _,
    };
    base.setfenv(f, env);
    f();
    graphDflt = env.graphDflt;  -- default values for graphics 
    difDflt = env.difDflt;  -- difficulty presets
    defaults = env.defaults; -- default values
    base.print('options data successfully loaded');
    --base.U.traverseTable(env)
else
    base.print('Error loading options data', err);
end;


forcedOptions = {};
-- data to use
vdata = {}
U.recursiveCopyTable(vdata, defaults)

ACTIONS = {};
CATEGORIES = {};
disableProcessing = false;
modified = false;


-- Copy of data to restore after cancel pressed
local current = { };

function KEYBOARD(IN)
    return IN;
end; 

function MOUSE(IN)
    return KEYBOARD(IN) + 1024;
end; 

function NEWVIEW(IN)
    return MOUSE(IN) + 1024;
end; 

function TRACKIR(IN)
    return NEWVIEW(IN) + 1024;
end; 

function JOYSTICKN(n, IN)
    return TRACKIR(IN) + 1024 * (n + 1);
end; 


function INJOYSTICKN(_n, _in)
    return base.U.iff(_n > 0, _in + 1024*_n, _in);
end; 

function DEJOYSTICKN(_n, _in)
    return base.U.iff(_n > 0, _in - 1024*_n, _in);
end; 

DEVICETYPES = {
    mouse = 2,
    keyboard = 1,
    joystick = 3,
    trackir = 4,
}
DEVICEORDER = {DEVICETYPES.keyboard, DEVICETYPES.joystick, DEVICETYPES.mouse, DEVICETYPES.trackir};

-- parse aspect string in form of n:m and returns n and m as numbers
function parseAspectSides(str)
    local idx = base.string.find(str, ':')
    local n = base.tonumber(base.string.sub(str, 1, idx - 1))
    local m = base.tonumber(base.string.sub(str, idx + 1))
    return n, m
end


-- convert aspect number to display value
function aspectNumberToString(num)
    local aspectsTable = {}
    for k,v in base.ipairs(current.graphics.aspect.values) do
        base.table.insert(aspectsTable, v.dispName);
    end;

    for _i, v in base.pairs(aspectsTable) do
        local n, m = parseAspectSides(v)
        local val = n / m
        if (0.000001 > base.math.abs(val - num)) then
            return v
        end
    end
    return num
end


-- convert string to aspect number
function stringToAspectNumber(str)
    if base.string.find(str, ':') then
        local n, m = parseAspectSides(str)
        return n / m
    else
        return base.tonumber(str)
    end
end


-- returns list of icons themes
function getIconsThemes(path)
    local res = { }
    for file in base.lfs.dir(path) do
        if '.' ~= base.string.sub(file, 1, 1) then
            local fullPath = path .. '/' .. file .. '/theme.lua'
            if 'file' == base.lfs.attributes(fullPath).mode then
                local theme = T.safeDoFile(fullPath);
                local localizedName = i18n.getLocalizedValue(theme, 'name')
                base.table.insert(res, {id = base.string.lower(file), dispName = localizedName});
            end
        end
    end
    return res
end

function getMonitorProfiles()
    local res = { }
    local path = base.mainPath .. '../Config/MonitorSetup/';
    for file in base.lfs.dir(path) do
        --base.print(path)
        if '.lua' == base.string.sub(file, -4) then
            local fullPath = path .. '/' .. file;
            if 'file' == base.lfs.attributes(fullPath).mode then
                local f, err = base.loadfile(fullPath)
                if f then
                    local env = { math = base.math, screen = {width = 1, height = 1, aspect = 1}};
                    base.setfenv(f, env);
                    f();
                    local item = {
                        id = base.string.lower(base.string.sub(file, 1, -5)), 
                        dispName = _(env.name),
                        };
                    base.table.insert(res, item);
                    --base.print('adding', item.id, item.dispName)
                else
                    base.print('Error loading file', err);
                end;            
            end
        end
    end
    return res
end;

-- setup preset callback
function bindPreset(control, target, preset)
    control.onChange = function()
        --U.recursiveCopyTable(target, preset)
        --base.U.traverseTable(preset)
        for k,v in base.pairs(target) do
            if preset[k] ~= nil then
                v.__value__ = preset[k];
				--base.print('preset[k]=', preset[k], ' v=',v.control)
            -- else
                -- base.print('not found [' .. base.tostring(k) .. '] ' .. base.tostring(v.__value__));
            end;
        end;
        bindControls();
    end
end



-- Setup dictionaries
function bindControls()
    --base.print('-------------------------------------------------')
	--base.U.stack()
    local tables = {current.difficulty, current.graphics, current.sound, current.views.cockpit}
    for i, tbl in base.ipairs(tables) do		
        for controlName, controlDescription in base.pairs(tbl) do 
            --base.print('binding', controlName, controlDescription)
            if controlDescription.binder then   
                _M[controlDescription.binder](controlName, controlDescription);
            else
				--base.print("controlName=",controlName)
                bindControl(controlName, controlDescription);
            end;
        end;
    end;
 
end

function localize(devOptions)
    local t = { 
        devOptions.keyCommands or {}, 
        devOptions.axisCommands or {},
        };
    for i = 1, #t do
        for ind,action in base.pairs(t[i]) do
            action.localizedName = gettext.dtranslate('input', action.name);
            action.localizedCategory = gettext.dtranslate('input', action.category or ' ');
        end;
    end;
    return devOptions;
end; 

-- Load options from file
function loadOptions()
    local modes = Gui.GetVideoModes()
    for i, v in base.pairs(modes) do
        local item = v[1] .. 'x' .. v[2]
        base.table.insert(defaults.graphics.resolution.values, {id = item, dispName = item});
    end
    
    defaults.difficulty.iconsTheme.values = getIconsThemes(base.mainPath .. './data/map/images/themes')
    defaults.graphics.multiMonitorSetup.values = getMonitorProfiles();
    
    U.recursiveCopyTable(vdata, defaults)        
    local path = optionsFile;
    local f, err = base.loadfile(path)
    local env = {};
    if f then
        base.setfenv(f, env)
        f()
        --  vdata     
        --              
        loadSavedOptions(vdata, env.options);
        --U.recursiveCopyTable(vdata, env.options)
    end
    
end


function strtrim(s)
	return base.string.gsub(s, "^%s*(.-)%s*$", "%1")
end
function extractTypeNameFromDeviceName(dev_name)
	local  pattern = " {[0-9a-zA-Z]+%-[0-9a-zA-Z]+%-[0-9a-zA-Z]+%-[0-9a-zA-Z]+%-[0-9a-zA-Z]+}"
	local  val = base.string.gsub(dev_name,pattern,"")
	return strtrim(val)
end

function loadInputOptions()
    function loadDeviceOptions(path)
        local f = base.loadfile(path);
        if f then
            local env = newInputData;
            base.setfenv(f, env);
            f();
            return env.layout();
        end;    
    end;
    
    function loadAllFolderOptions(path, tbl)
        for entry in lfs.dir(path) do
            local fullPath = path .. '/' .. entry;
            local a = lfs.attributes(fullPath);
            if (a.mode == 'file') and ( '.lua' == base.string.sub(entry, -4, -1) ) then 
                local devName = base.string.sub(entry, 1, -5);
                --base.print('loading ', fullPath );
                local devOptions = loadDeviceOptions(fullPath);
                devOptions = localize(devOptions);
                --if devicesByName[devName] then --    ,  
                    tbl[devName] = devOptions;
                --end;
                --base.U.trav(tbl);
            end;
        end;
    end;
    
    local lang = i18n.getLocale();
    defaultProfileName = 'default' .. '_' .. lang;
    --base.print('defaultProfileName',defaultProfileName);

    local path = base.mainPath..'../config/input/Aircrafts/';
    local f = base.loadfile(path .. '/aircraftNames.lua');
    base.assert(f);
    base.setfenv(f, _M);
    f(); -- creates aircraftNames table
    aircrafts = {};
    for entry in lfs.dir(path) do
        local a = lfs.attributes(path .. entry);
        if (a.mode == 'directory') and (entry ~= '.') and (entry ~= '..') and (entry ~= '.svn')then
            local profile = {};
            --profile.name = entry;
            --base.print('aircraftNames[entry], entry',aircraftNames[entry], entry);
            profile.name = entry;
            profile.joystick = {};
            loadAllFolderOptions(path .. entry .. '/joystick', profile.joystick);
            profile.keyboard = {};
            loadAllFolderOptions(path .. entry .. '/keyboard', profile.keyboard);
            --base.U.traverseTable(profile.keyboard);
            profile.mouse = {};
            loadAllFolderOptions(path .. entry .. '/mouse', profile.mouse);
            profile.trackir = {};
            loadAllFolderOptions(path .. entry .. '/trackir', profile.trackir);
			local nm = aircraftNames[entry] or entry
            aircrafts[nm] = profile;
            --base.print('profile');
            --base.U.trav(profile);
            --base.table.insert(aircrafts, profile);
        end;
    end;
    
    path = base.getFileName(base.mainPath..'../scripts/input/InputEvents.lua', true);
    local f, err = base.loadfile(path);
    if f then
        local env = newInputData;
        base.setfenv(f, env);
        f();
        inputEvents = env.inputEvents;
        inputEventsStrings = {};
        for k,v in base.pairs(inputEvents) do
            inputEventsStrings[v] = k;
        end;
    else
        --base.print('inputEvents', inputEventsStrings);
        --base.U.trav(inputEventsStrings);
        base.print('Error loading file '.. path, err);
    end;    
    originalAircrafts = {};
    base.U.recursiveCopyTable(originalAircrafts, aircrafts);
end; 

-- save options to file
function saveOptions(additionalOptions)
    -- vdata.graphics.multiMonitorSetup.__value__ = 
        -- multiMonitorSetup[vdata.graphics.multiMonitorSetup.__value__] or vdata.graphics.multiMonitorSetup.__value__;
    local path = optionsFile
    local f = base.io.output(path, 'w')
    if f then
        local s = Factory.create(S, f)
        local tbl = prepareOptionsForSave(additionalOptions);
        s:serialize_simple2("options", tbl)
        f:close()
    end
end

-- create options dialog
function create(x, y, w, h)
    startParameters = {x, y, w, h}
    init();
end
--[[
function bindSlider(slider, widget, callbackName)
    slider.onChange = function(self)
        local val = self:getValue();
        window.controls.userWidget[callbackName](window.controls.userWidget, val);
        window.controls.userWidget:drawCurve();
        widget:setText(base.tostring(val*100));
    end;
end;

function setDeadZone(value)
    window.controls.hsliderDeadzone:setValue(value);
    window.controls.widgetDeadzone:setText(base.tostring(value*100));
    userWidget:setDeadZone(value);
end; --]]

function doCreate(x, y, w, h)
	--base.print('doCreate')
    assignmentPanelWindow = assignmentPanel.create(x, y, w, h, cdata)
    axisTunePanelWindow = axisTunePanel.create(x, y, w, h, cdata)
    modifiersPanelWindow = modifiersPanel.create(x, y, w, h, cdata)
    forcefeedbackPanelWindow = forcefeedbackPanel.create(x, y, w, h, cdata)
    --overrideVisible(assignmentPanelWindow);
    --overrideVisible(axisTunePanelWindow);
    
    U.recursiveCopyTable(current, vdata)
    
    window = form.create(x, y, w, h)
    bindControls()
    bindTooltipsSize()
    bindTooltipsLifetime()

    bindPreset(form.lowBtn, current.graphics, graphDflt.low)
    bindPreset(form.mediumBtn, current.graphics, graphDflt.medium)
    bindPreset(form.highBtn, current.graphics, graphDflt.high)

    bindPreset(form.noviceBtn, current.difficulty, difDflt.low)
    bindPreset(form.aceBtn, current.difficulty, difDflt.high)

    local old_setVisible =  form.containerControls.setVisible;
    form.containerControls.setVisible = function (self, b)
        if b and (not self:isVisible()) then
            --updateInputOptions();
            NewInput.activate(b);
        end;
        old_setVisible(self, b);
    end;
    
    updateDevices();
    
    local sortedAircraftNames = {};
    for k,v in base.pairs(aircrafts) do 
        base.table.insert(sortedAircraftNames, k);
    end
    base.table.sort(sortedAircraftNames)
    for k,v in base.ipairs(sortedAircraftNames) do
        local item = form.containerControls.comboboxAircraft:newItem(v);
        form.containerControls.comboboxAircraft:addChild(item);
    end;

	local path = base.mainPath..'data/scripts/temp_options.lua'	
	local f = base.loadfile(path)
    local env = {};
	if f then
		base.setfenv(f, env)
		f()
	end
    if env.temp_options and env.temp_options.optionsAircraft then
        local children = form.containerControls.comboboxAircraft:getChildren();
        local valid = false;
        for i, widget in base.ipairs(children) do --      ,    
            local text = widget:getText();        --      
            --base.print(text);
            if text == env.temp_options.optionsAircraft then
                form.containerControls.comboboxAircraft:setText(env.temp_options.optionsAircraft);
                valid = true;
                break;                
            end;
        end;
        if valid == false then
            --base.print('assigning default')
            form.containerControls.comboboxAircraft:setText(aircraftNames.Default);
        end;
    else
        form.containerControls.comboboxAircraft:setText(aircraftNames.Default);
    end;
    
    menu = Menu.new()
    local item = Menu.newItem(cdata.clearAssignments);
    menu:insertWidget(item);
    setupCallbacks()
    created  = true;
	
	form.tabs[3].birdsSlider.onChange = birdsOnChange;
	form.tabs[3].birdsWidget:setText(base.tostring(form.tabs[3].birdsSlider:getValue()..'%'))
	
end;

function lifetimeOnChange()
	--base.print('onChange');
	--base.U.stack()
    form.tabs[3].tooltipsWidget:setText(base.tostring(form.tabs[3].tooltipsSlider:getValue()))
--	current.difficulty.birds.__value__ = form.tabs[3].birdsSlider:getValue()
end;

function birdsOnChange()
	--base.print('onChange');
	--base.U.stack()
    form.tabs[3].birdsWidget:setText(base.tostring(form.tabs[3].birdsSlider:getValue()..'%'))
	current.difficulty.birds.__value__ = form.tabs[3].birdsSlider:getValue()
end;

function updateDevices()
    local _devices = NewInput.getDevices();
    --base.print('\n ------- devices:\n');
    --base.U.traverseTable(_devices, 2);
    devices = {};
    devicesByName = {};
    for k,v in base.pairs(_devices) do
        local deviceType = NewInput.getDeviceType(v);
        local keys,axes = NewInput.getDeviceKeysAxes(v); --    
        local joystickNumber = NewInput.getJoystickNumber(v);
        --base.print('joystickNumber, v',joystickNumber, v);
        --base.U.traverseTable(keys);
        --base.U.traverseTable(axes);
        --base.print('\nsupported keys for ', v);
        local supportedKeys = {};
        local processedKeys = {};
        for key_ind,key_val in base.ipairs(keys) do
            local keyId = DEJOYSTICKN(joystickNumber, key_val);
            processedKeys[key_val] = inputEventsStrings[keyId];
            supportedKeys[inputEventsStrings[keyId]] = key_val;
            -- if inputEventsStrings[v] ~= nil then
                -- base.print(inputEventsStrings[v], v);
            -- end;
        end;
        local supportedAxes = {};
        local processedAxes = {};
        for axes_ind,axes_val in base.ipairs(axes) do
            local keyId = DEJOYSTICKN(joystickNumber, axes_val);
            processedAxes[axes_val] = inputEventsStrings[keyId];
            --base.print('processedAxes[axes_val] axes_val',processedAxes[axes_val], axes_val);
            --base.table.insert(supportedAxes, inputEventsStrings[keyId]);
            supportedAxes[inputEventsStrings[keyId]] = axes_val;
            --base.print('inputEventsStrings[axes_val]',inputEventsStrings[axes_val], axes_val);
            -- if inputEventsStrings[v] ~= nil then
                -- base.print(inputEventsStrings[v], v);
            -- end;
        end;
        --base.table.sort(supportedAxes);
        --base.table.sort(supportedKeys);
        local deviceDescription = {  
            name = v,
            nativeName = v,
            keys = processedKeys, -- keys[<key id>] == <key string>
            axes = processedAxes, -- axes[<axis id>] == <axis string>
            deviceType = deviceType,
            supportedAxes = supportedAxes, -- supportedAxes[<axis string>] == <axis id>
            supportedKeys = supportedKeys, -- supportedKeys[<key string>] == <key id>
            joystickNumber = joystickNumber,
            }
        --base.U.traverseTable(deviceDescription);
        base.table.insert(devices,deviceDescription);
        devicesByName[v] = deviceDescription;
    end
    base.table.sort(devices, function (p1,p2)
            if ( p1 == nil ) or (p2 == nil) then
                return false;
            end;
            local ind1, ind2 = 0, 0;
            local op1, op2  = p1.deviceType, p2.deviceType;
            for i = 1, #DEVICEORDER do
                if op1 == DEVICEORDER[i] then
                    ind1 = i;
                    break;
                end;
            end;
            for i = 1, #DEVICEORDER do
                if op2 == DEVICEORDER[i] then
                    ind2 = i;
                    break;
                end;
            end;
            return ind1 < ind2;
        end
    )
    
end; 

function setupCallbacks()
    window.container_bottom.containerBottomButtons.leftBtn.onChange = onButtonCancel;
    window.container_bottom.containerBottomButtons.rightBtn.onChange = onButtonOk;
    window.container_top.buttonClose.onChange = onButtonCancel;
    
    window.containerMain.containerTabs.radiobuttonSystem.onChange = onChangeTab;
    window.containerMain.containerTabs.radiobuttonGameplay.onChange = onChangeTab;
    window.containerMain.containerTabs.radiobuttonControls.onChange = onChangeTab;
    form.containerControls.comboboxAircraft.onChange = onComboAircraft;
    form.containerControls.comboboxCategory.onChange = onComboCategory;
    form.containerControls.buttonDefault.onChange = onButtonDefault;
    form.containerControls.buttonClear.onChange = onButtonClear;
    form.containerControls.buttonLoadProfile.onChange = onButtonLoadProfile;
    form.containerControls.buttonSaveProfileAs.onChange = onButtonSaveProfileAs;
    --form.containerControls.buttonSaveProfile.onChange = onButtonSaveProfile;
    form.containerControls.buttonAdd.onChange = onButtonAdd;
    form.containerControls.buttonAxisTune.onChange = onButtonAxisTune;
    form.containerControls.buttonAxisAssign.onChange = onButtonAxisAssign;
    form.containerControls.buttonModifiers.onChange = onButtonModifiers;
    form.containerControls.buttonFFTune.onChange = onButtonForcefeedback;
    form.containerControls.buttonClearCategory.onChange = onButtonClearCategory;
    menu.onChange = onMenuChange;
	--form.tabs[3].birdsSlider.onChange = birdsOnChange;
    
    window:addKeyCombination(onButtonCancel, nil,'escape');    
    window:addKeyCombination(onButtonOk, nil,'enter');    
    window:addKeyCombination(onButtonOk, nil,'return');    
end; 

function onButtonClearCategory(self)
    clearAssignments()
end; 

function clearAssignments()
    local category = form.containerControls.comboboxCategory:getText();
    local columnNumber = activeCell.data.column;
    local headerCell = form.containerControls.scrollgrid:getHeaderCell(columnNumber);
    local devName = headerCell:getText();
    local str = base.string.format(cdata.confirmClear, devName, category);
    local msgWindow = MsgWindow.new(str, cdata.question, 'question', cdata.yes, cdata.no)
    msgWindow.onChange = function (self, button )
        --base.print('msgWindow.onChange',self, button);
        if button == cdata.yes then
            local grid = form.containerControls.scrollgrid;
            for i = 1, grid:getRowsCount() do
                --base.print('col, row',menu.columnIndex, i);
                local w = grid:getCell(columnNumber, i)
                if w ~= nil then
                    local action  = w.data.action;        
                    action.combos = nil;
                    w:setText('');
                    w:setTooltip(Tooltip.new(''));
                end;
            end;
            modified = true;
        end;
        MsgWindow.onChange(self)
    end;
    msgWindow:setVisible(true);
    
end; 

function onButtonForcefeedback()
    if activeCell then
        local action = activeCell.data.action;
        local deviceType = action.device.deviceType;
        if deviceType == DEVICETYPES.joystick then
            forcefeedbackPanel.show(true);
        else
            activeCell:setFocus(true);
        end;
    end;
end; 

function onButtonModifiers()
    modifiersPanel.show(true);
end; 

function onButtonAxisTune()
    if activeCell then
        local action = activeCell.data.action;
        --base.print('action',action);
        --base.U.traverseTable(action)
        local category = form.containerControls.comboboxCategory:getText();
        if (cdata.axisCommands == category) and action.combos and (#action.combos > 0) then
            axisTunePanel.show(true);
        else
            activeCell:setFocus(true);
        end;
    end;
end; 

function onButtonAxisAssign()
    form.containerControls.comboboxCategory:setText(cdata.axisCommands);
    setActiveCell(nil)
    fillControlsGrid();
end; 

function setWindowGray(b)
    if b then
        if not widgetGray then 
            widgetGray = Widget.new();
            local _x,_y,_w,_h = window:getBounds();
            --base.print('_x,_y,_w,_h',_x,_y,_w,_h);
            widgetGray:setBounds(_x, _y, _w, _h);
            local theme = widgetGray:getTheme();
            theme.color = {100/255,100/255,100/255,0.7};
            widgetGray:setTheme(theme);
            window:addChild(widgetGray);
        end;
        widgetGray:setVisible(true);
        widgetGray:setEnabled(true);        
    else
        if widgetGray then
            widgetGray:setVisible(false);
            widgetGray:setEnabled(false);
            --window:removeChild(widgetGray);
            --widgetGraywidgetGray = nil;
            --window:removeWidget(widgetGray);            
            if activeCell then
                activeCell:setFocus(true);
            end;
        end;
    end;
end; 

function onButtonAdd()
    if activeCell then
        --setWindowGray(true);
        assignmentPanel.show(true);
    end;
end; 


function prepareProfileForSave(profile)
    function removeFields(action, fieldsToRemove)
        for i,fieldName in base.ipairs(fieldsToRemove) do 
            if action[fieldName] ~= nil then
                action[fieldName] = nil;
            end;
        end
    end; 
    
    local preparedProfile = {};
    local fieldsToRemove = {
        'columnIndex',
        'deviceName',
        'deviceType',
        'device',
        'valid',
        'localizedName',
        'localizedCategory',
        'widget',
        };
    U.recursiveCopyTable(preparedProfile, profile)
    
    if preparedProfile.keyCommands then
        for k,action in base.pairs(preparedProfile.keyCommands) do
            removeFields(action, fieldsToRemove);
        end;
    end;
    
    if preparedProfile.axisCommands then
        for k,action in base.pairs(preparedProfile.axisCommands) do
            removeFields(action, fieldsToRemove);
        end;
    end;
    
    return preparedProfile;
end; 

function saveProfiles()
    if modified == false then
        return true;
    else
        --local items = form.containerControls.comboboxAircraft:getWidgets();
        local successFlag = true;
        --base.U.trav(aircrafts);
        for localizedName, profile in base.pairs(aircrafts) do 
            local profileName = profile.name;
            --local profile  = aircrafts[profileName];
            base.print('saving',profileName);
            for j, device in base.ipairs(devices) do 
                local skip = false;
                local deviceName = device.name;
                local deviceType = device.deviceType;
                local layout = getLayout(profile, deviceType);
                local profileToSave = layout[deviceName];
                if not profileToSave then 
                    profileToSave = layout[defaultProfileName] or layout['default'];
                end;
                local invalidActions = validateLayout(profileToSave, localizedName);
                if #invalidActions > 0 then
                    -- local invalidActionsWarning = base.tostring(#invalidActions) .. 
                        -- cdata.invalidActionsWarning1 .. 
                        -- deviceName .. cdata.invalidActionsWarning2;
                    local invalidActionsWarning = base.string.format(cdata.invalidActionsWarning,
                        #invalidActions, deviceName);
                    base.print(invalidActionsWarning);
                    local str = '    ';
                    local maxLinesCount =20;
                    if #invalidActions <= maxLinesCount then
                        for k = 1,#invalidActions do 
                            base.print(invalidActions[k].name);
                            str = str .. invalidActions[k].name .. '\n    ';
                        end
                    else
                        for k = 1,maxLinesCount do 
                            base.print(invalidActions[k].name);
                            str = str .. invalidActions[k].name .. '\n    ';
                        end
                        str = str .. '...';
                    end;
                    invalidActionsWarning = invalidActionsWarning .. cdata.invalidActionsList .. str;
                    local warning = cdata.warning .. ' ' .. cdata.savingProfile .. ' ' .. profileName
                    local msgWindow = MsgWindow.new(invalidActionsWarning, 
                            warning, 'warning', cdata.ok);
                    msgWindow:setVisible(true);
                    skip = true;
                    successFlag = false;
                end;
                if not skip then
                    local deviceDirName = '';
                    if DEVICETYPES.keyboard == deviceType then -- keyboard
                        deviceDirName = '/keyboard/';
                    elseif DEVICETYPES.mouse == deviceType then -- mouse
                        deviceDirName = '/mouse/';
                    elseif DEVICETYPES.joystick == deviceType then -- joystisk
                        deviceDirName = '/joystick/';
                    elseif DEVICETYPES.trackir == deviceType then -- trackir
                        deviceDirName = '/trackir/';
                    end;

                    profileToSave = prepareProfileForSave(profileToSave);
                    local dn = deviceName;
                    local path = base.mainPath .. '../config/input/Aircrafts/' 
                        .. profileName .. deviceDirName .. deviceName .. '.lua';
                    --base.print('path',path);
                    local f = base.io.output(path, 'w')
                    base.print('saving ',base.mainPath .. '../config/input/Aircrafts/' 
                        .. profileName .. deviceDirName .. dn .. '.lua');
                    if f then
                        local s = Factory.create(S, f)
                        s:serialize_simple2("options", profileToSave)
                        f:write('function layout()\nreturn options\nend');
                        f:close()
                    end;
                end;
            end;
        end;
        return successFlag;
    end;
end; 

function onButtonSaveProfileAs()
    local oldInputProcessor = base.getInputProcessor();   
    if activeCell then
        local w,h = 500, 500;
        base.setInputProcessor(nil);
        callback = function(filepath, params) 
            if not filepath then 
                base.setInputProcessor(oldInputProcessor); --  
                return; 
            end;
            local profileName  = form.containerControls.comboboxAircraft:getText();
            local device = activeCell.data.action.device;
            profileToSave = getDeviceOptions(device, profileName)
-- TODO:     
            profileToSave = prepareProfileForSave(profileToSave);
            if base.string.lower(base.string.sub(filepath, -4, -1)) ~= '.lua' then -- extension absent
                filepath = filepath .. '.lua';
            end;
            --base.print('filepath',filepath);
                
            local f = base.io.output(filepath, 'w')
            if f then
                local s = Factory.create(S, f)
                s:serialize_simple2("options", profileToSave)
                f:write('function layout()\nreturn options\nend');
                f:close()
            end
            base.setInputProcessor(oldInputProcessor); --  
        end;
        --FileDlg.create(0, 0, w, h, 1, callback)
        FileDlg.setStyle('saveoptionsas', cdata.saveProfileAs, callback);
        FileDlg.show(true);
    end;   
end; 

function onButtonLoadProfile()
    if activeCell then
        local w,h = 500, 500;
        local callback = function(filepath, params) 
            base.setInputProcessor(onProcessInput);
            if not filepath then return; end;
            --base.print('filepath',filepath);
            local f = base.loadfile(filepath);
            base.print('f',f);
            if f then
                local env = newInputData;
                base.setfenv(f, env);
                f();
                if not env.layout then
                    local msgWindow = MsgWindow.new(cdata.error_reading_profile, cdata.message, 'error', cdata.ok)
                    msgWindow:setVisible(true)                    
                    return;
                else
                    local profile  = aircrafts[form.containerControls.comboboxAircraft:getText()];
                    local deviceName = activeCell.data.action.deviceName;
                    local deviceType = activeCell.data.action.deviceType;
                    local layout = getLayout(profile, deviceType);
                    local newLayout =  env.layout();
                    --base.print('profile, deviceName, deviceType, layout, newLayout', profile, deviceName, deviceType, layout, newLayout);
                    --base.print('layout[deviceName]',layout[deviceName],deviceName);
                    layout[deviceName] = localize(newLayout);
                    updateOptionsData();
                    fillControlsGrid();
                    FileDlg.show(false);
                    modified = true;
                end;
            end;
        end;
        --FileDlg.create(0, 0, w, h, 1, callback)
        local params = function() 
            base.setInputProcessor(onProcessInput); 
            end;
        FileDlg.setStyle('loadoptions', cdata.openProfile, callback, params);
        FileDlg.show(true);
        base.setInputProcessor(nil);
    end;
end; 


function onButtonClear()
    if activeCell then
        local action  = activeCell.data.action;
        action.combos = nil;
        local w = activeCell;
        str = '';
        w:setText(str);
        w:setTooltip(Tooltip.new(str));
        activeCell:setFocus(true);
        --updateOptionsData();
        modified = true;
    end;
end; 

function onButtonDefault(self)
    --base.print('activeCell', activeCell);
    if activeCell then
        local profile  = aircrafts[form.containerControls.comboboxAircraft:getText()];
        --base.print('profile:')
        --base.U.traverseTable(profile, 3)
        local action  = activeCell.data.action;
        --base.print('action.deviceType, action.name',action.deviceType, action.name);
        --base.U.trav(action);
        local layout = getLayout(profile, action.deviceType);
        --base.print('layout')
        --base.U.traverseTable(layout, 1);
        --base.print('devOptions')
        local devOptions = layout[defaultProfileName] or layout['default'];
        --base.print( defaultProfileName, devOptions, layout['default']);
        if devOptions.keyCommands then
            for k,_action in base.pairs(devOptions.keyCommands) do
                if (action.name == _action.name) then
                    --if _action.combos then
                        action.combos = _action.combos; 
                    --end;
                    break;
                end;
            end;
        end;
        
        if devOptions.axisCommands then
            for k,_action in base.pairs(devOptions.axisCommands) do
                if (action.name == _action.name) then 
                    --if _action.combos then
                        action.combos = _action.combos;
                    --end;
                    break;
                end;
            end;
        end;
        
        local combos = action.combos;
        --base.print('combos:');
        --base.U.traverseTable(combos,3);
        if combos then
            local str = '';
            for j = 1, #combos do
                local combo = combos[j]
                str = str .. combo.key
                if combo.reformers then
                    for k = 1, #combo.reformers do
                        local reformer = combo.reformers[k];
                        str = str .. ' + ' .. reformer;
                    end;
                end;
                str = str .. ';'
            end;
            local w = activeCell;
            str = base.string.sub(str, 1, -2);
            --base.print('str: ', str);
            w:setText(str);
            w:setTooltip(Tooltip.new(str));
            --grid:setCell(w, action[i].columnIndex, rowCounter);
        else
            local w = activeCell;
            w:setText('');
            w:setTooltip('');        
        end;
        activeCell:setFocus(true);
        modified = true;
    end;
end;

function onComboAircraft(self)
    updateInputOptions();
end; 

function onComboCategory(self)
    setActiveCell(nil)
    --base.turnLog(true);
    fillControlsGrid();
    --base.turnLog(false);
end; 

function setActiveCell(cell)
    if (cell ~= nil) and (cell.data.left == true) then
        cell = nil;
    end;
    activeCell = cell;
    local b = (cell ~= nil);
    form.containerControls.buttonDefault:setEnabled(b);
    form.containerControls.buttonClear:setEnabled(b);
    form.containerControls.buttonLoadProfile:setEnabled(b);
    form.containerControls.buttonSaveProfileAs:setEnabled(b);
    form.containerControls.buttonAdd:setEnabled(b);
    form.containerControls.buttonFFTune:setEnabled(b);
    form.containerControls.buttonAxisTune:setEnabled(b);
    form.containerControls.buttonClearCategory:setEnabled(b);
    if b then 
        if form.containerControls.comboboxCategory:getText() == cdata.axisCommands then
            form.containerControls.buttonAxisTune:setEnabled(true);
        else
            form.containerControls.buttonAxisTune:setEnabled(false);
        end;
    end;
end; 

function onChangeTab(self)
    Gui.SetWaitCursor(true);
    for i = 1, #form.tabs do
        if form.tabs[i] ~= self.tab then
            form.tabs[i]:setVisible(false);
        end;
    end;
    local b = self:getState();
    if b and not self.tab:isVisible() then
        self.tab:setVisible(b);
    end;
    Gui.SetWaitCursor(false);
end; 

function onButtonCancel()
    if modified == true then
        aircrafts = {};
        base.U.recursiveCopyTable(aircrafts, originalAircrafts);
        updateInputOptions();
    end;
    show(false);
    assignmentPanel.show(false);
    base.mmw.show(true);
end; 

function onButtonOk()
    local needRestart = false;
    -- base.print(current.graphics.resolution, 
        -- vdata.graphics.resolution, 
        -- current.graphics.fullScreen, 
        -- current.graphics.fullScreen);
    if (current.graphics.resolution.__value__ ~= vdata.graphics.resolution.__value__)
        or (current.graphics.fullScreen.__value__ ~= vdata.graphics.fullScreen.__value__) 
        or (current.difficulty.iconsTheme.__value__ ~= vdata.difficulty.iconsTheme.__value__) 
        or (current.graphics.multiMonitorSetup.__value__ ~= vdata.graphics.multiMonitorSetup.__value__)
    then
        needRestart = true;
    end;

    if saveProfiles() then
        U.recursiveCopyTable(vdata, current)
        saveOptions();
        if needRestart then
            base.restartME();
            return
        else
            show(false);
            base.mmw.show(true);           
        end;
    end;
    
	local path = base.mainPath..'data/scripts/temp_options.lua'	
	local f = base.loadfile(path)
    local env = {};
    env.temp_options = {};
	if f then
		base.setfenv(f, env)
		f()
	end    
    
    env.temp_options.optionsAircraft = form.containerControls.comboboxAircraft:getText();
    
	local f = base.io.output(path, 'w')
	if f then
		local s = Factory.create(S, f)
		s:serialize_simple2('temp_options', env.temp_options)
		f:close()
	end

   local tooltipsCombo = form["tooltipsSizeCombo"]
   if tooltipsCombo ~= nil then
       local text = tooltipsCombo:getText()
       if isTooltipSizeCorrect(text) then
           setTooltipsSize(text)
       end
   end
   local tooltipsSlider = form["tooltipsSlider"]
   if tooltipsSlider ~= nil then
       local lifetime = tooltipsSlider:getValue()
           setTooltipsLifetime(lifetime)
   end
end;

local tooltipsResourcesPath = '../FUI/resourcesbs/dhint.res'

local tooltipFontSizeMapping = {
    ["Micro"] = "font_tiny",
    ["Tiny"] = "font_default",
    ["Small"] = "font_arial_13",
    ["Medium"] = "font_arial_16",
    ["Big"] = "font_arial_19",
    ["Large"] = "font_dejavu_lgc_sans_22",
    ["Huge"] = "font_frugal_sans_45"
}

function isTooltipSizeCorrect(size)
    if size == nil then
        return false
    end
    if tooltipFontSizeMapping[size] == nil then
        return false
    end
    return true
end

function bindTooltipsLifetime()
    local tooltipLife = getTooltipsLifetime() or 6000
    local tooltipsSlider = form["tooltipsSlider"]
    local tooltipsWidget = form["tooltipsWidget"]
    if tooltipsSlider == nil or tooltipsWidget == nil then
        tooltipsSlider:setVisible(false)
        tooltipsWidget:setVisible(false)
        return
    else
        tooltipsSlider:setVisible(true)
        tooltipsWidget:setVisible(true)
    end
    tooltipsSlider:setValue(tooltipLife)
    tooltipsSlider.onChange = lifetimeOnChange
    lifetimeOnChange()
--[[    if tooltipsLife == nil then
        tooltipsLife 
    end
      local tooltipsLabel = form["tooltipsSlider"]
      if tooltipsLabel ~= nil then
          tooltipsLabel:setVisible(false)
      end
      local tooltipsCombo = form["tooltipsSizeCombo"]
      if tooltipsCombo ~= nil then
          tooltipsCombo:setVisible(false)
      end
      return
   end]]
end

function bindTooltipsSize()
   local tooltipsSize = getTooltipsSize()
   if tooltipsSize == nil then
      local tooltipsLabel = form["tooltipsSizeLabel"]
      if tooltipsLabel ~= nil then
          tooltipsLabel:setVisible(false)
      end
      local tooltipsCombo = form["tooltipsSizeCombo"]
      if tooltipsCombo ~= nil then
          tooltipsCombo:setVisible(false)
      end
      return
   end
        
   local correctValues = {}
--[[   for i=5, 19 do
      local element = {id = base.tostring(i), dispName = _(base.tostring(i))}
      base.table.insert(correctValues, element)
   end]]

--   for valueName, valueFont in base.pairs(tooltipFontSizeMapping) do
--      base.table.insert(correctValues, {id=valueFont, dispName=valueName})
--   end

   base.table.insert(correctValues, {id=tooltipFontSizeMapping["Micro"], dispName="Micro"})
   base.table.insert(correctValues, {id=tooltipFontSizeMapping["Tiny"], dispName="Tiny"})
   base.table.insert(correctValues, {id=tooltipFontSizeMapping["Small"], dispName="Small"})
   base.table.insert(correctValues, {id=tooltipFontSizeMapping["Medium"], dispName="Medium"})
   base.table.insert(correctValues, {id=tooltipFontSizeMapping["Big"], dispName="Big"})
   base.table.insert(correctValues, {id=tooltipFontSizeMapping["Large"], dispName="Large"})
   base.table.insert(correctValues, {id=tooltipFontSizeMapping["Huge"], dispName="Huge"})

   options = {
      __value__ = getFontNameFromSize(getTooltipsSize()),
      control = 'combo',
      values = correctValues
   }
   bindControl("tooltipsSize", options);
end
function getTooltipsLifetime()
   local defaultLifetime = 6000
   local resourcesFile = base.io.input(tooltipsResourcesPath);
   if resourcesFile == nil then
       return nil
   end
   local resources = resourcesFile:read("*all")
   resourcesFile:close()

   local startIndex = base.string.find(resources, "lifetime")
   if startIndex == nil then
       return defaultSize
   end
   local endIndex = base.string.find(resources, "}", startIndex)
   local lifetime = base.string.sub(resources, startIndex + 9, endIndex - 1)
   return base.tonumber(lifetime)
--   local fontSize = getFontSizeFromName(fontName);

--   if isTooltipSizeCorrect(fontSize) then
--       return fontSize
--   else
--       return defaultSize
--   end

end

function setTooltipsLifetime(lifetime)
    if lifetime == nil then
        return
    end

   local tooltipFontName = getFontNameFromSize(tooltipFontSize)
   local resourcesFile = base.io.input(tooltipsResourcesPath);
   if resourcesFile == nil then
       return
   end
   local resources = resourcesFile:read("*all")
   resourcesFile:close()

   local startIndex = base.string.find(resources, "lifetime")
   if startIndex == nil then
      resourcesFile = base.io.output(tooltipsResourcesPath)
      resourcesFile:write("\\lifetime{" .. tooltipFontName .. "}\n" .. resources)
      resourcesFile:close()
      return
   end

   resources = base.string.gsub(resources, '\\lifetime{[^}]*}', '\\lifetime{' .. base.tostring(lifetime) .. '}')
      resourcesFile = base.io.output(tooltipsResourcesPath);
      resourcesFile:write(resources)
      resourcesFile:close()
end

function getTooltipsSize()
   local defaultSize = tooltipFontSizeMapping["Tiny"];
   local resourcesFile = base.io.input(tooltipsResourcesPath);
   if resourcesFile == nil then
       return nil
   end
   local resources = resourcesFile:read("*all")
   resourcesFile:close()

   local startIndex = base.string.find(resources, "fonttype")
   if startIndex == nil then
       return defaultSize
   end
   local endIndex = base.string.find(resources, "}", startIndex)
   local fontName = base.string.sub(resources, startIndex + 9, endIndex - 1)
   local fontSize = getFontSizeFromName(fontName);

   if isTooltipSizeCorrect(fontSize) then
       return fontSize
   else
       return defaultSize
   end
end

function getFontNameFromSize(tooltipFontSize)
    local name = tooltipFontSizeMapping[tooltipFontSize]
    if name == nil then
        return tooltipFontSizeMapping["Tiny"]
    end
    return name
--[[    local number = base.tonumber(tooltipFontSize)
    if number < 20 then
        return "font_arial_" .. tooltipFontSize
    end
    if number == 20 then
        return "font_dejavu_lgc_sans_22"
    elseif number == 21 then
        return "font_dejavu_lgc_sans_27"
    elseif number == 22 then
        return "font_dejavu_lgc_sans_29"
    elseif number == 23 then
        return "font_dejavu_lgc_sans_31"
    else
        return "font_frugal_sans_45"
    end]]
end


function getFontSizeFromName(tooltipFontName)
    for size, name in base.pairs(tooltipFontSizeMapping) do
        if name == tooltipFontName then
            return size
        end
    end
    return "Tiny"
end

function setTooltipsSize(tooltipFontSize)
   if not isTooltipSizeCorrect(tooltipFontSize) then
       return
   end
   local tooltipFontName = getFontNameFromSize(tooltipFontSize)
   local resourcesFile = base.io.input(tooltipsResourcesPath);
   if resourcesFile == nil then
       return
   end
   local resources = resourcesFile:read("*all")
   resourcesFile:close()

   local startIndex = base.string.find(resources, "fonttype")
   if startIndex == nil then
      resourcesFile = base.io.output(tooltipsResourcesPath)
      resourcesFile:write("\\fonttype{" .. tooltipFontName .. "}\n" .. resources)
      resourcesFile:close()
      return
   end

   resources = base.string.gsub(resources, '\\fonttype{[^}]*}', '\\fonttype{' .. tooltipFontName .. '}')
      resourcesFile = base.io.output(tooltipsResourcesPath);
      resourcesFile:write(resources)
      resourcesFile:close()
end

function show(b) 
	--base.U.stack();
	--base.print('show')
	--base.U.traverseTable(vdata,2)
	--base.print('vdata.difficulty.birds.__value__', vdata.difficulty.birds.__value__)
	--if (form.tabs) then
	--	base.print(base.tostring(form.tabs[3].birdsSlider:getValue()..'%'))
	--end
	
    Gui.EnableHighSpeedUpdate(b)
    if b then
        modified = false;
        U.recursiveCopyTable(current, vdata)
        if not created then    
            doCreate(base.unpack(startParameters))
            updateInputOptions();
        else
            bindControls()
        end;
        --updateInputOptions();
    else
        base.setInputProcessor(nil);
        base.music.setMusicVolume(vdata.sound.music.__value__)
        base.music.setEffectsVolume(vdata.sound.gui.__value__)
    end
    if form.window then
        form.window:setVisible(b)
    end;
	
	if (form.tabs) then
		form.tabs[3].birdsSlider.onChange = birdsOnChange;
	end
end

function getLayout(profile, deviceType)
    local layout;
    if DEVICETYPES.keyboard == deviceType then -- keyboard
        layout = profile.keyboard;
    elseif DEVICETYPES.mouse == deviceType then -- mouse
        layout = profile.mouse;
    elseif DEVICETYPES.joystick == deviceType then -- joystisk
        layout = profile.joystick;
    elseif DEVICETYPES.trackir == deviceType then -- trackir
        layout = profile.trackir;
    end;
    return layout
end; 

function updateOptionsData()
    --base.print('updating options data');
	--base.U.stack()
    local path = base.getFileName(base.mainPath..'../scripts/input/InputEvents.lua', true);
    --local path = base.mainPath..'../scripts/input/InputEvents.lua';
    base.dofile(path); -- result in inputEvents table
    columns = {}
    local profileName = form.containerControls.comboboxAircraft:getText();
    --base.print('Aircraft: ',form.containerControls.comboboxAircraft:getText());
    local profile  = aircrafts[profileName];
    --base.U.trav(aircrafts);
    --base.U.traverseTable(profile, 2);
    columns[1] = {
        name = cdata.action,
        width = 400,
        };
    local _columns = {};
    --local val = aircrafts[form.containerControls.comboboxAircraft:getText()];
    
    ACTIONS = {};
    CATEGORIES = {};
    ALL_REFORMERS = {}; --    modifiers, switches, multiswitches
    ALL_REFORMERS_CODES = {};
    REFORMERS = {}; --  
    MODIFIERS = {};
    SWITCHES = {};
    --SWITCHGROUPS = {};
    for i = 1, #devices do
        local device = devices[i];
        --base.print('device:', device.nativeName, device.deviceType, device.name);
        local joystickNumber = NewInput.getJoystickNumber(device.nativeName);
        
        --base.print('NewInput.getDeviceType(device.nativeName)',NewInput.getDeviceType(device.nativeName));
        local sign = base.U.iff(NewInput.getDeviceType(device.nativeName) == 2, -1 , 1) --[[ NewInput::DT_MOUSE --]] --    !
        --base.print('joystickNumber, sign', joystickNumber, sign);
        local layout = getLayout(profile, device.deviceType);
        --base.print('layout',layout);
        --base.U.trav(layout);
		
	    local devOptions = layout[device.name]; --      
		
		if 	  devOptions == nil then --       
			  local template_name = extractTypeNameFromDeviceName(device.name)
			  devOptions  = layout[template_name]
			  if devOptions ~= nil then
				 layout[device.name] = devOptions;
				 base.print('loaded template "'..template_name..'" layout for ',device.name);
			  end
		end
				
        if devOptions == nil then   --        -
            devOptions = {};        --      -
            base.U.recursiveCopyTable(devOptions, layout[defaultProfileName] or layout['default']);
            layout[device.name] = devOptions;
            base.print('loaded default layout for ',device.name);
        end;
        --base.U.trav(devOptions);
        --base.print('devOptions',devOptions);
        collectReformers(devOptions, device, true);
        
        if devOptions.keyCommands then
            for k,action in base.pairs(devOptions.keyCommands) do
                ACTIONS[action.name] = ACTIONS[action.name] or {};
                --action.columnIndex = i + 1;
                -- if (device.deviceType == DEVICETYPES.joystick) 
                    -- and action.combos then
                    -- base.print('action.columnIndex',action.columnIndex, action.name);
                -- end;
                --base.print('action.columnIndex',action.columnIndex);
                action.deviceType = device.deviceType;
                action.deviceName = device.name;
                action.device = device;
                base.table.insert(ACTIONS[action.name], action);
                if not CATEGORIES[action.localizedCategory] then
                    CATEGORIES[action.localizedCategory] = 0;
                end;
                if action.combos and action.combos then
                    for j  = 1,#action.combos do
                        local combo = action.combos[j];
                        if combo.reformers then
                            for k,v in base.pairs(combo.reformers) do 
                                if not REFORMERS[v] then
                                    REFORMERS[v] = v;
                                    --base.print('REFORMERS[v]',REFORMERS[v]);
                                end;
                            end
                        end;
                    end;
                end;
                action.valid = true;
            end;
        end;
        
        if devOptions.axisCommands then
            for k,action in base.pairs(devOptions.axisCommands) do
                --base.print('action.name',action.name, i + 1);
                ACTIONS[action.name] = ACTIONS[action.name] or {};
                action.category = cdata.axisCommands;
                action.localizedCategory = cdata.axisCommands;
                --action.columnIndex = i + 1;
                --base.print('action.columnIndex',action.columnIndex);
                action.deviceType = device.deviceType;
                action.deviceName = device.name;
                action.device = device;
                base.table.insert(ACTIONS[action.name], action);
                if not CATEGORIES[action.localizedCategory] then
                    CATEGORIES[action.localizedCategory] = 0;
                end;
                if action.combos and action.combos.reformers then
                    for k,v in base.pairs(action.combos.reformers) do 
                        --base.print('REFORMERS: ', v);
                        base.table.insert(REFORMERS, v);
                    end
                end;
                action.valid = true;
            end;
        end;
        base.table.insert(_columns, {name = devices[i].name, width = 145, device = devices[i]});        
    end;
    
    base.table.sort(_columns, function (p1,p2)
            if ( p1 == nil ) or (p2 == nil) then
                return false;
            end;
            local ind1, ind2 = 0, 0;
            local op1, op2  = p1.device.deviceType, p2.device.deviceType;
            for i = 1, #DEVICEORDER do
                if op1 == DEVICEORDER[i] then
                    ind1 = i;
                    break;
                end;
            end;
            for i = 1, #DEVICEORDER do
                if op2 == DEVICEORDER[i] then
                    ind2 = i;
                    break;
                end;
            end;
            -- base.print('op1, op2',op1, op2);
            -- base.print('ind1, ind2',ind1, ind2);
            if ind1 == ind2 then
                return p1.name < p2.name;
            else
                return ind1 < ind2;
            end;
        end
    )
    columnsByDevice = {};
    for i = 1,#_columns do 
        base.table.insert(columns, _columns[i]);
        columnsByDevice[_columns[i].name] = i;
    end
    
    for i = 1, #devices do
        local device = devices[i];
        local layout = getLayout(profile, device.deviceType);
        local devOptions = layout[device.name];
        validateLayout(devOptions, profileName);
    end;
    createGlobalLayer();
end; 

function onHeaderMouseDown(self,x, y, button)
    --base.print('onHeaderMouseDown x, y, button',x, y, button);
    if button == 3 then
        local _tmp, _tmp1, w, h = menu:getBounds();
        menu:setBounds(x, y, w, h);
        menu:setVisible(true);
    end;
    if self.data.columnIndex ~= nil then
        selectColumn(self.data.columnIndex);
        menu.columnIndex = self.data.columnIndex;
        menu.name = self.data.name;
    else    
    end;
end;    

function onMenuChange(self, item)
    local text = item:getText();
    --base.print('menu.columnIndex',menu.columnIndex);
    if text == cdata.clearAssignments then
        clearAssignments()
    end;
end; 

function assembleCombo(combos)
    local str = '';
    if combos then
        for j = 1, #combos do
            local combo = combos[j]
            str = str .. combo.key
            if combo.reformers then
                for k = 1, #combo.reformers do
                    local reformer = combo.reformers[k];
                    str = str .. ' + ' .. reformer;
                end;
            end;
            str = str .. '; '
        end;
    end;
    return str;
end; 

function fillControlsGrid()
    base.collectgarbage('collect')
    --local t0 = base.os.clock();
    --base.print('fillControlsGrid');
    --base.U.stack();
    --updateOptionsData();
    local grid = form.containerControls.scrollgrid;
    grid:clear()
    --t0 = diffTime(t0, 'clear');
    
    local u = Widget.new(columns[1].name)
    u:setTheme(Theme.newOptionsControlsGridHeaderCellTheme())
    u:setTooltip(Tooltip.new(columns[1].name));
    grid:insertLeftColumn(columns[1].width, 1, u)
    --base.print('columns[i].name',columns[1].name);

    for i = 2, #columns do
        local u = Widget.new(columns[i].name)
        u:setTheme(Theme.newOptionsControlsGridHeaderCellTheme())
        u:setTooltip(Tooltip.new(columns[i].name));
        grid:insertColumn(columns[i].width, nil, u)
        --u:enableMouseCallback(true);
        --u.onMouseDown = onHeaderMouseDown;
        u.data = { 
            device = columns[i].device,
            columnIndex = i - 1;
            name = columns[i].name;
        }
        --base.print('columns[i].name',columns[i].name);
    end 

    --t0 = diffTime(t0, 'columns inserted');
    
    local sortedActions = {};
    for k,v in base.pairs(ACTIONS) do
        base.table.insert(sortedActions, v);
    end;
    base.table.sort(sortedActions, function(p1, p2) 
        if not p1 or not p2 then return false; end;
        local a1 = p1[1];
        local a2 = p2[1];
        if not a1 or not a2 then return false; end;
        -- if a1.category == a2.category then
            return ( (a1.localizedName or '') < (a2.localizedName or ''));
        -- else
            -- return (a1.category < a2.category);
        -- end;
    end)
    
    --t0 = diffTime(t0, 'actions sorted');
    
    local rowCounter = 1;
    local category = form.containerControls.comboboxCategory:getText();
    --for actionName, action in base.pairs(ACTIONS) do
    for i = 1, #sortedActions do
        local action = sortedActions[i];
        local ind, val = base.next(action)
        --local actionName = val.name;
        local actionName = val.localizedName;
        grid:insertRow(15, rowCounter);
        --base.print('actionName',actionName, val.name);
        local w = Widget.new();
        action.actionNameWidget = w;
        w:setText(actionName);
        w:enableMouseCallback(true);
        w.onMouseDown = onChangeGridCell;
        w.onFocus = onFocusGridCell;
        w.data = {row = rowCounter, column = 1, action = action[i], left = true};
        w:setTooltip(Tooltip.new(actionName));
        grid:setLeftCell(w, 1, rowCounter);
        
        --base.print('#action',#action);
        local removeFlag = false;
        for i = 1, #action do
            if (action[i].localizedCategory == category) or 
                ( (cdata.All == category) and 
                (cdata.axisCommands ~= action[i].localizedCategory) ) then
                --base.print('action[i].name',action[i].name, action[i].columnIndex, action[i]);
                local combos = action[i].combos;
                local str = assembleCombo(combos);
                local w = Widget.new();
                --base.print('str',str);
                str = base.string.sub(str, 1, -3);
                w:setText(str);
                w:enableMouseCallback(true);
                w.onMouseDown = onChangeGridCell;
                w.onMouseDblClick = onGridCellDblClick;                
                w.onFocus = onFocusGridCell;
                local columnNumber = columnsByDevice[action[i].device.name]
                action[i].widget = w;
                w.data = {row = rowCounter, column = columnNumber, action = action[i]};
                if str ~= '' then 
                    w:setTooltip(Tooltip.new(str));
                end;
                grid:setCell(w, columnNumber, rowCounter);
                --grid:setCell(w, action[i].columnIndex-1, rowCounter);
            else
                action[i].widget = nil;
                removeFlag = true;
            end;
        end;
        if removeFlag then
            --local ww = grid:getLeftCell(1,rowCounter);
            --base.print('removing', ww:getText());
            grid:removeRow(rowCounter);
            --grid:removeLeftRow(rowCounter);
        else
            rowCounter = rowCounter + 1;
        end;
    end;
    --t0 = diffTime(t0, 'table filled');
    
    local rowsCount = grid:getRowsCount();
    local columnsCount = grid:getColumnsCount();
    --base.print('rowsCount, columnsCount',rowsCount, columnsCount);
    for i = 1, rowsCount do 
        local theme;
        if base.math.fmod (i, 2) ~= 0 then -- Odd  
            theme = Theme.newOptionsControlsOddGridCellTheme();
        else
            theme = Theme.newOptionsControlsGridCellTheme();
        end;            
        local w = grid:getLeftCell(1, i);
        if w then
            w:setTheme(theme);
        end;
        for j = 1, columnsCount do 
            local w = grid:getCell(j, i);
            if w then
                w:setTheme(theme);
                local action = w.data.action or {};
                if action.valid == false then
                    theme.color = {1,0,0};
                    w:setTheme(theme);
                    base.print('conflict',action.name);
                    --base.U.traverseTable(ALL_REFORMERS,2);
                end;                
            end;
        end;
    end;
    --t0 = diffTime(t0, 'table stylized and verified');
    setActiveCell(nil);
end; 

function onChangeGridCell(self, x, y, button)
    if 1 == button then
        local grid = form.containerControls.scrollgrid;
        grid:selectRow(self.data.row);
        selectWidget(activeCell, false);
        selectWidget(self, true);
        setActiveCell(self);
    end;
end; 

function onGridCellDblClick(self, x, y, button)
    --base.print('onGridCellDblClick',button);
    if 1 == button then
        local grid = form.containerControls.scrollgrid;
        grid:selectRow(self.data.row);
        if self.data.column ~= 1 then
            selectWidget(self, true);
        end;
        setActiveCell(self);
        assignmentPanel.show(true);
    end;
end

function onFocusGridCell(self, focused)
    -- if focused then
        -- selectWidget(self, true);
    -- else
        -- selectWidget(self, false);
    -- end;
end

function selectWidget(widget, select)
    --base.print('selectWidget',widget, select);
    --base.U.stack();
    if widget then
        if widget.data.left ~= true then
            local theme = widget:getTheme();
            if select then 
                theme.border = Theme.newSimple2Border();
            else 
                theme.border = Theme.newEmptyBorder();
            end;
            widget:setTheme(theme);
            selectColumn(widget.data.column);
        else
            selectColumn(0);
        end;
    end;
end; 


function selectColumn(col)
    local grid = form.containerControls.scrollgrid;
    for i = 1,grid:getColumnsCount() do 
        local cell = grid:getHeaderCell(i);
        local theme = cell:getTheme();
        theme.color = {0,0,0,0};
        cell:setTheme(theme);    
    end
    if col > 0 then
        local cell = grid:getHeaderCell(col);
        local theme = cell:getTheme();
        --theme.color = {0,0,0,0.5};
        theme.color = {4/225,171/225,226/225,0.3};
        cell:setTheme(theme);
    end;
end; 

function fillCategoriesCombo()
    local combo = form.containerControls.comboboxCategory;
    combo:clear();
    local item = combo:newItem(cdata.All);
    combo:addChild(item);
    local t = {};
    for k,v in base.pairs(CATEGORIES) do
        --base.print('k,v', k,v);
        base.table.insert(t, k);
    end;
    --base.table.sort(t)
    local firstEntries = {cdata.All, cdata.axisCommands}
    base.table.sort(t, base.U.listFirstComparator(firstEntries))
    for k,v in base.pairs(t) do
        local item = combo:newItem(v);
        combo:addChild(item);
        if v == cdata.axisCommands then
            local theme = item:getTheme();
            theme.normalTheme.text.color = {0,0,1};
            theme.normalTheme.color = {1.0,1.0,1.0};--{0.0,0.8,0.0};
            theme.selectedTheme.text.color = {1,1,1};--{1,0,0};
            theme.selectedTheme.color = {0.7,0.7,0.7};
            item:setTheme(theme);
        end;
    end;
    combo:setText(cdata.All);
end; 

function diffTime(t0, msg)
    msg = msg or '';
    local t  =  base.os.clock();
    base.print(msg .. ' - diff time:',t - t0);
    return t;
end; 


function updateInputOptions()
    --base.turnLog(true);
    --local t0 = base.os.clock();
    updateDevices();
    --t0 = diffTime(t0, 'updateDevices');
    updateOptionsData();
    --t0 = diffTime(t0, 'updateOptionsData');
    fillCategoriesCombo();
    --t0 = diffTime(t0, 'fillCategoriesCombo');
    fillControlsGrid();
    --t0 = diffTime(t0, 'fillControlsGrid');
    --base.turnLog(false);
end; 

function  makeSnapshot(tbl)
    local initialState = {};
    --base.print('\nInitial:--------------------------------------------------------------\n');
    for k,v in base.pairs(tbl) do
        --base.print(k,v);
        initialState[k] = v;
    end;
    return initialState;
end; 

function cleanup(tbl, initialState)
    local extracted = {};
    for k,v in base.pairs(tbl) do
        if initialState[k] == nil then
            extracted[k] = v;
            tbl[k] = nil;
        end;
    end;
    -- base.print('\nCleanup---------------------------------------------------------------: \n');
    -- for k,v in base.pairs(tbl) do
        -- base.print(k,v);
    -- end;
    return extracted;
end; 

function init()
	--base.print('init')
    local hwnd = Gui.GetHWND();
    local initialState = makeSnapshot(base);
    NewInput.initialize(hwnd);
    newInputData = cleanup(base, initialState);
end; 

function updateWidget(widget, combos)
    local str = '';
    if combos then
        for j = 1, #combos do
            local combo = combos[j]
            str = str .. combo.key
            if combo.reformers then
                for k = 1, #combo.reformers do
                    local reformer = combo.reformers[k];
                    str = str .. ' + ' .. reformer;
                end;
            end;
            str = str .. ';'
        end;
    end;
    str = base.string.sub(str, 1, -2);
    widget:setText(str);
    widget:setTooltip(Tooltip.new(str));
end; 



function createGlobalLayer()
    --base.print('creating global layer');
    --base.U.stack();
    NewInput.clearReformers();
    NewInput.removeAllLayers();
    NewInput.createLayer("main");
    
    local t  = {};
    for modifierName, modifier in base.pairs(MODIFIERS) do
        base.table.insert(t, inputEvents[modifierName]);
        --base.print('adding modifier',modifierName, modifier, inputEvents[modifierName]);
    end;
    
    NewInput.addModifiers(t);
    
    for actionName, actions in base.pairs(ACTIONS) do 
        --base.print('actionName',actionName, actions.deviceType);
        for actionInd, action in base.ipairs(actions) do
            --base.print('actionName',actionName, action.deviceType);
            if action.deviceType ~= DEVICETYPES.mouse then
                --base.print('actionInd, action',actionInd, action.device.name);
                for comboInd, combo in base.ipairs(action.combos or {}) do
                    --base.print('comboInd, combo',comboInd, combo);
                    --local keyID = inputEvents[combo.key];
                    local keyID = action.device.supportedKeys[combo.key];
                    local downID = action.down or 0;
                    local upID = action.up or 0;
                    local pressedID = action.pressed or 0;
                    local reformersIDs = {};
                    --base.print('key keyID, downID, upID, pressedID', combo.key, keyID, downID, upID, pressedID);
                    for reformerInd, reformer in base.ipairs(combo.reformers or {}) do
                        local reformerID = inputEvents[reformer];
                        --base.print('keyID, reformerID, reformer',combo.key, reformerID, reformer);
                        base.table.insert(reformersIDs, reformerID);
                    end;
                    -- if action.deviceType == DEVICETYPES.joystick then
                        --base.print('actionInd, action',actionInd, action.device.name);
                        -- base.print('actionName',actionName, actions.deviceType, action.device.name);
                    -- end;
                    NewInput.addKeyCombo("main", keyID, reformersIDs, downID, pressedID, upID);
                end;
            end;
        end;
    end
    NewInput.setTopLayer("main");
    base.setInputProcessor(onProcessInput);
end; 

function setGlobalLayer()
    --NewInput.setTopLayer("main");
    createGlobalLayer();
end; 

function onProcessInput()
    --base.print('processInput');
    local category = form.containerControls.comboboxCategory:getText();
    local grid = form.containerControls.scrollgrid;
    if cdata.axisCommands == category then 
        return;
    end;
    local inputActions = NewInput.process();
    if disableProcessing == true then
        return;
    end;
    if #inputActions > 0 then
        --base.print('#inputActions',#inputActions);
        for i = 1,#inputActions do 
            local inputAction = inputActions[i];
            --base.U.traverseTable(inputActions[i]);
            local actionID = inputAction.action;
            local value = inputAction.value;
            local device = inputAction.device;
            local selectedColumn;
            if 0 == device then --     ...
                selectedColumn = 1;
            end;
            for columnNumber, column in base.ipairs(columns) do
                if column.device then
                    local columnDevice = JOYSTICKN(column.device.joystickNumber, 0);
                    --base.print('columnNumber, column, columnDevice',columnNumber, column, columnDevice);
                    if (columnDevice > 0) and (columnDevice == device) then
                        selectColumn(columnNumber-1);
                        selectedColumn = columnNumber-1;
                        --base.print('!!!');
                        break;
                    end;
                end;
            end;
            --base.print('inputAction.device, actionID, value',device , actionID, value);
            local actionName, actions, action = getAction(actionID);
            --base.print('actionName',actionName);
            --base.U.traverseTable(actions, 2);
            --base.print('actionName, actions, action, actionID',actionName, actions, action, actionID);
            if actionName 
                and ( (action.localizedCategory == category) or (cdata.All == category) ) 
                and (action.combos ~= nil) then
                --base.print('actionName',actionName);
                local actionNameWidget = actions.actionNameWidget;
                -- local theme = actionNameWidget:getTheme();
                -- theme.border.color = {1,0,0};
                -- theme.color = {1,0,0};
                --actionNameWidget:setTheme(theme);
                local row = actionNameWidget.data.row;
                --base.print('activeCell, row, actionNameWidget',activeCell, row, actionNameWidget);
                if activeCell then
                    selectWidget(activeCell, false);
                end;
                if selectedColumn then
                    local w = grid:getCell(selectedColumn, row)
                    selectWidget(w, true);
                    setActiveCell(w);
                end;
                grid:selectRow(row);
                grid:setRowVisible(row);
                return;
            end;
        end
    end;    
end; 

function getAction(actionID)
    --base.print('actionID',actionID);
    for actionName, actions in base.pairs(ACTIONS) do 
        --base.print('actionName',actionName);
        for actionInd, action in base.ipairs(actions) do
            --base.print('actionInd, action',actionInd, action.device.name);
            if (action.down == actionID) or (action.pressed == actionID) then
                return actionName, actions, action;
            end;
        end;
    end
end; 

function clearAllActionsEnvolvingReformer(reformerName)
    for ind, device in base.ipairs(devices) do
        local deviceName = device.name;
        local layout = getDeviceLayout(deviceName);
        for keyInd, command in base.pairs(layout.keyCommands or {}) do
            for comboInd, combo in base.pairs(command.combos or {}) do
                for reformerInd, reformer in base.pairs(combo.reformers or {}) do
                    if reformer == reformerName then
                        --combos[comboInd] = nil;
                        --base.print('removing key command',command.name);
                        base.table.remove(command.combos, comboInd);
                        break;
                    end;
                end;
            end;        
        end;
        for axisInd, command in base.pairs(layout.axisCommands or {}) do
            for comboInd, combo in base.pairs(command.combos or {}) do
                for reformerInd, reformer in base.pairs(combo.reformers or {}) do
                    if reformer == reformerName then
                        --combos[comboInd] = nil;
                        --base.print('removing axis command',command.name);
                        base.table.remove(command.combos, comboInd);
                        break;
                    end;
                end;
            end;        
        end;
    end;    
end; 

function getDeviceLayout(deviceName)
    local profile = aircrafts[form.containerControls.comboboxAircraft:getText()];
    local device = devicesByName[deviceName];
    local layout = getLayout(profile, device.deviceType);
    local devOptions = layout[device.name];
    return devOptions;
end; 


function validateLayout(layout, profileName)
    local invalidActions = {};
    local ALL_REFORMERS = collectAllReformers(profileName);    
    for keyInd, command in base.pairs(layout.keyCommands or {}) do
        for comboInd, combo in base.pairs(command.combos or {}) do
            for reformerInd, reformer in base.pairs(combo.reformers or {}) do
                if nil == ALL_REFORMERS[reformer]  then
                    command.valid = false;
                    base.table.insert(invalidActions, command);
                    break;
                end;
            end;
        end;        
    end;
    for axisInd, command in base.pairs(layout.axisCommands or {}) do
        for comboInd, combo in base.pairs(command.combos or {}) do
            for reformerInd, reformer in base.pairs(combo.reformers or {}) do
                if nil == ALL_REFORMERS[reformer] then
                    command.valid = false;
                    base.table.insert(invalidActions, command);
                    break;
                end;
            end;
        end;        
    end;   
    --base.print(#invalidActions .. ' invalid actions');
    return invalidActions;
end; 

function getDeviceOptions(device, profileName)
    local profile  = aircrafts[profileName];
    local deviceName = device.name;        
    local deviceType = device.deviceType;
    local layout = getLayout(profile, deviceType);
    local devOptions = layout[deviceName];
    if devOptions == nil then 
        devOptions = layout[defaultProfileName] or layout['default'];
    end;
    return devOptions;
end; 

function collectAllReformers(profileName)
    --base.print('collectAllReformers: profileName',profileName);
    local allReformers = {};
    local profile  = aircrafts[profileName];
    for j, device in base.ipairs(devices) do 
        local devOptions = getDeviceOptions(device, profileName)
        local t1 = collectReformers(devOptions, device);
        for k,v in base.pairs(t1) do
            if nil == allReformers[k] then
                allReformers[k] = v;
                --base.print('k,v',k,v);
            end;
        end;
    end;
    return allReformers;
end; 

function collectReformers(layout, device, useGlobal)
    local _MODIFIERS, _SWITCHES, _ALL_REFORMERS, _ALL_REFORMERS_CODES = {},{},{},{};
    if true == useGlobal then      
        _MODIFIERS, _SWITCHES, _ALL_REFORMERS, _ALL_REFORMERS_CODES = 
            MODIFIERS, SWITCHES, ALL_REFORMERS, ALL_REFORMERS_CODES; 
    end;
    
    if layout.modifiers then
        for modifierName, modifier in base.pairs(layout.modifiers) do
            --base.print('modifierName, modifier',modifierName, modifier);
            _ALL_REFORMERS[modifierName] = {
                value = modifier,
                device = device,
                };
            if not _MODIFIERS[modifierName] then
                _MODIFIERS[modifierName] = modifier;
            end;
        end;
    end;

    if layout.switches then
        for switchName,switch in base.pairs(layout.switches) do
            --ALL_REFORMERS[switcheName] = switch;
            _ALL_REFORMERS[switchName] = {
                value = switch,
                device = device,
                };
            if not _SWITCHES[switchName] then
                _SWITCHES[switchName] = switch;
            end;
        end;
    end;
    
    for reformerName,reformerValue in base.pairs(_ALL_REFORMERS) do
        --local k = sign * DEJOYSTICKN(joystickNumber, inputEvents[reformerValue.value]);
        local k = inputEvents[reformerValue.value];
        --local val = reformerName;
        if not _ALL_REFORMERS_CODES[k] then
            _ALL_REFORMERS_CODES[k] = reformerName;
            --base.print('reformerName, reformerValue, k',reformerName, ALL_REFORMERS_CODES[k], k);
        end;
    end;
    return _ALL_REFORMERS, _MODIFIERS, _SWITCHES,  _ALL_REFORMERS_CODES;
end; 

function resetSelection()
    --base.print('resetSelection');
    --base.U.stack();
    if form.containerControls then 
        local grid = form.containerControls.scrollgrid;
        if grid then
            for c = 1,grid:getColumnsCount() do
                for r = 1, grid:getRowsCount() do
                    local widget = grid:getCell(c,r)
                    if widget then
                        local theme = widget:getTheme();
                        theme.border = Theme.newEmptyBorder();
                        widget:setTheme(theme);
                    end;        
                end;
            end;    
        end;
    end;
end; 
--init();

function bindAspectCombo(name, controlDescription)
    local combo = bindControl(name, controlDescription)
    --base.U.traverseTable(controlDescription)
    combo:setText(aspectNumberToString(controlDescription.__value__) )
    
    function combo:onChange(item)
        local value = stringToAspectNumber(self:getText())
        if value then
            controlDescription.__value__ = value
        end
    end
end


function bindResolutionCombo(name, controlDescription)
    local combo = bindControl(name, controlDescription)
    
    function combo:onChange(item)
        local w = base.tonumber(base.string.match(item.itemId, '%d+'))
        local h = base.tonumber(base.string.match(item.itemId, '%d+$'))
        local aspect = w / h
        current.graphics.resolution.__value__ = item:getText()
        current.graphics.width.__value__ = w
        current.graphics.height.__value__ = h
        current.graphics.aspect.__value__ = aspect
        form.aspectCombo:setText(aspectNumberToString(aspect))
    end
end

function bindControl(name, controlDescription)
    function addItem(combo, itemName, id)
        --base.print('adding item', itemName, id)
        local item = combo:newItem(itemName)
        item:setTheme(Theme.newOptionsComboBoxItemTheme())
        item.itemId = id;
        combo:insertWidget(item)
    end;

    if controlDescription == nil then 
        base.print('controlDescription == nil, skipping', name)
        return;
    end;
    local controlType = controlDescription.control;
    if controlType == nil then
        --base.print('controlType == nil, skipping', name)
        return;
    end;
    
    local control;
    if controlType == 'combo' then
        --base.print('binding como', name, value)
        control = form[name .. "Combo"];
        if control then 
            control:clear();
            control:setReadonly(true);
            if controlDescription.values == nil then
                base.print('controlType.values == nil for ', name)
                return;
            end;

            for i, value in base.ipairs(controlDescription.values)  do
                --base.print('combo:', name, value.dispName, value.id);
                addItem(control, value.dispName, value.id);
                if controlDescription.__value__ == value.id then 
                    --base.print('combo text:', name, itemName, stringValue)
                    control:setText(value.dispName);
                end;
            end;
            control.onChange = function(self, itm)
                local value = itm.itemId
                controlDescription.__value__ = value;
            end
        else
            base.print(name .. "Combo", "not found")
            return;
        end;
        --return control;
    elseif controlType == 'check' then 
        --base.print('binding check: ' .. name  .. ' - ' ..  base.tostring(controlDescription.__value__))
        control = form[name .. "Checkbox"]
        if not control then 
            base.print(name .. "Checkbox", "not found")
            return;
        else			
            control:setState(controlDescription.__value__)
            control.onChange = function(self)
                controlDescription.__value__ = self:getState()
            end    
        end;
	elseif controlType == 'radio' then         
		for k, v in base.pairs(controlDescription.names) do
			control = form[v .. "RadioButton"]			
			--base.print('control=',v .. "RadioButton")
						
			control.onChange = function(self)				
				controlDescription.__value__ = controlDescription.values[v]
				--base.print('curBtn',controlDescription.curBtn,'__value__=',controlDescription.__value__)
			end				
		end    
		
		control = form[controlDescription.buttons[controlDescription.__value__] .. "RadioButton"]
		control:setState(true)
			
    elseif controlType == 'slider' then 
		--form.tabs[3].birdsSlider.onChange = birdsOnChange;
		--form.tabs[3].birdsSlider:setValue(current.difficulty.birds.__value__)
		--form.tabs[3].birdsWidget:setText(base.tostring(form.tabs[3].birdsSlider:getValue()..'%'))
        --base.print('binding slider', name)
        control = form[name .. "Slider"]
        if control then 
            control:setValue(controlDescription.__value__)
            local handler;
            if controlDescription.handler then 
                handler = getFunctionFromString(controlDescription.handler);
            end;
			
			if (name == 'birds') then			
				control.onChange = birdsOnChange;
				birdsOnChange();
--			elseif (name == '') then
--             control.onChange = lifetimeOnChange
--             lifetimeOnChange()
--             base.assert(nil, "")
         else
				if controlDescription.subtype == 'volume' then
					control.mute_at = -30
					control:setRange(control.mute_at, 0)
				end
				control.onChange = function(self)
					local val = self:getValue()
					if val == self.mute_at then val = -100 end
					controlDescription.__value__ = val
					--base.print(name, controlDescription.handler)
					if handler then
						handler(val)
					end
				end
			end
        else
            base.print(name .. "Slider", "not found")
            return;
        end;--]]
        --return control;
    else
        base.print('Unknown control type', controlType);
        return 
    end;
    
    if controlDescription.hidden == true then            
        control:setVisible(false);
        local labelName = name .. "Label"
        local label = form[labelName];
        if label then 
            label:setVisible(false)
        end;
        --base.print(name .. ' hidden', control, label);
    end;
    
    return control;
end;


--         
function prepareOptionsForSave(additionalOptions)
    function traverse(sourceTable, out, tabstr)
        --base.print('traverse:')
        for k,v in base.pairs(sourceTable) do
            --base.print(tabstr .. base.tostring(k),v)
            if ( base.type(v) == 'table' ) then 
                if ( v.__value__ == nil ) then
                    out[k] = {};
                    traverse(v, out[k], tabstr .. '  ');
                else
                    --base.print(tabstr ..  'writing value', v.__value__)
                    out[k] = v.__value__
                end;
            end;
        end;    
    end;

    local out = {};
    traverse(vdata , out, '');

    if (additionalOptions) then 
        base.U.recursiveCopyTable(out, additionalOptions)
    end;	
    
    return out;
end;


--        vdata
function loadSavedOptions(destinationTable, options)
    function traverse(srcTable, destTable)
        --base.print('traverse:', key)
        for k,v in base.pairs(srcTable) do
            --base.print(k,v)
            if destTable[k] == nil then
                base.print(base.string.format('Key "%s" not found in destination table', k))
            end;
            if ( base.type(v) == 'table' ) then 
                if ( v.__value__ == nil ) then
                    traverse(v, destTable[k]);
                else
                    --base.print( k, v, destTable[k] );
                    v.__value__ = destTable[k];
                end;
            end;
        end;    
    end;

    --  vdata     
    --      
    traverse(destinationTable, options);    
    return destinationTable;
end;

function getFunctionFromString(funName)
    local fun;
    local str = 'function fun() return base.' .. funName .. '; end;';
    local f, err = base.loadstring(str);
    if not f then 
        base.print('error loading chunk:', err);
        return
    else
        local env = {base = base};
        base.setfenv(f, env);
        f();
        --base.print('fun', env.fun())
        return env.fun();
    end;
end;

function getForcedOptionsDescription()
   -- base.U.traverseTable(vdata.difficulty)
    local tables = {vdata.difficulty, vdata.graphics, vdata.sound, vdata.views.cockpit}
    local forcedOptions = {};
    for i, tbl in base.ipairs(tables) do
        for controlName, controlDescription in base.pairs(tbl) do 
            --base.print('binding', controlName, controlDescription)
            if controlDescription.enforceable == true then   
                forcedOptions[controlName] = controlDescription;
            end;
        end;
    end;
    return forcedOptions;
end;

function getForcedOptions()
    return forcedOptions;
end;

function setForcedOptions(options)	
    forcedOptions = options;
end;


function getOptions()
    return prepareOptionsForSave();
end;

function enforceOptions()
    function traverse(srcTable, destTable)
        --base.print('traverse:', key)
        for k,v in base.pairs(srcTable) do
            --base.print(k,v)
            if ( base.type(v) == 'table' ) then 
                if ( v.__value__ == nil ) then
                    destTable[k] = {};
                    traverse(v, destTable[k]);
                else
                    --base.print( k, v );
                    if (v.enforceable == true) and (forcedOptions[k] ~= nil) then
                        --base.print('Enforcing:', k, v, forcedOptions[k]);
                        destTable[k] = forcedOptions[k];
                    else
                        --base.print('Leaving as is:', k, v.__value__);
                        destTable[k] = v.__value__;
                    end;
                end;
            end;
        end;    
    end;

    local enforcedOptions = {};
    
    if vdata.difficulty.setGlobal.__value__ == false then
        traverse(vdata, enforcedOptions);    
        return enforcedOptions;
    else
        return prepareOptionsForSave();
    end;
end;
