dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")

std_message_timeout = 15

local t_start = 0.0
local t_stop = 0.0
local delta_t_com = 2.0

local dt = 0.2 -- Default interval between commands in the stack.
local dt_mto = 10.0 -- Default message timeout time.
local apu_start_time = 25 -- APU takes 25s to start.
local engine_start_time = 55 -- Engines take 55s each to start.
local engine_spool_time = 10 -- After engines are started, takes 10s to spool up when collective grip is twisted to max.
--local stop_sequence_time = 10.0 -- TODO: timeout

start_sequence_full = {}
stop_sequence_full = {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] = command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full,t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full,t_stop, command)
end

NO_FUEL = 1
COLLECTIVE = 2
BATTERY_LOW = 3
APU_START_FAULT = 4
FUEL_PUMP_FAULT = 5
LEFT_ENGINE_START_FAULT = 6
RIGHT_ENGINE_START_FAULT = 7

alert_messages = {}
alert_messages[COLLECTIVE] = {message = _("SET THE COLLECTIVE STICK DOWN"), message_timeout = 10}
alert_messages[NO_FUEL] = {message = _("CHECK FUEL QUANTITY"), message_timeout = 10}
alert_messages[BATTERY_LOW] = {message = _("POWER SUPPLY FAULT. CHECK THE BATTERY"), message_timeout = 10}
alert_messages[APU_START_FAULT] = {message = _("AI-9 NOT READY TO START ENGINE"), message_timeout = 10}
alert_messages[FUEL_PUMP_FAULT] = {message = _("FEEDING FUEL TANK PUMP FAULT"), message_timeout = 10}
alert_messages[LEFT_ENGINE_START_FAULT] = {message = _("LEFT ENGINE START FAULT"), message_timeout = 10}
alert_messages[RIGHT_ENGINE_START_FAULT] = {message = _("RIGHT ENGINE START FAULT"), message_timeout = 10}


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Start sequence
local function doStartSequence()
	push_start_command(0.0, {message = _("HAVOC'S QUICK AUTOSTART IS RUNNING"), message_timeout = dt_mto}) -- Message text and timeout will be modified by insertTimeRemaining function below.

	push_start_command(dt, {message = _("Cockpit Doors - Close"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.CPT_MECH, action = cockpit_mechanics_commands.Command_CPT_MECH_GENERAL_DOORS_CLOSE, value = 0.0})

	push_start_command(dt, {message = _("Left Engine Stop lever - OFF"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.LEVER_Left_Engine_Lock, value = 0.0})
	push_start_command(dt, {message = _("Right Engine Stop lever - OFF"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.LEVER_Right_Engine_Lock, value = 0.0})
	push_start_command(dt, {message = _("Rotor Brake - OFF"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.LEVER_Rotor_Lock, value = 0.0})

	push_start_command(dt, {action = Keys.iCommand_PlaneAUTDecreaseRegime})
	push_start_command(dt, {action = Keys.iCommand_PlaneAUTDecreaseRegime})
	push_start_command(dt, {message = _("Engine Throttles - Auto"), message_timeout = dt_mto})
	push_start_command(dt, {action = Keys.iCommand_PlaneAUTIncreaseRegime})
	push_start_command(dt, {message = _("Collective Throttle - Set to min (DECR, left)"), message_timeout = dt_mto})
	push_start_command(dt, {action = Keys.iCommand_ThrottleDecrease})
	push_start_command(4.0, {action = Keys.iCommand_ThrottleStop})
	push_start_command(dt, {message = _("Collective lever - Full Down"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.COLLECTIVE, value = -1.0})

	-- Electric Power
	push_start_command(dt, {message = _("Right Battery - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.BatteryRight, value = 1.0})
	push_start_command(dt, {message = _("Left Battery - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.BatteryLeft, value = 1.0})
	push_start_command(dt, {message = _("DC Voltmeter knob - BATT"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.DCGangSwitcher, value = 0.22}) -- Steps are 1/9 or 0.1111... in size.
	push_start_command(dt, {message = _("Inverter PO-750A - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Rotary115vConverterCover, value = 1.0}) -- Cover open
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Rotary115vConverter, value = 1.0}) -- Switch
	push_start_command(dt, {message = _("Left CBs - ON (gang bar)"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.CB_FRAME_LEFT, value = 1.0})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.CB_FRAME_LEFT, value = 0.0})
	push_start_command(dt, {message = _("Right CBs - ON (gang bar)"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.CB_FRAME_RIGHT, value = 1.0})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.CB_FRAME_RIGHT, value = 0.0})

	-- POWER FROM BATT (Network To Batteries) - Powers onboard systems from batteries?
	push_start_command(dt, {message = _("Power From Batt (Network To Batteries) switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.NetworkToBatteriesCover, value = 1.0}) -- Cover open
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.NetworkToBatteries, value = 1.0}) -- Switch

	-- Hydraulic system (starts on MAIN)
	--push_start_command(dt, {message = _("Main/Auxiliary Hydraulic Switch - MAIN"), message_timeout = dt_mto})
	--push_start_command(dt, {device = devices.HYDRO_SYS_INTERFACE, action = hydraulic_commands.MainHydroCover, value = 1.0})
	--push_start_command(dt, {device = devices.HYDRO_SYS_INTERFACE, action = hydraulic_commands.MainHydro, value = 1.0})
	--push_start_command(dt, {device = devices.HYDRO_SYS_INTERFACE, action = hydraulic_commands.MainHydroCover, value = 0.0})

	-- Seal and pressurize cabin
	push_start_command(dt, {message = _("Cabin Press valve - OPEN (CCW)"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ECS_INTERFACE, action = ecs_commands.Sealing_valve, value = 0.0})
	push_start_command(dt, {message = _("Cabin Depress switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ECS_INTERFACE, action = ecs_commands.CabinUnseal, value = 1.0})
	push_start_command(dt, {message = _("Blowdown Conditioning switch - CONDITION"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ECS_INTERFACE, action = ecs_commands.BlowdownConditioning, value = 1.0})

	-- Fuel System
	push_start_command(dt, {message = _("Service (Feed) Tanks 1 switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveTank1, value = 1.0})
	push_start_command(dt, {message = _("Service (Feed) Tanks 2 switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveTank2, value = 1.0})
	push_start_command(dt, {message = _("Fuel Shutoff Left switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveLeftEngineCover, value = 1.0}) -- Cover open
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveLeftEngine, value = 1.0}) -- Switch
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveLeftEngineCover, value = 0.0}) -- Cover close
	push_start_command(dt, {message = _("Fuel Shutoff Right switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveRightEngineCover, value = 1.0}) -- Cover open
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveRightEngine, value = 1.0}) -- Switch
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveRightEngineCover, value = 0.0}) -- Cover close
	push_start_command(dt, {message = _("Fuel Crossfeed (Delimiter) switch - ON"), message_timeout = dt_mto}) -- "Fuel Delimiter Valve"
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE,action =  fuel_commands.ValveDelimiter, value = 1.0})
	push_start_command(dt, {message = _("Service Tank Pumps 1, 2, 4, and 5 switches - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank1Pump, value = 1.0})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank2Pump, value = 1.0})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank4Pump, value = 1.0})
	push_start_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank5Pump, value = 1.0})

	-- Fire Extinguisher
	push_start_command(dt, {message = _("Fire Extinguisher Power switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.Power, value = 1.0})
	push_start_command(dt, {message = _("Fire Extinguisher Control switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.SensorControl, value = 1.0})
	--push_start_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.Pyro1, value = 1.0})
	--push_start_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.Pyro1, value = 0.0})
	--push_start_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.Pyro2, value = 1.0})
	--push_start_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.Pyro2, value = 0.0})

	-- Start APU
	push_start_command(dt, {message = _("Starting APU (25s)"), message_timeout = apu_start_time})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_APU_Launch_Method, value = -1.0, check_condition = FUEL_PUMP_FAULT})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_APU_StartUp, value = 1.0}) -- Press
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_APU_StartUp, value = 0.0}) -- Release
	push_start_command(apu_start_time, {check_condition = APU_START_FAULT})
	
	-- Start Left Engine
	push_start_command(dt, {message = _("Starting Left Engine (55s)"), message_timeout = engine_start_time})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_Engine_Launch_Method, value = 0.0})
	push_start_command(dt, {message = _("Engine Start switch -- LEFT"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_Engine_Select, value = 1.0, check_condition = COLLECTIVE})
	push_start_command(dt, {message = _("Engine Start button -- Press"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_Engine_StartUp, value = 1.0}) -- Press
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_Engine_StartUp, value = 0.0}) -- Release
	push_start_command(engine_start_time, {check_condition = LEFT_ENGINE_START_FAULT})

	-- Start Right Engine
	push_start_command(dt, {message = _("Starting Right Engine (55s)"), message_timeout = engine_start_time})
	push_start_command(dt, {message = _("Engine Start switch -- RIGHT"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_Engine_Select, value = 0.0})
	push_start_command(dt, {message = _("Engine Start button -- Press"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_Engine_StartUp, value = 1.0}) -- Press
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_Engine_StartUp, value = 0.0}) -- Release
	push_start_command(engine_start_time, {check_condition = RIGHT_ENGINE_START_FAULT})

	-- Spool Up
	push_start_command(dt, {message = _("Collective Throttle - Set to max (INCR, right)"), message_timeout = dt_mto})
	push_start_command(dt, {action = Keys.iCommand_ThrottleIncrease})
	push_start_command(4.0, {action = Keys.iCommand_ThrottleStop})
	push_start_command(engine_spool_time, {message = _("Engines Spooled Up"), message_timeout = dt_mto})

	-- Generators and other electrics
	push_start_command(dt, {message = _("Left Generator switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.ACGeneratorLeft, value = 1.0})
	push_start_command(dt, {message = _("Right Generator switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.ACGeneratorRight, value = 1.0})
	push_start_command(dt, {message = _("115V Transformer switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Transformer115vMainBackup, value = 1.0})
	push_start_command(dt, {message = _("36V Transformer switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Transformer36vMainBackup, value = 1.0})
	push_start_command(dt, {message = _("Left Rectifier switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.RectifierLeft, value = 1.0})
	push_start_command(dt, {message = _("Right Rectifier switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.RectifierRight, value = 1.0})
	push_start_command(dt, {message = _("AC Voltmeter knob - LEFT GENERATORS C-A"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.ACGangSwitcher, value = 0.5})
	push_start_command(dt, {message = _("Inverter PO-750A - OFF"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Rotary115vConverter, value = 0.0}) -- Switch
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Rotary115vConverterCover, value = 0.0}) -- Cover close

	push_start_command(dt, {message = _("APU Stop button - Press"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_APU_Stop, value = 1.0})
	push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.STARTUP_APU_Stop, value = 0.0})

	push_start_command(dt, {message = _("Power From Batt (Network To Batteries) switch - OFF"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.NetworkToBatteries, value = 0.0}) -- Switch
	push_start_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.NetworkToBatteriesCover, value = 0.0}) -- Cover close

	-- Left Panel switches
	push_start_command(dt, {message = _("SPUU (Tail Roter Pitch Limiter) Power switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SPUU_52, action = spuu_commands.On_Off, value = 1.0})
	push_start_command(dt, {message = _("Radar Altimeter (RV-5) Power switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.RADAR_ALTIMETER, action = ralt_commands.POWER, value = 1.0})
	push_start_command(dt, {message = _("Doppler (DISS-15) switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.DISS_15, action = diss_commands.POWER, value = 1.0})
	push_start_command(dt, {message = _("Vert Gyro 1 switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.MGV1SU_1, action = mgv1su_commands.POWER, value = 1.0})
	push_start_command(dt, {message = _("Vert Gyro 2 switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.MGV1SU_2, action = mgv1su_commands.POWER, value = 1.0})
	push_start_command(dt, {message = _("Vert Gyro 1 Cage button - Press for 2 seconds"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.MGV1SU_1, action = mgv1su_commands.CAGE, value = 1.0}) -- Press
	push_start_command(2.0, {device = devices.MGV1SU_1, action = mgv1su_commands.CAGE, value = 0.0}) -- Release
	push_start_command(dt, {message = _("Vert Gyro 2 Cage button - Press for 2 seconds"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.MGV1SU_2, action = mgv1su_commands.CAGE, value = 1.0}) -- Press
	push_start_command(2.0, {device = devices.MGV1SU_2, action = mgv1su_commands.CAGE, value = 0.0}) -- Release
	push_start_command(dt, {message = _("Comp. System (GREBEN) switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.GREBEN, action = greben_commands.POWER, value = 1.0})
	--push_start_command(1.0,{device = devices.KM_2, action =  avKM_2_commands.calc_magn_var, value = 1.0, message = _("set magnetic declination on KM-2"), message_timeout = std_message_timeout}) -- This is done automatically by Petrovich??
	push_start_command(dt, {message = _("Intercom (SPU-8) Network 1 switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SPU_8, action = SPU_8_Mi24_commands.CMD_SPU8_NETWORK_1, value = 1.0})
	push_start_command(dt, {message = _("Intercom (SPU-8) Network 2 switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SPU_8, action = SPU_8_Mi24_commands.CMD_SPU8_NETWORK_2, value = 1.0})
	push_start_command(dt, {message = _("HF Radio (JADRO-1A) switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.JADRO_1I, action = jadro_commands.POWER, value = 1.0})
	push_start_command(dt, {message = _("R-828 Radio switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.EUCALYPT_M24, action = eucalypt_commands.POWER_ON_OFF2, value = 1.0})
	push_start_command(dt, {message = _("R-863 Radio switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.R_863, action = r863_commands.POWER, value = 1.0})
	push_start_command(dt, {message = _("Blink (Flasher) switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.INT_LIGHTS_SYSTEM, action = int_lights_commands.BlinkerSystem, value = 1.0})
	
	-- IFF
	push_start_command(dt, {message = _("IFF switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.IFF, action = IFF_6201_commands.CMD_IFF_Power_Sw, value = 1.0})
	
	-- JADRO-1A Radio
	push_start_command(dt, {message = _("JADRO-1A Radio Mode knob - AM"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.JADRO_1I, action = jadro_commands.MODE, value = 0.2}) -- 0.0 = OFF, 0.1 = STB (SSB), 0.2 = AM
	
	-- RWR
	push_start_command(dt, {message = _("RWR switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SPO_10, action = SPO_commands.Command_SPO_POWER, value = 1.0})
	
	-- PU-38 GREBEN compass system
	push_start_command(dt, {message = _("GREBEN Tune/Oper switch - OPER"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.GREBEN, action = greben_commands.SETUP_OPER, value = 1.0})
	push_start_command(dt, {message = _("GREBEN Match (Sync) button - Press for 3 seconds"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.GREBEN, action = greben_commands.Match, value = 1.0})
	push_start_command(3.0, {device = devices.GREBEN, action = greben_commands.Match, value = 0.0})
	push_start_command(dt, {message = _("GREBEN Mode switch - GYRO"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.GREBEN, action = greben_commands.MODE, value = 0.0})
	
	-- Autopilot
	push_start_command(dt, {message = _("Autopilot Roll Channel button - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.AUTOPILOT, action = autopilot_commands.ButtonKon, value = 1.0}) -- Press
	push_start_command(dt, {device = devices.AUTOPILOT, action = autopilot_commands.ButtonKon, value = 0.0}) -- Release
	push_start_command(dt, {message = _("Autopilot Pitch Channel button - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.AUTOPILOT, action = autopilot_commands.ButtonTon, value = 1.0}) -- Press
	push_start_command(dt, {device = devices.AUTOPILOT, action = autopilot_commands.ButtonTon, value = 0.0}) -- Release

	-- Gunsight and Weapons Panel
	push_start_command(dt, {message = _("Sight Power switch - ON"), message_timeout = dt_mto}) -- Weapons panel.
	push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Power, value = 1.0})
	push_start_command(dt, {message = _("Range Insert switch - AUTO"), message_timeout = dt_mto}) -- Weapons panel.
	push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Range_Auto_Manual, value = 1.0})
	push_start_command(dt, {message = _("Sight (Ranging) Mode switch - AUTO"), message_timeout = dt_mto}) -- Sight base.
	push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Manual_Auto, value = 1.0})
	push_start_command(dt, {message = _("Sync/Async switch - ASYNC"), message_timeout = dt_mto}) -- Sight base.
	push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Sync_Async, value = 0.0})
	push_start_command(dt, {message = _("Fire Ctrl (Master Arm) switch - ON"), message_timeout = dt_mto}) -- Weapons panel.
	push_start_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Pilot_SWITCHER_FIRE_CONTROL, value = 1.0})
	push_start_command(dt, {message = _("MG Rate (Cannon ROF) switch - INCR"), message_timeout = dt_mto}) -- Weapons panel
	push_start_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Pilot_TEMP_NPU30, value = 1.0})
	push_start_command(dt, {message = _("Fixed Crosshair Brightness - 20%"), message_timeout = dt_mto}) -- Sight base.
	push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Brightness_NS, value = 0.2})
	push_start_command(dt, {message = _("Aux Stores Lights switch - ON")}) -- Right angled panel bottom.
	push_start_command(dt, {device = devices.INT_LIGHTS_SYSTEM, action = int_lights_commands.SpecialEquipmentPanelRedLights, value = 1.0})

	-- Gunsight reflector NOTE No longer needed, gunsight now starts in this position in cold start.
	--push_start_command(dt, {message = _("GUNSIGHT REFLECTOR - ADJUST DOWN"), message_timeout = dt_mto})
	--push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Reflector_Fix, value = 1.0}) -- Unlock sight reflector.
	--for i = 0, 7, 1 do
	--	push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Reflector_Move_Down_EXT, value = 1.0})
	--end
	--push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.Reflector_Fix, value = 0.0}) -- Lock sight reflector.

	-- Pilot-Operator (front) seat
	push_start_command(dt, {message = _("Setting up Pilot-Operator switches..."), message_timeout = dt_mto})
	push_start_command(dt, {message = _("Intercom (SPU-8) Power switch - ON"), message_timeout = dt_mto}) -- Popup switch label says "SPUU Power ON/OFF" but I think that's wrong...
	push_start_command(dt, {device = devices.SPU_8, action = SPU_8_Mi24_commands.CMD_SPU8_O_ICS, value = 1.0})
	push_start_command(dt, {message = _("Safety Switches (Master Arm) gang bar - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_SWITCHER_SAFE_WEAP, value = 1.0})
	push_start_command(dt, {message = _("Missile Power switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_URS_POWER, value = 1.0})
	push_start_command(dt, {message = _("FDI (ADI) switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.PKP72M_INTERFACE, action = pkp72m_interface_commands.PKP72MoperatorSwitch, value = 1.0})
	push_start_command(dt, {message = _("Cplr/Distr switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.ASP_17V, action = asp_commands.USR, value = 1.0})
	push_start_command(dt, {message = _("Missile Station Selector (SCHO) power switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_POWER_SHO_SWITCHER, value = 1.0})
	push_start_command(dt, {message = _("Guid. Unit Power switch - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.I9K113, action = i9K113_commands.Command_POWER_PN, value = 1.0})
	push_start_command(dt, {message = _("Burst Length - SHORT"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_CHAIN_LENGTH_SHORT_MED_LONG, value = 1.0})
	push_start_command(dt, {message = _("Fxd MG-30 Rate (Cannon ROF) switch - INCR"), message_timeout = dt_mto}) -- Weapons panel
	push_start_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_OPERATOR_RATE_MORE, value = 1.0})
	--push_start_command(dt, {device = devices.I9K113, action = i9K113_commands.Command_NABL, value = 1.0}) -- OBSERVE
	--push_start_command(dt, {device = devices.I9K113, action = i9K113_commands.Command_STVORKI, value = 1.0}) -- Sight Doors
	push_start_command(dt, {message = _("Done with Pilot-Operator switches"), message_timeout = dt_mto})

	-- RWR test beep
	push_start_command(dt, {message = _("RWR test beep"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.SPO_10, action = SPO_commands.Command_SPO_SIGNAL, value = 1.0}) -- Turn on RWR audio
	push_start_command(dt, {device = devices.SPO_10, action = SPO_commands.Command_SPO_CHECK, value = 1.0}) -- Press (makes a beep)
	push_start_command(dt, {device = devices.SPO_10, action = SPO_commands.Command_SPO_CHECK, value = 0.0}) -- Release
	push_start_command(dt, {device = devices.SPO_10, action = SPO_commands.Command_SPO_SIGNAL, value = 0.0}) -- Turn off RWR audio

	-- Fans
	push_start_command(dt, {message = _("Pilot and Operator Fans - ON"), message_timeout = dt_mto})
	push_start_command(dt, {device = devices.CPT_MECH, action = cockpit_mechanics_commands.Command_CPT_MECH_FAN_PILOT, value = 1.0})
	push_start_command(dt, {device = devices.CPT_MECH, action = cockpit_mechanics_commands.Command_CPT_MECH_FAN_OPERATOR, value = 1.0})

	push_start_command(dt, {message = _("HAVOC'S QUICK AUTOSTART IS COMPLETE"), message_timeout = 60.0})
	push_start_command(dt, {message = _("Manual steps remaining:"), message_timeout = 60.0})
	push_start_command(dt, {message = _("Lights ... As needed"), message_timeout = 60.0})
	push_start_command(dt, {message = _("Radios ... As needed"), message_timeout = 60.0})
	push_start_command(dt, {message = _("Navigation ... As needed"), message_timeout = 60.0})
	push_start_command(dt, {message = _("Altimeter ... Set to match QFE (airfield elevation) or QNH (sea level altitude) as desired"), message_timeout = 60.0})
end
doStartSequence()


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
local function doStopSequence()
	push_stop_command(0.0, {message = _("HAVOC'S QUICK AUTOSTOP IS RUNNING"), message_timeout = dt_mto}) -- Message text and timeout will be modified by insertTimeRemaining function below.

	push_stop_command(dt, {message = _("Blink (Flasher) switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.INT_LIGHTS_SYSTEM, action = int_lights_commands.BlinkerSystem, value = 0.0})
	push_stop_command(dt, {message = _("SPUU (Tail Roter Pitch Limiter) Power switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SPUU_52, action = spuu_commands.On_Off, value = 0.0})
	push_stop_command(dt, {message = _("Radar Altimeter (RV-5) Power switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.RADAR_ALTIMETER, action = ralt_commands.POWER, value = 0.0})
	push_stop_command(dt, {message = _("Doppler (DISS-15) switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.DISS_15, action = diss_commands.POWER, value = 0.0})
	push_stop_command(dt, {message = _("Vert Gyro 1 switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.MGV1SU_1, action = mgv1su_commands.POWER, value = 0.0})
	push_stop_command(dt, {message = _("Vert Gyro 2 switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.MGV1SU_2, action = mgv1su_commands.POWER, value = 0.0})
	
	-- PU-38 GREBEN compass system
	push_stop_command(dt, {message = _("Comp. System (GREBEN) switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.GREBEN, action = greben_commands.POWER, value = 0.0})
	push_stop_command(dt, {message = _("GREBEN Tune/Oper switch - OPER"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.GREBEN, action = greben_commands.SETUP_OPER, value = 1.0})
	push_stop_command(dt, {message = _("GREBEN Mode switch - MAG"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.GREBEN, action = greben_commands.MODE, value = -1.0}) -- 0.0 = GYRO, 1.0 = ??
		
	push_stop_command(dt, {message = _("Intercom (SPU-8) Network 1 switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SPU_8, action = SPU_8_Mi24_commands.CMD_SPU8_NETWORK_1, value = 0.0, })
	push_stop_command(dt, {message = _("Intercom (SPU-8) Network 2 switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SPU_8, action = SPU_8_Mi24_commands.CMD_SPU8_NETWORK_2, value = 0.0})
	push_stop_command(dt, {message = _("HF Radio (JADRO-1A) switch - ON"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.JADRO_1I, action = jadro_commands.POWER, value = 0.0})
	push_stop_command(dt, {message = _("R-828 Radio switch - ON"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.EUCALYPT_M24, action = eucalypt_commands.POWER_ON_OFF2, value = 0.0})
	push_stop_command(dt, {message = _("R-863 Radio switch - ON"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.R_863, action = r863_commands.POWER, value = 0.0})
	
	-- JADRO-1A Radio
	push_stop_command(dt, {message = _("JADRO-1A Radio Mode knob - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.JADRO_1I, action = jadro_commands.MODE, value = 0.0}) -- 0.0 = OFF, 0.1 = STB (SSB), 0.2 = AM

	-- IFF
	push_stop_command(dt, {message = _("IFF switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.IFF, action = IFF_6201_commands.CMD_IFF_Power_Sw, value = 0.0})
	
	-- RWR
	push_stop_command(dt, {message = _("RWR switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.SPO_10, action = SPO_commands.Command_SPO_POWER, value = 0.0})

	--push_stop_command(dt, {device = devices.EXT_LIGHTS_SYSTEM, action = ext_lights_commands.NavLtSwitch, value = 0.0})
	--push_stop_command(dt, {device = devices.EXT_LIGHTS_SYSTEM, action = ext_lights_commands.FormationLights, value = 0.0})
	--push_stop_command(dt, {device = devices.EXT_LIGHTS_SYSTEM, action = ext_lights_commands.TipLights, value = 0.0})
	--push_stop_command(dt, {device = devices.EXT_LIGHTS_SYSTEM, action = ext_lights_commands.StrobeLight, value = 0.0})
	
	-- Gunsight and Weapons Panel
	push_stop_command(dt, {message = _("Sight Power switch - OFF"), message_timeout = dt_mto}) -- Weapons panel.
	push_stop_command(dt, {device = devices.ASP_17V, action = asp_commands.Power, value = 0.0})
	push_stop_command(dt, {message = _("Range Insert switch - MAN"), message_timeout = dt_mto}) -- Weapons panel.
	push_stop_command(dt, {device = devices.ASP_17V, action = asp_commands.Range_Auto_Manual, value = 0.0})
	push_stop_command(dt, {message = _("Sight (Ranging) Mode switch - MAN"), message_timeout = dt_mto}) -- Sight base.
	push_stop_command(dt, {device = devices.ASP_17V, action = asp_commands.Manual_Auto, value = 0.0})
	push_stop_command(dt, {message = _("Sync/Async switch - ASYNC"), message_timeout = dt_mto}) -- Sight base.
	push_stop_command(dt, {device = devices.ASP_17V, action = asp_commands.Sync_Async, value = 0.0})
	push_stop_command(dt, {message = _("Fire Ctrl (Master Arm) switch - OFF"), message_timeout = dt_mto}) -- Weapons panel.
	push_stop_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Pilot_SWITCHER_FIRE_CONTROL, value = 0.0})
	push_stop_command(dt, {message = _("Fixed Crosshair Brightness - 100%"), message_timeout = dt_mto}) -- Sight base.
	push_stop_command(dt, {device = devices.ASP_17V, action = asp_commands.Brightness_NS, value = 1.0})
	push_stop_command(dt, {message = _("Aux Stores Lights switch - OFF")}) -- Right angled panel bottom.
	push_stop_command(dt, {device = devices.INT_LIGHTS_SYSTEM, action = int_lights_commands.SpecialEquipmentPanelRedLights, value = 0.0})


	-- Pilot-Operator (front) seat
	push_stop_command(dt, {message = _("Turning off Pilot-Operator switches..."), message_timeout = dt_mto})
	push_stop_command(dt, {message = _("Intercom (SPU-8) Power switch - OFF"), message_timeout = dt_mto}) -- Popup switch label says "SPUU Power ON/OFF" but I think that's wrong...
	push_stop_command(dt, {device = devices.SPU_8, action = SPU_8_Mi24_commands.CMD_SPU8_O_ICS, value = 0.0})
	push_stop_command(dt, {message = _("Safety Switches (Master Arm) gang bar - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_SWITCHER_SAFE_WEAP, value = 0.0})
	push_stop_command(dt, {message = _("Missile Power switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_URS_POWER, value = 0.0})
	push_stop_command(dt, {message = _("FDI (ADI) switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.PKP72M_INTERFACE, action = pkp72m_interface_commands.PKP72MoperatorSwitch, value = 0.0})
	push_stop_command(dt, {message = _("Cplr/Distr switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ASP_17V, action = asp_commands.USR, value = 0.0})
	push_stop_command(dt, {message = _("Missile Station Selector (SCHO) power switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.WEAP_SYS, action = weapon_commands.Operator_POWER_SHO_SWITCHER, value = 0.0})
	push_stop_command(dt, {message = _("Guid. Unit Power switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.I9K113, action = i9K113_commands.Command_POWER_PN, value = 0.0})
	push_stop_command(dt, {message = _("Done with Pilot-Operator switches"), message_timeout = dt_mto})

	-- Generators and other electrics
	push_stop_command(dt, {message = _("Left Generator switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.ACGeneratorLeft, value = 0.0})
	push_stop_command(dt, {message = _("Right Generator switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.ACGeneratorRight, value = 0.0})
	push_stop_command(dt, {message = _("115V Transformer switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Transformer115vMainBackup, value = 0.0})
	push_stop_command(dt, {message = _("36V Transformer switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Transformer36vMainBackup, value = 0.0})
	push_stop_command(dt, {message = _("Left Rectifier switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.RectifierLeft, value = 0.0})
	push_stop_command(dt, {message = _("Right Rectifier switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.RectifierRight, value = 0.0})
	push_stop_command(dt, {message = _("AC Voltmeter knob - LEFT GENERATORS C-A"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.ACGangSwitcher, value = 0.5})
	--push_stop_command(dt, {message = _("Inverter PO-750A - OFF"), message_timeout = dt_mto})
	--push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Rotary115vConverter, value = 0.0}) -- Switch
	--push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.Rotary115vConverterCover, value = 0.0}) -- Cover close
	
	push_stop_command(dt, {message = _("Collective Throttle - Set to min (DECR, left)"), message_timeout = dt_mto})
	push_stop_command(dt, {action = Keys.iCommand_ThrottleDecrease})
	push_stop_command(4.0, {action = Keys.iCommand_ThrottleStop})
	
	push_stop_command(dt, {message = _("Wait for engines to spool down (5s)"), message_timeout = dt_mto})
	push_stop_command(5.0, {message = _("Engines spooled down"), message_timeout = dt_mto})

	push_stop_command(dt, {message = _("Left Engine Stop lever - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.LEVER_Left_Engine_Lock, value = 0.0})
	push_stop_command(dt, {message = _("Right Engine Stop lever - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.LEVER_Right_Engine_Lock, value = 0.0})

	-- Fuel System
	push_stop_command(dt, {message = _("Service (Feed) Tanks 1 switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveTank1, value = 0.0})
	push_stop_command(dt, {message = _("Service (Feed) Tanks 2 switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveTank2, value = 0.0})
	push_stop_command(dt, {message = _("Fuel Shutoff Left switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveLeftEngineCover, value = 1.0}) -- Cover open
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveLeftEngine, value = 0.0}) -- Switch
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveLeftEngineCover, value = 0.0}) -- Cover close
	push_stop_command(dt, {message = _("Fuel Shutoff Right switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveRightEngineCover, value = 1.0}) -- Cover open
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveRightEngine, value = 0.0}) -- Switch
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.ValveRightEngineCover, value = 0.0}) -- Cover close
	push_stop_command(dt, {message = _("Fuel Crossfeed (Delimiter) switch - OFF"), message_timeout = dt_mto}) -- "Fuel Delimiter Valve"
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE,action =  fuel_commands.ValveDelimiter, value = 0.0})
	push_stop_command(dt, {message = _("Service Tank Pumps 1, 2, 4, and 5 switches - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank1Pump, value = 0.0})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank2Pump, value = 0.0})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank4Pump, value = 0.0})
	push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = fuel_commands.Tank5Pump, value = 0.0})

	-- Fire Extinguisher
	push_stop_command(dt, {message = _("Fire Extinguisher Power switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.Power, value = 0.0})
	push_stop_command(dt, {message = _("Fire Extinguisher Control switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = fire_commands.SensorControl, value = 0.0})
	
	-- LH CBs off
	push_stop_command(dt, {message = _("Left CBs (29x) - OFF"), message_timeout = dt_mto})
	for i = elec_commands.CB_LEFT_HOMING_MISSILE_POWER, elec_commands.CB_LEFT_HOMING_MISSILE_POWER + 28, 1 do
		push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = i, value = 0.0})
	end
	-- RH CBs off
	push_stop_command(dt, {message = _("Right CBs (30x) - OFF"), message_timeout = dt_mto})
	for i = elec_commands.CB_RIGHT_CONTROL_FORCE_MECHANISM, elec_commands.CB_RIGHT_CONTROL_FORCE_MECHANISM + 29, 1 do
		push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = i, value = 0.0})
	end

	push_stop_command(dt, {message = _("Wait for rotor to spool down (65s)"), message_timeout = dt_mto})
	push_stop_command(65.0, {message = _("Rotor Brake - ON"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = engine_commands.LEVER_Rotor_Lock, value = 1.0})
	
	-- Unseal and depressurize cabin
	push_stop_command(dt, {message = _("Cabin Press valve - Close (CW)"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ECS_INTERFACE, action = ecs_commands.Sealing_valve, value = 1.0})
	push_stop_command(dt, {message = _("Cabin Depress switch - ON"), message_timeout = dt_mto}) -- FIXME Startup and shutdown both put this in the ON position... What should it be set to?
	push_stop_command(dt, {device = devices.ECS_INTERFACE, action = ecs_commands.CabinUnseal, value = 1.0})
	push_stop_command(dt, {message = _("Blowdown Conditioning switch - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ECS_INTERFACE, action = ecs_commands.BlowdownConditioning, value = 0.0})
	
	push_stop_command(dt, {message = _("Cockpit Doors - Open"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.CPT_MECH, action = cockpit_mechanics_commands.Command_CPT_MECH_GENERAL_DOORS_CLOSE, value = 1.0})
	
	-- Fans
	push_stop_command(dt, {message = _("Pilot and Operator Fans - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.CPT_MECH, action = cockpit_mechanics_commands.Command_CPT_MECH_FAN_PILOT, value = 0.0})
	push_stop_command(dt, {device = devices.CPT_MECH, action = cockpit_mechanics_commands.Command_CPT_MECH_FAN_OPERATOR, value = 0.0})
	
	-- Electric Power
	push_stop_command(dt, {message = _("Right Battery - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.BatteryRight, value = 0.0})
	push_stop_command(dt, {message = _("Left Battery - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.BatteryLeft, value = 0.0})
	push_stop_command(dt, {message = _("DC Voltmeter knob - OFF"), message_timeout = dt_mto})
	push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = elec_commands.DCGangSwitcher, value = 0.0}) -- Steps are 1/9 or 0.1111... in size.
	
	push_stop_command(dt, {message = _("HAVOC'S QUICK AUTOSTOP IS COMPLETE"), message_timeout = 60.0})
end
doStopSequence()


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Inserts messages into the sequence that show how many minutes there are remaining in the sequence.  Adds " (XmXs)" time display to the end of the first item in the sequence (which must be a message, and is by default).  Sets the message timeout of the first item to be the total time.
local function insertTimeRemaining(sequence, endingTime)
	local totalTime = math.ceil(endingTime) -- Round up to the next whole second.
	local totalTimeMins = math.floor(totalTime / 60)
	local totalTimeSecs = totalTime % 60
	-- Add the total time onto the end of the initial sequence message.
	sequence[1]['message'] = sequence[1]['message']..' ('..totalTimeMins..'m'..totalTimeSecs..'s)'
	-- Set the message timeout to be the total time.
	sequence[1]['message_timeout'] = endingTime

	local minsRemaining = totalTimeMins
	local i = 1
	while sequence[i] do
		-- If the current array element has a time less than or equal to our current number of minutes remaining, insert an element at the current position that shows the time remaining.
		if minsRemaining ~= 0 and endingTime - sequence[i]['time'] <= minsRemaining * 60 then
			if minsRemaining == 1 then
				minutesString = 'MINUTE'
			else
				minutesString = 'MINUTES'
			end
			table.insert(sequence, i, {message = _('=== '..minsRemaining..' '..minutesString..' REMAINING ==='), message_timeout = 60})
			sequence[i]['time'] = endingTime - minsRemaining * 60.0
			--log.info('sequence[i]: '..sequence[i]['message'])
			-- Subtract 1 minute from the remaining minutes to do.
			minsRemaining = minsRemaining - 1
			-- Decrement the index counter since we just added an element.  This makes sure we don't skip one.
			i = i - 1
		end
		-- Increment the index counter to go to the next element.
		i = i + 1
	end
	log.info('Start/Stop sequence time: '..totalTimeMins..'m'..totalTimeSecs..'s')
end
insertTimeRemaining(start_sequence_full, t_start)
insertTimeRemaining(stop_sequence_full, t_stop)

-- Debug function to log all the timing and message data for the entire sequence.  Useful to check to make sure the right values are going in, and in the right order.
local function logSequenceData()
	for i = 1, #start_sequence_full do
		local message = '(action)'
		if start_sequence_full[i]['message'] then
			message = start_sequence_full[i]['message']
		end
		log.info("start_sequence_full[i]['time']: "..start_sequence_full[i]['time']..', remaining: '..t_start-start_sequence_full[i]['time']..', message: '..message)
	end
end
--logSequenceData()
