--Loadouts database
-------------------------------------------------------------------------------------------------------
----OB----
 

if not versionDCE then versionDCE = {} end
versionDCE["UTIL_db_loadouts.lua"] = "1.1.37"


--[[ Loadout Entry Example ----------------------------------------------------------------------------

["MiG-21Bis"] = {														--String, aircraft type
	["Strike"] = {														--String, task
		["Custom Loadout Name"] = {										--String, custom loadout name
			support = {													--Table, list of tasks that can support this loadout (nil = is never added, true = is added when available)
				["Escort"] = true,										--Fighter escort
				["SEAD"] = true,										--SEAD	escort
				["Escort Jammer"] = true,								--Jammer escort
				["Flare Illumination"] = true,							--Target area flare illumination (mandatory support for loadout to be eligible)
				["Laser Illumination"] = true,							--Target laser illumination (mandatory support for loadout to be eligible)
			},
			attributes = {												--Array, custom loadout attributes. Only used by A-G tasks. Any target attribute must be matched in this array for the loadout to be eligible for the target.
				[1] = "Anti-tank",										--String, custom attribute to be matched for target attribute
				[2] = "Stand-off Missile",								--String, custom attribute to be matched for target attribute
			},
			code_loadout =  {"Crisis", "Cyprus"},						--String, need to build campaign db_loadout with camp_init code_loadout
			weaponType = "Bombs",										--String, type of ordinance of loadout. Only used by A-G taks. Options: "Cannon", "Rockets", "Bombs", "Guided bombs", "ASM". A-G weapon types cannot be mixed.
			expend = "All",												--String, quantity of wapons expended per attack. Only used by A-G tasks. Options: "Auto", "All", "Half", "Two".
			day = true,													--Boolean, loadout is day capable
			night = true,												--Boolean, loadout is night capable
			adverseWeather = true,										--Boolean, loadout is adverse weather capable
			range = 900000,												--Number, range radius in meters
			capability = 1,											--Number, how good is the aircraft with this loadout. The higher the better
			firepower = 1,												--Number, how much firepower has this loadout. The higher the better
			vCruise = 225,												--Number, cruise speed in m/s
			vAttack = 280,												--Number, attack speed in m/s
			hCruise = 6000,												--Number, cruise altitude in m
			hAttack = 100,												--Number, attack altitude in m
			standoff = 5000,											--Number, attack distance from target in m. Determines attack waypoint distance for A-G with missiles (for Bombss use nil) and engage distance for A-A tasks
			tStation = 1200,											--Number, seconds the aircraft can remain on station. Only used by CAP, AWACS and Refuelling tasks
			LDSD = true,												--Boolean, aircraft is Look-Down/Shoot-Down capable. Only used by CAP and Intercept tasks
			--- self_escort = false,										--Boolean, aircraft can defend itself against fighters. Only used by A-G tasks
			sortie_rate = 6,											--Number, average amount of sorties that aircraft flies per day
			stores = {													--Table, loadout table for DCS
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{R-60M 2L}",
					},
					[2] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[3] = 
					{
						["CLSID"] = "{PTB_800_MIG21}",
					},
					[4] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[5] = 
					{
						["CLSID"] = "{R-60M 2R}",
					},
					[6] = 
					{
						["CLSID"] = "{ASO-2}",
					},
				},
				["fuel"] = 2280,
				["flare"] = 32,
				["ammo_type"] = 1,
				["chaff"] = 32,
				["gun"] = 100,
			},
		},
	},
},

--Detection automatique du BON loadout
--si vous prevoyez un nom d'avion au milieu du titre, découpez le dans une table: TF-71-Tomcat-80s devient {"TF%-71", "80s" }
--si un tiret est dans le nom, mettez % devant
--insensible à la casse des lettres
--Automatic detection of the right loadout
--if you provide a plane name in the middle of the title, cut it out in a table: TF-71-Tomcat-80s becomes {"TF%-71", "80s" }
--if a dash is in the name, put % in front of it
--case sensitive
campaigns_code_loadout = { 
    ["Cyprus"] =    "Cyprus Incident",
    ["Crisis"] =    "Crisis in PG",
    ["PG"] =        "Over PG",
    ["Caucasus"] =    "Over Caucasus",         
    ["TF80sRED"] =    {"TF%-71", "Fishbed", "80s" },    --"TF-71-Fishbed-80s", 
    ["TF80s"] =        {"TF%-71", "80s" },    
    ["TF"] =        "TF%-71",
    ["IPW71"] =        "India%-Pak War%-71",             --India-Pak War-71 - MiG-19   
    ["HWITC"] =        "Hot War in the Cold",
    ["IIW"] =        "Iran%-Iraq war",                --Iran-Iraq war-Gazelle
}



]]-----------------------------------------------------------------------------------------------------

--Detection automatique du BON loadout
--si vous prevoyez un nom d'avion au milieu du titre, découpez le dans une table: TF-71-Tomcat-80s devient {"TF%-71", "80s" }
--si un tiret est dans le nom, mettez % devant
--insensible à la casse des lettres
--Automatic detection of the right loadout
--if you provide a plane name in the middle of the title, cut it out in a table: TF-71-Tomcat-80s becomes {"TF%-71", "80s" }
--if a dash is in the name, put % in front of it
--case sensitive
campaigns_code_loadout = { 
    ["Cyprus"] =	"Cyprus Incident",
    ["Crisis"] =	"Crisis in PG",
    ["PG"] =		"Over PG",
    ["Caucasus"] =	"Over Caucasus", 		
    ["TF80sRED"] =	{"TF%-71", "Fishbed", "80s" },	--"TF-71-Fishbed-80s", 
	["TF80s"] =		{"TF%-71", "80s" },	
	["TF"] =		"TF%-71",
    ["IPW71"] =		"India%-Pak War%-71", 			--India-Pak War-71 - MiG-19   
    ["HWITC"] =		"Hot War in the Cold",
    ["IIW"] =		"Iran%-Iraq war",				--Iran-Iraq war-Gazelle
}


db_all_loadouts = {
	["A-10C_2"] = {
		["Anti-ship Strike"] = {
			["CAS-2-Mav*4"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- --- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
		},	
		["Strike"] = {
			["CAS-1-soft-Laser guided Rockets"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- --- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{LAU-131x3 - 7 AGR-20 M282}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{LAU-131 - 7 AGR-20 M282}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{LAU-131x3 - 7 AGR-20 M282}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{LAU-131x3 - 7 AGR-20 M282}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{LAU-131x3 - 7 AGR-20 M282}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["CAS-2-Mav*4"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- --- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["Strike-1-8*GBU-12"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship", "Structure", "soft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
					["num"] = 11,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "BRU-42_3*GBU-12",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "BRU-42_3*GBU-12",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["Strike-2-GBU-10-GBU-12"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship", "Structure"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
		},
	},
	["A-10C"] = {
		["Anti-ship Strike"] = {
			["Mav"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = 9000,
				tStation = nil,
				LDSD = false,
				--- --- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "LAU-105_2*CATM-9M",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "ALQ_184",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "Fuel_Tank_FT600",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Mav"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = 9000,
				tStation = nil,
				LDSD = false,
				--- --- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "LAU-105_2*CATM-9M",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "ALQ_184",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "Fuel_Tank_FT600",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["Mk-82"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- --- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "LAU-105_2*CATM-9M",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "ALQ_184",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "Fuel_Tank_FT600",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3470,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["Mk-84"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 5200,
				hAttack = 5100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "LAU-105_2*CATM-9M",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "ALQ_184",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "Fuel_Tank_FT600",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["GBU-12"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Bridge"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 6200,
				hAttack = 7100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "LAU-105_2*CATM-9M",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "ALQ_184",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "Fuel_Tank_FT600",
					["num"] = 6,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4526,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["GBU-10"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 6200,
				hAttack = 7100,
				standoff = 11000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "LAU-105_2*CATM-9M",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "ALQ_184",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 6,
				},
				}, -- end of ["pylons"]
				["fuel"] = 5029,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
			["GBU-38"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Bridge"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 120,
				vAttack = 125,
				hCruise = 6200,
				hAttack = 7100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[11] = {
					["CLSID"] = "LAU-105_2*CATM-9M",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "ALQ_184",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "Fuel_Tank_FT600",
					["num"] = 6,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4526,
                ["flare"] = 120,
                ["chaff"] = 240,
                ["gun"] = 100,
				},
			},
		},
	},
	["A-50"] = {         --Mainstay--
		["AWACS"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 231.25,
				vAttack = 231.25,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = nil,
				tStation = 36000,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 1.2,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "70000",
                    ["flare"] = 192,
					["chaff"] = 192,
                    ["gun"] = 100,
				},
			},
		},
	},
	["AH-1W"] = {      --Cobra--
		["Escort"] = {
			["Escort"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 55,
				-- vAttack = 55,
				-- hCruise = 50,
				-- hAttack = 50,
				standoff = 4000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 10,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1250,
                ["flare"] = 30,
                ["chaff"] = 30,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike"] = {
				minscore = 0.1,
				support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 4000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{3EA17AB0-A805-4D9E-8732-4CE00CB00F17}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{3EA17AB0-A805-4D9E-8732-4CE00CB00F17}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1250,
                ["flare"] = 30,
                ["chaff"] = 30,
                ["gun"] = 100,
				},
			},
		},
	},
	["AJS37"] = {
		["Anti-ship Strike"] = {
			["Antiship - RB 15F*2 - RB-74J*2 - RB-24J*2 - FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},			
				attributes = {"ship"},
				code_loadout =  {"PG", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 250.83333333333,
				vAttack = 215.5,
				hCruise = 3500,
				hAttack = 1000,
				standoff = 35000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{VIGGEN_X-TANK}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{Rb15}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{Rb15}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{Robot74}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{Robot74}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4476,
				["flare"] = 36,
				["chaff"] = 105,
				["gun"] = 100,
				},
			},
		},		
		["Strike"] = {
			["CAS - Bomb M/71*8 - ECM*2 - RB-24J*2 - FT"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 250.83333333333,
				vAttack = 350.5,
				hCruise = 500,
				hAttack = 300,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{VIGGEN_X-TANK}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{U22A}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{KB}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{M71BOMB}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{M71BOMB}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4476,
				["flare"] = 36,
				["chaff"] = 105,
				["gun"] = 100,
				},
			},
			["CAS - Bomb M/71 chute*8 - ECM*2 - RB-24J*2 - FT"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 250.83333333333,
				vAttack = 350.5,
				hCruise = 500,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{VIGGEN_X-TANK}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{U22A}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{KB}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{M71BOMBD}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{M71BOMBD}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4476,
				["flare"] = 36,
				["chaff"] = 105,
				["gun"] = 100,
				},
			},			
			["CAS - RB-75T*2 - ECM*2 - RB-24J*2 - FT"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"PG", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 250.83333333333,
				vAttack = 350.5,
				hCruise = 6000,
				hAttack = 5572,
				standoff = 6000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{VIGGEN_X-TANK}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{U22A}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{KB}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{RB75T}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{RB75T}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4476,
				["flare"] = 36,
				["chaff"] = 105,
				["gun"] = 100,
				},
			},
			["CAS - BK90 (MJ1)*2 - ECM*2 - RB-24J*2 - XT"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"PG", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 250.83333333333,
				vAttack = 350.5,
				hCruise = 100,
				hAttack = 200,
				standoff = 9000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[2] = {
					["CLSID"] = "{KB}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{U22A}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{VIGGEN_X-TANK}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BK90}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{BK90}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4476,
				["flare"] = 36,
				["chaff"] = 105,
				["gun"] = 100,
				},
			},			
			["CAS - Rocket ARAK M70 HE*2 - ECM*2 - RB-24J*2 - FT"] = {
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {},
				weaponType = "Rockets",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 250.83333333333,
				vAttack = 350.5,
				hCruise = 100,
				hAttack = 300,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{VIGGEN_X-TANK}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{U22A}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{KB}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{ARAKM70BHE}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{ARAKM70BHE}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4476,
				["flare"] = 36,
				["chaff"] = 105,
				["gun"] = 100,
				},
			},
			["CAS - Rocket ARAK M70 AP*2 - ECM*2 - RB-24J*2 - FT"] = {
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "soft", "Parked Aircraft"},
				code_loadout =  {},
				weaponType = "Rockets",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 250.83333333333,
				vAttack = 350.5,
				hCruise = 100,
				hAttack = 300,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{VIGGEN_X-TANK}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{Robot24J}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{U22A}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{KB}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{ARAKM70BAP}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{ARAKM70BAP}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = 4476,
				["flare"] = 36,
				["chaff"] = 105,
				["gun"] = 100,
				},
			},
		},		
	},
	["An-26B"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 154.16666666667,
				vAttack = 154.16666666667,
				hCruise = 7300,
				hAttack = 7300,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "5500",
					["flare"] = 384,
					["chaff"] = 384,
					["gun"] = 100,
				},
			},
		},
	},
	["AV8BNA"] = {           ---Harrier ---
		["Intercept"] = {
			["2000s 90s 80s SR AA - AIM9M*4 - Gun - ECM"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},				
				},
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["2000s 90s 80s LR AA - AIM9M*4 - FT*2 - Gun - ECM"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 246.66666666667,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = 1200,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},			
				},
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["2000s 90s 80s LR AA - AIM9M*4 - FT*2 - Gun - ECM"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 255,
				-- vAttack = 270,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},					
				},
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["2000s 90s 80s LR AA - AIM9M*4 - FT*2 - Gun - ECM"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 7011,
				hAttack = 7011,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{AIM-9M-ON-ADAPTER}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},					
				},
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["Anti-ship Strike"] = {
			["2000s 90s 80s Antiship LR AG AGM65F*2 - AIM9M*1 - AGM122*1 - FT*2 - TP"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 5572,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {				
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 7,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["2000s 90s 80s Antiship SR AG AGM65F*4 - AIM9M*1 - AGM122*1 - Gun - TP"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 5572,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {				
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike 2000s 90s 80s LR AG Mk82*2 - AIM9M*1 - AGM122*1 - FT*2 - Gun - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 6706,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s SR AG Mk82*8 - AIM9M*1 - AGM122*1 -  Gun - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 6706,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BRU-42_2*Mk-82_LEFT}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{BRU-42_2*Mk-82_RIGHT}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{BRU-42_2*Mk-82_LEFT}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BRU-42_2*Mk-82_RIGHT}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s LR AG Mk83*2 - AIM9M*1 - AGM122*1 - FT*2  - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 6706,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s SR AG Mk83*4 - AIM9M*1 - AGM122*1 - Gun - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 6706,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s LR AG Mk82HD*2 - AIM9M*1 - AGM122*1 - FT*2 - Gun - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 300,
				hAttack = 100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s SR AG Mk82HD*8 - AIM9M*1 - AGM122*1 - FT*2 - Gun - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 300,
				hAttack = 100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BRU-42_2*Mk-82SNAKEYE_LEFT}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{BRU-42_2*Mk-82SNAKEYE_RIGHT}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{BRU-42_2*Mk-82SNAKEYE_LEFT}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BRU-42_2*Mk-82SNAKEYE_RIGHT}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s LR AG LR AG Mk20*2 - AIM9M*1 - AGM122*1 - FT*2 - Gun - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 4006,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s SR AG Mk20*8 - AIM9M*1 - AGM122*1 - Gun - ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 6706,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BRU-42_2*MK-20_LEFT}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{BRU-42_2*MK-20_RIGHT}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{BRU-42_2*MK-20_LEFT}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BRU-42_2*MK-20_RIGHT}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s LR AG AGM65F*2 - AIM9M*1 - AGM122*1 - FT*2 - TP"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 5572,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {				
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 7,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s SR AG AGM65F*4 - AIM9M*1 - AGM122*1 - Gun - TP"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6000,
				hAttack = 5572,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {				
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s LR AG GBU12*4 - AIM9M*1 - AGM122*1 - FT*2 - TP"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BRU-42_2*GBU-12_LEFT}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BRU-42_2*GBU-12_RIGHT}",
					["num"] = 7,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s SR AG GBU12*8 - AIM9M*1 - AGM122*1 - Gun - TP"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BRU-42_2*GBU-12_LEFT}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{BRU-42_2*GBU-12_RIGHT}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{BRU-42_2*GBU-12_LEFT}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BRU-42_2*GBU-12_RIGHT}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s 80s LR AG GBU16*2 - AIM9M*1 - AGM122*1 - FT*2 - TP"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 7,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["2000s 90s 80s SR AG GBU16*4 - AIM9M*1 - AGM122*1 - Gun - TP"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s LR AG GBU38*2 - AIM9M*1 - AGM122*1 - Gun - FT*2 - TP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s SR AG GBU38*8 - AIM9M*1 - AGM122*1 - Gun - TP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BRU-42_2*GBU-38_LEFT}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{BRU-42_2*GBU-38_RIGHT}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{BRU-42_2*GBU-38_LEFT}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BRU-42_2*GBU-38_RIGHT}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s LR AG GBU54*2 - AIM9M*1 - AGM122*1 - FT*2 - Gun - TP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{GBU_54_V_1B}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{GBU_54_V_1B}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s SR AG GBU54*8 - AIM9M*1 - AGM122*1 - Gun - TP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{BRU-70A_2*GBU-54_LEFT}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{BRU-70A_2*GBU-54_RIGHT}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{BRU-70A_2*GBU-54_LEFT}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{BRU-70A_2*GBU-54_RIGHT}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Strike 2000s 90s LR AG GBU32*2 - AIM9M*1 - AGM122*1 - FT*2 - TP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{GBU_32_V_2B}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{AV8BNA_AERO1D}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{GBU_32_V_2B}",
					["num"] = 7,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["2000s 90s SR AG GBU32*4 - AIM9M*1 - AGM122*1 - Gun - TP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 277.5,
				hCruise = 6048,
				hAttack = 6706,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{AGM_122_SIDEARM}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{GBU_32_V_2B}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{GBU_32_V_2B}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{GBU_32_V_2B}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{GBU_32_V_2B}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},			
		["SEAD"] = {
			["AIM-122*2, AIM-9 *2, ECM*1"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{GAU_12_Equalizer}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{LAU_7_AGM_122_SIDEARM}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{LAU_7_AGM_122_SIDEARM}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{ALQ_164_RF_Jammer}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3519,
				["flare"] = 120,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},	
		},
	},
	["B-1B"] = {
		["Strike"] = {
			["Strike TF AGM-154*12"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"Structure", "SAM"},
				code_loadout =  {},
				weaponType = "ASM",
				expend = "Auto",
				attackType = nil,
				day = false,
				night = true,
				adverseWeather = true,
				range = 1000000,
				capability = 10,
				firepower = 1.5,
				vCruise = 250.25,
				vAttack = 356.94444444444,
				hCruise = 7315.2,
				hAttack = 7315.2,
				standoff = 43000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					[1] = {
					["CLSID"] = "{AABA1A14-78A1-4E85-94DD-463CF75BD9E4}",
					["num"] = 1,
					},
					[2] = {
					["CLSID"] = "{AABA1A14-78A1-4E85-94DD-463CF75BD9E4}",
					["num"] = 2,
					},
					[3] = {
					["CLSID"] = "{AABA1A14-78A1-4E85-94DD-463CF75BD9E4}",
					["num"] = 3,
					},
					},
					["fuel"] = "88450",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
	},
	["B-52H"] = {
		["Strike"] = {
			["Mk-84*18"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = false,
				night = true,
				adverseWeather = true,
				range = 1000000,
				capability = 1,
				firepower = 30,
				vCruise = 231.25,
				vAttack = 256.94444444444,
				hCruise = 7315.2,
				hAttack = 7315.2,
				standoff = 25000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 1.5,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}",
						}, -- end of [1]
						[3] = 
						{
							["CLSID"] = "{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}",
						}, -- end of [3]
					}, -- end of ["pylons"]
					["fuel"] = "141135",
					["flare"] = 192,
					["chaff"] = 1125,
					["gun"] = 100,
				},
			},
			["Strike TF  AGM-86C*20"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"Base", "SAM"},
				code_loadout =  {"TF"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 1000000,
				capability = 10,
				firepower = 1.5,
				vCruise = 231.25,
				vAttack = 256.94444444444,
				hCruise = 8315.2,
				hAttack = 8315.2,
				standoff = 130000,
				ingress = 50000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[2] = {
					["CLSID"] = "{8DCAF3A3-7FCF-41B8-BB88-58DEDA878EDE}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{45447F82-01B5-4029-A572-9AAD28AF0275}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{45447F82-01B5-4029-A572-9AAD28AF0275}",
					["num"] = 1,
				},
					}, -- end of ["pylons"]
					["fuel"] = "141135",
					["flare"] = 192,
					["chaff"] = 1125,
					["gun"] = 100,
					},
				},		
			["Strike TF medium  AGM-86C*20"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"Base", "SAM"},
				code_loadout =  {"TF"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 1000000,
				capability = 10,
				firepower = 1.5,
				vCruise = 231.25,
				vAttack = 256.94444444444,
				hCruise = 7315.2,
				hAttack = 7315.2,
				standoff = 130000,
				ingress = 50000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[2] = {
					["CLSID"] = "{8DCAF3A3-7FCF-41B8-BB88-58DEDA878EDE}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{45447F82-01B5-4029-A572-9AAD28AF0275}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{45447F82-01B5-4029-A572-9AAD28AF0275}",
					["num"] = 1,
				},
					}, -- end of ["pylons"]
					["fuel"] = "141135",
					["flare"] = 192,
					["chaff"] = 1125,
					["gun"] = 100,
				},
			},	
		},
	},
	["C-130"] = {        --Hercules--
		["Transport"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 154.16666666667,
				vAttack = 154.16666666667,
				hCruise = 4572,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "20830",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["CH-47D"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 40,
				vAttack = 40,
				hCruise = 100,
				hAttack = 100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 5,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "3600",
					["flare"] = 120,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["E-2C"] = {       --Hawkeye--
		["AWACS"] = {
			["Default"] = {
				attributes = {"AEW"},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				vCruise = 152.778,
				vAttack = 138.889,
				hCruise = 7315.2,
				hAttack = 7315.2,
				tStation = 14400,
				sortie_rate = 12,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "65000",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["E-3A"] = {         --Sentry--
		["AWACS"] = {
			["Default"] = {
				attributes = {"Sentry"},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 231.25,
				vAttack = 231.25,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = nil,
				tStation = 36000,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 12,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "65000",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["FA-18C_hornet"] = {
		["SEAD"] = {
			["SEAD 80s SR-SEAD-AIM-9L*2,AIM7MH*2,AGM-88*4,FT*1"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				-- weaponType = "ASM",
				-- expend = nil,
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				sortie_rate = 12,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["SEAD 80s LR-SEAD-AIM-9L*2,AIM7MH*2,AGM-88*2,FT*3"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				-- weaponType = "ASM",
				-- expend = nil,
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				sortie_rate = 12,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["SEAD 90s SR-SEAD-AIM-9M*2,AIM-120B*2,AGM-88*4,FT*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				-- weaponType = "ASM",
				-- expend = nil,
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				sortie_rate = 12,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["SEAD 90s LR-SEAD-AIM-9M*2,AIM-120B*2,AGM-88*2,FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				-- weaponType = "ASM",
				-- expend = nil,
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				sortie_rate = 12,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["SEAD 2000s SR-SEAD-AIM-9X*2,AIM-120C*2,AGM-88*4,FT*1"] = {
				attributes = {},
				code_loadout =  {"Caucasus", "TF"},
				-- weaponType = "ASM",
				-- expend = nil,
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				sortie_rate = 12,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["SEAD 2000s LR-SEAD-AIM-9X*2,AIM-120C*2,AGM-88*2,FT*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus", "TF"},
				-- weaponType = "ASM",
				-- expend = nil,
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				sortie_rate = 12,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
		},
		["Intercept"] = {
			["Intercept 2000s SR1 AA - AIM-9X*6 AIM-120C*6 FT*1"] = {
				attributes = {},
				code_loadout =  {"Caucasus", "TF"},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["Intercept 90s SR1 AA - AIM-9M*6 AIM-120B*6 FT*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9M",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9M",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["Intercept 80s SR1 AA - AIM-9L*6 AIM-7MH*4 FT*1"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9L",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-9L",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP 2000s LR1 AA - AIM-9X*2 AIM-120C*6 FT*3"] = {
				attributes = {"CV CAP"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 6,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 7096,
				hAttack = 7096,
				-- standoff = 36000,
				tStation = 2700,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["CAP 90s LR1 AA - AIM-9M*2 AIM-120B*6 FT*3"] = {
				attributes = {"CV CAP"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 6,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 7096,
				hAttack = 7096,
				-- standoff = 36000,
				tStation = 2700,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["CAP 80s LR1 AA - AIM-9L*2 AIM-7MH*4 FT*3"] = {
				attributes = {"CV CAP"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 6,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 7096,
				hAttack = 7096,
				-- standoff = 36000,
				tStation = 2700,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort 2000s LR1 AA - AIM-9X*2 AIM-120C*6 FT*3"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 346.66666666667,
				-- hCruise = 7096,
				-- hAttack = 7096,
				standoff = 72000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["Escort 90s LR1 AA - AIM-9M*2 AIM-120B*6 FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 346.66666666667,
				-- hCruise = 7096,
				-- hAttack = 7096,
				standoff = 72000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["Escort 80s LR1 AA - AIM-9L*2 AIM-7MH*4 FT*3"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 346.66666666667,
				-- hCruise = 7096,
				-- hAttack = 7096,
				standoff = 72000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
		},	
		["Fighter Sweep"] = {
			["Fighter Sweep 2000s LR1 AA - AIM-9X*2 AIM-120C*6 FT*3"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 346.66666666667,
				hCruise = 7096,
				hAttack = 7096,
				standoff = 36000,
				tStation = nil,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120C",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["Fighter Sweep 90s LR1 AA - AIM-9M*2 AIM-120B*6 FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 346.66666666667,
				hCruise = 7096,
				hAttack = 7096,
				standoff = 36000,
				tStation = nil,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU-115_2*LAU-127_AIM-120B",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["Fighter Sweep 80s LR1 AA - AIM-9L*2 AIM-7MH*4 FT*3"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 346.66666666667,
				hCruise = 7096,
				hAttack = 7096,
				standoff = 36000,
				tStation = nil,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{LAU-115 - AIM-7H}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
			},
				["fuel"] = "4900",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
		},	
		["Anti-ship Strike"] = {
			["Antiship 80s LR-Anti-Ship-AIM-9L*2,AIM7MH*2,AGM-84D*2,FT*3"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 50000,
				tStation = nil,
				LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Antiship 80s SR-Anti-Ship-AIM-9L*2,AIM7MH*2,AGM-84D*4,FT*1"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 50000,
				tStation = nil,
				LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Antiship 90s LR-Anti-Ship-AIM-9M*2,AIM-120B*2,AGM-84D*2,FT*3"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 50000,
				tStation = nil,
				LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Antiship 90s SR-Anti-Ship-AIM-9M*2,AIM-120B*2,AGM-84D*4,FT*1"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 50000,
				tStation = nil,
				LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Antiship 2000s LR-Anti-Ship-AIM-9X*2,AIM-120C*2,AGM-84D*2,FT*3"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 50000,
				tStation = nil,
				LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Antiship 2000s SR-Anti-Ship-AIM-9X*2,AIM-120C*2,AGM-84D*4,FT*1"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 50000,
				tStation = nil,
				LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AGM_84D}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},	
		["Strike"] = {			
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*2,MK82LD*4,FT*3"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*2,MK82LD*8,FT*1"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*2,MK82LD*4,FT*3"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*2,MK82LD*8,FT*1"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR-AG-AIM-9L*2,AIM-7MH*2,MK82LD*4,FT*3"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR-AG-AIM-9L*2,AIM-7MH*2,MK82LD*8,FT*1"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_MK-82}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*2,MK84*2,FT*3"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*2,MK84*4,FT*1"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*2,MK84LD*2,FT*3"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*2,MK84LD*4,FT*1"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR-AG-AIM-9L*2,AIM-7MH*2,MK84LD*2,FT*3"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR-AG-AIM-9L*2,AIM-7MH*2,MK84LD*4,FT*1"] = {
			minscore = 0.5,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*2,Mk20-Rockeye*4,FT*3"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*2,Mk20-Rockeye*8,FT*1"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*2,Mk20-Rockeye*4,FT*3"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*2,Mk20-Rockeye*8,FT*1"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR-AG-AIM-9L*2,AIM-7MH*2,Mk20-Rockeye*4,FT*3"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR-AG-AIM-9L*2,AIM-7MH*2,Mk20-Rockeye*8,FT*1"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_ROCKEYE}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*2,MK82HD*4,FT*3"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*2,MK82HD*8,FT*1"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*2,MK82HD*4,FT*3"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*2,MK82HD*8,FT*1"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			-- ["Strike 80s LR-AG-AIM-9L*2,AIM-7MH*2,MK82HD*4,FT*3"] = {
			-- minscore = 0.3,
				-- support = {
					-- ["Escort"] = true,
					-- ["SEAD"] = true,
				-- },
				-- attributes = {"soft", "Parked Aircraft", "SAM"},
				-- code_loadout =  {"TF80s", "TF80sRED"},
				-- weaponType = "Bombs",
				-- expend = "All",
				-- day = true,
				-- night = true,
				-- adverseWeather = false,
				-- range = 450000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 245,
				-- vAttack = 350.5,
				-- hCruise = 300.4,
				-- hAttack = 200,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = true,
				-- --- self_escort = false,
				-- sortie_rate = 6,
				-- stores = {
					-- ["pylons"] = 
					-- {
				-- [9] = {
					-- ["CLSID"] = "{AIM-9L}",
					-- ["num"] = 9,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{AIM-9L}",
					-- ["num"] = 1,
				-- },
				-- [6] = {
					-- ["CLSID"] = "{AIM-7H}",
					-- ["num"] = 6,
				-- },
				-- [4] = {
					-- ["CLSID"] = "{AIM-7H}",
					-- ["num"] = 4,
				-- },
				-- [5] = {
					-- ["CLSID"] = "{FPU_8A_FUEL_TANK}",
					-- ["num"] = 5,
				-- },
				-- [8] = {
					-- ["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					-- ["num"] = 8,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					-- ["num"] = 2,
				-- },
				-- [7] = {
					-- ["CLSID"] = "{FPU_8A_FUEL_TANK}",
					-- ["num"] = 7,
				-- },
				-- [3] = {
					-- ["CLSID"] = "{FPU_8A_FUEL_TANK}",
					-- ["num"] = 3,
				-- },
				-- }, -- end of ["pylons"]
					-- ["fuel"] = 3249,
					-- ["flare"] = 60,
					-- ["chaff"] = 60,
					-- ["gun"] = 100,
				-- },
			-- },
			-- ["Strike 80s SR-AG-AIM-9L*2,AIM-7MH*2,MK82HD*8,FT*1"] = {
			-- minscore = 0.3,
				-- support = {
					-- ["Escort"] = true,
					-- ["SEAD"] = true,
				-- },
				-- attributes = {"soft", "Parked Aircraft", "SAM"},
				-- code_loadout =  {"TF80s", "TF80sRED"},
				-- weaponType = "Bombs",
				-- expend = "All",
				-- day = true,
				-- night = true,
				-- adverseWeather = false,
				-- range = 150000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 245,
				-- vAttack = 350.5,
				-- hCruise = 300.4,
				-- hAttack = 200,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = true,
				-- --- self_escort = false,
				-- sortie_rate = 6,
				-- stores = {
					-- ["pylons"] = 
					-- {
				-- [9] = {
					-- ["CLSID"] = "{AIM-9L}",
					-- ["num"] = 9,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{AIM-9L}",
					-- ["num"] = 1,
				-- },
				-- [6] = {
					-- ["CLSID"] = "{AIM-7H}",
					-- ["num"] = 6,
				-- },
				-- [4] = {
					-- ["CLSID"] = "{AIM-7H}",
					-- ["num"] = 4,
				-- },
				-- [5] = {
					-- ["CLSID"] = "{FPU_8A_FUEL_TANK}",
					-- ["num"] = 5,
				-- },
				-- [8] = {
					-- ["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					-- ["num"] = 8,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					-- ["num"] = 2,
				-- },
				-- [7] = {
					-- ["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					-- ["num"] = 7,
				-- },
				-- [3] = {
					-- ["CLSID"] = "{BRU33_2X_MK-82_Snakeye}",
					-- ["num"] = 3,
				-- },
				-- }, -- end of ["pylons"]
					-- ["fuel"] = 3249,
					-- ["flare"] = 60,
					-- ["chaff"] = 60,
					-- ["gun"] = 100,
				-- },
			-- },
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*1,GBU-12*4,FT*3,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*1,GBU-12*8,FT*1,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*1,GBU-12*4,FT*3,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*1,GBU-12*8,FT*1,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR-AG-AIM-9L*2,AIM-7MH*1,GBU-12*4,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR-AG-AIM-9L*2,AIM-7MH*1,GBU-12*8,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU33_2X_GBU-12}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*1,GBU-10*2,FT*3,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*1,GBU-10*4,FT*1,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*1,GBU-10*2,FT*3,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*1,GBU-10*4,FT*1,GP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR-AG-AIM-9L*2,AIM-7-MH*1,GBU-10*2,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR-AG-AIM-9L*2,AIM-7-MH*1,GBU-10*4,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*1,GBU-38*4,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*1,GBU-38*8,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*1,GBU-38*4,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*1,GBU-38*8,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU55_2*GBU-38}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*1,GBU-31*2,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*1,GBU-31*4,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*1,GBU-31*2,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*1,GBU-31*4,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 20000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*1,JSAW-C*4,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 60000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*AGM-154C}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*AGM-154C}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*1,JSAW-C*8,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 60000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*AGM-154C}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*AGM-154C}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU55_2*AGM-154C}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU55_2*AGM-154C}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*1,JSAW-A*4,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 60000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*AGM-154A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*AGM-154A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*1,JSAW-A*8,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 60000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{BRU55_2*AGM-154A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{BRU55_2*AGM-154A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{BRU55_2*AGM-154A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BRU55_2*AGM-154A}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*2,SLAM-ER*2,FT*3"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 100000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{AGM_84H}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84H}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*2,SLAM-ER*4,FT*1"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 8172,
				standoff = 43000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{AGM_84H}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AGM_84H}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AGM_84H}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AGM_84H}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR-AG-AIM-9X*2,AIM-120C*1,AGM-65F*2,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR-AG-AIM-9X*2,AIM-120C*1,AGM-65F*4,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR-AG-AIM-9M*2,AIM-120B*1,AGM-65F*2,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR-AG-AIM-9M*2,AIM-120B*1,AGM-65F*4,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR-AG-AIM-9L*2,AIM-7-MH*1,AGM-65F*2,FT*3,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR-AG-AIM-9L*2,AIM-7-MH*1,AGM-65F*4,FT*1,GP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245.83333333333,
				vAttack = 300.5,
				hCruise = 7486.4,
				hAttack = 7472,
				standoff = 15000,
				tStation = nil,
				-- LDSD = true,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM-7H}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{AN_ASQ_228}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FPU_8A_FUEL_TANK}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "LAU_117_AGM_65F",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4900",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},			
		},
	},
	["F-14A-135-GR"] = {     ---Tomcat A ---
		["Intercept"] = {
			["80s AA AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA AIM-54A-MK47*4, AIM-7MH*2, AIM-9L*2,XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-7MH*6, AIM-9L*2"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9M*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-7MH*6, AIM-9M*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
		},
		["CAP"] = {
			["80s AA AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA AIM-54A-MK47*4, AIM-7MH*2, AIM-9L*2,XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-7MH*6, AIM-9L*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 20000,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9M*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-7MH*6, AIM-9M*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 20000,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
		},
		["Escort"] = {
			["80s AA AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA AIM-54A-MK47*4, AIM-7MH*2, AIM-9L*2,XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-7MH*6, AIM-9L*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9M*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-7MH*6, AIM-9M*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
		},		
		["Fighter Sweep"] = {
			["80s AA AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA AIM-54A-MK47*4, AIM-7MH*2, AIM-9L*2,XT*2"] = {
				attributes = {},
				code_loadout =  {"TF80s"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9L*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["80s AA Iran AIM-7MH*6, AIM-9L*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-54A-MK47*2, AIM-7MH*4, AIM-9M*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9L}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54A_Mk47}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
			["90s-2000s AA Iran AIM-7MH*6, AIM-9M*2"] = {
				attributes = {"IRIAF"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 20300,
				tStation = 3600,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
			},
		},		
	},
	["F-14B"] = {     ---Tomcat---
		["Intercept"] = {
			["90s-2000s AA-1 - AIM-54C-MK47*4, AIM-7MH*2, AIM-9M*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 12,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
			AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
		},
		["90s-2000s AA-2 - AIM-54C-MK47*2, AIM-7MH*4, AIM-9M*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 12,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
			AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
		},
		["90s-2000s AA-3 - AIM-54C-MK47*6, AIM-9M*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 12,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM_54C_Mk47 R}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM_54C_Mk47 L}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
			AddPropAircraft = 
		{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
		},
		},		
		},
		["CAP"] = {
			["90s-2000s AA-1 - AIM-54C-MK47*4, AIM-7MH*2, AIM-9M*2, XT*2"] = {
				attributes = {"CV CAP"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 12,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
		["90s-2000s AA-2 - AIM-54C-MK47*2, AIM-7MH*4, AIM-9M*2, XT*2"] = {
				attributes = {"CV CAP"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 3600,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 12,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},	
		},
		["Escort"] = {
			["90s-2000s AA-1 - AIM-54C-MK47*4, AIM-7MH*2, AIM-9M*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
		["90s-2000s AA-2 - AIM-54C-MK47*2, AIM-7MH*4, AIM-9M*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				standoff = 80300,
				-- tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},	
		},		
		["Fighter Sweep"] = {
			["90s-2000s AA-1 - AIM-54C-MK47*4, AIM-7MH*2, AIM-9M*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 315.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
		["90s-2000s AA-2 - AIM-54C-MK47*2, AIM-7MH*4, AIM-9M*2, XT*2"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 315.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 100300,
				tStation = 7200,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{BELLY AIM-7MH}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},	
		},
		["Strike"] = {
			["Strike 90s-2000s AG - Mk82LD*8-AIM-54C-MK47*2, AIM-7MH*2, AIM-9M*2, XT*2"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{MAK79_MK82 4}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{MAK79_MK82 4}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},	
			},
			["Strike 90s-2000s AG - Mk82HD*8-AIM-54C-MK47*2, AIM-7MH*2, AIM-9M*2, XT*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 306.4,
				hAttack = 100,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{MAK79_MK82SE 4}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{MAK79_MK82SE 4}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},	
			},
			["Strike 90s-2000s AG - Mk84LD*2-AIM-54C-MK47*2, AIM-7MH*2, AIM-9M*2, XT*2"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{BRU-32 MK-84}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{BRU-32 MK-84}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
			["Strike 90s-2000s AG - Mk83LD*2-AIM-54C-MK47*2, AIM-7MH*2, AIM-9M*2, XT*2"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{MAK79_MK83 1R}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{MAK79_MK83 1L}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
			["Strike 90s-2000s AG - Mk20*2-AIM-54C-MK47*2, AIM-7MH*2, AIM-9M*2, XT*2"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{MAK79_MK20 1R}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{MAK79_MK20 1L}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
			["Strike 90s-2000s AG - GBU24*1-AIM-54C-MK47*2, AIM-7MH*1, AIM-9M*2, XT*2, GP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{F14-LANTIRN-TP}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{BRU-32 GBU-24}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
			["Strike 90s-2000s AG - GBU24*2, AIM-7MH*1, AIM-9M*2, XT*2, GP"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{F14-LANTIRN-TP}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{BRU-32 GBU-24}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{BRU-32 GBU-24}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
			["Strike 90s-2000s AG - GBU16*2-AIM-54C-MK47*2, AIM-7MH*1, AIM-9M*2, XT*2, GP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{F14-LANTIRN-TP}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{BRU-32 GBU-16}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{BRU-32 GBU-16}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
			["Strike 90s-2000s AG - GBU16*4, AIM-7MH*1, AIM-9M*2, XT*2, GP"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{F14-LANTIRN-TP}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BRU-32 GBU-16}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{BRU-32 GBU-16}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{BRU-32 GBU-16}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{BRU-32 GBU-16}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
			["Strike 90s-2000s AG - GBU12*2-AIM-54C-MK47*2, AIM-7MH*1, AIM-9M*2, XT*2, GP"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{F14-LANTIRN-TP}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{BRU-32 GBU-12}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{BRU-32 GBU-12}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{AIM_54C_Mk47}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},
		["Strike 90s-2000s AG - GBU-12*4, AIM-9M*2, AIM-7M*1,Lantirn, FT*2"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG", "TF", "Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{F14-LANTIRN-TP}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BRU-32 GBU-12}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{BRU-32 GBU-12}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{BRU-32 GBU-12}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{BRU-32 GBU-12}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{F14-300gal}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{SHOULDER AIM-7MH}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{LAU-138 wtip - AIM-9M}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "7348",
					["flare"] = 60,
					["chaff"] = 140,
					["gun"] = 100,
				},
				AddPropAircraft = 
	{
		["LGB100"] = 6,
		["M61BURST"] = 0,
		["IlsChannel"] = 11,				-- preset ILS channel
		["LGB1"] = 8,
		["KY28Key"] = 1,
		["TacanBand"] = 0,
		["ALE39Loadout"] = 3,
		["UseLAU138"] = true,
		["LGB10"] = 8,
		["INSAlignmentStored"] = true,		-- fast alignment, remember to modify also the value: "startup_time_player" in this file
		["TacanChannel"] = 37,				-- preset TACAN channel
		["LGB1000"] = 1,
	},
			},	
		},		
	},
	["F-15C"] = {      ---Eagle---
		["Intercept"] = {
			["AIM-9M*4, AIM-120B*4, Fuel*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [1]
						[3] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
						}, -- end of [6]
						[7] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [7]
						[8] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [8]
						[9] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [9]
						[11] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [11]
					}, -- end of ["pylons"]
					["fuel"] = "6103",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},		
		["2000s LR AA AIM-120C*4,  AIM-9M*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 6,
				},
				[10] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 10,
				},
				[11] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
					}, -- end of ["pylons"]
					["fuel"] = "6103",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["AIM-9M*4, AIM-120B*4, Fuel*3"] = {
				attributes = {"Air Forces"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [1]
					[2] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [2]
					[3] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [3]
					[4] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [4]
					[5] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [5]
					[6] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [6]
					[7] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [7]
					[8] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [8]
					[9] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [9]
					[10] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [10]					
					[11] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [11]
				}, -- end of ["pylons"]
				["fuel"] = "6103",
				["flare"] = 60,
				["chaff"] = 120,
				["gun"] = 100,
				},
			},
			["2000s LR AA AIM-120C*4,  AIM-9M*4, Fuel*3"] = {
				attributes = {"Air Forces"},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 6,
				},
				[10] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 10,
				},
				[11] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
				["fuel"] = "6103",
				["flare"] = 60,
				["chaff"] = 120,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["AIM-9M*4, AIM-120B*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [1]
					[2] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [2]
					[3] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [3]
					[4] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [4]
					[5] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [5]
					[6] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [6]
					[7] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [7]
					[8] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [8]
					[9] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [9]
					[10] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [10]					
					[11] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [11]
				}, -- end of ["pylons"]
				["fuel"] = "6103",
				["flare"] = 60,
				["chaff"] = 120,
				["gun"] = 100,
				},
			},
			["2000s LR AA AIM-120C*4,  AIM-9M*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 6,
				},
				[10] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 10,
				},
				[11] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
				["fuel"] = "6103",
				["flare"] = 60,
				["chaff"] = 120,
				["gun"] = 100,
				},
			},
		},		
		["Fighter Sweep"] = {
			["AIM-9M*4, AIM-120B*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [1]
					[2] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [2]
					[3] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [3]
					[4] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [4]
					[5] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [5]
					[6] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [6]
					[7] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [7]
					[8] = 
					{
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					}, -- end of [8]
					[9] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [9]
					[10] = 
					{
						["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					}, -- end of [10]					
					[11] = 
					{
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					}, -- end of [11]
				}, -- end of ["pylons"]
				["fuel"] = "6103",
				["flare"] = 60,
				["chaff"] = 120,
				["gun"] = 100,
				},
			},
			["2000s LR AA AIM-120C*4,  AIM-9M*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 6,
				},
				[10] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 10,
				},
				[11] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
				["fuel"] = "6103",
				["flare"] = 60,
				["chaff"] = 120,
				["gun"] = 100,
				},
			},
		},
	},	
	["F-15E"] = {
		["Strike"] = {
			["GBU-10*4, AIM-9M*2, AIM-120B*2, Fuel*2"] = {
			minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = false,
					night = true,
					adverseWeather = false,
					range = 900000,
					capability = 1,
					firepower = 1,
					vCruise = 245,
					vAttack = 277.5,
					hCruise = 7315.2,
					hAttack = 7315.2,
					standoff = 15000,
					tStation = nil,
					LDSD = true,
					--- self_escort = false,
					sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [3]
						[11] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [11]
						[7] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [7]
						[18] = 
						{
							["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
						}, -- end of [18]
						[17] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [17]
						[19] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [19]
						[9] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [9]
						[13] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [13]
					}, -- end of ["pylons"]
					["fuel"] = "10246",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
			["2000s AG GBU-10*4, AIM-9M*2, AIM-120C*2, Fuel*2"] = {
			minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = false,
					night = true,
					adverseWeather = false,
					range = 900000,
					capability = 1,
					firepower = 1,
					vCruise = 245,
					vAttack = 277.5,
					hCruise = 7315.2,
					hAttack = 7315.2,
					standoff = 15000,
					tStation = nil,
					LDSD = true,
					--- self_escort = false,
					sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
						}, -- end of [3]
						[11] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [11]
						[7] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [7]
						[18] = 
						{
							["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
						}, -- end of [18]
						[17] = 
						{
							["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
						}, -- end of [17]
						[19] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [19]
						[9] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [9]
						[13] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [13]
					}, -- end of ["pylons"]
					["fuel"] = "10246",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
			["Strike GBU-38*12, AIM-9M*2, AIM-120B*2, FT*3"] = {
			minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
					attributes = {"soft", "Parked Aircraft", "SAM"},
					code_loadout =  {"PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = false,
					night = true,
					adverseWeather = true,
					range = 900000,
					capability = 1,
					firepower = 1,
					vCruise = 245,
					vAttack = 277.5,
					hCruise = 7315.2,
					hAttack = 7315.2,
					standoff = 20000,
					tStation = nil,
					LDSD = true,
					--- self_escort = false,
					sortie_rate = 6,
				stores = {
					["pylons"] = 
				{
				[19] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 19,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[18] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 18,
				},
				[17] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 17,
				},
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 3,
				},
				[13] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 13,
				},
				[7] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 7,
				},
				[11] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 9,
				},
				[12] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 12,
				},
				[16] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 16,
				},
				[15] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 15,
				},
				[8] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 6,
				},
				[14] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 14,
				},
				[10] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 10,
				},	
				}, -- end of ["pylons"]
					["fuel"] = "10246",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
			["Strike 2000s AG GBU-38*12, AIM-9M*2, AIM-120C*2, FT*3"] = {
			minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
					attributes = {"soft", "Parked Aircraft", "SAM"},
					code_loadout =  {"Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = false,
					night = true,
					adverseWeather = true,
					range = 900000,
					capability = 1,
					firepower = 1,
					vCruise = 245,
					vAttack = 277.5,
					hCruise = 7315.2,
					hAttack = 7315.2,
					standoff = 20000,
					tStation = nil,
					LDSD = true,
					--- self_escort = false,
					sortie_rate = 6,
				stores = {
					["pylons"] = 
				{
				[19] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 19,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[18] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 18,
				},
				[17] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 17,
				},
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 3,
				},
				[13] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 13,
				},
				[7] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 7,
				},
				[11] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 9,
				},
				[12] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 12,
				},
				[16] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 16,
				},
				[15] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 15,
				},
				[8] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 6,
				},
				[14] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 14,
				},
				[10] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 10,
				},	
				}, -- end of ["pylons"]
					["fuel"] = "10246",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
			["Strike GBU-31*4, AIM-9M*2, AIM-120B*2, FT*2"] = {
			minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = false,
					night = true,
					adverseWeather = true,
					range = 900000,
					capability = 1,
					firepower = 1,
					vCruise = 245,
					vAttack = 277.5,
					hCruise = 7315.2,
					hAttack = 7315.2,
					standoff = 20000,
					tStation = nil,
					LDSD = true,
					--- self_escort = false,
					sortie_rate = 6,
				stores = {
					["pylons"] = 
				{
				[19] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 19,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[18] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 18,
				},
				[17] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 17,
				},
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 3,
				},
				[13] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 13,
				},
				[7] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 7,
				},
				[11] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 9,
				},
				},-- end of ["pylons"]
					["fuel"] = "10246",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
			["Strike 2000s AG GBU-31*4, AIM-9M*2, AIM-120C*2, FT*2"] = {
			minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = false,
					night = true,
					adverseWeather = true,
					range = 900000,
					capability = 1,
					firepower = 1,
					vCruise = 245,
					vAttack = 277.5,
					hCruise = 7315.2,
					hAttack = 7315.2,
					standoff = 20000,
					tStation = nil,
					LDSD = true,
					--- self_escort = false,
					sortie_rate = 6,
				stores = {
					["pylons"] = 
				{
				[19] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 19,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[18] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 18,
				},
				[17] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 17,
				},
				[2] = {
					["CLSID"] = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 3,
				},
				[13] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 13,
				},
				[7] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 7,
				},
				[11] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 11,
				},
				[9] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 9,
				},
				},-- end of ["pylons"]
					["fuel"] = "10246",
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["F-16C bl.52d"] = {				--Falcon IA--
		["Laser Illumination"] = {
			["Laser Illumination"] = {
				attributes = {},
				code_loadout =  {"PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 300,
				hCruise = 7096,
				hAttack = 7096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "ALQ_184",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
			},	
 				["fuel"] = 3104,
				["flare"] = 45,
				["chaff"] = 90,
				["gun"] = 100,
				},
			},	
		},
		["SEAD"] = {
			["AGM-45*2, AIM-9M*2, AIM-120B*2, ECM*1, Fuel*2"] = {
				attributes = {},
				code_loadout =  {"PG"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "ALQ_184",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{CAAC1CFD-6745-416B-AFA4-CB57414856D0}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3104,
				["flare"] = 45,
				["chaff"] = 90,
				["gun"] = 100,
				},
			},	
		},
		["Strike"] = {
			["Strike GBU-10, AIM-9M*2, AIM-120B*2, Fuel*2, ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = false,
					adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "ALQ_184",
					["num"] = 6,
				}, -- end of [10]
					}, -- end of ["pylons"]
					["fuel"] = 3104,
					["flare"] = 45,
					["chaff"] = 90,
					["gun"] = 100,
				},
			},
			["Strike GBU-12, AIM-9M*2, AIM-120B*2, Fuel*2, ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge"},
				code_loadout =  {"PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = false,
					adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{BRU-42_2xGBU-12_right}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{89D000B0-0360-461A-AD83-FB727E2ABA98}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "ALQ_184",
					["num"] = 6,
				}, -- end of [10]
					}, -- end of ["pylons"]
					["fuel"] = 3104,
					["flare"] = 45,
					["chaff"] = 90,
					["gun"] = 100,
				},
			},
			["Strike 2*AIM9M, 2*AIM120B, 2*GBU-38, ECM, 2*FT"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{GBU-38}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "ALQ_184",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{CAAC1CFD-6745-416B-AFA4-CB57414856D0}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				}, -- end of [10]
					}, -- end of ["pylons"]
					["fuel"] = 3104,
					["flare"] = 45,
					["chaff"] = 90,
					["gun"] = 100,
				},
			},
			["Strike 2*AIM9M, 2*AIM120B, 2*GBU-31, ECM, 2*FT"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{GBU-31}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "ALQ_184",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{CAAC1CFD-6745-416B-AFA4-CB57414856D0}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				}, -- end of [10]
					}, -- end of ["pylons"]
					["fuel"] = 3104,
					["flare"] = 45,
					["chaff"] = 90,
					["gun"] = 100,
				},
			},			
			["Mk-82*6, AIM-9M*2, AIM-120B*2, Fuel*2, ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure","soft", "Parked Aircraft"},
				code_loadout =  {"PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 2,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
						}, -- end of [4]
						[6] = 
						{
							["CLSID"] = "ALQ_184",
						}, -- end of [6]
						[7] = 
						{
							["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
						}, -- end of [7]
						[8] = 
						{
							["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
						}, -- end of [8]
						[9] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [9]
						[10] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [10]
					}, -- end of ["pylons"]
					["fuel"] = 3104,
					["flare"] = 45,
					["chaff"] = 90,
					["gun"] = 100,
				},
			},
			["Mk-84*2, AIM-9M*2, AIM-120B*2, Fuel*2, ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"PG"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 1,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
						}, -- end of [4]
						[6] = 
						{
							["CLSID"] = "ALQ_184",
						}, -- end of [6]
						[7] = 
						{
							["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
						}, -- end of [7]
						[8] = 
						{
							["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
						}, -- end of [8]
						[9] = 
						{
							["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						}, -- end of [9]
						[10] = 
						{
							["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						}, -- end of [10]
					}, -- end of ["pylons"]
					["fuel"] = 3104,
					["flare"] = 45,
					["chaff"] = 90,
					["gun"] = 100,
				},
			},
		},
	},
	["F-16C_50"] = {    --Falcon--
		["Laser Illumination"] = {
			["Laser Illumination AIM-120*2, AIM-9X*2, FUEL*2, TGP"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 300,
				hCruise = 7096,
				hAttack = 7096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				[5] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 5,
				},
			},	
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["Laser Illumination Caucasus AIM-120B*2,AIM-9M*2,FUEL*2, TGP"] = {
				attributes = {},
				code_loadout =  {"PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 300,
				hCruise = 7096,
				hAttack = 7096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				[5] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 5,
				},
			},	
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["Intercept"] = {
			[" AA AIM-120B*4, AIM-9L*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			[" AA AIM-120B*2, AIM-9L*4, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["2000s SR AA AIM-120C*4, AIM-9X*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["2000s LR AA AIM-120C*4, AIM-9X*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s LR AA AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s SR AA AIM-120B*4, AIM-9M*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s LR AA AIM-9L*6, FT*3"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s SR AA AIM-9L*6, FT*1"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["AIM-120B*4, AIM-9L*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["AIM-120B*2, AIM-9L*4, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["2000s LR AA AIM-120C*4, AIM-9X*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},		
			["90s LR AA AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},			
			["80s LR AA AIM-9L*6, FT*3"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["AIM-120B*4, AIM-9L*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["AIM-120B*2, AIM-9L*4, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["2000s SR AA AIM-120C*4, AIM-9X*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["2000s LR AA AIM-120C*4, AIM-9X*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s LR AA AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s SR AA AIM-120B*4, AIM-9M*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s LR AA AIM-9L*6, FT*3"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s SR AA AIM-9L*6, FT*1"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},		
		["Fighter Sweep"] = {
			["AIM-120B*4, AIM-9L*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["AIM-120B*2, AIM-9L*4, FT*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["2000s SR AA AIM-120C*4, AIM-9X*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["2000s LR AA AIM-120C*4, AIM-9X*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s LR AA AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s SR AA AIM-120B*4, AIM-9M*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s LR AA AIM-9L*6, FT*3"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s SR AA AIM-9L*6, FT*1"] = {
				attributes = {},
				code_loadout =  {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["SEAD"] = {
			["SEAD LR - AGM-88*2, AIM-9L*2, AIM-120B*2, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["SEAD 2000s LR SEAD AGM88*2,AIM-120C*2, AIM-9X*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["SEAD 2000s SR SEAD AGM88*4,AIM-120C*2, AIM-9X*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["SEAD 90s LR SEAD AGM88*2,AIM-120B*2, AIM-9M*2, FT*3"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["SEAD 90s SR SEAD AGM88*4,AIM-120B*2, AIM-9M*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["SEAD 80s LR SEAD AGM88*2,AIM-9L*4, FT*3"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
			["SEAD 80s SR SEAD AGM88*4,AIM-9L*4,FT*1"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 3249,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["Anti-ship Strike"] = {
			["2000s LR AntiShip AGM65D*4,AIM-120C*2, AIM-9X*2, FT*3,TP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["2000s SR AntiShip AGM65D*4,AIM-120C*2, AIM-9X*2, FT*1,TP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s LR AntiShip AGM65D*4,AIM-120B*2, AIM-9M*2, FT*3,TP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["90s SR AntiShip AGM65D*4,AIM-120B*2, AIM-9M*2, FT*1,TP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s LR AntiShip AGM65D*4, AIM-9L*4, FT*3,TP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
					[1] = {
						["CLSID"] = "{AIM-9L}",
						["num"] = 1,
					},
					[2] = {
						["CLSID"] = "{AIM-9L}",
						["num"] = 2,
					},
					[3] = {
						["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
						["num"] = 3,
					},
					[4] = {
						["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
						["num"] = 4,
					},
					[5] = {
						["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
						["num"] = 5,
					},
					[6] = {
						["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
						["num"] = 6,
					},
					[7] = {
						["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
						["num"] = 7,
					},
					[8] = {
						["CLSID"] = "{AIM-9L}",
						["num"] = 8,
					},
					[9] = {
						["CLSID"] = "{AIM-9L}",
						["num"] = 9,
					},
					[11] = {
						["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
						["num"] = 11,
					},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["80s SR AntiShip AGM65D*4, AIM-9L*4, FT*1,TP"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"ship"},
				code_loadout =  {},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
					["pylons"] = {
						[1] = {
							["CLSID"] = "{AIM-9L}",
							["num"] = 1,
						},
						[2] = {
							["CLSID"] = "{AIM-9L}",
							["num"] = 2,
						},
						[3] = {
							["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
							["num"] = 3,
						},
						[4] = {
							["CLSID"] = "<CLEAN>",
							["num"] = 4,
						},
						[5] = {
							["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
							["num"] = 5,
						},
						[6] = {
							["CLSID"] = "<CLEAN>",
							["num"] = 6,
						},
						[7] = {
							["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
							["num"] = 7,
						},
						[8] = {
							["CLSID"] = "{AIM-9L}",
							["num"] = 8,
						},
						[9] = {
							["CLSID"] = "{AIM-9L}",
							["num"] = 9,
						},
						[11] = {
							["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
							["num"] = 11,
						},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},	
		["Strike"] = {
			["Strike GBU-10*2, AIM-120B*2, AIM-9L*2, FUEL*3, TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Cyprus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR AG GBU10*2,AIM-120C*2, AIM-9X*2, FT*3,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR AG GBU10*4,AIM-120C*2, AIM-9X*2, FT*1,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR AG GBU10*2,AIM-120B*2, AIM-9M*2, FT*3,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR AG GBU10*4,AIM-120B*2, AIM-9M*2, FT*1,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR AG GBU10*2,AIM-9M*4, FT*3,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR AG GBU10*4,AIM-9M*4, FT*1,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike GBU-12*4, AIM-120B*2, AIM-9L*2, FUEL*2, TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*GBU-12}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR AG GBU12*4,AIM-120C*2, AIM-9X*2, FT*3,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*GBU-12}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR AG GBU12*6,AIM-120C*2, AIM-9X*2, FT*1,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*GBU-12}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR AG GBU12*4,AIM-120B*2, AIM-9M*2, FT*3,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*GBU-12}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR AG GBU12*6,AIM-120B*2, AIM-9M*2, FT*1,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*GBU-12}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR AG GBU12*4,AIM-9M*4, FT*3,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*GBU-12}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR AG GBU12*4,AIM-9M*4, FT*1,TP"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*GBU-12}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{DB769D48-67D7-42ED-A2BE-108D566C8B1E}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike Turkey Cyprus AG - AGM65D*4"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR AG AGM65D*4,AIM-120C*2, AIM-9X*2, FT*3,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR AG AGM65D*4,AIM-120C*2, AIM-9X*2, FT*1,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR AG AGM65D*4,AIM-120B*2, AIM-9M*2, FT*3,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR AG AGM65D*4,AIM-120B*2, AIM-9M*2, FT*1,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s LR AG AGM65D*4, AIM-9L*4, FT*3,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 80s SR AG AGM65D*4, AIM-9L*4, FT*1,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 10000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR AG GBU38*4,AIM-120C*2, AIM-9X*2, FT*3,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR AG GBU38*4,AIM-120C*2, AIM-9X*2, FT*1,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR AG GBU38*4,AIM-120B*2, AIM-9M*2, FT*3,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR AG GBU38*4,AIM-120B*2, AIM-9M*2, FT*1,TP"] = {
				minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Crisis", "PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BRU57_2*GBU-38}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s LR AG GBU31*2,AIM-120C*2, AIM-9X*2, FT*3,TP"] = {
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 2000s SR AG GBU31*2,AIM-120C*2, AIM-9X*2, FT*1,TP"] = {
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Caucasus"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{5CE2FF2A-645A-4197-B48D-8720AC69394F}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s LR AG GBU31*2,AIM-120B*2, AIM-9M*2, FT*3,TP"] = {
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike 90s SR AG GBU31*2,AIM-120B*2, AIM-9M*2, FT*1,TP"] = {
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Crisis", "PG"},
					weaponType = "Guided bombs",
					expend = "Auto",
					day = true,
					night = true,
					adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = 20000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "<CLEAN>",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{GBU-31V3B}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				},
					}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Mk-82*6, AIM-120B*2, AIM-9L*2, FUEL*3, Pod"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{TER_9A_3*MK-82}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{TER_9A_3*MK-82}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Mk-82HD*6 , AIM-120B*2, AIM-9L*2, FUEL*3, Pod"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 315.5,
				hCruise = 3000.4,
				hAttack = 300,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{TER_9A_3*MK-82_Snakeye}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{TER_9A_3*MK-82_Snakeye}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Mk-84*2, AIM-120B*2, AIM-9L*2, FUEL*3, Pod"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["CBU-97*4, AIM-120B*2, AIM-9L*2, FT*3,pod"] = {
			minscore = 0.4,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AIM-9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*CBU-97}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2L*CBU-97}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
					["fuel"] = 3249,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},		
		},
	},
	["F-4E"] = {      --Phantom--
		["Anti-ship Strike"] = {
			["Anti-Ship Strike AGM-65K*4,AIM-7M*4,Fuel*3"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG"},
				weaponType = "ASM",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
                {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{D7670BC7-881B-4094-906C-73879CF7EB27}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{D7670BC7-881B-4094-906C-73879CF7EB28}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
                }, -- end of ["pylons"]	
				["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Anti-Ship Strike Turkey Cyprus AG - AGM65D*4"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"Cyprus"},
				weaponType = "ASM",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
                }, -- end of ["pylons"]	
				["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Intercept"] = {
			["Crisis AIM-7M*4,AIM-9*4,Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR AIM-9*4,AIM-7*4"] = {
				attributes = {},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Cyprus AIM-7M*4,AIM-9*4,Fuel"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Crisis AIM-9M*4, AIM-7M*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255,
				-- vAttack = 245,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR AIM-9*4,AIM-7*4"] = {
				attributes = {},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Cyprus AIM-9M*4, AIM-7M*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},		
		["Fighter Sweep"] = {
			["Crisis AIM-9M*4, AIM-7M*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR AIM-9*4,AIM-7*4"] = {
				attributes = {},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 2753.6,
				hAttack = 2753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Cyprus AIM-9M*4, AIM-7M*4, Fuel*3"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 9753.6,
				hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["Crisis Day, AIM-7M*4,AIM-9M*4,Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 246.66666666667,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR Medium AIM-9*4,AIM-7*4"] = {
				attributes = {"medium"},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 246.66666666667,
				hCruise = 4000,
				hAttack = 4000,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR Low AIM-9*4,AIM-7*4"] = {
				attributes = {"low"},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 246.66666666667,
				hCruise = 2000,
				hAttack = 2000,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Cyprus Day, AIM-7M*4,AIM-9M*4,Fuel"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 246.66666666667,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{F4-2-AIM9L}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			},
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},		
		["SEAD"] = {
			["Crisis AGM-45*4, AIM-7M*2, Fuel*1, ECM"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 10,
				stores = {
				["pylons"] = {
					[9] = {
						["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
						["num"] = 9,
					},
					[1] = {
						["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
						["num"] = 1,
					},
					[8] = {
						["CLSID"] = "{AGM_45A}",
						["num"] = 8,
					},
					[2] = {
						["CLSID"] = "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
						["num"] = 2,
					},
					[5] = {
						["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
						["num"] = 5,
					},
					[7] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 7,
					},
					[6] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 6,
					},
					[4] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 4,
					},
					[3] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 3,
					},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Cyprus AGM-45*2, AIM-7M*2, Fuel*1, ECM"] = {
				attributes = {},
				code_loadout =  {"Cyprus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Crisis Strike AGM-65D*4, AIM-7M*2, ECM, FT*3"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"SAM", "soft"},
				code_loadout =  {"IIW", "Crisis", "PG"},
					weaponType = "ASM",
					expend = "Auto",
					attackType = "Dive",
					day = true,
					night = false,
					adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Crisis Strike Mk20*6, AIM-7*2, AIM-9*4, ECM, FT"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft"},
				code_loadout =  {"IIW", "Crisis", "PG"},
					weaponType = "Bombs",
					expend = "All",
					attackType = "Dive",
					day = true,
					night = false,
					adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{9DDF5297-94B9-42FC-A45E-6E316121CD85}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},			
			["Crisis Strike Heavy Mk84*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"IIW", "Crisis", "PG"},
					weaponType = "Bombs",
					expend = "All",
					attackType = "Dive",
					day = true,
					night = false,
					adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
					[8] = {
						["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
						["num"] = 8,
					},
					[2] = {
						["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
						["num"] = 2,
					},
					[7] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 7,
					},
					[3] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 3,
					},
					[9] = {
						["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
						["num"] = 9,
					},
					[6] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 6,
					},
					[4] = {
						["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
						["num"] = 4,
					},
					[1] = {
						["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
						["num"] = 1,
					},
					[5] = {
						["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
						["num"] = 5,
					},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Crisis Mk-82*6, AIM-7M*4, Fuel*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW", "Crisis", "PG"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["IIW Rockets, AIM-7M*4, Fuel*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"IIW"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 1572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}",
					["num"] = 2,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA CAS1 AGM-65K*4,AIM-7*2,Fuel*2,ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"HWITC"},
					weaponType = "ASM",
					expend = "Auto",
					day = true,
					night = false,
					adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 3486.4,
				hAttack = 2572,
				standoff = 2000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{D7670BC7-881B-4094-906C-73879CF7EB28}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{D7670BC7-881B-4094-906C-73879CF7EB27}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA strike Mk-82*6,AIM-7*2,Fuel*2,ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "Structure", "SAM"},
				code_loadout =  {"HWITC"},
					weaponType = "Bombs",
					expend = "All",
					day = true,
					night = false,
					adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 3486.4,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["GTA CAS2 Mk20*6,AIM-7*2,Fuel*2,ECM"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"HWITC"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 3486.4,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			[" Cyprus Strike Heavy Mk84*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Cyprus Mk-82*6, AIM-7M*4, Fuel*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Turkey Cyprus AG - Rockeye*6"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Turkey Cyprus AG - AGM65D*4"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "SAM"},
				code_loadout =  {"Cyprus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 215,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
                }, -- end of ["pylons"]	
				["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Cyprus Rockets, AIM-7M*4, Fuel*2"] = {
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {},
				weaponType = "Rockets",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 1572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{8D399DDA-FF81-4F14-904D-099B34FE7918}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}",
					["num"] = 2,
				},
				[9] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}",
					["num"] = 1,
				},
			}, -- end of ["pylons"]
					["fuel"] = "4864",
					["flare"] = 30,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},		
	},
	["F-5E-3"] = {   ---Tiger---
		["Intercept"] = {
			["AIM-9P*2, Fuel_275*1"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 200000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
						[4] = 
						{
							["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
						}, -- end of [4]
					},
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["Day, AIM-9P*2, Fuel_275*3"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 246.66666666667,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 36000,
				tStation = 1800,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
						[4] = 
						{
							["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
						}, -- end of [4]
					},
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["AIM-9P*2, Fuel_275*1"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				standoff = 28000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
						[4] = 
						{
							["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
						}, -- end of [4]
					},
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["AIM-9P*2, Fuel_275*1"] = {
				attributes = {},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 7011,
				hAttack = 7011,
				standoff = 27000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
						[4] = 
						{
							["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
						}, -- end of [4]
					},
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["MR, Mk-82*4, AIM-9P*2, Fuel_275*1"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
						}, -- end of [6]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["SR, Mk-82*5, AIM-9P*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
						[4] = 
						{
							["CLSID"] = "{MER-5E_MK82x5}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["OCA, Mk-83*2, AIM-9P*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Parked Aircraft"},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[3] = 
						{
							["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
						}, -- end of [5]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["Mk-84*1, AIM-9P*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure"},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
						[4] = 
						{
							["CLSID"] = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["MR, CBU-52*4, AIM-9P*2, Fuel_275*1"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft"},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 7000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [6]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["SR, CBU-52*4, AIM-9P*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft"},
				code_loadout =  {"IIW", "Crisis", "PG", "Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 7000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [3]
						[5] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CBU-52B}",
						}, -- end of [6]
						[7] = 
						{
							["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
						}, -- end of [7]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["ammo_type"] = 1,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["GTA CAS1/STRIKE Mk-82SE*4,AIM-9P*2,Fuel 275"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"Bridge", "soft", "Parked Aircraft", "Structure", "SAM"},
				code_loadout =  {"HWITC", "Cyprus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 2486.4,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
				[1] = {
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{Mk82SNAKEYE}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 7,
				}, -- end of [7]
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["GTA CAS2/STRIKE CBU-52B*4,AIM-9P*2,Fuel 275"] = {
			minscore = 0.1,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"HWITC"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 350000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 2876.8,
				hAttack = 2572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = {
				["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{0395076D-2F77-4420-9D33-087A4398130B}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{CBU-52B}",
					["num"] = 2,
				},
					}, -- end of ["pylons"]
					["fuel"] = 2046,
					["flare"] = 15,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
	},
	["F-86F Sabre"] = {
		["Intercept"] = {
			["Intercept IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Intercept IPW - AIM-9*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 180,
				vAttack = 200,
				hCruise = 7096,
				hAttack = 7096,
				-- standoff = 36000,
				tStation = 1800,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			[" Escort IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				-- vAttack = 346.66666666667,
				-- hCruise = 7096,
				-- hAttack = 7096,
				standoff = 1000,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Fighter Sweep"] = {
			["Fighter Sweep IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Anti-ship Strike"] = {
			["IPW - Antiship Strike - 200gal Fuel*2, AIM-9*2, M117*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Antiship Strike - 200gal Fuel*2, AIM-9*2, AN-M64*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Antiship IPW - Strike - AIM-9*2, HVAR*16"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[9] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Antiship IPW - Strike - 200gal Fuel*2, AIM-9*2, HVAR*8"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},	
		},	
		["Strike"] = {
			["IPW - Strike - 200gal Fuel*2, AIM-9*2, M117*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - 200gal Fuel*2, AIM-9*2, HVAR*8"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - 200gal Fuel*2, AIM-9*2, AN-M64*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - IPW - Strike - AIM-9*2, HVAR*16"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[9] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},
	["F-117A"] = {
		["Strike"] = {
			["GBU-27*2"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"PG", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "All",
				day = false,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 120,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 8534.4,
				hAttack = 8534.4,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{EF0A9419-01D6-473B-99A3-BEBDB923B14D}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{EF0A9419-01D6-473B-99A3-BEBDB923B14D}",
						}, -- end of [2]
					}, -- end of ["pylons"]
					["fuel"] = "3840",
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["GBU-10*2"] = {
			minscore = 0.1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "Bridge"},
				code_loadout =  {"PG", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "All",
				day = false,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 120,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 8534.4,
				hAttack = 8534.4,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}",
						}, -- end of [2]
					}, -- end of ["pylons"]
					["fuel"] = "3840",
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},
	["Il-76MD"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				vCruise = 154.16666666667,
				vAttack = 154.16666666667,
				hCruise = 3500,
				hAttack = 3500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = 40000,
                    ["flare"] = 96,
                    ["chaff"] = 96,
                    ["gun"] = 100,
				},
			},
		},
	},
	["KC130"] = {
		["Refueling"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 216.66666666667,
				vAttack = 216.66666666667,
				hCruise = 7315.2,
				hAttack = 7315.2,
				standoff = nil,
				tStation = 21600,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 1.5,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
				["fuel"] = 20830,
                ["flare"] = 60,
                ["chaff"] = 120,
                ["gun"] = 100,
				},
			},
		},
	},
	["KC-135"] = {
		["Refueling"] = {
			["Default"] = {
				attributes = {"KC135"},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 216.66666666667,
				vAttack = 216.66666666667,
				hCruise = 7000,
				hAttack = 7000,
				standoff = nil,
				tStation = 21600,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = 90700,
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["KC135MPRS"] = {
		["Refueling"] = {
			["Default"] = {
				attributes = {"KC135MPRS"},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 220.66666666667,
				vAttack = 220.66666666667,
				hCruise = 7315.2,
				hAttack = 7315.2,
				standoff = nil,
				tStation = 21600,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = 90700,
					["flare"] = 60,
					["chaff"] = 120,
					["gun"] = 100,
				},
			},
		},
	},
	["M-2000C"] = {     --Mirage--
		["Intercept"] = {
			["80s 90s 2000s Day, MagicII*2, S-530D*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
				[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 8,
				},					
				},
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["80s 90s 2000s Day, MagicII*2, S-530D*2, FT*1"] = {
				attributes = {"Air Forces"},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 246.66666666667,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 8,
				},					
				},
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["80s 90s 2000s MagicII*2, S-530D*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = 27000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 8,
				},					
				},
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["80s 90s 2000s MagicII*2, S-530D*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 7011,
				hAttack = 7011,
				standoff = 27000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{Matra_S530D}",
					["num"] = 8,
				},					
				},
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["GBU-16*1, MagicII*2, FT*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
					["Laser Illumination"] = true,
				},
				attributes = {"Bridge", "Structure"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7924.8,
				hAttack = 7315.2,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{Eclair}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{M2KC_08_RPL541}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{M2KC_02_RPL541}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
			["GBU-12*4, MagicII*2, FT*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
					["Laser Illumination"] = true,
				},
				attributes = {"Bridge"},
				code_loadout =  {},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 7924.8,
				hAttack = 7315.2,
				standoff = 15000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{Eclair}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{M2KC_08_RPL541}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{M2KC_02_RPL541}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},			
			["80s 90s 2000s SR AG MK82*8,MagicII*2,FT*1"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 4876.8,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{M2KC_RAFAUT_MK82}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{M2KC_RAFAUT_MK82}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
			["80s 90s 2000s LR AG MK82*4,MagicII*2,FT*3"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 4876.8,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{M2KC_02_RPL541}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{M2KC_08_RPL541}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
			["80s 90s 2000s SR AG MK82HD*8,MagicII*2,FT*1"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{M2KC_RAFAUT_MK82A}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{M2KC_RAFAUT_MK82A}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
			["80s 90s 2000s LR AG MK82HD*4,MagicII*2,FT*3"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 350000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{M2KC_02_RPL541}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{M2KC_08_RPL541}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{Mk82AIR}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
			["80s 90s 2000s SR AG Belouga*8,MagicII*2,FT*1"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "SAM"},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 130000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{M2KC_RAFAUT_BLG66}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{M2KC_RAFAUT_BLG66}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
			["80s 90s 2000s LR AG Belouga*4,MagicII*2,FT*3"] = {
			minscore = 0.2,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "SAM"},
				code_loadout =  {"Cyprus", "Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = false,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 350.5,
				hCruise = 300.4,
				hAttack = 200,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{MMagicII}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{M2KC_02_RPL541}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{M2KC_08_RPL541}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{BLG66_BELOUGA_AC}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{M2KC_RPL_522}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 3165,
				["flare"] = 48,
				["chaff"] = 112,
				["gun"] = 100,
				},
			},
		},
	},
	["Mi-8MT"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"HWITC", "TF"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 40,
				vAttack = 40,
				hCruise = 500,
				hAttack = 500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[8] = {
					["CLSID"] = "PKT_7_62",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "KORD_12_7",
					["num"] = 7,
				},
			}, -- end of ["pylons"]
					["fuel"] = 1929,
                ["flare"] = 128,
                ["chaff"] = 0,
                ["gun"] = 0,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["ExhaustScreen"] = true,
                                            ["CargoHalfdoor"] = true,
                                            ["GunnersAISkill"] = 90,
                                            ["AdditionalArmor"] = true,
                                            ["NS430allow"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
		["Strike"] = {
			["Strike Rockets"] = {
				minscore = 0.3,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft"},
				code_loadout =  {"HWITC"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 40000,
				capability = 10,
				firepower = 1,
				vCruise = 40,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "PKT_7_62",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "KORD_12_7",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1929,
                ["flare"] = 128,
                ["chaff"] = 0,
                ["gun"] = 0,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["ExhaustScreen"] = true,
                                            ["CargoHalfdoor"] = true,
                                            ["GunnersAISkill"] = 90,
                                            ["AdditionalArmor"] = true,
                                            ["NS430allow"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["Mi-24P"] = {     --Hind--
		["Escort"] = {
			["Escort 4x9M114, 2xUPK-23"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 75,
				-- vAttack = 55,
				-- hCruise = 50,
				-- hAttack = 50,
				standoff = 6000,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "GUV_YakB_GSHP",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "GUV_YakB_GSHP",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 799,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Escort 2xB8V20+4xATGM_AT9-Heat+4xATGM_AT9-AA"] = {
				attributes = {},
				code_loadout =  {"Cyprus", "HWITC", "Crisis"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 75,
				-- vAttack = 55,
				-- hCruise = 50,
				-- hAttack = 50,
				standoff = 6000,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[6] = {
					["CLSID"] = "{2x9M220_Ataka_V}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{2x9M220_Ataka_V}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "GUV_YakB_GSHP",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "GUV_YakB_GSHP",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 799,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike 2xB8V20+8xATGM_9M114"] = {
				minscore = 0.1,		
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "SAM"},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 100000,
				capability = 1,
				firepower = 1,
				vCruise = 75,
				vAttack = 75,
				hCruise = 50,
				hAttack = 50,
				standoff = 6000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[6] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1055,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Strike 2xB8V20+8xATGM_AT9-Heat"] = {
				minscore = 0.1,		
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "SAM"},
				code_loadout =  {"Cyprus", "HWITC", "Crisis"},
				weaponType = nil,
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 100000,
				capability = 1,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 6000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[6] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1055,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Strike - Structures - AT9Heat*4 + S-24B*4"] = {
				minscore = 0.3,		
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"Structure"},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 100000,
				capability = 1,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 2000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[6] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{2x9M120_Ataka_V}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{APU_68_S-24}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{APU_68_S-24}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{APU_68_S-24}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{APU_68_S-24}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1055,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},		
	},
	["Mi-24V"] = {
		["Escort"] = {
			["Escort 4x9M114, 2xUPK-23"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 3000,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1551,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike - 8x9M114, 2xUPK-23"] = {
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"All"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 3000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{B919B0F4-7C25-455E-9A02-CEA51DB895E3}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1551,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},		
	},
	["Mi-26"] = {
		["Transport"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 5,
				firepower = 10,
				vCruise = 100,
				vAttack = 100,
				hCruise = 100,
				hAttack = 100,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "9600",
					["flare"] = 192,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},
	["MiG-19P"] = {
		["Intercept"] = {
			["Intercept IPW - Intercept - K-13A*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			-- ["Intercept  IPW K-13A*2, PTB-760*2"] = {
				-- attributes = {},
				-- code_loadout =  {"IPW71"},
				-- weaponType = nil,
				-- expend = nil,
				-- day = true,
				-- night = false,
				-- adverseWeather = false,
				-- range = 250000,
				-- capability = 10,
				-- firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = false,
				-- self_escort = true,
				-- sortie_rate = 6,
				-- stores = {
			-- ["pylons"] = {
				-- [6] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 6,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 1,
				-- },
				-- [5] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 2,
				-- },
			-- },
				-- ["fuel"] = "1800",
                -- ["flare"] = 0,
                -- ["chaff"] = 0,
                -- ["gun"] = 100,
				-- },
				-- ["AddPropAircraft"] = 
                                        -- {
                                            -- ["MissileToneVolume"] = 5,
                                            -- ["NAV_Initial_Hdg"] = 0,
                                            -- ["ADF_Selected_Frequency"] = 1,
                                            -- ["ADF_NEAR_Frequency"] = 303,
                                            -- ["ADF_FAR_Frequency"] = 625,
                                            -- ["MountSIRENA"] = true,
                                        -- }, -- end of ["AddPropAircraft"]
			-- },
		},
		["CAP"] = {
			["CAP IPW K-13A*2, PTB-760*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 6,
				firepower = 1,
				vCruise = 200,
				vAttack = 213.86666666667,
				hCruise = 7096,
				hAttack = 7096,
				standoff = 3000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
		["Escort"] = {
			[" Escort IPW K-13A*2, PTB-760*2"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				-- vAttack = 346.66666666667,
				-- hCruise = 7096,
				-- hAttack = 7096,
				standoff = 3000,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},	
		["Fighter Sweep"] = {
			["Fighter Sweep TF-Old-LR-AIM-9M*2,AIM7MH*4,FT*3"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},	
		["Anti-ship Strike"] = {
			["IPW - Strike - K-13A*2, FAB-250*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		["Antiship IPW - Strike SR - K-13A*2, ORO-57K*4"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},			
		},	
		["Strike"] = {
			["IPW - Strike - K-13A*2, FAB-250*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			["IPW - Strike SR - K-13A*2, ORO-57K*4"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			-- ["IPW - Strike - K-13A*2, PTB-760*2, FAB-250*2"] = {
			-- minscore = 0.3,
				-- support = {
					-- ["Escort"] = true,
					-- ["SEAD"] = false,
				-- },
				-- attributes = {"soft", "Parked Aircraft", "Structure"},
				-- code_loadout =  {"IPW71"},
				-- weaponType = "Bombs",
				-- expend = "All",
				-- attackType = "Dive",
				-- day = true,
				-- night = false,
				-- adverseWeather = false,
				-- range = 450000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 200,
				-- vAttack = 300.5,
				-- hCruise = 5486.4,
				-- hAttack = 4572,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = false,
				-- - self_escort = true,
				-- sortie_rate = 6,
				-- stores = {
					-- ["pylons"] = {
				-- [6] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 6,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 1,
				-- },
				-- [5] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 2,
				-- },
				-- [5] = {
					-- ["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					-- ["num"] = 2,
				-- },
			-- }, -- end of ["pylons"]
				-- ["fuel"] = "1800",
                -- ["flare"] = 0,
                -- ["chaff"] = 0,
                -- ["gun"] = 100,
				-- },
				-- ["AddPropAircraft"] = 
                                        -- {
                                            -- ["MissileToneVolume"] = 5,
                                            -- ["NAV_Initial_Hdg"] = 0,
                                            -- ["ADF_Selected_Frequency"] = 1,
                                            -- ["ADF_NEAR_Frequency"] = 303,
                                            -- ["ADF_FAR_Frequency"] = 625,
                                            -- ["MountSIRENA"] = true,
                                        -- }, -- end of ["AddPropAircraft"]
			-- },
			["IPW - Strike - K-13A*2, PTB-760*2, ORO-57K*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 1800,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["MiG-21Bis"] = {
		["Anti-ship Strike"] = {
			["Antiship IPW R-3R*1, R-3S*1, FT800L, S-24B*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{S-24B}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{S-24B}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 2280,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Antiship Strike - R-3R*1, R-3S*1, FT800L, FAB-500*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},	
		},
		["Intercept"] = {
			["R-60*4, R-3R*2, Fuel_800*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_490C_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["TF-Old-R-3R*2,R-3S*2,FT,ASO2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 5,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR ,R60*4 R3R*2,FT 800L"] = {
				attributes = {},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["R-60*4, R-3R*2, Fuel_450*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["TF-Old-R-3R*2,R-60M*4,FT,ASO2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 5,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-60M 2R}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-60M 2L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["TF-Old-R-3R*2,R-3S*2,FT,ASO2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 5,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["R-3R*2, R-3S*2, FT, ASO"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3S}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 220,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR Medium,R60*4 R3R*2,FT 800L"] = {
				attributes = {"medium"},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 220,
				hCruise = 4000,
				hAttack = 4200,
				standoff = 15000,
				tStation = 2400,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR Low,R60*4 R3R*2,FT 800L"] = {
				attributes = {"low"},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 220,
				hCruise = 2000,
				hAttack = 2000,
				standoff = 15000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},	
		["Escort"] = {
			["R-60*4, R-3R*2, Fuel_450*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				-- vAttack = 350,
				-- hCruise = 7500,
				-- hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["TF-Old-R-3R*2,R-60M*4,FT,ASO2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 5,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-60M 2R}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-60M 2L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["TF-Old-R-3R*2,R-3S*2,FT,ASO2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 5,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["R-3R*2, R-3S*2, FT, ASO"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				-- vAttack = 350,
				-- hCruise = 7500,
				-- hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3S}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				-- vAttack = 350,
				-- hCruise = 7500,
				-- hAttack = 5500,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR ,R60*4 R3R*2,FT 800L"] = {
				attributes = {},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				-- vAttack = 350,
				-- hCruise = 7500,
				-- hAttack = 5500,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["R-60*4, R-3R*2, Fuel_450*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["TF-Old-R-3R*2,R-3S*2,FT,ASO2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 5,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["TF-Old-R-3R*2,R-60M*4,FT,ASO2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 5,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-60M 2R}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-60M 2L}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["R-3R*2, R-3S*2, FT, ASO"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3S}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				code_loadout =  {"IPW71"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["GTA AIR/AIR ,R60*4 R3R*2,FT 800L"] = {
				attributes = {},
				code_loadout =  {"HWITC"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 225,
				vAttack = 250,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{R-3R}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-60 2L}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{R-60 2R}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 40,
					["chaff"] = 18,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, FAB-250*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71", "HWITC"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			-- ["IPW - Strike - R-3R*1, R-3S*1, FT800L, FAB-100*8"] = {
				-- minscore = 0.3,
				-- support = {
						-- ["Escort"] = true,
						-- ["SEAD"] = false,
					-- },
				-- attributes = {"soft", "Parked Aircraft"},
				-- code_loadout =  {"IPW71"},
				-- weaponType = "Bombs",
				-- expend = "All",
				-- attackType = "Dive",
				-- day = true,
				-- night = false,
				-- adverseWeather = false,
				-- range = 300000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 250,
				-- vAttack = 300,
				-- hCruise = 5500,
				-- hAttack = 4000,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = false,
				-- self_escort = false,
				-- sortie_rate = 6,
				-- stores = {
				-- ["pylons"] = {
				-- [5] = {
					-- ["CLSID"] = "{FAB-100-4}",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{R-3S}",
					-- ["num"] = 2,
				-- },
				-- [4] = {
					-- ["CLSID"] = "{R-3R}",
					-- ["num"] = 4,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{FAB-100-4}",
					-- ["num"] = 1,
				-- },
				-- [3] = {
					-- ["CLSID"] = "{PTB_800_MIG21}",
					-- ["num"] = 3,
				-- },
			-- }, -- end of ["pylons"]
                -- ["fuel"] = 2280,
					-- ["flare"] = 0,
					-- ["chaff"] = 0,
					-- ["gun"] = 100,
				-- },
			-- },
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, FAB-500*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71", "HWITC"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, UB16UM*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"IPW71", "HWITC"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{UB-16_S5M}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{UB-16_S5M}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, S-24B*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71", "HWITC"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{S-24B}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{S-24B}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
			-- ["GTA strike 2  GROM*2  FT800L"] = {
				-- minscore = 0.3,
				-- support = {
						-- ["Escort"] = true,
						-- ["SEAD"] = false,
					-- },
				-- attributes = {"soft", "Parked Aircraft", "Structure", "Bridge", "SAM"},
				-- code_loadout =  {"HWITC"},
				-- weaponType = "ASM",
				-- expend = "Auto",
				-- attackType = nil,
				-- day = true,
				-- night = false,
				-- adverseWeather = true,
				-- range = 700000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 200,
				-- vAttack = 250,
				-- hCruise = 3500,
				-- hAttack = 3000,
				-- standoff = 2000,
				-- tStation = nil,
				-- LDSD = false,
				-- self_escort = false,
				-- sortie_rate = 6,
				-- stores = {
				-- ["pylons"] = {
				-- [1] = {
					-- ["CLSID"] = "{R-60 2L}",
					-- ["num"] = 1,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Kh-66_Grom}",
					-- ["num"] = 2,
				-- },
				-- [3] = {
					-- ["CLSID"] = "{PTB_800_MIG21}",
					-- ["num"] = 3,
				-- },
				-- [4] = {
					-- ["CLSID"] = "{Kh-66_Grom}",
					-- ["num"] = 4,
				-- },
				-- [5] = {
					-- ["CLSID"] = "{R-60 2R}",
					-- ["num"] = 5,
				-- },
				-- [6] = {
					-- ["CLSID"] = "{ASO-2}",
					-- ["num"] = 6,
				-- },
			-- }, -- end of ["pylons"]
                -- ["fuel"] = 2280,
				-- ["flare"] = 40,
				-- ["chaff"] = 18,
				-- ["gun"] = 100,
				-- },
			-- },
			["GTA strike 1 S24*4 FT800L"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure", "SAM"},
				code_loadout =  {"HWITC"},
				weaponType = "Rockets",
				expend = "All",
				attackType = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{S-24A}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{S-24A}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{S-24A}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{S-24A}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{ASO-2}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 40,
				["chaff"] = 18,
				["gun"] = 100,
				},
			},
		},		
	},
	["MiG-23MLD"] = {
		["Intercept"] = {
			["R-24R*2, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["R-24R*1, R-24T*1, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{6980735A-44CC-4BB9-A1B5-591532F1DC69}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["R-24R*2, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 3,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7000,
				hAttack = 8000,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["R-24R*1, R-24T*1, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 3,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7000,
				hAttack = 8000,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{6980735A-44CC-4BB9-A1B5-591532F1DC69}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["R-24R*2, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 3,
				firepower = 1,
				vCruise = 250,
				-- vAttack = 350,
				-- hCruise = 7000,
				-- hAttack = 8000,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["R-24R*1, R-24T*1, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 3,
				firepower = 1,
				vCruise = 250,
				-- vAttack = 350,
				-- hCruise = 7000,
				-- hAttack = 8000,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{6980735A-44CC-4BB9-A1B5-591532F1DC69}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["R-24R*2, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 3,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7000,
				hAttack = 8000,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["R-24R*1, R-24T*1, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 3,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7000,
				hAttack = 8000,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[2] = 
						{
							["CLSID"] = "{6980735A-44CC-4BB9-A1B5-591532F1DC69}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}",
						}, -- end of [6]
					}, -- end of ["pylons"]
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},		
		["Strike"] = {
			["Strike FAB500*4, FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 6000,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
			},	
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Strike FAB500*2, R-60*4, FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 350,
				hCruise = 6000,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 3,
				},
			},	
					["fuel"] = "3800",
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},			
		},		
	},
	["MiG-25RBT"] = {
		["Reconnaissance"] = {
			["Default"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 600,
				vAttack = 700,
				hCruise = 12000,
				hAttack = 12000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike Fab500*2, R-60*2"] = {
				minscore = 0.3,
				attributes = {"Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "all",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 600,
				vAttack = 700,
				hCruise = 12000,
				hAttack = 8000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[4] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["Strike Fab500*4"] = {
				minscore = 0.3,
				attributes = {"Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "all",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 600,
				vAttack = 700,
				hCruise = 12000,
				hAttack = 8000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[4] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},
	["MiG-25PD"] = {
		["Intercept"] = {
			["R-40R*4"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 64,
					["chaff"] = 64,
					["gun"] = 100,
				},
			},
			["R-40R*2, R-40T*2"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 64,
					["chaff"] = 64,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["R-40R*4"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 600000,
				capability = 5,
				firepower = 1,
				vCruise = 600,
				vAttack = 700,
				hCruise = 12000,
				hAttack = 12000,
				standoff = 25000,
				tStation = 3600,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 64,
					["chaff"] = 64,
					["gun"] = 100,
				},
			},
			["R-40R*2, R-40T*2"] = {
				attributes = {},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 5,
				firepower = 1,
				vCruise = 600,
				vAttack = 700,
				hCruise = 12000,
				hAttack = 12000,
				standoff = 25000,
				tStation = nil,
				LDSD = true,
				self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 64,
					["chaff"] = 64,
					["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["R-40R*4"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 600,
				vAttack = 700,
				hCruise = 12000,
				hAttack = 12000,
				standoff = 25000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 64,
					["chaff"] = 64,
					["gun"] = 100,
				},
			},
			["R-40R*2, R-40T*2"] = {
				attributes = {},
				code_loadout =  {"IIW", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 1,
				firepower = 1,
				vCruise = 600,
				vAttack = 700,
				hCruise = 12000,
				hAttack = 12000,
				standoff = 25000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{4EDBA993-2E34-444C-95FB-549300BF7CAF}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}",
						}, -- end of [4]
					}, -- end of ["pylons"]
					["fuel"] = "15245",
					["flare"] = 64,
					["chaff"] = 64,
					["gun"] = 100,
				},
			},
		},		
	},
	["MiG-27K"] = {
		["SEAD"] = {
			["Kh-25MPU*2,R-60M*2,Fuel"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = "ASM",
				expend = nil,
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 300,
				vAttack = 400,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[2] = {
					["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
			},
			},
		},	
		["Strike"] = {
			["Kh-29T*2, R-60*2, FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure", "Bridge"},
				code_loadout =  {"IIW"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 300,
				vAttack = 400,
				hCruise = 5500,
				hAttack = 2000,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["GTA STRIKE1 Kh-29L*2,R-60M*2,Fuel"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,
				},
				attributes = {"Structure", "SAM", "Bridge"},
				code_loadout =  {"HWITC"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5315.2,
				hAttack = 2000,
				standoff = 2000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["GTA STRIKE2 Kh-25L*2,R-60M*2,Fuel"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure", "SAM"},
				code_loadout =  {"HWITC"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5924.8,
				hAttack = 2315.2,
				standoff = 2000,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
			["GTA FAB-500*2,FAB-250*2,R-60M*2,Fuel"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,
				},
				-- attributes = {"Bridge"},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"HWITC"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 277.5,
				hCruise = 5924.8,
				hAttack = 2315.2,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "4500",
                ["flare"] = 60,
                ["chaff"] = 60,
                ["gun"] = 100,
				},
			},
		},	
	},
	["MiG-29A"] = {
		["Intercept"] = {
			["Intercept R-73*4 - R-27ER*1 - R-27ET*1 - FT"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[7] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
					}, -- end of ["pylons"]
					["fuel"] = "3380",
					["flare"] = 30,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["R-27R*2, R-60M*4, Fuel*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
						[1] = 
						{
							["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						}, -- end of [1]
						[2] = 
						{
							["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						}, -- end of [2]
						[3] = 
						{
							["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
						}, -- end of [3]
						[4] = 
						{
							["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
						}, -- end of [4]
						[5] = 
						{
							["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
						}, -- end of [5]
						[6] = 
						{
							["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						}, -- end of [6]
						[7] = 
						{
							["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						}, -- end of [7]
					}, -- end of ["pylons"]
					["fuel"] = "3380",
					["flare"] = 30,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort  - R-73*4 - R-27ER*1 - R-27ET*1 - FT"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 260.83333333333,
				-- vAttack = 315.83333333333,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = 50000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[7] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = "3380",
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
			},
			["R-27R*2, R-60M*4, Fuel*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = 27000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [1]
					[2] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [2]
					[3] = 
					{
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
					}, -- end of [3]
					[4] = 
					{
						["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
					}, -- end of [4]
					[5] = 
					{
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
					}, -- end of [5]
					[6] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [6]
					[7] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [7]
				}, -- end of ["pylons"]
				["fuel"] = "3380",
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP R-73*4 - R-27ER*1 - R-27ET*1 - FT"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 213.83333333333,
				vAttack = 213.83333333333,
				hCruise = 7011,
				hAttack = 7011,
				-- standoff = 27000,
				tStation = 4000,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[7] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = "3380",
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
			},
			["R-27R*2, R-60M*4, Fuel*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 7011,
				hAttack = 7011,
				standoff = 27000,
				tStation = 2700,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [1]
					[2] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [2]
					[3] = 
					{
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
					}, -- end of [3]
					[4] = 
					{
						["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
					}, -- end of [4]
					[5] = 
					{
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
					}, -- end of [5]
					[6] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [6]
					[7] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [7]
				}, -- end of ["pylons"]
				["fuel"] = "3380",
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["Fighter Sweep R-73*4 - R-27ER*1 - R-27ET*1 - FT"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 260.83333333333,
				vAttack = 315.83333333333,
				hCruise = 7011,
				hAttack = 7011,
				standoff = 60000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[7] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
				["fuel"] = "3380",
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
			},
			["R-27R*2, R-60M*4, Fuel*1"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 7011,
				hAttack = 7011,
				standoff = 27000,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [1]
					[2] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [2]
					[3] = 
					{
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
					}, -- end of [3]
					[4] = 
					{
						["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
					}, -- end of [4]
					[5] = 
					{
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
					}, -- end of [5]
					[6] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [6]
					[7] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					}, -- end of [7]
				}, -- end of ["pylons"]
				["fuel"] = "3380",
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
			},	
		},		
	},
	["MiG-31"] = {
		["Intercept"] = {
			["Intercept  R-60M*4,R-33*4"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 1000000,
				capability = 10,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 6,
				},
				},	
				["fuel"] = 15500,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},	
		},	
		["Fighter Sweep"] = {
			["Intercept  R-60M*4,R-33*4"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability =  10,
				firepower = 1,
				vCruise = 300,
				vAttack = 500.555,
				hCruise = 10500,
				hAttack = 10000,
				standoff = 100000,
				-- tStation = 2700,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 6,
				},
				},
				["fuel"] = 15500,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Intercept  R-60M*4,R-33*4"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability =  10,
				firepower = 1,
				vCruise = 300,
				vAttack = 500.555,
				hCruise = 10500,
				hAttack = 10000,
				standoff = 100000,
				-- tStation = 2700,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 6,
				},
				},
				["fuel"] = 15500,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},		
		["CAP"] = {
			["Intercept  R-60M*4,R-33*4"] = {
				attributes = {"Mig-31"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 600000,
				capability =  10,
				firepower = 1,
				vCruise = 220,
				vAttack = 220.555,
				hCruise = 10500,
				hAttack = 10000,
				standoff = 100000,
				tStation = 3700,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 12,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 6,
				},
				},
				["fuel"] = 15500,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
	},
	["MirageF1"] = {
		["Intercept"] = {
			["Day, MagicII*2, S-530D*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},				
				},
				["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["Day, MagicII*2, S-530D*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 250000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 246.66666666667,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 36000,
				tStation = 1800,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},					
				},
				["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["MagicII*2, S-530D*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = 27000,
				tStation = nil,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},					
				},
				["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike Mk82*4, Magic *2, FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{M2KC_RAFAUT_MK82}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{M2KC_RAFAUT_MK82}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
			["Strike Belouga*4, Magic*2, FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{M2KC_RAFAUT_BLG66}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{M2KC_RAFAUT_BLG66}",
					["num"] = 3,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				}, -- end of ["pylons"]
                ["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
			["Strike Mk-83*2, Magic*2, FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}",
					["num"] = 3,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				}, -- end of ["pylons"]
                ["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
			["Strike Rockets*2, Magic*2, FT"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"IIW"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{Matra155RocketPod}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{Matra155RocketPod}",
					["num"] = 3,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				}, -- end of ["pylons"]
                ["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
		},			
		["Fighter Sweep"] = {
			["MagicII*2, S-530D*2, FT*1"] = {
				attributes = {},
				code_loadout =  {"IIW"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 360000,
				capability = 1,
				firepower = 1,
				vCruise = 245,
				vAttack = 245,
				hCruise = 7011,
				hAttack = 7011,
				standoff = 27000,
				tStation = nil,
				LDSD = true,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},					
				},
				["fuel"] = 4530,
				["flare"] = 50,
				["chaff"] = 50,
				["gun"] = 100,
				},
			},
		},		
	},
	["MirageF1CT"] = {
		["Anti-ship Strike"] = {
			["AS-30L*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"ship"},
				code_loadout =  {"IIW"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "ECARTOMETRE LASER",
					["num"] = 9,
				},
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{AS_30L}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{AS_30L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},
				[8] = {
					["CLSID"] = "COLD START",
					["num"] = 8,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
			},
			},
		},	
		["Strike"] = {
			["AS-30L*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure"},
				code_loadout =  {"IIW"},
				weaponType = "ASM",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "ECARTOMETRE LASER",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "COLD START",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{AS_30L}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{AS_30L}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
			["GBU-16"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Guided bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 400000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[7] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 7,
				},
				[1] = {
					["CLSID"] = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}",
					["num"] = 1,
				},
				-- [6] = {
					-- ["CLSID"] = "{Barax}",
					-- ["num"] = 6,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{Phimat}",
					-- ["num"] = 2,
				-- },
				[5] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{RP_35_F1}",
					["num"] = 4,
				},
				[8] = {
					["CLSID"] = "COLD START",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "ECARTOMETRE LASER",
					["num"] = 9,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "4530",
                ["flare"] = 50,
                ["chaff"] = 50,
                ["gun"] = 100,
				},
			},
		},		
	},
	["S-3B Tanker"] = {   --Viking--
		["Refueling"] = {
			["Low Track"] = {
				attributes = {"low"},
				code_loadout =  {"All"},
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 0.4,
				firepower = 1,
				vCruise = 200,
				vAttack = 150,
				hCruise = 1828.8,
				hAttack = 1828.8,
				tStation = 10800,
				sortie_rate = 12,
				stores = {
					["pylons"] = {},
					["fuel"] = 7813,
					["flare"] = 30,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
			["Medium Track"] = {
				attributes = {"medium"},
				code_loadout =  {"All"},
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 0.4,
				firepower = 1,
				vCruise = 200,
				vAttack = 150,
				hCruise = 6096,
				hAttack = 6096,
				tStation = 10800,
				sortie_rate = 12,
				stores = {
					["pylons"] = {},
					["fuel"] = 7813,
					["flare"] = 30,
					["chaff"] = 30,
					["gun"] = 100,
				},
			},
		},
	},
	["SA342M"] = {      --Gazelle--
		["Strike"] = {
			["Strike Cyprus Strike Hot3x4, FAS, IR Deflector"] = {
				minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Cyprus"},
				weaponType = nil,
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true, 
				range = 120000,
				capability = 10,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 4000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{HOT3D}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{HOT3G}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{HOT3D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{HOT3G}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{IR_Deflector}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 275,
                ["flare"] = 32,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Strike 80s,90s,2000s AG Hot3*4,IR deflector, Sand Filter"] = {
				minscore = 0.3,
				support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"IIW", "Crisis", "PG"},
				weaponType = nil,
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true, 
				range = 80000,
				capability = 10,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = 4000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{HOT3D}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{HOT3G}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{HOT3D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{HOT3G}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{FAS}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{IR_Deflector}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 275,
                ["flare"] = 32,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},
	["Su-17M4"] = {
		["Anti-ship Strike"] = {
			["Kh-25ML*4, R-60*2, FT*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"ship"},
				code_loadout =  {"IIW"},
				weaponType = "ASM",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = 18000,
				ingress = 15000,
				egress = 5000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
			},
			},
			["TF-Old-Kh-25ML*2,Kh-29L*2,R-60*2,FT*2"] = {
				minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"ship"},
				code_loadout =  {"TF80s", "TF80sRED"},
				weaponType = "ASM",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 100,
				hAttack = 200,
				standoff = 18000,
				ingress = 15000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{3468C652-E830-4E73-AFA9-B5F260AB7C3D}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{3468C652-E830-4E73-AFA9-B5F260AB7C3D}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
			},
			},
			["IPW - AntishipStrike - FAB 500 M62*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
			},
			},
		},	
		["Strike"] = {
			["Fab250*12, R-60*2, FT*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
				},
			},
			["Fab500*4, R-60*2, FT*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
				},
			},
			["Rockets, R-60*2, FT*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"IIW"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
				},
			},
			["LR Fab250*8, R-60*2, FT*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
				},
			},
			["LR Fab500*2, R-60*2, FT*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Structure"},
				code_loadout =  {"IIW"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
				},
			},
			["LR, Rockets, R-60*2, FT*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"IIW"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 300000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{414E383A-59EB-41BC-8566-2B5E0788ED1F}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 64,
                ["chaff"] = 64,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - FAB 500 M62*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - FAB 250*16"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{3E35F8C1-052D-11d6-9191-00A0249B6F00}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - RBK-500 PTAB-10-5*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"IPW71"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - S-13*25"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - S-24B*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"IPW71"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},		
	},
	["Su-24M"] = {
		["Anti-ship Strike"] = {
			["Antiship, Kh-31A*2,R-60M*4,Fuel"] = {
			minscore = 0.1,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"Crisis", "PG", "TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "ASM",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 110000,
				ingress = 50000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
				[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{4D13E282-DF46-4B23-864A-A9423DFDE504}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{16602053-4A12-40A2-B214-AB60D481B20E}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{4D13E282-DF46-4B23-864A-A9423DFDE504}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 8,
				}, -- end of [8]
                }, -- end of ["pylons"]	
				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},
		},		
		["SEAD"] = {
			["SEAD  Kh58*2_R60*4_L-081"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "Caucasus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 330,
				vAttack = 450,
				hCruise = 8000,
				hAttack = 8000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
			["pylons"] = {
				[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{FE382A68-8620-4AC0-BDF5-709BFE3977D7}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{0519A264-0AB6-11d6-9193-00A0249B6F00}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{FE382A68-8620-4AC0-BDF5-709BFE3977D7}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 8,
				},
				}, -- end of ["pylons"]
 				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},	
		},
		["Laser Illumination"] = {
			["Laser Illumination, R-60M*4, Fuel"] = {
				attributes = {},
				code_loadout =  {"Crisis", "PG", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 270,
				vAttack = 300,
				hCruise = 7096,
				hAttack = 7096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{0519A264-0AB6-11d6-9193-00A0249B6F00}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{7D7EC917-05F6-49D4-8045-61FC587DD019}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{7D7EC917-05F6-49D4-8045-61FC587DD019}",
					["num"] = 2,
				},
			},	
				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},	
		},
		["Strike"] = {
			["BGL, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
						["Laser Illumination"] = true,
					},
				attributes = {"soft", "Structure"},
				code_loadout =  {"Crisis", "PG", "Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 7096,
				hAttack = 7096,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[8] = {
					["CLSID"] = "{275A2855-4A79-4B2D-B082-91EA2ADF4691}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{0519A264-0AB6-11d6-9193-00A0249B6F00}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{39821727-F6E2-45B3-B1F0-490CC8921D1E}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{BA565F89-2373-4A84-9502-A0E017D3A44A}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{BA565F89-2373-4A84-9502-A0E017D3A44A}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{BA565F89-2373-4A84-9502-A0E017D3A44A}",
					["num"] = 7,
				},
				[2] = {
					["CLSID"] = "{BA565F89-2373-4A84-9502-A0E017D3A44A}",
					["num"] = 2,
				},
			},	
				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},	
			["Bombs 1, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 1,
					},
					[2] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 2,
					},
					[3] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 3,
					},
					[4] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 4,
					},
					[5] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 5,
					},
					[6] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 6,
					},
					[7] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 7,
					},
					[8] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 8,
					},
				},	
				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},	
			["Bombs 2, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 1,
					},
					[2] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 2,
					},
					[3] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 3,
					},
					[4] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 4,
					},
					[5] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 5,
					},
					[6] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 6,
					},
					[7] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 7,
					},
					[8] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 8,
					},
				},	
				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},
			["Bombs 3, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "SAM", "Structure"},
				code_loadout =  {"Crisis", "PG", "Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 1,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 1,
					},
					[2] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 2,
					},
					[3] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 3,
					},
					[4] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 4,
					},
					[5] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 5,
					},
					[6] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 6,
					},
					[7] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 7,
					},
					[8] = 
					{
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 8,
					},
				},	
				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},
		},		
	},
	["Su-24MR"] = {
		["Reconnaissance"] = {
			["Reco TANGAZH,ETHER,R-60M*2,Fuel*2"] = {
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {},
				code_loadout =  {"TF", "TF80s", "TF80sRED"},
				weaponType = nil,
				expend = nil,
				day = false,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 10,
				firepower = 10,
				vCruise = 250,
				vAttack = 350,
				hCruise = 10096,
				hAttack = 10096,
				standoff = nil,
				tStation = 2000,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
				[1] = {
					["CLSID"] = "{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{7D7EC917-05F6-49D4-8045-61FC587DD019}",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "{0519A262-0AB6-11d6-9193-00A0249B6F00}",
					["num"] = 5,
				},
				[7] = {
					["CLSID"] = "{7D7EC917-05F6-49D4-8045-61FC587DD019}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{0519A261-0AB6-11d6-9193-00A0249B6F00}",
					["num"] = 8,
				}, -- end of [8]
                }, -- end of ["pylons"]	
				["fuel"] = "11700",
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},
		},
	},
	["Su-25"] = {                   ---Frogfoot---
		["Strike"] = {
			["GTA CAS2 PATAB-1M(cluster)*6,R-60M*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				code_loadout =  {"HWITC"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 2500,
				hAttack = 2000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{7AEC222D-C523-425e-B714-719C0D1EB14D}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["GTA strike1 S-25L*6,R-60M*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"HWITC"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 2500,
				hAttack = 2000,
				standoff = 1000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 8,
				},
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["GTA strike2 Kh-25*4 R-60*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				code_loadout =  {"HWITC"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 2500,
				hAttack = 2000,
				standoff = 2000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				[8] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["GTA CAS1 S-8KOM*120,R-60M*2"] = {
				minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				code_loadout =  {"HWITC"},
				weaponType = "Rockets",
				expend = "All",
				day = true,
				night = false,
				adverseWeather = true,
				range = 150000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 3500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 4,
				},
				[7] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 10,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "2835",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
		},		
	},
	["Su-25T"] = {
		["SEAD"] = {
			["ARM, Fuel*2, ECM"] = {
				attributes = {},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 500,
				hAttack = 500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82D}",
						["num"] = 1,
					},
					[2] = 
					{
						["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 2,
					},
					[3] = 
					{
						["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
						["num"] = 3,
					},
					[4] = 
					{
						["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
						["num"] = 4,
					},
					[5] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 5,
					},
					[6] = 
					{
						["CLSID"] = "{0519A264-0AB6-11d6-9193-00A0249B6F00}",
						["num"] = 6,
					},
					[7] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 7,
					},
					[8] = 
					{
						["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
						["num"] = 8,
					},
					[9] = 
					{
						["CLSID"] = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",
						["num"] = 9,
					},
					[10] = 
					{
						["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 10,
					},
					[11] = 
					{
						["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82C}",
						["num"] = 11,
					},
				}, -- end of ["pylons"]
                ["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},	
		},
		["Strike"] = {
			["Bombs 1, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"SAM", "Structure"},
				code_loadout =  {"Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 1,
					},
					[2] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 2,
					},
					[3] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 3,
					},
					[4] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 4,
					},
					[5] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 5,
					},
					[7] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 7,
					},
					[8] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 8,
					},
					[9] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 9,
					},
					[10] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 10,
					},
					[11] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 11,
					},
				}, -- end of ["pylons"]
                ["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["Bombs 2, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"Parked Aircraft"},
				code_loadout =  {"Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 1,
					},
					[2] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 2,
					},
					[3] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 3,
					},
					[4] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 4,
					},
					[5] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 5,
					},
					[7] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 7,
					},
					[8] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 8,
					},
					[9] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 9,
					},
					[10] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 10,
					},
					[11] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 11,
					},
				}, -- end of ["pylons"]
                ["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["Bombs 3, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft"},
				code_loadout =  {"Caucasus"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 1,
					},
					[2] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 2,
					},
					[3] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 3,
					},
					[4] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 4,
					},
					[5] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 5,
					},
					[7] = 
					{
						["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						["num"] = 7,
					},
					[8] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 8,
					},
					[9] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 9,
					},
					[10] = 
					{
						["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
						["num"] = 10,
					},
					[11] = 
					{
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 11,
					},
				}, -- end of ["pylons"]
                ["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["BGL, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
						["Laser Illumination"] = true,
					},
				attributes = {"Structure", "soft"},
				code_loadout =  {"Caucasus"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = false,
				range = 800000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 500,
				hAttack = 5000,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 1,
				stores = {
				["pylons"] = {
				[11] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 11,
				},
				[10] = {
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[6] = {
					["CLSID"] = "{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}",
					["num"] = 6,
				},
				[9] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["Standoff, R-60M*4, Fuel"] = {
			minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = true,
					},
				attributes = {"soft", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability = 1,
				firepower = 1,
				vCruise = 230,
				vAttack = 250,
				hCruise = 500,
				hAttack = 1000,
				standoff = 15000,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[11] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 11,
				},
				[1] = {
					["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
					["num"] = 1,
				},
				[10] = {
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 10,
				},
				[2] = {
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[9] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 9,
				},
				[3] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
					["num"] = 8,
				},
				[4] = {
					["CLSID"] = "{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			-- ["Rockets, R-60M*4, Fuel"] = {
					-- support = {
						-- ["Escort"] = true,
						-- ["SEAD"] = true,
					-- },
				-- attributes = {"soft", "Parked Aircraft", "SAM"},
				-- code_loadout =  {"Caucasus"},
				-- weaponType = "Rockets",
				-- expend = "All",
				-- day = true,
				-- night = true,
				-- adverseWeather = true,
				-- range = 800000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 230,
				-- vAttack = 250,
				-- hCruise = 500,
				-- hAttack = 100,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = false,
				-- --- self_escort = false,
				-- sortie_rate = 6,
				-- stores = {
				-- ["pylons"] = 
				-- {
					-- [1] = 
					-- {
						-- ["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						-- ["num"] = 1,
					-- },
					-- [2] = 
					-- {
						-- ["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
						-- ["num"] = 2,
					-- },
					-- [3] = 
					-- {
						-- ["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
						-- ["num"] = 3,
					-- },
					-- [4] = 
					-- {
						-- ["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
						-- ["num"] = 4,
					-- },
					-- [5] = 
					-- {
						-- ["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						-- ["num"] = 5,
					-- },
					-- [7] = 
					-- {
						-- ["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
						-- ["num"] = 7,
					-- },
					-- [8] = 
					-- {
						-- ["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
						-- ["num"] = 8,
					-- },
					-- [9] = 
					-- {
						-- ["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
						-- ["num"] = 9,
					-- },
					-- [10] = 
					-- {
						-- ["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
						-- ["num"] = 10,
					-- },
					-- [11] = 
					-- {
						-- ["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						-- ["num"] = 11,
					-- },
				-- }, -- end of ["pylons"]
                -- ["fuel"] = "3790",
                -- ["flare"] = 128,
                -- ["chaff"] = 128,
                -- ["gun"] = 100,
				-- },
			-- },
		},		
	},
	["Su-25TM"] = {	
		["Anti-ship Strike"] = {
			["Antiship Kh-35*2_R-73*2_Fuel*2_MPS410_Kopyo-25"] = {
					minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "ASM",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 10,
				firepower = 1,
				vCruise = 220,
				vAttack = 260,
				hCruise = 296,
				hAttack = 296,
				standoff = 110000,
				ingress = 50000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
				[1] = 
                    {
                    ["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82D}",
                    }, -- end of [1]
                [2] = 
                    {
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					}, -- end of [2]
                [3] = 
                    {
                    ["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
                    }, -- end of [3]
                [5] = 
                    {
                    ["CLSID"] = "{2234F529-1D57-4496-8BB0-0150F9BDBBD3}",
                    }, -- end of [5]
                [6] = 
                    {
                    ["CLSID"] = "{F4920E62-A99A-11d8-9897-000476191836}",
                    }, -- end of [6]
                [7] = 
                    {
                    ["CLSID"] = "{2234F529-1D57-4496-8BB0-0150F9BDBBD3}",
                    }, -- end of [7]
                [9] = 
                    {
                    ["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
                    }, -- end of [9]
                [10] = 
                    {
                    ["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					}, -- end of [10]
                [11] = 
                    {
                ["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82D}",
                    }, -- end of [8]
                }, -- end of ["pylons"]	
				["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["Antiship Kh-31A*2_R-73*2_Fuel*2_MPS410_Kopyo-25"] = {
					minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = "ASM",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 10,
				firepower = 1,
				vCruise = 220,
				vAttack = 260,
				hCruise = 296,
				hAttack = 296,
				standoff = 110000,
				ingress = 50000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
				[1] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82D}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 3,
				},
				[5] = {
					["CLSID"] = "{4D13E282-DF46-4B23-864A-A9423DFDE50A}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{F4920E62-A99A-11d8-9897-000476191836}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{4D13E282-DF46-4B23-864A-A9423DFDE50A}",
					["num"] = 7,
				},
				[9] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{CBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 10,
				},
				[11] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82D}",
					["num"] = 11,
				}, -- end of [8]
                }, -- end of ["pylons"]	
				["fuel"] = "3790",
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
		},
	},
	["Su-27"] = {
		["Intercept"] = {
			["Intercept R-73*2,R-27ER*4,R-27ET*2,ECM"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
					["num"] = 10,
				},
				},	
				["fuel"] = 5590.18,
				["flare"] = 96,
				["chaff"] = 96,
				["gun"] = 100,
				},
			},	
		},	
		["Fighter Sweep"] = {
			["Sweep R-73*2,R-27ER*4,R-27ET*2,ECM"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability =  10,
				firepower = 1,
				vCruise = 260.222,
				vAttack = 300.555,
				hCruise = 8500,
				hAttack = 8500,
				standoff = 70000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
					["num"] = 10,
				},
				},
				["fuel"] = 5590.18,
				["flare"] = 96,
				["chaff"] = 96,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort R-73*2,R-27ER*4,R-27ET*2,ECM"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 800000,
				capability =  10,
				firepower = 1,
				vCruise = 260.222,
				vAttack = 300.555,
				hCruise = 8500,
				hAttack = 8500,
				standoff = 70000,
				tStation = nil,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
					["num"] = 10,
				},
				},
				["fuel"] = 5590.18,
				["flare"] = 96,
				["chaff"] = 96,
				["gun"] = 100,
				},
			},
		},		
		["CAP"] = {
			["CAP R-73*2,R-27ER*4,R-27ET*2,ECM"] = {
				attributes = {},
				code_loadout =  {"TF", "Caucasus"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 600000,
				capability =  10,
				firepower = 1,
				vCruise = 213.222,
				vAttack = 213.555,
				hCruise = 8500,
				hAttack = 8500,
				standoff = 70000,
				tStation = 3700,
				LDSD = true,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 7,
				},
				[8] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
					["num"] = 10,
				},
				},
				["fuel"] = 5590.18,
				["flare"] = 96,
				["chaff"] = 96,
				["gun"] = 100,
				},
			},
		},
	},
	["Tu-22M3"] = {	
		["Strike"] = {
			["Strike bombs"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Structure", "SAM"},
				code_loadout =  {"Caucasus"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = nil,
				day = false,
				night = true,
				adverseWeather = false,
				range = 900000,
				capability = 10,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					[3] = {
					["CLSID"] = "{AD5E5863-08FC-4283-B92C-162E2B2BD3FF}",
					["num"] = 3,
				},
					},
				["fuel"] = "50000",
                ["flare"] = 48,
                ["chaff"] = 48,
                ["gun"] = 100,
				},
			},
		},
		["Anti-ship Strike"] = {
			["Antiship  Kh-22N*3"] = {
					minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"TF", "TF80s", "TF80sRED", "Caucasus"},
				weaponType = "ASM",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 10,
				firepower = 1,
				vCruise = 250,
				vAttack = 300,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 200000,
				ingress = 50000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
					[5] = {
					["CLSID"] = "{12429ECF-03F0-4DF6-BCBD-5D38B6343DE1}",
					["num"] = 5,
					},
					[1] = {
					["CLSID"] = "{12429ECF-03F0-4DF6-BCBD-5D38B6343DE1}",
					["num"] = 1,
					},
					[3] = {
					["CLSID"] = "{12429ECF-03F0-4DF6-BCBD-5D38B6343DE1}",
					["num"] = 3,
					}, -- end of [8]
                }, -- end of ["pylons"]	
				["fuel"] = "50000",
                ["flare"] = 48,
                ["chaff"] = 48,
                ["gun"] = 100,
				},
			},
		},
	},
	["Tu-142"] = {	
		["Anti-ship Strike"] = {
			["Antiship Kh-35*6"] = {
					minscore = 0.3,
					support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				code_loadout =  {"TF", "TF80s", "TF80sRED"},
				weaponType = "ASM",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 10,
				firepower = 1,
				vCruise = 220,
				vAttack = 250,
				hCruise = 10096,
				hAttack = 10096,
				standoff = 110000,
				ingress = 50000,
				egress = 10000,
				MaxAttackOffset = 60,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
                {
					[1] = {
					["CLSID"] = "{C42EE4C3-355C-4B83-8B22-B39430B8F4AE}",
					["num"] = 1,
					},
                }, -- end of ["pylons"]	
				["fuel"] = "60000",
                ["flare"] = 48,
                ["chaff"] = 48,
                ["gun"] = 100,
				},
			},
		},
	},
	["UH-1H"] = {   --Huey--
		["Strike"] = {
			["Cyprus Strike rockets"] = {
				minscore = 0.1,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Structure"},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 80000,
				capability = 1,
				firepower = 1,
				vCruise = 55,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				-- self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "M134_L",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "XM158_MK5",
					["num"] = 2,
				},
				[5] = {
					["CLSID"] = "XM158_MK5",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "M134_R",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "M60_SIDE_R",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "M60_SIDE_L",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 631,
                ["flare"] = 60,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
		},
		["Transport"] = {
			["Cyprus Default"] = {
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {},
				code_loadout =  {"All"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				vCruise = 40,
				vAttack = 40,
				hCruise = 500,
				hAttack = 500,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = 
					{
					}, -- end of ["pylons"]
					["fuel"] = 631,
					["flare"] = 60,
					["chaff"] = 0,
					["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
		},		
	},		
}