
--~ Added 2 types of warheads: 

--~ 'enhanced_a2a_warhead' and 'directional_a2a_warhead'

--~ 'enhanced_a2a_warhead' is a more powerful warhead (factor 1.7) type for some human fired a2a missiles, 
--~ to support the new extended proximity fuses.

--~ 'directional_a2a_warhead' has the bonus factor 3.5, used specifically by:
--~ 120B, C, 9X and R77
--~ The reason fo the high factor is because these have VERY high prox ranges in relation to their explosive weight

--~ --Yoda

function enhanced_a2a_warhead(power) -- By Yoda
    local res = {};

    res.expl_mass = 1.7*power;
    res.other_factors = {1, 1, 1};
    res.obj_factors = {1, 1};
    res.concrete_factors = {1, 1, 1};
    res.cumulative_factor = 0;
    res.concrete_obj_factor = 0.0;
    res.cumulative_thickness = 0.0;
    
    return res;
end

function directional_a2a_warhead(power) -- By Yoda
    local res = {};

    res.expl_mass = 3.5*power;
    res.other_factors = {1, 1, 1};
    res.obj_factors = {1, 1};
    res.concrete_factors = {1, 1, 1};
    res.cumulative_factor = 0.0;
    res.concrete_obj_factor = 0.0;
    res.cumulative_thickness = 0.0;
    
    return res;
end

function simple_warhead(power)
    local res = {};

    res.expl_mass = power;
    res.other_factors = {1, 1, 1};
    res.obj_factors = {1, 1};
    res.concrete_factors = {1, 1, 1};
    res.cumulative_factor = 0;
    res.concrete_obj_factor = 0.0;
    res.cumulative_thickness = 0.0;
    
    return res;
end


function cumulative_warhead(power)
    local res = {};              
    
    res.expl_mass = power;
    res.other_factors = {1, 1, 1};
    res.obj_factors = {1, 1};
    res.concrete_factors = {1, 1, 1};
    res.cumulative_factor = 3.0;
    res.concrete_obj_factor = 0.0;
    res.cumulative_thickness = 0.2;
    
    return res;
end

function penetrating_warhead(power)
    local res = {};
    
    res.expl_mass = power;
    res.other_factors = {1, 1, 1};
    res.obj_factors = {1, 1};
    res.concrete_factors = {1, 1, 1};
    res.cumulative_factor = 1.0;
    res.concrete_obj_factor = 0.0;
    res.cumulative_thickness = 0.2;
    
    return res;
end

warheads = {}


---------------------------------------------
-- Rockets
---------------------------------------------
warheads["C_5"] = simple_warhead(0.37);

warheads["C_8"] = -- -8 shaped-charge, fragmented
{
    expl_mass        = 3.0, -- Warhead 3 kg, explosive 0.855 kg + fragments bonus
    other_factors    = { 1.0, 0.5, 0.5 },
    concrete_factors = { 1.0, 0.5, 0.1 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.3
};

warheads["C_8OFP2"] =  -- C-8OFP HE
{
    expl_mass        = 9.2, -- Warhead 9,2 kg, explosive 2.7 kg + fragments bonus
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 0.1 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 0.0,
    cumulative_thickness = 0.0
};

warheads["C_8CM"] = -- C-8 target-marking rocket
{
    transparency= 0.8,
    color = {1, 140/255, 0},
    intensity = 3,
    duration = 300,
};

warheads["C_13"] = -- -13 HE
{
    expl_mass        = 33.0, -- Warhead 33 kg, explosive 7 kg + fragments bonus
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 0.5 },
    concrete_obj_factor= 1.0;
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 0.0,
    cumulative_thickness = 0.0
}; 

warheads["C_24"] = simple_warhead(123.0); -- Warhead 123 kg, explosive 23.5 kg + fragments bonus

warheads["C_25"] = simple_warhead(190.0); -- Warhead 190 kg, explosive 27 kg + fragments bonus

warheads["GRAD_RAKETA"] = simple_warhead(18.4); -- Warhead 18.4 kg, explosive 6.4 kg + fragments bonus

warheads["URAGAN_RAKETA"] = -- 8K14 Scud-B

{
    expl_mass = 9000.0, 
    other_factors    = { 10.0, 100.0, 100.0 },
    concrete_factors = { 10.0, 100.0, 100.0 },
    concrete_obj_factor = 10.0,
    obj_factors      = { 10.0, 100.0, 100.0 },
    cumulative_factor= 4.0,
    cumulative_thickness = 4.0
};

warheads["HYDRA_70"] = simple_warhead(3.85); -- Warhead 3.85 kg, explosive 1.04 kg + fragments bonus

warheads["HYDRA_70WP"] =
{
    transparency= 0.8,
    color = {1, 1, 1},
    intensity = 3,
    duration = 300,
};

warheads["Zuni_127"] = simple_warhead(22.0); -- Warhead 22 kg, explosive ??? kg + fragments bonus


------------------------------------------------
-- Bombs
------------------------------------------------
warheads["FAB_100"] = simple_warhead(100.0); -- Explosive 45 kg + fragments bonus

warheads["FAB_250"] = simple_warhead(200.0); -- Explosive 100 kg + fragments bonus

warheads["FAB_500"] = simple_warhead(400.0); -- Explosive 200 kg + fragments bonus

warheads["FAB_1500"] = simple_warhead(1400.0); -- Explosive 700 kg + fragments bonus

warheads["BetAB_500"] = 
{
    expl_mass        = 200.0,
    other_factors    = { 0.5, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 3.0 },
    concrete_obj_factor= 2.0;
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 0.0,
    cumulative_thickness = 0.0
};

warheads["BetAB_500ShP"] = 
{
    expl_mass = 200.0,
    other_factors    = { 0.2, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 10.0 },
    concrete_obj_factor = 5.0,
    obj_factors      = { 0.2, 1.0, 1.0 },
    cumulative_factor= 5.0,
    cumulative_thickness = 0.0
};

warheads["M_117"] = simple_warhead(350.0); -- Explosive 175 kg + fragments bonus
warheads["Mk_81"] = simple_warhead(90.0); -- Explosive 45 kg + fragments bonus
warheads["Mk_82"] = simple_warhead(180.0); -- Explosive 89 kg + fragments bonus
warheads["Mk_83"] = simple_warhead(400.0); -- Explosive 202 kg + fragments bonus
warheads["Mk_84"] = simple_warhead(850.0); -- Explosive 428 kg + fragments bonus

warheads["KAB_500Kr"] = 
{
    expl_mass = 300.0,
    other_factors    = { 0.2, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 10.0 },
    concrete_obj_factor = 5.0,
    obj_factors      = { 0.2, 1.0, 1.0 },
    cumulative_factor= 5.0,
    cumulative_thickness = 0.0
};

warheads["KAB_500"] = warheads["KAB_500Kr"];

warheads["KAB_500KrOD"] = simple_warhead(560.0); -- Explosive 280 kg + fuel-air explosive bonus
warheads["KAB_1500Kr"] = simple_warhead(1100.0); 
warheads["GBU_10"] = simple_warhead(850.0); -- Explosive 428 kg + fragments bonus
warheads["GBU_11"] = simple_warhead(850.0); -- Explosive 428 kg + fragments bonus
warheads["GBU_12"] = simple_warhead(180.0); -- Explosive 89 kg + fragments bonus
warheads["GBU_22"] = simple_warhead(180.0); -- Explosive 89 kg + fragments bonus
warheads["GBU_16"] = simple_warhead(400.0); -- Explosive 202 kg + fragments bonus
warheads["GBU_17"] = simple_warhead(240.0); 
warheads["GBU_24"] = simple_warhead(850.0); -- Explosive 428 kg + fragments bonus
warheads["GBU_15"] = simple_warhead(850.0); -- Explosive 428 kg + fragments bonus

warheads["GBU_27"] = 
{
    expl_mass = 240.0, 
    other_factors    = { 0.2, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 10.0 },
    concrete_obj_factor = 5.0,
    obj_factors      = { 0.2, 1.0, 1.0 },
    cumulative_factor= 5.0,
    cumulative_thickness = 0.0
};

warheads["GBU_28"] = 
{
    expl_mass = 325.0, 
    other_factors    = { 0.2, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 10.0 },
    concrete_obj_factor = 5.0,
    obj_factors      = { 0.2, 1.0, 1.0 },
    cumulative_factor= 5.0,
    cumulative_thickness = 0.0
};

warheads["GBU_29"] = simple_warhead(850.0); -- Explosive 428 kg + fragments bonus
warheads["GBU_30"] = simple_warhead(400.0); -- Explosive 202 kg + fragments bonus
warheads["AGM_62"] = simple_warhead(230.0); -- Explosive 113 kg + fragments bonus

------------------------------------------------
-- Missiles AA
------------------------------------------------
warheads["R_550"] = simple_warhead(13.0);
warheads["MICA_T"] = enhanced_a2a_warhead(12.0);
warheads["MICA_R"] = enhanced_a2a_warhead(12.0);
warheads["Super_530F"] = simple_warhead(27.0);
warheads["P_40T"] = simple_warhead(38.0);
warheads["P_40R"] = simple_warhead(38.0);
warheads["P_24R"] = simple_warhead(25.0);
warheads["P_24T"] = simple_warhead(25.0);
warheads["P_60"] = simple_warhead(3.5);
warheads["P_33E"] = simple_warhead(47.0);
warheads["P_27AE"] = simple_warhead(39.0);
warheads["P_27P"] = simple_warhead(39.0);
warheads["P_27PE"] = simple_warhead(39.0);
warheads["P_27T"] = simple_warhead(39.0);
warheads["P_27TE"] = simple_warhead(39.0);
warheads["P_27EM"] = simple_warhead(39.0);
warheads["P_73"] = enhanced_a2a_warhead(8.0);
warheads["P_77"] = directional_a2a_warhead(22.0);
warheads["P_37"] = simple_warhead(60.0);
warheads["AIM_7"] = enhanced_a2a_warhead(39.0);
warheads["AIM_9"] = enhanced_a2a_warhead(10.0);
warheads["AIM_9P"] = enhanced_a2a_warhead(11.0);
warheads["AIM_9X"] = directional_a2a_warhead(10.0);
warheads["AIM_54"] = simple_warhead(60.75);
warheads["AIM_120"] = directional_a2a_warhead(22.0);
warheads["AIM_120C"] = directional_a2a_warhead(22.0);

-----------------------------------------------------
-- Missiles AG
-----------------------------------------------------
warheads["S_25L"] = simple_warhead(150.0);
warheads["X_22"] = simple_warhead(1000.0);
warheads["X_23"] = simple_warhead(108.0);
warheads["X_23L"] = simple_warhead(108.0);
warheads["X_28"] = simple_warhead(155.0);
warheads["X_25ML"] = simple_warhead(90.0);
warheads["X_25MP"] = simple_warhead(90.0);
warheads["X_25MR"] = simple_warhead(90.0);
warheads["X_58"] = simple_warhead(150.0);
warheads["X_59M"] = simple_warhead(315.0);
warheads["X_29L"] = simple_warhead(317.0);
warheads["X_29T"] = simple_warhead(317.0);
warheads["X_29TE"] = simple_warhead(317.0);
warheads["X_55"] = simple_warhead(410.0);
warheads["X_65"] = simple_warhead(500.0);
warheads["X_15"] = simple_warhead(150.0);
warheads["X_31A"] = penetrating_warhead(90.0);
warheads["AGM_84E"] = simple_warhead(222.0);
warheads["AGM_86"] = simple_warhead(450.0);
warheads["AGM_45"] = simple_warhead(66.0);
warheads["AGM_88"] = simple_warhead(66.0);
warheads["AGM_122"] = simple_warhead(10.2);
warheads["AGM_123"] = simple_warhead(454.0);
warheads["AGM_130"] = simple_warhead(870.0);
warheads["ALARM"] = simple_warhead(66.0);
warheads["BGM_109B"] = simple_warhead(454.0);
warheads["AGM_154"] = simple_warhead(89.0);

warheads["AGM_65E"] = 
{
    expl_mass        = 39.0, -- Warhead 56,25 kg, explosive 39 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 2.0
};

warheads["AGM_65K"] = 
{
    expl_mass        = 39.0, -- Warhead 56,25 kg, explosive 39 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 2.0
};

warheads["AGM_65D"] = 
{
    expl_mass        = 39.0, -- Warhead 56,25 kg, explosive 39 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 2.0
};

warheads["AGM_65H"] = 
{
    expl_mass        = 39.0, -- Warhead 56,25 kg, explosive 39 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 2.0
};

warheads["AGM_65G"] = 
{
    expl_mass        = 36.3, -- Warhead 135,0 kg, explosive 36,3 kg 
    other_factors    = { 0.5, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 3.0 },
    concrete_obj_factor = 2.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 0.0,
    cumulative_thickness = 0.0
};
    
warheads["TGM_65G"] = simple_warhead(0);
warheads["TGM_65D"] = simple_warhead(0);
warheads["CATM_65K"] = simple_warhead(0);
warheads["TGM_65H"] = simple_warhead(0);


------------------------------------------------------
-- ATGM
------------------------------------------------------
warheads["Vikhr_M"] = 
{
    expl_mass        = 4.0, -- Warhead 8 kg, explosive 4 kg + fragments bonus
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.9
};

warheads["Vikhr"] = 
{
    expl_mass        = 4.0, -- Warhead 8 kg, explosive 4 kg + fragments bonus
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.9
};

warheads["AT_6"] = 
{
    expl_mass        = 2.4, -- Warhead 5,4 kg, explosive 2,4 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.75
};

warheads["MALUTKA"] = 
{
    expl_mass        = 2.2, -- Warhead 3,5 kg, explosive 2,2 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.6
};

warheads["KONKURS"] = 
{
    expl_mass        = 1.5, -- Warhead 2,7 kg, explosive ??? kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.4
};

warheads["P_9M117"] = 
{
    expl_mass        = 1.5, -- Warhead 7 kg, explosive ??? kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.55
};

warheads["P_9M133"] = 
{
    expl_mass        = 3.5, -- Warhead ??? kg, explosive ??? kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 1.0
};


warheads["TOW"] = 
{
    expl_mass        = 3.6, -- Warhead 5,9 kg, explosive 3,6 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.9
};

warheads["AGM_114"] = 
{
    expl_mass        = 6.17, -- Warhead 9,89 kg, explosive 6,17 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 0.9
};

warheads["AGM_114K"] = 
{
    expl_mass        = 5.67, -- Warhead 9,89 kg, explosive 5,67 kg 
    other_factors    = { 1.0, 1.0, 1.0 },
    concrete_factors = { 1.0, 1.0, 1.0 },
    concrete_obj_factor = 0.0,
    obj_factors      = { 1.0, 1.0 },
    cumulative_factor= 3.0,
    cumulative_thickness = 1.2
};


------------------------------------------------------
--- Antiship Missiles
------------------------------------------------------
warheads["X_31P"] = penetrating_warhead(90.0);
warheads["X_35"] = simple_warhead(145.0);
warheads["X_41"] = simple_warhead(320.0);
warheads["AGM_84A"] = simple_warhead(225.0);
warheads["AGM_84S"] = simple_warhead(225.0);
warheads["Sea_Eagle"] = simple_warhead(230.0);
warheads["Kormoran"] = simple_warhead(165.0);
warheads["AGM_119"] = simple_warhead(140.0);
warheads["P_35"] = simple_warhead(930.0);
warheads["P_500"] = simple_warhead(1000.0);
warheads["P_700"] = simple_warhead(1000.0);
warheads["P_15U"] = simple_warhead(490.0);
warheads["P_120"] = simple_warhead(500.0);
warheads["R_85"] = simple_warhead(930.0);
warheads["R_85U"] = simple_warhead(300.0);


------------------------------------------------------
-- SAM Missile
------------------------------------------------------
warheads["SeaSparrow"] = simple_warhead(39.0); -- RIM-7 Sea Sparrow
warheads["SM_2"] = simple_warhead(98.0); -- SM-2 RIM-66
warheads["SA5B55"] = simple_warhead(133.0); -- SA-10 S-300PS
warheads["SA48H6E2"] = simple_warhead(143.0); -- SA-N-10 S-300F
warheads["SA9M82"] = simple_warhead(150.0); -- SA-12
warheads["SA9M83"] = simple_warhead(150.0); -- SA-12
warheads["SAV611"] = simple_warhead(80.0); --Volna
warheads["SA3M9M"] = simple_warhead(59.0); -- SA-6 Kub
warheads["SA9M33"] = simple_warhead(15.0); -- SA-8 Osa
warheads["SA9M31"] = simple_warhead(0.95); -- SA-9 Strela-1   (2.6)
warheads["SA9M38M1"] = simple_warhead(70.0); --SA-11 Buk
warheads["SA9M333"] = simple_warhead(1.8); -- SA-13 Strela-10 (4.0)
warheads["SA9M330"] = simple_warhead(14.5); -- SA-15 Tor
warheads["SA9M311"] = simple_warhead(9.0); -- SA-19 Tunguska
warheads["Igla_1E"] = simple_warhead(1.5); -- SA-18 Igla-S
warheads["MIM_104"] = simple_warhead(73.0); -- Patriot
warheads["MIM_72G"] = simple_warhead(10.0); -- Chaparrel
warheads["FIM_92C"] = simple_warhead(0.8); -- Stinger          (0.7)
warheads["SA5B27"] = simple_warhead(60.0); -- SA-3 S-125 
warheads["HAWK_RAKETA"] = simple_warhead(70.0); -- Hawk
warheads["ROLAND_R"] = simple_warhead(6.5); -- Roland






--  

--[[
expl_mass        = 2.0, 
        

 other_factors   =  { HE1, HE2, HE3};
      :
HE1.     (expl_mass *HE1)
HE2.    
HE3.     

 concrete_factors = { HE1, HE2, HE3},
      :
HE1     (expl_mass *HE1)
HE2    
HE3     

 concrete_obj_factor = CP,
 -     :
CP  -     (expl_mass *CP)

 obj_factors      = { HE1, HE2 },
        ():
HE1     (expl_mass *HE1)
HE2    

 cumulative_factor= SC,
SC       (expl_mass *SC)
 cumulative_thickness = TH
TH -   ,      ( ).  
        ,     .


           10 . 

   :

obj_factors = {0.5, 1}, 
concrete_factors = {0.8, 1, 1}, 
other_factors = {0.9, 1, 1}, 
cumulative_factor = 5, 
concrete_obj_factor = 3
cumulative_thickness = 0.05

, 

1.      ,     10*0.9 = 9
2.       ,     10*0.8,       3*10 = 30   
3.      ,     10*0.5, 
          5*10=50   ,     5 .

 ,        ,   simple_warhead,     -  .       - .


--]]