local R550_M1 =
{
    category = CAT_AIR_TO_AIR,
	name = "R_550_M1",
	user_name = _("R550 Magic 1"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3}, 
    M = 89.0,
    H_max = 15000.0,
    H_min = 1.0,
    Diam = 157.0,
    Cx_pil = 2,
    D_max = 7000.0,
    D_min = 500.0,
    Head_Form = 0,
    Life_Time = 30.0,
    Nr_max = 35,
    v_min = 140.0,
    v_mid = 400.0,
    Mach_max = 2.0,
    t_b = 0.0,
    t_acc = 2.0,
    t_marsh = 0.0,
    Range_max = 10000.0,
    H_min_t = 10.0,
    Fi_start = 0.53,
    Fi_rak = 1.1,
    Fi_excort = 0.53,
    Fi_search = 0.044,
    OmViz_max = 0.52,
    warhead = predefined_warhead("R_550"),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -1.45,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 5.0,
	--seeker sensivity params
    SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters. 
	ccm_k0 = 2.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.	
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.016, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "magic-r550_1",
			file	 = "magic-r550_1",
			life	 = 1,
			fire	 = {0, 1},
			username = "magic-r550_1",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	ModelData = {   58 ,  -- model params count
		0.4 ,   -- characteristic square (характеристическая площадь)
			
		-- параметры зависимости Сx
		0.05 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.1 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.5 , -- Cx_k4 крутизна спада за волновым кризисом 
		0.8 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
		
		-- параметры зависимости Cy
		2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end		   -- Stage
		-1.0,		   -1.0,	2.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	11.8,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	25000.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		30.0, -- таймер самоликвидации, сек
		30.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		370, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		6.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-8.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-1.2, -- производная по высоте производной дальности по скорости цели, ЗПС
		8900, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		2900.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		14000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		5300.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		6700.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		1800.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.35, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(R550_M1)

local R550_M2 =
{
	category = CAT_AIR_TO_AIR,
	name = "R_550",
	user_name = _("R550 Magic 2"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,R_550},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3}, 
    M = 89.0,
    H_max = 18000.0,
    H_min = 1.0,
    Diam = 157.0,
    Cx_pil = 2,
    D_max = 4000.0,
    D_min = 500.0,
    Head_Form = 0,
    Life_Time = 30.0,
    Nr_max = 30,
    v_min = 140.0,
    v_mid = 400.0,
    Mach_max = 2.0,
    t_b = 0.0,
    t_acc = 1.88,
    t_marsh = 0.0,
    Range_max = 10000.0,
    H_min_t = 10.0,
    Fi_start = 0.96,
    Fi_rak = 3.14152,
    Fi_excort = 0.96,
    Fi_search = 0.044,
    OmViz_max = 0.52,
    warhead = predefined_warhead("R_550"),
    exhaust = { 0.7, 0.7, 0.7, 1.0 },
    X_back = -1.45,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 5.0,
	--seeker sensivity params
	SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. 
	ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.	
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.016, -- площадь выходного сечения сопла
	
	shape_table_data =
	{
		{
			name	 = "magic-r550",
			file	 = "magic-r550",
			life	 = 1,
			fire	 = {0, 1},
			username = "magic-r550",
			index 	 = R_550,
		},
	},
	
	ModelData = {   58 ,  -- model params count
		0.4 ,   -- characteristic square (характеристическая площадь)
			
		-- параметры зависимости Сx
		0.05 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.1 , -- Cx_k1 высота пика волнового кризиса
		0.01 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.5 , -- Cx_k4 крутизна спада за волновым кризисом 
		0.8 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
			
		-- параметры зависимости Cy
		2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		   -1.0,	1.88,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	12.58,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	29750.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		30.0, -- таймер самоликвидации, сек
		30.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		450, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		6.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-8.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-1.2, -- производная по высоте производной дальности по скорости цели, ЗПС
		10000, -- дальность ракурс 180(навстречу) град, Н=5000м, V=900км/ч, м
		3300.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м
		16000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		6000.0, -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		7500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		2100.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.35, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(R550_M2)

local desc_IR = " ".._("IR AAM")

local R550_variants =
{
	["Magic_2"] = {picture = "r60.png",   CLSID = "{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", display_name = R550_M2.user_name ..desc_IR, wstype = R550_M2.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = R550_M2.M },
	["Magic_1"] = {picture = "r60.png",   CLSID = "{R550_Magic_1}",                         display_name = R550_M1.user_name ..desc_IR, wstype = R550_M1.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = R550_M1.M },
}

local R550_DRAG  			  = R550_M1.Cx_pil / 4096.0 -- 4096 - magic number from long time ago when flanker was 1.5 
local R550_DRAG_WITH_ADAPTER  = R550_DRAG + 0.0002 -- TODO verify this value 

local function r550_with_adapter(CLSID, r550_variant)
	local var = R550_variants[r550_variant] or R550_variants["Magic_1"]
	declare_loadout({
		category			= var.category,
		CLSID 				= CLSID,
		Picture				= "r60.png",
--        PictureBlendColor   = "0xffffffff",
		displayName			=	var.display_name,
		wsTypeOfWeapon		=   var.wstype,
		attribute			=	{4,	4,	32,	111},--  TODO update this
		Cx_pil				=	R550_DRAG_WITH_ADAPTER,
		Count				=	1,
		Weight_Empty		=	39,
		Weight				=	39 + var.mass,
		Elements			=	
		{
			{ShapeName	=	"aero-3b",	    IsAdapter  	   =   true  }, -- TODO replace adapter model!!!
			{ShapeName	=	r550_variant,	connector_name 	= "Point" },
		}-- end of Elements
	})
end--]]

r550_with_adapter	 ("{R550_Magic_1_M21}",                "Magic_1")
r550_with_adapter	 ("{R550_Magic_2_M21}",                "Magic_2")
-----------------------------------------------------------------------------------------------------------------
--PL-5EII

local pl5eii_mass = 83.0
local pylon_mass = 70.0

PL_5EII_AA = {
    category        = CAT_AIR_TO_AIR,
    name            = 'PL-5EII',
    user_name       = _('PL-5EII'),
    wsTypeOfWeapon  = {4,4,7,WSTYPE_PLACEHOLDER},
    Escort          = 0,
    Head_Type       = 1,
    sigma           = {3, 3, 3},
    M               = pl5eii_mass,
    H_max           = 14000.0,
    H_min           = -1.0,
    Diam            = 127.0,
    Cx_pil          = 1.6,
    D_max           = 7500.0,
    D_min           = 300.0,
    Head_Form       = 0,
    Life_Time       = 60.0,
    Nr_max          = 35,
    v_min           = 140.0,
    v_mid           = 350.0,
    Mach_max        = 2.7,
    t_b             = 0.0,
    t_acc           = 6.0,
    t_marsh         = 0.0,
    Range_max       = 16000.0,
    H_min_t         = 1.0,
    Fi_start        = 0.3,
    Fi_rak          = 3.14152,
    Fi_excort       = 0.79,
    Fi_search       = 0.09,
    OmViz_max       = 0.61,
    warhead         = simple_aa_warhead(11.5, 127);
    exhaust         = tail_solid1;
    X_back          = -1.55,
    Y_back          = -0.071,
    Z_back          = 0.0,
    Reflection      = 0.0182,
    KillDistance    = 7.0,
    --seeker sensivity params
    ccm_k0                  = 0.5,
    SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters.
    SeekerCooled            = true, -- True is cooled seeker and false is not cooled seeker.

    supersonic_A_coef_skew  = 0.25,
    nozzle_exit_area        = 0.0068,

    shape_table_data = {
        {
            name     = 'PL-5EII',
            file     = 'pl5eii',
            life     = 1,
            fire     = {0, 1},
            username = 'PL-5EII',
            index    = WSTYPE_PLACEHOLDER,
        },
    },

    ModelData = {
        58 ,  -- model params count
        0.4 ,   -- characteristic square (характеристическая площадь)

        -- параметры зависимости Сx
        0.049 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
        0.082 , -- Cx_k1 высота пика волнового кризиса
        0.010 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
        0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
        0.550 , -- Cx_k4 крутизна спада за волновым кризисом
        0.8 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))

        -- параметры зависимости Cy
        2.5 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
        0.8     , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
        1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом

        0.13 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
        0.0, --угловая скорость создаваймая моментом газовых рулей

        -- Engine data. Time, fuel flow, thrust.
        -- t_statr    t_b     t_accel   t_march   t_inertial        t_break        t_end           -- Stage
        -1.0,        -1.0,          6,    0.0,        0.0,            0.0,        1.0e9,           -- time of stage, sec
         0.0,         0.0,        5.3,    0.0,        0.0,            0.0,          0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
         0.0,         0.0,    11500.0,    0.0,        0.0,            0.0,          0.0,           -- thrust, newtons

        1.0e9, -- таймер самоликвидации, сек
        60.0, -- время работы энергосистемы, сек
        0, -- абсолютная высота самоликвидации, м
        0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
        1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
        1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м
        0.0,  -- синус угла возвышения траектории набора горки
        30.0, -- продольное ускорения взведения взрывателя
        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
        1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
        1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
        2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

        -- DLZ data. Use numbers below for your implemetation.
        9.0, -- производная дальности по скорости носителя на высоте 1км, ППС
        -13.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
        -2.1, -- производная по высоте производной дальности по скорости цели, ЗПС
        15500.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
        5500.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м 
        27000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
        10000.0,  -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
        10500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
        3500.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
        2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
        0.55, -- процент гарантированной дальности от дальности в ППС на высоте 1км
        -0.01, -- производная процента гарантированной дальности в ППС по высоте
        0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
    },
}

declare_weapon(PL_5EII_AA)

local PL_5EII_DRAG 		  = 0.00077
local PL_5EII_DRAG_WITH_ADAPTER  = PL_5EII_DRAG + 0.0002 -- TODO verify this value 

declare_loadout({
	category			= CAT_AIR_TO_AIR,
	CLSID 				= '{PL-5EII_M21}',
	Picture				= 'pl5eii.png',
    --PictureBlendColor   = "0xffffffff",
	displayName			=	"PL-5EII"..desc_IR,
	wsTypeOfWeapon		=   PL_5EII_AA.wsTypeOfWeapon,
	attribute			=	{4,	4,	32,	111},--  TODO update this
	Cx_pil				=	PL_5EII_DRAG_WITH_ADAPTER,
	Count				=	1,
	Weight_Empty		=	39,
	Weight				=	39 + pl5eii_mass,
	Elements			=	
	{
		{ShapeName	=	"aero-3b",	    IsAdapter  	   =   true  }, -- TODO replace adapter model!!!
		{ShapeName	=	'PL_5EII_AA',	connector_name 	= "Point" },
	}-- end of Elements
	})

-----------------------------------------------------------------------------------------------------------------
-- PL-8A

local PL_8_DRAG 		  = 0.001959765625
local PL_8_DRAG_WITH_ADAPTER  = PL_8_DRAG + 0.0002 -- TODO verify this value 

pl8b_name  = 'PL-8B'
pl8b_model = 'pl8b'
pl8b_mass  = 115.0

PL_8B_AA = {
    category        = CAT_AIR_TO_AIR,
    name            = pl8b_name,
    --model           = 'PL-8B'
    user_name       = _(pl8b_name),
    wsTypeOfWeapon  = {4,4,7,WSTYPE_PLACEHOLDER},
    Escort          = 0,
    Head_Type       = 1,
    sigma           = {3, 3, 3},
    M               = pl8b_mass,
    H_max           = 16000.0,
    H_min           = -1.0,
    Diam            = 160.0,
    Cx_pil          = 2.5,
    D_max           = 20000.0,
    D_min           = 500.0,
    Head_Form       = 0,
    Life_Time       = 240.0,
    Nr_max          = 40,
    v_min           = 140.0,
    v_mid           = 400.0,
    Mach_max        = 3.5,
    t_b             = 0.0,
    t_acc           = 3.0,
    t_marsh         = 3.0,
    Range_max       = 20000.0,
    H_min_t         = 1.0,
    Fi_start        = 0.5,
    Fi_rak          = 3.14152,
    Fi_excort       = 1.31,
    Fi_search       = 0.09,
    OmViz_max       = 1.05,
    warhead         = enhanced_a2a_warhead(11.0);
    exhaust         = tail_solid1;
    X_back          = -1.61,
    Y_back          = -0.089,
    Z_back          = 0.0,
    Reflection      = 0.0329,
    KillDistance    = 7.0,
    --seeker sensivity params
    SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters.
    ccm_k0          = 0.35, -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
    SeekerCooled    = true, -- True is cooled seeker and false is not cooled seeker.

    shape_table_data = {
        {
            name     = pl8b_name,
            file     = pl8b_model,
            life     = 1,
            fire     = {0, 1},
            username = pl8b_name,
            index    = WSTYPE_PLACEHOLDER,
        },
    },

    ModelData = {
        58 ,  -- model params count
        0.4 ,   -- characteristic square (характеристическая площадь)
        
        -- параметры зависимости Сx
        0.05 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
        0.12 , -- Cx_k1 высота пика волнового кризиса
        0.02 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
        0.062, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
        1.2 , -- Cx_k4 крутизна спада за волновым кризисом 
        1.0 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
        
        -- параметры зависимости Cy
        0.9 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
        0.8     , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
        1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
        
        0.78 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
        0.6, --угловая скорость создаваймая моментом газовых рулей
        
        -- Engine data. Time, fuel flow, thrust.    
        --    t_statr        t_b        t_accel        t_march        t_inertial        t_break        t_end            -- Stage
        -1.0,       -1.0,    7,          0.0,        0.0,            0.0,        1.0e9,         -- time of stage, sec
        0.0,         0.0,    6.18,       0.0,        0.0,            0.0,        0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
        0.0,        0.0,    14000.0,    0.0,    0.0,            0.0,        0.0,           -- thrust, newtons
    
        1.0e9, -- таймер самоликвидации, сек
        23.0, -- время работы энергосистемы, сек
        0, -- абсолютная высота самоликвидации, м
        0.35, -- время задержки включения управления (маневр отлета, безопасности), сек
        1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
        1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
        0.0,  -- синус угла возвышения траектории набора горки
        30.0, -- продольное ускорения взведения взрывателя
        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
        1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
        1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
        2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

        -- DLZ data. Use numbers below for your implemetation.
        9.0, -- производная дальности по скорости носителя на высоте 1км, ППС
        -13.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
        -2.1, -- производная по высоте производной дальности по скорости цели, ЗПС
        14000.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
        5000.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м 
        19000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
        6000.0,  -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
        10000.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
        3000.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
        2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
        0.55, -- процент гарантированной дальности от дальности в ППС на высоте 1км
        -0.01, -- производная процента гарантированной дальности в ППС по высоте
        0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
    },
}

declare_weapon(PL_8B_AA)

declare_loadout({
	category			= CAT_AIR_TO_AIR,
	CLSID 				= '{PL-8B_M21}',
	Picture				= 'pl8b.png',
    --PictureBlendColor   = "0xffffffff",
	displayName			=	_(pl8b_name)..desc_IR,
	wsTypeOfWeapon		=   PL_8B_AA.wsTypeOfWeapon,
	attribute			=	{4,	4,	32,	111},--  TODO update this
	Cx_pil				=	PL_8_DRAG_WITH_ADAPTER,
	Count				=	1,
	Weight_Empty		=	39,
	Weight				=	39 + pl8b_mass,
	Elements			=	
	{
		{ShapeName	=	"aero-3b",	    IsAdapter  	   =   true  }, -- TODO replace adapter model!!!
		{ShapeName	=	pl8b_model,	connector_name 	= "Point" },
	}-- end of Elements
})
