F_15N =  {

    Name                 =   'F-15N',
    DisplayName            = _('F-15N'),
	HumanCockpit = true,
	HumanCockpitPath = "./Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardLeft/",
    Picture             = "F-15.png",
    Rate                 = 50, 
    Shape                 = "f-15",
	input_profile_entry = 	"F-15N",

    shape_table_data     =
    {
        {
            file       = 'f-15';
            life       = 20; 
            vis        = 3;  
            desrt    = 'f-15-oblomok'; 
            fire       = {300, 2}; 
            username = 'F-15N';
            index    =  WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
			positioning = "BYNORMAL";
        },
		{
			name  		= "f-15-oblomok";
			file  		= "f-15-oblomok";
			fire  		= { 240, 2};
		},

    },

	net_animation = {
        0, -- front gear
        3, -- right gear
        5, -- left gear
        9, -- right flap
        10, -- left flap
        11, -- right aileron
        12, -- left aileron
        15, -- right elevator
        16, -- left elevator
        17, -- rudder

        38,    -- canopy
        115, -- gear door
        116, -- gear door
        117, -- gear door

        190, -- left (red) navigation wing-tip light
        191, -- right (green) navigation wing-tip light
        192, -- tail (white) light

        198, -- anticollision (flashing red) top light
        199, -- anticollision (flashing red) bottom light
        208, -- taxi light (white) right main gear door
    },

	mapclasskey = "P0091000024",
    attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, F_15,
		"Fighters", "Refuelable", "Datalink", "Link16"
        },
	Categories = { {
			CLSID = "{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}",
			Name = "Interceptor"
		} },

    M_empty                     =  13380,    
    M_nominal                   =  19000,    
    M_max                       =  30845,   
    M_fuel_max                  =  6103,    
    H_max                       =  18300,      
	length						=	19.43,
	height						=	5.63,             
	wing_area					=	56.5,
	wing_span					=	13.05,
	wing_type 					=   1,               
	wing_tip_pos 				= 	{-3.9, 0.2, 6.6},            
	flaps_maneuver              =  1,                   
	has_speedbrake              =  true,
	RCS                         =  5,                  
	IR_emission_coeff			=  0.85,	
	IR_emission_coeff_ab		=  4.25,                
	stores_number               =  12,                    
    CAS_min                     =  58,                 
    V_opt                       =  220,                
    V_take_off                  =  61,                
    V_land                      =  71,                 
	V_max_sea_level				=	403,	
	V_max_h						=	736.11,	
	Vy_max						=	275,	
	Mach_max					=	2,5,
    Ny_min                      =  -3.0,                  
    Ny_max                      =  8.0,                  
    Ny_max_e                    =  8.0,                 
    bank_angle_max              =  60,                  
    range                       =  2540,                
    thrust_sum_max              =  13347,    
    has_afteburner              =  true,
    thrust_sum_ab               =  21952,    
    average_fuel_consumption    =  0.271,

    tand_gear_max                               =  1.732,   
	nose_gear_pos 				                =  {4.59, -2.523, 0},   
	nose_gear_amortizer_direct_stroke   		=  0, 
	nose_gear_amortizer_reversal_stroke  		=  -0.43, 
	nose_gear_amortizer_normal_weight_stroke 	=  -0.215,   
	nose_gear_wheel_diameter 	                =  0.754,
	main_gear_pos 						 	    =  {-0.8, -2.456, 1.425}, 
	main_gear_amortizer_direct_stroke	 	    =  0, 
	main_gear_amortizer_reversal_stroke  	    =  -0.228, 
	main_gear_amortizer_normal_weight_stroke    =  -0.114,
	main_gear_wheel_diameter 				    =  0.972, 
    brakeshute_name                          	=  0,       
	
	mechanimations = {
		CrewLadder = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 91, "to", 0.9, "in", 1.5 } }
					}, {
						C = { { "Sleep", "for", 5 } }
					} },
				Transition = { "Dismantle", "Erect" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 91, "to", 0, "in", 2.7 } }
					}, {
						C = { { "Sleep", "for", 0 } }
					} },
				Transition = { "Erect", "Dismantle" }
			} },
		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0.9, "in", 8.08 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0, "in", 6.743 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "JettisonCanopy", 0 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		ServiceHatches = { {
				Sequence = { {
						C = { { "PosType", 3 }, { "Sleep", "for", 120 } }
					}, {
						C = { { "Arg", 428, "to", 0.9, "speed", 0.6 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Sequence = { {
						C = { { "PosType", 3 }, { "Sleep", "for", 120 } }
					}, {
						C = { { "Arg", 428, "to", 0, "speed", 0.6 } }
					} },
				Transition = { "Open", "Close" }
			} }
	},

    engines_count    = 2,
	engines_nozzles = { {
			diameter = 1.076,
			elevation = 0,
			exhaust_length_ab = 5.8,
			exhaust_length_ab_K = 0.76,
			pos = { -6.751, 0.067, -0.705 },
			smokiness_level = 0.1
		}, {
			diameter = 1.076,
			elevation = 0,
			exhaust_length_ab = 5.8,
			exhaust_length_ab_K = 0.76,
			pos = { -6.751, 0.067, 0.705 },
			smokiness_level = 0.1
		} },
	crew_members = { {
			drop_canopy_name = 22,
			ejection_seat_name = 58,
			pilot_name = 19,
			pos = { 6.277, 1.198, 0 },
			role = "pilot",
			role_display_name = "Pilot"
		} },

	fires_pos = { { -1.842, 0.563, 0 }, { -1.044, 0.481, 2.87 }, { -1.189, 0.461, -3.232 }, { -1.52, 0.265, 4.274 }, { -1.52, 0.265, -4.274 },
		[8] = { -5.753, 0.06, 0.705 },
		[9] = { -5.753, 0.06, -0.705 },
		[10] = { -0.992, 0.85, 0 },
		[11] = { -1.683, 0.507, -2.91 }
	},

		-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 240,
		chaff = {
			chargeSz = 1,
			default = 120,
			increment = 30
		},
		flare = {
			chargeSz = 2,
			default = 60,
			increment = 15
		}
	},

	chaff_flare_dispenser = { {
			dir = { 0, -1, 0 },
			pos = { 1.158, -1.77, -0.967 }
		}, {
			dir = { 0, -1, 0 },
			pos = { 1.158, -1.77, 0.967 }
		} },

    detection_range_max        = 335,
    radar_can_see_ground    =    true,
	CanopyGeometry = { -0.17364817766693, -0.55667039922642, -0.93969262078591, -0.51342418176678, -0.087155742747658 },
	Sensors = {
		RADAR = "AN/APG-63",
		RWR = "Abstract RWR"
	},
	Countermeasures = {
		ECM = "AN/ALQ-135"
	},
	HumanRadio = {
		frequency = 124,
		modulation = 0
	},
	Pylons = { {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					arg_increment = -0.1
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIS_ASQ_T50}",
					arg_increment = -0.1,
					attach_point_position = { 0.3, 0, 0 }
				}, {
					CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					arg_increment = -0.1
				}, {
					CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P3}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P5}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9L}",
					arg_increment = -0.1
				} },
			Number = 1,
			Order = 1,
			Type = 0,
			X = 0.66,
			Y = -0.078,
			Z = -3.325,
			arg = 309,
			arg_increment = 0,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					Cx_gain = 0.45454545454545,
					arg_value = 0
				} },
			Number = 2,
			Order = 2,
			Type = 0,
			X = -0.155,
			Y = -0.343,
			Z = -2.944,
			arg = 309,
			arg_increment = 1,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					arg_increment = -0.1
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					arg_increment = -0.1
				}, {
					CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					arg_increment = -0.1
				}, {
					CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P3}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P5}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9L}",
					arg_increment = -0.1
				} },
			Number = 3,
			Order = 3,
			Type = 0,
			X = 0.66,
			Y = -0.078,
			Z = -2.563,
			arg = 309,
			arg_increment = 0,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}"
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}"
				}, {
					CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}"
				}, {
					CLSID = "{AIM-7F}"
				}, {
					CLSID = "{AIM-7H}"
				}, {
					CLSID = "{AIM-7E}"
				} },
			Number = 4,
			Order = 4,
			Type = 1,
			X = -2.59,
			Y = -0.76,
			Z = -1.47,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}"
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}"
				}, {
					CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}"
				}, {
					CLSID = "{AIM-7F}"
				}, {
					CLSID = "{AIM-7H}"
				}, {
					CLSID = "{AIM-7E}"
				} },
			Number = 5,
			Order = 5,
			Type = 1,
			X = 1.25,
			Y = -0.75,
			Z = -1.545,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					arg_value = 0
				} },
			Number = 6,
			Order = 6,
			Type = 0,
			X = 0.184,
			Y = -1.03,
			Z = 0,
			arg = 313,
			arg_value = 1,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}"
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}"
				}, {
					CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}"
				}, {
					CLSID = "{AIM-7F}"
				}, {
					CLSID = "{AIM-7H}"
				}, {
					CLSID = "{AIM-7E}"
				} },
			Number = 7,
			Order = 7,
			Type = 1,
			X = -2.59,
			Y = -0.76,
			Z = 1.47,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}"
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}"
				}, {
					CLSID = "{8D399DDA-FF81-4F14-904D-099B34FE7918}"
				}, {
					CLSID = "{AIM-7F}"
				}, {
					CLSID = "{AIM-7H}"
				}, {
					CLSID = "{AIM-7E}"
				} },
			Number = 8,
			Order = 8,
			Type = 1,
			X = 1.25,
			Y = -0.75,
			Z = 1.545,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					arg_increment = -0.1
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					arg_increment = -0.1
				}, {
					CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					arg_increment = -0.1
				}, {
					CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P3}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P5}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9L}",
					arg_increment = -0.1
				} },
			Number = 9,
			Order = 9,
			Type = 0,
			X = 0.66,
			Y = -0.078,
			Z = 2.563,
			arg = 317,
			arg_increment = 0,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{E1F29B21-F291-4589-9FD8-3272EEC69506}",
					Cx_gain = 0.45454545454545,
					arg_value = 0
				} },
			Number = 10,
			Order = 10,
			Type = 0,
			X = -0.155,
			Y = -0.343,
			Z = 2.944,
			arg = 317,
			arg_increment = 1,
			use_full_connector_position = true
		}, {
			Launchers = { {
					CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					arg_increment = -0.1
				}, {
					CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}",
					arg_increment = -0.1
				}, {
					CLSID = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIS_ASQ_T50}",
					arg_increment = -0.1,
					attach_point_position = { 0.3, 0, 0 }
				}, {
					CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					arg_increment = -0.1
				}, {
					CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P3}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9P5}",
					arg_increment = -0.1
				}, {
					CLSID = "{AIM-9L}",
					arg_increment = -0.1
				} },
			Number = 11,
			Order = 11,
			Type = 0,
			X = 0.66,
			Y = -0.078,
			Z = 3.325,
			arg = 317,
			arg_increment = 0,
			use_full_connector_position = true
		} },

	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories

    WorldID =  6, 

	Failures = { {
			enable = false,
			hh = 0,
			id = "asc",
			label = "ASC",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "autopilot",
			label = "AUTOPILOT",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "hydro",
			label = "HYDRO",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "l_engine",
			label = "L-ENGINE",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "r_engine",
			label = "R-ENGINE",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "radar",
			label = "RADAR",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "mlws",
			label = "MLWS",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "rws",
			label = "RWS",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "ecm",
			label = "ECM",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "hud",
			label = "HUD",
			mm = 0,
			mmint = 1,
			prob = 100
		}, {
			enable = false,
			hh = 0,
			id = "mfd",
			label = "MFD",
			mm = 0,
			mmint = 1,
			prob = 100
		} },

	Tasks = {
        aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
		aerodynamics = {
			Cy0 = 0,
			Czbe = -0.016,
			Mzalfa = 6,
			Mzalfadt = 1,
			cx_brk = 0.06,
			cx_flap = 0.06,
			cx_gear = 0.0268,
			cy_flap = 0.4,
			kjx = 2.95,
			kjz = 0.00125,
			table_data = { { 0, 0.0215, 0.055, 0.08, 0.22, 0.65, 25, 1.2 }, { 0.2, 0.0215, 0.055, 0.08, 0.22, 1.8, 25, 1.2 }, { 0.4, 0.0215, 0.055, 0.08, 0.22, 3, 25, 1.2 }, { 0.6, 0.0215, 0.055, 0.05, 0.28, 4.2, 25, 1.2 }, { 0.7, 0.0215, 0.055, 0.05, 0.28, 4.2, 23, 1.15 }, { 0.8, 0.0215, 0.055, 0.05, 0.28, 4.2, 21.7, 1.1 }, { 0.9, 0.023, 0.058, 0.09, 0.2, 4.2, 20.1, 1.07 }, { 1, 0.032, 0.062, 0.17, 0.15, 4.2, 18.9, 1.04 }, { 1.1, 0.043, 0.062, 0.235, 0.09, 3.78, 17.4, 1.02 }, { 1.2, 0.046, 0.062, 0.285, 0.08, 2.94, 17, 1 }, { 1.3, 0.047, 0.06, 0.29, 0.1, 2.1, 16, 0.92 }, { 1.4, 0.047, 0.056, 0.3, 0.136, 1.8, 15, 0.8 }, { 1.6, 0.047, 0.052, 0.34, 0.21, 1.08, 13, 0.7 }, { 1.8, 0.046, 0.042, 0.34, 2.43, 0.96, 12, 0.55 }, { 2.2, 0.042, 0.037, 0.49, 3.5, 0.84, 10, 0.37 }, { 2.5, 0.042, 0.033, 0.6, 4.7, 0.84, 9, 0.3 }, { 3.9, 0.04, 0.023, 0.9, 6, 0.84, 7, 0.2 } }
		},
		engine = {
			ForsRUD = 0.91,
			MaksRUD = 0.85,
			MaxRUD = 1,
			MinRUD = 0,
			Nmg = 66,
			cefor = 2.56,
			cemax = 1.24,
			dcx_eng = 0.0114,
			dpdh_f = 14000,
			dpdh_m = 6000,
			hMaxEng = 19.5,
			table_data = { 
			{ 0, 115000, 212000 }, 
			{ 0.2, 94000, 200000 }, 
			{ 0.4, 92000, 205000 }, 
			{ 0.6, 103000, 207000 }, 
			{ 0.7, 105000, 210000 }, 
			{ 0.8, 105000, 220000 }, 
			{ 0.9, 105000, 235000 }, 
			{ 1, 107000, 250000 }, 
			{ 1.1, 103000, 258000 }, 
			{ 1.2, 94000, 268000 }, 
			{ 1.3, 84000, 285000 }, 
			{ 1.4, 71000, 300000 }, 
			{ 1.6, 34000, 318000 }, 
			{ 1.8, 19000, 337000 }, 
			{ 2.2, 17000, 370000 }, 
			{ 2.5, 19000, 390000 }, 
			{ 3.9, 82000, 310000 } 
			},
			type = "TurboJet"
		}
	},

	Damage = { {
			args = { 296 },
			critical_damage = 3
		}, {
			args = { 297 },
			critical_damage = 3
		}, {
			args = { 65 },
			critical_damage = 8
		}, {
			args = { 298 },
			critical_damage = 2
		}, {
			args = { 301 },
			critical_damage = 2
		},
		[0] = {
			args = { 146 },
			critical_damage = 5
		},
		[7] = {
			args = { 249 },
			critical_damage = 2
		},
		[8] = {
			args = { 265 },
			critical_damage = 3
		},
		[9] = {
			args = { 154 },
			critical_damage = 3
		},
		[10] = {
			args = { 153 },
			critical_damage = 3
		},
		[11] = {
			args = { 167 },
			critical_damage = 1
		},
		[12] = {
			args = { 161 },
			critical_damage = 1
		},
		[13] = {
			args = { 169 },
			critical_damage = 2
		},
		[14] = {
			args = { 163 },
			critical_damage = 2
		},
		[15] = {
			args = { 267 },
			critical_damage = 2
		},
		[16] = {
			args = { 266 },
			critical_damage = 2
		},
		[17] = {
			args = { 168 },
			critical_damage = 2
		},
		[18] = {
			args = { 162 },
			critical_damage = 2
		},
		[20] = {
			args = { 183 },
			critical_damage = 2
		},
		[23] = {
			args = { 223 },
			critical_damage = 5
		},
		[24] = {
			args = { 213 },
			critical_damage = 5
		},
		[25] = {
			args = { 226 },
			critical_damage = 2
		},
		[26] = {
			args = { 216 },
			critical_damage = 2
		},
		[29] = {
			args = { 224 },
			critical_damage = 5,
			deps_cells = { 23, 25 }
		},
		[30] = {
			args = { 214 },
			critical_damage = 5,
			deps_cells = { 24, 26 }
		},
		[35] = {
			args = { 225 },
			critical_damage = 6,
			deps_cells = { 23, 29, 25, 37 }
		},
		[36] = {
			args = { 215 },
			critical_damage = 6,
			deps_cells = { 24, 30, 26, 38 }
		},
		[37] = {
			args = { 228 },
			critical_damage = 2
		},
		[38] = {
			args = { 218 },
			critical_damage = 2
		},
		[39] = {
			args = { 244 },
			critical_damage = 2,
			deps_cells = { 53 }
		},
		[40] = {
			args = { 241 },
			critical_damage = 2,
			deps_cells = { 54 }
		},
		[43] = {
			args = { 243 },
			critical_damage = 2,
			deps_cells = { 39, 53 }
		},
		[44] = {
			args = { 242 },
			critical_damage = 2,
			deps_cells = { 40, 54 }
		},
		[51] = {
			args = { 240 },
			critical_damage = 2
		},
		[52] = {
			args = { 238 },
			critical_damage = 2
		},
		[53] = {
			args = { 248 },
			critical_damage = 2
		},
		[54] = {
			args = { 247 },
			critical_damage = 2
		},
		[56] = {
			args = { 158 },
			critical_damage = 2
		},
		[57] = {
			args = { 157 },
			critical_damage = 2
		},
		[59] = {
			args = { 148 },
			critical_damage = 3
		},
		[61] = {
			args = { 147 },
			critical_damage = 2
		},
		[82] = {
			args = { 152 },
			critical_damage = 2
		},
		[83] = {
			args = { 134 },
			critical_damage = 2
		},
		[84] = {
			args = { 136 },
			critical_damage = 2
		},
		[85] = {
			args = { 135 },
			critical_damage = 2
		}
	},

	DamageParts = 
	{  
		[1] = "f-15-oblomok-wing-r", -- wing R
		[2] = "f-15-oblomok-wing-l", -- wing L
	},
---------------------------------------------------------------------------------------------------------------------------------------------
	lights_data = {
		lights = { {
				lights = { {
						argument = 199,
						controller = "Strobe",
						period = 1.33333,
						typename = "Argument"
					} },
				typename = "collection"
			}, {
				lights = { {
						argument = 209,
						typename = "Argument"
					} },
				typename = "Collection"
			}, {
				lights = { {
						argument = 192,
						typename = "Argument"
					}, {
						argument = 190,
						controller = "Strobe",
						cool_down_t = 0.6,
						flash_time = 0.7,
						mode = 1,
						period = 1,
						power_up_t = 0.3,
						typename = "Argument"
					}, {
						argument = 191,
						controller = "Strobe",
						cool_down_t = 0.6,
						flash_time = 0.7,
						mode = 1,
						period = 1,
						power_up_t = 0.3,
						typename = "Argument"
					} },
				typename = "Collection"
			}, {
				argument = 88,
				typename = "argumentlight"
			},
			[6] = {
				lights = { {
						argument = 208,
						typename = "Argument"
					} },
				typename = "Collection"
			}
		},
		typename = "collection"
	},
}

add_aircraft(F_15N)
