#ifndef _NVD_COMMON_
#define _NVD_COMMON_

#include "common/context.hlsl"

#define MASK_SIZE (1.0/0.4)//(1.0/0.8)

float getMask(float2 c, float mul) {
	return saturate(mul*(1 - sqrt(dot(c, c))));
}

float2 calcMaskCoord(float2 projPos) {
	return float2((projPos.x - gNVDpos.x) * gNVDaspect, projPos.y - gNVDpos.y + 0.3) * MASK_SIZE; //(projPos.x - gNVDpos.x)
}

float getNVDMask(float2 projPos) {
	float2 uvm = calcMaskCoord(projPos);
	return getMask(uvm, 1);//10
}

#endif
