/*
 * Decompiled with CFR 0.152.
 */
package dcscontrol;

import dcscontrol.DCSTableModel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MainDialogController
implements Initializable {
    private ObservableList<DCSTableModel> viewTableData = FXCollections.observableArrayList();
    private PDDocument _pdfDocument = null;
    private String _pdfFilename = null;
    private String _dcsFolder = null;
    private String _pdfFolder = null;
    @FXML
    private Pane paneStep2;
    @FXML
    private Label labelStep1Info;
    @FXML
    private Label labelStep2Info;
    @FXML
    private Button btnAddHtml;
    @FXML
    private Label icoBtnAddHtml;
    @FXML
    private Label icoBtnTemplate;
    @FXML
    private TextArea textEventLog;
    @FXML
    private TableView table;
    @FXML
    private TableColumn colFormField;
    @FXML
    private TableColumn colBindkey;
    @FXML
    private TableColumn colAction;
    @FXML
    private TableColumn colDevice;

    public void initialize(URL url, ResourceBundle rb) {
        this.initViewTable();
        this.repaint();
        String tesztFolder = System.getProperty("user.home") + "\\Saved Games\\DCS\\InputLayoutsTxt";
        File fajl = new File(tesztFolder);
        if (fajl.exists() && fajl.isDirectory()) {
            this._dcsFolder = fajl.getPath();
            this.eventLog("DCS folder found: " + this._dcsFolder);
        } else {
            fajl = new File(tesztFolder + "\\..");
            if (fajl.exists() && fajl.isDirectory()) {
                try {
                    this._dcsFolder = fajl.getCanonicalPath();
                    this.eventLog("DCS folder found: " + this._dcsFolder);
                }
                catch (IOException ex) {
                    this.eventLog(ex.getMessage());
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                }
            } else {
                this.eventLog("DCS folder is not found.");
            }
        }
    }

    @FXML
    private void btnOpenAction(ActionEvent event) {
        File fajl = this.fileOpenSave("html files", "html", 'o', this._dcsFolder);
        if (fajl != null) {
            try {
                String deviceName = DCSTableModel.getDeviceFromFilename(fajl.getName());
                String prefix = JOptionPane.showInputDialog(null, "To separate two or more device, use prefix for key/button form field in PDF.\nFor example: device without prefix: JOY_BTN1\ndevice with TM_ prefix: TM_JOY_BTN1\n\nIf there is prefix for " + deviceName + ", set here or leave empty:", "Optional prefix for " + deviceName, 3);
                if (prefix == null) {
                    return;
                }
                this._dcsFolder = fajl.getPath();
                Document doc = Jsoup.parse((File)fajl, null);
                Elements rows = doc.body().getElementsByTag("tr");
                String c4 = deviceName;
                for (Element row : rows) {
                    Elements cols = row.getElementsByTag("td");
                    if (cols.size() < 3) continue;
                    String c1 = prefix + ((Element)cols.get(0)).text().replace("\"", "");
                    String c2 = ((Element)cols.get(1)).text();
                    String c3 = ((Element)cols.get(2)).text();
                    if (c1.isEmpty() || c1.equals(prefix)) continue;
                    this.viewTableData.add((Object)new DCSTableModel(c1, c2, c3, c4, ""));
                }
                Collections.sort(this.viewTableData);
                this.eventLog(fajl.getName() + " HTML file add.");
            }
            catch (IOException ex) {
                this.eventLog("File open error: " + ex.getMessage());
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            }
            catch (Exception ex) {
                this.eventLog("Error: " + ex.getMessage());
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            }
        }
        this.tableDataRecalculate();
        this.repaint();
    }

    @FXML
    private void btnExitAction(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void btnClearAction(ActionEvent event) {
        this.viewTableData.clear();
        this.textEventLog.clear();
        try {
            if (this._pdfDocument != null) {
                this._pdfDocument.close();
                this._pdfDocument = null;
            }
        }
        catch (IOException ex) {
            this.eventLog("IO Error: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, ex.getMessage(), "IO Error", 0);
        }
        this._pdfFilename = "";
        this.repaint();
        this.eventLog("Area clear, all file closed.");
    }

    @FXML
    private void btnFillSavePdfAction(ActionEvent event) {
        try {
            File targetPdf = this.fileOpenSave("PDF file", "pdf", 's', this._pdfFolder);
            if (targetPdf != null) {
                if (!targetPdf.getName().toLowerCase().endsWith(".pdf")) {
                    this.eventLog("Target file renamed from: " + targetPdf.getCanonicalFile());
                    targetPdf = new File(targetPdf.getCanonicalFile() + ".pdf");
                    this.eventLog("Target file renamed to: " + targetPdf.getCanonicalFile());
                }
                boolean doit = false;
                if (targetPdf.exists()) {
                    if (JOptionPane.showConfirmDialog(null, targetPdf.getName() + " is exist.\nOverwrite?", "File exist", 0) == 0) {
                        doit = true;
                    }
                } else {
                    doit = true;
                }
                if (doit) {
                    if (this._pdfDocument != null) {
                        this.fillTemplateFields();
                        this._pdfDocument.save(targetPdf);
                        this.eventLog("Fill and save PDF template into: " + targetPdf.getName());
                        PDFRenderer pdfRenderer = new PDFRenderer(this._pdfDocument);
                        String PngFilename = targetPdf.getCanonicalFile() + ".png";
                        BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 200.0f, ImageType.RGB);
                        ImageIOUtil.writeImage((BufferedImage)bim, (String)PngFilename, (int)200);
                        this.eventLog("Save as PNG into: " + PngFilename);
                    } else {
                        this.eventLog("Cannot write target pdf.");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.eventLog(ex.getMessage());
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
        }
        this.repaint();
    }

    @FXML
    private void btnOpenTemplateAction(ActionEvent event) {
        try {
            File originalPdf = this.fileOpenSave("PDF template file", "pdf", 'o', this._pdfFolder);
            if (originalPdf != null) {
                if (originalPdf.canRead()) {
                    this._pdfFilename = null;
                    if (this._pdfDocument != null) {
                        this._pdfDocument.close();
                    }
                    this._pdfDocument = PDDocument.load((File)originalPdf);
                    this._pdfFilename = originalPdf.getName();
                    this._pdfFolder = originalPdf.getPath();
                    this.eventLog("Template PDF file open: " + this._pdfFilename);
                } else {
                    this.eventLog("The template file is not readable.");
                }
            }
        }
        catch (Exception ex) {
            this.eventLog(ex.getMessage());
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
        }
        this.tableDataRecalculate();
        this.repaint();
    }

    private File fileOpenSave(String filterDetail, String extension, char command, String directory) {
        try {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(filterDetail, extension);
            chooser.setFileFilter(filter);
            if (directory != null && !directory.isEmpty()) {
                chooser.setCurrentDirectory(new File(directory));
            }
            int returnVal = 1;
            switch (Character.toLowerCase(command)) {
                case 'o': {
                    returnVal = chooser.showOpenDialog(null);
                    break;
                }
                case 's': {
                    returnVal = chooser.showSaveDialog(null);
                }
            }
            if (returnVal == 0) {
                return chooser.getSelectedFile().getAbsoluteFile();
            }
        }
        catch (Exception ex) {
            this.eventLog(ex.getMessage());
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
        }
        return null;
    }

    private void fillTemplateFields() {
        try {
            PDDocumentCatalog docCatalog = this._pdfDocument.getDocumentCatalog();
            PDAcroForm acroForm = docCatalog.getAcroForm();
            List fields = acroForm.getFields();
            block3: for (PDField field : fields) {
                for (int i = 0; i < this.viewTableData.size(); ++i) {
                    if (field.getFullyQualifiedName().equals("Modes")) {
                        if (!((DCSTableModel)this.viewTableData.get(i)).getGroup().equals(field.getFullyQualifiedName()) || !((DCSTableModel)this.viewTableData.get(i)).getAction().matches("\\(\\d\\).*")) continue;
                        field.setValue(field.getValueAsString() + ((DCSTableModel)this.viewTableData.get(i)).getAction() + "\n");
                        continue;
                    }
                    if (!((DCSTableModel)this.viewTableData.get(i)).getBindkey().equals(field.getFullyQualifiedName())) continue;
                    field.setValue(((DCSTableModel)this.viewTableData.get(i)).getAction());
                    continue block3;
                }
            }
        }
        catch (IOException ex) {
            this.eventLog("I/O error: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, ex.getMessage(), "IO Error", 0);
        }
        catch (Exception ex) {
            this.eventLog("Error: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
        }
    }

    private void repaint() {
        this.labelStep1Info.setText("");
        this.icoBtnAddHtml.setText("?");
        this.icoBtnTemplate.setText("?");
        this.paneStep2.setDisable(true);
        this.labelStep2Info.setText("");
        this.btnAddHtml.setDisable(true);
        if (this._pdfDocument != null && this._pdfDocument.getNumberOfPages() > 0) {
            this.labelStep1Info.setText(this._pdfFilename);
            this.icoBtnTemplate.setText("\u2714");
            this.btnAddHtml.setDisable(false);
        }
        if (!this.viewTableData.isEmpty()) {
            this.labelStep1Info.setText(this.labelStep1Info.getText() + " " + this.viewTableData.size() + " binded actions");
            this.icoBtnAddHtml.setText("\u2714");
        }
        if (!this.viewTableData.isEmpty() && this._pdfDocument != null) {
            this.paneStep2.setDisable(false);
        }
    }

    private void eventLog(String event) {
        this.textEventLog.appendText(event + "\n");
    }

    private void initViewTable() {
        this.table.getColumns();
        this.colFormField.setCellValueFactory((Callback)new PropertyValueFactory("formkey"));
        this.colFormField.setSortable(false);
        this.colBindkey.setCellValueFactory((Callback)new PropertyValueFactory("bindkey"));
        this.colBindkey.setSortable(false);
        this.colAction.setCellValueFactory((Callback)new PropertyValueFactory("action"));
        this.colAction.setSortable(false);
        this.colDevice.setCellValueFactory((Callback)new PropertyValueFactory("device"));
        this.colDevice.setSortable(false);
        this.table.setItems(this.viewTableData);
    }

    private void tableDataRecalculate() {
        if (this._pdfDocument != null) {
            PDDocumentCatalog docCatalog = this._pdfDocument.getDocumentCatalog();
            PDAcroForm acroForm = docCatalog.getAcroForm();
            List fields = acroForm.getFields();
            block0: for (PDField field : fields) {
                for (int i = 0; i < this.viewTableData.size(); ++i) {
                    if (!((DCSTableModel)this.viewTableData.get(i)).getBindkey().equals(field.getFullyQualifiedName())) continue;
                    ((DCSTableModel)this.viewTableData.get(i)).setFormkey(field.getFullyQualifiedName());
                    continue block0;
                }
            }
        }
    }
}

