--- Detect and attack a set of enemy units using helicopters.
-- Name: AID-A2G-001 - Detection and Attack Helicopters
-- Author: FlightControl
-- Date Created: 02 Nov 2018

-- Define a SET_GROUP object that builds a collection of groups that define the recce network.
-- Here we build the network with all the groups that have a name starting with CCCP Recce.

DetectionSetGroup = SET_GROUP:New() -- Defene a set of group objects, caled DetectionSetGroup.
DetectionSetGroup:FilterPrefixes( { "BLUEOH58D" } ) -- The DetectionSetGroup will search for groups that start with the name "CCCP Recce".
DetectionSetGroup:FilterStart() 

Detection = DETECTION_AREAS:New( DetectionSetGroup, 10000 )
-- Setup the A2A dispatcher, and initialize it.

A2GDispatcher = AI_A2G_DISPATCHER:New( Detection )
-- This command will start the dynamic filtering, so when groups spawn in or are destroyed, 
-- which have a group name starting with "CCCP Recce", then these will be automatically added or removed from the set.

-- This command defines the reconnaissance network.
-- It will group any detected ground enemy targets within a radius of 1km.
-- It uses the DetectionSetGroup, which defines the set of reconnaissance groups to detect for enemy ground targets.




-- Add defense coordinates.
--A2GDispatcher:AddDefenseCoordinate( "BLUEHQMINAKH", GROUP:FindByName( "BLUEHQMINAKH" ):GetCoordinate() )
--A2GDispatcher:SetDefenseReactivityHigh()
--A2GDispatcher:SetDefenseRadius( 15000 )
--A2GDispatcher:SetTacticalDisplay( true )

NorthAleppo = ZONE_POLYGON:New( "NorthAleppo", GROUP:FindByName( "NorthAleppo" ) )
MAINZONE = ZONE_POLYGON:New( "MAINZONE", GROUP:FindByName( "MAINZONE" ) )

-- Setup the squadrons.
A2GDispatcher:SetSquadron( "MINAKHCOPTER", AIRBASE.Syria.Minakh, { "AH64D", "CH47D", "SA342M" } )
A2GDispatcher:SetSquadronCasPatrol( "MINAKHCOPTER", NorthAleppo, 100, 500, 40, 250, 100, 300, "RADIO" )
A2GDispatcher:SetSquadronCasPatrolInterval( "MINAKHCOPTER", 3, 1, 500 )
A2GDispatcher:SetSquadronTakeoffFromParkingCold( "MINAKHCOPTER" )
A2GDispatcher:SetSquadronOverhead( "MINAKHCOPTER", 0.25 )

A2GDispatcher:SetSquadron( "TAFTANAZCOPTER", AIRBASE.Syria.Taftanaz, { "AH1W", "UH60A", "MI24V" } )
A2GDispatcher:SetSquadronCasPatrol( "TAFTANAZCOPTER", NorthAleppo, 100, 500, 70, 250, 100, 300, "RADIO" )
A2GDispatcher:SetSquadronCasPatrolInterval( "TAFTANAZCOPTER", 3, 1, 500 )
A2GDispatcher:SetSquadronTakeoffFromParkingCold( "TAFTANAZCOPTER" )
A2GDispatcher:SetSquadronOverhead( "TAFTANAZCOPTER", 0.25 )

A2GDispatcher:SetSquadron( "HATAYCOPTER", AIRBASE.Syria.Hatay, { "MI26" ,"CH47D" } )
A2GDispatcher:SetSquadronCasPatrol( "HATAYCOPTER", MAINZONE, 1000, 3000, 70, 250, 100, 300, "RADIO" )
A2GDispatcher:SetSquadronCasPatrolInterval( "HATAYCOPTER", 2, 1, 500 )
A2GDispatcher:SetSquadronTakeoffFromParkingCold( "HATAYCOPTER" )
A2GDispatcher:SetSquadronOverhead( "HATAYCOPTER", 0.25 )


A2GDispatcher:Start()

--Airbases of Syria

--AIRBASE.Syria.Kuweires
--AIRBASE.Syria.Marj_Ruhayyil
--AIRBASE.Syria.Kiryat_Shmona
--AIRBASE.Syria.Marj_as_Sultan_North
--AIRBASE.Syria.Eyn_Shemer
--AIRBASE.Syria.Incirlik
--AIRBASE.Syria.Damascus
--AIRBASE.Syria.Bassel_Al_Assad
--AIRBASE.Syria.Aleppo
--AIRBASE.Syria.Qabr_as_Sitt
--AIRBASE.Syria.Wujah_Al_Hajar
--AIRBASE.Syria.Al_Dumayr
--AIRBASE.Syria.Hatay
--AIRBASE.Syria.Haifa
--AIRBASE.Syria.Khalkhalah--
--AIRBASE.Syria.Megiddo
--AIRBASE.Syria.Rayak
--AIRBASE.Syria.Mezzeh
--AIRBASE.Syria.King_Hussein_Air_College
--AIRBASE.Syria.Jirah
--AIRBASE.Syria.Taftanaz
--AIRBASE.Syria.Rene_Mouawad
--AIRBASE.Syria.Ramat_David
--AIRBASE.Syria.Minakh
--AIRBASE.Syria.Adana_Sakirpasa
--AIRBASE.Syria.Marj_as_Sultan_South
--AIRBASE.Syria.Hama
--AIRBASE.Syria.Al_Qusayr
--AIRBASE.Syria.Palmyra
--AIRBASE.Syria.Tabqa
--AIRBASE.Syria.Beirut_Rafic_Hariri
--AIRBASE.Syria.An_Nasiriyah
--AIRBASE.Syria.Abu_al_Duhur