camp_triggers = {
	['Reinforce VAW-125'] = {
		['action'] = 'Action.AirUnitReinforce("R/VAW-125", "VAW-125", 8)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Tbilissi Airbase Disabled Text'] = {
		['action'] = {
			[1] = 'Action.Text("The infrastructure at Tbilissi-Lochini Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume.")',
		},
		['once'] = true,
		['condition'] = 'Return.TargetAlive("Tbilisi Airbase") < 7',
		['active'] = true,
	},
	['Reinforce 559.BAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/559.BAP", "559.BAP", 12)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Cargo convoy 2 Patrol ATest Sea'] = {
		['action'] = 'Action.ShipMission("Cargo convoy 2", {{"Ships 1-5", "Ships 1-4", "Ships 1-3", "Ships 1-2"}}, 8, 5, nil)',
		['once'] = true,
		['condition'] = 'Return.Mission() == 1',
		['active'] = false,
	},
	['Reinforce 31.IAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/31.IAP", "31.IAP", 12)',
		['condition'] = 'true',
		['active'] = true,
	},
	['CVN-74 John C. Stennis sunk'] = {
		['action'] = {
			[1] = 'db_airbases["CVN-74 John C. Stennis"].inactive = true',
			[2] = 'Action.Text("After the CVN-74 John C. Stennis has been hit by air strikes and sunk, Squadrons are no longer able to fly. Most of its planes are deep into the Gulf waters and it will need a long time to restore this unit s capabilities")',
		},
		['condition'] = 'Return.TargetAlive("CVN-74 John C. Stennis") == 0',
		['active'] = true,
	},
	['Sukhumi Airbase Disabled'] = {
		['action'] = {
			[1] = 'db_airbases["Sukhumi"].inactive = true',
		},
		['condition'] = 'Return.TargetAlive("Sukhumi Airbase") < 4 and Return.TargetAlive("Sukhumi Airbase Strategics") < 5',
		['active'] = true,
	},
	['Kobuleti Airbase Disabled'] = {
		['action'] = {
			[1] = 'db_airbases["Kobuleti"].inactive = true',
		},
		['condition'] = 'Return.TargetAlive("Kobuleti Airbase") < 11',
		['active'] = true,
	},
	['Reinforce VMFA-312'] = {
		['action'] = 'Action.AirUnitReinforce("R/VMFA-312", "VMFA-312", 16)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Campaign End Draw'] = {
		['action'] = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Russian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Russians will convince them to withdraw from Georgia")',
			[3] = 'NoMoreNewspaper = true',
		},
		['once'] = true,
		['condition'] = 'MissionInstance == 40',
		['active'] = true,
	},
	['TF-71 Patrol ATest Sea'] = {
		['action'] = 'Action.ShipMission("TF-71", {{"Indy 1-1", "Indy 1-2", "Indy 1-3", "Indy 1-4"}}, 10, 8, nil)',
		['once'] = true,
		['condition'] = 'Return.Mission() == 1',
		['active'] = false,
	},
	['Batumi Airbase Disabled Text'] = {
		['action'] = {
			[1] = 'Action.Text("After the facilities at Batumi Airbase have been hit by air strikes, air operations at this base came to a complete stop. Due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['once'] = true,
		['condition'] = 'Return.TargetAlive("Batumi Airbase") < 6',
		['active'] = true,
	},
	['LHA Group Close to Georgian Coasts'] = {
		['action'] = {
			[1] = 'Action.ShipMission("LHA Group", {{"Indy 3-5", "Indy 3-6", "Indy 3-7", "Indy 3-8""}}, 10, 8, nil)',
			[2] = 'Action.AirUnitActive("VMA 311", true)',
			[3] = 'Action.Text("After the estimated near destruction of all the enemy anti-ship air squadrons, LHA Group is allowed to move closer of Georgian coast and VMA-311 will begin its air to ground campaign.")',
		},
		['once'] = true,
		['condition'] = 'Return.AirUnitReady("368.ShAP") + Return.AirUnitReady("559.BAP") + Return.AirUnitReady("52.TBAP") + Return.AirUnitReady("959.BAP") + Return.AirUnitReady("79.TBAP") < 10',
		['active'] = true,
	},
	['Reinforce 52.TBAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/52.TBAP", "52.TBAP", 6)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Gudauta Airbase Disabled Text'] = {
		['action'] = {
			[1] = 'Action.Text("After the facilities at Gudauta Airbase have been hit by air strikes, air operations at this base came to a complete stop. Due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['once'] = true,
		['condition'] = 'Return.TargetAlive("Gudauta Airbase") < 10',
		['active'] = true,
	},
	['Reinforce VF-101'] = {
		['action'] = 'Action.AirUnitReinforce("R/VF-101", "VF-101", 16)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Reinforce VF-143'] = {
		['action'] = 'Action.AirUnitReinforce("R/VF-143", "VF-143", 16)',
		['condition'] = 'true',
		['active'] = true,
	},
	['19.IAP Alive 50%'] = {
		['action'] = 'Action.Text("Aircraft strength of the 19.IAP equiped with Fishbed has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
		['once'] = true,
		['condition'] = 'Return.AirUnitAlive("19.IAP") + Return.AirUnitReady("R/19.IAP") < 6',
		['active'] = true,
	},
	['Campaign End Victory 2'] = {
		['action'] = {
			[2] = 'Action.Text("US Navy Air forces are completly defeated. After repeated air strikes and disastrous losses in air-air combat, the US are no longer able to produce any sorties or offer any resistance. The Russian Air Force now owns complete air superiority. Without enough air forces the US Navy will have to withdraw. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[1] = 'Action.CampaignEnd("win")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
		['once'] = true,
		['condition'] = 'Return.AirUnitReady("VFA-106") + Return.AirUnitReady("VF-101") + Return.AirUnitReady("VMFA-312") + Return.AirUnitReady("VF-143") < 4',
		['active'] = true,
	},
	['CAP After EWR Destroyed'] = {
		['action'] = {
			[1] = 'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, our ability of to launch interceptors against enemy strike packages was severely degraded. We will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
		['once'] = false,
		['condition'] = 'Return.TargetAlive("EWR 1 501") == 0 and Return.TargetAlive("EWR 2 502") == 0 and Return.TargetAlive("EWR 3 503") == 0',
		['active'] = true,
	},
	['Reinforce 79.TBAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/79.TBAP", "79.TBAP", 6)',
		['condition'] = 'true',
		['active'] = true,
	},
	['19.IAP Alive 25%'] = {
		['action'] = 'Action.Text("Aircraft strength of the 19.IAP equiped with Fishbed has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
		['once'] = true,
		['condition'] = 'Return.AirUnitAlive("19.IAP") + Return.AirUnitReady("R/19.IAP") < 5',
		['active'] = true,
	},
	['CVN-71 Theodore Roosevelt Damaged Heavy'] = {
		['action'] = {
			[2] = 'Action.Text("CVN-71 Theodore Roosevelt has sustained heavy damage. All combat operations against our forces have been put on hold until further notice.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[1] = 'Action.CampaignEnd("loss")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
		['once'] = true,
		['condition'] = 'camp.ShipHealth and camp.ShipHealth["CVN-71 Theodore Roosevelt"] and camp.ShipHealth["CVN-71 Theodore Roosevelt"] < 33 and camp.ShipHealth["CVN-71 Theodore Roosevelt"] > 0',
		['active'] = true,
	},
	['Reinforce 174.IAP-PVO'] = {
		['action'] = 'Action.AirUnitReinforce("R/174.IAP-PVO", "174.IAP-PVO", 6)',
		['condition'] = 'true',
		['active'] = true,
	},
	['GroundUnitRepair'] = {
		['action'] = 'Action.GroundUnitRepair()',
		['condition'] = 'true',
		['active'] = true,
	},
	['Reinforce 174 ARW'] = {
		['action'] = 'Action.AirUnitReinforce("R/174 ARW", "174 ARW", 12)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Campaign End Loss 2'] = {
		['action'] = {
			[2] = 'Action.Text("The US Navy units deployed off the coasts of Georgia have successfully destroyed all the targets that they were assigned by US Central Command. With the complete destruction of our airforce over Georgia, the air campaign of this war comes to an end. We will soon begin to withdraw from Georgia. Our diplomatic power in the world is really weaked by this defeat.")',
			[3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[1] = 'Action.CampaignEnd("loss")',
			[4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[5] = 'NoMoreNewspaper = true',
		},
		['once'] = true,
		['condition'] = 'GroundTarget["blue"].percent < 45',
		['active'] = true,
	},
	['Repair'] = {
		['action'] = 'Action.AirUnitRepair()',
		['condition'] = 'true',
		['active'] = true,
	},
	['Tbilissi Airbase Disabled'] = {
		['action'] = {
			[1] = 'db_airbases["Tbilissi-Lochini"].inactive = true',
		},
		['condition'] = 'Return.TargetAlive("Tbilisi Airbase") < 7',
		['active'] = true,
	},
	['Reinforce 19.IAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/19.IAP", "19.IAP", 12)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Reinforce 368.ShAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/368.ShAP", "368.ShAP", 16)',
		['condition'] = 'true',
		['active'] = true,
	},
	['TF-74 Patrol ATest Sea'] = {
		['action'] = 'Action.ShipMission("TF-74", {{"Indy 2-1", "Indy 2-2", "Indy 2-3", "Indy 2-4"}}, 10, 8, nil)',
		['once'] = true,
		['condition'] = 'Return.Mission() == 1',
		['active'] = false,
	},
	['Campaign End Victory 3'] = {
		['action'] = {
			[2] = 'Action.Text("After the CVN-71 Theodore Roosevelt has been hit by air strikes and sunk, US Air Squadrons are no longer able to fly. Most of their planes are deep into the Caucasian waters and it will need a long time to restore this unit s capabilities. US Navy will withdraw from the Georgian coasts. This is a Great Victory for Russian Air Force")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[1] = 'Action.CampaignEnd("win")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
		['once'] = false,
		['condition'] = 'Return.TargetAlive("CVN-71 Theodore Roosevelt") == 0',
		['active'] = true,
	},
	['Red Ground Target Briefing Intel'] = {
		['action'] = 'Action.AddGroundTargetIntel("red")',
		['condition'] = 'true',
		['active'] = true,
	},
	['19.IAP Alive 75%'] = {
		['action'] = 'Action.Text("Aircraft strength of the 19.IAP equiped with Fishbed has fallen below 75%.")',
		['once'] = true,
		['condition'] = 'Return.AirUnitAlive("19.IAP") + Return.AirUnitReady("R/19.IAP") < 8',
		['active'] = true,
	},
	['Reinforce VFA-106'] = {
		['action'] = 'Action.AirUnitReinforce("R/VFA-106", "VFA-106", 16)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Cargo convoy 1 Patrol ATest Sea'] = {
		['action'] = 'Action.ShipMission("Cargo convoy 1", {{"Ships 1-1", "Ships 1-2", "Ships 1-3", "Ships 1-4"}}, 8, 5, nil)',
		['once'] = true,
		['condition'] = 'Return.Mission() == 1',
		['active'] = false,
	},
	['Campaign End Victory 1'] = {
		['action'] = {
			[2] = 'Action.Text("The US Navy units deployed off the coasts of Georgia have been successfully destroyed by our long range bombers. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[1] = 'Action.CampaignEnd("win")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
		['once'] = true,
		['condition'] = 'GroundTarget["red"].percent < 45',
		['active'] = true,
	},
	['CVN-71 Theodore Roosevelt Damaged Moderate'] = {
		['action'] = {
			[2] = 'Action.Text("CVN-71 Theodore Roosevelt has sustained substantial damage. Unable to continue flight operations, the carrier is retreating under own power for repairs. All combat operations against Russian forces have been put on hold until further notice.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[1] = 'Action.CampaignEnd("loss")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
		['once'] = true,
		['condition'] = 'camp.ShipHealth and camp.ShipHealth["CVN-71 Theodore Roosevelt"] and camp.ShipHealth["CVN-71 Theodore Roosevelt"] < 66 and camp.ShipHealth["CVN-71 Theodore Roosevelt"] >= 33',
		['active'] = true,
	},
	['Reinforce VMA 311'] = {
		['action'] = 'Action.AirUnitReinforce("VMA 331", "VMA 311", 4)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Campaign first destructions'] = {
		['action'] = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
		['once'] = true,
		['condition'] = 'GroundTarget["red"].percent < 100',
		['active'] = true,
	},
	['Batumi Airbase Disabled'] = {
		['action'] = {
			[1] = 'db_airbases["Batumi"].inactive = true',
		},
		['condition'] = 'Return.TargetAlive("Batumi Airbase") < 6',
		['active'] = true,
	},
	['Reinforce 3.IAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/3.IAP", "3.IAP", 12)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Senaki Airbase Disabled Text'] = {
		['action'] = {
			[1] = 'Action.Text("After the facilities at Senaki-Kolkhi Airbase have been hit by air strikes, air operations at this base came to a complete stop. Due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['once'] = true,
		['condition'] = 'Return.TargetAlive("Senaki Airbase") < 12',
		['active'] = true,
	},
	['Gudauta Airbase Disabled'] = {
		['action'] = {
			[1] = 'db_airbases["Gudauta"].inactive = true',
		},
		['condition'] = 'Return.TargetAlive("Gudauta Airbase") < 10',
		['active'] = true,
	},
	['Reinforce 959.BAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/959.BAP", "959.BAP", 12)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Campaign Briefing'] = {
		['action'] = {
			[2] = 'Action.Text("The US Navy has sent considerable forces near Georgia. The Task Force 68 is leaded by the CVN-68 Nimitz. At the forefront are the F/A-18C of the VFA-131 and VFA-192. They will certainly try to attack our air defenses, Airbases and many strategical targets in Georgia like bridges train stations and Harbors. Air superiority and strikers escort should be the mission of the VF-101 and VF-32 with their F-14B Tomcats.")',
			[3] = 'Action.Text("Our glorious Air Force is flying a mix of MiG-21, MiG-25 and MiG-23 fighters directed by ground based early warning radar. Air bases and target complexes of high value are protected by a variety of surface-air missile systems, such as the Sa-2 Guindeline, SA-6 Gainful, the SA-8 Gecko and the SA-3 Goa, as well as short-range IR-SAMs and AAA. We will maintain air superiority over Georgia by neutralizing US Navy air raids over the country and  protecting our SAM systems. Their Task Force will be targeted by Russians anti-ship fleet : Su-24, Tu-22 and TU-142 with their long range missiles")',
			[1] = 'Action.Text("Georgian terrorists tryed to bring down the democratic georgian government. Georgian loyal troops helped by russian Army was able to stop this action quickly. The United States of America certainly behind this action will try to help those terrorists. Wisely the Turkish government was not ready to open his bases to US attack planes and only one Navy Task Force has been sent near Georgian coasts to attack the free people of Georgia. Of course our forces will help Georgia to defend themself against US imperialism.")',
			[4] = 'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
			[5] = 'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
		},
		['once'] = true,
		['condition'] = 'true',
		['active'] = false,
	},
	['Kutaisi Airbase Disabled Text'] = {
		['action'] = {
			[1] = 'Action.Text("The infrastructure at Kutaisi Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume.")',
		},
		['once'] = true,
		['condition'] = 'Return.TargetAlive("Kutaisi Airbase") < 11',
		['active'] = true,
	},
	['Sukhumi Airbase Disabled Text'] = {
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Sukhumi Airbase. Our remaining aircrafts at the airstrip will no longer be able to launch on sorties.")',
		},
		['once'] = true,
		['condition'] = 'Return.TargetAlive("Sukhumi Airbase") < 4 and Return.TargetAlive("Sukhumi Airbase Strategics") < 5',
		['active'] = true,
	},
	['Kutaisi Airbase Disabled'] = {
		['action'] = {
			[1] = 'db_airbases["Kutaisi"].inactive = true',
		},
		['condition'] = 'Return.TargetAlive("Kutaisi Airbase") < 11',
		['active'] = true,
	},
	['LHA_Tarawa'] = {
		['action'] = {
			[1] = 'db_airbases["LHA_Tarawa"].inactive = true',
			[2] = 'Action.Text("After the LHA_Tarawa has been hit by air strikes and sunk, VMA 311 is no longer able to fly. Most of its planes are deep into the Gulf waters and it will need a long time to restore this unit s capabilities")',
		},
		['condition'] = 'Return.TargetAlive("LHA_Tarawa") == 0',
		['active'] = true,
	},
	['Kobuleti Airbase Disabled Text'] = {
		['action'] = {
			[1] = 'Action.Text("After the facilities at Kobuleti Airbase have been hit by air strikes, air operations at this base came to a complete stop. Due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['once'] = true,
		['condition'] = 'Return.TargetAlive("Kobuleti Airbase") < 11',
		['active'] = true,
	},
	['Campaign 40 percents destructions'] = {
		['action'] = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
		['once'] = true,
		['condition'] = 'GroundTarget["red"].percent < 60',
		['active'] = true,
	},
	['LHA-Group Far from Georgian Coasts'] = {
		['action'] = {
			[1] = 'Action.ShipMission("LHA-Group", {{"Indy 3-1", "Indy 3-2", "Indy 3-3", "Indy 3-4"}}, 10, 8, nil)',
		},
		['once'] = true,
		['condition'] = 'Return.Mission() == 1',
		['active'] = false,
	},
	['Reinforce 28.IAP'] = {
		['action'] = 'Action.AirUnitReinforce("R/28.IAP", "28.IAP", 12)',
		['condition'] = 'true',
		['active'] = true,
	},
	['Blue Ground Target Briefing Intel'] = {
		['action'] = 'Action.AddGroundTargetIntel("blue")',
		['condition'] = 'true',
		['active'] = true,
	},
	['Senaki Airbase Disabled'] = {
		['action'] = {
			[1] = 'db_airbases["Senaki-Kolkhi"].inactive = true',
		},
		['condition'] = 'Return.TargetAlive("Senaki Airbase") < 12',
		['active'] = true,
	},
	['Campaign 20 percents destructions'] = {
		['action'] = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
		['once'] = true,
		['condition'] = 'GroundTarget["red"].percent < 80',
		['active'] = true,
	},
	['Campaign End Loss'] = {
		['action'] = {
			[2] = 'Action.Text("Ongoing combat operations have exhausted 19.IAP. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Russian Air Force to maintain air superiority, Central Command has decided to call of the air campaign against US NAvy. They will be able to stay near Georgia and our diplomatic power in the world is really weaked by this defeat.")',
			[3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[1] = 'Action.CampaignEnd("loss")',
			[4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[5] = 'NoMoreNewspaper = true',
		},
		['once'] = true,
		['condition'] = 'Return.AirUnitAlive("19.IAP") + Return.AirUnitReady("R/19.IAP") < 4',
		['active'] = true,
	},
	['Campaign 50 percents destructions'] = {
		['action'] = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
		['once'] = true,
		['condition'] = 'GroundTarget["red"].percent < 50',
		['active'] = true,
	},
}
