return plane( "Su-30", _("Su-30"),
    {
        
        EmptyWeight = "17700",
        MaxFuelWeight = "9400",
        MaxHeight = "17300",
        MaxSpeed = "2200",
        MaxTakeOffWeight = "30500",
        Picture = "Su-30.png",
        Rate = "50",
        Shape = "Su-30",
        WingSpan = "14.7",
        WorldID = 13,
		country_of_origin = "RUS",

		-- Countermeasures
		passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 192,
			-- PPR-26
			chaff = {default = 96, increment = 3, chargeSz = 1},
			-- PPI-26
			flare = {default = 96, increment = 3, chargeSz = 1}
        },
		
        attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, Su_30,
        "Multirole fighters",
        },
        Categories = {
            pl_cat("{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor"),
        },
        CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),
        Sensors = {
            RADAR = "N-011M",
            IRST = "OLS-27",
            RWR = "Abstract RWR"
        },
        mapclasskey = "P0091000024",
    pylons_enumeration = {10, 1, 9, 2, 3, 8, 11, 12, 4, 7, 6, 5},
    Pylons = {
        pylon(1, 0, -1.943000, 0.173000, -7.280000,
            {arg = 308, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" }, --R-73
                { CLSID = '{RKL609_L}', arg = 308, arg_value = 1, required = {{station = 10, loadout = {'{RKL609_R}'},}} },--Sorbciya

                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" }, --Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" }, --Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" }, --Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" }, --Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" }, --Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" }, --Smoke Generator - orange

				--Modded
			{ CLSID = "DIS_PL-8B", arg_value = 0.2, attach_point_position = {0.5, 0, 0} }, --PL-8B

            },
			1
        ),
        pylon(2, 0, -2.535000, -0.165000, -6.168000,
            {arg = 309, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = '{FBC29BFE-3D24-4C64-B81D-941239D12249}', arg_value = 0 }, --R-73
                --{ CLSID = '{PL-8}', arg_value = 0 },  --PL-8
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" }, --Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" }, --Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" }, --Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" }, --Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" }, --Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" }, --Smoke Generator - orange

				--Modded
				{ CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0, Type = 1 }, --R-77
				{ CLSID = "DIS_SD-10", arg_value = 0, attach_point_position = {0.5, 0, 0} }, --SD-10
				{ CLSID = "DIS_PL-8B", arg_value = 0, attach_point_position = {0.5, 0, 0} }, --PL-8B
								
            },
			2
        ),
        pylon(3, 0, -1.137000, -0.321000, -4.524000,
            {arg = 310, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = '{FBC29BFE-3D24-4C64-B81D-941239D12249}' , arg_value = 0.3}, --R-73
                --{ CLSID = '{PL-8}', arg_value = 0 },  --PL-8
                { CLSID = '{9B25D316-0434-4954-868F-D51DB1A38DF0}', arg_value = 0 }, --R-27R
                { CLSID = '{E8069896-8435-4B90-95C0-01A03AE6E400}', arg_value = 0 }, --R-27ER
                { CLSID = '{88DAC840-9F75-4531-8689-B46E64E42E53}', arg_value = 0 }, --R-27T
                { CLSID = '{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}', arg_value = 0 }, --R-27ET
                { CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0.45, Type = 1 }, --R-77
                BD3("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"),--BetAB-500
                BD3("{BD289E34-DF84-4C5E-9220-4B14C346E79D}"),--BetAB-500ShP
                BD3('{37DCC01E-9E02-432F-B61D-10C166CA2798}'), --FAB-500 M62
                BD3('{3C612111-C7AD-476E-8A8E-2485812F4E5C}'),--FAB-250
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74884}"), --KMGU-2 - 96 AO-2.5RT
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74881}"), --KMGU-2 - 96 PTAB-2.5KO
                BD3("{4203753F-8198-4E85-9924-6F8FF679F9FF}"),--RBK-250 PTAB-2.5M
                BD3("{RBK_250_275_AO_1SCH}"),                -- RBK-250-275 AO-1SCh
                BD3("{D5435F26-F120-4FA3-9867-34ACE562EF1B}"),--RBK-500 PTAB-10-5
                BD3("{7AEC222D-C523-425e-B714-719C0D1EB14D}"),--RBK-500 PTAB-1M
                BD3("{RBK_500U_OAB_2_5RT}"),                --RBK-500U OAB-2.5RT
                MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER*6 FAB-100
                MBD("{53BE25A4-C86C-4571-9BC0-47D668349595}"),-- 6 * FAB-250
                BD3("{0511E528-EA28-4caf-A212-00D1408DF10A}"), --SAB-100
                BD3("{FC56DF80-9B09-44C5-8976-DCFAFF219062}"), --B-13L - 5 S-13 OF
                BD3("{A0648264-4BC0-4EE8-A543-D119F6BA4257}"), --S-25 OFM
                BD3("{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"), --B-8M1 - 20 S-8KOM
                BD3("{3DFB7320-AB0E-11d7-9897-000476191836}"), --B-8M1 - 20 S-8TsM
                BD3("B-8M1 - 20 S-8OFP2"),--B-8M1 - 20 S-8OFP2

                -- twin pylon
                { CLSID = '{FAB_250_DUAL_L}', arg_value = 1.0 }, --
                { CLSID = '{FAB_500_DUAL_L}', arg_value = 1.0 }, --
                { CLSID = '{RBK_250_PTAB25M_DUAL_L}', arg_value = 1.0 }, --
                { CLSID = '{RBK_500_PTAB105_DUAL_L}', arg_value = 1.0 },
                { CLSID = '{B13_5_S13OF_DUAL_L}', arg_value = 1.0 }, --
                { CLSID = '{B8M1_20_S8KOM_DUAL_L}', arg_value = 1.0 }, --
                { CLSID = '{B8M1_20_S8TsM_DUAL_L}', arg_value = 1.0 }, --
                { CLSID = '{B8M1_20_S8OFP2_DUAL_L}', arg_value = 1.0 }, --
                { CLSID = '{S25_DUAL_L}', arg_value = 1.0 }, --

				--Modded			
				{ CLSID = 'DIS_PL-12', arg_value = 0.45, Type = 1}, --PL-12
				{ CLSID = "DIS_SD-10", arg_value = 0.35, attach_point_position = {0.5, 0, 0} }, --SD-10
				{ CLSID = "DIS_SD-10_DUAL_L", arg_value = 1,  attach_point_position = {0, 0.07, 0} },
				{ CLSID = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}", arg_value = 0.35, Type = 1 }, -- R-33 (100km) Mach 3.5

				{CLSID = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },-- Kh-25MPU
				{CLSID = "{Kh-25MP}", arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },				-- Kh-25MP
				{ CLSID = "{X-31P}", arg_value = 0.45, Type = 1 , attach_point_position = {0.4, 0, 0} },	--	Kh-31P


				MBD("{MBD3_U6_5*FAB-250}"),	--MER 6*5 FAB-250 
				MBD("{3E35F8C1-052D-11d6-9191-00A0249B6F00}"),	-- 4 * FAB-250	
				MBD("{MBD3_U6_3*FAB-250_fwd}"),		--MER*3 FAB-250 
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100 
				{ CLSID = "{FAB_250_M62}" ,arg_value = 0.15},
				{CLSID = "{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}", arg_value = 0.15 },		--	FAB-1500 M54 
				{ CLSID = "DIS_YU_6"}, --YU-6
				{ CLSID = "{LTF_5B}"},
				{ CLSID = 'DIS_PL-12_DUAL', arg_value = 1.0 } 
				

            },
			3
        ),
        pylon(4, 1, -0.075000, -1.218000, -1.192000,
            {arg = 311, arg_value = 1, use_full_connector_position = true,},
            {
                { CLSID = '{9B25D316-0434-4954-868F-D51DB1A38DF0}', arg_value = 0 }, --R-27R
                { CLSID = '{E8069896-8435-4B90-95C0-01A03AE6E400}', arg_value = 0 }, --R-27ER
                --{ CLSID = '{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}', arg_value = 0 }, --R-27ET
                { CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0.35, Type = 1 }, --R-77
                BD3('{37DCC01E-9E02-432F-B61D-10C166CA2798}'), --FAB-500 M62
                BD3('{3C612111-C7AD-476E-8A8E-2485812F4E5C}'),--FAB-250
                BD3("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"),--BetAB-500
                BD3("{BD289E34-DF84-4C5E-9220-4B14C346E79D}"),--BetAB-500ShP
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74884}"), --KMGU-2 - 96 AO-2.5RT
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74881}"), --KMGU-2 - 96 PTAB-2.5KO
                MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER*6 FAB-100
                BD3("{RBK_250_275_AO_1SCH}"),                -- RBK-250-275 AO-1SCh
                BD3("{D5435F26-F120-4FA3-9867-34ACE562EF1B}"),--RBK-500 PTAB-10-5
                BD3("{7AEC222D-C523-425e-B714-719C0D1EB14D}"),--RBK-500 PTAB-1M
                BD3("{RBK_500U_OAB_2_5RT}"),                --RBK-500U OAB-2.5RT
                BD3("{0511E528-EA28-4caf-A212-00D1408DF10A}"), --SAB-100

				--Modded
				{ CLSID = 'DIS_PL-12', arg_value = 0.45, Type = 1}, --PL-12
				{ CLSID = 'DIS_SD-10', arg_value = 0.35, Type = 1, attach_point_position = {0.5, 0, 0} }, --SD-10 
				{ CLSID = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}", arg_value = 0, Type = 1 }, -- R-33 (100km) Mach 3.5
							
				{CLSID = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },-- Kh-25MPU
				{CLSID = "{Kh-25MP}", arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },				-- Kh-25MP
				{ CLSID = "{X-31P}", arg_value = 0, Type = CATAPULT },	--	Kh-31P 

				MBD("{MBD3_U6_5*FAB-250}"),	--MER 6*5 FAB-250 
				MBD("{3E35F8C1-052D-11d6-9191-00A0249B6F00}"),	-- 4 * FAB-250	
				MBD("{MBD3_U6_3*FAB-250_fwd}"),		--MER*3 FAB-250 
				{ CLSID = "{FAB_250_M62}" ,arg_value = 0.15},

            },
			5
        ),
        pylon(5, 1, -3.751000, -0.384000, 0.000000,
            {arg = 312, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = '{9B25D316-0434-4954-868F-D51DB1A38DF0}', arg_value = 0 }, --R-27R
                { CLSID = '{E8069896-8435-4B90-95C0-01A03AE6E400}', arg_value = 0 }, --R-27ER
                --{ CLSID = '{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}', arg_value = 0 }, --R-27ET
                { CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0.35, Type = 1 }, --R-77
                BD3('{37DCC01E-9E02-432F-B61D-10C166CA2798}'), --FAB-500 M62
                BD3('{3C612111-C7AD-476E-8A8E-2485812F4E5C}'),--FAB-250
                BD3("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"),--BetAB-500
                BD3("{BD289E34-DF84-4C5E-9220-4B14C346E79D}"),--BetAB-500ShP
                MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER*6 FAB-100
                BD3("{RBK_250_275_AO_1SCH}"),                -- RBK-250-275 AO-1SCh
                BD3("{D5435F26-F120-4FA3-9867-34ACE562EF1B}"),--RBK-500 PTAB-10-5
                BD3("{7AEC222D-C523-425e-B714-719C0D1EB14D}"),--RBK-500 PTAB-1M
                BD3("{RBK_500U_OAB_2_5RT}"),                --RBK-500U OAB-2.5RT
                BD3("{0511E528-EA28-4caf-A212-00D1408DF10A}"), --SAB-100
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" }, --Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" }, --Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" }, --Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" }, --Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" }, --Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" }, --Smoke Generator - orange

				--Modded
				{ CLSID = 'DIS_PL-12', arg_value = 0.45, Type = 1}, --PL-12
				{ CLSID = 'DIS_SD-10', arg_value = 0.35, Type = 1, attach_point_position = {0.5, 0, 0} }, --SD-10 
				{ CLSID = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}" }, -- R-33 (100km) Mach 3.5
				{CLSID = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },-- Kh-25MPU
				{CLSID = "{Kh-25MP}", arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },				-- Kh-25MP

				MBD("{MBD3_U6_3*FAB-250_fwd}"),		--MER*3 FAB-250 
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{ CLSID = "{FAB_250_M62}" ,arg_value = 0.15},
															   
            },
			6
		),
        pylon(6, 1, 0.986000, -0.384000, 0.000000,
            {arg = 313, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = '{9B25D316-0434-4954-868F-D51DB1A38DF0}', arg_value = 0 }, --R-27R
                { CLSID = '{E8069896-8435-4B90-95C0-01A03AE6E400}', arg_value = 0 }, --R-27ER
                --{ CLSID = '{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}', arg_value = 0 }, --R-27ET
                { CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0.35, Type = 1 }, --R-77
                BD3('{37DCC01E-9E02-432F-B61D-10C166CA2798}'), --FAB-500 M62
                BD3('{3C612111-C7AD-476E-8A8E-2485812F4E5C}'),--FAB-250
                BD3("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"),--BetAB-500
                BD3("{BD289E34-DF84-4C5E-9220-4B14C346E79D}"),--BetAB-500ShP
                MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER*6 FAB-100
                MBD("{53BE25A4-C86C-4571-9BC0-47D668349595}"),-- 6 * FAB-250
                BD3("{RBK_250_275_AO_1SCH}"),                -- RBK-250-275 AO-1SCh
                BD3("{D5435F26-F120-4FA3-9867-34ACE562EF1B}"),--RBK-500 PTAB-10-5
                BD3("{7AEC222D-C523-425e-B714-719C0D1EB14D}"),--RBK-500 PTAB-1M
                BD3("{RBK_500U_OAB_2_5RT}"),                --RBK-500U OAB-2.5RT
                BD3("{0511E528-EA28-4caf-A212-00D1408DF10A}"), --SAB-100
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" }, --Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" }, --Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" }, --Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" }, --Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" }, --Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" }, --Smoke Generator - orange

				--Modded
				{ CLSID = 'DIS_PL-12', arg_value = 0.45, Type = 1}, --PL-12
				{ CLSID = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}", arg_value = 0, Type = 1 }, -- R-33 (100km) Mach 3.5
				{ CLSID = 'DIS_SD-10', arg_value = 0.35, Type = 1, attach_point_position = {0.5, 0, 0} }, --SD-10
	
				{CLSID = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },-- Kh-25MPU
				{CLSID = "{Kh-25MP}", arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },				-- Kh-25MP
				{ CLSID = "{X-31P}", arg_value = 0.35, Type = CATAPULT },	--	Kh-31P

				MBD("{MBD3_U6_5*FAB-250}"),	--MER 6*5 FAB-250
				MBD("{3E35F8C1-052D-11d6-9191-00A0249B6F00}"),	-- 4 * FAB-250	
				MBD("{MBD3_U6_3*FAB-250_fwd}"),		--MER*3 FAB-250
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100
				{ CLSID = "{FAB_250_M62}" ,arg_value = 0.15},
				{CLSID	= "{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}", arg_value = 0.15 },		--	FAB-1500 M54
				{ CLSID = "DIS_YU_6", attach_point_position = {-1.357000, -0.384000, 0.000000}}, --YU-6

            },
			7
        ),
        pylon(7, 1, -0.075000, -1.218000, 1.192000,
            {arg = 314, arg_value = 1, use_full_connector_position = true,},
            {
                { CLSID = '{9B25D316-0434-4954-868F-D51DB1A38DF0}', arg_value = 0 }, --R-27R
                { CLSID = '{E8069896-8435-4B90-95C0-01A03AE6E400}', arg_value = 0 }, --R-27ER
                --{ CLSID = '{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}', arg_value = 0 }, --R-27ET
                { CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0.35, Type = 1 }, --R-77
                BD3('{37DCC01E-9E02-432F-B61D-10C166CA2798}'), --FAB-500 M62
                BD3('{3C612111-C7AD-476E-8A8E-2485812F4E5C}'),--FAB-250
                BD3("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"),--BetAB-500
                BD3("{BD289E34-DF84-4C5E-9220-4B14C346E79D}"),--BetAB-500ShP
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74884}"), --KMGU-2 - 96 AO-2.5RT
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74881}"), --KMGU-2 - 96 PTAB-2.5KO
                MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER*6 FAB-100
                BD3("{RBK_250_275_AO_1SCH}"),                -- RBK-250-275 AO-1SCh
                BD3("{D5435F26-F120-4FA3-9867-34ACE562EF1B}"),--RBK-500 PTAB-10-5
                BD3("{7AEC222D-C523-425e-B714-719C0D1EB14D}"),--RBK-500 PTAB-1M
                BD3("{RBK_500U_OAB_2_5RT}"),                --RBK-500U OAB-2.5RT
                BD3("{0511E528-EA28-4caf-A212-00D1408DF10A}"), --SAB-100

				--Modded
				{ CLSID = 'DIS_PL-12', arg_value = 0.45, Type = 1}, --PL-12
				{ CLSID = 'DIS_SD-10', arg_value = 0.35, Type = 1, attach_point_position = {0.5, 0, 0} }, --SD-10 
				{ CLSID = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}", arg_value = 0, Type = 1 }, -- R-33 (100km) Mach 3.5

				{CLSID = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },-- Kh-25MPU
				{CLSID = "{Kh-25MP}", arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },				-- Kh-25MP
				{ CLSID = "{X-31P}", arg_value = 0, Type = CATAPULT },	--	Kh-31P 

				MBD("{MBD3_U6_5*FAB-250}"),	--MER 6*5 FAB-250 
				MBD("{3E35F8C1-052D-11d6-9191-00A0249B6F00}"),	-- 4 * FAB-250	
				MBD("{MBD3_U6_3*FAB-250_fwd}"),		--MER*3 FAB-250 
				{ CLSID = "{FAB_250_M62}" ,arg_value = 0.15}			,
	
            },
			8
        ),
        pylon(8, 0, -1.137000, -0.321000, 4.524000,
            {arg = 315, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = '{FBC29BFE-3D24-4C64-B81D-941239D12249}' , arg_value = 0.3}, --R-73
                --{ CLSID = '{PL-8}', arg_value = 0 },  --PL-8
                { CLSID = '{9B25D316-0434-4954-868F-D51DB1A38DF0}', arg_value = 0 }, --R-27R
                { CLSID = '{E8069896-8435-4B90-95C0-01A03AE6E400}', arg_value = 0 }, --R-27ER
                { CLSID = '{88DAC840-9F75-4531-8689-B46E64E42E53}', arg_value = 0 }, --R-27T
                { CLSID = '{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}', arg_value = 0 }, --R-27ET
                { CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0.45, Type = 1 }, --R-77
                BD3("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"),--BetAB-500
                BD3("{BD289E34-DF84-4C5E-9220-4B14C346E79D}"),--BetAB-500ShP
                BD3('{37DCC01E-9E02-432F-B61D-10C166CA2798}'), --FAB-500 M62
                BD3('{3C612111-C7AD-476E-8A8E-2485812F4E5C}'),--FAB-250
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74884}"), --KMGU-2 - 96 AO-2.5RT
                --BD3("{96A7F676-F956-404A-AD04-F33FB2C74881}"), --KMGU-2 - 96 PTAB-2.5KO
                BD3("{4203753F-8198-4E85-9924-6F8FF679F9FF}"),--RBK-250 PTAB-2.5M
                BD3("{RBK_250_275_AO_1SCH}"),                -- RBK-250-275 AO-1SCh
                BD3("{D5435F26-F120-4FA3-9867-34ACE562EF1B}"),--RBK-500 PTAB-10-5
                BD3("{7AEC222D-C523-425e-B714-719C0D1EB14D}"),--RBK-500 PTAB-1M
                BD3("{RBK_500U_OAB_2_5RT}"),                --RBK-500U OAB-2.5RT
                MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER*6 FAB-100
                MBD("{53BE25A4-C86C-4571-9BC0-47D668349595}"),-- 6 * FAB-250
                BD3("{0511E528-EA28-4caf-A212-00D1408DF10A}"), --SAB-100
                BD3("{FC56DF80-9B09-44C5-8976-DCFAFF219062}"), --B-13L - 5 S-13 OF
                BD3("{A0648264-4BC0-4EE8-A543-D119F6BA4257}"), --S-25 OFM
                BD3("{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"), --B-8M1 - 20 S-8KOM
                BD3("{3DFB7320-AB0E-11d7-9897-000476191836}"), --B-8M1 - 20 S-8TsM
                BD3("B-8M1 - 20 S-8OFP2"),--B-8M1 - 20 S-8OFP2

                -- twin pylon
                { CLSID = '{FAB_250_DUAL_R}', arg_value = 1.0 }, --
                { CLSID = '{FAB_500_DUAL_R}', arg_value = 1.0 }, --
                { CLSID = '{RBK_250_PTAB25M_DUAL_R}', arg_value = 1.0 }, --
                { CLSID = '{RBK_500_PTAB105_DUAL_R}', arg_value = 1.0 },
                { CLSID = '{B13_5_S13OF_DUAL_R}', arg_value = 1.0 }, --
                { CLSID = '{B8M1_20_S8KOM_DUAL_R}', arg_value = 1.0 }, --
                { CLSID = '{B8M1_20_S8TsM_DUAL_R}', arg_value = 1.0 }, --
                { CLSID = '{B8M1_20_S8OFP2_DUAL_R}', arg_value = 1.0 }, --
                { CLSID = '{S25_DUAL_R}', arg_value = 1.0 }, --
				
				--Modded
				{ CLSID = 'DIS_PL-12', arg_value = 0.45, Type = 1}, --PL-12
				{ CLSID = "DIS_SD-10", arg_value = 0.35, attach_point_position = {0.5, 0, 0} }, --SD-10
				{ CLSID = "DIS_SD-10_DUAL_L", arg_value = 1, attach_point_position = {0, 0.07, 0} },
				{ CLSID = "{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}", arg_value = 0.35, Type = 1 }, -- R-33 (100km) Mach 3.5	

				{CLSID = "{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}",arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },-- Kh-25MPU
				{CLSID = "{Kh-25MP}", arg_value = 0.2, attach_point_position = {0.08, 0.03, 0} },				-- Kh-25MP
				{ CLSID = "{X-31P}", arg_value = 0.45, Type = 1 , attach_point_position = {0.4, 0, 0} },	--	Kh-31P


				MBD("{MBD3_U6_5*FAB-250}"),	--MER 6*5 FAB-250 
				MBD("{3E35F8C1-052D-11d6-9191-00A0249B6F00}"),	-- 4 * FAB-250	
				MBD("{MBD3_U6_3*FAB-250_fwd}"),		--MER*3 FAB-250 
				{CLSID = "{29A828E2-C6BB-11d8-9897-000476191836}"},-- MBD-2-67U - 4 FAB-100 
				{CLSID = "{FAB_250_M62}" ,arg_value = 0.15},
				{CLSID = "{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}", arg_value = 0.15 },		--	FAB-1500 M54 
				{CLSID = "DIS_YU_6"}, --YU-6
				{ CLSID = "{LTF_5B}"},
				{ CLSID = 'DIS_PL-12_DUAL', arg_value = 1.0 } 

            },
			10
        ),
        pylon(9, 0, -2.535000, -0.165000, 6.168000,
            {arg = 316, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = '{FBC29BFE-3D24-4C64-B81D-941239D12249}', arg_value = 0 }, --R-73
                --{ CLSID = '{PL-8}', arg_value = 0 },  --PL-8
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" }, --Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" }, --Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" }, --Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" }, --Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" }, --Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" }, --Smoke Generator - orange

				--Modded
				{ CLSID = '{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}', arg_value = 0, Type = 1 }, --R-77
				{ CLSID = "DIS_SD-10", arg_value = 0, attach_point_position = {0.5, 0, 0} }, --SD-10
				{ CLSID = "DIS_PL-8B", arg_value = 0, attach_point_position = {0.5, 0, 0} }, --PL-8B                        

            },
			11
        ),
        pylon(10, 0, -1.943000, 0.173000, 7.280000,
            {arg = 317, arg_value = 0, use_full_connector_position = true,},
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" }, --R-73
                { CLSID = '{RKL609_R}', arg = 317, arg_value = 1, required = {{station = 1, loadout = {'{RKL609_L}'},}} },--Sorbciya

                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}" }, --Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}" }, --Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}" }, --Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}" }, --Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}" }, --Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}" }, --Smoke Generator - orange
				
				--Modded
				{ CLSID = "DIS_PL-8B", arg_value = 0.2, attach_point_position = {0.5, 0, 0} }, --PL-8B

            },
			12
        ),
		
		pylon(11, 0, -0.091000, -0.321000, -3.253000,
            {arg = 324, arg_value = 0, use_full_connector_position = true,},
            {
                -- twin pylon
                { CLSID = '{FAB_250_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{FAB_500_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{RBK_250_PTAB25M_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{RBK_500_PTAB105_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} },
                { CLSID = '{B13_5_S13OF_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{B8M1_20_S8KOM_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{B8M1_20_S8TsM_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{B8M1_20_S8OFP2_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{S25_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --

				--Modded			
				{ CLSID = "DIS_SD-10_DUAL_L", arg_value = 1,  attach_point_position = {0, 0.67, 0} },


			},
			4
		),
		
		pylon(12, 0, -0.091000, -0.321000, 3.253000,
            {arg = 325, arg_value = 0, use_full_connector_position = true,},
            {
                -- twin pylon
                { CLSID = '{FAB_250_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{FAB_500_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{RBK_250_PTAB25M_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{RBK_500_PTAB105_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} },
                { CLSID = '{B13_5_S13OF_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{B8M1_20_S8KOM_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{B8M1_20_S8TsM_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{B8M1_20_S8OFP2_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --
                { CLSID = '{S25_DUAL_L}', arg_value = 1.0,  attach_point_position = {0, 0.56, 0} }, --

				--Modded			
				{ CLSID = "DIS_SD-10_DUAL_L", arg_value = 1,  attach_point_position = {0, 0.67, 0} },



			},
			9
		),		
    },
    {
        aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
        --aircraft_task(GAI),
        aircraft_task(AFAC),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
        aircraft_task(CAS),
        aircraft_task(PinpointStrike),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
    },
	aircraft_task(CAP)
);
