-- Server hooks
module('server', package.seeall)

-- do not load real gettext here
-- _ only marks strings for translation
local _ = function(msg) return msg end

local log

local names = {}

local function log_write(str)
	net.log(str)
	if log then log:write(os.date("%c") .. " : " .. str .. "\n") end
end

local function unit_type(unit) return net.get_unit_property(unit, 4) or "" end

local function side_name(side)
	if side == 0 then return "Spectateur"
	elseif side == 1 then return "Rouge"
	else return "Bleu" end
end

function on_net_start()
	log = io.open("Temp/net-server.log", "w")
	log_write("Dmarrage du serveur")

	names = {}
	names[net.get_name(1)] = 1
end

function on_mission(filename)
	--already reported
	--log_write("Loaded mission ", filename)
end

function on_net_stop()
	log_write("arrt du serveur")
	if log then
		log:close()
		log = nil
	end
	names = {}
end

function on_process()
end

function on_connect(id, addr, port, name, ucid)
--[[ banning example
	if banned_hosts and banned_hosts[addr] then
		-- extend the ban
		--banned_hosts[addr] = os.time()
		return "Banned by IP", false
	end
	if banned_names and banned_names[name] then
		-- extend the ban
		--banned_names[name] = os.time()
		return "Banned by name", false
	end
	if banned_serials and banned_serials[ucid] then
		-- extend the ban
		--banned_names[name] = os.time()
		return "Banned by UniqueClientID", false
	end
]]

	-- write to log
	log_write(string.format("Client connect: id = [%d], addr = %s:%d, nom = %q",
		id, addr, port, name))
	--net.recv_chat(string.format(_("Connected client: id = [%d], addr = %s:%d, name = %q", id, addr, port, name)))

	if names[name] then
		return _("S'il vous plat, donner un surnom unique."), false
	end

	names[name] = id

	return true
end

function on_disconnect(id, err)
	local n = net.get_name(id)
	if names[n] then
		names[n] = nil
	end
	log_write(string.format("Client dconnect [%d] %q", id, n))
end

--
function on_set_name(id, new_name)
	-- check against ban list
	--if banned_names[new_name] then
	--	kick(id, "banned name")
	--end
	old_name = net.get_name(id)
	if names[new_name] then
		log_write(string.format("Client [%d] %q essay de chang de nom pour %q", id, old_name, new_name))
		return old_name
	end
	names[old_name] = nil
	names[new_name] = id
	log_write(string.format("Client [%d] %q Nom modifi par %q", id, old_name, new_name))
	return name
end

function on_set_unit(id, side, unit)
	name = net.get_name(id)
	if unit ~= "" then
		msg = string.format("Client [%d] %q rejoint %s en %q(%s)", id, name, side_name(side), unit_type(unit), unit)
	else
		msg = string.format("Client [%d] %q rejoint %s", id, name, side_name(side))
	end
	log_write(msg)
	return true
end

function on_chat(id, msg, all)
	if msg=="/mybad" then
		return string.format("je (%d, %q) a pris un screenshot  %f", id, net.get_name(id), net.get_model_time())
	elseif string.sub(msg, 1, 1) == '/' then
		net.recv_chat("ecrir le message: "..msg, 0)
		return
	end
	return msg
end


--------------------------------------------------
-- load event callbacks

dofile('./Scripts/net/events.lua')
