﻿Clear-Host

$ScriptTitle = "DCS TARGET Macro File Generator"
$ScriptVersion = "V2.0 - 01/07/2021"

function Remove-Diacritics {
	param (
		[string]$String,
		[switch]$Capitalize
	)
	$objD = $String.Normalize([Text.NormalizationForm]::FormD)
	$sb = New-Object Text.StringBuilder
	# Traitement des Diacritics
	for ($i = 0; $i -lt $objD.Length; $i++) {
		$c = [Globalization.CharUnicodeInfo]::GetUnicodeCategory($objD[$i])
		if ($c -ne [Globalization.UnicodeCategory]::NonSpacingMark) {[void]$sb.Append($objD[$i])}
	}
	# Traitement des caractères spéciaux
	$sb = $sb.Replace('–','-').Replace('Δ','D').Replace('œ','oe').Replace("'","")
    $sb = $sb -Replace ('\s+','_')
    $sb = $sb -Replace ('[,&: -/]','_')
	$sb = $sb -Replace ("[^\da-zA-Z-._' ]","")
    $sb = $sb -Replace ('_+','_')
	$sb = $sb.Trim().TrimEnd('_')
	$sb = "$sb".Normalize([Text.NormalizationForm]::FormC)
	# Switch Capitalize
	if ($PSBoundParameters['Capitalize']) {
		$sb = (Get-Culture).TextInfo.ToTitleCase($sb.ToLower())
	}
	return $sb

}

#Présentation
Write-Host ""
Write-Host "`t$ScriptTitle" -ForegroundColor Yellow
Write-Host "`t$ScriptVersion" -ForegroundColor Gray
Write-Host "`tIRRE_Biluf @ www.lesirreductibles.com" -ForegroundColor Gray
Write-Host ""
Write-Host "`t1 - Export your plane inputs in game (HTML)"
Write-Host "`t2 - Select your html file (Keyboard.html)"
Write-Host "`t3 - Choose your plane name"
Write-Host "`t4 - Link the generated .ttm file in your TARGET Script"
Write-Host ""

# Import du HTML
Add-type -Assembly System.Windows.Forms
$OpenFileDialog = New-Object System.Windows.Forms.OpenFileDialog
$OpenFileDialog.Title = "Select your Keyboard.html"
$OpenFileDialog.initialDirectory = $PSScriptRoot
$OpenFileDialog.filter = "HTML File (*.html)| *.html"
$OpenFileDialog.ShowDialog() | Out-Null
$OpenFileDialog.filename
$SourceHTML = Get-Content $OpenFileDialog.filename -Encoding UTF8

if ($SourceHTML) {

	# Sélection du nom de l'avion
	$FolderHTML = $OpenFileDialog.FileName.Split('\')
	$FolderHTML = $FolderHTML[$FolderHTML.Count-2]
	[System.Reflection.Assembly]::LoadWithPartialName('Microsoft.VisualBasic') | Out-Null
	$Aircraft = [Microsoft.VisualBasic.Interaction]::InputBox("Enter the name of the plane.`r`nThe Output file will be :`r`nDCS_<PlaneName>_Macro.ttm", "Plane Name", $FolderHTML)

	# Définition du fichier de sortie
	$OutFile = "$PSScriptRoot\DCS_" + $Aircraft.Replace(' ','') + "_Macro.ttm"

	# Hash Table USB codes
	$USBCodes = @{"a"="USB[0x04]";"b"="USB[0x05]";"c"="USB[0x06]";"d"="USB[0x07]";"e"="USB[0x08]";"f"="USB[0x09]";"g"="USB[0x0A]";"h"="USB[0x0B]";"i"="USB[0x0C]";"j"="USB[0x0D]";"k"="USB[0x0E]";"l"="USB[0x0F]";"m"="USB[0x10]";"n"="USB[0x11]";"o"="USB[0x12]";"p"="USB[0x13]";"q"="USB[0x14]";"r"="USB[0x15]";"s"="USB[0x16]";"t"="USB[0x17]";"u"="USB[0x18]";"v"="USB[0x19]";"w"="USB[0x1A]";"x"="USB[0x1B]";"y"="USB[0x1C]";"z"="USB[0x1D]";"1"="USB[0x1E]";"2"="USB[0x1F]";"3"="USB[0x20]";"4"="USB[0x21]";"5"="USB[0x22]";"6"="USB[0x23]";"7"="USB[0x24]";"8"="USB[0x25]";"9"="USB[0x26]";"0"="USB[0x27]";"Enter"="USB[0x28]";"Esc"="USB[0x29]";"Back"="USB[0x2A]";"Tab"="USB[0x2B]";"Space"="USB[0x2C]";"-"="USB[0x2D]";"="="USB[0x2E]";"["="USB[0x2F]";"]"="USB[0x30]";"\"="USB[0x31]";";"="USB[0x33]";"'"="USB[0x34]";"``"="USB[0x35]";","="USB[0x36]";"."="USB[0x37]";"/"="USB[0x38]";"CapsLock"="USB[0x39]";"F1"="USB[0x3A]";"F2"="USB[0x3B]";"F3"="USB[0x3C]";"F4"="USB[0x3D]";"F5"="USB[0x3E]";"F6"="USB[0x3F]";"F7"="USB[0x40]";"F8"="USB[0x41]";"F9"="USB[0x42]";"F10"="USB[0x43]";"F11"="USB[0x44]";"F12"="USB[0x45]";"SysRQ"="USB[0x46]";"Scroll"="USB[0x47]";"Break"="USB[0x48]";"Pause"="USB[0x48]";"Insert"="USB[0x49]";"Home"="USB[0x4A]";"PageUp"="USB[0x4B]";"Delete"="USB[0x4C]";"End"="USB[0x4D]";"PageDown"="USB[0x4E]";"Right"="USB[0x4F]";"Left"="USB[0x50]";"Down"="USB[0x51]";"Up"="USB[0x52]";"NumLock"="USB[0x53]";"num/"="USB[0x54]";"num*"="USB[0x55]";"num-"="USB[0x56]";"num+"="USB[0x57]";"numEnter"="USB[0x58]";"num1"="USB[0x59]";"num2"="USB[0x5A]";"num3"="USB[0x5B]";"num4"="USB[0x5C]";"num5"="USB[0x5D]";"num6"="USB[0x5E]";"num7"="USB[0x5F]";"num8"="USB[0x60]";"num9"="USB[0x61]";"num0"="USB[0x62]";"num."="USB[0x63]";"num="="USB[0x67]";"F13"="USB[0x68]";"F14"="USB[0x69]";"F15"="USB[0x6A]";"F16"="USB[0x6B]";"F17"="USB[0x6C]";"F18"="USB[0x6D]";"F19"="USB[0x6E]";"F20"="USB[0x6F]";"F21"="USB[0x70]";"F22"="USB[0x71]";"F23"="USB[0x72]";"F24"="USB[0x73]";"LShift"="L_SHIFT";"RShift"="R_SHIFT";"LCtrl"="L_CTL";"RCtrl"="R_CTL";"LAlt"="L_ALT";"RAlt"="R_ALT";"LWin"="L_WIN"}

	# Préparation de l'Array
	$Results = New-Object System.Collections.ArrayList

	# Préparation de la DataTable
	$dt = New-Object System.Data.Datatable "Mapping"
	[Void]$dt.Columns.Add("Categorie")
	[Void]$dt.Columns.Add("Define")
	[Void]$dt.Columns.Add("Libelle")
	[Void]$dt.Columns.Add("Mapping")
	[Void]$dt.Columns.Add("Comment")
	[Void]$dt.Columns.Add("DefineLength",[System.Type]::GetType("System.Int32") ) 
	[Void]$dt.Columns.Add("LibelleLength",[System.Type]::GetType("System.Int32") ) 
	[Void]$dt.Columns.Add("MappingLength",[System.Type]::GetType("System.Int32") ) 
	[Void]$dt.Columns.Add("CommentLength",[System.Type]::GetType("System.Int32") ) 

	# Parsing
	for ($i = 12; $i -lt $SourceHTML.Count;$i++) {
		if ($SourceHTML[$i] -match "^\s+<tr>") {
			
			# Create dt Row
			$row = $dt.NewRow(); $i++

			# Parsing HTML Row
			$Mapping = $SourceHTML[$i] -Replace("^\s+<td>","") -Replace("</td>",""); $i++
			$Libelle = $SourceHTML[$i] -Replace("^\s+<td>","") -Replace("</td>",""); $i++
			$Categorie = $SourceHTML[$i] -Replace("^\s+<td>","") -Replace("</td>","")
	
			# Categorie
			$row["Categorie"] = $Categorie
	
			# Define
			$row["Define"] = "define"
			$row["DefineLength"] = $row["Define"].Length
	
			# Libelle
			$rowLib = Remove-Diacritics $Libelle
			if ($rowLib -match "^\d") {$rowLib = "_" + $rowLib}
			$row["Libelle"] = $rowLib
			$row["LibelleLength"] = $row["Libelle"].Length
	
			# Mapping
			$tabMapping = $Mapping.Replace('"; "','¤').Split('¤')[0]
			$tabMapping = $tabMapping.Trim('"').Replace(' - ','¤').Split('¤')
			$newMapping = $null
			for ($j = 0; $j -le $tabMapping.Count; $j++) {
				$Touche = $tabMapping[$j]
				$newMapping += $USBCodes["$Touche"] + "+"
			}
			$row["Mapping"] = $newMapping.TrimEnd('+')
			$row["MappingLength"] = $row["Mapping"].Length
	
			# Comment
			$row["Comment"] = '// "' + $Mapping + '"'
			$row["Comment"] = $row["Comment"].Replace('""',"")
			$row["CommentLength"] = $row["Comment"].Length
	
			# Add dt Row
			$dt.Rows.Add($row)  
	
		}
	}

	# Composition du fichier de Macro

	# Maximums
	$DefineMax  = ($dt.Rows.DefineLength | Measure-Object -Maximum).Maximum
	$LibelleMax = ($dt.Rows.LibelleLength | Measure-Object -Maximum).Maximum
	$MappingMax = ($dt.Rows.MappingLength | Measure-Object -Maximum).Maximum
	$CommentMax = ($dt.Rows.CommentLength | Measure-Object -Maximum).Maximum
	$col = $DefineMax + $LibelleMax + $MappingMax + $CommentMax + 11

	# Entête
	$line = "//$("*"*($col - 2))";[void]$Results.Add($line)
	$line = "// $ScriptTitle - $ScriptVersion";[void]$Results.Add($line)
	$line = "// DCS $Aircraft - Generated $(Get-Date)";[void]$Results.Add($line)
	$line = "//$("*"*($col - 2))`r`n";[void]$Results.Add($line)

	# Affichage par catégorie
	($dt | Where-Object {$_.Categorie -ne ''} | Select-Object Categorie -Unique).Categorie | Sort-Object | ForEach-Object {
		$Cat = $_
		$line = "`r`n// $Cat $("*" * $($col - $Cat.Length - 4))`r`n"
		[void]$Results.Add($line)
		$dt | Where-Object {$_.Categorie -eq $Cat} | Sort-Object Libelle -Unique | ForEach-Object {
			$SpacerLibelle = $DefineMax - $_.Define.Length + 5
			$SpacerMapping = $LibelleMax - $_.Libelle.Length + 3
			$SpacerComment = $MappingMax - $_.Mapping.Length + 3
			$line = ("{0}{1}{2}{3}{4}{5}{6}" -f $_.Define,$(" "*$SpacerLibelle),$_.Libelle,$(" "*$SpacerMapping),$_.Mapping,$(" "*$SpacerComment),$_.Comment)
			[void]$Results.Add($line)
		}
	}

	# Sortie vers le fichier
	$Utf8NoBomEncoding = New-Object System.Text.UTF8Encoding($False)
	[System.IO.File]::WriteAllLines($OutFile, $Results, $Utf8NoBomEncoding)

}