--To generate a new mission file. Unzips template mission, defines content of next missions and packs a new mission file
--Initiated by Debrief_Master.lua, BAT_FirstMission.lua or BAT_RedoMission.lua
------------------------------------------------------------------------------------------------------- 
-- Miguel Fichier Revision M37.d
------------------------------------------------------------------------------------------------------- 

-- miguel21 modification M37.d SuperCarrier
-- Miguel21 modification M35 version ScriptsMod
-- miguel21 modification M34 custom FrequenceRadio
-- Miguel21 modification M29	AddCommandRadioF10 CallTankRefuel
-- Miguel21 modification M26	destroys targets if below a certain value
-- Miguel21 modification M11 : Multiplayer
-- Tomsk    modification M09.b	Integration de  Prune Script
-- Miguel21 modification M00b	Integration de conf_mod
-- -------------------------------------------------------------------------------------------------------

				
----- unpack template mission file ----
local minizip = require('minizip')

local zipFile = minizip.unzOpen("Init/base_mission.miz", 'rb')

zipFile:unzLocateFile('mission')
local misStr = zipFile:unzReadAllCurrentFile()
local misStrFunc = loadstring(misStr)()

zipFile:unzLocateFile('options')
local optStr = zipFile:unzReadAllCurrentFile()
local optStrFunc = loadstring(optStr)()

zipFile:unzLocateFile('warehouses')
local warStr = zipFile:unzReadAllCurrentFile()
local warStrFunc = loadstring(warStr)()

zipFile:unzLocateFile('l10n/DEFAULT/dictionary')
local dicStr = zipFile:unzReadAllCurrentFile()
local dicStrFunc = loadstring(dicStr)()

zipFile:unzLocateFile('l10n/DEFAULT/mapResource')
local resStr = zipFile:unzReadAllCurrentFile()
local resStrFunc = loadstring(resStr)()

zipFile:unzClose()


---- add trigger to destory scenery objects -----
mission.trig.flag[1] = true
mission.trig.conditions[1] = "return(true)"
mission.trig.actions[1] = ""
mission.trig.funcStartup[1] = "if mission.trig.conditions[1]() then mission.trig.actions[1]() end"
mission.trigrules[1] = {
	["rules"] = {},
	["eventlist"] = "",
	["actions"] = {},
	["comment"] = "Scenery Destruction",
	["predicate"] = "triggerStart",
}

require("Active/oob_scen")
for scen_name,scen in pairs(oob_scen) do											--iterate through destroyed scenery objects
	if scen.x and scen.z then														--destroyed scenery object has x and z coordinates
		
		local zones_n = #mission.triggers.zones	+ 1									--trigger zone number
		
		--add trigger zone
		mission.triggers.zones[zones_n] = {
			["x"] = scen.x,
			["y"] = scen.z,
			["radius"] = 1,
			["zoneId"] = zones_n,
			["color"] = 
			{
				[1] = 1,
				[2] = 1,
				[3] = 1,
				[4] = 0.15,
			},
			["hidden"] = true,
			["name"] = "SceneryDestroyZone" .. #mission.trigrules[1].actions + 1,
		}

		--add trigger
		mission.trig.actions[1] = mission.trig.actions[1] ..  "a_scenery_destruction_zone(" .. zones_n .. ", 100);"
		
		mission.trigrules[1].actions[#mission.trigrules[1].actions + 1] = {
			["ai_task"] = {
				[1] = "",
				[2] = "",
			},
			["predicate"] = "a_scenery_destruction_zone",
			["destruction_level"] = 100,
			["zone"] = zones_n,
		}
	end
end


----- prepare triggers to run files in mission -----
local trig_n = 1
local function AddFileTrigger(filename)
	trig_n = trig_n + 1
	mapResource["ResKey_Action_" .. trig_n] = filename
	mission.trig.funcStartup[trig_n] = 'if mission.trig.conditions[' .. trig_n .. ']() then mission.trig.actions[' .. trig_n .. ']() end'
	mission.trig.flag[trig_n] = true
	mission.trig.conditions[trig_n] = "return(true)"
	-- mission.trig.actions[trig_n] = 'a_do_script_file(getValueResourceByKey("ResKey_Action_' .. trig_n .. '")); mission.trig.funcStartup[' .. trig_n .. ']=nil;'
	mission.trig.actions[trig_n] = 'a_do_script_file(getValueResourceByKey("ResKey_Action_' .. trig_n .. '"));'		-- Miguel21 modification M11 : Multiplayer
	mission.trigrules[trig_n] = {
		['rules'] = {},
		['eventlist'] = '',
		['comment'] = 'Trigger ' .. trig_n,
		['predicate'] = 'triggerStart',
		['actions'] = {
			[1] = {
				['file'] = 'ResKey_Action_' .. trig_n,
				['predicate'] = 'a_do_script_file',
				['ai_task'] = {
					[1] = '',
					[2] = '',
				},
			},
		},
	}
end

AddFileTrigger("camp_status.lua")
AddFileTrigger("EventsTracker.lua")
AddFileTrigger("AddCommandRadioF10.lua")											-- Miguel21 Modification M29
AddFileTrigger("GCIdata.lua")
AddFileTrigger("GCIscript.lua")
AddFileTrigger("ARM_Defence_Script.lua")
AddFileTrigger("CustomTasksScript.lua")
AddFileTrigger("CarrierIntoWindScript.lua")

----- run scripts to create content of next mission -----
dofile("../../../ScriptsMod."..versionPackageICM.."/UTIL_Functions.lua")

camp.SC_FullPlaneOnDeck = mission_ini.SC_FullPlaneOnDeck								-- miguel21 modification M37.d SuperCarrier
camp.CVN_Vmax = mission_ini.CVN_Vmax													-- miguel21 modification M37.d SuperCarrier
camp.CVN_windDeck = mission_ini.CVN_windDeck											-- miguel21 modification M37.d SuperCarrier

if not camp.path or camp.path == nil then												-- Miguel21 modification M35.d version ScriptsMod
	camp.path = os.getenv('pathSavedGames')												-- Miguel21 modification M35.e version ScriptsMod
	camp.path = string.gsub(camp.path, "\\", "/") 
end

require("Init/db_loadouts")
require("Init/db_airbases")
require("Active/oob_air")
require("Active/oob_ground")
require("Init/conf_mod")															-- Miguel21 modification M00 : need option
require("Init/radios_freq_compatible")												-- miguel21 modification M34 custom FrequenceRadio

if Debug.KillGround.flag then
	for side_name,side in pairs(oob_ground) do														--side table(red/blue)											
		if side_name == Debug.KillGround.sideGround then	
			for country_n,country in pairs(side) do														--country table (number array)
				if country.vehicle then																	--if country has vehicles
					for group_n,group in pairs(country.vehicle.group) do								--groups table (number array)
						for unit_n,unit in pairs(group.units) do										--units table (number array)					
							
							if not unit.dead and math.random(1, 100) <= Debug.KillGround.pourcent then
							
								print("MainNT PasseDestroy "..unit.name)
							
									unit.dead = true														--mark unit as dead in oob_ground
									unit.dead_last = true													--mark unit as died in last mission
									-- unit.CheckDay = camp.day  
							end
						end
					end
				end
				if country.static then																--if country has static objects	
					for group_n,group in pairs(country.static.group) do								--groups table (number array)
						for unit_n,unit in pairs(group.units) do									--units table (number array)
							if not unit.dead and math.random(1, 100) <= Debug.KillGround.pourcent then			--check if unitId matches initiatorMissionID (string, needs to be converted to number)
								
								print("MainNT PasseDestroy static "..unit.name)
								
								if unit.dead ~= true then											--unit is not yet dead (some static objects that are spawned in a destroyed state are logged dead at mission start, these must be excluded here)
									group.dead = true												--mark group as dead in oob_ground (static objects can be set as group.dead and spawned in a destroyed state)
									group.hidden = true												--hide dead static object
									unit.dead = true												--mark unit as dead in oob_ground (this is for the targetlist)
									unit.dead_last = true
								end
							end
						
						end
					end
				end
				if country.ship then																--if country has ships
					for group_n,group in pairs(country.ship.group) do								--groups table (number array)
						for unit_n,unit in pairs(group.units) do									--units table (number array)
							if not unit.dead and math.random(1, 100) <= Debug.KillGround.pourcent then				--check if unitId matches initiatorMissionID (string, needs to be converted to number)
								
								print("MainNT PasseDestroy ship "..unit.name)
								
								unit.dead = true													--mark unit as dead in oob_ground
								unit.dead_last = true												--mark unit as died in last mission
								unit.CheckDay = camp.day                            -- ajoute la date de destruction    Miguel21 modification M19 : Repair SAM   
								
							end
						
						end
					end
				end
			end
		end
	end
end
require("Active/targetlist")
if Debug.KillGround.flag then
	for side_name,side in pairs(targetlist) do											--iterate through targetlist
		if side_name == Debug.KillGround.sideTarget then
			for target_name,target in pairs(side) do										--iterate through targets
					
				if target.elements and target.elements[1].x then							--if the target has subelements and is a scenery object target (element has x coordinate)
					for element_n,element in pairs(target.elements) do						--iterate through target elements
						if not element.dead and math.random(1, 100) <= Debug.KillGround.pourcent then		
							
							print("MainNT PasseDestroy __SCENERY__ "..element.name)
							
							
							if element.dead then											--element was already dead previously
								element.dead_last = false									--mark element as not died in last mission
							else
								element.dead = true	
							end
						end
					end
				end
			end
		end
	end
end
require("Active/camp_triggers")

dofile("../../../ScriptsMod."..versionPackageICM.."/DC_Refpoints.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_MissionScore.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_Time.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_Weather.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_DestroyTarget.lua")			-- miguel21 Mod26
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_NavalEnvironment.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_UpdateTargetlist.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_CheckTriggers.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_UpdateTargetlist.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_UpdateOOBGround.lua")

dofile("../../../ScriptsMod."..versionPackageICM.."/ATO_ThreatEvaluation.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/ATO_RouteGenerator.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/ATO_Generator.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/ATO_PlayerAssign.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/ATO_Timing.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/ATO_FlightPlan.lua")

dofile("../../../ScriptsMod."..versionPackageICM.."/DC_StaticAircraft.lua")
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_Prune.lua")														-- Tomsk modification M09 Integration de  Prune Script
dofile("../../../ScriptsMod."..versionPackageICM.."/DC_Briefing.lua")

dofile("../../../ScriptsMod."..versionPackageICM.."/DC_EndCampaign.lua")

dofile("../../../ScriptsMod."..versionPackageICM.."/UTIL_Debug.lua")

mission.currentKey = 999999															--not clear how this works but is required for multiplyer clients to be available for selection on mission start

----- convert tables back to strings for insertion into content files -----
local misStr = "mission = " .. TableSerialization(mission, 0)
local optStr = "options = " .. TableSerialization(options, 0)
local warStr = "warehouses = " .. TableSerialization(warehouses, 0)
local dicStr = "dictionary = " .. TableSerialization(dictionary, 0)
local resStr = "mapResource = " .. TableSerialization(mapResource, 0)
local gciStr = "GCI = " .. TableSerialization(GCI, 0)
local cmpStr = "camp = " .. TableSerialization(camp, 0)

----- create temporary content files of new mission file -----
local misFile = io.open("misFile.lua", "w")											--mission
misFile:write(misStr)
misFile:close()

local optFile = io.open("optFile.lua", "w")											--options
optFile:write(optStr)
optFile:close()

local warFile = io.open("warFile.lua", "w")											--warehouses
warFile:write(warStr)
warFile:close()

local dicFile = io.open("dicFile.lua", "w")											--dictionary
dicFile:write(dicStr)
dicFile:close()

local resFile = io.open("resFile.lua", "w")											--mapResource
resFile:write(resStr)
resFile:close()

local gciFile = io.open("GCIdata.lua", "w")											--GCI data file (EWR radars, AWACS, interceptors)
gciFile:write(gciStr)
gciFile:close()

local cmpFile = io.open("Active/camp_status.lua", "w")								--campaign status file
cmpFile:write(cmpStr)
cmpFile:close()


----- create new mission file and add content files -----
if FirstMission then																--is true if script is launched from GenerateFirstMission.lua
	miz = minizip.zipCreate("../" .. camp.title .. "_first.miz")					--create the first campaign mission
else																				--is false if script is launched from Debrief_Master.lua
	miz = minizip.zipCreate("../" .. camp.title .. "_ongoing.miz")					--create the ongoing campaign mission
end
miz:zipAddFile("mission", "misFile.lua")
miz:zipAddFile("options", "optFile.lua")
miz:zipAddFile("warehouses", "warFile.lua")
miz:zipAddFile("l10n/DEFAULT/dictionary", "dicFile.lua")
miz:zipAddFile("l10n/DEFAULT/mapResource", "resFile.lua")
miz:zipAddFile("l10n/DEFAULT/EventsTracker.lua", "../../../ScriptsMod."..versionPackageICM.."/Mission Scripts/EventsTracker.lua")
miz:zipAddFile("l10n/DEFAULT/GCIdata.lua", "GCIdata.lua")
miz:zipAddFile("l10n/DEFAULT/GCIscript.lua", "../../../ScriptsMod."..versionPackageICM.."/Mission Scripts/GCIscript.lua")
miz:zipAddFile("l10n/DEFAULT/ARM_Defence_Script.lua", "../../../ScriptsMod."..versionPackageICM.."/Mission Scripts/ARM_Defence_Script.lua")
miz:zipAddFile("l10n/DEFAULT/CustomTasksScript.lua", "../../../ScriptsMod."..versionPackageICM.."/Mission Scripts/CustomTasksScript.lua")
miz:zipAddFile("l10n/DEFAULT/CarrierIntoWindScript.lua", "../../../ScriptsMod."..versionPackageICM.."/Mission Scripts/CarrierIntoWindScript.lua")
miz:zipAddFile("l10n/DEFAULT/AddCommandRadioF10.lua", "../../../ScriptsMod."..versionPackageICM.."/Mission Scripts/AddCommandRadioF10.lua")				-- Miguel21 Modification M29
miz:zipAddFile("l10n/DEFAULT/camp_status.lua", "Active/camp_status.lua")

local BriefingImages = {}
for _i,_filename in ipairs(BriefingImagesB) do	
	findValue = false
	for i,filename in ipairs(BriefingImages) do
		if _filename == filename then findValue = true    break end
	end
	if not findValue then
		table.insert(BriefingImages, _filename)
	end 
end
for _i,_filename in ipairs(BriefingImagesR) do	
	findValue = false
	for i,filename in ipairs(BriefingImages) do
		if _filename == filename then findValue = true  break end
	end
	if not findValue then
		table.insert(BriefingImages, _filename)
	end 
end

for i,filename in ipairs(BriefingImages) do											--briefing images to be added to mission file
	miz:zipAddFile("l10n/DEFAULT/" .. filename, "Images/" .. filename)
end

miz:zipAddFile("l10n/DEFAULT/alarme.wav" , "Sounds/alarme.wav")


miz:zipClose()


----- remove temporary content files -----
os.remove("misFile.lua")
os.remove("optFile.lua")
os.remove("warFile.lua")
os.remove("dicFile.lua")
os.remove("resFile.lua")
os.remove("GCIdata.lua")


----- save updated status files  -----
local air_str = "oob_air = " .. TableSerialization(oob_air, 0)								--make a string
if TypeAlias then
	air_str = air_str .. "TypeAlias = " .. TableSerialization(TypeAlias, 0)
end
local airFile = io.open("Active/oob_air.lua", "w")											--open oob air file
airFile:write(air_str)																		--save new data
airFile:close()

local ground_str = "oob_ground = " .. TableSerialization(oob_ground, 0)						--make a string
local groundFile = io.open("Active/oob_ground.lua", "w")									--open oob ground file
groundFile:write(ground_str)																--save new data
groundFile:close()


local tgt_str = "targetlist = " .. TableSerialization(targetlist, 0)						--make a string
local tgtFile = io.open("Active/targetlist.lua", "w")										--open targetlist file
tgtFile:write(tgt_str)																		--save new data
tgtFile:close()

local trigStr = "camp_triggers = " .. TableSerialization(camp_triggers, 0)
local trigFile = io.open("Active/camp_triggers.lua", "w")
trigFile:write(trigStr)
trigFile:close()