local function add_structure(f)
	if(f) then
		f.shape_table_data = 
		{
			{
				file  	    = f.ShapeName,
				life		= f.Life,
				username    = f.Name,
				desrt       = f.ShapeNameDestr or "self",
			    classname 	= f.classname   or "lLandVehicle",
				positioning = f.positioning or "ADD_HEIGTH" -- {"BYNORMAL", "ONLYHEIGTH", "BY_XZ", "ADD_HEIGTH"}
			}
		}
		if f.ShapeNameDestr then
			f.shape_table_data[#f.shape_table_data + 1] = 
			{
				name  = f.ShapeNameDestr,
				file  = f.ShapeNameDestr,	
			}
		end
		
		f.mapclasskey = "P0091000076";
		f.attribute = {wsType_Static, wsType_Standing}
		add_surface_unit(f)
		GT = nil;
	else
		error("Can't add structure")
	end;
end

local function add_personnel(f)
	if(f) then
		f.shape_table_data = 
		{
			{
				file  	    = f.ShapeName,
				life		= f.Life,
				username    = f.Name,
				desrt       = f.ShapeNameDestr or "self",
			    classname 	= "lHuman",
				positioning = f.positioning or "BYNORMAL"	--available: {"BYNORMAL", "ONLYHEIGTH", "BY_XZ", "ADD_HEIGTH"}
			}
		}
		if f.ShapeNameDestr then
			f.shape_table_data[#f.shape_table_data + 1] = 
			{
				name  = f.ShapeNameDestr,
				file  = f.ShapeNameDestr,	
			}
		end
		
		f.mapclasskey = "P0091000201";
		f.attribute = {wsType_Static, wsType_Standing} 
		
		add_surface_unit(f)
		GT = nil;
	else
		error("Can't add personnel")
	end;
end
---------------- Buildings -----------
add_structure({
Name 		 =  "FCLP Box lights",                -- Landingstrip light
DisplayName  = _("US Navy - FCLP Box lights"),
ShapeName	 =   "cvn_Landebahn",
ShapeNameDestr = "cvn_Landebahn",
Life		 =  1000,
Rate		 =  1,
category     =  'Fortification',
SeaObject    = 	false,
isPutToWater =  false,
})
---------------- Vehicles ------------
add_structure({
Name 		 =  "cvn_a-s32a-31a",                -- Tow Klein
DisplayName  = _("US Navy - MD-3 Tow Tractor empty"),
ShapeName	 =   "cvn_a-s32a-31a",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_a-s32a-31a_towbar",                -- Tow Klein+towbar
DisplayName  = _("US Navy - MD-3 Tow Tractor with Towbar empty"),
ShapeName	 =   "cvn_a-s32a-33a_towbar",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_msu-200nav",                -- Tow Air Tractor
DisplayName  = _("US Navy - MD-3 Air Tractor empty"),
ShapeName	 =   "cvn_msu-200nav",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_a-s32a-31a-fire",                -- Tow Fire
DisplayName  = _("US Navy - MD-3 Fire Tractor empty"),
ShapeName	 =   "cvn_a-s32a-31a-fire",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_gabelstapler",                -- Gabelstapler
DisplayName  = _("US Navy - Forklift empty"),
ShapeName	 =   "cvn_gabelstapler",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'Fortification',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "IFLOLS_Mk14",                -- IFLOLS_Mk14
DisplayName  = _("US Navy - IFLOLS Mk14"),
ShapeName	 =   "IFLOLS_Mk14",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_baggage_truck",                -- Baggage Truck
DisplayName  = _("US Navy - Baggage Truck"),
ShapeName	 =   "cvn_baggage_truck",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'Fortification',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_epu_truck",                -- NAS EPU Truck
DisplayName  = _("US Navy - NAS EPU Truck empty"),
ShapeName	 =   "cvn_epu_truck",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_service-truck",                -- NAS Service Truck
DisplayName  = _("US Navy - NAS Service Truck empty"),
ShapeName	 =   "cvn_service-truck",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_utility_cart",                -- Utility Cart
DisplayName  = _("US Navy - Utility Cart"),
ShapeName	 =   "cvn_utility_cart",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'Fortification',
SeaObject    = 	false,
isPutToWater =  false,
})
---------------- Objects ------------
add_structure({
Name 		 =  "towbar_offen",                -- Towbar open
DisplayName  = _("US Navy - Towbar open"),
ShapeName	 =   "cvn_towbar_offen",
ShapeNameDestr = "cvn_towbar_offen",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "towbar_zu",                -- Towbar closed
DisplayName  = _("US Navy - Towbar closed"),
ShapeName	 =   "cvn_towbar_zu",
ShapeNameDestr = "cvn_towbar_zu",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_holdbackbar",                -- Holdback Bar
DisplayName  = _("US Navy - Holdback Bar"),
ShapeName	 =   "cvn_holdbackbar",
ShapeNameDestr = "cvn_holdbackbar",
Life		 =  10,
Rate		 =  10,
category     =  'Fortification',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "radkeil",                -- Wheel Chock
DisplayName  = _("US Navy - Wheel Chock"),
ShapeName	 =   "cvn_radkeil",
ShapeNameDestr = "cvn_radkeil",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_Feuerloescher",                -- Fire Extinguisher
DisplayName  = _("US Navy - Fire Extinguisher"),
ShapeName	 =   "cvn_fire_extinguisher",
ShapeNameDestr = "cvn_fire_extinguisher",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "gtr18_base_projectile",                -- GTR 18 Smokey Sam by thesystem and SUNTSAG
DisplayName  = _("GTR-18 Smokey Sam - static"),
ShapeName	 =   "gtr18_base_projectile",
ShapeNameDestr = "gtr18_base_projectile",
Life		 =  10,
Rate		 =  10,
category     =  'Fortification',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_dcs-gpu",
DisplayName  = _("NATO - Ground Power Unit (GPU)"),     -- Ground Power Unit by thesystem and Lilkiki
ShapeName	 =   "dcs-gpu",
ShapeNameDestr = "oblomok-4",
Life		 =  1000,
Rate		 =  1,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cvn_KnuckleBuster",
DisplayName  = _("NATO - Ammunition Loading Assembly"), -- KnuckleBuster by mithandra
ShapeName	 =   "KnuckleBuster",
ShapeNameDestr = "oblomok-4",
Life		 =  1000,
Rate		 =  1,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
---------------- Deckcrew by Tomcatz------------
add_personnel({
Name 		 =  "CVN_cain_gang",                -- Chain Gang
DisplayName  = _("US Navy - Crew Chain"),
ShapeName	 =   "cvn_cain_gang",
ShapeNameDestr = "soldier_ge_00_d",
Life		 =  250,
Rate		 =  20,
category     =  'Personnel',
SeaObject    = 	false,
isPutToWater =  false,
})
add_personnel({
Name 		 =  "CVN_lso_s",                -- LSO's
DisplayName  = _("US Navy - Crew LSO"),
ShapeName	 =   "cvn_lso_s",
ShapeNameDestr = "soldier_ge_00_d",
Life		 =  250,
Rate		 =  20,
category     =  'Personnel',
SeaObject    = 	false,
isPutToWater =  false,
})
add_personnel({
Name 		 =  "CVN_cat_crew",                -- Cat Crew
DisplayName  = _("US Navy - Crew Cat"),
ShapeName	 =   "cvn_cat_crew",
ShapeNameDestr = "soldier_ge_00_d",
Life		 =  250,
Rate		 =  20,
category     =  'Personnel',
SeaObject    = 	false,
isPutToWater =  false,
})
add_personnel({
Name 		 =  "CVN_wire_crew",                -- Wire Crew
DisplayName  = _("US Navy - Crew Wire"),
ShapeName	 =   "cvn_wire_crew",
ShapeNameDestr = "soldier_ge_00_d",
Life		 =  250,
Rate		 =  20,
category     =  'Personnel',
SeaObject    = 	false,
isPutToWater =  false,
})
---------------- Static MHU-191 Ammo Trailer by Easy-P ------------
add_structure({
Name 		 =  "cart",                -- MHU-191 Trailer empty
DisplayName  = _("US Navy - MHU-191 Trailer empty"),
ShapeName	 =   "cvn_cart",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu10_1",                -- MHU-191 Trailer 1x GBU10
DisplayName  = _("US Navy - MHU-191 Trailer + 1xGBU10"),
ShapeName	 =   "cvn_cart_gbu10_1",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu10_2",                -- MHU-191 Trailer 2x GBU10
DisplayName  = _("US Navy - MHU-191 Trailer + 2xGBU10"),
ShapeName	 =   "cvn_cart_gbu10_2",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu10_3",                -- MHU-191 Trailer 3x GBU10
DisplayName  = _("US Navy - MHU-191 Trailer + 3xGBU10"),
ShapeName	 =   "cvn_cart_gbu10_3",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu31_1",                -- MHU-191 Trailer 1x GBU31
DisplayName  = _("US Navy - MHU-191 Trailer + 1xGBU31"),
ShapeName	 =   "cvn_cart_gbu31_1",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu31_2",                -- MHU-191 Trailer 2x GBU31
DisplayName  = _("US Navy - MHU-191 Trailer + 2xGBU31"),
ShapeName	 =   "cvn_cart_gbu31_2",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu31_3",                -- MHU-191 Trailer 3x GBU31
DisplayName  = _("US Navy - MHU-191 Trailer + 3xGBU31"),
ShapeName	 =   "cvn_cart_gbu31_3",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu32_1",                -- MHU-191 Trailer 1x GBU32
DisplayName  = _("US Navy - MHU-191 Trailer + 1xGBU32"),
ShapeName	 =   "cvn_cart_gbu32_1",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu32_2",                -- MHU-191 Trailer 2x GBU32
DisplayName  = _("US Navy - MHU-191 Trailer + 2xGBU32"),
ShapeName	 =   "cvn_cart_gbu32_2",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_gbu32_3",                -- MHU-191 Trailer 3x GBU32
DisplayName  = _("US Navy - MHU-191 Trailer + 3xGBU32"),
ShapeName	 =   "cvn_cart_gbu32_3",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_mk83_1",                -- MHU-191 Trailer 1x MK83
DisplayName  = _("US Navy - MHU-191 Trailer + 1xMK83"),
ShapeName	 =   "cvn_cart_mk83_1",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_mk83_2",                -- MHU-191 Trailer 2x MK83
DisplayName  = _("US Navy - MHU-191 Trailer + 2xMK83"),
ShapeName	 =   "cvn_cart_mk83_2",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})
add_structure({
Name 		 =  "cart_mk83_3",                -- MHU-191 Trailer 3x MK83
DisplayName  = _("US Navy - MHU-191 Trailer + 3xMK83"),
ShapeName	 =   "cvn_cart_mk83_3",
ShapeNameDestr = "oblomok-4",
Life		 =  10,
Rate		 =  10,
category     =  'ADEquipment',
SeaObject    = 	false,
isPutToWater =  false,
})