--To create the briefing for the next mission
--Initiated by MAIN_NextMission.lua
------------------------------------------------------------------------------------------------------- 

-- Miguel Fichier Revision M15 M34.e
------------------------------------------------------------------------------------------------------- 
-- correctif add Mig21 Channel 00

-- miguel21 modification M34.e change freq EWR + custom FrequenceRadio
-- Miguel21 modification M33.b 	Custom Briefing (onBoardNum)
-- Miguel21 modification M27 	MovedBullseye
								-- Miguel21 modification M17.c Option F-14B
-- Miguel21 Modification M15.c info catapulte/pont dans briefing
-- Miguel21 modification M11B. : Multiplayer--briefing								
-- Miguel21 M07.h : EWR toujours affiché dans le briefing
-- Miguel21 M06.b : helicoptere playable
-- Miguel21 M05.b : ajout picture Briefing + pictures Target
-- Miguel21 M04.e : ajout d'une troisieme radio
-- Eagle_01 E03.a : Removed Mi-8 and Gazelle special radio code

local target_picture = {
                        "blue",
                        "red",
                        }

----- Mission Title -----
mission.sortie = camp.title .. " - " .. camp.mission


--Order of Battle
do
	local s = "Order of Battle:\\n\\n"																--make lists of the air order of battle for all sides
	
	--air units
	for side_name,side in pairs(oob_air) do															--iterate through sides in oob_air
		if side_name == "blue" then
			s = s .. "Blue Air Units:\\n"															--side header
		else
			s = s .. "Red Air Units:\\n"															--side header
		end
	
		--define list entries
		local entries = {
			[1] = {
				header = "Unit",
				values = {},
			},
			[2] = {
				header = "Type",
				values = {},
			},
			[3] = {
				header = "Base",
				values = {},
			},
			[4] = {
				header = "Lst",
				values = {},
			},
			[5] = {
				header = "Dm",
				values = {},
			},
			[6] = {
				header = "Rdy",
				values = {},
			},
		}
	
		--add list values
		for unit_n,unit in ipairs(side) do															--iterate through units
			if unit.inactive ~= true then															--unit is active
				table.insert(entries[1].values, unit.name)											--unit name
				table.insert(entries[2].values, ReplaceTypeName(unit.type))							--unit type
				table.insert(entries[3].values, unit.base)											--unit base
				table.insert(entries[4].values, unit.roster.lost)									--unit lost aircraft
				table.insert(entries[5].values, unit.roster.damaged)								--unit damaged aircraft
				table.insert(entries[6].values, unit.roster.ready)									--unit ready aircraft
			end
		end
		
		--determine maximum string length for each entry
		for e = 1, #entries do																		--iterate through entries
			entries[e].str_length = string.len(entries[e].header)									--store string length of header for this entry
			for n = 1, #entries[e].values do														--iterate through values of this entry
				local l = string.len(tostring(entries[e].values[n]))								--get string length of value of this entry
				if l > entries[e].str_length then													--if the string length is larger than the previous
					entries[e].str_length = l														--make it the new length (find the largest)
				end
			end
		end
		
		--build the list header
		for e = 1, #entries do																		--iterate through entries
			s = s .. entries[e].header																--add header
			if e < #entries then																	--if this is not the last header, add spaces to the next header	
				local space = entries[e].str_length + 3 - string.len(entries[e].header)				--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
				for m = 1, space * 1.5 do															
					s = s .. " "																	--add 1.5 spaces for every missing letter
				end
			end
		end
		s = s .. "\\n"
	
		--build the list		
		for n = 1, #entries[1].values do															--iterate through number of values (number of units)
			for e = 1, #entries do																	--iterate through entries
				s = s .. entries[e].values[n]														--add value to list
				if e < #entries then																--if this is not the last header, add spaces to the next header	
					local space = entries[e].str_length + 3 - string.len(tostring(entries[e].values[n]))	--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
					for m = 1, space * 1.5 do													
						s = s .. " "																--add 1.5 spaces for every missing letter
					end
				end
			end
			s = s .. "\\n"																			--make a new line after each unit
		end
		
		--add oob description text (reinforcements and repairs)
		if PlayerFlight and camp.player.side == side_name then										--only do it for player side
			if side_name == "blue" then
				if briefing_oob_text_blue ~= "" then
					s = s .. "\\n" .. briefing_oob_text_blue .. "\\n"
				else
					s = s .. "\\n\\n"
				end
			elseif side_name == "red" then
				if briefing_oob_text_red ~= "" then
					s = s .. "\\n" .. briefing_oob_text_red .. "\\n"
				else
					s = s .. "\\n\\n"
				end
			end
		else
			s = s .. "\\n\\n"																		--make a new line after each side
		end
	end
	
	
	--ground targets
	for side_name,side in pairs(targetlist) do														--iterate through sides in targetlist
		if side_name == "blue" then																	--owner of the target is the opposite of targetlist side
			s = s .. "Red Ground Assets:\\n"														--side header
		else
			s = s .. "Blue Ground Assets:\\n"														--side header
		end
		
		local sort_table = {}																		--array to sort the targetlist
		for k,v in pairs(side) do
			table.insert(sort_table, k)																--insert key into sort table
		end
		table.sort(sort_table)																		--sort the table
		for i, v in ipairs(sort_table) do															--iterate through sort table
			if side[v].inactive ~= true then														--target is active
				if side[v].alive then																--target is a ground target
					if side[v].hidden == nil or side[v].hidden == false then						--target is not hidden
						s = s .. "- " .. v .. " (" .. math.ceil(side[v].alive) .. "%)\\n"			--add target name and alive percentage
						if side[v].expand then														--target elements should be displayed expanded
							if side[v].elements then												--target has elements
								local max_strl = 0
								for e = 1, #side[v].elements do										--iterate through elements
									local strl = string.len(side[v].elements[e].name)				--get elements name stringh lenght
									if strl > max_strl then
										max_strl = strl												--find longest string name
									end
								end
								for e = 1, #side[v].elements do										--iterate through elements
									local space = max_strl - string.len(side[v].elements[e].name) + 5
									s = s .. "   - " .. side[v].elements[e].name					--list each element
									for m = 1, space do													
										s = s .. " "												--add one space for every missing letter
									end
									if camp.ShipHealth and camp.ShipHealth[side[v].elements[e].name] then		--ship has a health entry
										if camp.ShipHealth[side[v].elements[e].name] == 0 then					--ship is sunk
											s = s .. "(sunk)"
										elseif camp.ShipHealth[side[v].elements[e].name] < 33 then				--ship has less than 33% health
											s = s .. "(heavy damage)"
										elseif camp.ShipHealth[side[v].elements[e].name] < 66 then				--ship has less than 66% health
											s = s .. "(moderate damage)"
										elseif camp.ShipHealth[side[v].elements[e].name] < 100 then				--ship has less than 100% health
											s = s .. "(light damage)"
										end
									end
									s = s .. "\\n"									
								end
							end
						end
					end
				end
			end
		end
		s = s .. "\\n\\n"																			--make a new line after each side
	end
	
	
	--Assign briefing text to mission file
	if briefing_text_playable ~= "" and PlayerFlight then											--there is briefing text which is only added if the mission is actually playable
		if briefing_text == "" then																	--there was no briefing text for this mission instance yet
			briefing_status = briefing_status .. FormatDate(camp.date.day, camp.date.month, camp.date.year) .. ", " .. FormatTime(camp.time, "hh:mm") .. ":\\n\\n"		--add date and time header
		end
		briefing_status = briefing_status .. briefing_text_playable									--add briefing text 
	end
	mission.descriptionText = briefing_status .. "\\n" .. s
end


-- Miguel21 modification M11B. : Multiplayer
local briefing = { 
				  ["blue"] = "",
					["red"] = "",
				  }

	--	pack.main[1].route[1].eta
	
	-- table.sort(ATO["blue"], function(a,b) return a.main[1].route[1].eta > b.main[1].route[1].eta  end)
	-- table.sort(ATO["red"], function(a,b) return a.main[1].route[1].eta > b.main[1].route[1].eta  end)

-- for sideName,side in pairs(oob_air) do																-- Miguel21 modification M11B. : Multiplayer--briefing			
-- ATO[side][pack_n][role], flight
for sideName, pack in pairs(ATO) do													--iterate through sides in ATO
	for p = 1, #pack do															--iterate through packages in sides
		for role,flight in pairs(pack[p]) do									--iterate through roles in package (main, SEAD, escort)		
			for f = 1, #flight do
				if flight[f].player or flight[f].client2 then
				
					local Tplayer = {}

					if flight[f].player then	
						Tplayer = camp.player
					elseif flight[f].client2 then	
						Tplayer = camp.player2
					end
			
					--Air Tasking Order
					-- if PlayerFlight and Tplayer.side == sideName then											--if the mission has a player flight
					if flight[f].player or flight[f].client2 then
						
						player_target_name = Tplayer.pack[Tplayer.role][Tplayer.flight].target_name																-- tag confirmant que la mission sera créee, evite les doublons d'image
							
						
						local s = "Air Tasking Order:\\n"
						
						--define list entries
						local entries = {
							[1] = {
								header = "Sorties",
								values = {},
							},
							[2] = {
								header = "Mission",
								values = {},
							},
							[3] = {
								header = "TOT",
								values = {},
							},
						}
						
						--sum together packages package sortie numbers
						local ATOList = {}
						for pack_n,pack in pairs(ATO[Tplayer.side]) do											--go through ATO on player side
							
							--package time on target
							local tot = FormatTime(camp.time + pack.main[1].route[1].eta, "hh:mm:ss")				--time on target (use first wapoint if no Target or Station WP is found below)
							for wp_n,wp in pairs(pack.main[1].route) do												--iterate through waypoints of first main flight
								if wp.id == "Target" or wp.id == "Station" then										--if wp is target or station
									tot = FormatTime(camp.time + wp.eta, "hh:mm:ss")								--make this the time on target			
								end
							end
							
							--package sortie number
							local sortie_n = 0																		--number of aircraft (sorties) in package
							for role,flight in pairs(pack) do														--iterate through roles in package
								for n = 1, #flight do																--iterate through flights in role
									sortie_n = sortie_n + flight[n].number											--count number of aircraft
								end
							end
							
							if #ATOList == 0 then																	--ATOList is still empty
								ATOList[#ATOList + 1] = {
									target_name = pack.main[1].target_name,
									sortie_n = sortie_n,
									tot = tot,
								}
							else																					--ATOList has content
								for a = 1, #ATOList do																--go through ATOList to see if there is already a package entered with same target
									if pack.main[1].target_name == ATOList[a].target_name then						--find packages with same target to combine them 
										ATOList[a].sortie_n = ATOList[a].sortie_n + sortie_n
										break
									end
									if a == #ATOList then															--no package with same target was found in ATOList
										ATOList[#ATOList + 1] = {
											target_name = pack.main[1].target_name,
											sortie_n = sortie_n,
											tot = tot,
										}
									end
								end
							end
						end
						
						--add list values
						for pack_n,pack in pairs(ATOList) do														--iterate through packages
							table.insert(entries[1].values, pack.sortie_n)											--number of sorties in package
							table.insert(entries[2].values, pack.target_name)										--package target
							table.insert(entries[3].values, pack.tot)												--package time on target
						end
						
						--determine maximum string length for each entry
						for e = 1, #entries do																		--iterate through entries
							entries[e].str_length = string.len(entries[e].header)									--store string length of header for this entry
							for n = 1, #entries[e].values do														--iterate through values of this entry
								local l = string.len(tostring(entries[e].values[n]))								--get string length of value of this entry
								if l > entries[e].str_length then													--if the string length is larger than the previous
									entries[e].str_length = l														--make it the new length (find the largest)
								end
							end
						end
						
						--build the list header
						for e = 1, #entries do																		--iterate through entries
							s = s .. entries[e].header																--add header
							if e < #entries then																	--if this is not the last header, add spaces to the next header	
								local space = entries[e].str_length + 3 - string.len(entries[e].header)				--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
								for m = 1, space * 1.5 do															
									s = s .. " "																	--add 1.5 spaces for every missing letter
								end
							end
						end
						s = s .. "\\n"

						--build the list		
						for n = 1, #entries[1].values do															--iterate through number of values (number of units)
							for e = 1, #entries do																	--iterate through entries
								s = s .. entries[e].values[n]														--add value to list
								if e < #entries then																--if this is not the last header, add spaces to the next header	
									local space = entries[e].str_length + 3 - string.len(tostring(entries[e].values[n]))	--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
									for m = 1, space * 1.5 do													
										s = s .. " "																--add 1.5 spaces for every missing letter
									end
								end
							end
							s = s .. "\\n"																			--make a new line after each unit
						end
						
						--Assign briefing text to mission file
						-- mission.descriptionText = mission.descriptionText .. s
						
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"
					end


					----- Task Briefing -----


					--Mission overview
					-- if PlayerFlight and Tplayer.side == sideName then															--if the mission has a player flight-- Miguel21 modification M11B. : Multiplayer--briefing
					
					-- if  flight[f].client2 then print("DC B Passe client2") end
					
					if flight[f].player or flight[f].client2 then	
						
						local squad = Tplayer.pack[Tplayer.role][Tplayer.flight].name
						local target_name = Tplayer.pack[Tplayer.role][Tplayer.flight].target_name						--get the target of the player flight
						local player_task = Tplayer.pack[Tplayer.role][Tplayer.flight].task								--get the task of the player flight
						local target = Tplayer.pack[Tplayer.role][Tplayer.flight].target								--get target table
						local time_start = FormatTime(camp.time + Tplayer.waypoints[1].ETA, "hh:mm")							--player spawn time
						local time_launch
						
						local s = "\\n\\n\\n\\n".."\\n--- "..squad.." "..player_task.." "..target_name.." ".." ---\\n"
						
						s = s.."Mission:\\n"																						--add a description of the mission
						
						target_picture[sideName] = Tplayer.pack[Tplayer.role][Tplayer.flight].target.picture						--get the target picture MIGUEL21 Miguel21 M05
					
					-- print("DC B  target.picture "..tostring(Tplayer.pack[Tplayer.role][Tplayer.flight].target.picture))
					
						if Tplayer.waypoints[2] then
							time_launch = FormatTime(camp.time + Tplayer.waypoints[2].ETA , "hh:mm")							--player take off time
						end
						local time_target = FormatTime(camp.time + Tplayer.waypoints[Tplayer.tgt_wp].ETA, "hh:mm")			--player time on target
						
						--CAP
						if player_task == "CAP" then
							local time_station = FormatTime(camp.time + Tplayer.waypoints[Tplayer.tgt_wp + 1].ETA, "hh:mm")			--player time to leave stations (for CAP, AWACS and Refueling)
							s = s .. "You are tasked to perform a Combat Air Patrol " .. target.text .. " from " .. time_target .. " to " .. time_station .. ". Engage all hostile aircraft threatening friendly forces in your CAP area.\\n"
						
						--Intercept
						elseif player_task == "Intercept" then
							
							local airbase = Tplayer.pack[Tplayer.role][Tplayer.flight].base

							if Tplayer.tgt_pack then	 --ATO[Tplayer.tgt_side][Tplayer.tgt_pack]
								
								local tgt_heading = GetHeading(Tplayer.waypoints[1], ATO[Tplayer.tgt_side][Tplayer.tgt_pack].main[1].route[1])
								local tgt_distance = GetDistance(Tplayer.waypoints[1], ATO[Tplayer.tgt_side][Tplayer.tgt_pack].main[1].route[1])
								local tgt_n = 0
								for role, flight in pairs (ATO[Tplayer.tgt_side][Tplayer.tgt_pack]) do
									for n = 1, #flight do
										tgt_n = tgt_n + flight[n].number
									end
								end
								if tgt_n == 1 then
									s = s .. "You are assigned to ground alert intercept duty at " .. airbase .. ". Early warning radar has detected " .. tgt_n .. " target inbound to your sector at " .. math.floor(tgt_heading) .. "°/" .. FormatDistance(tgt_distance) .. ". Launch imediately for interception.\\n"
								else
									s = s .. "You are assigned to ground alert intercept duty at " .. airbase .. ". Early warning radar has detected " .. tgt_n .. " targets inbound to your sector at " .. math.floor(tgt_heading) .. "°/" .. FormatDistance(tgt_distance) .. ". Launch imediately for interception.\\n"
								end
						else
								s = s .. "You are assigned to ground alert intercept duty at " .. airbase .. " Wait for the GCI to scramble you..."
						
						end
						--Fighter Sweep
						elseif player_task == "Fighter Sweep" then
							s = s .. "You are tasked to perform a Fighter Sweep " .. target.text .. ". Your Time On Target is " .. time_target .. ".\\n"
						
						--Airbase Strike
						elseif player_task == "Strike" and target.class == "airbase" then
							s = s .. "You are tasked to strike " .. target.name .. " which hosts the " .. target.unit.name .. " equipped with " .. ReplaceTypeName(target.unit.type) .. ". Attack any parked aircraft on the airbase. Your Time On Target is " .. time_target .. "."
							if target.LaserCode then
								s = s .. " Target designation laser code " .. target.LaserCode .. "."
							end
							s = s .. "\\n"
						
						--Strike
						elseif player_task == "Strike" then
							s = s .. "You are tasked to strike " .. target_name .. " with a Time On Target of " .. time_target .. "."
							if target.LaserCode then
								s = s .. " Target designation laser code " .. target.LaserCode .. "."
							end
							s = s .. "\\n"
							
						--Anti-ship Strike
						elseif player_task == "Anti-ship Strike" then
							s = s .. "You are tasked to strike " .. target_name .. " with a Time On Target of " .. time_target .. "."
							if target.LaserCode then
								s = s .. " Target designation laser code " .. target.LaserCode .. "."
							end
							s = s .. "\\n"
							
						--Escort
						elseif player_task == "Escort" then
							if target.class == "airbase" then
								s = s .. "Escort a strike mission against " .. target.name .. ". Engage all hostile aircraft posing a threat to the strike package. "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Strike" or target.task == "Anti-ship Strike" then 
								s = s .. "Escort a strike mission against the " .. target_name .. ". Engage all hostile aircraft posing a threat to the strike package. "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Reconnaissance" then
								s = s .. "Escort a recon mission " .. target.text .. ". Engage all hostile aircraft posing a threat to the recon element. "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							end
							s = s .. "\\n"
						
						--SEAD
						elseif player_task == "SEAD" then
							if target.class == "airbase" then
								s = s .. "Provide SEAD escort for a strike mission against " .. target.name .. ". Engage all hostile air defense systems posing a threat to the strike package. "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Strike" or target.task == "Anti-ship Strike" then 
								s = s .. "Provide SEAD escort for a strike mission against the " .. target_name .. ". Engage all hostile air defense systems posing a threat to the strike package. "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Reconnaissance" then
								s = s .. "Provide SEAD escort for a recon mission " .. target.text .. ". Engage all hostile air defense systems posing a threat to the recon element. "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							end
							s = s .. "\\n"
						
						--Escort Jammer
						elseif player_task == "Escort Jammer" then
							if target.class == "airbase" then
								s = s .. "Provide jammer escort for a strike mission against " .. target.name .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Strike" or target.task == "Anti-ship Strike" then 
								s = s .. "Provide jammer escort for a strike mission against the " .. target_name .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Reconnaissance" then
								s = s .. "Provide jammer escort for a recon mission " .. target.text .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							end
							s = s .. "\\n"
							
						--Flare Illumination
						elseif player_task == "Flare Illumination" then
							if target.class == "airbase" then
								s = s .. "Provide battlefield flare illumination for a strike mission against " .. target.name .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Strike" or target.task == "Anti-ship Strike" then 
								s = s .. "Provide battlefield flare illumination for a strike mission against the " .. target_name .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Reconnaissance" then
								s = s .. "Provide battlefield flare illumination for a recon mission " .. target.text .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							end
							s = s .. "\\n"
							
						--Laser Illumination
						elseif player_task == "Laser Illumination" then
							if target.class == "airbase" then
								s = s .. "Provide target laser designation for a strike mission against " .. target.name .. ". "
								s = s .. "Set your laser designator to code " .. target.LaserCode .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Strike" or target.task == "Anti-ship Strike" then 
								s = s .. "Provide target laser designation for a strike mission against the " .. target_name .. ". "
								s = s .. "Set your laser designator to code " .. target.LaserCode .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							elseif target.task == "Reconnaissance" then
								s = s .. "Provide target laser designation for a recon mission " .. target.text .. ". "
								s = s .. "Set your laser designator to code " .. target.LaserCode .. ". "
								--s = s .. "Man your aircraft at " .. time_start .. " and prepare to launch at " .. time_launch .. ". Your Time on Target is " .. time_target .. ". Good Luck."
							end
							s = s .. "\\n"
						
						--Reconnaissance
						elseif player_task == "Reconnaissance" then
							s = s .. "You are tasked to perform reconnaissance " .. target.text .. ". Your Time On Target is " .. time_target .. ".\\n"
						
						--AWACAS
						elseif player_task == "AWACS" then
							local time_station = FormatTime(camp.time + Tplayer.waypoints[Tplayer.tgt_wp + 1].ETA, "hh:mm")		--player time to leave stations (for CAP, AWACS and Refueling)
							s = s .. "You are tasked to perform a AWACS patrol " .. target.text .. " from " .. time_target .. " to " .. time_station .. ".\\n"
							
						--Refueling
						elseif player_task == "Refueling" then
							local time_station = FormatTime(camp.time + Tplayer.waypoints[Tplayer.tgt_wp + 1].ETA, "hh:mm")		--player time to leave stations (for CAP, AWACS and Refueling)
							s = s .. "You are tasked to perform tanker support " .. target.text .. " from " .. time_target .. " to " .. time_station .. ". Provide fuel to friendly aircraft in your patrol area.\\n"
						
						--Transport
						elseif player_task == "Transport" then
							s = s .. "Fly a transport mission from " .. target.base .. " to " .. target.destination .. ".\\n"
							
						--Nothing/Ferry
						elseif player_task == "Nothing" then
							s = s .. "Ferry flight from " .. target.base .. " to " .. target.destination .. ".\\n"
							
						end
						
						if targetlist[Tplayer.side][target_name].elements then									--if the target is a scenery, vehicle or ship target
							s = s .. "\\nTarget:\\n" .. target_name .. " (" .. math.ceil(targetlist[Tplayer.side][target_name].alive) .. "%)\\n"		--Target name and percentage of alive sub-elements 
							for e = 1, #targetlist[Tplayer.side][target_name].elements do						--list all target elements
								local ename = targetlist[Tplayer.side][target_name].elements[e].name			--element name
								local i = string.find(ename, "#")													--position of # in string
								if i then
									ename = string.sub(ename, 0, i - 1) 											--only display part of element name before #
								end
								s = s .. "- " .. ename
								if targetlist[Tplayer.side][target_name].elements[e].dead == true then			--if the target element is destroyed
									s = s .. " (destroyed)\\n"														--mark as destroyed and make new line
								else
									s = s .. "\\n"																	--make new line
								end
							end
						end
						-- Miguel21 modification M11B. : Multiplayer--briefing pour chaque camp 16 X briefing[sideName]
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"									--add mission overview string to briefing string
					end


					--Package overview
					-- if PlayerFlight and Tplayer.side == sideName then																			--if the mission has a player flight
					if flight[f].player or flight[f].client2 then
						local s = "Package:\\n"																		--make a list of the details of all flights in the player package
						
						local entries = {																			--list entries that are making up the package overview
							[1] = {
								lookup = "task",																	--lookup in the ATO flight table
								header = "Task",																	--name which should be displayer in the list header
								str_length = 4,																		--string length of largest entry of this type (default the string length of the header)
							},
							[2] = {
								lookup = "number",
								header = "Num",
								str_length = 3,
							},
							[3] = {
								lookup = "type",
								header = "Type",
								str_length = 4,
							},
							[4] = {
								lookup = "base",
								header = "Base",
								str_length = 4,
							},
							[5] = {
								lookup = "callsign",
								header = "Callsign",
								str_length = 8,
							},
							[6] = {
								lookup = "player",
								header = "",
								str_length = 0,
							},
						}

						--collect the maximum string length of each entry in the list
						for role_name,role in pairs(Tplayer.pack) do											--iterate through roles in the player package
							for flight_n,flight in pairs(role) do													--iterate through the flights in all roles
								for e = 1, #entries do																--iterate through all entries
									local value = ReplaceTypeName(flight[entries[e].lookup])
									local l = string.len(tostring(value))											--get the string length of the current entry for this flight
									if l > entries[e].str_length then												--if the string length is larger than the previous
										entries[e].str_length = l													--make it the new length (find the largest)
									end
								end
							end
						end
						
						--build the list header
						for e = 1, #entries do																		--iterate through all entries
							s = s .. entries[e].header																--add entry of this flight to list
							if e ~= #entries then																	--if this is not the last entry of the flight, add spaces to the next entry	
								local space = entries[e].str_length + 3 - string.len(tostring(entries[e].header))	--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
								for n = 1, space * 1.5 do															
									s = s .. " "																	--add 1.5 spaces for every missing letter
								end
							end
						end
						s = s .. "\\n"
						
						--build the overview list with the entries of all flights
						for role_name,role in pairs(Tplayer.pack) do											--iterate through roles in the player package	
							for flight_n,_flight in pairs(role) do													--iterate through flights in all roles
								for e = 1, #entries do																--iterate through all entries
									if type(_flight[entries[e].lookup]) == "string" or type(_flight[entries[e].lookup]) == "number" then	--entry is a string or number
										local value = ReplaceTypeName(_flight[entries[e].lookup])
										s = s .. value																--add entry of this flight to list
										if e ~= #entries then																			--if this is not the last entry of the flight, add spaces to the next entry	
											local space = entries[e].str_length + 3 - string.len(tostring(value))	--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
											for n = 1, space * 1.5 do													
												s = s .. " "														--add 1.5 spaces for every missing letter
											end
										end
									elseif _flight[entries[e].lookup] then											--entry is true (player marking)
										local client = ""
										if flight[f].player then client = "player" end
										if flight[f].client2 then client = "client" end
										s = s .. "("..client..")"															--add player flight marking
									end
								end
								s = s .. "\\n"																		--make a new line after each flight
							end
						end
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"														--add package overview string to briefing string
					end


					--Flight overview
					-- Miguel21 modification M33 	Custom Briefing (onBoardNum)
					if flight[f].player or flight[f].client2 then
						local s = "Flight:\\n"																		--make a list of the details of all flights in the player package
							s = s.."CallSign    Designated aircraft number \\n"	
						
						for role_name,role in pairs(Tplayer.pack) do												--iterate through roles in the player package	
							for flight_n,_flight in pairs(role) do													--iterate through flights in all roles
								if _flight.units	 then
									for u=1 , #_flight.units do
										if type(_flight.units[u].callsign) == "table" then
											s = s.. tostring(_flight.units[u].callsign.name).."       "..tostring(_flight.units[u].onboard_num).. "\\n"
										else
											s = s.. tostring(_flight.units[u].callsign) .."       "..tostring(_flight.units[u].onboard_num).. "\\n"
										end
									end
								end
							end
						end
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"
					end



					-- Miguel21 modification M27 	MovedBullseye
					if brief[sideName] then
						local s = "Bullseye:\\n"
						s = s.." bullseye Name " .. brief[sideName].bullseye.name
						if brief[sideName]["bullseye"]["gps"] then
							s = s.." " .. brief[sideName]["bullseye"]["gps"].." \\n"
						end
						s = s.." \\n"
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"
					end

					--Navigation overview
					-- if PlayerFlight and Tplayer.side == sideName then																			--if the mission has a player flight
					if flight[f].player or flight[f].client2 then	
						local s = "Flightplan:\\n"																	--make a list with details of the player waypoints
						
						local entries = {																			--list entries that are making up the navigaion overview
							[1] = {
								lookup = "number",																	--lookup in the player.waypoints table
								header = "WP",																		--name which should be displayer in the list header
								str_length = 2,																		--string length of largest entry of this type (default the string length of the header)
							},
							[2] = {
								lookup = "briefing_name",
								header = "Descr",
								str_length = 5,
							},
							[3] = {
								lookup = "alt",
								header = "Altitute",
								str_length = 8,
							},
							[4] = {
								lookup = "speed",
								header = "Speed",
								str_length = 5,
							},
							[5] = {
								lookup = "ETA",
								header = "ETA",
								str_length = 3,
							},
						}
						
						--collect the maximum string length of each entry in the list	
						for w = 1, #Tplayer.waypoints do														--iterate through the waypoints
							for e = 1, #entries do																	--iterate through all entries
								local entry																			--lookup of entry e of WP w
								if entries[e].lookup == "number" then
									entry = w - 1																	--waypoint number, starts with 0
								elseif entries[e].lookup == "ETA" then
									entry = FormatTime(camp.time + Tplayer.waypoints[w][entries[e].lookup], "hh:mm:ss")	--format the time in the hh:mm:ss format
								elseif entries[e].lookup == "alt" then
									entry = FormatAlt(Tplayer.waypoints[w][entries[e].lookup])					--format altitude in meters or feet
								elseif entries[e].lookup == "speed" then
									entry = FormatSpeed(Tplayer.waypoints[w][entries[e].lookup])				--format speed in kph or kts
								else
									entry = Tplayer.waypoints[w][entries[e].lookup]								--no special formating
								end
								local l = string.len(tostring(entry))												--get the string length
								if l > entries[e].str_length then													--if the string length is larger than the previous
									entries[e].str_length = l														--make it the new length (find the largest)
								end
							end
						end
						
						--build the list header
						for e = 1, #entries do																		--iterate through all entries
							s = s .. entries[e].header																--add entry of this waypoint to list
							if e ~= #entries then																	--if this is not the last entry of the waypoints, add spaces to the next entry	
								local space = entries[e].str_length + 3 - string.len(tostring(entries[e].header))	--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
								for n = 1, space * 1.5 do															
									s = s .. " "																	--add 1.5 spaces for every missing letter
								end
							end
						end
						s = s .. "\\n"
						
						--build the overview list with the entries of all waypoints
						local WP_num = 0																			--waypoint number, starts with 0
						for w = 1, #Tplayer.waypoints do														--iterate through all waypoints
							if Tplayer.waypoints[w].briefing_name ~= "Taxi" then								--do not list taxi waypoint in overview
								for e = 1, #entries do																--iterate through all entries
									local entry
									if entries[e].lookup == "number" then
										entry = WP_num
										WP_num = WP_num + 1
									elseif entries[e].lookup == "ETA" then
										entry = FormatTime(camp.time + Tplayer.waypoints[w][entries[e].lookup], "hh:mm:ss")	--format the time in the hh:mm:ss format
									elseif entries[e].lookup == "alt" then
										entry = FormatAlt(Tplayer.waypoints[w][entries[e].lookup])				--format altitude in meters or feet
									elseif entries[e].lookup == "speed" then
										entry = FormatSpeed(Tplayer.waypoints[w][entries[e].lookup])			--format speed in kph or kts
									else
										entry = Tplayer.waypoints[w][entries[e].lookup]							--no special formating
									end
									s = s .. entry
									if e ~= #entries then															--if this is not the last entry of the waypoint, add spaces to the next entry	
										local space = entries[e].str_length + 3 - string.len(tostring(entry))		--calculate number of spaces that need to be added for alignement (string length of largest entry of same type + 3 - length of current entry = number of spaces)
										for n = 1, space * 1.5 do														
											s = s .. " "															--add 1.5 spaces for every missing letter
										end
									end
								end
								s = s .. "\\n"																		--make a new line after each waypoint
							end
						end
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"														--add navigation overview string to briefing string
					end


					--Radio navigation
					-- if PlayerFlight and Tplayer.side == sideName then
					if flight[f].player or flight[f].client2 then	
						local s = "Radio Navigation:\\n"
						
						--homebase TACAN
						if db_airbases[Tplayer.pack[Tplayer.role][Tplayer.flight].base].tacan then
							s = s .. Tplayer.pack[Tplayer.role][Tplayer.flight].base .. " TACAN: " .. db_airbases[Tplayer.pack[Tplayer.role][Tplayer.flight].base].tacan .. "\\n"
						end
						
						--carrier ICLS
						if db_airbases[Tplayer.pack[Tplayer.role][Tplayer.flight].base].icls then
							s = s .. Tplayer.pack[Tplayer.role][Tplayer.flight].base .. " ICLS: Channel " .. db_airbases[Tplayer.pack[Tplayer.role][Tplayer.flight].base].icls .. "\\n"
						end
						
						--tanker TACAN
						for pack_n,pack in pairs(ATO[Tplayer.side]) do																		--iterate through packages in player side
							for role_name,role in pairs(pack) do																				--iterate through roles in package
								if role[1] and role[1].task == "Refueling" then																	--if first flight is tanker
									if role[1].tacan then																						--tanker has a tacan channel
										s = s .. "Tanker " .. role[1].callsign .. ", TACAN " .. role[1].tacan .. "Y / TKR\\n"					--add TACAN informaion
									end
								end
							end
						end
						
						briefing[sideName] = briefing[sideName] .. s ..  "\\n\\n"
					end


					--Communication
					-- if PlayerFlight and Tplayer.side == sideName then													--if the mission has a player flight
					if flight[f].player or flight[f].client2 then	
						local s = "Communication:\\n"																		--overview of relevant comms frequencies
						local MC = 0
						if  flight[f].type == "MiG-21Bis" then			-- add Mig21 Channel 00
							MC = -1		-- MC ModChannel
						end
						
						for u = 1, #Tplayer.group["units"] do
							Tplayer.group["units"][u]["Radio"] = {}															--create the radio channels table for the player group
							for n = 1, #camp.radio[sideName] do																		--do it for all the radios
								Tplayer.group["units"][u]["Radio"][n] = {
									["channels"] = {},
								}
							end
						end
						
						local AWACS_freq = {}																				--table to store AWACS frequencies
						local tanker_freq = {}																				--table to store tanker frequencies
						local EWR_freq = {}																					--table to store EWR frequencies
						local CAP_freq = {}
						local All_freq = {}
						
						for pack_n,pack in pairs(ATO[Tplayer.side]) do														--iterate through packages in player side
							for role_name,role in pairs(pack) do															--iterate through roles in package													--iterate through the flights in role
								if role[1] and role[1].task == "AWACS" then													--if first flight is AWACS
									AWACS_freq[role[1].callsign] = role[1].frequency										--store callsign and frequency
								elseif role[1] and role[1].task == "Refueling" then											--if first flight is tanker
									tanker_freq[role[1].callsign] = role[1].frequency										--store callsign and frequency
								elseif role[1] and role[1].task == "CAP" then											--if first flight is tanker
									CAP_freq[role[1].callsign] = role[1].frequency										--store callsign and frequency
								elseif role[1]  and  string.find(role[1].task,"Strike") then		--and  string.find(role[1].task,"Strike")
						
									if not All_freq[role[1].callsign] then All_freq[role[1].callsign] = {} end
									
									if not All_freq[role[1].callsign].freq then All_freq[role[1].callsign].freq = role[1].frequency end
									if not All_freq[role[1].callsign].task then All_freq[role[1].callsign].task = role[1].task end

								end
							end
						end
						
						for ewr_n,ewr in pairs(ewr[Tplayer.side]) do														--iterate through EWR on player side
							if ewr.frequency and ewr.callsign then															--if EWR has a freqency and callsign
								-- if tonumber(ewr.frequency) ~= tonumber(Tplayer.EWR_freq) then							--do not store EWR if it is the one that is controlling the player in intercept (it will be put on package channel 1)
									--   Miguel21 modification EWR M07.g
									if not EWR_freq[ewr.callsign] then
										EWR_freq[ewr.callsign] = {}
									end
									EWR_freq[ewr.callsign]["freq"] = ewr.frequency											--store callsign and frequency
									EWR_freq[ewr.callsign]["callsign"] = ewr.callsign	
								-- end
							end
						end
						
						
						-- frequency[flight[f].type].radio[1].nbCanal
						
						--reprend sous une forme plus simple les butées des radios
						local _radio = {}
						
						if not frequency[flight[f].type] then
							_radio[1] = {
								min = 225,
								max = 399,
								nbCanal = 0,
							}
						else
							for i=1, #frequency[flight[f].type].radio do
								_radio[i] = frequency[flight[f].type].radio[i]
							end
						end
						local nC = 1																								-- permet de simplifier les copier/coller
						--build list
						local s = "Communication:\\n"	
						for u = 1, #Tplayer.group["units"] do
							s = "Communication:\\n"																					-- reinitialise le txt pour chaque unite, sinon il y a doublon
							
							-- Tplayer.group.frequency freq
							-- miguel21 modification M34.c  custom FrequenceRadio
							nC = 1	--radioN
							if (Tplayer.group.frequency > _radio[nC].min and Tplayer.group.frequency < _radio[nC].max)	 then
								if Tplayer.EWR_freq and Tplayer.EWR_call then														--if the player is on intercept
									if camp.radio[sideName][2] then																			--player has a second radio
										s = s .. "Package: " .. Tplayer.group.frequency .. " MHz,   "								--package frequency
									else																							--player has only one radio
										s = s .. "GCI: " .. Tplayer.group.frequency .. " MHz, Callsign " .. Tplayer.EWR_call .. ",   "	--GCI frequency
									end
								else	
									s = s .. "Package: " .. Tplayer.group.frequency .. " MHz,   "									--package frequency
								end
								
								table.insert(Tplayer.group["units"][u]["Radio"][1]["channels"], tonumber(Tplayer.group.frequency))	--insert frequency to radio channel table
								
								
								if camp.radio[sideName][2]  then																				--player has a second radio
									s = s .. "Radio 1 / Channel " .. #Tplayer.group["units"][u]["Radio"][nC]["channels"] .. "\\n"	--add channel number to briefing
								else																								--player has only one radio
									s = s .. "Channel " .. #Tplayer.group["units"][u]["Radio"][nC]["channels"] + MC .. "\\n"			--add channel number to briefing
								end
							end
							
							local freqATC = tonumber(db_airbases[Tplayer.pack[Tplayer.role][Tplayer.flight].base].ATC_frequency)						
							
							
							s = s .. Tplayer.pack[Tplayer.role][Tplayer.flight].base .. ": " .. freqATC .. " MHz,   "				--ATC frequency
							nC = 2	--radioN
							if camp.radio[sideName][nC] and (freqATC > _radio[nC].min and freqATC < _radio[nC].max) then																				--player has a second radio
								table.insert(Tplayer.group["units"][u]["Radio"][nC]["channels"], freqATC)					--insert frequency to radio 2 channel table
								s = s .. "Radio 2 / Channel " .. #Tplayer.group["units"][u]["Radio"][nC]["channels"] 				--add channel number to briefing
								nC = 3	--radioN
								if camp.radio[sideName][nC] and (freqATC > _radio[nC].min and freqATC < _radio[nC].max) then																			-- Miguel21 M04.c : ajout d'une troisieme radio
									table.insert(Tplayer.group["units"][u]["Radio"][nC]["channels"], freqATC)				--insert frequency to radio 3 channel table
									s = s .. " & Radio 3 / Channel " .. #Tplayer.group["units"][u]["Radio"][nC]["channels"]			--add channel number to briefing
								end
								s = s .. "\\n"
							elseif  (freqATC > _radio[1].min and freqATC < _radio[1].max) then																								--player has only one radio	
								table.insert(Tplayer.group["units"][u]["Radio"][1]["channels"], freqATC)					--insert frequency to radio 1 channel table
								s = s .. "Channel " .. #Tplayer.group["units"][u]["Radio"][1]["channels"] + MC .. "\\n"			--add channel number to briefing
							end
							
							--AWACS_freq
							for call,freq in pairs(AWACS_freq) do
								s = s .. "AWACS: " .. freq .. " MHz, " .. call .. ",   "										--AWACS frequency
								
								local freqAWACS = tonumber(freq)
					
								nC = 2	--radioN
								if camp.radio[sideName][2] and (freqAWACS > _radio[nC].min and freqAWACS < _radio[nC].max) then																			--player has a second radio
									table.insert(Tplayer.group["units"][u]["Radio"][2]["channels"], freqAWACS)			--insert freqAWACSuency to radio 2 channel table
									s = s .. "Radio 2 / Channel " .. #Tplayer.group["units"][u]["Radio"][2]["channels"]			--add channel number to briefing
									nC = 3	--radioN
									if camp.radio[sideName][3] and (freqAWACS > _radio[nC].min and freqAWACS < _radio[nC].max) then
										table.insert(Tplayer.group["units"][u]["Radio"][3]["channels"], freqAWACS)		--insert frequency to radio 3 channel table
										s = s .. " & Radio 3 / Channel " .. #Tplayer.group["units"][u]["Radio"][3]["channels"]	--add channel number to briefing
									end
									s = s .. "\\n"
								elseif  (freqAWACS > _radio[1].min and freqAWACS < _radio[1].max)	 then																						--player has only one radio
									table.insert(Tplayer.group["units"][u]["Radio"][1]["channels"], freqAWACS)			--insert frequency to radio 1 channel table
									s = s .. "Channel " .. #Tplayer.group["units"][u]["Radio"][1]["channels"]  + MC.. "\\n"		--add channel number to briefing
								end
							end
						
							
							for call,freq in pairs(EWR_freq) do
								s = s .. "EWR: " ..  " " .. freq.freq .. " MHz, " .. call .. ",   "								--EWR frequency  -- Miguel21 modification EWR M07.g --freq.callsign ..
								nC = 2	--radioN
								
								local freqEWR = tonumber(freq.freq)
								if camp.radio[sideName][2] and (freqEWR > _radio[nC].min and freqEWR < _radio[nC].max) and #Tplayer.group["units"][u]["Radio"][nC]["channels"] < _radio[nC].nbCanal then																			--player has a second radio -- Miguel21 modification EWR M07.g
									table.insert(Tplayer.group["units"][u]["Radio"][2]["channels"], freqEWR)		--insert frequency to radio 2 channel table -- Miguel21 modification EWR M07.g
									s = s .. "Radio 2 / Channel " .. #Tplayer.group["units"][u]["Radio"][2]["channels"] 		--add channel number to briefing
									nC = 3	--radioN
									if camp.radio[sideName][3] and (freqEWR > _radio[nC].min and freqEWR < _radio[nC].max) and #Tplayer.group["units"][u]["Radio"][nC]["channels"] < _radio[nC].nbCanal  then
										table.insert(Tplayer.group["units"][u]["Radio"][3]["channels"], freqEWR)	--insert frequency to radio 3 channel table -- Miguel21 M04.c : ajout d'une troisieme radio
										s = s .. " & Radio 3 / Channel " .. #Tplayer.group["units"][u]["Radio"][3]["channels"] 	--add channel number to briefing
									end
									s = s .. "\\n"
								elseif  (freqEWR > _radio[1].min and freqEWR < _radio[1].max) and #Tplayer.group["units"][u]["Radio"][1]["channels"] < _radio[1].nbCanal  then																							--player has only one radio
									table.insert(Tplayer.group["units"][u]["Radio"][1]["channels"], freqEWR)		--insert frequency to radio 1 channel table
									s = s .. "Channel " .. #Tplayer.group["units"][u]["Radio"][1]["channels"]  + MC.. "\\n"		--add channel number to briefing
								end
							end
							
							for call,freq in pairs(tanker_freq) do
								s = s .. "Tanker: " .. freq .. " MHz, " .. call .. ",   "										--Tanker frequency
								if camp.radio[sideName][2] then																			--player has a second radio
									table.insert(Tplayer.group["units"][u]["Radio"][2]["channels"], tonumber(freq))			--insert frequency to radio 2 channel table
									s = s .. "Radio 2 / Channel " .. #Tplayer.group["units"][u]["Radio"][2]["channels"] 		--add channel number to briefing[sideName]
									
									if camp.radio[sideName][3] then
										table.insert(Tplayer.group["units"][u]["Radio"][3]["channels"], tonumber(freq))		--insert frequency to radio 3 channel table
										s = s .. " & Radio 3 / Channel " .. #Tplayer.group["units"][u]["Radio"][3]["channels"] 	--add channel number to briefing[sideName]
									end
									
									s = s .. "\\n"
								
								else																							--player has only one radio

									table.insert(Tplayer.group["units"][u]["Radio"][1]["channels"], tonumber(freq))			--insert frequency to radio 1 channel table
									
									s = s .. "Channel " .. #Tplayer.group["units"][u]["Radio"][1]["channels"] + MC .. "\\n"		--add channel number to briefing
								end
							end
						
							
							for call,freq in pairs(CAP_freq) do
								s = s .. "CAP: " .. freq .. " MHz, " .. call .. ",   "																						--CAP_freq frequency
								
								local freqCAP = tonumber(freq)	

								if  #Tplayer.group["units"][u]["Radio"][1]["channels"] < _radio[1].nbCanal and (freqCAP > _radio[1].min and freqCAP < _radio[1].max) then									--CAP on  radio 1 -- check nb max de canaux
									table.insert(Tplayer.group["units"][u]["Radio"][1]["channels"], freqCAP)															--insert frequency to radio 1 channel table
									s = s .. "Radio 1 / Channel " .. #Tplayer.group["units"][u]["Radio"][1]["channels"]	+ MC												--add channel number to briefing
									
									if camp.radio[sideName][3] and #Tplayer.group["units"][u]["Radio"][3]["channels"] < _radio[3].nbCanal and (freqCAP > _radio[3].min and freqCAP < _radio[3].max) then
										table.insert(Tplayer.group["units"][u]["Radio"][3]["channels"], freqCAP)														--insert frequency to radio 3 channel table
										s = s .. " & Radio 3 / Channel " .. #Tplayer.group["units"][u]["Radio"][3]["channels"]												--add channel number to briefing
									end
									s = s .. "\\n"
		
								elseif camp.radio[sideName][2] 	and #Tplayer.group["units"][u]["Radio"][2]["channels"] < _radio[2].nbCanal and (freqCAP > _radio[2].min and freqCAP < _radio[2].max) then																						--player has only one radio
									table.insert(Tplayer.group["units"][u]["Radio"][2]["channels"], freqCAP)															--insert frequency to radio 1 channel table
									s = s .. "Radio 2 / Channel " .. #Tplayer.group["units"][u]["Radio"][2]["channels"] ..  "\\n"												--add channel number to briefing
								end
							end
							
							s = s .."\\n\\n"
							for call,freq in pairs(All_freq) do						
								s = s ..freq.task..": " .. freq.freq .. " MHz, " .. call .. ",   "																			--All frequency
								local freqALL = tonumber(freq.freq)
								if camp.radio[sideName][2] and #Tplayer.group["units"][u]["Radio"][2]["channels"] < _radio[2].nbCanal and (freqALL > _radio[2].min and freqALL < _radio[2].max) then				--player has a second radio
									table.insert(Tplayer.group["units"][u]["Radio"][2]["channels"], freqALL)													--insert frequency to radio 2 channel table
									s = s .. "Radio 2 / Channel " .. #Tplayer.group["units"][u]["Radio"][2]["channels"]														--add channel number to briefing
									
									if camp.radio[sideName][3] and (freqALL > _radio[3].min and freqALL < _radio[3].max) then
										table.insert(Tplayer.group["units"][u]["Radio"][3]["channels"], freqALL)												--insert frequency to radio 3 channel table
										s = s .. " & Radio 3 / Channel " .. #Tplayer.group["units"][u]["Radio"][3]["channels"]												--add channel number to briefing
									end
									s = s .. "\\n"
								elseif #Tplayer.group["units"][u]["Radio"][1]["channels"] < _radio[1].nbCanal and (freqALL > _radio[1].min and freqALL < _radio[1].max) then																																		--player has only one radio
									table.insert(Tplayer.group["units"][u]["Radio"][1]["channels"], freqALL)													--insert frequency to radio 1 channel table
									s = s .. "Radio 1 / Channel " .. #Tplayer.group["units"][u]["Radio"][1]["channels"]  + MC.. "\\n"													--add channel number to briefing
								end
							end
							
							
						
						end						
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"
					end

					-- Miguel21 Modification M15 info catapulte/pont dans briefing	
					local tabNam = {}	
					s = ""
					if placePA then
						for side , pPA in pairs(placePA) do
							if sideName == side then					--if camp.player.side == side then
								for base , Tmn in pairs(pPA) do
								s = s..tostring(base).." Takeoff time on the platform at ...\\n"
									for sec, name in pairsByKeys(Tmn) do
										if tabNam[name] ~= true then
											catTime = camp.time + sec 
											s = s.." "..FormatTime(catTime, "hh:mm").. " - "..tostring(name).."\\n"
											tabNam[name] = true
										end
									end
								end
							end
						end

					briefing[sideName] = briefing[sideName] .. s .. "\\n\\n"
					end

					--Meteo
					-- if PlayerFlight and Tplayer.side == sideName then													--if the mission has a player flight
					if flight[f].player or flight[f].client2 then	
						local s = "Meteo:\\n"																				--overview of Weather
						
						local remain = math.ceil((camp.weather.zoneEnd - ((camp.day - 1) * 86400 + camp.time)) / 3600)		--hours until end of weather zone
						local duration = math.ceil((camp.weather.zoneEnd - camp.weather.zoneStart) / 3600)					--duration of the weather zone in hours
						local passed = 100 / duration * remain																--percentage of zone passage
						
						if camp.weather.zone == "high" then
							if mission.weather["enable_fog"] == false then
								s = s .. "Good flying weather due to influence of a high pressure system in theater of operations"
								if remain < 6 then
									s = s .. ". Change of general weather situation imminent. "
								elseif remain < 25 then
									s = s .. ", expected to remain in effect for next " .. remain .. " hours. "
								elseif remain < 48 then
									s = s .. ", expected to remain dominant for another day. "
								else
									s = s .. ", expected to remain dominant for next " .. math.floor(remain / 24) .. " days. "
								end
							else
								s = s .. "Ground fog conditions. "
							end
							
						elseif camp.weather.zone == "low front cold" then
							s = s .. "Low pressure system dominating theater of operations. Currently poor flying weather due to passage of cold front. Weather improvement expected within next " .. remain .. " hours. "
							
						elseif camp.weather.zone == "low front warm" then
							s = s .. "Low pressure system dominating theater of operations. "
							if passed < 50 then
								s = s .. "Currently increasingly poor flying weather due to the passage of warm front. Expected to clear up after " .. remain .. " hours. "
							else
								s = s .. "Weather expected to deteriorate within next " .. remain .. " hours due to approach of warm front. "
							end
							
						elseif camp.weather.zone == "low sector cold" then
							s = s .. "Low pressure system dominating theater of operations. Currently fair flying weather in cold sector"
							if remain < 6 then
								s = s .. ". Change of general weather situation imminent. "
							elseif remain < 25 then
								s = s .. ", expected to remain in effect for next " .. remain .. " hours. "
							elseif remain < 48 then
								s = s .. ", expected to remain stable for another day. "
							else
								s = s .. ", expected to remain stable for next " .. math.floor(remain / 24) .. " days. "
							end
							
						elseif camp.weather.zone == "low sector warm" then
							s = s .. "Low pressure system dominating theater of operations. Currently fair flying weather in warm sector"
							if remain < 6 then
								s = s .. ". Change of general weather situation imminent. "
							elseif remain < 25 then
								s = s .. ", expected to remain in effect for next " .. remain .. " hours. "
							elseif remain < 48 then
								s = s .. ", expected to remain stable for another day. "
							else
								s = s .. ", expected to remain stable for next " .. math.floor(remain / 24) .. " days. "
							end
							
						end
						
						briefing[sideName] = briefing[sideName] .. s .. "\\n\\n" .. METAR
					end


					--Assign briefing text to mission file
					if sideName == "blue" then
						mission.descriptionBlueTask = briefing[sideName]
					else
						mission.descriptionRedTask = briefing[sideName]
					end
				end
			end
		end
	end
end

	-- Miguel21 modification M06 : helicoptere plyable
	-- Le SA342 est tres particulier
	-- fréquence VHF en frequency Group
	-- canal préreglé uniquement en radio_1.miz qui est la RadioFM
	
	--Eagle_01 modification E03.a                                                                    
	-- Removed Mi-8 and Gazelle special radio code
	--[[
if PlayerFlight then															
	if camp.player.group["units"][1]["type"] == "SA342M" then
		for i=1, #camp.player.group["units"] do
			camp.player.group["units"][i]["Radio"] = { [1] = nil, }
			camp.player.group["units"][i]["Radio"] = { [1] = radioFM.SA342M[1] , }
		end                                                                 	
	elseif camp.player.group["units"][1]["type"] == "Mi-8MT" then
		for i=1, #camp.player.group["units"] do
			camp.player.group["units"][i]["Radio"] = { [2] = nil, }
			camp.player.group["units"][i]["Radio"] = { [2] = radioFM["Mi-8MT"][2] , }
		end
	
	end
end--]]

-- _affiche(target_picture, "target_picture")
-- ad image Miguel21 modification M05

	-- ajoute les images permanente du briefing
	
	for side, file in pairs(pictureBrief) do
		if side == "blue" then 			
			for nb, filename in ipairs(file) do	
				table.insert(BriefingImagesB, filename)
			end
		elseif side == "red" then
			for nb, filename in ipairs(file) do
				table.insert(BriefingImagesR, filename)
			end
		end
	end

	 -- ajoute les images du target selectionné
	if target_picture["blue"] then
		  for TP_n, target_picture in ipairs(target_picture.blue) do
			filename = target_picture    
			table.insert(BriefingImagesB, filename)
		   end
	elseif target_picture["red"] then
		  for TP_n, target_picture in ipairs(target_picture.red) do
			filename = target_picture    
			table.insert(BriefingImagesR, filename)
		   end
	end
		
	  for n = 1, #BriefingImagesB do
		mapResource["ResKey_BriefingImage_" .. BriefingImagesB[n]] = BriefingImagesB[n]     --define key in mapResource file
		table.insert(mission.pictureFileNameB, "ResKey_BriefingImage_" .. BriefingImagesB[n])  --add picture to blue briefing
	  end

	 for n = 1, #BriefingImagesR do
		mapResource["ResKey_BriefingImage_" .. BriefingImagesR[n]] = BriefingImagesR[n]     --define key in mapResource file
		table.insert(mission.pictureFileNameR, "ResKey_BriefingImage_" .. BriefingImagesR[n])  --add picture to red briefing
	  end


-- print("DC B descriptionBlueTask2 "..mission.descriptionBlueTask)
-- print()
-- print()
-- print("DC B descriptionRedTask2 "..mission.descriptionRedTask)

-- _affiche(mission.pictureFileNameB, "DC B mission.pictureFileNameB")
-- print()
-- print()
-- _affiche(mission.pictureFileNameR, "DC B mission.pictureFileNameR")

