import os.path
import re
import sys
import time  # Для задержки перед закрытием

CONFIG_FILE = "dcs_path_config.txt"

def get_dcs_path_from_user():
    """Запрашивает у пользователя путь до папки DCS World"""
    while True:
        user_input = input("Введите путь к игре (где лежит папка Scripts): ").strip()
        user_input = user_input.replace('\\', '/').strip('"\'')
        
        speech_lua_path = os.path.join(user_input, "Scripts", "Speech", "speech.lua")
        
        if os.path.isfile(speech_lua_path):
            with open(CONFIG_FILE, "w", encoding="utf-8") as f:
                f.write(user_input)
            return speech_lua_path
        print(f"Ошибка: speech.lua не найден по пути: {speech_lua_path}\nПопробуйте ещё раз.")

def load_target_path():
    """Загружает путь к speech.lua из конфига или запрашивает у пользователя"""
    default_path = os.path.join("C:/Eagle Dynamics/DCS World", "Scripts", "Speech", "speech.lua")
    
    if os.path.isfile(default_path):
        return default_path
    
    if os.path.isfile(CONFIG_FILE):
        with open(CONFIG_FILE, "r", encoding="utf-8") as f:
            base_path = f.readline().strip()
            config_path = os.path.join(base_path, "Scripts", "Speech", "speech.lua")
            if os.path.isfile(config_path):
                return config_path
    
    return get_dcs_path_from_user()

def fix_j11a_nation(file_path):
    """Исправляет nation для J-11A в файле speech.lua"""
    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            content = f.read()
        
        pattern = re.compile(r"(\['J-11A'\]\s*=\s*)([^,]+)(,)")
        match = pattern.search(content)
        
        if not match:
            print("⚠️ Строка с J-11A не найдена в файле")
            return "error"
        
        current_value = match.group(2).strip()
        if current_value == "nations.RUSSIA":
            return "no_change"
        
        new_content = pattern.sub(r"\1nations.RUSSIA\3", content)
        
        with open(file_path, 'w', encoding='utf-8') as f:
            f.write(new_content)
        
        return "changed"
    
    except Exception as e:
        print(f"❌ Ошибка при обработке файла: {e}")
        return "error"

def main():
    print("=== DCS Speech.lua Configurator ===")
    
    speech_path = load_target_path()
    print(f"\nНайден файл speech.lua:\n{speech_path}")
    
    print("\nПроверка значения для J-11A...")
    result = fix_j11a_nation(speech_path)
    
    if result == "changed":
        print(f"✅ Исправлено: ['J-11A'] → nations.RUSSIA")
    elif result == "no_change":
        print("✅ J-11A уже имеет правильное значение: nations.RUSSIA")
    else:
        print("\nПроизошла ошибка!")
        input("Нажмите Enter для выхода...")
        sys.exit(1)
    
    # Короткая пауза перед закрытием (1 секунда)
    time.sleep(1)
    sys.exit(0)

if __name__ == "__main__":
    main()
