local ext_lamp_prototypes = {
    IR_TRIODE_FAKE_BACKLIGHT = { -- Triple IR LED operation indicating fake light
        color = {255, 0, 0, 0.28}, flir_amount = 0.28, range = 1.0,
        power_up_t = 0.05, cool_down_t = 0.05,
    },
    IR_TRIODE = { -- Triple IR LED light of unknown characteristics
        color = {2, 0, 0, 0.17}, flir_amount = 0.094, range = 1800, angle_max = math.rad(24.0 + 4.0), angle_min = math.rad(24.0 - 4.0),
        power_up_t = 0.05, cool_down_t = 0.05,
    },
    IR_STROBE = { -- IR anti-collision light
        color = {2, 0, 0, 0.12}, flir_amount = 1.0, range = 16,
        controller = "VariablePatternStrobe", mode = "1 Flash", period = 0.5,
    },
    IR_FORMATION_LAMP = { -- IR formation light
        color = {2, 0, 0, 0.12}, flir_amount = 0.68, range = 0.84,
        controller = "Strobe", period = 1.2, reduced_flash_time = 0.5, power_up_t = 0.25, cool_down_t = 0.05, mode = 0,
    },
}



function make_CH47F ( rewrite_settings )
local AIRCRAFT = {
    Name                = "CH-47F",
    DisplayName         = _("CH-47F"),
    date_of_introduction = 2001.00,
    country_of_origin   = "USA",

    Picture             = "CH-47F.png",
    Rate                = 40, -- RewardPoint in Multiplayer -- TODO evaluate
    Shape               = "CH-47F_bl1",
    --*XRayShape           =  .. "_X-Ray",
    coreShaftShapeType  = "NIL",
    propellorShapeType  = "3ARG_PROC_BLUR",
    debrisGeneration    = 1,

    shape_table_data    = {
        {
            file        = "";
            life        = 58; -- life bar -- TODO evaluate
            vis         = 9; -- visibility gain -- TODO evaluate
            desrt       = "CH-47F_bl1_oblomki"; -- Name of destroyed object file name
            fire        = {3600, 8}; -- Fire on the ground after destroyed
            username    = "";
            index       = WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
            positioning = "BYNORMAL";
            drawonmap = true;
        },
        {
            name = "CH-47F_bl1_oblomki";
            file = "CH-47F_bl1_oblomki";
            fire = {3600, 8};
        },
    },

    mapclasskey = "P0091000020",  -- ref. MissionEditor/data/NewMap/images/nato/*.png
    attribute   = {wsType_Air, wsType_Helicopter, wsType_Cruiser, WSTYPE_PLACEHOLDER, "Transport helicopters",},
    Categories  = {},



    -----------------------------------------------------------------------------------------------



    M_empty         = 11400.0, -- kg  epmty + oil + 3 pilots
    M_nominal       = 17460.0, -- kg
    M_max           = 22680.0, -- kg
    M_fuel_max      = 3891.2 * 0.785, -- kg
    M_fuel_per_tank = {450.4 * 0.785, 1044.8 * 0.785, 450.4 * 0.785, 450.4 * 0.785, 1044.8 * 0.785, 450.4 * 0.785},
    --*M_Boost_Mixt_max = 0,
    --*center_of_mass = {0.0, 0.0, 0.0},
	InternalCargo = {
        nominalCapacity = 2400,
        maximalCapacity = 10886,
        para_unit_point = 55,
        unit_point 	  = 55,
		unit_block 	  = {0.76, 0.775},
		area 	  	  = {8, 1.5, 2},-- cargo bay dimensions
		far_wall_pos  = {4,-1.25,0}, -- coordinates on  point on corner of floor and centerline of far wall , together with area  it will give  geometry of cargo compartment in BCS  
		out_door = {
			rampa_left = {large = false, x = -10, z = -0.7, heading = math.rad(-160),
                mechanicals = {
                    close = {"CargoBayGates", "Close"},
                    deploy = {"CargoBayGates", "Hang"},
                    board = {"CargoBayGates", "Open"},
                    deployable = {{mechanism = "CargoBayGates", states = {"Open", "Hang"}}, {mechanism = "CargoBayGate0", states = {"Open", "Hang", "Board"}}, {mechanism = "CargoBayGate3", states = {"On"}},},
                    boardable = {{mechanism = "CargoBayGates", states = {"Open","CustomStage3","Board"}}, {mechanism = "CargoBayGate0", states = {"Open", "Board"}},},
                },
            },
			rampa_right = {large = false, x = -10, z =  0.7, heading = math.rad(160),
                mechanicals = {
                    close = {"CargoBayGates", "Close"},
                    deploy = {"CargoBayGates", "Hang"},
                    board = {"CargoBayGates", "Open"},
                    deployable = {{mechanism = "CargoBayGates", states = {"Open", "Hang"}}, {mechanism = "CargoBayGate0", states = {"Open", "Hang", "Board"}}, {mechanism = "CargoBayGate3", states = {"On"}},},
                    boardable = {{mechanism = "CargoBayGates", states = {"Open","CustomStage3","Board"}}, {mechanism = "CargoBayGate0", states = {"Open", "Board"}},},
                },
            },
			cargo_generic = {large = true, x = -10, z = 0, heading = math.rad(-180),
                mechanicals = {
                    close = {"CargoBayGates", "Close"},
                    board = {"CargoBayGates", "Open"},
                    boardable = {{mechanism = "CargoBayGates", states = {"Open"}}, {mechanism = "CargoBayGate0", states = {"Open"}},},
                },
            },
		},
	},

	LandRWCategories =
	{
		[1] =
		{
			Name = "AircraftCarrier",
		}, -- end of [1]
		[2] =
		{
			Name = "HelicopterCarrier",
		}, -- end of [2]
	}, -- end of LandRWCategories
	TakeOffRWCategories =
	{
		[1] =
		{
			Name = "AircraftCarrier",
		}, -- end of [1]
		[2] =
		{
			Name = "HelicopterCarrier",
		}, -- end of [2]
	}, -- end of TakeOffRWCategories

    length          = 28.3, -- Full length in m
    height          = 5.998, -- Height in m
    moment_of_inertia = {46000, 259000, 274000},
    --*rotInertia_xy = 0,

    Vy_max          = 14.6, -- Max climb speed in m/s (for AI)
    Ny_max          = 1.2, -- Max G (for AI)



    undercarriage_transmission = "Nil",
    undercarriage_movement = 0,
    wheel_steering_angle_max = math.rad(181.0),

    nose_gear_pos                            = {-4.99, -2.271, 1.605}, -- Central gear coordinates
    nose_gear_amortizer_direct_stroke        = 0.0,
    nose_gear_amortizer_reversal_stroke      = -0.15,
    nose_gear_amortizer_normal_weight_stroke = -0.15+0.147,
    nose_gear_wheel_diameter                 = 0.676,
    --*nose_gear_hiking = 0,

    main_gear_pos                            = {1.872, -2.536, 1.402}, -- Main gear coordinates
    main_gear_amortizer_direct_stroke        = 0.0,
    main_gear_amortizer_reversal_stroke      = -0.294,
    main_gear_amortizer_normal_weight_stroke = -0.294+0.285,
    main_gear_wheel_diameter                 = 0.676,

    --*tandem_gear_wheel_diameter



    range           = 465, -- Max range in km (for AI) -- TODO evaluate
    RCS             = 12.5, -- Radar Cross Section m2 -- TODO evaluate
    IR_emission_coeff = 0.1, -- Normal engine -- IR_emission_coeff = 1.0 @ Su-27 without afterburner. It is a reference value. -- TODO evaluate
    --*tanker_type = 0,
    --*air_refuel_receptacle_pos = {0.0, 0.0, 0.0},
    bigParkingRamp  = false,

    rotor_height                = 2.04,
    rotor_diameter              = 18.3,
    blades_number               = 6,
    blade_area                  = 7.43,
    rotor_RPM                   = -225.0,
    tail_rotor_RPM              = 225.0,
    blade_chord                 = 0.883,
    rotor_MOI                   = 30000,
    rotor_pos                   = {6.237,	2.018, 0.000},
    thrust_correction           = 0.75,
    fuselage_Cxa0               = 0.6,
    fuselage_Cxa90              = 5.9,
    fuselage_area               = 8.8,
    centering                   = -6.15328,
    tail_pos                    = {-5.755,	3.281,	0},
    tail_fin_area               = 3.45,
    tail_stab_area              = 2.94,

    MOI                         = {46000.0, 76162.0, 80778.0},

    V_max                       = 285,
    V_max_cruise                = 260,
    H_stat_max_L                = 2675,
    H_stat_max                  = 1675,
    H_din_two_eng               = 3100,
    H_din_one_eng               = 1600,
    flight_time_typical         = 142,
    flight_time_maximum         = 189,

    lead_stock_main             = 0.265,
    lead_stock_support          = 0.265,
    scheme                      = 2,

    Vy_land_max                 = 12.8,
    sound_name                  = "Aircrafts/Engines/RotorCH47",

    cannon_sight_type           = 0,
    cargo_max_weight            = 5000.0,
    cargo_radius_in_menu        = 2000.0,
    helicopter_hook_pos         = {-0.327, -1.999, 0.000},
    h_max_gear_hook             = 3.300,



    engines_count = 2, -- Engines count
    engines_nozzles = {
        [1] = {
            pos                 = {-5.555, 1.200, -1.205},
            elevation           = 5.0,
            azimuth             = 8.0,
            diameter            = 0.57,
            exhaust_length_ab   = 1.0,
            exhaust_length_ab_K = 0.3,
            smokiness_level     = 0.0,
            --*afterburner_effect_texture
            --*afterburner_circles_count
            --*afterburner_circles_pos
            --*afterburner_circles_scale
            engine_number       = 1,
        }, -- end of [1]
        [2] = {
            pos                 = {-5.555, 1.200, 1.205},
            elevation           = 5.0,
            azimuth             = -8.0,
            diameter            = 0.57,
            exhaust_length_ab   = 1.0,
            exhaust_length_ab_K = 0.3,
            smokiness_level     = 0.0,
            --*afterburner_effect_texture
            --*afterburner_circles_count
            --*afterburner_circles_pos
            --*afterburner_circles_scale
            engine_number       = 2,
        }, -- end of [2]
    }, -- end of engines_nozzles
    --*engines_startup_sequence = {0, 1},
    has_afteburner = false,
    engine_data =
    {
        power_take_off = 2926,
        power_max = 3395,
        power_WEP = 3395,
        power_TH_k =
        {
            [1] = {14.007,  -383.35, 3336.5},
            [2] = {15.464,  -409.31, 3447.3},
            [3] = {-2.9802, -222.92, 3025.2},
            [4] = {-4.8014, -104.19, 2382.0},
        },
        SFC_k = {0.0, -1.206e-005, 0.3637},
        power_RPM_k = {-0.08639, 0.24277, 0.84175},
        power_RPM_min = 9.1384,
        Nmg_Ready = 88.0,
        sound_name = "Aircrafts/Engines/EngineGE_CH47",
    },
    SFM_Data = {
        engine = {
            type = "TurboShaft",
            name = "T55-GA-714A",

            Nominal_RPM = 13600.0,
            Nmg     = 70.0,
            Nominal_Fan_RPM = 5200.0,
            MinRUD  = 0, -- Min state of the throttle
            MaxRUD  = 1, -- Max state of the throttle
            MaksRUD = 1, -- Military power state of the throttle
            ForsRUD = 1, -- Afterburner state of the throttle
            Startup_Prework = 58.0,
            Shutdown_Duration = 42.0,
            Startup_Duration = 42.0,
            Startup_Flame_FX_Time = 42.0,

            dcx_eng = 0.015, -- Engine drag coefficient
            hMaxEng = 12.5, -- Max altitude for safe engine operation in km
            dpdh_f  = 1800, -- altitude coefficient for AB thrust
            dpdh_m  = 1800, -- altitude coefficient for max thrust
            cemax   = 0.37, -- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
            cefor   = 0.37, -- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
            table_data = {
            --   M          Pmax
                {0.0,       16620.0},
                {0.1,       15600.0},
                {0.2,       14340.0},
                {0.3,       13320.0},
                {0.4,       12230.0},
                {0.5,       11300.0},
                {0.6,       10600.0},
                {0.7,       10050.0},
                {0.8,        9820.0},
                {0.9,        5902.0},
                {1.9,        3469.0}
            },
        }, -- end of engine
    },



    crew_members = {
        [1] = {
            role                = "pilot",
            role_display_name   = _("Pilot"),

            pilot_name          = "pilot_raf", -- TODO evaluate
            ejection_seat_name  = 0,
            ejection_added_speed= {0.0, 0.0, 1.0},
            drop_canopy_name    = 0,
            drop_parachute_name = "pilot_raf_parachute",

            can_be_playable     = true,
            --*g_suit
            --*ejection_play_arg
            --*ejection_through_canopy
            --*pilot_body_arg
            canopy_arg          = 38,
            --*canopy_args         = {38, 6.0, 421, 0.4},
            --*bailout_arg
            --*boarding_arg
            ejection_order      = 0,
            pos                 = {6.458, -0.256, 1.168},
            --*canopy_pos
            --*canopy_ejection_dir
        }, -- end of [1]
        [2] = {
            role                = "copilot",
            role_display_name   = _("Co-Pilot"),

            pilot_name          = "pilot_raf", -- TODO evaluate
            ejection_seat_name  = 0,
            ejection_added_speed= {0.0, 0.0, -1.0},
            drop_canopy_name    = 0,
            drop_parachute_name = "pilot_raf_parachute",

            can_be_playable     = true,
            --*g_suit
            --*ejection_play_arg
            --*ejection_through_canopy
            pilot_body_arg      = 472,
            canopy_arg          = 421,
            --*canopy_args         = {38, 6.0, 421, 0.4},
            --*bailout_arg
            --*boarding_arg
            ejection_order      = 1,
            pos                 = {6.458, -0.256, -1.168},
            --*canopy_pos
            --*canopy_ejection_dir
        }, -- end of [2]
        [3] = {
            role                = "flight_officer",
            role_display_name   = _("Engineer"),

            pilot_name          = "pilot_raf", -- TODO evaluate
            ejection_seat_name  = 0,
            ejection_added_speed= {0.0, 0.0, -1.0},
            drop_canopy_name    = 0,
            drop_parachute_name = "pilot_raf_parachute",

            can_be_playable     = true,
            --*g_suit
            --*ejection_play_arg
            --*ejection_through_canopy
            pilot_body_arg      = 472,
            canopy_arg          = 421,
            --*canopy_args         = {38, 6.0, 421, 0.4},
            --*bailout_arg
            --*boarding_arg
            ejection_order      = 1,
            pos                 = {6.458, -0.256, -1.168},
            --*canopy_pos
            --*canopy_ejection_dir
        }, -- end of [3]
        [4] = {
            role                = "gunner",
            role_display_name   = _("Port Gunner"),

            pilot_name          = "pilot_raf", -- TODO evaluate
            ejection_seat_name  = 0,
            ejection_added_speed= {0.0, 0.0, -1.0},
            drop_canopy_name    = 0,
            drop_parachute_name = "pilot_raf_parachute",

            can_be_playable     = true,
            --*g_suit
            --*ejection_play_arg
            --*ejection_through_canopy
            pilot_body_arg      = 472,
            canopy_arg          = 421,
            --*canopy_args         = {38, 6.0, 421, 0.4},
            --*bailout_arg
            --*boarding_arg
            ejection_order      = 1,
            pos                 = {6.458, -0.256, -1.168},
            --*canopy_pos
            --*canopy_ejection_dir
        }, -- end of [4]
        [5] = {
            role                = "gunner",
            role_display_name   = _("Stbd. Gunner"),

            pilot_name          = "pilot_raf", -- TODO evaluate
            ejection_seat_name  = 0,
            ejection_added_speed= {0.0, 0.0, -1.0},
            drop_canopy_name    = 0,
            drop_parachute_name = "pilot_raf_parachute",

            can_be_playable     = true,
            --*g_suit
            --*ejection_play_arg
            --*ejection_through_canopy
            pilot_body_arg      = 472,
            canopy_arg          = 421,
            --*canopy_args         = {38, 6.0, 421, 0.4},
            --*bailout_arg
            --*boarding_arg
            ejection_order      = 1,
            pos                 = {6.458, -0.256, -1.168},
            --*canopy_pos
            --*canopy_ejection_dir
        }, -- end of [5]
        [6] = {
            role                = "gunner",
            role_display_name   = _("Aft Gunner"),

            pilot_name          = "pilot_raf", -- TODO evaluate
            ejection_seat_name  = 0,
            ejection_added_speed= {0.0, 0.0, -1.0},
            drop_canopy_name    = 0,
            drop_parachute_name = "pilot_raf_parachute",

            can_be_playable     = true,
            --*g_suit
            --*ejection_play_arg
            --*ejection_through_canopy
            pilot_body_arg      = 472,
            canopy_arg          = 421,
            --*canopy_args         = {38, 6.0, 421, 0.4},
            --*bailout_arg
            --*boarding_arg
            ejection_order      = 1,
            pos                 = {6.458, -0.256, -1.168},
            --*canopy_pos
            --*canopy_ejection_dir
        }, -- end of [6]
    }, -- end of crew_members
    carried_members = {
    },
    crew_stations = "Hybrid",

    --fires_pos = { -- TODO deprecate w/ x-ray
    --    [1] = {0.0, 0.5, 0.0}, -- Fuselage -- TODO evaluate
    --    --[2] = {-0.6, -0.3, 0.95}, -- Wing R In
    --    --[3] = {-0.6, -0.3, -0.95},-- Wing L In
    --    --[4] = {-0.7, -0.25, 2.2}, -- Wing R Mid
    --    --[5] = {-0.7, -0.25, -2.2}, -- Wing L Mid
    --    --[6] = {-0.9, -0.18, 4.4}, -- Wing R Out
    --    --[7] = {-0.9, -0.18, -4.4}, -- Wing L Out
    --    [8] = {1.7, -0.1, 0.1}, -- Engine R In -- TODO evaluate
    --    [9] = {1.7, -0.1, -0.1}, -- Engine L In -- TODO evaluate
    --    --[10] = {0.2, 0.1, 0.1}, -- Engine R Out
    --    --[11] = {0.2, 0.1, -0.1}, -- Engine L Out
    --}, -- end of fires_pos

    effects_presets = {
        {effect = "HeaterExhaustSmokeTrail", preset = "KO_50"},
        {effect = "HeaterExhaustHotAir", preset = "KO_50"},
    },



    chaff_flare_dispenser = {
        [1] = {pos = {-5.804, 0.371, -1.571}, dir = {0.75876, -0.27004, -0.59275},},
        [2] = {pos = {-5.783, 0.348, 1.578}, dir = {0.76288, -0.28056, 0.58248},},
        [3] = {pos = {-6.036, -0.124, -1.608}, dir = {0.75179, -0.37749, -0.54065},},
        [4] = {pos = {-6.537, 0.153, 1.571}, dir = {0.72049, -0.39576, 0.56944},},
        [5] = {pos = {-2.192, 0.112, -1.654}, dir = {0.00000, 0.64278, -0.76604},},
        [6] = {pos = {-2.455, 0.111, 1.659}, dir = {0.00000, 0.64278, 0.76604},},
        [7] = {pos = {-2.435, 0.112, -1.654}, dir = {0.00000, 0.64278, -0.76604},},
        [8] = {pos = {-2.213, 0.111, 1.659}, dir = {0.00000, 0.64278, 0.76604},},
    },
    passivCounterm = {
        CMDS_Edit           = false,
        SingleChargeTotal   = 240,
        chaff               = {default = 120, increment = 30, chargeSz = 1},
        flare               = {default = 120, increment = 30, chargeSz = 1},
    },



    -- Sensors
    detection_range_max     = 0,
    radar_can_see_ground    = false, -- This should be examined (what is this exactly?) ??? -- TODO evaluate
    CanopyGeometry = makeHelicopterCanopyGeometry(LOOK_AVERAGE, LOOK_GOOD, LOOK_BAD),
    Sensors = {
        OPTIC	= "Merkury LLTV", -- For night goggles imitation
		RWR		= "Abstract RWR",
    },
    --*aim_error_level_bombing
    --*aim_error_dive_bombing
    --*aim_error_ground_attack



    --*ColdStartDefaultControls = {
    --*    [38] = 0.0,
    --*},



    mechanimations = {
        CargoBayGates = {
            {
                Transition = {"Close", "Open"},
                Sequence = {
                    {C = {{"PosType", 6}, {"Sleep", "for", 6.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Sleep", "for", 1.5}}},
                    {C = {{"Arg", 38, "to", 1.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.91, "speed", 0.186}}},
                    {C = {{"PosType", 6}, {"Sleep", "for", 8.0}}},
                    {C = {{"VelType", 0}, {"Arg", 85, "to", 1.0, "speed", 3.5}}},
                },
            },
            {
                Transition = {"Open", "Close"},
                Sequence = {
                    {C = {{"PosType", 6}, {"Sleep", "for", 4.0}}},
                    {C = {{"VelType", 1}, {"Arg", 85, "to", 0.0, "speed", 0.5}}},
                    {C = {{"PosType", 6}, {"Sleep", "for", 6.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Arg", 38, "to", 0.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.0, "speed", 0.186}}},
                },
            },
            {
                Transition = {"Close", "Hang"},
                Sequence = {
                    {C = {{"PosType", 6}, {"Sleep", "for", 6.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Sleep", "for", 1.5}}},
                    {C = {{"Arg", 38, "to", 1.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.604, "speed", 0.186}}},
                },
            },
            {
                Transition = {"Hang", "Close"},
                Sequence = {
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Arg", 38, "to", 0.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.0, "speed", 0.186}}},
                },
            },
			{
                Transition = {"Close", "CustomStage3"},
                Sequence = {
                    {C = {{"PosType", 6}, {"Sleep", "for", 1.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Sleep", "for", 1.5}}},
                    {C = {{"Arg", 38, "to", 1.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 1.0}}},
                    {C = {{"Arg", 86, "to", 0.55, "speed", 0.186}}}
                },
            },
			{
                Transition = {"CustomStage3", "Close"},
                Sequence = {
                    {C = {{"PosType", 6}, {"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Arg", 38, "to", 0.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.0, "speed", 0.186}}},
                },
            },
			{
                Transition = {"Close", "Board"},
                Sequence = {
                    {C = {{"PosType", 6}, {"Sleep", "for", 6.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Sleep", "for", 1.5}}},
                    {C = {{"Arg", 38, "to", 1.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.91, "speed", 0.186}}},
                    {C = {{"PosType", 6}, {"Sleep", "for", 8.0}}},
                    {C = {{"VelType", 0}, {"Arg", 85, "to", 1.0, "speed", 3.5}}},
                },
            },
            {
                Transition = {"Board", "Close"},
                Sequence = {
                    {C = {{"PosType", 6}, {"Sleep", "for", 4.0}}},
                    {C = {{"VelType", 1}, {"Arg", 85, "to", 0.0, "speed", 0.5}}},
                    {C = {{"PosType", 6}, {"Sleep", "for", 6.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Arg", 38, "to", 0.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.0, "speed", 0.186}}},
                },
            },
        },
        CargoBayGate0 = {
            {
                Transition = {"Close", "Open"},
                Sequence = {
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    --{C = {{"Sleep", "for", 1.5}}},
                    {C = {{"Arg", 38, "to", 1.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.91, "speed", 0.186}}},
                    {C = {{"PosType", 6}, {"Sleep", "for", 4.0}}},
                    {C = {{"VelType", 0}, {"Arg", 85, "to", 1.0, "speed", 3.5}}},
                },
            },
            {
                Transition = {"Open", "Close"},
                Sequence = {
                    {C = {{"VelType", 1}, {"Arg", 85, "to", 0.0, "speed", 0.5}}},
                    {C = {{"PosType", 6}, {"Sleep", "for", 4.0}}},
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Arg", 38, "to", 0.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.0, "speed", 0.186}}},
                },
            },
            {
                Transition = {"Close", "Ventilate"},
                Sequence = {
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                    {C = {{"Sleep", "for", 1.5}}},
                    {C = {{"Arg", 38, "to", 1.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                },
            },
            {
                Transition = {"Ventilate", "Hang"},
                Sequence = {
                    {C = {{"Arg", 86, "to", 0.604, "speed", 0.186}}},
                },
            },
            {
                Transition = {"Hang", "Board"},
                Sequence = {
                    {C = {{"Arg", 86, "to", 0.91, "speed", 0.186}}},
                },
            },
            {
                Transition = {"Board", "Open"},
                Sequence = {
                    {C = {{"PosType", -1}, {"Sleep", "for", 2.0}}},
                    {C = {{"VelType", 0}, {"Arg", 85, "to", 1.0, "speed", 3.5}}},
                },
            },
            {
                Transition = {"Open", "Board"},
                Sequence = {
                    {C = {{"VelType", 1}, {"Arg", 85, "to", 0.0, "speed", 0.5}}},
                    {C = {{"PosType", -1}, {"Sleep", "for", 2.0}}},
                },
            },
            {
                Transition = {"Board", "Hang"},
                Sequence = {
                    {C = {{"Arg", 86, "to", 0.604, "speed", 0.186}}},
                },
            },
            {
                Transition = {"Hang", "Ventilate"},
                Sequence = {
                    {C = {{"Arg", 86, "to", 0.07, "speed", 0.186}}},
                },
            },
            {
                Transition = {"Ventilate", "Close"},
                Sequence = {
                    {C = {{"Arg", 38, "to", 0.0, "speed", 0.25}}},
                    {C = {{"Sleep", "for", 2.0}}},
                    {C = {{"Arg", 86, "to", 0.0, "speed", 0.186}}},
                },
            },
        },
        ExternalCargoEquipment = {
            {
                Transition = {"Dismantle", "Erect"},
                Sequence = {
                    {C = {{"Arg", 26, "to", 1.0, "speed", 1.0, "sign", 1}}},
                },
            },
            {
                Transition = {"Erect", "Dismantle"},
                Sequence = {
                    {C = {{"Sleep", "for", 10.0}}},
                    {C = {{"Arg", 26, "to", 0.0, "speed", 1.0, "sign", -1}}},
                },
            },
        },
        ServiceHatch7 = {
            {Transition = {"Any", "CustomStage0"}, Sequence = {
                    {C = {{"PokeSound", 12006}}},
                },
            },
            {Transition = {"Any", "CustomStage1"}, Sequence = {
                    {C = {{"PokeSound", 12007}}},
                },
            },
        },
        ServiceHatch8 = {
            {
                Transition = {"Close", "Open"},
                Sequence = {
                    {C = {{"Arg", 25, "to", 1.0, "speed", 1.0, "sign", 1}}},
                },
            },
            {
                Transition = {"Open", "Close"},
                Sequence = {
                    {C = {{"Arg", 25, "to", 0.0, "speed", 1.0, "sign", -1}}},
                },
            },
        },
        ServiceHatch9 = {
            {Transition = {"Any", "CustomStage0"}, Sequence = {
                    {C = {{"PokeSound", 12004}}},
                },
            },
            {Transition = {"Any", "CustomStage1"}, Sequence = {
                    {C = {{"PokeSound", 12005}}},
                },
            },
        },
        ServiceHatch10 = {
            {Transition = {"Any", "CustomStage0"}, Sequence = {
                    {C = {{"PokeSound", 12000}}},
                },
            },
            {Transition = {"Any", "CustomStage1"}, Sequence = {
                    {C = {{"PokeSound", 12001}}},
                },
            },
        },
        ServiceHatch11 = {
            {Transition = {"Any", "CustomStage0"}, Sequence = {
                    {C = {{"PokeSound", 12002}}},
                },
            },
            {Transition = {"Any", "CustomStage1"}, Sequence = {
                    {C = {{"PokeSound", 12003}}},
                },
            },
        },
        SearchLight0Elevation = {
            {Transition = {"Any", "Retract"}, Sequence = {
                    {C = {{"Arg", 425, "from", 1.0, "to", 0.0, "speed", 0.15},},},
                },
            },
            {Transition = {"Any", "Extend"}, Sequence = {
                    {C = {{"Arg", 425, "from", 0.0, "to", 1.0, "speed", 0.15},},},
                },
            },
        },
        SearchLight0Panning = {
            {Transition = {"Any", "Right"}, Sequence = {
                    {C = {{"Arg", 426, "from", -1.0, "to", 1.0, "speed", 0.2},},},
                },
            },
            {Transition = {"Any", "Left"}, Sequence = {
                    {C = {{"Arg", 426, "from", 1.0, "to", -1.0, "speed", 0.2},},},
                },
            },
        },
        SearchLight1Elevation = {
            {Transition = {"Any", "Retract"}, Sequence = {
                    {C = {{"Arg", 423, "from", 1.0, "to", 0.0, "speed", 0.15},},},
                },
            },
            {Transition = {"Any", "Extend"}, Sequence = {
                    {C = {{"Arg", 423, "from", 0.0, "to", 1.0, "speed", 0.15},},},
                },
            },
        },
        SearchLight1Panning = {
            {Transition = {"Any", "Right"}, Sequence = {
                    {C = {{"Arg", 424, "from", -1.0, "to", 1.0, "speed", 0.2},},},
                },
            },
            {Transition = {"Any", "Left"}, Sequence = {
                    {C = {{"Arg", 424, "from", 1.0, "to", -1.0, "speed", 0.2},},},
                },
            },
        },
        HeadLights = {
            {Transition = {"Any", "Retract"}, Sequence = {
                    {C = {{"Arg", 424, "to", 0.0, "speed", 0.2},},},
                    {C = {{"Arg", 423, "to", 0.0, "speed", 0.15},},},
                },
            },
            {Transition = {"Any", "Taxi"}, Sequence = {
                    {C = {{"Arg", 423, "to", 0.6, "speed", 0.15},},},
                    {C = {{"Arg", 424, "to", 0.05, "speed", 0.2},},},
                },
            },
            {Transition = {"Any", "High"}, Sequence = {
                    {C = {{"Arg", 423, "to", 0.4, "speed", 0.15},},},
                    {C = {{"Arg", 424, "to", 0.0, "speed", 0.2},},},
                },
            },
        },
    },

    net_animation = {
        28, 29, 30,
        600,
        620, 621, 622, 623, 624, 625, 626, 627,

        395, 396, 397, 398,         -- controls: stick, collective, pedals
        39, 99, 533,                -- pilot head turn, head roll
        337, 399, 537,              -- copilot head turn, head roll
        506, 508, 509,              -- pilot helmet kit
        516, 518, 519,              -- copilot helmet kit
        459, 460,                   -- died/alive
        500, 501, 502, 503,         -- pilot hands on stick, collective; pedals control
        510, 511, 512, 513,         -- copilot hands on stick, collective; pedals control
        530, 531, 532,              -- pilot body deflections
        534, 535, 536,              -- copilot body deflections
    },



    --HumanRadio = {
    --    frequency = 132.0,
    --    editable = true,
    --    minFrequency = 118.000,
    --    maxFrequency = 136.975,
    --    modulation = MODULATION_AM
    --},
    --panelRadio = {
    --    {
    --        ID = "ARK-15M",
    --        name = _("ARK-15M"),
    --        displayUnits = "kHz",
    --        range = {min = 0.100, max = 1.795},
    --        channels = {
    --            [1] = { name = _("Channel 1, Outer"),       default = 0.625,    modulation = _("AM")},  -- Krasnodar-Center
    --            [2] = { name = _("Channel 1, Inner"),       default = 0.303,    modulation = _("AM")},  -- Krasnodar-Center
    --            [3] = { name = _("Channel 2, Outer"),       default = 0.289,    modulation = _("AM")},  -- Maykop
    --            [4] = { name = _("Channel 2, Inner"),       default = 0.591,    modulation = _("AM")},  -- Maykop
    --            [5] = { name = _("Channel 3, Outer"),       default = 0.408,    modulation = _("AM")},  -- Krymsk
    --            [6] = { name = _("Channel 3, Inner"),       default = 0.803,    modulation = _("AM")},  -- Krymsk
    --            [7] = { name = _("Channel 4, Outer"),       default = 0.443,    modulation = _("AM")},  -- Anapa
    --            [8] = { name = _("Channel 4, Inner"),       default = 0.215,    modulation = _("AM")},  -- Anapa
    --        }
    --    },
    --},



    -- Guns
    Guns = nil,

    Pylons = {
        pylon(
            1, -- pylon index
            0, -- pylon default weapon start (0 - rail, 1 - catapult, > 1 - from hatch)
            0.0, 0.0, 0.0, -- coordinates in aircraft space, can be 0, 0, 0 if connector is used
            {
                connector = "GUNNER_POINT_2",
                use_full_connector_position = true,
                DisplayName = _("L MG"),
                arg = 87,
                arg_value = 0.0,
            },
            {
                {
                    CLSID = "{CH47_PORT_M60D}",
                    connector = "GUNNER_POINT_2",
                    arg_value = 1.0,
                },
                {
                    CLSID = "{CH47_PORT_M240H}",
                    connector = "GUNNER_POINT_2",
                    arg_value = 1.0,
                },
            },
            100
        ),
        pylon(
            2, -- pylon index
            0, -- pylon default weapon start (0 - rail, 1 - catapult, > 1 - from hatch)
            0.0, 0.0, 0.0, -- coordinates in aircraft space, can be 0, 0, 0 if connector is used
            {
                connector = "GUNNER_POINT_1",
                use_full_connector_position = true,
                DisplayName = _("R MG"),
                arg = 349,
                arg_value = 0.0,
            },
            {
                {
                    CLSID = "{CH47_STBD_M60D}",
                    connector = "GUNNER_POINT_1",
                    arg_value = 1.0,
                },
                {
                    CLSID = "{CH47_STBD_M240H}",
                    connector = "GUNNER_POINT_1",
                    arg_value = 1.0,
                },
            },
            300
        ),
        pylon(
            3, -- pylon index
            0, -- pylon default weapon start (0 - rail, 1 - catapult, > 1 - from hatch)
            0.0, 0.0, 0.0, -- coordinates in aircraft space, can be 0, 0, 0 if connector is used
            {
                connector = "GUNNER_POINT_3",
                use_full_connector_position = true,
                DisplayName = _("Aft MG"),
                arg = 348,
                arg_value = 0.0,
            },
            {
                {
                    CLSID = "{CH47_AFT_M60D}",
                    connector = "GUNNER_POINT_3",
                    arg_value = 1.0,
                },
                {
                    CLSID = "{CH47_AFT_M240H}",
                    connector = "GUNNER_POINT_3",
                    arg_value = 1.0,                    
                },
            },
            300
        ),
        pylon(
            4, -- pylon index
            0, -- pylon default weapon start (0 - rail, 1 - catapult, > 1 - from hatch)
            0.0, 0.0, 0.0, -- coordinates in aircraft space, can be 0, 0, 0 if connector is used
            {
                DisplayName = _("MH47"),
                arg = 349,
                arg_value = 0.0,
            },
            {
                {
                    CLSID = "{MH47}",
                    arg_value = 1.0,
                },
            },
            300
        ),
    },




    -- Tasks
    Tasks = {
        aircraft_task(Reconnaissance),
        aircraft_task(Escort),
        aircraft_task(Transport),
        aircraft_task(Airborne),
        aircraft_task(CAS),
    },
    DefaultTask = aircraft_task(Transport),



    -- Damage, index meaning see in Scripts\Aircrafts\_Common\Damage.lua
    Damage = verbose_to_dmg_properties({
        -- Сabin
        ["NOSE_CENTER"] = {
            args = {146}, damage_boundary = 0.1,
            critical_damage = 3.5,
            construction = {durability = 4.15, skin = "Aluminum"},
            droppable = false,
        },
        ["NOSE_LEFT_SIDE"] = {
            args = {296}, damage_boundary = 0.22,
            critical_damage = 2,
            construction = {durability = 1.78, skin = "Glass"},
            droppable = false,
        },
        ["NOSE_RIGHT_SIDE"] = {
            args = {297}, damage_boundary = 0.27,
            critical_damage = 2,
            construction = {durability = 1.78, skin = "Glass"},
            droppable = false,
        },
        ["COCKPIT"] = {
            args = {65}, damage_boundary = 0.21,
            critical_damage = 2,
            construction = {durability = 0.92, skin = "Glass"},
            droppable = false,
        },
        ["CABIN_LEFT_SIDE"] = {
            args = {150}, damage_boundary = 0.23,
            critical_damage = 2,
            construction = {durability = 0.92, skin = "Glass"},
            droppable = false,
        },
        ["CABIN_RIGHT_SIDE"] = {
            args = {149}, damage_boundary = 0.05,
            critical_damage = 3.5,
            construction = {durability = 4.15, skin = "Aluminum"},
            droppable = false,
        },
        ["CABIN_BOTTOM"] = {
            args = {152}, damage_boundary = 0.05,
            critical_damage = 5,
            construction = {durability = 5.76, skin = "Aluminum"},
            droppable = false,
        },
        ["PITOT"] = {
            args = {-1},
            critical_damage = 1,
            construction = {durability = 0.01, skin = "Aluminum"},
            droppable = false,
        },
        ["GUN"] = {
            args = {-1},
            critical_damage = 1,
            construction = {durability = 0.01, skin = "Aluminum"},
            droppable = false,
        },

        -- Engines
        ["ENGINE_L"] = {
            args = {166}, damage_boundary = 0.05,
            critical_damage = 1,
            construction = {durability = 1.05, skin = "Aluminum"},
            droppable = false,
        },
        ["PYLON3"] = {
            args = {-1},
            critical_damage = 1,
            construction = {durability = 0.12, skin = "Aluminum"},
            droppable = false,
        },
        ["ENGINE_R"] = {
            args = {160}, damage_boundary = 0.05,
            critical_damage = 1,
            construction = {durability = 1.05, skin = "Aluminum"},
            droppable = false,
        },
        ["PYLON4"] = {
            args = {-1},
            critical_damage = 1,
            construction = {durability = 0.12, skin = "Aluminum"},
            droppable = false,
        },

        -- Fuselage
        ["FUSELAGE_LEFT_SIDE"] = {
            args = {154}, damage_boundary = 0.05,
            critical_damage = 4,
            construction = {durability = 3.90, skin = "Aluminum"},
            droppable = false,
        },
        ["FUSELAGE_RIGHT_SIDE"] = {
            args = {153}, damage_boundary = 0.05,
            critical_damage = 4,
            construction = {durability = 3.90, skin = "Aluminum"},
            droppable = false,
        },
        ["AIR_BRAKE_L"] = {
            args = {185}, damage_boundary = 0.05,
            critical_damage = 3.8,
            construction = {durability = 3.41, skin = "Aluminum"},
            droppable = false,
        },
        ["AIR_BRAKE_R"] = {
            args = {222}, damage_boundary = 0.05,
            critical_damage = 3.8,
            construction = {durability = 3.41, skin = "Aluminum"},
            droppable = false,
        },
        ["WING_L_PART_CENTER"] = {
            args = {231}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.74, skin = "Aluminum"},
            droppable = false,
        },
        ["WING_R_PART_CENTER"] = {
            args = {221}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.74, skin = "Aluminum"},
            droppable = false,
        },
        ["WING_L_PART_IN"] = {
            args = {230}, damage_boundary = 0.05,
            critical_damage = 5,
            construction = {durability = 5.69, skin = "Aluminum"},
            droppable = false,
        },
        ["WING_R_PART_IN"] = {
            args = {220}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.68, skin = "Aluminum"},
            droppable = false,
        },
        ["NOSE_BOTTOM"] = {
            args = {148}, damage_boundary = 0.05,
            critical_damage = 5,
            construction = {durability = 5.31, skin = "Aluminum"},
            droppable = false,
        },
        ["ARMOR_NOSE_PLATE_LEFT"] = {
            args = {298}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.74, skin = "Aluminum"},
            droppable = false,
        },
        ["ARMOR_NOSE_PLATE_RIGHT"] = {
            args = {299}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.74, skin = "Aluminum"},
            droppable = false,
        },
        ["ARMOR_PLATE_LEFT"] = {
            args = {300}, damage_boundary = 0.05,
            critical_damage = 4,
            construction = {durability = 3.90, skin = "Aluminum"},
            droppable = false,
        },
        ["ARMOR_PLATE_RIGHT"] = {
            args = {301}, damage_boundary = 0.05,
            critical_damage = 4,
            construction = {durability = 3.90, skin = "Aluminum"},
            droppable = false,
        },
        ["WING_L_PART_OUT"] = {
            args = {252}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.96, skin = "Aluminum"},
            droppable = false,
        },
        ["FUSELAGE_BOTTOM"] = {
            args = {156}, damage_boundary = 0.05,
            critical_damage = 5.5,
            construction = {durability = 6.99, skin = "Aluminum"},
            droppable = false,
        },
        ["FUSELAGE_TOP"] = {
            args = {155}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 3.11, skin = "Aluminum"},
            droppable = false,
        },
        ["FUEL_TANK_LEFT_SIDE"] = {
            args = {158}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.74, skin = "Aluminum"},
            droppable = false,
        },
        ["FUEL_TANK_RIGHT_SIDE"] = {
            args = {157}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.74, skin = "Aluminum"},
            droppable = false,
        },
        ["TAIL_LEFT_SIDE"] = {
            args = {235}, damage_boundary = 0.05,
            critical_damage = 4,
            construction = {durability = 3.90, skin = "Aluminum"},
            droppable = false,
        },
        ["TAIL_RIGHT_SIDE"] = {
            args = {233}, damage_boundary = 0.05,
            critical_damage = 4,
            construction = {durability = 3.90, skin = "Aluminum"},
            droppable = false,
        },
        ["TAIL_BOTTOM"] = {
            args = {159}, damage_boundary = 0.05,
            critical_damage = 5.5,
            construction = {durability = 6.49, skin = "Aluminum"},
            droppable = false,
        },
        ["TAIL_TOP"] = {
            args = {303}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 1.91, skin = "Aluminum"},
            droppable = false,
        },
        ["LEFT_GEAR_BOX"] = {
            args = {267}, damage_boundary = 0.05,
            critical_damage = 2,
            construction = {durability = 1.38, skin = "Aluminum"},
            droppable = false,
        },
        ["RIGHT_GEAR_BOX"] = {
            args = {266}, damage_boundary = 0.05,
            critical_damage = 2,
            construction = {durability = 1.38, skin = "Aluminum"},
            droppable = false,
        },

        -- Forward Pylon
        ["WING_R_PART_OUT"] = {
            args = {250}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 2.21, skin = "Aluminum"},
            droppable = false,
        },

        -- Aft Pylon
        ["MTG_L"] = {
            args = {188}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 3.45, skin = "Aluminum"},
            droppable = false,
        },
        ["MTG_R"] = {
            args = {189}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 3.45, skin = "Aluminum"},
            droppable = false,
        },
        ["MTG_L_BOTTOM"] = {
            args = {167}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 4.11, skin = "Aluminum"},
            droppable = false,
        },
        ["MTG_R_BOTTOM"] = {
            args = {161}, damage_boundary = 0.05,
            critical_damage = 3,
            construction = {durability = 4.11, skin = "Aluminum"},
            droppable = false,
        },

        -- Forward Rotor
        ["ROTOR"] = {
            critical_damage = 20, args = {53},
            children = {"BLADE_1_IN", "BLADE_2_IN", "BLADE_3_IN",},
            construction = {durability = 10.0, skin = "Steel"},
            droppable = false,
        },
        ["BLADE_1_IN"] = {
            critical_damage = 5, args = {117},
            children = {"BLADE_1_CENTER",},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_1_CENTER"] = {
            critical_damage = 5, args = {116},
            children = {"BLADE_1_OUT"},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_1_OUT"] = {
            critical_damage = 5, args = {115},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_2_IN"] = {
            critical_damage = 5, args = {120},
            children = {"BLADE_2_CENTER",},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_2_CENTER"] = {
            critical_damage = 5, args = {119},
            children = {"BLADE_2_OUT"},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_2_OUT"] = {
            critical_damage = 5, args = {118},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_3_IN"] = {
            critical_damage = 5, args = {123},
            children = {"BLADE_3_CENTER",},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_3_CENTER"] = {
            critical_damage = 5, args = {122},
            children = {"BLADE_3_OUT"},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_3_OUT"] = {
            critical_damage = 5, args = {121},
            construction = {durability = 0.5, skin = "Aluminum"},
            droppable = true,
        },

        -- Aft Rotor
        ["TAIL_ROTOR"] = {
            critical_damage = 20, args = {54},
            children = {"BLADE_4_IN", "BLADE_5_IN", "BLADE_6_IN",},
            construction = {durability = 10.0, skin = "Steel"},
            droppable = false,
        },
        ["BLADE_4_IN"] = {
            critical_damage = 5, args = {126},
            children = {"BLADE_4_CENTER",},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_4_CENTER"] = {
            critical_damage = 5, args = {125},
            children = {"BLADE_4_OUT"},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_4_OUT"] = {
            critical_damage = 5, args = {124},
            construction = {durability = 0.5, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_5_IN"] = {
            critical_damage = 5, args = {129},
            children = {"BLADE_5_CENTER",},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_5_CENTER"] = {
            critical_damage = 5, args = {128},
            children = {"BLADE_5_OUT"},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_5_OUT"] = {
            critical_damage = 5, args = {127},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_6_IN"] = {
            critical_damage = 5, args = {132},
            children = {"BLADE_6_CENTER",},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_6_CENTER"] = {
            critical_damage = 5, args = {131},
            children = {"BLADE_6_OUT"},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },
        ["BLADE_6_OUT"] = {
            critical_damage = 5, args = {130},
            construction = {durability = 0.28, skin = "Aluminum"},
            droppable = true,
        },

        -- Undercarriage
        ["WHEEL_L"] = {
            critical_damage = 5,
            args = {267},
            construction = {durability = 10.0, skin = "Steel", spar = "Rod"},
            droppable = false,
        },
        ["WHEEL_R"] = {
            critical_damage = 5,
            args = {266},
            construction = {durability = 10.0, skin = "Steel", spar = "Rod"},
            droppable = false,
        },
        ["WHEEL_FL"] = {
            critical_damage = 5,
            args = {137},
            construction = {durability = 10.0, skin = "Steel", spar = "Rod"},
            droppable = false,
        },
        ["WHEEL_FR"] = {
            critical_damage = 5,
            args = {136},
            construction = {durability = 10.0, skin = "Steel", spar = "Rod"},
            droppable = false,
        },
    }),

    DamageParts = {
        --[1] = "SpitfireIXc_oblomok_wing_r", -- wing R -- TODO evaluate - Made Dragon
        --[2] = "SpitfireIXc_oblomok_wing_l", -- wing L -- TODO evaluate - Made Dragon
        --[3] = "", -- nose
        --[4] = "SpitfireIXc_oblomok_tail", -- tail -- TODO evaluate - Made Dragon
    },



    AddPropAircraft = {
        {
            id = "NetCrewControlPriority",
            control = "comboList",
            label = _("Aircraft Control Priority"),
            playerOnly = true,
            defValue = 0,
            values = {
                {id = 0, dispName = _("Pilot")},
                {id = 1, dispName = _("Co-Pilot")},
                {id = -1, dispName = _("Ask Always")},
                {id = -2, dispName = _("Equally Responsible")},
            },
            wCtrl = 150,
        },
    },



    Failures = { -- TODO evaluate - Made Dragon
--        { id = 'CTRL_AILERON_ROD_DESTROYED',            label = _('Aileron control failure'),                           enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_AILERON_ROD_MAJOR_DAMAGE',         label = _('Aileron control crippled'),                          enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_AILERON_ROD_MINOR_DAMAGE',         label = _('Aileron control damaged'),                           enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_ELEVATOR_ROD_DESTROYED',           label = _('Elevator control failure'),                          enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_ELEVATOR_ROD_MAJOR_DAMAGE',        label = _('Elevator control crippled'),                         enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_ELEVATOR_ROD_MINOR_DAMAGE',        label = _('Elevator control damaged'),                          enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_ELEVATOR_TRIM_FAILURE',            label = _('Trim drive failure'),                                enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_RUDDER_ROD_DESTROYED',             label = _('Rudder control failure'),                            enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_RUDDER_ROD_MAJOR_DAMAGE',          label = _('Rudder control crippled'),                           enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_RUDDER_ROD_MINOR_DAMAGE',          label = _('Rudder control damaged'),                            enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'CTRL_COMPASS_DESTROYED',                label = _('Compass destroyed'),                                 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },



--        { id = 'ELEC_BATTERY_OVERHEAT',                 label = _('Battery overheated'),                                enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_BATTERY_DESTROYED',                label = _('Battery failure'),                                   enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_GENERATOR_FAILURE',                label = _('Generator failure'),                                 enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_GENERATOR_REGULATOR_MALFUNCTION',  label = _('Regulator malfunction'),                             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_BOOSTER_FUEL_PUMP_FAILURE',        label = _('Booster pump failure'),                              enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_BOOSTER_FUEL_PUMP_COIL_FAILURE',   label = _('Booster pump electrical malfunction'),               enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_UC_LAMP_CU_BULB_FAILURE',          label = _('Undercarriage indicator Up light bulb broken'),      enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_UC_LAMP_CD_BULB_FAILURE',          label = _('Undercarriage indicator Down light bulb broken'),    enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_PITOT_HEAT_WIRING',                label = _('Pitot heating wire broken'),                         enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_PITOT_HEAT_ELEMENT',               label = _('Pitot heating element burned out'),                  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_RETICLE_BULB_FAILURE',             label = _('Reticle bulb broken'),                               enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_SUPERCHARGER_BULB_FAILURE',        label = _('Supercharger indicator bulb broken'),                enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_SUPERCHARGER_SOLENOID_FAILURE',    label = _('Supercharger solenoid failure'),                     enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_STARTER_LOOM_SEVERED',             label = _('Starter control wire broken'),                       enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_STARTER_SOLENOID_FAILURE',         label = _('Starter solenoid failure'),                          enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_STARTER_RELAY_FAILURE',            label = _('Starter relay failure'),                             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_NAVLIGHT_RED_FAILURE',             label = _('LH nav. light failure'),                             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_NAVLIGHT_GREEN_FAILURE',           label = _('RH nav. light failure'),                             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ELEC_NAVLIGHT_WHITE_FAILURE',           label = _('Aft nav. light failure'),                            enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },



--        { id = 'FUEL_ENGINE0_FUEL_PUMP_FAILURE',           label = _('Motor fuel pump failure'),                           enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'FUEL_ENGINE0_FUEL_PUMP_DEGRADED',          label = _('Motor fuel pump crippled'),                          enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'FUEL_BOOSTER_FUEL_PUMP_DEGRADED',       label = _('Booster pump mechanical malfunction'),               enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'FUEL_DROPTANK_LINE_SEVERED',            label = _('Drop tank hose severed'),                            enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'FUEL_MAIN_TANK_MINOR_LEAK',             label = _('Fuel tank minor leak'),                              enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'FUEL_MAIN_TANK_MAJOR_LEAK',             label = _('Fuel tank leak'),                                    enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

        { id = "FUEL_LEVEL_SENDER_0_FAILURE",           label = _("Failure.CH47.FUEL_SENDER0_(LH_FORE_AUX)_FAILURE"),   },
        { id = "FUEL_LEVEL_SENDER_1_FAILURE",           label = _("Failure.CH47.FUEL_SENDER1_(LH_MAIN_1)_FAILURE"),     },
        { id = "FUEL_LEVEL_SENDER_2_FAILURE",           label = _("Failure.CH47.FUEL_SENDER2_(LH_MAIN_2)_FAILURE"),     },
        { id = "FUEL_LEVEL_SENDER_3_FAILURE",           label = _("Failure.CH47.FUEL_SENDER3_(LH_MAIN_3)_FAILURE"),     },
        { id = "FUEL_LEVEL_SENDER_4_FAILURE",           label = _("Failure.CH47.FUEL_SENDER4_(LH_AFT_AUX)_FAILURE"),    },
        { id = "FUEL_LEVEL_SENDER_5_FAILURE",           label = _("Failure.CH47.FUEL_SENDER5_(RH_FORE_AUX)_FAILURE"),   },
        { id = "FUEL_LEVEL_SENDER_6_FAILURE",           label = _("Failure.CH47.FUEL_SENDER6_(RH_MAIN_1)_FAILURE"),     },
        { id = "FUEL_LEVEL_SENDER_7_FAILURE",           label = _("Failure.CH47.FUEL_SENDER7_(RH_MAIN_2)_FAILURE"),     },
        { id = "FUEL_LEVEL_SENDER_8_FAILURE",           label = _("Failure.CH47.FUEL_SENDER8_(RH_MAIN_3)_FAILURE"),     },
        { id = "FUEL_LEVEL_SENDER_9_FAILURE",           label = _("Failure.CH47.FUEL_SENDER9_(RH_AFT_AUX)_FAILURE"),    },
        { id = "FUEL_LH_LOW_LEVEL_SENSOR_FAILURE",      label = _("Failure.CH47.FUEL_LH_LOW_LEVEL_SENSOR_FAILURE"),     },
        { id = "FUEL_RH_LOW_LEVEL_SENSOR_FAILURE",      label = _("Failure.CH47.FUEL_RH_LOW_LEVEL_SENSOR_FAILURE"),     },



        { id = "HYDR_ACCUMULATOR_LOW_AIR_PRESSURE",     label = _("Hydro acc. low air pressure"),        hidden = true, },

        { id = "HYDR_FCS1_PRES_SWITCH_DISCO",           label = _("Failure.CH47.HYDR_FCS1_PRES_SWITCH_DISCO"),          },
        { id = "HYDR_FCS1_PRES_SWITCH_LOOSE",           label = _("Failure.CH47.HYDR_FCS1_PRES_SWITCH_LOOSE"),          },
        { id = "HYDR_FCS1_PRES_SWITCH_SHORT",           label = _("Failure.CH47.HYDR_FCS1_PRES_SWITCH_SHORT"),          },
        { id = "HYDR_FCS2_PRES_SWITCH_DISCO",           label = _("Failure.CH47.HYDR_FCS2_PRES_SWITCH_DISCO"),          },
        { id = "HYDR_FCS2_PRES_SWITCH_LOOSE",           label = _("Failure.CH47.HYDR_FCS2_PRES_SWITCH_LOOSE"),          },
        { id = "HYDR_FCS2_PRES_SWITCH_SHORT",           label = _("Failure.CH47.HYDR_FCS2_PRES_SWITCH_SHORT"),          },
        { id = "HYDR_UTIL_PRES_SWITCH_DISCO",           label = _("Failure.CH47.HYDR_UTIL_PRES_SWITCH_DISCO"),          },
        { id = "HYDR_UTIL_PRES_SWITCH_LOOSE",           label = _("Failure.CH47.HYDR_UTIL_PRES_SWITCH_LOOSE"),          },
        { id = "HYDR_UTIL_PRES_SWITCH_SHORT",           label = _("Failure.CH47.HYDR_UTIL_PRES_SWITCH_SHORT"),          },



--        { id = 'INST_VARIOMETR_DEPRESSURIZATION',       label = _('Variometer depressurization'),                       enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'INST_VARIOMETER_CLOGGED',               label = _('Variometer hose clogged'),                           enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'INST_SPEEDOMETER_DEPRESSURIZATION',     label = _('Speedometer depressurization'),                      enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'INST_PITOT_DAMAGE',                     label = _('Pitot damaged'),                                     enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'INST_TACH0_LOOM_SEVERED',               label = _('Tachometer circuit failure'),                        enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'INST_TACH0_POOR_CONNECTION',            label = _('Tachometer poor connection'),                        enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'INST_TACH0_RESISTANCE_MISMATCH',        label = _('Tachometer indicator adjustment fault'),             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },



--        { id = 'ENG0_JAMMED',                           label = _('Engine destroyed'),                                  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_MAGNETO0',                         label = _('Magneto No. 1 failure'),                             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_MAGNETO1',                         label = _('Magneto No. 2 failure'),                             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_GOVERNOR_MALFUNCTION',             label = _('Propeller governor malfunction'),                    enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_GOVERNOR_FAILURE',                 label = _('Propeller governor failure'),                        enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_GOVERNOR_REGULATOR_MALFUNCTION',   label = _('Propeller governor regulator failure'),              enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_STARTER_CLUTCH_FAILURE',           label = _('Starter clutch failure'),                            enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_STARTER_MOTOR_FAILURE',            label = _('Starter motor failure'),                             enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_BOOST_REGULATOR_MALFUNCTION',      label = _('Boost regulator malfunction'),                       enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_WATERRADIATOR0_PIERCED',           label = _('Port water radiator pierced'),                       enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_WATERRADIATOR1_PIERCED',           label = _('Starboard water radiator pierced'),                  enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
--        { id = 'ENG0_OILRADIATOR0_PIERCED',             label = _('Oil radiator pierced'),                              enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

        { id = "EXTE_FWD_MECHANICAL_FAILURE",           label = _("Failure.CH47.EXTE_FWD_MECHANICAL_FAILURE"),          },
        { id = "EXTE_CTR_MECHANICAL_FAILURE",           label = _("Failure.CH47.EXTE_CTR_MECHANICAL_FAILURE"),          },
        { id = "EXTE_AFT_MECHANICAL_FAILURE",           label = _("Failure.CH47.EXTE_AFT_MECHANICAL_FAILURE"),          },



        { id = "CHIPS_FOR_EVERYONE",           label = _("DEBUG Initiate CHIPS annunciators"),          },
        { id = "DEBRIS_FOR_EVERYONE",           label = _("DEBUG Initiate DEBRIS annunciators"),          },
    },



    lights_data = {
        typename = "Collection",
        lights = {
            [WOLALIGHT_PROJECTORS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Port WHT seachlight
                        typename = "Argument", argument = 208,
                        movable = true,
                    },
                    { -- 1 -- Stbd. WHT searchlight
                        typename = "Argument", argument = 209,
                        movable = true,
                    },
                    { -- 2 -- Port IR searchlight
                        typename = "Collection",
                        lights = {
                            {
                                typename = "Omni", connector = "LIGHT_IR_L",
                                proto = ext_lamp_prototypes.IR_TRIODE_FAKE_BACKLIGHT,
                                movable = true,
                            },
                            {
                                typename = "Spot", connector = "LIGHT_IR_L",
                                proto = ext_lamp_prototypes.IR_TRIODE,
                                movable = true,
                            },
                        },
                    },
                    { -- 3 -- Stbd. IR searchlight
                        typename = "Collection",
                        lights = {
                            {
                                typename = "Omni", connector = "LIGHT_IR_R",
                                proto = ext_lamp_prototypes.IR_TRIODE_FAKE_BACKLIGHT,
                                movable = true,
                            },
                            {
                                typename = "Spot", connector = "LIGHT_IR_R",
                                proto = ext_lamp_prototypes.IR_TRIODE,
                                movable = true,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_LANDING_LIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Stbd. WHT searchlight
                        typename = "Argument", argument = 209,
                        movable = true,
                    },
                },
            },
            [WOLALIGHT_TAXI_LIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Stbd. WHT searchlight
                        typename = "Argument", argument = 209,
                        movable = true,
                    },
                },
            },
            [WOLALIGHT_AUX_LIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- FWD hook illumination
                        typename = "Argument", argument = 194,
                    },
                    { -- 1 -- CTR hook illumination
                        typename = "Argument", argument = 195,
                    },
                    { -- 2 -- AFT hook illumination
                        typename = "Argument", argument = 196,
                    },
                    { -- 3 -- Top IR ANTI COL strobe
                        typename = "Omni", connector = "BEACON_IR_T",
                        proto = ext_lamp_prototypes.IR_STROBE,
                    },
                    { -- 4 -- Bottom IR ANTI COL strobe
                        typename = "Omni", connector = "BEACON_IR_B",
                        proto = ext_lamp_prototypes.IR_STROBE,
                    },
                    { -- 5 -- Cabin WHT
                        typename = "Argument", argument = 601,
                    },
                    { -- 6 -- Cabin NVG
                        typename = "Argument", argument = 602,
                    },
                    { -- 7 -- LH DOME WHT
                        typename = "Argument", argument = 605,
                    },
                    { -- 8 -- LH DOME NVG
                        typename = "Argument", argument = 606,
                    },
                    { -- 9 -- RH DOME WHT
                        typename = "Argument", argument = 607,
                    },
                    { -- 10 -- RH DOME NVG
                        typename = "Argument", argument = 608,
                    },
                    { -- 11 -- LH UTIL WHT
                        typename = "Argument", argument = 609,
                    },
                    { -- 12 -- LH UTIL NVG
                        typename = "Argument", argument = 610,
                    },
                    { -- 13 -- RH UTIL WHT
                        typename = "Argument", argument = 611,
                    },
                    { -- 14 -- RH UTIL NVG
                        typename = "Argument", argument = 612,
                    },
                },
            },
            [WOLALIGHT_NAVLIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Port POSN light
                        typename = "Argument", argument = 190,
                        controller = "Strobe", period = 0.73, reduced_flash_time = 0.5, power_up_t = 0.25, cool_down_t = 0.5, mode = 0,
                    },
                    { -- 1 -- Stbd. POSN light
                        typename = "Argument", argument = 191,
                        controller = "Strobe", period = 0.73, reduced_flash_time = 0.5, power_up_t = 0.25, cool_down_t = 0.5, mode = 0,
                    },
                    { -- 2 -- Aft POSN light
                        typename = "Argument", argument = 192,
                        controller = "Strobe", period = 0.73, reduced_flash_time = 0.5, power_up_t = 0.25, cool_down_t = 0.5, mode = 0,
                    },
                },
            },
            [WOLALIGHT_FORMATION_LIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- FORM electroluminescent stripes
                        typename = "Argument", argument = 200,
                        controller = "Strobe", period = 1.0, reduced_flash_time = 0.5, power_up_t = 0.05, cool_down_t = 0.05, mode = 0,
                    },
                },
            },
            [WOLALIGHT_IR_FORMATION] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- IR FORM light
                        typename = "Argument", argument = 193,
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 1 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_1",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 2 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_2",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 3 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_3",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 4 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_4",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 5 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_5",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 6 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_6",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 7 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_7",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                    { -- 8 -- IR FORM light
                        typename = "Omni", connector = "SIDE_LIGHT_IR_8",
                        proto = ext_lamp_prototypes.IR_FORMATION_LAMP,
                    },
                },
            },
            [WOLALIGHT_STROBES] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Top ANTI COL strobe
                        typename = "Argument", argument = 197,
                        controller = "Strobe", period = 1.49,
                    },
                    { -- 0 -- Bottom ANTI COL strobe
                        typename = "Argument", argument = 198,
                        controller = "Strobe", period = 1.51,
                    },
                },
            },
            [WOLALIGHT_CABIN_WORK] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- MFD Collective
                        typename = "Argument", argument = 604,
                    },
                },
            },
            [WOLALIGHT_CABIN_BOARDING] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Cabin WHT
                        typename = "Argument", argument = 601,
                    },
                    { -- 1 -- LH DOME NVG
                        typename = "Argument", argument = 606,
                    },
                    { -- 2 -- RH DOME NVG
                        typename = "Argument", argument = 608,
                    },
                    { -- 3 -- LH UTIL WHT
                        typename = "Argument", argument = 609,
                    },
                },
            },
            [WOLALIGHT_CABIN_NIGHT] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Consoles Backlight
                        typename = "Argument", argument = 603,
                    },
                },
            },
        }
    },



    rotor_animation = {
        rotor_locations = {
            {pos = { 5.923, 2.086, 0.0}, pitch = -0.157079235},
            {pos = {-5.893, 3.511, 0.0}, pitch = -0.0698136985}
        },
        rotor_models = {
            {
                modelRotorHub_EDM       = "CH-47F_bl1_rotor_hub",
                modelRotorHubLod_FBX    = "/models/ch47f_rotor_hub_lod.FBX",
                boundRotorHub_FBX       = "/models/ch47f_rotor_hub_bound.FBX",
                boundBlade_FBX          = "/models/ch47f_rotor_blade_bound.FBX",
                modelBlade_FBX          = {"/models/ch47f_rotor_blade.FBX"}, -- "/models/ch47f_rotor_blade_damage_1.FBX", "/models/ch47f_rotor_blade_damage_2.FBX" };
            },
            {
                modelRotorHub_EDM       = "CH-47F_bl1_rotor_hub_rear",
                modelRotorHubLod_FBX    = "/models/ch47f_rotor_hub_rear_lod.FBX",
                boundRotorHub_FBX       = "/models/ch47f_rotor_hub_rear_bound.FBX",
                boundBlade_FBX          = "/models/ch47f_rotor_blade_rear_bound.FBX",
                modelBlade_FBX          = {"/models/ch47f_rotor_blade_rear.FBX"}, -- "/models/ch47f_rotor_blade_damage_1.FBX", "/models/ch47f_rotor_blade_damage_2.FBX" };
            },
        },
    },



    ViewSettings = ViewSettings,
    SnapViews    = SnapViews,

	HumanRadio 		=
		{
			frequency	= 251.0,
			editable	= true,
			minFrequency	= 30.000,
			maxFrequency	= 399.975,
			rangeFrequency = {
				{min =  30.0, max =  87.975, modulation	= MODULATION_FM},
				{min = 108.0, max = 135.995, modulation	= MODULATION_AM},
				{min = 136.0, max = 155.995, modulation	= MODULATION_AM_AND_FM, modulationDef = MODULATION_FM},
				{min = 156.0, max = 173.975, modulation	= MODULATION_FM},
				{min = 225.0, max = 399.975, modulation	= MODULATION_AM_AND_FM, modulationDef = MODULATION_AM}
			},
			modulation = MODULATION_AM,
		},
	panelRadio = {
			[1] = {
			    name = _("VHF FM: ARC-186"),
				range = {min =  30.0, max =  87.995},
				channels = {
					[1] = { name = _("Channel 1"),		default = 31.5, modulation = _("FM")}, -- default
					[2] = { name = _("Channel 2"),		default = 45.7, modulation = _("FM")},
					[3] = { name = _("Channel 3"),		default = 57.0, modulation = _("FM")},
					[4] = { name = _("Channel 4"),		default = 38.0, modulation = _("FM")},
					[5] = { name = _("Channel 5"),		default = 30.0, modulation = _("FM")},
					[6] = { name = _("Channel 6"),		default = 32.0, modulation = _("FM")},
					[7] = { name = _("Channel 7"),		default = 40.0, modulation = _("FM")},
					[8] = { name = _("Channel 8"),		default = 50.0, modulation = _("FM")},
					[9] = { name = _("Channel 9"),		default = 55.5, modulation = _("FM")},
					[10] = { name = _("Channel 10"),		default = 39.9, modulation = _("FM")},
					[11] = { name = _("Channel 11"),		default = 41.5, modulation = _("FM")},
					[12] = { name = _("Channel 12"),		default = 75.7, modulation = _("FM")},
					[13] = { name = _("Channel 13"),		default = 33.0, modulation = _("FM")},
					[14] = { name = _("Channel 14"),		default = 38.0, modulation = _("FM")},
					[15] = { name = _("Channel 15"),		default = 42.0, modulation = _("FM")},
					[16] = { name = _("Channel 16"),		default = 51.5, modulation = _("FM")},
					[17] = { name = _("Channel 17"),		default = 50.0, modulation = _("FM")},
					[18] = { name = _("Channel 18"),		default = 79.0, modulation = _("FM")},
					[19] = { name = _("Channel 19"),		default = 51.5, modulation = _("FM")},
					[20] = { name = _("Channel 20"),		default = 34.9, modulation = _("FM")},
				}
			},
		},
}

if rewrite_settings then
   for i,o in pairs(rewrite_settings) do
        AIRCRAFT[i] = o
   end
end

AIRCRAFT.shape_table_data[1].file     = AIRCRAFT.Shape
AIRCRAFT.shape_table_data[1].username = AIRCRAFT.Name

return AIRCRAFT
end
