mount_vfs_texture_archives("Bazar/Textures/AvionicsCommon")

dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.common_script_path.."tools.lua")
dofile(LockOn_Options.script_path.."materials.lua")

layoutGeometry = {}

MainPanel = {"ccMainPanel", LockOn_Options.script_path.."mainpanel_init.lua"}

creators = {}

-- smoke 
creators[devices.Smoke]        = {"avSimpleWeaponSystem"  ,LockOn_Options.script_path.."Smoke/Smoke.lua"}


creators[devices.AN_APG70]		= {"AN_APG70::RadarDevice", nil,
									{{"ctrl_device_aa", devices.RDRCTRL_AA},
									{"ctrl_device_ag", devices.RDRCTRL_AG},
									{"MUX", devices.DMUX}
									}
								}
								
																								
creators[devices.RDRCTRL_AA]	= {"AN_APG70::RadarControlAA", nil,
									{{"an_apg70", devices.AN_APG70},
									{"MUX", devices.DMUX}}
								}
								
creators[devices.RDRCTRL_AG]	= {"AN_APG70::RadarControlAG", nil,
									{{"an_apg70", devices.AN_APG70},
									{"MUX", devices.DMUX}}
								}
								
creators[devices.HOTASCTRL]		= {"F15E_Instruments::avHOTAS", LockOn_Options.script_path.."Scripts/HOTAS_init.lua",
									{{"MUX", devices.DMUX},
									{"MPD_LEFT", devices.MPD_FLEFT},
									{"MPCD_CNT", devices.MPCD_FCENTER},
									{"MPD_RIGHT", devices.MPD_FRIGHT},
									{"MPCD_RLEFT", devices.MPCD_RLEFT},
									{"MPD_RLEFT", devices.MPD_RLEFT},
									{"MPD_RRIGHT", devices.MPD_RRIGHT},
									{"MPCD_RRIGHT", devices.MPCD_RRIGHT}}
								}
									
creators[devices.HPSS]	 		= {"F15E_Systems::avHPSS", nil,
									{{"ELECPWR", devices.EPSS},
									{"DEEC", devices.DEEC}}
								}
									
creators[devices.EPSS]			= {"F15E_Systems::avEPSS", nil,
									{{"HYDRPWR", devices.HPSS},
									{"DEEC", devices.DEEC}}
								}
creators[devices.UHF1]	 		= {"F15E_RadioSystem::avF15E_UHF1", 
									LockOn_Options.script_path.."Scripts/UHF1_Radio.lua",
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX}}
								}
creators[devices.UHF2]	 		= {"F15E_RadioSystem::avF15E_UHF2", 
									LockOn_Options.script_path.."Scripts/UHF2_Radio.lua",
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX}}
								}
creators[devices.TACAN]	 		= {"F15E_RadioSystem::avF15E_TACAN", nil,
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX}}
								}
creators[devices.ILS]	 		= {"F15E_RadioSystem::avF15E_ILS", nil,
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX}}
								}
creators[devices.ICS]	 		= {"F15E_RadioSystem::avF15E_ICS", 
									LockOn_Options.script_path.."Scripts/Intercom.lua",
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX},
									{"UHF1", devices.UHF1},
									{"UHF2", devices.UHF2},
									{"TACAN", devices.TACAN},
									{"ILS", devices.ILS},
									}
								}
creators[devices.DEEC]	 		= {"F15E_Systems::avDEEC", nil,
									{{"ELECPWR", devices.EPSS},
									 {"HYDRPWR", devices.HPSS},
									 {"MUX", devices.DMUX}}
								}
creators[devices.AFSS]	 		= {"F15E_Systems::avFuelControl", nil,
									{{"ELECPWR", devices.EPSS},
									 {"HYDRPWR", devices.HPSS},
									 {"LGSYST", devices.LGS},
									 {"MUX", devices.DMUX}}
								}
creators[devices.FLCTRL]		= {"F15E_Systems::avFlightControl", 
									LockOn_Options.script_path.."Scripts/FLT_CTRL_init.lua",
									{{"ELECPWR", devices.EPSS},
									{"HYDRPWR", devices.HPSS},
									{"ADC", devices.ADC},
									{"DEEC", devices.DEEC},
									{"LGSYST", devices.LGS},
									{"MUX", devices.DMUX}}
								}
creators[devices.LGS]	 		= {"F15E_Systems::avLandingGear", nil,
									{{"ELECPWR", devices.EPSS},
									{"HYDRPWR", devices.HPSS},
									{"MUX", devices.DMUX},
									}
								}
creators[devices.EXTLT]	 		= {"F15E_Systems::avExtLights", nil,
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX}}
								}
creators[devices.INTLT]	 		= {"F15E_Systems::avIntLights", nil,
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX},
									{"ACC", devices.ACC}}
								}
creators[devices.CNPYSYST]		= {"F15E_Systems::avCanopySyst", 
									LockOn_Options.script_path.."Scripts/CNPYSYST_init.lua",
									{{"HYDRPWR", devices.HPSS},
									 {"ELECPWR", devices.EPSS},
									 {"MUX", devices.DMUX}}
								}
creators[devices.ECS]	 		= {"F15E_Systems::avEnvControl", nil,
									{{"ELECPWR", devices.EPSS},
									{"CNPYST", devices.CNPYSYST},
									}
								}
creators[devices.WCAS]	 		= {"F15E_Systems::avWCASyst", nil,
									{{"ELECPWR", devices.EPSS},
									{"FUELMON", devices.AFSS},
									{"HYDRPWR", devices.HPSS},
									{"LGSYST", devices.LGS},
									{"CNPYST", devices.CNPYSYST},
									{"ENVCON", devices.ECS},
									{"MUX", devices.DMUX},
									{"FLINST", devices.FLINST},
									}
								}
creators[devices.PACS]			= {"F15E_Systems::avF15EWeapons", LockOn_Options.script_path.."Scripts/MSC.lua",
									{{"ELECPWR", devices.EPSS},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"AN_APG70", devices.AN_APG70},
									{"MUX", devices.DMUX},
									{"aam_ctrl_device", devices.AAWCTRL}}
								}
creators[devices.ADC]			= {"F15E_BlackBox::avADC", nil,
									{{"ELECPWR", devices.EPSS},
									{"INS_EGI", devices.INS_EGI},
									{"LGSYST", devices.LGS},
									{"MUX", devices.DMUX}}
								}
creators[devices.ACC]			= {"F15E_BlackBox::avACC", LockOn_Options.script_path.."Scripts/MSC.lua",
									{{"MUX", devices.DMUX}}
								}
creators[devices.DMUX]			= {"F15E_BlackBox::avMUX", nil,
									{{"ELECPWR_device", devices.EPSS},
									{"FLCTRL_device", devices.FLCTRL},
									{"ICS_CTRL_device", devices.ICS},
									{"ILS_CTRL_device", devices.ILS},
									{"TCN_CTRL_device", devices.TACAN},
									{"IFF_TRN_device", devices.IFF_TRN},
									{"DEEC_device", devices.DEEC},
									{"AFSS_device", devices.AFSS},
									{"HUDCTRL_device", devices.HUDCTRL},
									{"TAPEREC_device", devices.TAPEREC},
									{"ARMCTRL_device", devices.PACS},
									{"WPNGUIDE_device", devices.AGWCTRL},
									{"AAMS_device", devices.AAWCTRL},
									{"M61A1_device", devices.GUNCTRL},
									{"ADC_device", devices.ADC},
									{"ACC_device", devices.ACC},
									{"INSDC_device", devices.INS},
									{"INS_EGI_device", devices.INS_EGI},
									{"AN_ALR56_device", devices.TEWS},
									{"AN_ALE45_device", devices.EWS_CMD},
									{"AN_ALQ135_device", devices.EWS_JMR},
									{"AN_APG70_device", devices.AN_APG70},
									{"RDRCTRL_AA_device", devices.RDRCTRL_AA},
									{"RDRCTRL_AG_device", devices.RDRCTRL_AG},
									{"AN_AAQ13_device", devices.NAVPOD},
									{"TGPCTRL_device", devices.TGPCTRL},
									{"TFR_device", devices.TFR},
									{"LGSYST_device", devices.LGS},
									{"HOTAS_device", devices.HOTASCTRL},
									{"WCACTRL_device", devices.WCAS},
									{"SYSTEMS_SYNC_device", devices.SYSTEMS_SYNC},
									{"CARA_device", devices.CARA},
									{"DMS_device", devices.DMS },
									}
								}
creators[devices.INS_EGI]			= {"F15E_BlackBox::avINS_EGI", nil,
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX},
									{"UFC", devices.UFCCTRL_FRONT}}
								}
creators[devices.INS]			= {"F15E_BlackBox::avINDC", nil,
									{{"ELECPWR", devices.EPSS},
									{"TACAN", devices.TACAN},
									{"VORILS", devices.ILS},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"INS_EGI", devices.INS_EGI},
									{"MUX", devices.DMUX}}
								}
creators[devices.DMS]			= {"F15E_Instruments::avTSD_Map", LockOn_Options.script_path.."Scripts/DMS_init.lua",
									{{"ELECPWR", devices.EPSS},
									{"INSDC", devices.INS},
									{"MUX", devices.DMUX}}
								}
creators[devices.HUDCTRL]		= {"F15E_Instruments::avHUD", nil,
									{{"ELECPWR", devices.EPSS},
									{"ACC", devices.ACC},
									{"MUX", devices.DMUX}}
								}
								
local UFC_Linked_devices = 		{{"ELECPWR", devices.EPSS},
								 {"UHF1", devices.UHF1},
								 {"UHF2", devices.UHF2},
								 {"MUX", devices.DMUX}}
								
creators[devices.UFCCTRL_FRONT]	= {"F15E_Instruments::avUFC_Front", nil, UFC_Linked_devices}
								
creators[devices.UFCCTRL_REAR]	= {"F15E_Instruments::avUFC_Rear", nil, UFC_Linked_devices}
								
local FC_MFD_Ctrl_Linked_devices	= {{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX},
									{"DMS", devices.DMS},
									{"TGPCTRL", devices.TGPCTRL},
									{"UFC", devices.UFCCTRL_FRONT}}
								
local RC_MFD_Ctrl_Linked_devices	= {{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX},
									{"DMS", devices.DMS},
									{"TGPCTRL", devices.TGPCTRL},
									{"UFC", devices.UFCCTRL_REAR}}
								
creators[devices.MPD_FLEFT]		= {"F15E_Instruments::avMPCD_FL", nil, FC_MFD_Ctrl_Linked_devices}
								
creators[devices.MPCD_FCENTER]	= {"F15E_Instruments::avMPCD_FC", nil, FC_MFD_Ctrl_Linked_devices}
								
creators[devices.MPD_FRIGHT]	= {"F15E_Instruments::avMPCD_FR", nil, FC_MFD_Ctrl_Linked_devices}
								
creators[devices.MPCD_RLEFT]	= {"F15E_Instruments::avMPCD_RLO", nil, RC_MFD_Ctrl_Linked_devices}
								
creators[devices.MPD_RLEFT]		= {"F15E_Instruments::avMPCD_RLI", nil, RC_MFD_Ctrl_Linked_devices}
								
creators[devices.MPD_RRIGHT]	= {"F15E_Instruments::avMPCD_RRI", nil, RC_MFD_Ctrl_Linked_devices}
								
creators[devices.MPCD_RRIGHT]	= {"F15E_Instruments::avMPCD_RRO", nil, RC_MFD_Ctrl_Linked_devices}
								
creators[devices.FLINST]		= {"F15E_Instruments::avFlight_Inst", nil,
									{{"ELECPWR", devices.EPSS},
									{"DEEC", devices.DEEC},
									{"FUELMON", devices.AFSS},
									{"HYDRPWR", devices.HPSS},
									{"ENVCON", devices.ECS},
									{"FLCTRL", devices.FLCTRL},
									{"ADC", devices.ADC},
									{"MUX", devices.DMUX}
									}
								}
creators[devices.AGWCTRL]		= {"F15E_Systems::avF15EWGuidSyst", LockOn_Options.script_path.."Scripts/MSC.lua",
									{{"ELECPWR", devices.EPSS},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"INSDC", devices.INS},
									{"MUX", devices.DMUX},
									{"ARMCTRL", devices.PACS}}
								}
creators[devices.AAWCTRL]		= {"F15E_Systems::avF15EAACBT", nil,
									{{"ELECPWR", devices.EPSS},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"INSDC", devices.INS},
									{"INS_EGI", devices.INS_EGI},
									{"MUX", devices.DMUX},
									{"ARMCTRL", devices.PACS},
									{"AN_APG70", devices.AN_APG70}}
								}
creators[devices.GUNCTRL]		= {"F15E_Systems::avF15EVulcan", nil,
									{{"ELECPWR", devices.EPSS},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"INSDC", devices.INS},
									{"ARMCTRL", devices.PACS},
									{"AN_APG70", devices.AN_APG70},
									{"MUX", devices.DMUX}}
								}
								
creators[devices.NAVPOD]		= {"F15E_Sensors::avNAVPod", 
									LockOn_Options.script_path.."Scripts/AAQ13.lua",
									{{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"ARMCTRL", devices.PACS}}
								}
								
local TGP_linked_devices		= {{"ELECPWR", devices.EPSS},
									{"MUX", devices.DMUX},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"INSDC", devices.INS},
									{"ARMCTRL", devices.PACS}
								}
								
creators[devices.LANTPOD]		= {"F15E_Sensors::avAN_AAQ14",
									LockOn_Options.script_path.."Scripts/AAQ14.lua",
									TGP_linked_devices
								}
creators[devices.LTNGPOD]		= {"F15E_Sensors::avAN_AAQ28", 
									LockOn_Options.script_path.."Scripts/AAQ28.lua",
									TGP_linked_devices
								}
creators[devices.TGPCTRL]		= {"F15E_Sensors::avTGP", nil,
									{{"ELECPWR", devices.EPSS},
									{"AN_AAQ14", devices.LANTPOD},
									{"AN_AAQ28", devices.LTNGPOD},
									{"MUX", devices.DMUX}
									}
								}
creators[devices.EWS_RWR]		= {"F15E_Sensors::avEWS_ALR56_LRU", 
									LockOn_Options.script_path.."Scripts/ALR56C.lua",
									{{"ELECPWR", devices.EPSS}}
								}
creators[devices.TEWS]			= {"F15E_Sensors::avAN_ALR56C", nil,
									{{"ELECPWR", devices.EPSS},
									{"ACC", devices.ACC},
									{"MUX", devices.DMUX},
									{"ALR56C_LRU", devices.EWS_RWR}}
								}
creators[devices.EWS_CMD]		= {"F15E_Systems::avAN_ALE45", nil,
									{{"ELECPWR", devices.EPSS},
									{"ADC", devices.ADC},
									{"ACC", devices.ACC},
									{"AN_ALR56", devices.TEWS}}
								}
creators[devices.EWS_JMR]		= {"F15E_Systems::avAN_ALQ135", nil,
									{{"ELECPWR", devices.EPSS},
									{"ACC", devices.ACC},
									{"AN_ALR56", devices.TEWS}}
								}
								
creators[devices.AUTOSTART]		= {"F15E_Systems::avF15EAutoStart",nil,
								    {{"HYDRPWR", devices.HPSS},
								    {"ELECPWR", devices.EPSS},
								    {"DEEC", devices.DEEC},
									{"AFSS", devices.AFSS},
									{"FLCTRL", devices.FLCTRL},
									{"WCAS", devices.WCAS},
									{"EXTLT", devices.EXTLT},
									{"INTLT", devices.INTLT},
									{"CANOPY", devices.CNPYSYST},
									{"MPD_LEFT", devices.MPD_FLEFT},
									{"MPCD_CNT", devices.MPCD_FCENTER},
									{"MPD_RIGHT", devices.MPD_FRIGHT},
									{"MPCD_RLEFT", devices.MPCD_RLEFT},
									{"MPD_RLEFT", devices.MPD_RLEFT},
									{"MPD_RRIGHT", devices.MPD_RRIGHT},
									{"MPCD_RRIGHT", devices.MPCD_RRIGHT},
									{"HUDCTRL", devices.HUDCTRL},
									{"ECS", devices.ECS},
									{"INSDC", devices.INS},
									{"TEWS", devices.TEWS},
									{"AN_APG70", devices.AN_APG70},
									{"AN_AAQ13", devices.NAVPOD},
									{"RDRCTRL_AA", devices.RDRCTRL_AA},
									{"FLINST", devices.FLINST},
									{"ADC", devices.ADC},
									{"TGPCTRL", devices.TGPCTRL},
									{"UFC_FRONT", devices.UFCCTRL_FRONT},
									{"UFC_REAR", devices.UFCCTRL_REAR},
									{"TFR", devices.TFR},
									{"AN_ALE45", devices.EWS_CMD},
									{"ICS_CTRL", devices.ICS},
									{"CARA", devices.CARA}}
								}
								
								
creators[devices.TAPEREC]		= {"F15E_Instruments::avTapeRecorder", nil,
									{}
								}
								
creators[devices.TFR]			= {"F15E_Sensors::avTFR", nil, { {"MUX", devices.DMUX} } }

creators[devices.ANVIS9] 		= {"F15E_Helmet::ANVIS9_F15E"}

creators[devices.CARA]			= {"F15E_Sensors::avCARA", LockOn_Options.script_path.."Scripts/CARA.lua",
									{ {"MUX", devices.DMUX} } }
									
creators[devices.IFF_TRN]		= {"F15E_RadioSystem::avF15E_APX119_IFF", LockOn_Options.script_path.."Scripts/AN_APX119.lua",
									{{"ELECPWR", devices.EPSS},
									 {"MUX", devices.DMUX}} 
								}
----------------------
creators[devices.SYSTEMS_SYNC]	= {"F15E_Systems::avSystemsSync", nil,
									{}
								}							 
									 
creators[devices.SWITCHS_SYNC]	= {"F15E_Systems::avSwitchesSync", nil,
									{{"MUX", devices.DMUX},
									 {"CANOPY", devices.CNPYSYST},
									 {"EXTLT", devices.EXTLT},
									 {"INTLT", devices.INTLT},
									 {"ECS", devices.ECS},
									 {"FLINST", devices.FLINST}}
								}
creators[devices.DATA_HUB]		= {"F15E_BlackBox::avDataParams", nil, 
									{{"MUX", devices.DMUX},
									 {"UHF1", devices.UHF1},
									 {"UHF2", devices.UHF2}
									} 
								}


-- Displays
local HUD_Main_Display	 =  {{"PNT_HUD_CENTER", "PNT_HUD_DOWN", "PNT_HUD_RIGHT"}, {rz_l = 5.1}}

local HUD_linked_devices =	{{"ELECPWR", devices.EPSS},
							{"HUDCTRL", devices.HUDCTRL},
							{"MUX", devices.DMUX},
							{"AN_AAQ13", devices.NAVPOD}}


local FC_MPDL_Display 	 =  {{"PNT_MFD1_CENTER", "PNT_MFD1_DOWN", "PNT_MFD1_RIGHT"}}
local FC_MPDR_Display 	 =  {{"PNT_MFD2_CENTER", "PNT_MFD2_DOWN", "PNT_MFD2_RIGHT"}}
local FC_MPCD_Display 	 =  {{"PNT_MFD3_CENTER", "PNT_MFD3_DOWN", "PNT_MFD3_RIGHT"}}

local RC_MPCDL_Display 	 =  {{"PNT_MFD4_CENTER", "PNT_MFD4_DOWN", "PNT_MFD4_RIGHT"}}
local RC_MPDL_Display 	 =  {{"PNT_MFD5_CENTER", "PNT_MFD5_DOWN", "PNT_MFD5_RIGHT"}}
local RC_MPDR_Display 	 =  {{"PNT_MFD6_CENTER", "PNT_MFD6_DOWN", "PNT_MFD6_RIGHT"}}
local RC_MPCDR_Display 	 =  {{"PNT_MFD7_CENTER", "PNT_MFD7_DOWN", "PNT_MFD7_RIGHT"}}

local MFD_linked_devices = 	{{"ELECPWR", devices.EPSS},
							{"MUX", devices.DMUX},
							{"DMS", devices.DMS},
							{"AN_ALR56", devices.TEWS},
							{"AN_AAQ13", devices.NAVPOD},
							{"TGPCTRL", devices.TGPCTRL}}

indicators  = {}

-------------------
-- FRONT COCKPIT --
-------------------

-->>>> HUD <<<<--
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_HUD_NF",
									LockOn_Options.script_path.."HUD/HUD_NF_init.lua", nil, 
									HUD_Main_Display,
									HUD_linked_devices
								}
								
indicators[#indicators + 1] =	{	"F15E_Displays::ccHUDM",
									LockOn_Options.script_path.."HUD/HUD_init.lua", nil, 
									HUD_Main_Display, 
									HUD_linked_devices
								}
								
indicators[#indicators + 1] =	{	"F15E_Displays::ccHUD_Repeater_Bake",
									LockOn_Options.script_path.."MFDG/HUD/HUD_REP_init.lua", nil,
									FC_MPDR_Display,
									HUD_linked_devices
								}
								
-->>>> VIDEO OUTPUT <<<<--

-->>>> MFDs <<<<--									
--FCMPDL
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MPDFL",
									LockOn_Options.script_path.."MFDG/FC_MPDL.lua", devices.MPD_FLEFT,
									FC_MPDL_Display,
									MFD_linked_devices
								}	
								
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MFDB_FCMPDL",
									LockOn_Options.script_path.."Bake/MFDG/Bake_FCL_init.lua", devices.MPD_FLEFT,
									FC_MPDL_Display,
									{{"MUX", devices.DMUX}}
								}	

--FCMPCD
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MPCDFC",
									LockOn_Options.script_path.."MFDG/FC_MPCD.lua", devices.MPCD_FCENTER,
									FC_MPCD_Display,
									MFD_linked_devices
								}					

indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MFDB_FCMPCD",
									LockOn_Options.script_path.."Bake/MFDG/Bake_FCC_init.lua", devices.MPCD_FCENTER,
									FC_MPCD_Display,
									{{"MUX", devices.DMUX}},
								}	

--FCMPDR
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MPDFR",
									LockOn_Options.script_path.."MFDG/FC_MPDR.lua", devices.MPD_FRIGHT,
									FC_MPDR_Display,
									MFD_linked_devices
								}					

indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MFDB_FCMPDR",
									LockOn_Options.script_path.."Bake/MFDG/Bake_FCR_init.lua", devices.MPD_FRIGHT,
									FC_MPDR_Display,
									{{"MUX", devices.DMUX}}
								}	

-->>>> UFC <<<<--
indicators[#indicators + 1] =	{	"F15E_Displays::ccUFC_Front",
									LockOn_Options.script_path.."UFC/Indicator/UFC_Front_init.lua", devices.UFCCTRL_FRONT,
									{{"PNT_UFC_CENTER", "PNT_UFC_DOWN", "PNT_UFC_RIGHT"}},
									{{"ELECPWR", devices.EPSS}}
								}	
		
								
------------------
-- REAR COCKPIT --
------------------
-- >>>> MFDs <<<<--				}					
--RCMPCDL
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MPCDLR",
									LockOn_Options.script_path.."MFDG/RC_MPDCL.lua", devices.MPCD_RLEFT,
									RC_MPCDL_Display,
									MFD_linked_devices
								}					
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MFDB_RCLO",
									LockOn_Options.script_path.."Bake/MFDG/Bake_RCLO_init.lua", devices.MPCD_RLEFT,
									RC_MPCDL_Display,
									{{"MUX", devices.DMUX}}
								}
								
--RCMPDL
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MPDLR",
									LockOn_Options.script_path.."MFDG/RC_MPDL.lua", devices.MPD_RLEFT,
									RC_MPDL_Display,
									MFD_linked_devices
								}
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MFDB_RCLI",
									LockOn_Options.script_path.."Bake/MFDG/Bake_RCLI_init.lua", devices.MPD_RLEFT,
									RC_MPDL_Display,
									{{"MUX", devices.DMUX}}
								}								
								
--RCMPDR
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MPDRR",
									LockOn_Options.script_path.."MFDG/RC_MPDR.lua", devices.MPD_RRIGHT,
									RC_MPDR_Display,
									MFD_linked_devices
								}
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MFDB_RCRI",
									LockOn_Options.script_path.."Bake/MFDG/Bake_RCRI_init.lua", devices.MPD_RRIGHT,
									RC_MPDR_Display,
									{{"MUX", devices.DMUX}}
								}									
								
--RCMPCDR
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MPCDRR",
									LockOn_Options.script_path.."MFDG/RC_MPDCR.lua", devices.MPCD_RRIGHT,
									RC_MPCDR_Display,
									MFD_linked_devices
								}
indicators[#indicators + 1] =	{	"F15E_Displays::ccF15E_MFDB_RCRO",
									LockOn_Options.script_path.."Bake/MFDG/Bake_RCRO_init.lua", devices.MPCD_RRIGHT,
									RC_MPCDR_Display,
									{{"MUX", devices.DMUX}}
								}									
								
-->>>> UFC <<<<--
indicators[#indicators + 1] =	{	"F15E_Displays::ccUFC_Rear",
									LockOn_Options.script_path.."UFC/Indicator/UFC_Rear_init.lua", devices.UFCCTRL_REAR,
									{{"PNT_UFCR_CENTER", "PNT_UFCR_DOWN", "PNT_UFCR_RIGHT"}},
									{{"ELECPWR", devices.EPSS}}
								}					



indicators[#indicators + 1] = 	{	"F15E_Helmet::ccHelmetF15E",LockOn_Options.script_path.."HELMET/Indicator/HelmetIndicator.lua"} 									
								
---------------------------------------------
indicators[#indicators + 1] =	{ 	"ccControlsIndicatorF15E",	
                                    LockOn_Options.script_path.."ControlsIndicator/ControlsIndicator.lua", nil
                                }
								
---------------------------------------------
dofile(LockOn_Options.script_path.."KNEEBOARD/device/declare_kneeboard_device.lua")
---------------------------------------------
dofile(LockOn_Options.common_script_path.."PADLOCK/PADLOCK_declare.lua")
---------------------------------------------