dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua") -- "script_path" is main scripts folder. common is local.

local rate = 0.5
make_default_activity(rate) -- gets plane info

local Data = get_base_data() 

local dev = GetSelf()

function post_initialize()
    print("post_initialize called in Smoke.lua")
    smoke_station0 = false	--pylon 1
    smoke_station1 = false  --pylon 5
    smoke_station2 = false  --pylon 8
    smoke_station3 = false  --pylon 11   
    smoke_station4 = false  --pylon 15  

    smoke_any = false
	smk_tog = false
	smoke_on = false
	deselect = false
	burnerLit = false 
	smoke_toggle_num = 0
	current_smoke = false
	smoke_armed = true --change to initially be false if you want to use the arming system
	center_smoke_equipped = false
	tip_smoke_equipped = false
	count = 0 --Will keep track of how long the burners are activated
	
	--Smokes equipable
	Smoke1 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E741}"
	Smoke2 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E742}"
	Smoke3 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E743}"
	Smoke4 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}"
	Smoke5 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E745}"
	Smoke6 = "{A4BCC903-06C8-47bb-9937-A30FEDB4E746}"


	-- Smoke1 = "{INV-SMOKE-RED}"
	-- Smoke2 = "{INV-SMOKE-GREEN}"
	-- Smoke3 = "{INV-SMOKE-BLUE}"
	-- Smoke4 = "{INV-SMOKE-WHITE}"
	-- Smoke5 = "{INV-SMOKE-YELLOW}"
	-- Smoke6 = "{INV-SMOKE-ORANGE}"

end

--dev:listen_command(7003) -- Smoke Armed
dev:listen_command(7010)


-- station 1 and 15 are the outermost ones (on a pylon)
-- station 5 and 11 are the cheeks
-- station 8 is center (on a pylon)
function Logic()

	-- pylon 1
	ST0 = dev:get_station_info(0)
	ST0CLSID = ST0.CLSID
	
	if((ST0CLSID == Smoke1) or (ST0CLSID == Smoke2) or (ST0CLSID == Smoke3) or (ST0CLSID == Smoke4) or (ST0CLSID == Smoke5) or (ST0CLSID == Smoke6)) then --If a smoke pod is on the 1 pylon
		smoke_station0 = true
	else
		smoke_station0 = false
	end
	
	-- pylon 5
	ST1 = dev:get_station_info(4)
	ST1CLSID = ST1.CLSID
	
	if((ST1CLSID == Smoke1) or (ST1CLSID == Smoke2) or (ST1CLSID == Smoke3) or (ST1CLSID == Smoke4) or (ST1CLSID == Smoke5) or (ST1CLSID == Smoke6)) then --If a smoke pod is on the 2 pylon
		smoke_station1 = true
	else
		smoke_station1 = false
	end
	
	-- pylon 8
	ST2 = dev:get_station_info(7)
	ST2CLSID = ST2.CLSID
	
	if((ST2CLSID == Smoke1) or (ST2CLSID == Smoke2) or (ST2CLSID == Smoke3) or (ST2CLSID == Smoke4) or (ST2CLSID == Smoke5) or (ST2CLSID == Smoke6)) then --If a smoke pod is on the 3 pylon
		smoke_station2 = true
	else
		smoke_station2 = false
	end

	-- pylon 11
	ST3 = dev:get_station_info(10)
	ST3CLSID = ST3.CLSID
	
	if((ST3CLSID == Smoke1) or (ST3CLSID == Smoke2) or (ST3CLSID == Smoke3) or (ST3CLSID == Smoke4) or (ST3CLSID == Smoke5) or (ST3CLSID == Smoke6)) then --If a smoke pod is on the 3 pylon
		smoke_station3 = true
	else
		smoke_station3 = false
	end

	-- pylon 15
	ST4 = dev:get_station_info(14)
	ST4CLSID = ST4.CLSID
	
	if((ST4CLSID == Smoke1) or (ST4CLSID == Smoke2) or (ST4CLSID == Smoke3) or (ST4CLSID == Smoke4) or (ST4CLSID == Smoke5) or (ST4CLSID == Smoke6)) then --If a smoke pod is on the 3 pylon
		smoke_station4 = true
	else
		smoke_station4 = false
	end


	-- if smoke_station0 == true or smoke_station1 == true or smoke_station2 == true or smoke_station3 == true then
	if smoke_station0 == true or smoke_station1 == true or smoke_station2 == true  then
		smoke_any = true
	end


	--If the left engine is in afterburner and the smoke is on the smoke will automatically be turned off.
	--[[
	if smoke_on == true then 
		-- if(center_smoke_equipped and tip_smoke_equipped) then
		if(tip_smoke_equipped) then
			dev:launch_station(0);
			dev:launch_station(1);
			dev:launch_station(2);
			dev:launch_station(3);		
		end
		smoke_on = true
		deselect = true --This variable is deselecting the smoke while in AB
	end
	--]]

	

	--If the smoke button has been pressed an odd number of times since the last update, or if the AB has been on since the last press the smoke will be toggled
	--IF AB is on nothing happens, and the toggle remains true so each update the AB state is checked again until the AB is deselected
	--This allows for you to toggle smoke while in AB without causing any smoke to be dispensed
	smoke_toggle = smoke_toggle_num % 2 -- this will either equal 1 or 0, if it equals 1 that means an odd number of presses has occured, and the next if statement will pass
	if smoke_toggle == 1 and smoke_armed == true then 
		
		-- pylon 1
		if(smoke_station0 == true) then
			dev:launch_station(0);
		end

		-- pylon 5
		if(smoke_station1 == true) then
			dev:launch_station(4);
		end

		-- pylon 8
		if(smoke_station2 == true) then
			dev:launch_station(7);
		end

		-- pylon 11
		if(smoke_station3 == true) then
			dev:launch_station(10);
		end

		-- pylon 15
		if(smoke_station4 == true) then
			dev:launch_station(14);
		end

		-- if(smoke_station3 == true) then
		-- 	dev:launch_station(14);
		-- end

			
		--Resetting values for next presses
		smoke_toggle = 0
		smoke_toggle_num = 0
		if smoke_on == true then
			smoke_on = false
			print_message_to_user("Smoke Off")
		else --If the smoke is off
			smoke_on = true
			print_message_to_user("Smoke On")
		end
		
	end
end


function SetCommand(command,value)
	
	if (command == 7010) and smoke_any == true then --and track_is_reading() == false then
		smoke_toggle_num = smoke_toggle_num + 1  --Activates a variable to turn on or off smoke when appropriate once the smoke toggle has been pressed (keeps track of how many times the button is pressed).
	end
end

function update() -- Ties into "local rate" at top. Updates twice a second
Logic()
end

need_to_be_closed = false