module("Mi-8MT", package.seeall)

local Module = require("Scripts.DCS-BIOS.lib.modules.Module")

--- @class Mi_8MT: Module
local Mi_8MT = Module:new("Mi-8MT", 0x2600, { "Mi-8MT", "Mi-8MTV2" })

--v2.0a overhaul by WarLord

-- remove Arg# Pilot 933 / CoPilot 934 / Crew 935

--Electrical system
Mi_8MT:defineToggleSwitch("GEN1_SWITCH", 1, 3015, 538, "Electrical system", "Generator 1 Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("GEN2_SWITCH", 1, 3016, 539, "Electrical system", "Generator 2 Switch, ON/OFF")

Mi_8MT:defineToggleSwitch("AC_GRND_PWR_SWITCH", 1, 3014, 540, "Electrical system", "AC Ground Power Switch, ON/OFF")
Mi_8MT:define3PosTumb("INV_115V_SWITCH", 1, 3012, 541, "Electrical system", "Inverter Switch 115V MANUAL/OFF/AUTO")
Mi_8MT:define3PosTumb("INV_36V_SWITCH", 1, 3013, 542, "Electrical system", "Inverter Switch 36V MANUAL/OFF/AUTO")
Mi_8MT:defineTumb("AC_VOLT_SEL", 1, 3017, 535, 0.1, { 0, 1 }, nil, false, "Electrical system", "AC Voltmeter Selector")
Mi_8MT:defineTumb("DC_VOLT_SEL", 1, 3008, 494, 0.1, { 0, 0.7 }, nil, false, "Electrical system", "DC Voltmeter Selector")
Mi_8MT:defineToggleSwitch("BATT1_SWITCH", 1, 3003, 495, "Electrical system", "Battery 1 Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("BATT2_SWITCH", 1, 3002, 496, "Electrical system", "Battery 2 Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("STBY_GEN_SWITCH", 1, 3001, 497, "Electrical system", "Standby Generator Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("RECT1_SWITCH", 1, 3007, 499, "Electrical system", "Rectifier 1 Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("RECT2_SWITCH", 1, 3005, 500, "Electrical system", "Rectifier 2 Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("RECT3_SWITCH", 1, 3006, 501, "Electrical system", "Rectifier 3 Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("DC_GRND_PWR_SWITCH", 1, 3004, 502, "Electrical system", "DC Ground Power Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("EQ_TST_SWITCH", 1, 3009, 503, "Electrical system", "Equipment Test Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("NET_RECT_COVER", 1, 3020, 147, "Electrical system", "Net on Rectifier Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("NET_RECT_SWITCH", 1, 3019, 148, "Electrical system", "Net on Rectifier Switch, ON/OFF")
Mi_8MT:define3PosTumb("TRANS_36V_SWITCH", 1, 3020, 149, "Electrical system", "Transformer Switch 36V, MAIN/OFF/AUXILIARY")
Mi_8MT:definePotentiometer("STB_GEN_RHEO", 1, 3010, 498, { 0, 1 }, "Electrical system", "Standby Generator Voltage Adjustment Rheostat")
Mi_8MT:definePotentiometer("GEN1_RHEO", 1, 3011, 536, { 0, 1 }, "Electrical system", "Generator 1 Voltage Adjustment Rheostat")
Mi_8MT:definePotentiometer("GEN2_RHEO", 1, 3018, 537, { 0, 1 }, "Electrical system", "Generator 2 Voltage Adjustment Rheostat")
Mi_8MT:defineToggleSwitch("BATT_HEAT_SWITCH", 1, 3106, 522, "Electrical system", "Battery Heating Switch, ON/OFF")

--AZS Left Panel Line 1
Mi_8MT:defineToggleSwitch("CB_BW_ESBR", 1, 3031, 590, "AZS Left Panel Line 1", "CB BW ESBR, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_EXPLODE", 1, 3032, 591, "AZS Left Panel Line 1", "CB Explode, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_CTRL", 1, 3033, 592, "AZS Left Panel Line 1", "CB Control, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_EQUIP", 1, 3034, 593, "AZS Left Panel Line 1", "CB Equipment, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_RS_GUV_FIRE", 1, 3035, 594, "AZS Left Panel Line 1", "CB RS/GUV Fire, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_RS_GUV_WARN", 1, 3036, 595, "AZS Left Panel Line 1", "CB RS/GUV Warning, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ESBR_HEAT", 1, 3037, 596, "AZS Left Panel Line 1", "CB ESBR Heating, ON/OFF")

--AZS Left Panel Line 2
Mi_8MT:defineToggleSwitch("CB_311", 1, 3038, 597, "AZS Left Panel Line 2", "CB 311, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_GUV_OUTER_LEFT", 1, 3039, 598, "AZS Left Panel Line 2", "CB GUV: Outer 800 Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_GUV_OUTER_RIGHT", 1, 3040, 599, "AZS Left Panel Line 2", "CB GUV: Outer 800 Right, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_GUV_622_LEFT_INNER_LEFT", 1, 3041, 600, "AZS Left Panel Line 2", "CB GUV: Inner Left 622 Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_GUV_622_LEFT_INNER_RIGHT", 1, 3042, 601, "AZS Left Panel Line 2", "CB GUV: Inner Left 622 Right, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_GUV_622_RIGHT_INNER_LEFT", 1, 3043, 602, "AZS Left Panel Line 2", "CB GUV: Inner Right 622 Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_GUV_622_RIGHT_INNER_RIGHT", 1, 3044, 603, "AZS Left Panel Line 2", "CB GUV: Inner Right 622 Right, ON/OFF")

--AZS Left Panel Line 3
Mi_8MT:defineToggleSwitch("CB_ELEC_LAUNCH_LEFT", 1, 3045, 604, "AZS Left Panel Line 3", "CB Electric Launch 800 Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ELEC_LAUNCH_RIGHT", 1, 3046, 605, "AZS Left Panel Line 3", "CB Electric Launch 800 Right, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_PKT", 1, 3047, 606, "AZS Left Panel Line 3", "CB PKT, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_JET_BOMB_GUV", 1, 3048, 607, "AZS Left Panel Line 3", "CB Emergency Jettison: Bombs and GUV, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_JET_PWR", 1, 3049, 608, "AZS Left Panel Line 3", "CB Emergency Jettison: Power, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_JET_ARM", 1, 3050, 609, "AZS Left Panel Line 3", "CB Emergency Jettison: Armed, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_SIG_FLARE", 1, 3051, 610, "AZS Left Panel Line 3", "CB Signal Flare, ON/OFF")

--AZS Right Panel Left Line 1
Mi_8MT:defineToggleSwitch("CB_APU_START", 1, 3052, 611, "AZS Right Panel Left Line 1", "CB APU Start, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_APU_IGN", 1, 3053, 612, "AZS Right Panel Left Line 1", "CB APU Ignition, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ENG_START", 1, 3054, 613, "AZS Right Panel Left Line 1", "CB Engine Start, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ENG_IGN", 1, 3055, 614, "AZS Right Panel Left Line 1", "CB Engine Ignition, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_RPM", 1, 3056, 615, "AZS Right Panel Left Line 1", "CB RPM CONTROL, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_NONAME", 1, 3057, 616, "AZS Right Panel Left Line 1", "CB NONAME, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_CTRL_MAIN", 1, 3058, 617, "AZS Right Panel Left Line 1", "CB Lock Opening Control Main, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_CTRL_RES", 1, 3059, 618, "AZS Right Panel Left Line 1", "CB Lock Opening Control Reserve, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_TURN", 1, 3060, 619, "AZS Right Panel Left Line 1", "CB TURN INDICATOR, ON/OFF")

--AZS Right Panel Left Line 2
Mi_8MT:defineToggleSwitch("CB_FUEL_BYPASS", 1, 3070, 629, "AZS Right Panel Left Line 2", "CB Fuel System: Bypass Valve, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FUEL_LEFT_VALVE", 1, 3071, 630, "AZS Right Panel Left Line 2", "CB Fuel System: Left Valve, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FUEL_RIGHT_VALVE", 1, 3072, 631, "AZS Right Panel Left Line 2", "CB Fuel System: Right Valve, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FUEL_METER", 1, 3073, 632, "AZS Right Panel Left Line 2", "CB Fuel System: Fuelmeter, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FUEL_CENTER_PUMP", 1, 3074, 633, "AZS Right Panel Left Line 2", "CB Fuel System: Center Tank Pump, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FUEL_LEFT_PUMP", 1, 3075, 634, "AZS Right Panel Left Line 2", "CB Fuel System: Left Tank Pump, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FUEL_RIGHT_PUMP", 1, 3076, 635, "AZS Right Panel Left Line 2", "CB Fuel System: Right Tank Pump, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_T819", 1, 3077, 636, "AZS Right Panel Left Line 2", "CB T-819, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_SPUU52", 1, 3078, 637, "AZS Right Panel Left Line 2", "CB SPUU-52, ON/OFF")

--AZS Right Panel Left Line 3
Mi_8MT:defineToggleSwitch("CB_LIGHTS_LEFT_CTRL", 1, 3088, 647, "AZS Right Panel Left Line 3", "CB Headlights: Left: Control, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_LIGHTS_LEFT_LIGHT", 1, 3089, 648, "AZS Right Panel Left Line 3", "CB Headlights: Left: Light, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_LIGHTS_RIGHT_CTRL", 1, 3090, 649, "AZS Right Panel Left Line 3", "CB Headlights: Right: Control, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_LIGHTS_RIGHT_LIGHT", 1, 3091, 650, "AZS Right Panel Left Line 3", "CB Headlights: Right: Light, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ANO", 1, 3092, 651, "AZS Right Panel Left Line 3", "CB ANO, ON/OFF")

Mi_8MT:defineToggleSwitch("CB_WING_LIGHTS", 1, 3093, 652, "AZS Right Panel Left Line 3", "CB Wing Lights, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_CHECK_LAMP", 1, 3094, 653, "AZS Right Panel Left Line 3", "CB Check Lamps/Flasher, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_PRF4_LEFT", 1, 3095, 918, "AZS Right Panel Left Line 3", "CB PRF-4 Light Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_PRF4_RIGHT", 1, 3096, 919, "AZS Right Panel Left Line 3", "CB PRF-4 Light Right, ON/OFF")

--AZS Right Panel Right Line 1
Mi_8MT:defineToggleSwitch("CB_AUTO_PILOT_MAIN", 1, 3061, 620, "AZS Right Panel Right Line 1", "CB Autopilot: Main, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_AUTO_PILOT_FRICTION", 1, 3062, 621, "AZS Right Panel Right Line 1", "CB Autopilot: Friction, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_AUTO_PILOT_CLUTCH", 1, 3063, 622, "AZS Right Panel Right Line 1", "CB Autopilot: Electric Clutches, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_HYDR_MAIN", 1, 3064, 623, "AZS Right Panel Right Line 1", "CB Hydraulics: Main, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_HYDR_AUX", 1, 3065, 624, "AZS Right Panel Right Line 1", "CB Hydraulics: Auxiliary, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_SPU", 1, 3066, 625, "AZS Right Panel Right Line 1", "CB Radio: SPU (Intercom), ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ALTIMETER", 1, 3067, 626, "AZS Right Panel Right Line 1", "CB Radio: Altimeter, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_R863", 1, 3068, 627, "AZS Right Panel Right Line 1", "CB Radio: Command Radio Station (R-863), ON/OFF")
Mi_8MT:defineToggleSwitch("CB_6201", 1, 3069, 628, "AZS Right Panel Right Line 1", "CB Radio: 6201, ON/OFF")

--AZS Right Panel Right Line 2
Mi_8MT:defineToggleSwitch("CB_FIRE_SIG", 1, 3079, 638, "AZS Right Panel Right Line 2", "CB Fire Protection System: Signalization, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FIRE_1_LEFT", 1, 3080, 639, "AZS Right Panel Right Line 2", "CB Fire Protection System: 1 Queue Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FIRE_1_RIGHT", 1, 3081, 640, "AZS Right Panel Right Line 2", "CB Fire Protection System: 1 Queue Right, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FIRE_2_LEFT", 1, 3082, 641, "AZS Right Panel Right Line 2", "CB Fire Protection System: 2 Queue Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_FIRE_2_RIGHT", 1, 3083, 642, "AZS Right Panel Right Line 2", "CB Fire Protection System: 2 Queue Right, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ARC9", 1, 3084, 643, "AZS Right Panel Right Line 2", "CB Radio: Radio Compass MW(ARC-9), ON/OFF")
Mi_8MT:defineToggleSwitch("CB_ARCUD", 1, 3085, 644, "AZS Right Panel Right Line 2", "CB Radio: Radio Compass VHF(ARC-UD), ON/OFF")
Mi_8MT:defineToggleSwitch("CB_DOPPLER", 1, 3086, 645, "AZS Right Panel Right Line 2", "CB Radio: Doppler Navigator, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_RADIO_METER", 1, 3087, 646, "AZS Right Panel Right Line 2", "CB Radio: Radio Meter, ON/OFF")

--AZS Right Panel Right Line 3
Mi_8MT:defineToggleSwitch("CB_DFRST_CTRL", 1, 3097, 656, "AZS Right Panel Right Line 3", "CB Defrost System: Control, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_DFRST_LEFT", 1, 3098, 657, "AZS Right Panel Right Line 3", "CB Defrost System: Left Engine, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_DFRST_RIGHT", 1, 3099, 658, "AZS Right Panel Right Line 3", "CB Defrost System: Right Engine, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_DFRST_RIO3", 1, 3100, 659, "AZS Right Panel Right Line 3", "CB Defrost System: RIO-3, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_DFRST_GLASS", 1, 3101, 660, "AZS Right Panel Right Line 3", "CB Defrost System: Glass, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_WPR_LEFT", 1, 3102, 661, "AZS Right Panel Right Line 3", "CB Wiper Left, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_WPR_RIGHT", 1, 3103, 662, "AZS Right Panel Right Line 3", "CB Wiper Right, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_RIO3", 1, 3104, 663, "AZS Right Panel Right Line 3", "CB RIO-3, ON/OFF")
Mi_8MT:defineToggleSwitch("CB_KO50", 1, 3105, 664, "AZS Right Panel Right Line 3", "CB Heater KO-50, ON/OFF")

--AZS PANEL GROUP BUTTONS
Mi_8MT:definePushButton("AZS_GRP_BTN1", 1, 3022, 882, "AZS Panel Group Buttons", "Group 1 On")
Mi_8MT:definePushButton("AZS_GRP_BTN4", 1, 3025, 883, "AZS Panel Group Buttons", "Group 4 On")
Mi_8MT:definePushButton("AZS_GRP_BTN7", 1, 3028, 884, "AZS Panel Group Buttons", "Group 7 On")
Mi_8MT:definePushButton("AZS_GRP_BTN2", 1, 3023, 885, "AZS Panel Group Buttons", "Group 2 On")
Mi_8MT:definePushButton("AZS_GRP_BTN5", 1, 3026, 886, "AZS Panel Group Buttons", "Group 5 On")
Mi_8MT:definePushButton("AZS_GRP_BTN8", 1, 3029, 887, "AZS Panel Group Buttons", "Group 8 On")
Mi_8MT:definePushButton("AZS_GRP_BTN3", 1, 3024, 888, "AZS Panel Group Buttons", "Group 3 On")
Mi_8MT:definePushButton("AZS_GRP_BTN6", 1, 3027, 889, "AZS Panel Group Buttons", "Group 6 On")
Mi_8MT:definePushButton("AZS_GRP_BTN9", 1, 3030, 890, "AZS Panel Group Buttons", "Group 9 On")

--FUEL SYSTEM
Mi_8MT:defineToggleSwitch("FUEL_FEED_PUMP", 2, 3006, 438, "Fuel System", "Feed Tank Pump Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("FUEL_LEFT_PUMP", 2, 3003, 439, "Fuel System", "Left Tank Pump Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("FUEL_RIGTH_PUMP", 2, 3005, 440, "Fuel System", "Right Tank Pump Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("FUEL_LEFT_SHUTOFF", 2, 3001, 427, "Fuel System", "Left Shutoff Valve Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("FUEL_RIGTH_SHUTOFF", 2, 3002, 429, "Fuel System", "Right Shutoff Valve Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("FUEL_LEFT_COVER", 2, 3009, 426, "Fuel System", "Left Shutoff Valve Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("FUEL_RIGHT_COVER", 2, 3010, 428, "Fuel System", "Right Shutoff Valve Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("FUEL_CROSSFEED", 2, 3004, 431, "Fuel System", "Crossfeed Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("FUEL_CROSSFEED_COVER", 2, 3011, 430, "Fuel System", "Crossfeed Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("FUEL_BYPASS", 2, 3007, 433, "Fuel System", "Bypass Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("FUEL_BYPASS_COVER", 2, 3012, 432, "Fuel System", "Bypass Switch Cover, OPEN/CLOSE")
Mi_8MT:defineTumb("FUEL_REFUEL", 2, 3014, 437, 0.5, { 0, 1 }, nil, false, "Fuel System", "Refueling Control Switch, REFUEL/OFF/CHECK")

--Engine start panel - APU Launch Panel
Mi_8MT:define3PosTumb("APU_START_MODE", 3, 3012, 412, "APU Launch Panel", "APU Start Mode Switch, START/COLD CRANKING/FALSE START")
Mi_8MT:definePushButton("APU_START", 3, 3026, 413, "APU Launch Panel", "APU Start Button - Push to start APU")
Mi_8MT:definePushButton("APU_STOP", 3, 3007, 415, "APU Launch Panel", "APU Stop Button - Push to stop APU")

--Engine start panel - Engines Launch Panel
Mi_8MT:definePushButton("ENG_START", 3, 3005, 419, "Engines Launch Panel", "Engine Start Button - Push to start engine")
Mi_8MT:definePushButton("ENG_ABORT_START", 3, 3006, 421, "Engines Launch Panel", "Abort Start Engine Button - Push to abort start")
Mi_8MT:define3PosTumb("ENG_SEL", 3, 3008, 422, "Engines Launch Panel", "Engine Selector Switch, LEFT/OFF/RIGHT")
Mi_8MT:define3PosTumb("ENG_START_MODE", 3, 3027, 423, "Engines Launch Panel", "Engine Start Mode Switch, START/OFF/COLD CRANKING")
Mi_8MT:define3PosTumb("ENG_IGN_CHK", 3, 3074, 425, "Engines Launch Panel", "Engine Ignition Check Switch, LEFT/OFF/RIGHT")

--Engine management
Mi_8MT:defineToggleSwitch("ENG_LEFT_STOP", 3, 3009, 204, "Engines management", "Left Engine Stop Lever")
Mi_8MT:defineToggleSwitch("ENG_RIGHT_STOP", 3, 3010, 206, "Engines management", "Right Engine Stop Lever")
Mi_8MT:defineToggleSwitch("ENG_RTR_BRAKE", 3, 3011, 208, "Engines management", "Rotor Brake Handle, UP/DOWN")
Mi_8MT:definePushButton("ENG_VBR_SENS_TEST", 3, 3020, 310, "Engines management", "Vibration Sensor Test Button - Push to test")
Mi_8MT:definePushButton("ENG_COLD_TMP_SENS_TEST", 3, 3023, 311, "Engines management", "Cold Temperature Sensor Test Button - Push to test")
Mi_8MT:definePushButton("ENG_HOT_TMP_SENS_TEST", 3, 3022, 312, "Engines management", "Hot Temperature Sensor Test Button - Push to test")
Mi_8MT:definePushButton("ENG_LEFT_REG_TEMP_TEST", 3, 3019, 313, "Engines management", "Left Engine Temperature Regulator Test Button - Push to test")
Mi_8MT:definePushButton("ENG_RIGHT_REG_TEMP_TEST", 3, 3020, 314, "Engines management", "Right Engine Temperature Regulator Test Button - Push to test")
Mi_8MT:define3PosTumb("ENG_LEFT_FREE_TURB_RPM", 3, 3063, 202, "Engines management", "Readjust Left Free Turbine RPM Switch, MORE/OFF/LESS")
Mi_8MT:define3PosTumb("ENG_RIGHT_FREE_TURB_RPM", 3, 3064, 867, "Engines management", "Readjust Right Free Turbine RPM Switch, MORE/OFF/LESS")

--Center Console
Mi_8MT:defineToggleSwitch("ENG_LEFT_ECC", 3, 3001, 167, "Center Console", "Left Engine EEC Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("ENG_RIGHT_ECC", 3, 3003, 173, "Center Console", "Right Engine EEC Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("ENG_LEFT_ER", 3, 3052, 168, "Center Console", "Left Engine ER Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("ENG_RIGHT_ER", 3, 3053, 172, "Center Console", "Right Engine ER Switch, ON/OFF")
Mi_8MT:define3PosTumb("ENG_LEFT_FT_CHECK", 3, 3050, 169, "Center Console", "Left Engine FT Check Switch, ST1/WORK/ST2")
Mi_8MT:define3PosTumb("ENG_RIGHT_FT_CHECK", 3, 3051, 171, "Center Console", "Right Engine FT Check Switch, ST1/WORK/ST2")
Mi_8MT:define3PosTumb("ENG_CT_CHECK", 3, 3054, 170, "Center Console", "CT Check Switch, RIGHT/WORK/LEFT")

--Hydraulic system
Mi_8MT:defineToggleSwitch("HYDR_MAIN_SWITCH", 4, 3001, 406, "Hydraulic system", "Main Hydraulic Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("HYDR_AUX_SWITCH", 4, 3002, 410, "Hydraulic system", "Auxiliary Hydraulic Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("HYDR_AUX_COVER", 4, 3006, 409, "Hydraulic system", "Auxiliary Hydraulic Switch Cover, OPEN/CLOSE")
Mi_8MT:definePushButton("HYDR_AUX_OFF", 4, 3003, 411, "Hydraulic system", "Auxiliary Hydraulic Shut Off Button - Push to shut off")

--Autopilot
Mi_8MT:definePushButton("AUTOPILOT_HDG_ON", 16, 3003, 134, "Autopilot", "Autopilot Heading ON Button")
Mi_8MT:definePotentiometer("AUTOPILOT_HDG_ON_LMP", 16, 3019, 868, { 0, 1 }, "Autopilot", "Autopilot Heading ON Lamp Dimmer")
Mi_8MT:definePushButton("AUTOPILOT_HDG_OFF", 16, 3005, 135, "Autopilot", "Autopilot Heading OFF Button")
Mi_8MT:definePotentiometer("AUTOPILOT_HDG_OFF_LMP", 16, 3020, 869, { 0, 1 }, "Autopilot", "Autopilot Heading OFF Lamp Dimmer")
Mi_8MT:definePushButton("AUTOPILOT_PITCH_ROLL_ON", 16, 3002, 138, "Autopilot", "Autopilot Pitch / Roll ON Button")
Mi_8MT:definePotentiometer("AUTOPILOT_PITCH_ROLL_ON_LMP", 16, 3020, 870, { 0, 1 }, "Autopilot", "Autopilot Pitch / Roll ON Lamp Dimmer")
Mi_8MT:definePushButton("AUTOPILOT_ALT_ON", 16, 3001, 144, "Autopilot", "Autopilot Altitude ON Button")
Mi_8MT:definePotentiometer("AUTOPILOT_ALT_ON_LMP", 16, 3022, 871, { 0, 1 }, "Autopilot", "Autopilot Altitude ON Lamp Dimmer")
Mi_8MT:definePushButton("AUTOPILOT_ALT_OFF", 16, 3004, 145, "Autopilot", "Autopilot Altitude OFF Button")
Mi_8MT:definePotentiometer("AUTOPILOT_ALT_OFF_LMP", 16, 3023, 872, { 0, 1 }, "Autopilot", "Autopilot Altitude OFF Lamp Dimmer")
Mi_8MT:define3PosTumb("AUTOPILOT_ALT_CHNL", 16, 3007, 146, "Autopilot", "Autopilot Altitude Channel Control")
Mi_8MT:defineRotary("AUTOPILOT_HDG_ADJ", 16, 3009, 136, "Autopilot", "Autopilot Heading Adjustment Knob")
Mi_8MT:defineRotary("AUTOPILOT_ROLL_ADJ", 16, 3008, 140, "Autopilot", "Autopilot Roll Adjustment Knob")
Mi_8MT:defineRotary("AUTOPILOT_PITCH_ADJ", 16, 3010, 142, "Autopilot", "Autopilot Pitch Adjustment Knob")
Mi_8MT:definePushButton("AUTOPILOT_OFF_LEFT", 16, 3029, 183, "Autopilot", "Autopilot Off Left Button")
Mi_8MT:definePushButton("AUTOPILOT_OFF_RIGHT", 16, 3030, 226, "Autopilot", "Autopilot Off Right Button")
Mi_8MT:define3PosTumb("AUTOPILOT_TRM_LEFT", 16, 3031, 184, "Autopilot", "Trimmer Left Button")
Mi_8MT:define3PosTumb("AUTOPILOT_TRM_RIGHT", 16, 3032, 227, "Autopilot", "Trimmer Right Button")

--Radar altimeter
Mi_8MT:definePushButton("RADAR_ALT_TEST", 18, 3002, 32, "Radar altimeter", "Radio Altimeter Test Button - Push to test")
Mi_8MT:defineRotary("RADAR_ALT_DANGER_ALT", 18, 3001, 29, "Autopilot", "Dangerous RALT Knob")
Mi_8MT:defineToggleSwitch("RADAR_ALT_PWR", 18, 3003, 35, "Radar altimeter", "Radar Altimeter Power Switch, ON/OFF")

--WEAPONS
Mi_8MT:defineToggleSwitch("WPN_ARM", 12, 3027, 921, "Weapons", "Weapon Safe/Armed Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_EMGR_EXPLODE", 12, 3007, 707, "Weapons", "Emergency Explode Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_EMGR_EXPLODE_COVER", 12, 3049, 706, "Weapons", "Emergency Explode Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("WPN_EMGR_BMB_RLS", 12, 3032, 709, "Weapons", "Emergency Bomb Release Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_EMGR_BMB_RLS_COVER", 12, 3050, 708, "Weapons", "Emergency Bomb Release Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("WPN_BOMBS_SWITCH", 12, 3002, 717, "Weapons", "Main Bombs Switch, ON/OFF")
Mi_8MT:definePushButton("WPN_BOMBS_CHECK", 12, 3014, 718, "Weapons", "Lamps Check Button - Push to check")
Mi_8MT:defineToggleSwitch("WPN_ESBR_HEAT", 12, 3012, 720, "Weapons", "ESBR Heating Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_ESBR_SWITCH", 12, 3028, 731, "Weapons", "ESBR Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_EMG_EXPLODE", 12, 3004, 570, "Weapons", "Emergency Explode Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_EMG_RLS", 12, 3005, 572, "Weapons", "Emergency Release Switch")
Mi_8MT:defineToggleSwitch("WPN_EMG_EXPLODE_COVER", 12, 3051, 569, "Weapons", "Emergency Explode Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("WPN_EMG_RLS_COVER", 12, 3052, 571, "Weapons", "Emergency Release Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("WPN_RS_GUV_SEL", 12, 3030, 575, "Weapons", "RS/GUV Selector Switch, ON/OFF")
Mi_8MT:definePushButton("WPN_LAMPS_CHK", 12, 3026, 576, "Weapons", "Lamps Check Button - Push to check")
Mi_8MT:definePushButton("WPN_PUS_ARM", 12, 3031, 574, "Weapons", "PUS Arming Button - Push to arm")
Mi_8MT:define3PosTumb("WPN_AMOUNT1", 12, 3020, 342, "Weapons", "8/16/4 Switch")
Mi_8MT:define3PosTumb("WPN_AMOUNT2", 12, 3020, 343, "Weapons", "1-2-5-6/AUTO/3-4 Switch")
Mi_8MT:define3PosTumb("WPN_SEL", 12, 3022, 344, "Weapons", "UPK/PKT/RS Switch")
Mi_8MT:define3PosTumb("WPN_CUTOFF", 12, 3006, 345, "Weapons", "CUTOFF Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_SEL2", 12, 3041, 349, "Weapons", "800_or_624_622_800 Switch")
Mi_8MT:defineToggleSwitch("WPN_SEL2_COVER", 12, 3053, 348, "Weapons", "800 or 624_622_800 Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("WPN_MINE_ARM", 12, 3076, 573, "Weapons", "Mine Arms Main Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("WPN_PKT_SEL", 12, 3077, 905, "Weapons", "PKT Selector Switch, FLIGHT ENGINEER/PILOT")
Mi_8MT:defineToggleSwitch("WPN_LEFT_RS_COVER", 12, 3084, 185, "Weapons", "Left Fire RS Button Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("WPN_RIGHT_RS_COVER", 12, 3085, 228, "Weapons", "Right Fire RS Button Cover, OPEN/CLOSE")
Mi_8MT:definePushButton("WPN_LEFT_RS_FIRE", 12, 3082, 186, "Weapons", "Left Fire RS Button")
Mi_8MT:definePushButton("WPN_RIGHT_RS_FIRE", 12, 3083, 229, "Weapons", "Right Fire RS Button")
Mi_8MT:defineToggleSwitch("WPN_GUN_CAM", 12, 3098, 352, "Weapons", "Gun Camera Switch, ON/OFF")

Mi_8MT:defineToggleSwitch("SAS_FLASH", 21, 3005, 523, "SAS", "Flasher Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("SAS_TRANS", 21, 3006, 525, "SAS", "Transparent Switch, DAY/NIGHT")
Mi_8MT:define3PosTumb("SAS_CHK", 21, 3007, 150, "SAS", "Check Switch, LAMPS/OFF/FLASHER")

Mi_8MT:defineToggleSwitch("SPUU52_PWR", 8, 3005, 332, "SPUU-52", "SPUU-52 Power Switch, ON/OFF")
Mi_8MT:definePushButton("SPUU52_ENGAGE", 8, 3001, 127, "SPUU-52", "SPUU-52 Control Engage Button")

Mi_8MT:definePushButton("DCHARGE_LEFT_ENG", 19, 3001, 389, "Something", "Main Discharge Left Engine Button")
Mi_8MT:definePushButton("DCHARGE_RIGHT_ENG", 19, 3002, 390, "Something", "Main Discharge Right Engine Button")
Mi_8MT:definePushButton("DCHARGE_KO50", 19, 3003, 391, "Something", "Main Discharge KO-50 Button")
Mi_8MT:definePushButton("DCHARGE_APU", 19, 3004, 392, "Something", "Main Discharge APU GEAR Button")
Mi_8MT:definePushButton("DCHARGE_ALT_LEFT_ENG", 19, 3005, 393, "Something", "Alternate Discharge Left Engine Button")
Mi_8MT:definePushButton("DCHARGE_ALT_RIGHT_ENG", 19, 3006, 394, "Something", "Alternate Discharge Right Engine Button")
Mi_8MT:definePushButton("DCHARGE_ALT_KO50", 19, 3007, 395, "Something", "Alternate Discharge KO-50 Button")
Mi_8MT:definePushButton("DCHARGE_ALT_APU", 19, 3008, 396, "Something", "Alternate Discharge APU GEAR Button")
Mi_8MT:definePushButton("DCHARGE_FIRE_BTN", 19, 3009, 397, "Something", "Turn Off Fire Signal Button")
Mi_8MT:defineToggleSwitch("DCHARGE_FIRE_DETECT_TEST", 19, 3010, 399, "Something", "Fire Detector Test Switch")
Mi_8MT:defineToggleSwitch("DCHARGE_SQUIB_TEST", 19, 3011, 400, "Something", "Squib Test Switch")

Mi_8MT:defineToggleSwitch("DEFROST_MODE", 3, 3030, 353, "Heating", "Defrost Mode Switch, AUTO/MANUAL")
Mi_8MT:definePushButton("DEFROST_OFF", 3, 3031, 354, "Heating", "Defrost OFF Button - Push to turn off")
Mi_8MT:defineToggleSwitch("DEFROST_LEFT_ENG_HEAT", 3, 3032, 355, "Heating", "Left Engine Heater Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("DEFROST_RIGHT_ENG_HEAT", 3, 3033, 356, "Heating", "Right Engine Heater Switch, MANUAL/AUTO")
Mi_8MT:defineToggleSwitch("DEFROST_GLASS_HEAT", 3, 3034, 357, "Heating", "Glass Heater Switch, MANUAL/AUTO")
Mi_8MT:defineToggleSwitch("DEFROST_ICE_DET", 3, 3035, 358, "Heating", "Ice Detector Heater Switch, MANUAL/AUTO")
Mi_8MT:definePushButton("DEFROST_ICE_DET_TEST", 3, 3036, 359, "Heating", "Ice Detector Heater Test Button - Push to test")
Mi_8MT:defineToggleSwitch("DEFROST_LEFT_PITOT", 3, 3038, 519, "Heating", "Left Pitot Heater Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("DEFROST_RIGHT_PITOT", 3, 3039, 520, "Heating", "Right Pitot Heater Switch, ON/OFF")
Mi_8MT:definePushButton("DEFROST_LEFT_PITOT_TEST", 3, 3040, 339, "Heating", "Left Pitot Heater Test Button - Push to test")
Mi_8MT:definePushButton("DEFROST_RIGHT_PITOT_TEST", 3, 3041, 482, "Heating", "Right Pitot Heater Test Button - Push to test")

Mi_8MT:defineToggleSwitch("DPL_PWR", 15, 3001, 483, "Navigation", "Doppler Navigator Power Switch, ON/OFF")
Mi_8MT:definePushButton("DPL_OFF_COORD", 15, 3002, 818, "Navigation", "Turn Off Coordinates Calculator Button")
Mi_8MT:definePushButton("DPL_ON_COORD", 15, 3003, 819, "Navigation", "Turn On Coordinates Calculator Button")
Mi_8MT:definePushButton("DPL_DEC_ANGLE", 15, 3004, 815, "Navigation", "Decrease Map Angle Button")
Mi_8MT:definePushButton("DPL_INC_ANGLE", 15, 3005, 816, "Navigation", "Increase Map Angle Button")
Mi_8MT:definePushButton("DPL_DEC_PATH", 15, 3006, 809, "Navigation", "Decrease Path KM Button")
Mi_8MT:definePushButton("DPL_INC_PATH", 15, 3007, 810, "Navigation", "Increase Path KM Button")
Mi_8MT:definePushButton("DPL_DEC_DEV", 15, 3008, 803, "Navigation", "Decrease Deviation KM Button")
Mi_8MT:definePushButton("DPL_INC_DEV", 15, 3009, 804, "Navigation", "Increase Deviation KM Button")

Mi_8MT:defineToggleSwitch("ADI_R_ATT_PWR", 7, 3004, 487, "ADI", "Right Attitude Indicator Power Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("ADI_L_ATT_PWR", 6, 3004, 335, "ADI", "Left Attitude Indicator Power Switch, ON/OFF")
Mi_8MT:definePushButton("ADI_L_ATT_KNOB", 6, 3002, 11, "ADI", "Left Attitude Indicator Cage Knob - Push to cage")
Mi_8MT:definePushButton("ADI_R_ATT_KNOB", 7, 3002, 90, "ADI", "Right Attitude Indicator Cage Knob - Push to cage")
Mi_8MT:defineToggleSwitch("ADI_VK53_PWR", 32, 3001, 336, "ADI", "VK-53 Power Switch, ON/OFF")

Mi_8MT:defineToggleSwitch("GMC_PWR", 14, 3001, 485, "GMC", "GMC Power Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("GMC_HEM_SEL", 14, 3002, 470, "GMC", "GMC Hemisphere Selection Switch, NORTH/SOUTH")
Mi_8MT:define3PosTumb("GMC_MODE", 14, 3004, 472, "GMC", "GMC Mode Switch, MC/DG/AC(N/F)")

Mi_8MT:defineToggleSwitch("ENG_L_ENG_DUST", 3, 3028, 517, "Engine Control", "Left Engine Dust Protection Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("ENG_R_ENG_DUST", 3, 3029, 518, "Engine Control", "Right Engine Dust Protection Switch, ON/OFF")

Mi_8MT:define3PosTumb("LGHT_ANO", 9, 3012, 513, "Lights", "ANO Switch, BRIGHT/OFF/DIM")
Mi_8MT:define3PosTumb("LGHT_FRM", 9, 3013, 514, "Lights", "Formation Lights Switch, BRIGHT/OFF/DIM")
Mi_8MT:defineToggleSwitch("LGHT_TIP", 9, 3014, 515, "Lights", "Tip Lights Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("LGHT_STROBE", 9, 3015, 516, "Lights", "Strobe Light Switch, ON/OFF")
Mi_8MT:definePushButton("LGHT_ANO_CODE", 9, 3016, 322, "Lights", "ANO Code Button")
Mi_8MT:defineToggleSwitch("LGHT_TAXI", 9, 3017, 836, "Lights", "Taxi Light Switch, ON/OFF")
Mi_8MT:define3PosTumb("LGHT_L_LAND", 9, 3018, 837, "Lights", "Left Landing Light Switch, LIGHT/OFF/RETRACT")
Mi_8MT:define3PosTumb("LGHT_R_LAND", 9, 3019, 838, "Lights", "Right Landing Light Switch, LIGHT/OFF/RETRACT")

Mi_8MT:define3PosTumb("LGHT_L_CEIL", 46, 3002, 333, "Lights", "Left Ceiling Light Switch, RED/OFF/WHITE")
Mi_8MT:define3PosTumb("LGHT_R_CEIL", 46, 3003, 489, "Lights", "Right Ceiling Light Switch, RED/OFF/WHITE")
Mi_8MT:defineToggleSwitch("LGHT_5_5V", 46, 3004, 479, "Lights", "5.5V Lights Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("LGHT_CARGO", 46, 3022, 511, "Lights", "Cargo Cabin Duty Lights Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("LGHT_CARGO2", 46, 3023, 512, "Lights", "Cargo Cabin Common Lights Switch, ON/OFF")

--SPU-7
Mi_8MT:defineToggleSwitch("SPU7_L_ICS", 36, 3004, 553, "SPU-7", "Radio/ICS Switch Left")
Mi_8MT:defineToggleSwitch("SPU7_L_NETWORK", 36, 3007, 551, "SPU-7", "Network 1/2 Switch (N/F) Left")
Mi_8MT:definePushButton("SPU7_L_CIRC_CALL", 36, 3008, 552, "SPU-7", "Circular Call Button (N/F) Left")
Mi_8MT:defineToggleSwitch("SPU7_R_ICS", 36, 3012, 845, "SPU-7", "Radio/ICS Switch Right")
Mi_8MT:defineToggleSwitch("SPU7_R_NETWORK", 36, 3013, 843, "SPU-7", "Network 1/2 Switch (N/F) Right")
Mi_8MT:definePushButton("SPU7_R_CIRC_CALL", 36, 3014, 846, "SPU-7", "Circular Call Button (N/F) Right")
Mi_8MT:defineToggleSwitch("SPU7_LARYNG", 36, 3006, 480, "SPU-7", "Laryngophone Switch, ON/OFF")

Mi_8MT:defineToggleSwitch("R863_MOD", 38, 3001, 369, "R-863", "R-863, Modulation Switch, FM/AM")

Mi_8MT:definePushButton("R828_TUNER", 39, 3003, 738, "R-828", "R-828, Radio Tuner Button")

Mi_8MT:defineToggleSwitch("JAD1A_PWR", 37, 3013, 484, "YaDRO-1A", "YaDRO-1A, Power Switch, ON/OFF")
Mi_8MT:definePushButton("JAD1A_CTRL", 37, 3009, 742, "YaDRO-1A", "YaDRO-1A, Control Button")

Mi_8MT:defineToggleSwitch("RI65_PWR", 11, 3006, 338, "RI-65", "RI-65 Power Switch, ON/OFF")
Mi_8MT:definePushButton("RI65_OFF", 11, 3005, 292, "RI-65", "RI-65 OFF Button")
Mi_8MT:definePushButton("RI65_RPT", 11, 3003, 293, "RI-65", "RI-65 Repeat Button")
Mi_8MT:definePushButton("RI65_CHK", 11, 3004, 294, "RI-65", "RI-65 Check Button")
Mi_8MT:defineToggleSwitch("RI65_AMP", 36, 3020, 295, "RI-65", "RI-65 Amplifier Switch, ON/OFF")

Mi_8MT:defineToggleSwitch("ARCUD_SENS", 41, 3002, 453, "ARC-UD", "ARC-UD, Sensitivity Switch, MORE/LESS")
Mi_8MT:defineToggleSwitch("ARCUD_WAVE", 41, 3003, 454, "ARC-UD", "ARC-UD, Wave Switch, MW/DW")
Mi_8MT:definePushButton("ARCUD_CTRL", 41, 3006, 672, "ARC-UD", "ARC-UD, Control Button")
Mi_8MT:definePushButton("ARCUD_L_ANT", 41, 3007, 673, "ARC-UD", "ARC-UD, Left Antenna Button")
Mi_8MT:definePushButton("ARCUD_R_ANT", 41, 3008, 674, "ARC-UD", "ARC-UD, Right Antenna Button")
Mi_8MT:defineToggleSwitch("ARCUD_LCK", 41, 3012, 481, "ARC-UD", "ARC-UD, Lock Switch, LOCK/UNLOCK")

Mi_8MT:defineToggleSwitch("PKV_DBL", 47, 3005, 0, "PKV Sight", "Sight Double")

Mi_8MT:defineToggleSwitch("CLOCK_HEAT", 45, 3006, 521, "Clock", "Clock Heating Switch, ON/OFF")

Mi_8MT:definePushButton("UV26_SEQ", 48, 3004, 914, "UV-26", "CMD Num of Sequences Button")
Mi_8MT:definePushButton("UV26_RST", 48, 3008, 864, "UV-26", "CMD Reset to Default Program Button")
Mi_8MT:definePushButton("UV26_STOP_DSP", 48, 3009, 865, "UV-26", "CMD Stop Dispense Button")

Mi_8MT:definePushButton("BLST_L_OPEN", 17, 3018, 213, "Cockpit", "Left Window, OPEN/CLOSE")
Mi_8MT:definePushButton("BLST_R_OPEN", 17, 3019, 214, "Cockpit", "Right Window, OPEN/CLOSE")

Mi_8MT:defineToggleSwitch("BRK_WHEEN", 17, 3017, 881, "Brakes", "Wheel Brakes Handle")
Mi_8MT:defineToggleSwitch("BRK_PARK", 17, 3024, 930, "Brakes", "Parking Brake Handle")
Mi_8MT:definePushButton("ACC_RST", 17, 3006, 925, "Something", "Accelerometer Reset Button - Push to reset")
Mi_8MT:defineToggleSwitch("CPIT_AIR_L_FAN", 17, 3020, 334, "Cockpit Air", "Left Fan Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("CPIT_AIR_R_FAN", 17, 3021, 488, "Cockpit Air", "Right Fan Switch, ON/OFF")

Mi_8MT:defineToggleSwitch("ARC9_MAIN_BACKUP", 40, 3011, 469, "ARC-9", "ARC-9, Dialer Switch, MAIN/BACKUP")
Mi_8MT:defineToggleSwitch("ARC9_TLF_TLG", 40, 3002, 444, "ARC-9", "ARC-9, TLF/TLG Switch")

Mi_8MT:defineToggleSwitch("CARGO_RLS_CVR", 51, 3002, 199, "External Cargo Equipment", "Tactical Cargo Release Button Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("CARGO_EMG_RLS_CVR", 51, 3004, 197, "External Cargo Equipment", "Emergency Cargo Release Button Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("CARGO_AUTO_DROP", 51, 3005, 324, "External Cargo Equipment", "External Cargo Automatic Dropping, ON/OFF")

Mi_8MT:defineToggleSwitch("SIG_CASS_1", 52, 3001, 282, "Signal Flares", "Signal Flares Cassette 1 Power Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("SIG_CASS_2", 52, 3006, 283, "Signal Flares", "Signal Flares Cassette 2 Power Switch, ON/OFF")

Mi_8MT:definePushButton("KO50_START", 53, 3001, 464, "KO-50", "KO-50 Heater Start Button - Push to start")
Mi_8MT:defineToggleSwitch("KO50_FAN", 53, 3002, 467, "KO-50", "KO-50 Fan Switch, ON/OFF")
Mi_8MT:define3PosTumb("KO50_MODE", 53, 3003, 465, "KO-50", "KO-50 Heater Mode Switch, MANUAL/OFF/AUTO")
Mi_8MT:define3PosTumb("KO50_REGIME", 53, 3004, 466, "KO-50", "KO-50 Heater Regime Switch, FILLING/FULL/MEDIUM")

Mi_8MT:defineToggleSwitch("SARPP_MODE", 55, 3001, 315, "SARPP", "SARPP-12 Mode Switch, MANUAL/AUTO")

Mi_8MT:defineToggleSwitch("P503B_PWR", 56, 3001, 305, "Recorder P-503B", "Recorder P-503B Power Switch, ON/OFF")

Mi_8MT:defineToggleSwitch("IFF_SEL", 57, 3002, 301, "IFF", "IFF Transponder Device Selector Switch, WORK/RESERVE")
Mi_8MT:defineToggleSwitch("IFF_MODE", 57, 3003, 300, "IFF", "IFF Transponder Device Mode Switch, 1/2")
Mi_8MT:defineToggleSwitch("IFF_ERASE_COVER", 57, 3004, 296, "IFF", "IFF Transponder Erase Button Cover, OPEN/CLOSE")
Mi_8MT:definePushButton("IFF_ERASE", 57, 3005, 297, "IFF", "IFF Transponder Erase Button - Push to erase")
Mi_8MT:defineToggleSwitch("IFF_DIS_COVER", 57, 3006, 298, "IFF", "IFF Transponder Disaster Switch Cover, OPEN/CLOSE")
Mi_8MT:defineToggleSwitch("IFF_DIS", 57, 3007, 299, "IFF", "IFF Transponder Disaster Switch, ON/OFF")

Mi_8MT:definePushButton("JMP_SIREN", 20, 3001, 323, "Jump Siren", "Alarm Bell Button - Push to turn on")

Mi_8MT:defineRotary("BAR_L_QFE", 26, 3001, 18, "Bariometer", "Baro Pressure QFE Knob")
Mi_8MT:defineRotary("BAR_R_QFE", 27, 3001, 97, "Bariometer", "Baro Pressure QFE Knob")

Mi_8MT:defineRotary("VAR_L_ADJ", 30, 3001, 17, "Variometer", "Variometer Adjustment Knob")
Mi_8MT:defineRotary("VAR_R_ADJ", 31, 3001, 96, "Variometer", "Variometer Adjustment Knob")

Mi_8MT:defineRotary("HSI_L_CRS", 34, 3001, 26, "HSI", "HSI Course Set Knob")
Mi_8MT:defineRotary("HSI_R_CRS", 35, 3001, 102, "HSI", "HSI Course Set Knob")
Mi_8MT:defineRotary("SPUU52_ADJ", 8, 3002, 128, "SPUU-52", "SPUU-52 Adjustment Knob")

Mi_8MT:defineToggleSwitch("HSI_COMP_SEL", 34, 3003, 858, "HSI", "HSI Radio Compass Selector Switch, ARC-9/ARC-UD")
Mi_8MT:defineToggleSwitch("MISC_TST_WORK", 15, 3011, 797, "Misc", "Test/Work Switch")
Mi_8MT:defineToggleSwitch("MISC_LAND_SEA", 15, 3012, 798, "Misc", "Land/Sea Switch")
Mi_8MT:defineToggleSwitch("R863_UNIT_SWITCH", 38, 3002, 132, "R-863", "R-863, Unit Switch, DIAL/MEMORY")
Mi_8MT:defineToggleSwitch("R863_SQL_SWITCH", 38, 3004, 155, "R-863", "R-863, Squelch Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("R863_EMG_RCVR", 38, 3010, 153, "R-863", "R-863, Emergency Receiver Switch, ON/OFF (N/F)")
Mi_8MT:defineToggleSwitch("R863_ARC", 38, 3011, 154, "R-863", "R-863, ARC Switch, ON/OFF (N/F)")
Mi_8MT:defineToggleSwitch("R828_SQL_SWITCH", 39, 3004, 739, "R-828", "R-828, Squelch Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("R828_PWR", 39, 3005, 756, "R-828", "R-828, Power Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("R828_COMP_SWITCH", 39, 3006, 757, "R-828", "R-828, Compass Switch, COMM/NAV")
Mi_8MT:defineToggleSwitch("CMD_PWR", 48, 3010, 910, "CMD", "CMD Power Switch, ON/OFF")
Mi_8MT:defineToggleSwitch("CMD_FLRS_AMOUNT", 48, 3003, 913, "CMD", "CMD Flares Amount Switch, COUNTER/PROGRAMMING")

-- Mi_8MT:defineTumb("AC_VOLT_SEL", 1, 3017, 535, 0.1, { 0, 1 }, nil, false, "Electrical system", "AC Voltmeter Selector") -- duplicate
Mi_8MT:reserveIntValue(10)
Mi_8MT:defineTumb("FUEL_METER_SWITCH", 2, 3008, 61, 0.1, { 0, 0.5 }, nil, false, "FUEL", "Fuel Meter Switch, OFF/SUM/LEFT/RIGHT/FEED/ADDITIONAL")
Mi_8MT:defineTumb("POD_VAR_SEL", 12, 3013, 719, 0.1, { 0, 0.5 }, nil, false, "PODS", "Pod Variants Selector Switch")
Mi_8MT:defineTumb("ESBR_POS", 12, 3029, 730, 0.0555, { 0, 0.8325 }, nil, false, "ESBR", "ESBR Position Selector Switch")
Mi_8MT:defineTumb("POD_SEL_SWITH", 12, 3042, 347, 0.1, { 0, 0.3 }, nil, false, "PODS", "In800Out/800inOr624/622 Switch")
Mi_8MT:defineTumb("PYRO_L", 12, 3044, 350, 0.1, { 0, 0.3 }, nil, false, "PODS", "Left PYROCARTRIDGE Switch, I/II/III")
Mi_8MT:defineTumb("PYRO_R", 12, 3045, 351, 0.1, { 0, 0.3 }, nil, false, "PODS", "Right PYROCARTRIDGE Switch, I/II/III")
Mi_8MT:defineTumb("FIRE_CHECK_CIRC", 19, 3012, 401, 0.1, { 0, 0.7 }, nil, false, "FIRE", "Check Fire Circuits Switch, OFF/CONTROL/1/2/3/4/5/6")
Mi_8MT:defineTumb("DFRST_AMP_SEL", 3, 3037, 372, 0.1, { 0, 0.9 }, nil, false, "HEATING", "Defrost System Amperemeter Selector Switch")
Mi_8MT:defineTumb("DOP_NAV_MODE", 15, 3010, 826, 0.1, { 0, 0.4 }, nil, false, "Navigation", "Doppler Navigator Mode Switch")
Mi_8MT:defineTumb("RADIO_SEL_L", 36, 3003, 550, 0.1, { 0, 0.5 }, nil, false, "SPU-7", "Radio Source Selector Switch, R-863/JADRO-1A/R-828/NF/ARC-9/ARC-UD Left")
Mi_8MT:defineTumb("RADIO_SEL_R", 36, 3011, 842, 0.1, { 0, 0.5 }, nil, false, "SPU-7", "Radio Source Selector Switch, R-863/JADRO-1A/R-828/NF/ARC-9/ARC-UD Right")
Mi_8MT:defineTumb("JADR1A_MODE", 37, 3001, 744, 0.5, { -0.5, 1 }, nil, false, "YaDRO-1A", "YaDRO-1A, Mode Switch, OFF/OM/AM")
Mi_8MT:defineTumb("ARCUD_MODE", 41, 3001, 456, 0.1, { 0, 0.4 }, nil, false, "ARC-UD", "ARC-UD, Mode Switch, OFF/NARROW/WIDE/PULSE/RC")
Mi_8MT:defineTumb("ARCUD_CHL", 41, 3004, 457, 0.1, { 0, 0.5 }, nil, false, "ARC-UD", "ARC-UD, Channel Selector Switch, 1/2/3/4/5/6")
Mi_8MT:defineTumb("ARC9_MODE", 40, 3003, 446, 0.1, { 0, 0.3 }, nil, false, "ARC-9", "ARC-9, Mode Selector Switch, OFF/COMP/ANT/LOOP")

Mi_8MT:definePotentiometer("NAV_L_ATT_KNOB", 6, 3003, 10, { 0, 1 }, "Navigation", "Left Attitude Indicator Zero Pitch Knob")
Mi_8MT:definePotentiometer("WPN_BURST_LEN", 12, 3043, 346, { 0, 1 }, "Weapons", "Burst Length Knob")
Mi_8MT:definePotentiometer("NAV_R_ATT_KNOB", 7, 3003, 89, { 0, 1 }, "Navigation", "Right Attitude Indicator Zero Pitch Knob")
Mi_8MT:definePotentiometer("NAV_GMC_LAT_SEL", 14, 3006, 474, { 0, 0.728 }, "Navigation", "GMC Latitude Selection Knob")
Mi_8MT:definePotentiometer("L_RED_LGHT_1", 46, 3005, 280, { 0, 1 }, "Lights", "Left Red Lights Brightness Group 1 Rheostat")
Mi_8MT:definePotentiometer("L_RED_LGHT_2", 46, 3006, 281, { 0, 1 }, "Lights", "Left Red Lights Brightness Group 2 Rheostat")
Mi_8MT:definePotentiometer("R_RED_LGHT_1", 46, 3007, 491, { 0, 1 }, "Lights", "Right Red Lights Brightness Group 1 Rheostat")
Mi_8MT:definePotentiometer("R_RED_LGHT_2", 46, 3008, 492, { 0, 1 }, "Lights", "Right Red Lights Brightness Group 2 Rheostat")
Mi_8MT:definePotentiometer("C_RED_LGHT_1", 46, 3009, 894, { 0, 1 }, "Lights", "Central Red Lights Brightness Group 1 Rheostat")
Mi_8MT:definePotentiometer("C_RED_LGHT_2", 46, 3010, 895, { 0, 1 }, "Lights", "Central Red Lights Brightness Group 2 Rheostat")
Mi_8MT:definePotentiometer("LGHT_55V", 46, 3011, 924, { 0, 1 }, "Lights", "Lights Brightness 5.5V Rheostat")
Mi_8MT:definePotentiometer("SGHT_KNOB", 47, 3003, 855, { 0, 0.807 }, "Weapons", "Sight Limb Knob")
Mi_8MT:definePotentiometer("ARC9_BCK_TUNE", 40, 3004, 449, { -0.2, 0.4 }, "ARC-9", "ARC-9, Backup Frequency Tune Knob")
Mi_8MT:definePotentiometer("ARC9_MAIN_TUNE", 40, 3007, 451, { -0.2, 0.4 }, "ARC-9", "ARC-9, Main Frequency Tune Knob")
Mi_8MT:definePotentiometer("KO50_TRG_TEMP", 53, 3005, 468, { 0, 1 }, "KO-50", "KO-50 Target Temperature Knob")
Mi_8MT:definePotentiometer("FR_BCK_LGHT", 56, 3002, 308, { 0, 0.8 }, "P-503B", "Recorder P-503B Backlight Brightness Knob")

Mi_8MT:definePotentiometer("VOL_KNOB_L", 36, 3009, 841, { 0, 1 }, "Radio Volume", "Common Volume Knob Left")
Mi_8MT:definePotentiometer("VOL_KNOB_R", 36, 3001, 549, { 0, 1 }, "Radio Volume", "Common Volume Knob Right")
Mi_8MT:definePotentiometer("LST_VOL_KNOB_L", 36, 3002, 548, { 0, 1 }, "Radio Volume", "Listening Volume Knob Left")
Mi_8MT:definePotentiometer("LST_VOL_KNOB_R", 36, 3010, 840, { 0, 1 }, "Radio Volume", "Listening Volume Knob Right")
Mi_8MT:definePotentiometer("R863_VOL", 38, 3005, 156, { 0, 1 }, "Radio Volume", "R-863, Volume Knob")
Mi_8MT:definePotentiometer("R828_VOL", 39, 3002, 737, { 0, 1 }, "Radio Volume", "R-828, Volume Knob")
Mi_8MT:definePotentiometer("JADR1A_VOL", 37, 3007, 743, { 0, 1 }, "Radio Volume", "YaDRO-1A, Volume Knob")
Mi_8MT:definePotentiometer("ARCUD_VOL", 41, 3005, 455, { 0, 1 }, "Radio Volume", "ARC-UD, Volume Knob")
Mi_8MT:definePotentiometer("SGT_BRIGHT", 47, 3001, 589, { 0, 1 }, "Weapons", "Sight Brightness Knob")
Mi_8MT:definePotentiometer("ARC9_VOL", 40, 3001, 448, { 0, 1 }, "Radio Volume", "ARC-9, Volume Knob")

Mi_8MT:define3PosTumb("SPUU52_TEST", 8, 3003, 129, "SPUU-52", "SPUU-52 Test Switch, P/OFF/t)")
Mi_8MT:define3PosTumb("GMC_CTRL_SWITCH", 14, 3003, 476, "GMC", "GMC Control Switch, 0/CONTROL/300")
Mi_8MT:define3PosTumb("GMC_CRS_SWITCH", 14, 3005, 477, "GMC", "GMC Course Setting Switch, CCW/OFF/CW)")
Mi_8MT:defineTumb("R863_CNL_SEL", 38, 3003, 370, 0.05, { 0, 0.949768 }, nil, false, "R-863", "R-863, Radio Channel Selector Knob")

Mi_8MT:defineFixedStepTumb("R863_FREQ1", 38, 3006, 157, 0.01, { 0, 0.23 }, { -0.1, 0.1 }, nil, "R-863", "R-863, 10MHz Rotary Knob")
Mi_8MT:defineFixedStepTumb("R863_FREQ2", 38, 3007, 158, 0.1, { 0, 1 }, { -0.1, 0.1 }, nil, "R-863", "R-863, 1MHz Rotary Knob")
Mi_8MT:defineFixedStepTumb("R863_FREQ3", 38, 3008, 159, 0.1, { 0, 1 }, { -0.1, 0.1 }, nil, "R-863", "R-863, 100KHz Rotary Knob")
Mi_8MT:defineFixedStepTumb("R863_FREQ4", 38, 3009, 160, 0.25, { 0, 1 }, { -0.1, 0.1 }, nil, "R-863", "R-863, 1KHz Rotary Knob")

Mi_8MT:defineTumb("R828_PRST_CHAN_SEL", 39, 3001, 735, 0.1, { 0, 0.9 }, nil, false, "R-828", "R-828, Radio Channel Selector Knob")

Mi_8MT:defineFixedStepTumb("YADRO1A_FREQ1", 37, 3002, 745, 0.1, { 0, 1 }, { -0.1, 0.1 }, nil, "YaDRO-1A", "YaDRO-1A, Frequency Selector, 1MHz")
Mi_8MT:defineFixedStepTumb("YADRO1A_FREQ2", 37, 3003, 746, 0.1, { 0, 1 }, { -0.1, 0.1 }, nil, "YaDRO-1A", "YaDRO-1A, Frequency Selector, 100kHz")
Mi_8MT:defineFixedStepTumb("YADRO1A_FREQ3", 37, 3004, 747, 0.1, { 0, 1 }, { -0.1, 0.1 }, nil, "YaDRO-1A", "YaDRO-1A, Frequency Selector, 10kHz")
Mi_8MT:defineFixedStepTumb("YADRO1A_FREQ4", 37, 3005, 748, 0.1, { 0, 1 }, { -0.1, 0.1 }, nil, "YaDRO-1A", "YaDRO-1A, Frequency Selector, 1kHz")
Mi_8MT:defineFixedStepTumb("YADRO1A_FREQ5", 37, 3006, 749, 0.1, { 0, 1 }, { -0.1, 0.1 }, nil, "YaDRO-1A", "YaDRO-1A, Frequency Selector, 100Hz")
Mi_8MT:defineTumb("YADRO1A_SQL", 37, 3008, 741, 0.7, { 0, 0.7 }, nil, false, "YaDRO-1A", "YaDRO-1A, Squelch Switch")

local function getYadro1AFrequency(dev0)
	local yfreq1 = string.format("%.0f", dev0:get_argument_value(750) * 10)
	if yfreq1 == "10" then
		yfreq1 = "0"
	end
	local yfreq2 = string.format("%.0f", dev0:get_argument_value(745) * 10)
	if yfreq2 == "10" then
		yfreq2 = "0"
	end
	local yfreq3 = string.format("%.0f", dev0:get_argument_value(746) * 10)
	if yfreq3 == "10" then
		yfreq3 = "0"
	end
	local yfreq4 = string.format("%.0f", dev0:get_argument_value(747) * 10)
	if yfreq4 == "10" then
		yfreq4 = "0"
	end
	local yfreq5 = string.format("%.0f", dev0:get_argument_value(748) * 10)
	if yfreq5 == "10" then
		yfreq5 = "0"
	end
	local yfreq6 = string.format("%.0f", dev0:get_argument_value(749) * 10)
	if yfreq6 == "10" then
		yfreq6 = "0"
	end
	return yfreq1 .. yfreq2 .. yfreq3 .. yfreq4 .. yfreq5 .. "." .. yfreq6
end

Mi_8MT:defineString("YADRO1A_FREQ", getYadro1AFrequency, 7, "YaDRO-1A", "YaDRO-1A, Frequency (String)")

Mi_8MT:defineTumb("WPN_SIGHT_DBL", 47, 3005, 856, 0.5, { 0, 0.5 }, nil, false, "Weapons", "PKV Sight Double")
Mi_8MT:defineToggleSwitch("WPN_SIGHT_SUN", 47, 3006, 903, "Weapons", "PKV Sun Filter")

Mi_8MT:defineTumb("STC_PRS_SYSTEM", 25, 3001, 839, 0.1, { 0, 0.2 }, nil, false, "Pitot", "Static Pressure System Mode Selector, LEFT/COMMON/RIGHT")
Mi_8MT:defineTumb("CMD_FLARE_SEL", 48, 3002, 859, 0.5, { 0, 1 }, nil, false, "Dispenser", "CMD Board Flares Dispensers Switch, LEFT/BOTH/RIGHT")
Mi_8MT:definePushButton("CMD_INTERVAL", 48, 3006, 862, "Dispenser", "CMD Dispense Interval Button")
Mi_8MT:definePushButton("CMD_FLARE_NUM", 48, 3005, 863, "Dispenser", "CMD Num in Sequence Button")
Mi_8MT:definePushButton("CMD_FLARE_START", 48, 3007, 866, "Dispenser", "CMD Start Dispense Button")
Mi_8MT:definePushButton("CMD_FLARE_START_STOP", 48, 3013, 911, "Dispenser", "CMD Start/Stop Dispense Button")
Mi_8MT:defineTumb("WIPER_L_OFF", 17, 3025, 331, 0.1, { 0, 0 }, nil, false, "Windscreen", "Left Windscreen Wiper Control Switch, OFF")
Mi_8MT:defineTumb("WIPER_L_ON", 17, 3025, 331, 0.1, { 0, 0.1 }, nil, false, "Windscreen", "Left Windscreen Wiper Control Switch, ON")
Mi_8MT:defineTumb("WIPER_L_RST", 17, 3025, 331, 0.2, { 0, 0.2 }, nil, false, "Windscreen", "Left Windscreen Wiper Control Switch, RESET")
Mi_8MT:defineTumb("WIPER_L_SPD_1", 17, 3025, 331, 0.3, { 0, 0.3 }, nil, false, "Windscreen", "Left Windscreen Wiper Control Switch, SPEED 1")
Mi_8MT:defineTumb("WIPER_L_SPD_2", 17, 3025, 331, 0.4, { 0, 0.4 }, nil, false, "Windscreen", "Left Windscreen Wiper Control Switch, SPEED 2")
Mi_8MT:defineTumb("WIPER_R_OFF", 17, 3026, 478, 0.1, { 0, 0 }, nil, false, "Windscreen", "Right Windscreen Wiper Control Switch, OFF")
Mi_8MT:defineTumb("WIPER_R_ON", 17, 3026, 478, 0.1, { 0, 0.1 }, nil, false, "Windscreen", "Right Windscreen Wiper Control Switch, ON")
Mi_8MT:defineTumb("WIPER_R_RST", 17, 3026, 478, 0.2, { 0, 0.2 }, nil, false, "Windscreen", "Right Windscreen Wiper Control Switch, RESET")
Mi_8MT:defineTumb("WIPER_R_SPD_1", 17, 3026, 478, 0.3, { 0, 0.3 }, nil, false, "Windscreen", "Right Windscreen Wiper Control Switch, SPEED 1")
Mi_8MT:defineTumb("WIPER_R_SPD_2", 17, 3026, 478, 0.4, { 0, 0.4 }, nil, false, "Windscreen", "Right Windscreen Wiper Control Switch, SPEED 2")
Mi_8MT:define3PosTumb("ARC_9_LOOP", 40, 3010, 447, "ARC-9", "ARC-9, Loop Control Switch, LEFT/OFF/RIGHT")
Mi_8MT:defineTumb("ARC_BCK_100KHZ", 40, 3005, 675, 0.05, { 0, 0.55 }, nil, false, "ARC-9", "ARC-9, Backup 100kHz Rotary Knob")
Mi_8MT:defineTumb("ARC_BCK_10KHZ", 40, 3006, 450, 0.1, { 0, 0.9 }, nil, false, "ARC-9", "ARC-9, Backup 10kHz Rotary Knob")
Mi_8MT:defineTumb("ARC_MAIN_100KHZ", 40, 3008, 678, 0.05, { 0, 0.55 }, nil, false, "ARC-9", "ARC-9, Main 100kHz Rotary Knob")
Mi_8MT:defineTumb("ARC_MAIN_10KHZ", 40, 3009, 452, 0.1, { 0, 0.9 }, nil, false, "ARC-9", "ARC-9, Main 10kHz Rotary Knob")
Mi_8MT:definePushButton("CARGO_TACT_REL", 51, 3001, 200, "External Cargo", "Tactical Cargo Release Button - Push to release")
Mi_8MT:definePushButton("EMG_TACT_REL", 51, 3003, 198, "External Cargo", "Emergency Cargo Release Button - Push to release")
Mi_8MT:defineTumb("IFF_MODE_SELECTOR", 57, 3001, 304, 0.1, { 0, 0.3 }, nil, false, "IFF", "IFF Transponder Mode Selector Switch, AUTO/KD/+-15/KP")
Mi_8MT:definePushButton("SIG_CAS1_RED", 52, 3003, 284, "Signal Flares", "Signal Flares Cassette 1 Launch Red Button")
Mi_8MT:definePushButton("SIG_CAS1_GREEN", 52, 3002, 285, "Signal Flares", "Signal Flares Cassette 1 Launch Green Button")
Mi_8MT:definePushButton("SIG_CAS1_YELLOW", 52, 3005, 286, "Signal Flares", "Signal Flares Cassette 1 Launch Yellow Button")
Mi_8MT:definePushButton("SIG_CAS1_WHITE", 52, 3004, 287, "Signal Flares", "Signal Flares Cassette 1 Launch White Button")
Mi_8MT:definePushButton("SIG_CAS2_RED", 52, 3008, 288, "Signal Flares", "Signal Flares Cassette 2 Launch Red Button")
Mi_8MT:definePushButton("SIG_CAS2_GREEN", 52, 3007, 289, "Signal Flares", "Signal Flares Cassette 2 Launch Green Button")
Mi_8MT:definePushButton("SIG_CAS2_YELLOW", 52, 3010, 290, "Signal Flares", "Signal Flares Cassette 2 Launch Yellow Button")
Mi_8MT:definePushButton("SIG_CAS2_WHITE", 52, 3009, 291, "Signal Flares", "Signal Flares Cassette 2 Launch White Button")

Mi_8MT:defineTumb("TRG_L_RADIO_ICS", 36, 3026, 182, 0.5, { 0, 0.5 }, nil, false, "Radio", "Left Trigger Button, RADIO/ICS")
Mi_8MT:defineTumb("TRG_R_RADIO_ICS", 36, 3027, 225, 0.5, { 0, 0.5 }, nil, false, "Radio", "Right Trigger Button, RADIO/ICS")

Mi_8MT:defineIndicatorLight("LMP_AP_HDG_ON", 781, "Lamps", "AP heading ON (green)")
Mi_8MT:defineIndicatorLight("LMP_AP_HEADING_OFF", 782, "Lamps", "AP heading OFF (red)")
Mi_8MT:defineIndicatorLight("LMP_AP_PITCH_ROLL_ON", 783, "Lamps", "AP pitch roll_on (green)")
Mi_8MT:defineIndicatorLight("LMP_AP_HEIGHT_ON", 784, "Lamps", "AP height ON (green)")
Mi_8MT:defineIndicatorLight("LMP_AP_HEIGHT_OFF", 785, "Lamps", "AP height OFF (red)")
Mi_8MT:defineIndicatorLight("LMP_ENGINE_RT_LEFT_ON", 316, "Lamps", "ENGINE_RT_LEFT_ON (green)")
Mi_8MT:defineIndicatorLight("LMP_ENGINE_RT_RIGHT_ON", 317, "Lamps", "ENGINE_RT_RIGHT_ON (green)")
Mi_8MT:defineIndicatorLight("LMP_SARPP_ON", 318, "Lamps", "SARPP ON (green)")
Mi_8MT:defineIndicatorLight("LMP_DESCENT_SIREN", 325, "Lamps", "Descent Siren (green)")
Mi_8MT:defineIndicatorLight("LMP_LOCK_OPEN", 326, "Lamps", "LOCK_OPEN (green)")
Mi_8MT:defineIndicatorLight("LMP_DOORS_OPEN", 327, "Lamps", "Doors OPEN (red)")
Mi_8MT:defineIndicatorLight("LMP_TURN_ON_RI65", 340, "Lamps", "TURN_ON_RI_65 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FROST", 360, "Lamps", "FROST Light (red)")
Mi_8MT:defineIndicatorLight("LMP_LEFT_ENG_HEATING", 362, "Lamps", "LEFT_ENG_HEATING (green)")
Mi_8MT:defineIndicatorLight("LMP_RIGHT_ENG_HEATING", 363, "Lamps", "RIGHT_ENG_HEATING (green)")
Mi_8MT:defineIndicatorLight("LMP_ANTI_ICE_ON", 361, "Lamps", "ANTI_ICE_ON (green)")
Mi_8MT:defineIndicatorLight("LMP_LEFT_PZU_FRONT", 364, "Lamps", "LEFT_PZU_FRONT (green)")
Mi_8MT:defineIndicatorLight("LMP_RIGHT_PZU_FRONT", 365, "Lamps", "RIGHT_PZU_FRONT (green)")
Mi_8MT:defineIndicatorLight("LMP_LEFT_PZU_BACK", 366, "Lamps", "LEFT_PZU_BACK (green)")
Mi_8MT:defineIndicatorLight("LMP_RIGHT_PZU_BACK", 367, "Lamps", "RIGHT_PZU_BACK (green)")
Mi_8MT:defineIndicatorLight("LMP_SECTION_1", 373, "Lamps", "SECTION 1 (green)")
Mi_8MT:defineIndicatorLight("LMP_SECTION_2", 375, "Lamps", "SECTION 2 (green)")
Mi_8MT:defineIndicatorLight("LMP_SECTION_3", 374, "Lamps", "SECTION 3 (green)")
Mi_8MT:defineIndicatorLight("LMP_SECTION_4", 376, "Lamps", "SECTION 4 (green)")
Mi_8MT:defineIndicatorLight("LMP_RIO_HEATING_OK", 368, "Lamps", "RIO_heating OK (green)")
Mi_8MT:defineIndicatorLight("LMP_LEFT_ENG_FIRE", 377, "Lamps", "LEFT Engine FIRE (red)")
Mi_8MT:defineIndicatorLight("LMP_RIGHT_ENG_FIRE", 378, "Lamps", "RIGHT Engine FIRE (red)")
Mi_8MT:defineIndicatorLight("LMP_KO50_FIRE", 379, "Lamps", "KO50 FIRE (red)")
Mi_8MT:defineIndicatorLight("LMP_REDUC_AI9_FIRE", 380, "Lamps", "REDUC_AI9 FIRE (red)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_LENG_1_QUEUE", 381, "Lamps", "FIRE_LENG_1_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_RENG_1_QUEUE", 382, "Lamps", "FIRE_RENG_1_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_KO50_1_QUEUE", 383, "Lamps", "FIRE_KO50_1_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_REDUCT_1_QUEUE", 384, "Lamps", "FIRE_REDUCT_1_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_LENG_2_QUEUE", 385, "Lamps", "FIRE_LENG_2_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_RENG_2_QUEUE", 386, "Lamps", "FIRE_RENG_2_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_KO50_2_QUEUE", 387, "Lamps", "FIRE_KO50_2_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE_REDUCT_2_QUEUE", 388, "Lamps", "FIRE_REDUCT_2_QUEUE (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CHECK_SENSORS", 398, "Lamps", "CHECK_SENSORS (red)")
Mi_8MT:defineIndicatorLight("LMP_HYDRO_MAIN_ON", 407, "Lamps", "HYDRO_main_on (green)")
Mi_8MT:defineIndicatorLight("LMP_HYDRO_AUX_ON", 408, "Lamps", "HYDRO_aux_on (red)")
Mi_8MT:defineIndicatorLight("LMP_APD9_ON", 414, "Lamps", "APD9_on (green)")
Mi_8MT:defineIndicatorLight("LMP_APD9_OIL_PRESSURE", 416, "Lamps", "APD9_oil_pressure (green)")
Mi_8MT:defineIndicatorLight("LMP_APD9_RPM", 417, "Lamps", "APD9 RPM (green)")
Mi_8MT:defineIndicatorLight("LMP_APD9_RPM_HIGH", 418, "Lamps", "APD9 RPM high (red)")
Mi_8MT:defineIndicatorLight("LMP_APD_ON", 420, "Lamps", "APD ON (green)")
Mi_8MT:defineIndicatorLight("LMP_APD_STARTER_ON", 424, "Lamps", "APD Starter ON (green)")
Mi_8MT:defineIndicatorLight("LMP_FUEL_LEFT_CLOSED", 434, "Lamps", "FUEL_left_closed (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FUEL_RIGHT_CLOSED", 435, "Lamps", "FUEL_right_closed (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FUEL_RING_CLOSED", 436, "Lamps", "FUEL_ring_closed (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FUEL_CENTER_ON", 441, "Lamps", "FUEL_center ON (green)")
Mi_8MT:defineIndicatorLight("LMP_FUEL_LEFT_ON", 442, "Lamps", "FUEL_left ON (green)")
Mi_8MT:defineIndicatorLight("LMP_FUEL_RIGHT_ON", 443, "Lamps", "FUEL_right ON (green)")
Mi_8MT:defineIndicatorLight("LMP_HEATER", 461, "Lamps", "HEATER Light (yellow)")
Mi_8MT:defineIndicatorLight("LMP_IGNITION", 462, "Lamps", "IGNITION Light (yellow)")
Mi_8MT:defineIndicatorLight("LMP_KO50_ON", 463, "Lamps", "KO50 ON (green)")
Mi_8MT:defineIndicatorLight("LMP_LEFT_PITOT_HEATER_OK", 341, "Lamps", "LEFT_PITOT_HEATER_OK (green)")
Mi_8MT:defineIndicatorLight("LMP_RIGHT_PITOT_HEATER_OK", 490, "Lamps", "RIGHT_PITOT_HEATER_OK (green)")
Mi_8MT:defineIndicatorLight("LMP_LEFT_PZU_ON", 509, "Lamps", "LEFT_PZU_ON (green)")
Mi_8MT:defineIndicatorLight("LMP_RIGHT_PZU_ON", 510, "Lamps", "RIGHT_PZU_ON (green)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_TURN_VU1", 504, "Lamps", "ELEC_turn_VU1 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_TURN_VU2", 505, "Lamps", "ELEC_turn_VU2 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_TURN_VU3", 506, "Lamps", "ELEC_turn_VU3 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_DC_GROUND", 507, "Lamps", "ELEC_DC_ground (yellow)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_TEST_EQUIPMENT", 508, "Lamps", "ELEC_test_equipment (red)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_GEN1_FAIL", 543, "Lamps", "ELEC_gen1_fail (red)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_GEN2_FAIL", 544, "Lamps", "ELEC_gen2_fail (red)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_AC_GROUND", 545, "Lamps", "ELEC_AC_ground (yellow)")
Mi_8MT:defineIndicatorLight("LMP_ELEC_PO_500", 546, "Lamps", "ELEC_PO_500 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CIRCUIT_FROM_BATTERY", 86, "Lamps", "CIRCUIT_FROM_BATTERY (red)")
Mi_8MT:defineIndicatorLight("LMP_CLOG_TF_LEFT", 68, "Lamps", "CLOG_TF_LEFT (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CLOG_TF_RIGHT", 69, "Lamps", "CLOG_TF_RIGHT (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CHIP_LEFT_ENG", 70, "Lamps", "CHIP_LEFT_ENG (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CHIP_RIGHT_ENG", 71, "Lamps", "CHIP_RIGHT_ENG (yellow)")
Mi_8MT:defineIndicatorLight("LMP_VIBRATION_LEFT_HIGH", 72, "Lamps", "VIBRATION_LEFT_HIGH (yellow)")
Mi_8MT:defineIndicatorLight("LMP_VIBRATION_RIGHT_HIGH", 73, "Lamps", "VIBRATION_RIGHT_HIGH (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FIRE", 74, "Lamps", "FIRE (red)")
Mi_8MT:defineIndicatorLight("LMP_LEFT_ENG_TURN_OFF", 76, "Lamps", "LEFT_ENG_TURN OFF (red)")
Mi_8MT:defineIndicatorLight("LMP_RIGHT_ENG_TURN_OFF", 77, "Lamps", "RIGHT_ENG_TURN OFF (red)")
Mi_8MT:defineIndicatorLight("LMP_FT_LEFT_HIGH", 78, "Lamps", "FT_LEFT_HIGH (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FT_RIGHT_HIGH", 79, "Lamps", "FT_RIGHT_HIGH (yellow)")
Mi_8MT:defineIndicatorLight("LMP_OIL_PRESSURE_LEFT", 80, "Lamps", "OIL_PRESSURE_LEFT (yellow)")
Mi_8MT:defineIndicatorLight("LMP_OIL_PRESSURE_RIGHT", 81, "Lamps", "OIL_PRESSURE_RIGHT")
Mi_8MT:defineIndicatorLight("LMP_ER_LEFT", 82, "Lamps", "ER_LEFT (yellow)")
Mi_8MT:defineIndicatorLight("LMP_ER_RIGHT", 83, "Lamps", "ER_RIGHT (yellow)")
Mi_8MT:defineIndicatorLight("LMP_EEC_LEFT_OFF", 84, "Lamps", "EEC_LEFT OFF (yellow)")
Mi_8MT:defineIndicatorLight("LMP_EEC_RIGHT_OFF", 85, "Lamps", "EEC_RIGHT OFF (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CHIP_MAIN_REDUCTOR", 873, "Lamps", "CHIP_MAIN_REDUCTOR (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CHIP_INTER_REDUCTOR", 874, "Lamps", "CHIP_INTER_REDUCTOR (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CHIP_TAIL_REDUCTOR", 875, "Lamps", "CHIP_TAIL_REDUCTOR (yellow)")
Mi_8MT:defineIndicatorLight("LMP_300_LEFT", 64, "Lamps", "300_Left (yellow)")
Mi_8MT:defineIndicatorLight("LMP_DISS_OFF", 65, "Lamps", "DISS_OFF (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD1", 555, "Lamps", "BD1 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD2", 556, "Lamps", "BD2 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD3", 557, "Lamps", "BD3 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD4", 558, "Lamps", "BD4 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD5", 559, "Lamps", "BD5 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD6", 560, "Lamps", "BD6 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD1BOMB", 711, "Lamps", "BD1 Bomb (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD2BOMB", 712, "Lamps", "BD2 Bomb (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD3BOMB", 713, "Lamps", "BD3 Bomb (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD4BOMB", 714, "Lamps", "BD4 Bomb (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD5BOMB", 715, "Lamps", "BD5 Bomb (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BD6BOMB", 716, "Lamps", "BD6 Bomb (yellow)")
Mi_8MT:defineIndicatorLight("LMP_PUS1", 562, "Lamps", "PUS1 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_PUS3", 563, "Lamps", "PUS3 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_PUS4", 564, "Lamps", "PUS4 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_PUS6", 565, "Lamps", "PUS6 (yellow)")
Mi_8MT:defineIndicatorLight("LMP_EMERGEXPLODE", 561, "Lamps", "EmergExplode (red)")
Mi_8MT:defineIndicatorLight("LMP_EMERGEXPLODESEC", 705, "Lamps", "EmergExplodeSec (red)")
Mi_8MT:defineIndicatorLight("LMP_BV_NET_ON", 710, "Lamps", "BV_Net ON (yellow)")
Mi_8MT:defineIndicatorLight("LMP_RS_NET_ON", 566, "Lamps", "RS_Net ON (yellow)")
Mi_8MT:defineIndicatorLight("LMP_GUV_NET_ON", 567, "Lamps", "GUV_Net ON (yellow)")
Mi_8MT:defineIndicatorLight("LMP_FKP_ON", 568, "Lamps", "FKP ON (yellow)")
Mi_8MT:defineIndicatorLight("LMP_CAUTION_WEAP", 778, "Lamps", "Caution_Weap (red)")
Mi_8MT:defineIndicatorLight("LMP_READY1", 586, "Lamps", "Ready 1 (red)")
Mi_8MT:defineIndicatorLight("LMP_READY2", 587, "Lamps", "Ready 2 (red)")
Mi_8MT:defineIndicatorLight("LMP_READY3", 588, "Lamps", "Ready 3 (red)")
Mi_8MT:defineIndicatorLight("LMP_RECORD_P503B", 306, "Lamps", "Record_P503B (green)")
Mi_8MT:defineIndicatorLight("LMP_IFF_KD", 302, "Lamps", "IFF_KD (green)")
Mi_8MT:defineIndicatorLight("LMP_IFF_KP", 303, "Lamps", "IFF_KP (green)")
Mi_8MT:defineIndicatorLight("LMP_IFF_TURNONRESERVE", 912, "Lamps", "IFF_TurnOnReserve (yellow)")
Mi_8MT:defineIndicatorLight("LMP_IFF_FAILURE", 87, "Lamps", "IFF_Failure (red)")

Mi_8MT:defineFloat("MIRRORS_DRAW", 928, { 1, 0 }, "Indicator", "mirrors_draw")
Mi_8MT:defineFloat("RUDDER_POSITION", 266, { 1, -1 }, "Indicator", "rudder_position")
Mi_8MT:defineFloat("STICK_ROLL", 181, { 1, -1 }, "Indicator", "stick_roll")
Mi_8MT:defineFloat("STICK_PITCH", 180, { 1, -1 }, "Indicator", "stick_pitch")
Mi_8MT:defineFloat("COLLECTIVE_POSITION", 191, { 0, 1 }, "Indicator", "collective_position")
Mi_8MT:defineFloat("CORRECTION_POSITION", 192, { 1, 0 }, "Indicator", "correction_position")
Mi_8MT:defineFloat("THROTTLE_LEFT", 187, { 0, 1 }, "Indicator", "throttle_left")
Mi_8MT:defineFloat("THROTTLE_RIGHT", 189, { 0, 1 }, "Indicator", "throttle_right")
Mi_8MT:defineFloat("COLL_ROUTE_DESCENT_SW", 560, { 0, 1 }, "Indicator", "coll_ROUTE_DESCENT_sw")
Mi_8MT:defineFloat("COLL_READJUSTFREETURBRPM_SW", 558, { 0, 1 }, "Indicator", "coll_ReadjustFreeTurbRPM_sw")
Mi_8MT:defineFloat("WHEELBRAKES", 881, { 0, 1 }, "Indicator", "wheelBrakes")
Mi_8MT:defineFloat("PARKINGBRAKE", 930, { 0, 1 }, "Indicator", "parkingBrake")
Mi_8MT:defineFloat("VARIOMETER_L", 16, { -1, 1 }, "Indicator", "Variometer_L")
Mi_8MT:defineFloat("VARIOMETER_R", 95, { -1, 1 }, "Indicator", "Variometer_R")
Mi_8MT:defineFloat("IAS_L", 24, { 0, 1 }, "Indicator", "IAS_L")
Mi_8MT:defineFloat("IAS_R", 790, { 0, 1 }, "Indicator", "IAS_R")
Mi_8MT:defineFloat("AGB_3K_LEFT_ROLL", 13, { -1, 1 }, "Indicator", "AGB_3K_Left_roll")
Mi_8MT:defineFloat("AGB_3K_LEFT_PITCH", 12, { 1.0, -1 }, "Indicator", "AGB_3K_Left_pitch")
Mi_8MT:defineFloat("AGB_3K_LEFT_FAILURE_FLAG", 14, { 0, 1 }, "Indicator", "AGB_3K_Left_failure_flag")
Mi_8MT:defineFloat("AGB_3K_LEFT_SIDESLIP", 15, { 1.0, -1 }, "Indicator", "AGB_3K_Left_sideslip")
Mi_8MT:defineFloat("AGB_3K_LEFT_INDEX", 820, { 0.5, -0.5 }, "Indicator", "AGB_3K_Left_index")
Mi_8MT:defineFloat("AGB_3K_RIGHT_ROLL", 92, { -1, 1 }, "Indicator", "AGB_3K_Right_roll")
Mi_8MT:defineFloat("AGB_3K_RIGHT_PITCH", 91, { 1.0, -1 }, "Indicator", "AGB_3K_Right_pitch")
Mi_8MT:defineFloat("AGB_3K_RIGHT_FAILURE_FLAG", 93, { 0, 1 }, "Indicator", "AGB_3K_Right_failure_flag")
Mi_8MT:defineFloat("AGB_3K_RIGHT_SIDESLIP", 94, { 1.0, -1 }, "Indicator", "AGB_3K_Right_sideslip")
Mi_8MT:defineFloat("AGB_3K_RIGHT_INDEX", 821, { 0.5, -0.5 }, "Indicator", "AGB_3K_Right_index")
Mi_8MT:defineFloat("EUP_SPEED", 22, { -1, 1 }, "Indicator", "EUP_Speed")
Mi_8MT:defineFloat("EUP_SIDESLIP", 23, { -1, 1 }, "Indicator", "EUP_Sideslip")
Mi_8MT:defineFloat("UGR_4K_HEADING_L", 25, { 0, 1 }, "Indicator", "UGR_4K_heading_L")
Mi_8MT:defineFloat("UGR_4K_COMMANDED_COURSE_L", 27, { 0, 1 }, "Indicator", "UGR_4K_commanded_course_L")
Mi_8MT:defineFloat("UGR_4K_BEARING_NEEDLE_L", 28, { 0, 1 }, "Indicator", "UGR_4K_bearing_needle_L")
Mi_8MT:defineFloat("UGR_4K_HEADING_R", 101, { 0, 1 }, "Indicator", "UGR_4K_heading_R")
Mi_8MT:defineFloat("UGR_4K_COMMANDED_COURSE_R", 103, { 0, 1 }, "Indicator", "UGR_4K_commanded_course_R")
Mi_8MT:defineFloat("UGR_4K_BEARING_NEEDLE_R", 104, { 0, 1 }, "Indicator", "UGR_4K_bearing_needle_R")
Mi_8MT:defineFloat("VD_10K_L_100", 19, { 0, 1 }, "Indicator", "VD_10K_L_100")
Mi_8MT:defineFloat("VD_10K_L_10", 20, { 0, 1 }, "Indicator", "VD_10K_L_10")
Mi_8MT:defineFloat("VD_10K_L_100_IND", 833, { 0, 1 }, "Indicator", "VD_10K_L_100_Ind")
Mi_8MT:defineFloat("VD_10K_L_100_IND_SHUTTER", 916, { 0.822, 0.75 }, "Indicator", "VD_10K_L_100_Ind_Shutter")
Mi_8MT:defineFloat("VD_10K_L_10_IND", 832, { 0, 1 }, "Indicator", "VD_10K_L_10_Ind")
Mi_8MT:defineFloat("VD_10K_L_PRESS", 21, { -0.051, 0.668 }, "Indicator", "VD_10K_L_PRESS")
Mi_8MT:defineFloat("VD_10K_R_100", 98, { 0, 1 }, "Indicator", "VD_10K_R_100")
Mi_8MT:defineFloat("VD_10K_R_10", 99, { 0, 1 }, "Indicator", "VD_10K_R_10")
Mi_8MT:defineFloat("VD_10K_R_100_IND", 835, { 0, 1 }, "Indicator", "VD_10K_R_100_Ind")
Mi_8MT:defineFloat("VD_10K_R_100_IND_SHUTTER", 917, { 0.822, 0.75 }, "Indicator", "VD_10K_R_100_Ind_Shutter")
Mi_8MT:defineFloat("VD_10K_R_10_IND", 834, { 0, 1 }, "Indicator", "VD_10K_R_10_Ind")
Mi_8MT:defineFloat("VD_10K_R_PRESS", 100, { -0.051, 0.668 }, "Indicator", "VD_10K_R_PRESS")
Mi_8MT:defineFloat("ROTORRPM", 42, { 0, 1 }, "Indicator", "RotorRPM")
Mi_8MT:defineFloat("ROTORRPM_OPER", 787, { 0, 1 }, "Indicator", "RotorRPM")
Mi_8MT:defineFloat("ROTORPITCH", 36, { 0, 1 }, "Indicator", "RotorPitch")
Mi_8MT:defineFloat("A_036_RALT", 34, { 0, 1 }, "Indicator", "A_036_RALT")
Mi_8MT:defineFloat("A_036_DANGERRALT_INDEX", 31, { 0, 1 }, "Indicator", "A_036_DangerRALT_index")
Mi_8MT:defineIndicatorLight("A_036_DANGERRALT_LAMP", 30, "Lamps", "A_036_DangerRALT_lamp (yellow)")
Mi_8MT:defineFloat("A_036_WARNING_FLAG", 33, { 0, 1 }, "Indicator", "A_036_warning_flag")
Mi_8MT:defineFloat("LEFTENGINERPM", 40, { 0, 1 }, "Indicator", "LeftEngineRPM")
Mi_8MT:defineFloat("RIGHTENGINERPM", 41, { 0, 1 }, "Indicator", "RightEngineRPM")
Mi_8MT:defineFloat("LEFTENGINERPM_OPER", 788, { 0, 1 }, "Indicator", "LeftEngineRPM")
Mi_8MT:defineFloat("RIGHTENGINERPM_OPER", 789, { 0, 1 }, "Indicator", "RightEngineRPM")
Mi_8MT:defineFloat("LEFTENGINETEMPERATUREHUND", 43, { 0, 1 }, "Indicator", "LeftEngineTemperatureHund")
Mi_8MT:defineFloat("LEFTENGINETEMPERATURETENTH", 44, { 0, 1 }, "Indicator", "LeftEngineTemperatureTenth")
Mi_8MT:defineFloat("RIGHTENGINETEMPERATUREHUND", 45, { 0, 1 }, "Indicator", "RightEngineTemperatureHund")
Mi_8MT:defineFloat("RIGHTENGINETEMPERATURETENTH", 46, { 0, 1 }, "Indicator", "RightEngineTemperatureTenth")
Mi_8MT:defineFloat("ENGINESMODE", 39, { 0, 1 }, "Indicator", "EnginesMode")
Mi_8MT:defineFloat("LEFTENGINEMODE", 37, { 0, 1 }, "Indicator", "LeftEngineMode")
Mi_8MT:defineFloat("RIGHTENGINEMODE", 38, { 0, 1 }, "Indicator", "RightEngineMode")
Mi_8MT:defineFloat("LEFT_ENGINE_BRAKE_HANDLE", 204, { 0, 1 }, "Indicator", "left_engine_brake_handle")
Mi_8MT:defineFloat("RIGHT_ENGINE_BRAKE_HANDLE", 206, { 0, 1 }, "Indicator", "right_engine_brake_handle")
Mi_8MT:defineFloat("LEFT_ENGINE_BRAKE_HANDLE_HOLDER", 203, { 0, 1 }, "Indicator", "left_engine_brake_handle_holder")
Mi_8MT:defineFloat("RIGHT_ENGINE_BRAKE_HANDLE_HOLDER", 205, { 0, 1 }, "Indicator", "right_engine_brake_handle_holder")
Mi_8MT:defineFloat("DISS15_HOVER_X", 830, { -1, 1 }, "Indicator", "diss15_hover_X")
Mi_8MT:defineFloat("DISS15_HOVER_Y", 828, { -1, 1 }, "Indicator", "diss15_hover_Y")
Mi_8MT:defineFloat("DISS15_HOVER_Z", 829, { -1, 1 }, "Indicator", "diss15_hover_Z")
Mi_8MT:defineFloat("DISS15_HOVER_LAMP_OFF", 831, { 0, 0.9 }, "Indicator", "diss15_hover_lamp OFF (red)")
Mi_8MT:defineFloat("DISS15_DRIFT_ANGLE", 791, { -1, 1 }, "Indicator", "diss15_drift_angle")
Mi_8MT:defineFloat("DISS15_W_SHUTTER", 795, { 0, 1 }, "Indicator", "diss15_W_shutter")
Mi_8MT:defineFloat("DISS15_W_MEMORY_LAMP", 796, { 1, 0 }, "Indicator", "diss15_W_memory_lamp (green)")
Mi_8MT:defineFloat("DISS15_W_100", 792, { 0, 1 }, "Indicator", "diss15_W 100")
Mi_8MT:defineFloat("DISS15_W_10", 793, { 0, 1 }, "Indicator", "diss15_W 10")
Mi_8MT:defineFloat("DISS15_W_1", 794, { 0, 1 }, "Indicator", "diss15_W 1")
Mi_8MT:defineFloat("DISS15_COORD_ON_LAMP", 817, { 1, 0 }, "Indicator", "diss15_coord_on_lamp (yellow)")
Mi_8MT:defineFloat("DISS15_COORD_FORWARD", 805, { 1, 0 }, "Indicator", "diss15_coord_forward")
Mi_8MT:defineFloat("DISS15_COORD_X_100", 806, { 0, 1 }, "Indicator", "diss15_coord_X 100")
Mi_8MT:defineFloat("DISS15_COORD_X_10", 807, { 0, 1 }, "Indicator", "diss15_coord_X 10")
Mi_8MT:defineFloat("DISS15_COORD_X_1", 808, { 0, 1 }, "Indicator", "diss15_coord_X 1")
Mi_8MT:defineFloat("DISS15_COORD_RIGHT", 802, { 0, 1 }, "Indicator", "diss15_coord_right")
Mi_8MT:defineFloat("DISS15_COORD_Z_100", 799, { 0, 1 }, "Indicator", "diss15_coord_Z 100")
Mi_8MT:defineFloat("DISS15_COORD_Z_10", 800, { 0, 1 }, "Indicator", "diss15_coord_Z 10")
Mi_8MT:defineFloat("DISS15_COORD_Z_1", 801, { 0, 1 }, "Indicator", "diss15_coord_Z 1")
Mi_8MT:defineFloat("DISS15_COORD_MAP_ANGLE_100", 811, { 0, 1 }, "Indicator", "diss15_coord_map_angle 100")
Mi_8MT:defineFloat("DISS15_COORD_MAP_ANGLE_10", 812, { 0, 1 }, "Indicator", "diss15_coord_map_angle 10")
Mi_8MT:defineFloat("DISS15_COORD_MAP_ANGLE_1", 813, { 0, 1 }, "Indicator", "diss15_coord_map_angle 1")
Mi_8MT:defineFloat("DISS15_COORD_MAP_ANGLE_MIN", 814, { 0, 1 }, "Indicator", "diss15_coord_map_angle Minutes")
Mi_8MT:defineFloat("DISS15_CHECK_CONTROL_LAMP", 822, { 0, 0.9 }, "Indicator", "diss15_check_control_lamp (yellow)")
Mi_8MT:defineFloat("DISS15_CHECK_WORK_LAMP", 823, { 0, 0.9 }, "Indicator", "diss15_check_work_lamp (green)")
Mi_8MT:defineFloat("DISS15_CHECK_FAILM_LAMP", 824, { 0, 0.9 }, "Indicator", "diss15_check_failM_lamp (red)")
Mi_8MT:defineFloat("DISS15_CHECK_FAILC_LAMP", 825, { 0, 0.9 }, "Indicator", "diss15_check_failC_lamp (red)")
Mi_8MT:defineFloat("OILS_P_MAIN_REDUCTOR", 111, { 0, 1 }, "Indicator", "oils_p_main_reductor")
Mi_8MT:defineFloat("OILS_T_MAIN_REDUCTOR", 114, { -0.25, 0.65 }, "Indicator", "oils_t_main_reductor")
Mi_8MT:defineFloat("OILS_TEMP_TAIL_REDUCTOR", 113, { -0.25, 0.75 }, "Indicator", "oils_temp_tail_reductor")
Mi_8MT:defineFloat("OILS_TEMP_INTERMEDIATE_REDUCTOR", 112, { -0.25, 0.75 }, "Indicator", "oils_temp_intermediate_reductor")
Mi_8MT:defineFloat("OILS_P_LEFT_ENGINE", 115, { 0, 1 }, "Indicator", "oils_p_left_engine")
Mi_8MT:defineFloat("OILS_T_LEFT_ENGINE", 116, { -0.25, 0.75 }, "Indicator", "oils_t_left_engine")
Mi_8MT:defineFloat("OILS_P_RIGHT_ENGINE", 117, { 0, 1 }, "Indicator", "oils_p_right_engine")
Mi_8MT:defineFloat("OILS_T_RIGHT_ENGINE", 118, { -0.25, 0.75 }, "Indicator", "oils_t_right_engine")
Mi_8MT:defineFloat("AUTOPILOT_YAW_INDICATOR", 122, { -1, 1 }, "Indicator", "autopilot_yaw_indicator")
Mi_8MT:defineFloat("AUTOPILOT_PITCH_INDICATOR", 124, { -0.78, 0.78 }, "Indicator", "autopilot_pitch_indicator")
Mi_8MT:defineFloat("AUTOPILOT_ROLL_INDICATOR", 123, { -0.33, 0.33 }, "Indicator", "autopilot_roll_indicator")
Mi_8MT:defineFloat("AUTOPILOT_ALTITUDE_INDICATOR", 125, { -1, 1 }, "Indicator", "autopilot_altitude_indicator")
Mi_8MT:defineFloat("AUTOPILOT_YAW_SCALE", 119, { 0, 1 }, "Indicator", "autopilot_yaw_scale")
Mi_8MT:defineFloat("AUTOPILOT_ROLL_SCALE", 120, { 0, 1 }, "Indicator", "autopilot_roll_scale")
Mi_8MT:defineFloat("AUTOPILOT_PITCH_SCALE", 121, { 0, 1 }, "Indicator", "autopilot_pitch_scale")
Mi_8MT:defineFloat("HYDRO_PRESSURE_MAIN", 404, { 0.05, 1 }, "Indicator", "hydro_pressure_main")
Mi_8MT:defineFloat("HYDRO_PRESSURE_AUX", 405, { 0.05, 1 }, "Indicator", "hydro_pressure_aux")
Mi_8MT:defineFloat("APU_TEMPERATURE", 402, { 0, 1 }, "Indicator", "APU_temperature")
Mi_8MT:defineFloat("APU_PRESSURE", 403, { 0.04, 0.95 }, "Indicator", "APU_pressure")
Mi_8MT:defineFloat("CLOCK_CURRTIME_HOURS", 49, { 0, 1 }, "Indicator", "CLOCK_currtime_hours")
Mi_8MT:defineFloat("CLOCK_CURRTIME_MINUTES", 50, { 0, 1 }, "Indicator", "CLOCK_currtime_minutes")
Mi_8MT:defineFloat("CLOCK_CURRTIME_SECONDS", 51, { 0, 1 }, "Indicator", "CLOCK_currtime_seconds")
Mi_8MT:defineFloat("CLOCK_FLIGHT_TIME_METER_STATUS", 56, { 0, 1 }, "Indicator", "CLOCK_flight_time_meter_status")
Mi_8MT:defineFloat("CLOCK_FLIGHT_HOURS", 52, { 0, 1 }, "Indicator", "CLOCK_flight_hours")
Mi_8MT:defineFloat("CLOCK_FLIGHT_MINUTES", 53, { 0, 1 }, "Indicator", "CLOCK_flight_minutes")
Mi_8MT:defineFloat("CLOCK_SECONDS_METER_TIME_MINUTES", 54, { 0, 1 }, "Indicator", "CLOCK_seconds_meter_time_minutes")
Mi_8MT:defineFloat("CLOCK_SECONDS_METER_TIME_SECONDS", 55, { 0, 1 }, "Indicator", "CLOCK_seconds_meter_time_seconds")
Mi_8MT:defineFloat("FUEL_METER", 62, { 0, 1 }, "Indicator", "fuel_meter")
Mi_8MT:defineFloat("AIR_SYSTEM_PRESSURE", 320, { 0, 1 }, "Indicator", "air_system_pressure")
Mi_8MT:defineFloat("AIR_SYSTEM_BRAKE_PRESSURE", 321, { 0, 1 }, "Indicator", "air_system_brake_pressure")
Mi_8MT:defineFloat("SPUU_POINTER", 126, { -1, 1 }, "Indicator", "SPUU_pointer")
Mi_8MT:defineIndicatorLight("SPUU_LAMP", 786, "Lamps", "SPUU Light (red)")
Mi_8MT:defineFloat("PU_26_GA_LAMP", 827, { 0, 0.5 }, "Indicator", "PU_26_GA_Lamp (white)")
Mi_8MT:defineFloat("ARC_UD_NARROW_LAMP", 458, { 0, 0.9 }, "Indicator", "ARC_UD_Narrow_Lamp (green)")
Mi_8MT:defineFloat("ARC_UD_WIDE_LAMP", 459, { 0, 0.9 }, "Indicator", "ARC_UD_Wide_Lamp (green)")
Mi_8MT:defineFloat("ARC_UD_PULSE_LAMP", 460, { 0, 0.9 }, "Indicator", "ARC_UD_Pulse_Lamp (green)")
Mi_8MT:defineFloat("ARC_9_SIGNAL", 681, { 0, 1 }, "Indicator", "ARC_9_Signal")
Mi_8MT:defineFloat("SIGHTREFLECTORPOS", 857, { 0, 1 }, "Indicator", "SightReflectorPos")
Mi_8MT:defineFloat("SAFE_WEAP", 778, { 0, 1 }, "Indicator", "SAFE_WEAP")
Mi_8MT:defineFloat("AMMO_CNT1_1", 577, { 0, 1 }, "Indicator", "AMMO_CNT1_1")
Mi_8MT:defineFloat("AMMO_CNT1_2", 578, { 0, 1 }, "Indicator", "AMMO_CNT1_2")
Mi_8MT:defineFloat("AMMO_CNT2_1", 580, { 0, 1 }, "Indicator", "AMMO_CNT2_1")
Mi_8MT:defineFloat("AMMO_CNT2_2", 581, { 0, 1 }, "Indicator", "AMMO_CNT2_2")
Mi_8MT:defineFloat("AMMO_CNT3_1", 583, { 0, 1 }, "Indicator", "AMMO_CNT3_1")
Mi_8MT:defineFloat("AMMO_CNT3_2", 584, { 0, 1 }, "Indicator", "AMMO_CNT3_2")
Mi_8MT:defineFloat("R828_ASU", 740, { 0, 0.95 }, "Indicator", "R828_ASU Light (green)")
Mi_8MT:defineFloat("R828_CHANNEL", 736, { 0, 0.898 }, "Indicator", "R828_channel")
Mi_8MT:defineFloat("BLISTER_LEFT", 215, { 0, 0.8 }, "Indicator", "Window LEFT")
Mi_8MT:defineFloat("BLISTER_RIGHT", 216, { 0, 0.8 }, "Indicator", "Window RIGHT")
Mi_8MT:defineIndicatorLight("UV26_LAMPLEFTBOARD", 892, "Lamps", "UV26_lampLeftBoard (yellow)")
Mi_8MT:defineIndicatorLight("UV26_LAMPRIGHTBOARD", 891, "Lamps", "UV26_lampRightBoard (yellow)")
Mi_8MT:defineFloat("PILOT_MODEL", 245, { 0, 1 }, "Indicator", "Pilot_Model")
Mi_8MT:defineFloat("OPERATOR_MODEL", 242, { 0, 1 }, "Indicator", "Operator_Model")
Mi_8MT:defineFloat("CREW_MODEL", 262, { 0, 1 }, "Indicator", "Crew_Model")
Mi_8MT:defineFloat("UPPER_WINDSHIELD", 876, { 0, 1 }, "Indicator", "Upper Windshield Damage")
Mi_8MT:defineFloat("DOWN_WINDSHIELD", 877, { 0, 1 }, "Indicator", "Down Windshield Damage")
Mi_8MT:defineFloat("LEFT_WINDSHIELD", 879, { 0, 1 }, "Indicator", "Left Windshield Damage")
Mi_8MT:defineFloat("RIGHT_WINDSHIELD", 878, { 0, 1 }, "Indicator", "Right Windshield Damage")
Mi_8MT:defineIndicatorLight("JADRO_ASU_LAMP", 849, "Lamps", "Jadro_ASU_Lamp (white)")
Mi_8MT:defineIndicatorLight("JADRO_CTL_LAMP", 848, "Lamps", "Jadro_Ctl_Lamp (white)")
Mi_8MT:defineIndicatorLight("JADRO_BREAKDOWN_LAMP", 850, "Lamps", "Jadro_Breakdown_Lamp (white)")
Mi_8MT:defineFloat("RAM_TEMP", 904, { -1, 1 }, "Indicator", "RAM_Temp")
Mi_8MT:defineFloat("G_METER", 907, { -1, 1 }, "Indicator", "G_Meter")
Mi_8MT:defineFloat("G_METER_MAX", 908, { 0.343, 1 }, "Indicator", "G_Meter_Max")
Mi_8MT:defineFloat("G_METER_MIN", 909, { -1.0, 0.343 }, "Indicator", "G_Meter_Min")
Mi_8MT:defineFloat("SUN_SHADE_FILTER", 903, { 0, 1 }, "Indicator", "Sun_Shade_Filter")
Mi_8MT:defineFloat("SALONTEMPERATURE", 63, { -0.7, 0.693 }, "Indicator", "SalonTemperature")
Mi_8MT:defineFloat("DAYNIGHT", 927, { 1.0, 0.9 }, "Indicator", "DayNight")
Mi_8MT:defineFloat("REDLIGHTLHGR1", 880, { 1, 0 }, "Indicator", "RedLightLhGr1 (red)")
Mi_8MT:defineFloat("REDLIGHTLHGR2", 896, { 1, 0 }, "Indicator", "RedLightLhGr2 (red)")
Mi_8MT:defineFloat("REDLIGHTRHGR1", 897, { 1, 0 }, "Indicator", "RedLightRhGr1 (red)")
Mi_8MT:defineFloat("REDLIGHTRHGR2", 898, { 1, 0 }, "Indicator", "RedLightRhGr2 (red)")
Mi_8MT:defineFloat("REDLIGHTCHGR1", 899, { 1, 0 }, "Indicator", "RedLightChGr1 (red)")
Mi_8MT:defineFloat("REDLIGHTCHGR2", 901, { 1, 0 }, "Indicator", "RedLightChGr2 (red)")
Mi_8MT:defineFloat("REDLIGHTCHGR12", 922, { 1, 0 }, "Indicator", "RedLightChGr12 (red)")
Mi_8MT:defineFloat("REDLIGHT5V5", 902, { 1, 0 }, "Indicator", "RedLight5V5 (red)")
Mi_8MT:defineFloat("PLAFONDBRIGHTNESS", 900, { 0, 1 }, "Indicator", "Plafond Brightness")
Mi_8MT:defineFloat("LEFTPLAFOND", 547, { 0, 1 }, "Indicator", "LeftPlafond (white/red)")
Mi_8MT:defineFloat("RIGHTPLAFOND", 665, { 0, 1 }, "Indicator", "RightPlafond (white/red)")
Mi_8MT:defineFloat("RECORDERP503B_PANELLIGHTNESS", 920, { 1, 0 }, "Indicator", "RecorderP503B Brightness (red)")
Mi_8MT:defineFloat("WINDSCREENWIPERL", 254, { 0, 1 }, "Indicator", "WindscreenWiper Left")
Mi_8MT:defineFloat("WINDSCREENWIPERR", 255, { 0, 1 }, "Indicator", "WindscreenWiper Right")

--- @type {[integer]: string}
local R863_FREQ1_POS = {
	[0] = "10",
	[1] = "11",
	[2] = "12",
	[3] = "13",
	[4] = "14",
	[5] = "22",
	[6] = "23",
	[7] = "24",
	[8] = "25",
	[9] = "26",
	[10] = "27",
	[11] = "28",
	[12] = "29",
	[13] = "30",
	[14] = "31",
	[15] = "32",
	[16] = "33",
	[17] = "34",
	[18] = "35",
	[19] = "36",
	[20] = "37",
	[21] = "38",
	[22] = "39",
}

local function getR863Frequency(dev0)
	local freq1 = R863_FREQ1_POS[Module.round(dev0:get_argument_value(157) * 100)] or "10"
	local freq2 = string.format("%.0f", dev0:get_argument_value(158) * 10)
	if freq2 == "10" then
		freq2 = "0"
	end
	local freq3 = string.format("%.0f", dev0:get_argument_value(159) * 10)
	if freq3 == "10" then
		freq3 = "0"
	end

	local freq4 = "00"
	local freq4F = dev0:get_argument_value(160) * 100
	if freq4F ~= nil then
		if freq4F >= 0 and freq4F < 12.5 then
			freq4 = "00"
		elseif freq4F >= 12.5 and freq4F < 37.5 then
			freq4 = "25"
		elseif freq4F >= 37.5 and freq4F < 62.5 then
			freq4 = "50"
		elseif freq4F >= 62.5 and freq4F < 87.5 then
			freq4 = "75"
		end
	end

	return freq1 .. freq2 .. "." .. freq3 .. freq4
end

Mi_8MT:defineString("R863_FREQ", getR863Frequency, 7, "R-863", "R863, Frequency (String)")

Mi_8MT:defineRotary("CLOCK_R_LEV_TURN", 45, 3005, 60, "Clock", "Mech Clock Right Lever (Turn)")
Mi_8MT:definePushButton("CLOCK_R_LEV_PRESS", 45, 3004, 59, "Clock", "Mech Clock Right Lever (Press)")
Mi_8MT:defineRotary("CLOCK_L_LEV_TURN", 45, 3003, 58, "Clock", "Mech clock left lever (Turn)")
Mi_8MT:defineTumb("CLOCK_L_LEV_PULL", 45, 3001, 57, 1, { 0, 1 }, nil, false, "Clock", "Mech Clock Left Lever (Pull)")
Mi_8MT:defineTumb("CLOCK_L_LEV_PRESS", 45, 3002, 57, 1, { -1, 0 }, nil, false, "Clock", "Mech Clock Left Lever (Press)")

Mi_8MT:defineFloat("R863_FREQ1_TUBE", 157, { 0, 1 }, "Indicator", "R-863, 10MHz Tube")
Mi_8MT:defineFloat("R863_FREQ2_TUBE", 158, { 0, 1 }, "Indicator", "R-863, 1MHz Tube")
Mi_8MT:defineFloat("R863_FREQ3_TUBE", 159, { 0, 1 }, "Indicator", "R-863, 100KHz Tube")
Mi_8MT:defineFloat("R863_FREQ4_TUBE", 160, { 0, 1 }, "Indicator", "R-863, 1KHz Tube")

Mi_8MT:defineFloat("SBY_COMPASS_HDG", 272, { -1, 1 }, "Windscreen", "Standby Compass Heading")
Mi_8MT:defineFloat("SBY_COMPASS_PITCH", 274, { -1, 1 }, "Windscreen", "Standby Compass Pitch")
Mi_8MT:defineFloat("SBY_COMPASS_BANK", 273, { -1, 1 }, "Windscreen", "Standby Compass Bank")

Mi_8MT:defineFloat("COLLECTIVE_STOPPER", 201, { -1, 1 }, "Misc", "Collective_Stopper")

--Externals
Mi_8MT:defineBitFromDrawArgument("EXT_POSITION_LIGHTS", 190, "External Aircraft Model", "Position Lights")
Mi_8MT:defineBitFromDrawArgument("EXT_STROBE", 193, "External Aircraft Model", "Strobe Light")
Mi_8MT:defineBitFromDrawArgument("EXT_WOW_NOSE", 1, "External Aircraft Model", "Weight ON Wheels Nose Gear")
Mi_8MT:defineBitFromDrawArgument("EXT_WOW_RIGHT", 4, "External Aircraft Model", "Weight ON Wheels Right Gear")
Mi_8MT:defineBitFromDrawArgument("EXT_WOW_LEFT", 6, "External Aircraft Model", "Weight ON Wheels Left Gear")
Mi_8MT:defineFullRangeFloatFromExternalDrawArgument("EXT_ROTOR", 40, "External Aircraft Model", "Rotor Move")

Mi_8MT:defineIndicatorLight("LMP_BOMB_SIGHT_L_CRS", 47, "Lamps", " Bomb Sight Course Left Light (red)")
Mi_8MT:defineIndicatorLight("LMP_BOMB_SIGHT_R_CRS", 48, "Lamps", " Bomb Sight Course Right Light (red) (red)")
Mi_8MT:defineIndicatorLight("LMP_R863_EMERG", 151, "Lamps", "R-863 Emergency Light (green)")
Mi_8MT:defineIndicatorLight("LMP_UPK_CCT_ON", 860, "Lamps", "UPK CCT ON (yellow)")
Mi_8MT:defineIndicatorLight("LMP_PKT_CCT_ON", 861, "Lamps", "PKT CCT ON (yellow)")
Mi_8MT:defineIndicatorLight("LMP_BOMB_CCT_ON", 554, "Lamps", "BOMB CCT ON (yellow)")

Mi_8MT:defineReadWriteRadio("JADRO_1A_RADIO", 37, 7, 1, 100, "JADRO 1A Radio")
Mi_8MT:defineReadWriteRadio("R863_RADIO", 38, 7, 3, 1000, "R-863 Radio")
Mi_8MT:defineReadWriteRadio("R828_RADIO", 39, 7, 3, 1000, "R-828 Radio")

return Mi_8MT
