module("L-39", package.seeall)

local Module = require("Scripts.DCS-BIOS.lib.modules.Module")

--- @class L_39: Module
local L_39 = Module:new("L-39", 0x3200, { "L-39C", "L-39ZA" })
--by WarLord

-- remove Arg# Pilot 600 / Instructor 610

-----------------------------------L-39 Externals--------------------------------------------------
L_39:defineFloatFromDrawArgument("EXT_SPEED_BRAKE_RIGHT", 183, "External Aircraft Model", "Right Speed Brake")

L_39:defineFloatFromDrawArgument("EXT_SPEED_BRAKE_LEFT", 185, "External Aircraft Model", "Left Speed Brake")

L_39:defineBitFromDrawArgument("EXT_POSITION_LIGHT_LEFT", 190, "External Aircraft Model", "Left Position Light (red)")
L_39:defineBitFromDrawArgument("EXT_POSITION_LIGHT_RIGHT", 191, "External Aircraft Model", "Right Position Light (green)")
L_39:defineBitFromDrawArgument("EXT_STROBE", 192, "External Aircraft Model", "Strobe Light")

L_39:defineBitFromDrawArgument("EXT_WOW_NOSE", 1, "External Aircraft Model", "Weight ON Wheels Nose Gear")
L_39:defineBitFromDrawArgument("EXT_WOW_RIGHT", 4, "External Aircraft Model", "Weight ON Wheels Right Gear")
L_39:defineBitFromDrawArgument("EXT_WOW_LEFT", 6, "External Aircraft Model", "Weight ON Wheels Left Gear")

-----------------------------------L-39 GAUGES--------------------------------------------------

L_39:defineFloat("FRONT_CLOCK_TIME_H", 67, { 0, 1 }, "Gauges", "Front Clock Current Time Hours")
L_39:defineFloat("FRONT_CLOCK_TIME_M", 68, { 0, 1 }, "Gauges", "Front Clock Current Time Minutes")
L_39:defineFloat("FRONT_CLOCK_TIME_S", 70, { 0, 1 }, "Gauges", "Front Clock Current Time Seconds")
L_39:defineFloat("FRONT_CLOCK_MODE", 73, { 0, 0.2 }, "Gauges", "Front Clock Mode")
L_39:defineFloat("FRONT_CLOCK_FLIGHT_H", 71, { 0, 1 }, "Gauges", "Front Clock Flight Time Hours")
L_39:defineFloat("FRONT_CLOCK_FLIGHT_M", 72, { 0, 1 }, "Gauges", "Front Clock Flight Time Minutes")
L_39:defineFloat("FRONT_CLOCK_STOPP_M", 69, { 0.0, 1.0 }, "Gauges", "Front Clock Stopwatch 30 Minutes")
L_39:defineFloat("BACK_CLOCK_TIME_H", 405, { 0, 1 }, "Gauges", "Back Clock Current Time Hours")
L_39:defineFloat("BACK_CLOCK_TIME_M", 406, { 0, 1 }, "Gauges", "Back Clock Current Time Minutes")
L_39:defineFloat("BACK_CLOCK_TIME_S", 408, { 0, 1 }, "Gauges", "Back Clock Current Time Seconds")
L_39:defineFloat("BACK_CLOCK_MODE", 411, { 0, 0.2 }, "Gauges", "Back Clock Mode")
L_39:defineFloat("BACK_CLOCK_FLIGHT_H", 409, { 0, 1 }, "Gauges", "Back Clock Flight Time Hours")
L_39:defineFloat("BACK_CLOCK_FLIGHT_M", 410, { 0, 1 }, "Gauges", "Back Clock Flight Time Minutes")
L_39:defineFloat("BACK_CLOCK_STOPP_M", 407, { 0.0, 1.0 }, "Gauges", "Back Clock Stopwatch 30 Minutes")

L_39:defineFloat("FRONT_ALT_KM", 52, { 0, 1 }, "Gauges", "Front VD-20 Altimeter KM")
L_39:defineFloat("FRONT_ALT_M", 53, { 0, 1 }, "Gauges", "Front VD-20 Altimeter M")
L_39:defineFloat("FRONT_ALT_IND_KM", 54, { 0, 1 }, "Gauges", "Front VD-20 Altimeter Indicator KM")
L_39:defineFloat("FRONT_ALT_IND_M", 55, { 0, 1 }, "Gauges", "Front VD-20 Altimeter Indicator M")
L_39:defineFloat("FRONT_ALT_PRESS", 56, { 0, 1 }, "Gauges", "Front VD-20 Altimeter Pressure")
L_39:defineFloat("BACK_ALT_KM", 389, { 0, 1 }, "Gauges", "Back VD-20 Altimeter KM")
L_39:defineFloat("BACK_ALT_M", 390, { 0, 1 }, "Gauges", "Back VD-20 Altimeter M")
L_39:defineFloat("BACK_ALT_IND_KM", 391, { 0, 1 }, "Gauges", "Back VD-20 Altimeter Indicator KM")
L_39:defineFloat("BACK_ALT_IND_M", 392, { 0, 1 }, "Gauges", "Back VD-20 Altimeter Indicator M")
L_39:defineFloat("BACK_ALT_PRESS", 393, { 0, 1 }, "Gauges", "Back VD-20 Altimeter Pressure")

L_39:defineFloat("FRONT_RALT", 58, { 0.0, 0.955 }, "Gauges", "Front Radar Altimeter")
L_39:defineFloat("FRONT_RALT_DANGER", 59, { 0.0, 0.998 }, "Gauges", "Front Radar Altimeter Danger Altitude")
L_39:defineFloat("FRONT_RALT_WARNFLAG", 62, { 0, 1 }, "Gauges", "Front Radar Altimeter Warning Flag")
L_39:defineFloat("BACK_RALT", 396, { 0.0, 0.955 }, "Gauges", "Back Radar Altimeter")
L_39:defineFloat("BACK_RALT_DANGER", 397, { 0.0, 0.998 }, "Gauges", "Back Radar Altimeter Danger Altitude")
L_39:defineFloat("BACK_RALT_WARNFLAG", 400, { 0, 1 }, "Gauges", "Back Radar Altimeter Warning Flag")

L_39:defineFloat("FRONT_ALT_100_PTR", 637, { 0, 1 }, "Gauges", "Front Altimeter 100ft Ptr")
L_39:defineFloat("FRONT_ALT_10000", 632, { 0, 1 }, "Gauges", "Front Altimeter 10000ft")
L_39:defineFloat("FRONT_ALT_1000", 631, { 0, 1 }, "Gauges", "Front Altimeter 1000ft")
L_39:defineFloat("FRONT_ALT_100", 630, { 0, 1 }, "Gauges", "Front Altimeter 100ft")
L_39:defineFloat("FRONT_PRESS_SET_0", 636, { 0, 1 }, "Gauges", "Front Altimeter Pressure Setting 0")
L_39:defineFloat("FRONT_PRESS_SET_1", 635, { 0, 1 }, "Gauges", "Front Altimeter Pressure Setting 1")
L_39:defineFloat("FRONT_PRESS_SET_2", 634, { 0, 1 }, "Gauges", "Front Altimeter Pressure Setting 2")
L_39:defineFloat("FRONT_PRESS_SET_3", 633, { 0, 1 }, "Gauges", "Front Altimeter Pressure Setting 3")
L_39:defineFloat("BACK_ALT_100_PTR", 737, { 0, 1 }, "Gauges", "Back Altimeter 100ft Ptr")
L_39:defineFloat("BACK_ALT_10000", 732, { 0, 1 }, "Gauges", "Back Altimeter 10000ft")
L_39:defineFloat("BACK_ALT_1000", 731, { 0, 1 }, "Gauges", "Back Altimeter 1000ft")
L_39:defineFloat("BACK_ALT_100", 730, { 0, 1 }, "Gauges", "Back Altimeter 100ft")
L_39:defineFloat("BACK_PRESS_SET_0", 736, { 0, 1 }, "Gauges", "Back Altimeter Pressure Setting 0")
L_39:defineFloat("BACK_PRESS_SET_1", 735, { 0, 1 }, "Gauges", "Back Altimeter Pressure Setting 1")
L_39:defineFloat("BACK_PRESS_SET_2", 734, { 0, 1 }, "Gauges", "Back Altimeter Pressure Setting 2")
L_39:defineFloat("BACK_PRESS_SET_3", 733, { 0, 1 }, "Gauges", "Back Altimeter Pressure Setting 3")

L_39:defineFloat("FRONT_VARIOMETER", 74, { -1.0, 1.0 }, "Gauges", "Front Variometer")
L_39:defineFloat("FRONT_VARIOMETER_TURN", 75, { -1.0, 1.0 }, "Gauges", "Front Variometer Turn Indicator")
L_39:defineFloat("FRONT_VARIOMETER_SLIP", 76, { -1, 1 }, "Gauges", "Front Variometer Sideslip Indicator")
L_39:defineFloat("BACK_VARIOMETER", 416, { -1.0, 1.0 }, "Gauges", "Back Variometer")
L_39:defineFloat("BACK_VARIOMETER_TURN", 417, { -1, 1 }, "Gauges", "Back Variometer Turn Indicator")
L_39:defineFloat("BACK_VARIOMETER_SLIP", 418, { -1, 1 }, "Gauges", "Back Variometer Sideslip Indicator")

L_39:defineFloat("FRONT_KPP1273K_ROLL", 38, { -1, 1 }, "Gauges", "Front Artifical Horizont KPP Roll")
L_39:defineFloat("FRONT_KPP1273K_PITCH", 31, { -0.5, 0.5 }, "Gauges", "Front Artifical Horizont KPP Pitch")
L_39:defineFloat("FRONT_KPP1273K_SLIP", 40, { -1, 1 }, "Gauges", "Front Artifical Horizont KPP Sideslip")
L_39:defineFloat("FRONT_KPP1273K_DEVBAR_CRS", 35, { -1, 1 }, "Gauges", "Front Artifical Horizont KPP Course Deviation Bar")
L_39:defineFloat("FRONT_KPP1273K_DEVBAR_ATL", 34, { -1, 1 }, "Gauges", "Front Artifical Horizont KPP Altitude Deviation Bar")
L_39:defineFloat("FRONT_KPP1273K_BEACON_GLIDE", 36, { 0, 1 }, "Gauges", "Front Artifical Horizont KPP Glide Beacon")
L_39:defineFloat("FRONT_KPP1273K_BEACON_LOCAL", 37, { 0, 1 }, "Gauges", "Front Artifical Horizont KPP Localizer Beacon")
L_39:defineFloat("FRONT_KPP1273K_SDU_ROLL", 32, { -1, 1 }, "Gauges", "Front Artifical Horizont KPP SDU Roll")
L_39:defineFloat("FRONT_KPP1273K_SDU_PITCH", 33, { -1, 1 }, "Gauges", "Front Artifical Horizont KPP SDU Pitch ")
L_39:defineFloat("BACK_KPP1273K_ROLL", 375, { -1, 1 }, "Gauges", "Back Artifical Horizont KPP Roll")
L_39:defineFloat("BACK_KPP1273K_PITCH", 368, { -0.5, 0.5 }, "Gauges", "Back Artifical Horizont KPP Pitch")
L_39:defineFloat("BACK_KPP1273K_SLIP", 377, { -1, 1 }, "Gauges", "Back Artifical Horizont KPP Sideslip")
L_39:defineFloat("BACK_KPP1273K_DEVBAR_CRS", 372, { -1, 1 }, "Gauges", "Back Artifical Horizont KPP Course Deviation Bar")
L_39:defineFloat("BACK_KPP1273K_DEVBAR_ATL", 371, { -1, 1 }, "Gauges", "Back Artifical Horizont KPP Altitude Deviation Bar")
L_39:defineFloat("BACK_KPP1273K_BEACON_GLIDE", 373, { 0, 1 }, "Gauges", "Back Artifical Horizont KPP Glide Beacon")
L_39:defineFloat("BACK_KPP1273K_BEACON_LOCAL", 374, { 0, 1 }, "Gauges", "Back Artifical Horizont KPP Localizer Beacon")
L_39:defineFloat("BACK_KPP1273K_SDU_ROLL", 369, { -1, 1 }, "Gauges", "Back Artifical Horizont KPP SDU Roll")
L_39:defineFloat("BACK_KPP1273K_SDU_PITCH", 370, { -1, 1 }, "Gauges", "Back Artifical Horizont KPP SDU Pitch ")

L_39:defineFloat("FRONT_HSI_HDG", 41, { 1.0, 0.0 }, "Gauges", " FRONT HSI Heading")
L_39:defineFloat("FRONT_HSI_COM_CRS_NEEDLE", 42, { 1.0, 0.0 }, "Gauges", "Front HSI Commanded Course Needle")
L_39:defineFloat("FRONT_HSI_BRG_NEEDLE", 43, { 0, 1 }, "Gauges", "Front HSI Bearing Needle")
L_39:defineFloat("FRONT_HSI_DEV_BAR_CRS", 47, { -0.8, 0.8 }, "Gauges", "Front HSI Course Deviation Bar")
L_39:defineFloat("FRONT_HSI_DEV_BAR_ALT", 45, { -0.8, 0.8 }, "Gauges", "Front HSI Altitude Deviation Bar")
L_39:defineFloat("FRONT_HSI_BEACON_GLIDE", 46, { 0, 1 }, "Gauges", "Front HSI Glide Beacon")
L_39:defineFloat("FRONT_HSI_BEACON_LOCAL", 44, { 0, 1 }, "Gauges", "Front HSI Localizer Beacon")
L_39:defineFloat("BACK_HSI_HDG", 378, { 1.0, 0.0 }, "Gauges", " BACK HSI Heading")
L_39:defineFloat("BACK_HSI_COM_CRS_NEEDLE", 379, { 1.0, 0.0 }, "Gauges", "Back HSI Commanded Course Needle")
L_39:defineFloat("BACK_HSI_BRG_NEEDLE", 380, { 0, 1 }, "Gauges", "Back HSI Bearing Needle")
L_39:defineFloat("BACK_HSI_DEV_BAR_CRS", 384, { -0.8, 0.8 }, "Gauges", "Back HSI Course Deviation Bar")
L_39:defineFloat("BACK_HSI_DEV_BAR_ALT", 382, { -0.8, 0.8 }, "Gauges", "Back HSI Altitude Deviation Bar")
L_39:defineFloat("BACK_HSI_BEACON_GLIDE", 383, { 0, 1 }, "Gauges", "Back HSI Glide Beacon")
L_39:defineFloat("BACK_HSI_BEACON_LOCAL", 381, { 0, 1 }, "Gauges", "Back HSI Localizer Beacon")

L_39:defineFloat("FRONT_RSBN_RANGE_1", 64, { 0, 1 }, "Gauges", "Front Range RSBN 1KM")
L_39:defineFloat("FRONT_RSBN_RANGE_10", 65, { 0, 1 }, "Gauges", "Front Range RSBN 10KM")
L_39:defineFloat("FRONT_RSBN_RANGE_100", 66, { 0, 1 }, "Gauges", "Front Range RSBN 100KM")
L_39:defineFloat("BACK_RSBN_RANGE_1", 402, { 0, 1 }, "Gauges", "Back Range RSBN 1KM")
L_39:defineFloat("BACK_RSBN_RANGE_10", 403, { 0, 1 }, "Gauges", "Back Range RSBN 10KM")
L_39:defineFloat("BACK_RSBN_RANGE_100", 404, { 0, 1 }, "Gauges", "Back Range RSBN 100KM")
L_39:defineFloat("FRONT_RSBN_CHAN_NAV_GAUGE", 189, { 0.0, 0.39 }, "Gauges", "Front RSBN NAV Channel")
L_39:defineFloat("FRONT_RSBN_CHAN_LAND_GAUGE", 190, { 0.0, 0.39 }, "Gauges", "Front RSBN LAND Channel")
L_39:defineFloat("FRONT_RSBN_BACK_LIGHT", 580, { 0, 1 }, "Gauges", "Front RSBN Back Panel Light")

L_39:defineFloat("FRONT_IAS", 49, { 0.0, 1.0 }, "Gauges", "Front IAS (indicated)")
L_39:defineFloat("FRONT_TAS", 50, { 0.0, 1.0 }, "Gauges", "Front TAS (true)")
L_39:defineFloat("FRONT_MACH", 51, { 0, 1 }, "Gauges", "Front Number of MACH")
L_39:defineFloat("BACK_IAS", 386, { 0.0, 1.0 }, "Gauges", "Back IAS (indicated)")
L_39:defineFloat("BACK_TAS", 387, { 0.0, 1.0 }, "Gauges", "Back TAS (true)")
L_39:defineFloat("BACK_MACH", 388, { 0, 1 }, "Gauges", "Back Number of MACH")

L_39:defineFloat("FRONT_RKL41_NEEDLE", 77, { 0, 1 }, "Gauges", "Front RKL Indicator Needle")
L_39:defineFloat("FRONT_RKL41_SIGNAL", 156, { 0, 1 }, "Gauges", "Front RKL Signal Strength")
L_39:defineFloat("BACK_RKL41_NEEDLE", 420, { 0, 1 }, "Gauges", "Back RKL Indicator Needle")
L_39:defineFloat("BACK_RKL41_SIGNAL", 513, { 0, 1 }, "Gauges", "Back RKL Signal Strength")
L_39:defineFloat("BACK_KM8_HDG", 531, { 0, 1 }, "Gauges", "Back KM-8 Heading")
L_39:defineFloat("BACK_KM8_VARIATION", 530, { 1.0, -1.0 }, "Gauges", "Back KM-8 Variation")

L_39:defineFloat("FRONT_VOLT_METER", 92, { 0, 1 }, "Gauges", "Front Voltmeter")
L_39:defineFloat("FRONT_AMP_METER", 93, { 0, 1 }, "Gauges", "Front Ampermeter")

L_39:defineFloat("FRONT_OXY_PRESS", 301, { 0.0, 1.0 }, "Gauges", "Front Oxygen Pressure")
L_39:defineFloat("FRONT_OXY_FLOW", 302, { 0, 1 }, "Gauges", "Front Oxygen Flow Blinker")
L_39:defineFloat("BACK_OXY_PRESS", 477, { 0.0, 1.0 }, "Gauges", "Back Oxygen Pressure")
L_39:defineFloat("BACK_OXY_FLOW", 478, { 0, 1 }, "Gauges", "Back Oxygen Flow Blinker")

L_39:defineFloat("FRONT_ACCEL_G", 86, { 0, 1 }, "Gauges", "Front G Indicator")
L_39:defineFloat("FRONT_ACCEL_MIN", 88, { 0.31, 0.695 }, "Gauges", "Front Min G Indicator")
L_39:defineFloat("FRONT_ACCEL_MAX", 87, { 0, 1 }, "Gauges", "Front Max G Indicator")

L_39:defineFloat("FRONT_CPT_ALT", 95, { 0, 1 }, "Gauges", "Front Cockpit Altitude")
L_39:defineFloat("FRONT_PRESS_DIFF", 96, { 0.0, 1.0 }, "Gauges", "Front Differantial Cabine Pressure")
L_39:defineFloat("BACK_CPT_ALT", 550, { 0, 1 }, "Gauges", "Back Cockpit Altitude")
L_39:defineFloat("BACK_PRESS_DIFF", 551, { 0.0, 1.0 }, "Gauges", "Back Differantial Cabine Pressure")

L_39:defineFloat("FRONT_MAIN_HYD_PRESS", 198, { 0, 1 }, "Gauges", "Front Main Hydraulic Pressure")
L_39:defineFloat("FRONT_AUX_HYD_PRESS", 200, { 0, 1 }, "Gauges", "Front AUX Hydraulic Pressure")
L_39:defineFloat("FRONT_BRAKE_L_HYD_PRESS", 98, { 0, 1 }, "Gauges", "Front Left Brake Pressure")
L_39:defineFloat("FRONT_BRAKE_R_HYD_PRESS", 99, { 0, 1 }, "Gauges", "Front Right Brake Pressure")
L_39:defineFloat("FRONT_BRAKE_AUX_HYD_PRESS", 100, { 0, 1 }, "Gauges", "Front AUX Brake Pressure")

L_39:defineFloat("FRONT_FUEL_QUANT", 91, { 0.0, 1.0 }, "Gauges", "Front Fuel Quantity")
L_39:defineFloat("FRONT_FUEL_PRESS", 81, { 0.0, 1.0 }, "Gauges", "Front Fuel Pressure")
L_39:defineFloat("FRONT_FAN_RPM", 85, { 0.0, 1.0 }, "Gauges", "Front FAN RPM")
L_39:defineFloat("FRONT_COMP_RPM", 84, { 0.0, 1.0 }, "Gauges", "Front Compressor RPM")
L_39:defineFloat("FRONT_ENG_TEMP", 90, { 0, 1 }, "Gauges", "Front Engine Temperature")
L_39:defineFloat("FRONT_ENG_VIB", 94, { 0, 1 }, "Gauges", "Front Engine Vibrations Indicator")
L_39:defineFloat("FRONT_OIL_TEMP", 83, { 0.0, 1.0 }, "Gauges", "Front Oil Temperature")
L_39:defineFloat("FRONT_OIL_PRESS", 82, { 0.0, 1.0 }, "Gauges", "Front Oil Pressure")
L_39:defineFloat("FRONT_PITCH_TRIM", 247, { 1.0, -1.0 }, "Gauges", "Front Pitch Trim Indicator")
L_39:defineFloat("BACK_FUEL_QUANT", 427, { 0, 1 }, "Gauges", "Back Fuel Quantity")
L_39:defineFloat("BACK_FUEL_PRESS", 421, { 0.0, 1.0 }, "Gauges", "Back Fuel Pressure")
L_39:defineFloat("BACK_FAN_RPM", 425, { 0.0, 1.0 }, "Gauges", "Back FAN RPM")
L_39:defineFloat("BACK_COMP_RPM", 424, { 0.0, 1.0 }, "Gauges", "Back Compressor RPM")
L_39:defineFloat("BACK_ENG_TEMP", 426, { 0, 1 }, "Gauges", "Back Engine Temperature")
L_39:defineFloat("BACK_OIL_TEMP", 423, { 0.0, 1.0 }, "Gauges", "Back Oil Temperature")
L_39:defineFloat("BACK_OIL_PRESS", 422, { 0.0, 1.0 }, "Gauges", "Back Oil Pressure")

L_39:defineFloat("FRONT_HELMET_OXY_PRESS", 300, { 0, 1 }, "Gauges", "Front Helmet Oxygen Pressure Indicator")

L_39:defineFloat("FRONT_BRAKE_HANDLE", 127, { 0, 1 }, "Gauges", "Front Brake Handle")
L_39:defineFloat("BACK_BRAKE_HANDLE", 542, { 0, 1 }, "Gauges", "Back Brake Handle")

L_39:defineFloat("FRONT_INST_LIGHT_INTENS", 553, { 0, 1 }, "Gauges", "Front Instrument Lights Intensity")
L_39:defineFloat("FRONT_COMP_LIGHT_INTENS", 558, { 0, 1 }, "Gauges", "Front Compass Lights Intensity")
L_39:defineFloat("FRONT_EMERG_LIGHT_INTENS", 555, { 0, 1 }, "Gauges", "Front Emergency Lights Intensity")
L_39:defineFloat("BACK_INST_LIGHT_INTENS", 559, { 0, 1 }, "Gauges", "Back Instrument Lights Intensity")
L_39:defineFloat("BACK_EMERG_LIGHT_INTENS", 560, { 0, 1 }, "Gauges", "Back Emergency Lights Intensity")

------------------------------------ L-39 Lights --------------------------------------------------------------------

L_39:defineIndicatorLight("FRONT_WP_DANGER_ALT_LAMP", 2, "Warning, Caution and IndicatorLights", "Front Dangerous Altitude Lamp (red)")
L_39:defineIndicatorLight("FRONT_RV5_DANGER_ALT_LAMP", 63, "Warning, Caution and IndicatorLights", "Front Dangerous Radar Altitude Lamp (yellow)")
L_39:defineIndicatorLight("BACK_WP_DANGER_ALT_LAMP", 343, "Warning, Caution and IndicatorLights", "Back Dangerous Altitude Lamp (red)")
L_39:defineIndicatorLight("BACK_RV5_DANGER_ALT_LAMP", 401, "Warning, Caution and IndicatorLights", "Back Dangerous Radar Altitude Lamp (yellow)")

L_39:defineIndicatorLight("FRONT_L_GEAR_UP_LAMP", 109, "Warning, Caution and IndicatorLights", "Front Left Gear UP Lamp (red)")
L_39:defineIndicatorLight("FRONT_N_GEAR_UP_LAMP", 110, "Warning, Caution and IndicatorLights", "Front Nose Gear UP Lamp (red)")
L_39:defineIndicatorLight("FRONT_R_GEAR_UP_LAMP", 111, "Warning, Caution and IndicatorLights", "Front Right Gear UP Lamp (red)")
L_39:defineIndicatorLight("FRONT_L_GEAR_DOWN_LAMP", 112, "Warning, Caution and IndicatorLights", "Front Left Gear DOWN Lamp (green)")
L_39:defineIndicatorLight("FRONT_N_GEAR_DOWN_LAMP", 113, "Warning, Caution and IndicatorLights", "Front Nose Gear DOWN Lamp (green)")
L_39:defineIndicatorLight("FRONT_R_GEAR_DOWN_LAMP", 114, "Warning, Caution and IndicatorLights", "Front Right Gear DOWN Lamp (green)")
L_39:defineIndicatorLight("FRONT_GEAR_TRANS_LAMP", 115, "Warning, Caution and IndicatorLights", "Front Gear in Transition Lamp (red)")
L_39:defineIndicatorLight("FRONT_DOORS_OUT_LAMP", 116, "Warning, Caution and IndicatorLights", "Front Doors Out Lamp (red)")
L_39:defineIndicatorLight("FRONT_AIRBRAKE_LAMP", 117, "Warning, Caution and IndicatorLights", "Front Airbrake Lamp (green)")
L_39:defineIndicatorLight("BACK_L_GEAR_UP_LAMP", 428, "Warning, Caution and IndicatorLights", "Back Left Gear UP Lamp (red)")
L_39:defineIndicatorLight("BACK_N_GEAR_UP_LAMP", 429, "Warning, Caution and IndicatorLights", "Back Nose Gear UP Lamp (red)")
L_39:defineIndicatorLight("BACK_R_GEAR_UP_LAMP", 430, "Warning, Caution and IndicatorLights", "Back Right Gear UP Lamp (red)")
L_39:defineIndicatorLight("BACK_L_GEAR_DOWN_LAMP", 431, "Warning, Caution and IndicatorLights", "Back Left Gear DOWN Lamp (green)")
L_39:defineIndicatorLight("BACK_N_GEAR_DOWN_LAMP", 432, "Warning, Caution and IndicatorLights", "Back Nose Gear DOWN Lamp (green)")
L_39:defineIndicatorLight("BACK_R_GEAR_DOWN_LAMP", 433, "Warning, Caution and IndicatorLights", "Back Right Gear DOWN Lamp (green)")
L_39:defineIndicatorLight("BACK_GEAR_TRANS_LAMP", 434, "Warning, Caution and IndicatorLights", "Back Gear in Transition Lamp (red)")
L_39:defineIndicatorLight("BACK_DOORS_OUT_LAMP", 435, "Warning, Caution and IndicatorLights", "Back Doors Out Lamp (red)")
L_39:defineIndicatorLight("BACK_AIRBRAKE_LAMP", 436, "Warning, Caution and IndicatorLights", "Back Airbrake Lamp (green)")

L_39:defineIndicatorLight("FRONT_FLAPS_UP_LAMP", 278, "Warning, Caution and IndicatorLights", "Front Flaps 0° Lamp (green)")
L_39:defineIndicatorLight("FRONT_FLAPS_TO_LAMP", 279, "Warning, Caution and IndicatorLights", "Front Flaps 25° Lamp (green)")
L_39:defineIndicatorLight("FRONT_FLAPS_DN_LAMP", 280, "Warning, Caution and IndicatorLights", "Front Flaps 44° Lamp (green)")
L_39:defineIndicatorLight("BACK_FLAPS_UP_LAMP", 462, "Warning, Caution and IndicatorLights", "Back Flaps 0° Lamp (green)")
L_39:defineIndicatorLight("BACK_FLAPS_TO_LAMP", 463, "Warning, Caution and IndicatorLights", "Back Flaps 25° Lamp (green)")
L_39:defineIndicatorLight("BACK_FLAPS_DN_LAMP", 464, "Warning, Caution and IndicatorLights", "Back Flaps 44° Lamp (green)")

L_39:defineIndicatorLight("FRONT_RKL41_FAR_NDB_SEL_LAMP", 561, "Warning, Caution and IndicatorLights", "Front RKL-41 Far NDB Selector Lamp (white)")
L_39:defineIndicatorLight("FRONT_RKL41_NEAR_NDB_SEL_LAMP", 570, "Warning, Caution and IndicatorLights", "Front RKL-41 Near NDB Selector Lamp (white)")
L_39:defineIndicatorLight("BACK_RKL41_FAR_NDB_SEL_LAMP", 564, "Warning, Caution and IndicatorLights", "Back RKL-41 Far NDB Selector Lamp (white)")
L_39:defineIndicatorLight("BACK_RKL41_NEAR_NDB_SEL_LAMP", 571, "Warning, Caution and IndicatorLights", "Back RKL-41 Near NDB Selector Lamp (white)")

L_39:defineIndicatorLight("FRONT_MRP56_LAMP", 18, "Warning, Caution and IndicatorLights", "Front MRP 56 MARKER Lamp (green)")
L_39:defineIndicatorLight("BACK_MRP56_LAMP", 358, "Warning, Caution and IndicatorLights", "Back MRP 56 MARKER Lamp (green)")
L_39:defineIndicatorLight("FRONT_GEN_LAMP", 6, "Warning, Caution and IndicatorLights", "Front Generator Lamp (red)")
L_39:defineIndicatorLight("BACK_GEN_LAMP", 347, "Warning, Caution and IndicatorLights", "Back Generator Lamp (red)")
L_39:defineIndicatorLight("FRONT_EMERG_GEN_LAMP", 9, "Warning, Caution and IndicatorLights", "Front Emergency Generator Lamp (red)")
L_39:defineIndicatorLight("BACK_EMERG_GEN_LAMP", 350, "Warning, Caution and IndicatorLights", "Back Emergency Generator Lamp (red)")
L_39:defineIndicatorLight("FRONT_INVER_115_LAMP", 12, "Warning, Caution and IndicatorLights", "Front Inverter 115V Lamp (red)")
L_39:defineIndicatorLight("FRONT_INVER_363_LAMP", 16, "Warning, Caution and IndicatorLights", "Front Inverter 3x36V Lamp (red)")
L_39:defineIndicatorLight("BACK_INVER_115_LAMP", 353, "Warning, Caution and IndicatorLights", "Back Inverter 115V Lamp (red)")
L_39:defineIndicatorLight("BACK_INVER_363_LAMP", 357, "Warning, Caution and IndicatorLights", "Back Inverter 3x36V Lamp (red)")
L_39:defineIndicatorLight("FRONT_GND_POWER_LAMP", 316, "Warning, Caution and IndicatorLights", " FRONT Ground Power Lamp (yellow)")
L_39:defineIndicatorLight("FRONT_FIRE_LAMP", 1, "Warning, Caution and IndicatorLights", "Front FIRE Lamp (red)")
L_39:defineIndicatorLight("BACK_FIRE_LAMP", 342, "Warning, Caution and IndicatorLights", "Back FIRE Lamp (red)")
L_39:defineIndicatorLight("FRONT_MACH_LAMP", 3, "Warning, Caution and IndicatorLights", "Front MAX Mach Lamp (red)")
L_39:defineIndicatorLight("BACK_MACH_LAMP", 344, "Warning, Caution and IndicatorLights", "Back MAX Mach Lamp (red)")
L_39:defineIndicatorLight("FRONT_RSBN_AZIM_CORR_LAMP", 185, "Warning, Caution and IndicatorLights", "Front RSBN correction Azimuth Lamp (green)")
L_39:defineIndicatorLight("FRONT_RSBN_RANGE_CORR_LAMP", 186, "Warning, Caution and IndicatorLights", "Front RSBN correction Distance Lamp (green)")
L_39:defineIndicatorLight("BACK_RSBN_AZIM_CORR_LAMP", 359, "Warning, Caution and IndicatorLights", "Back RSBN correction Azimuth Lamp (green)")
L_39:defineIndicatorLight("BACK_RSBN_RANGE_CORR_LAMP", 362, "Warning, Caution and IndicatorLights", "Back RSBN correction Distance Lamp (green)")
L_39:defineIndicatorLight("FRONT_DECENT_END_LAMP", 15, "Warning, Caution and IndicatorLights", "Front END OF DECEND Lamp (green)")
L_39:defineIndicatorLight("BACK_DECENT_END_LAMP", 356, "Warning, Caution and IndicatorLights", "Back END OF DECEND Lamp (green)")
L_39:defineIndicatorLight("FRONT_GYRO_MISS_LAMP", 123, "Warning, Caution and IndicatorLights", "Front Gyroscope Misalignment Lamp (red)")
L_39:defineIndicatorLight("BACK_GYRO_MISS_LAMP", 443, "Warning, Caution and IndicatorLights", "Back Gyroscope Misalignment Lamp (red)")
L_39:defineIndicatorLight("FRONT_GYRO_MISS_PU26_LAMP", 206, "Warning, Caution and IndicatorLights", "Front Gyroscope Misalignment PU-26 Lamp (white)")
L_39:defineIndicatorLight("FRONT_HSI_OK_LAMP", 19, "Warning, Caution and IndicatorLights", "Front CONFROM AZIMUTH Lamp (green)")
L_39:defineIndicatorLight("FRONT_EMERG_FUEL_LAMP", 27, "Warning, Caution and IndicatorLights", "Front Emergency Fuel System Lamp (yellow)")
L_39:defineIndicatorLight("BACK_EMERG_FUEL_LAMP", 365, "Warning, Caution and IndicatorLights", "Back Emergency Fuel System Lamp (yellow)")
L_39:defineIndicatorLight("FRONT_TURBO_START_LAMP", 23, "Warning, Caution and IndicatorLights", "Front Turbine Starter Lamp (yellow)")
L_39:defineIndicatorLight("FRONT_FUEL_150_LAMP", 4, "Warning, Caution and IndicatorLights", "Front Remain 150Kg Fuel Lamp (red)")
L_39:defineIndicatorLight("BACK_FUEL_150_LAMP", 345, "Warning, Caution and IndicatorLights", "Back Remain 150Kg Fuel Lamp (red)")
L_39:defineIndicatorLight("FRONT_NO_START_LAMP", 7, "Warning, Caution and IndicatorLights", "Front Do Not Start Lamp (red)")
L_39:defineIndicatorLight("BACK_NO_START_LAMP", 348, "Warning, Caution and IndicatorLights", "Back Do Not Start Lamp (red)")
L_39:defineIndicatorLight("FRONT_FUEL_FILTER_LAMP", 26, "Warning, Caution and IndicatorLights", "Front Fuel Filter Lamp (red)")
L_39:defineIndicatorLight("BACK_FUEL_FILTER_LAMP", 364, "Warning, Caution and IndicatorLights", "Back Fuel Filter Lamp (red)")
L_39:defineIndicatorLight("L39C_FRONT_WING_TANKS_LAMP", 14, "Warning, Caution and IndicatorLights", "L-39C FRONT Wing Tanks Empty Lamp (green)")
L_39:defineIndicatorLight("L39C_BACK_WING_TANKS_LAMP", 355, "Warning, Caution and IndicatorLights", "L-39C BACK Wing Tanks Empty Lamp (green)")
L_39:defineIndicatorLight("L39ZA_FRONT_WING_TANKS_LAMP", 13, "Warning, Caution and IndicatorLights", "L-39ZA FRONT Wing Tanks Empty Lamp (green)")
L_39:defineIndicatorLight("L39ZA_BACK_WING_TANKS_LAMP", 354, "Warning, Caution and IndicatorLights", "L-39ZA BACK Wing Tanks Empty Lamp (green)")
L_39:defineIndicatorLight("FRONT_AIL_TRIM_NEUTRAL_LAMP", 246, "Warning, Caution and IndicatorLights", "Front Aileron Trimmer Neutral Position Lamp (green)")
L_39:defineIndicatorLight("FRONT_CANOPY_UNLOCK_LAMP", 10, "Warning, Caution and IndicatorLights", "Front Canopy Unlocked Lamp (red)")
L_39:defineIndicatorLight("BACK_CANOPY_UNLOCK_LAMP", 351, "Warning, Caution and IndicatorLights", "Back Canopy Unlocked Lamp (red)")
L_39:defineIndicatorLight("FRONT_PITOT_L_LAMP", 556, "Warning, Caution and IndicatorLights", "Front Pitot Left Lamp (green)")
L_39:defineIndicatorLight("FRONT_PITOT_R_LAMP", 557, "Warning, Caution and IndicatorLights", "Front Pitot Right Lamp (green)")
L_39:defineIndicatorLight("BACK_AIL_TRIM_NEUTRAL_LAMP", 441, "Warning, Caution and IndicatorLights", "Back Aileron Trimmer Neutral Position Lamp (yellow)")
L_39:defineIndicatorLight("BACK_ELE_TRIM_NEUTRAL_LAMP", 442, "Warning, Caution and IndicatorLights", "Back Elevator Trimmer Neutral Position Lamp (yellow)")
L_39:defineIndicatorLight("FRONT_ENG_VIB_LAMP", 8, "Warning, Caution and IndicatorLights", "Front Engine Vibrations Lamp (red)")
L_39:defineIndicatorLight("BACK_ENG_VIB_LAMP", 346, "Warning, Caution and IndicatorLights", "Back Engine Vibrations Lamp (red)")
L_39:defineIndicatorLight("FRONT_ENG_TEMP_700_LAMP", 28, "Warning, Caution and IndicatorLights", "Front Engine Temperature 700C Lamp (yellow)")
L_39:defineIndicatorLight("FRONT_ENG_TEMP_730_LAMP", 24, "Warning, Caution and IndicatorLights", "Front Engine Temperature 730C Lamp (red)")
L_39:defineIndicatorLight("FRONT_OIL_PRESS_LAMP", 20, "Warning, Caution and IndicatorLights", "Front MIN Oil Press Lamp (red)")
L_39:defineIndicatorLight("FRONT_CPT_PRESS_LAMP", 11, "Warning, Caution and IndicatorLights", "Front Cabin Pressure Lamp (red)")
L_39:defineIndicatorLight("BACK_CPT_PRESS_LAMP", 352, "Warning, Caution and IndicatorLights", "Back Cabin Pressure Lamp (red)")
L_39:defineIndicatorLight("FRONT_AIRCOND_OFF_LAMP", 22, "Warning, Caution and IndicatorLights", "Front Aircondition OFF Lamp (red)")
L_39:defineIndicatorLight("BACK_AIRCOND_OFF_LAMP", 361, "Warning, Caution and IndicatorLights", "Back Aircondition OFF Lamp (red)")
L_39:defineIndicatorLight("FRONT_EMERG_AIRCOND_LAMP", 17, "Warning, Caution and IndicatorLights", "Front Emergency Aircondition Lamp (red)")
L_39:defineIndicatorLight("FRONT_DEICE_LAMP", 25, "Warning, Caution and IndicatorLights", "Front De Icing ON Lamp (green)")
L_39:defineIndicatorLight("BACK_DEICE_LAMP", 363, "Warning, Caution and IndicatorLights", "Back De Icing ON Lamp (green)")
L_39:defineIndicatorLight("FRONT_ICE_LAMP", 21, "Warning, Caution and IndicatorLights", "Front Ice Warning Lamp (yellow)")
L_39:defineIndicatorLight("BACK_ICE_LAMP", 360, "Warning, Caution and IndicatorLights", "Back Ice Warning Lamp (yellow)")
L_39:defineIndicatorLight("FRONT_RIO_HEAT_LAMP", 182, "Warning, Caution and IndicatorLights", "Front RIO Heating ON Lamp (green)")
L_39:defineIndicatorLight("FRONT_HYD_FAIL_LAMP", 5, "Warning, Caution and IndicatorLights", "Front Hydraulic System Fail Lamp (red)")
L_39:defineIndicatorLight("BACK_HYD_FAIL_LAMP", 346, "Warning, Caution and IndicatorLights", "Back Hydraulic System Fail Lamp (red)")
L_39:defineIndicatorLight("FRONT_MASTER_CAUTION_LAMP", 253, "Warning, Caution and IndicatorLights", "Front Master Caution Lamp (red)")
L_39:defineIndicatorLight("BACK_MASTER_CAUTION_LAMP", 455, "Warning, Caution and IndicatorLights", "Back Master Caution Lamp (red)")
L_39:defineIndicatorLight("FRONT_RADIO_CONTROL_LAMP", 562, "Warning, Caution and IndicatorLights", "Front Radio Control Lamp (white)")
L_39:defineIndicatorLight("FRONT_KPP1273K_ARRETIR_L", 29, "Warning, Caution and IndicatorLights", "Front Artifical Horizont KPP Arretir Lamp (red)")
L_39:defineIndicatorLight("BACK_KPP1273K_ARRETIR_L", 366, "Warning, Caution and IndicatorLights", "Back Artifical Horizont KPP Arretir Lamp (red)")
L_39:defineIndicatorLight("FRONT_SARPP_LAMP", 299, "Warning, Caution and IndicatorLights", "Front SARPP Indicator Lamp (green)")
L_39:defineIndicatorLight("FRONT_RKL41_BACK_LIGHT", 563, "Warning, Caution and IndicatorLights", "Front RKL-41 Back Panel Light")
L_39:defineIndicatorLight("BACK_RKL41_BACK_LIGHT", 566, "Warning, Caution and IndicatorLights", "Back RKL-41 Back Panel Light")

------------------------------------ L-39 Clickable Controls --------------------------------------------------------------------
-- ASP-3NMU Gunsight
L_39:defineToggleSwitch("FRONT_GUNSIDE_MODE", 1, 3003, 101, "Gunsight", "Front ASP-3NMU Gunsight Mode, GYRO/FIXED")
L_39:definePotentiometer("FRONT_GUNSIDE_BRIGHT", 1, 3004, 102, { 0, 1 }, "Gunsight", "Front ASP-3NMU Gunsight Brightness Knob")
L_39:definePotentiometer("FRONT_GUNSIDE_WINGSPAN", 1, 3001, 103, { 0, 1 }, "Gunsight", "Front ASP-3NMU Target Wingspan Adjustment Dial (m)")
L_39:defineToggleSwitch("FRONT_GUNSIDE_FILTER", 1, 3012, 104, "Gunsight", "Front ASP-3NMU Gunsight Color Filter, ON/OFF")
L_39:defineToggleSwitch("FRONT_GUNSIDE_RETICLE", 1, 3011, 105, "Gunsight", "Front ASP-3NMU Gunsight Fixed Reticle Mask Lever")
L_39:definePotentiometer("FRONT_GUNSIDE_DEPRESS", 1, 3016, 106, { 0, 1 }, "Gunsight", "Front ASP-3NMU Gunsight Mirror Depression")
L_39:definePotentiometer("FRONT_GUNSIDE_DISTANCE", 1, 3002, 107, { 0, 1 }, "Gunsight", "Front ASP-3NMU Gunsight Target Distance")

-- CLOCK
L_39:definePushButton("FRONT_CLOCK_PUSH_L", 12, 3001, 335, "Clock", "Front Clock Left Push Button")
L_39:defineRotary("FRONT_CLOCK_ROTATE_L", 12, 3003, 336, "Clock", "Front Clock Left Rotate Knob")
L_39:definePushButton("FRONT_CLOCK_PUSH_R", 12, 3004, 337, "Clock", "Front Clock Right Push Button")
L_39:defineRotary("FRONT_CLOCK_ROTATE_R", 12, 3005, 338, "Clock", "Front Clock Right Rotate Knob")
L_39:definePushButton("BACK_CLOCK_PUSH_L", 13, 3001, 412, "Clock", "Back Clock Left Push Button")
L_39:defineRotary("BACK_CLOCK_ROTATE_L", 13, 3003, 413, "Clock", "Back Clock Left Rotate Knob")
L_39:definePushButton("BACK_CLOCK_PUSH_R", 13, 3004, 414, "Clock", "Back Clock Right Push Button")
L_39:defineRotary("BACK_CLOCK_ROTATE_R", 13, 3005, 415, "Clock", "Back Clock Right Rotate Knob")

-- VD-20
L_39:definePotentiometer("FRONT_VD20_PRESS", 9, 3001, 57, { 0, 1 }, "VD20", "Front Baro Pressure QFE Knob")
L_39:definePotentiometer("BACK_VD20_PRESS", 10, 3001, 394, { 0, 1 }, "VD20", "Back Baro Pressure QFE Knob")

--RV-5M
L_39:definePushButton("FRONT_RV5M_TEST", 14, 3002, 60, "RV5M", "Front RV-5M Radio Altimeter Test Button")
L_39:defineRotary("FRONT_RV5M_HEIGH_KNOB", 14, 3001, 61, "RV5M", "Front RV-5M Radio Altimeter Decision Height Knob")
L_39:definePushButton("BACK_RV5M_TEST", 14, 3005, 398, "RV5M", "Back RV-5M Radio Altimeter Test Button")
L_39:defineRotary("BACK_RV5M_HEIGH_KNOB", 14, 3004, 399, "RV5M", "Back RV-5M Radio Altimeter Decision Height Knob")

-- GMK
L_39:defineToggleSwitch("FRONT_GMK_SELECT", 17, 3002, 204, "GMK", "Front GMK-1AE GMC Hemisphere Selection Switch, N(orth)/S(outh)")
L_39:defineToggleSwitch("FRONT_GMK_MODE", 17, 3004, 207, "GMK", "Front GMK-1AE GMC Mode Switch, MC(Magnetic Compass Mode)/GC(Directional Gyro Mode)")
L_39:define3PosTumb("FRONT_GMK_TEST", 17, 3003, 205, "GMK", "Front GMK-1AE GMC Test Switch, 0/OFF/300")
L_39:define3PosTumb("FRONT_GMK_CRS_SEL", 17, 3005, 208, "GMK", "Front GMK-1AE GMC Course Selector Switch, CCW/OFF/CW")
L_39:definePotentiometer("FRONT_GMK_LATITUDE", 17, 3006, 209, { 0.0, 0.728 }, "GMK", "Front GMK-1AE GMC Latitude Selector Knob")
L_39:definePushButton("FRONT_GMK_SET_GIRO", 17, 3012, 124, "GMK", "Front GMK-1AE MC Synchronization Button")
L_39:definePushButton("BACK_GMK_SET_GIRO", 17, 3013, 444, "GMK", "Back GMK-1AE MC Synchronization Button")
L_39:definePotentiometer("FRONT_GMK_MAG_VAR", 17, 3014, 532, { 0.0, 1.0 }, "GMK", "Front GMK-1AE Magnetic Declination Set Knob")

-- KPP-1273K
L_39:definePushButton("FRONT_KPP_ARRETIR", 22, 3002, 30, "KPP", "Front KPP-1273K ADI Cage Button")
L_39:definePotentiometer("FRONT_KPP_SET", 22, 3003, 39, { -1, 1 }, "KPP", "Front KPP-1273K ADI Trim Knob")
L_39:defineToggleSwitch("FRONT_SDU_SW", 41, 3001, 177, "KPP", "Front SDU Switch, ON/OFF")
L_39:defineToggleSwitch("BACK_AGD_FAIL_PITCH", 22, 3008, 460, "KPP", "Back AGD Pitch Failure")
L_39:defineToggleSwitch("BACK_AGD_FAIL_BANK", 22, 3009, 461, "KPP", "Back AGD Bank Failure")
L_39:definePushButton("BACK_KPP_ARRETIR", 23, 3002, 367, "KPP", "Back KPP-1273K ADI Cage Button")
L_39:definePotentiometer("BACK_KPP_SET", 23, 3003, 376, { -1, 1 }, "KPP", "Back KPP-1273K ADI Trim Knob")

-- NPP
L_39:defineRotary("FRONT_HSI_CRS", 24, 3001, 48, "NPP", "Front HSI Course Set Knob")
L_39:definePushButton("BACK_FAIL_CRS", 25, 3002, 526, "NPP", "Back Course Accordance")
L_39:defineToggleSwitch("BACK_FAIL_GMK", 24, 3002, 458, "NPP", "Back GMK Failure")
L_39:defineRotary("BACK_HSI_CRS", 25, 3001, 385, "NPP", "Back HSI Course Set Knob")

--ISKRA
L_39:defineTumb("FRONT_RSBN_MODE", 31, 3001, 178, 0.1, { 0, 0.2 }, nil, false, "ISKRA", "Front RSBN Mode Switch, LANDING/NAVIGATION/GLIDE PATH")
L_39:definePushButton("FRONT_RSBN_IDENT", 31, 3002, 179, "ISKRA", "Front RSBN Identification Button")
L_39:definePushButton("FRONT_RSBN_TEST", 31, 3003, 180, "ISKRA", "Front RSBN Test Button")
L_39:definePotentiometer("FRONT_RSBN_LIGHT_KNOB", 31, 3004, 181, { 0, 1 }, "ISKRA", "Front RSBN Control Box Lighting Intensity Knob")
L_39:definePotentiometer("FRONT_RSBN_VOL", 31, 3005, 184, { 0.0, 0.8 }, "ISKRA", "Front RSBN Volume Knob")
L_39:define3PosTumb("FRONT_RSBN_SET_AZ", 31, 3006, 187, "ISKRA", "Front RSBN Initial Azimuth")
L_39:define3PosTumb("FRONT_RSBN_SET_RANGE", 31, 3007, 188, "ISKRA", "Front RSBN Initial Range")
L_39:defineMultipositionSwitch("FRONT_RSBN_CHAN_NAV_KNOB", 31, 3008, 191, 40, 0.025, "ISKRA", "Front RSBN Navigation Channel Selector Knob")
L_39:defineMultipositionSwitch("FRONT_RSBN_CHAN_LAND_KNOB", 31, 3009, 192, 40, 0.025, "ISKRA", "Front RSBN Landing Channel Selector Knob")
L_39:definePushButton("FRONT_RSBN_SET_AZ0", 31, 3010, 193, "ISKRA", "Front RSBN Set 0 Azimuth")
L_39:definePotentiometer("FRONT_RSBN_ALT_SEL", 31, 3011, 201, { 0.0, 1.0 }, "ISKRA", "Front RSBN Field Elevation Knob")
L_39:definePushButton("FRONT_RSBN_BEACON", 31, 3012, 297, "ISKRA", "Front RSBN Listen Callsign Button")
L_39:defineToggleSwitch("FRONT_RSBN_EMERG_LAND", 31, 3013, 527, "ISKRA", "Front RSBN Emergency Landing Switch, ON/OFF")

-- Variometer
L_39:definePotentiometer("FRONT_VV_SET", 15, 3001, 569, { 0, 1 }, "Variometer", "Front Variometer Adjustment Knob")
L_39:definePotentiometer("BACK_VV_SET", 16, 3001, 419, { 0, 1 }, "Variometer", "Back Variometer Adjustment Knob")

-- RKL-41
L_39:defineToggleSwitch("FRONT_RKL_BEACON_SW", 21, 3011, 119, "RKL41", "Front RKL-41 ADF Outer-Inner Beacon (Far-Near NDB) Switch")
L_39:definePotentiometer("FRONT_RKL_VOL", 21, 3001, 157, { 0, 1 }, "RKL41", "Front RKL-41 ADF Volume Knob")
L_39:definePotentiometer("FRONT_RKL_BRIGHT", 21, 3013, 161, { 0, 1 }, "RKL41", "Front RKL-41 ADF Brightness Knob")
L_39:defineToggleSwitch("FRONT_RKL_TLF_TLG", 21, 3002, 159, "RKL41", "Front RKL-41 ADF Mode Switch, TLF(A3)/TLG(A1,A2)")
L_39:defineMultipositionSwitch("FRONT_RKL_MODE", 21, 3003, 160, 5, 0.1, "RKL41", "Front RKL-41 ADF Function Selector Switch, OFF/COMP(AUTO)/COMP(MAN)/ANT/LOOP")
L_39:define3PosTumb("FRONT_RKL_LOOP_SW", 21, 3010, 162, "RKL41", "Front RKL-41 ADF Loop Switch, LEFT/OFF/RIGHT")
L_39:defineToggleSwitch("FRONT_RKL_REMOTE", 21, 3012, 158, "RKL41", "Front RKL-41 ADF Control Switch, TAKE CONTROL/HAND OVER CONTROL")
L_39:definePotentiometer("FRONT_RKL_FREQ_1_TUNE", 21, 3004, 165, { 0, 1 }, "RKL41", "Front RKL-41 ADF Far NDB Frequency Tune")
L_39:defineTumb("FRONT_RKL_FREQ_1_XX00", 21, 3005, 163, 0.0588, { 0.0, 0.938 }, nil, false, "RKL41", "Front RKL-41 ADF Far NDB 100kHz Rotary")
L_39:defineTumb("FRONT_RKL_FREQ_1_00XX", 21, 3006, 164, 0.1, { 0.0, 0.9 }, nil, false, "RKL41", "Front RKL-41 ADF Far NDB 10kHz Rotary")
L_39:definePotentiometer("FRONT_RKL_FREQ_2_TUNE", 21, 3007, 168, { 0, 1 }, "RKL41", "Front RKL-41 ADF Near NDB Frequency Tune")
L_39:defineTumb("FRONT_RKL_FREQ_2_XX00", 21, 3008, 166, 0.0588, { 0.0, 0.938 }, nil, false, "RKL41", "Front RKL-41 ADF Near NDB 100kHz Rotary")
L_39:defineTumb("FRONT_RKL_FREQ_2_00XX", 21, 3009, 167, 0.1, { 0.0, 0.9 }, nil, false, "RKL41", "Front RKL-41 ADF Near NDB 10kHz Rotary")
L_39:defineToggleSwitch("BACK_RKL_BEACON_SW", 21, 3024, 440, "RKL41", "Back RKL-41 ADF Outer-Inner Beacon (Far-Near NDB) Switch")
L_39:definePotentiometer("BACK_RKL_VOL", 21, 3014, 514, { 0, 1 }, "RKL41", "Back RKL-41 ADF Volume Knob")
L_39:definePotentiometer("BACK_RKL_BRIGHT", 21, 3026, 518, { 0, 1 }, "RKL41", "Back RKL-41 ADF Brightness Knob")
L_39:defineToggleSwitch("BACK_RKL_TLF_TLG", 21, 3015, 516, "RKL41", "Back RKL-41 ADF Mode Switch, TLF(A3)/TLG(A1,A2)")
L_39:defineMultipositionSwitch("BACK_RKL_MODE", 21, 3016, 517, 5, 0.1, "RKL41", "Back RKL-41 ADF Function Selector Switch, OFF/COMP(AUTO)/COMP(MAN)/ANT/LOOP")
L_39:define3PosTumb("BACK_RKL_LOOP_SW", 21, 3010, 519, "RKL41", "Back RKL-41 ADF Loop Switch, LEFT/OFF/RIGHT")
L_39:defineToggleSwitch("BACK_RKL_REMOTE", 21, 3025, 515, "RKL41", "Back RKL-41 ADF Control Switch, TAKE CONTROL/HAND OVER CONTROL")
L_39:definePotentiometer("BACK_RKL_FREQ_1_TUNE", 21, 3017, 522, { 0, 1 }, "RKL41", "Back RKL-41 ADF Far NDB Frequency Tune")
L_39:defineTumb("BACK_RKL_FREQ_1_XX00", 21, 3018, 520, 0.0588, { 0.0, 0.938 }, nil, false, "RKL41", "Back RKL-41 ADF Far NDB 100kHz Rotary")
L_39:defineTumb("BACK_RKL_FREQ_1_00XX", 21, 3019, 521, 0.1, { 0.0, 0.9 }, nil, false, "RKL41", "Back RKL-41 ADF Far NDB 10kHz Rotary")
L_39:definePotentiometer("BACK_RKL_FREQ_2_TUNE", 21, 3020, 525, { 0, 1 }, "RKL41", "Back RKL-41 ADF Near NDB Frequency Tune")
L_39:defineTumb("BACK_RKL_FREQ_2_XX00", 21, 3021, 523, 0.0588, { 0.0, 0.938 }, nil, false, "RKL41", "Back RKL-41 ADF Near NDB 100kHz Rotary")
L_39:defineTumb("BACK_RKL_FREQ_2_00XX", 21, 3022, 524, 0.1, { 0.0, 0.9 }, nil, false, "RKL41", "Back RKL-41 ADF Near NDB 10kHz Rotary")
L_39:defineToggleSwitch("BACK_RKL_ARK_FAIL", 21, 3027, 459, "RKL41", "Back RKL-41 ARK Failure")

-- Electric System
L_39:defineToggleSwitch("FRONT_BATTERY_SW", 4, 3001, 141, "Electric System", "Front Accumulator Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_MAIN_GEN_SW", 4, 3002, 142, "Electric System", "Front Main Generator Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_EMERG_GEN_SW", 4, 3003, 143, "Electric System", "Front Emergency Generator Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_NET_SW", 4, 3004, 502, "Electric System", "Front Net Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_EMERG_ENG_INST_PW", 4, 3072, 169, "Electric System", "Front Emergency Engine Instruments Power Switch, ON/OFF")
L_39:definePushButton("FRONT_TURBO_BTN", 4, 3005, 315, "Electric System", "Front Turbo Button")
L_39:defineToggleSwitch("FRONT_TURBO_SW_COVER", 4, 3006, 314, "Electric System", "Front Turbo Button Cover, Open/Close")
L_39:definePushButton("BACK_TURBO_BTN", 4, 3007, 488, "Electric System", "Back Turbo Button")
L_39:defineToggleSwitch("BACK_TURBO_SW_COVER", 4, 3008, 487, "Electric System", "Back Turbo Button Cover, Open/Close")
L_39:defineToggleSwitch("FRONT_STOP_TURBO_SW", 4, 3009, 313, "Electric System", "Front Stop Turbo Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_STOP_TURBO_COVER", 4, 3010, 312, "Electric System", "Front Stop Turbo Switch Cover, Open/Close")
L_39:definePushButton("FRONT_ENGINE", 4, 3011, 326, "Electric System", "Front Engine Button")
L_39:defineToggleSwitch("FRONT_ENGINE_COVER", 4, 3012, 325, "Electric System", "Front Engine Button Cover")
L_39:definePushButton("BACK_ENGINE", 4, 3013, 494, "Electric System", "Back Engine Button")
L_39:defineToggleSwitch("BACK_ENGINE_COVER", 4, 3014, 493, "Electric System", "Back Engine Button Cover")
L_39:defineToggleSwitch("FRONT_STOP_ENGINE", 4, 3015, 318, "Electric System", "Front Stop Engine Switch")
L_39:defineToggleSwitch("FRONT_STOP_ENGINE_COVER", 4, 3016, 317, "Electric System", "Front Stop Engine Switch Cover, Open/Close")
L_39:defineToggleSwitch("BACK_STOP_ENGINE", 4, 3017, 490, "Electric System", "Back Stop Engine Switch")
L_39:defineToggleSwitch("BACK_STOP_ENGINE_COVER", 4, 3018, 489, "Electric System", "Back Stop Engine Switch Cover, Open/Close")
L_39:defineMultipositionSwitch("L39C_FRONT_ENG_START_MODE", 4, 3019, 322, 3, 0.1, "Electric System", "L-39C FRONT Engine Start Mode Switch")
L_39:define3PosTumb("L39ZA_FRONT_ENG_START_MODE", 4, 3019, 322, "Electric System", "L39ZA FRONT Engine Start Mode Switch")
L_39:defineToggleSwitch("FRONT_ENG_STRT_MODE_COVER", 4, 3020, 321, "Electric System", "Front Engine Start Mode Switch Cover, Open/Close")
L_39:defineToggleSwitch("FRONT_EMERG_FUEL", 4, 3021, 320, "Electric System", "Front Emergency Fuel Switch")
L_39:defineToggleSwitch("FRONT_EMERG_FUEL_COVER", 4, 3022, 319, "Electric System", "Front Emergency Fuel Switch Cover")
L_39:defineToggleSwitch("BACK_EMERG_FUEL", 4, 3023, 492, "Electric System", "Back Emergency Fuel Switch")
L_39:defineToggleSwitch("BACK_EMERG_FUEL_COVER", 4, 3024, 491, "Electric System", "Back Emergency Fuel Switch Cover")
L_39:defineToggleSwitch("CB_ENGINE", 4, 3025, 144, "Electric System", "CB Engine")
L_39:defineToggleSwitch("CB_AGD_GMK", 4, 3026, 145, "Electric System", "CB AGD-GMK")
L_39:defineToggleSwitch("CB_INVERT1", 4, 3027, 146, "Electric System", "CB Inverter 1 (AC 115V)")
L_39:defineToggleSwitch("CB_INVERT2", 4, 3028, 147, "Electric System", "CB Inverter 2 (AC 115V)")
L_39:defineToggleSwitch("CB_RTL", 4, 3029, 148, "Electric System", "CB RDO (ICS and Radio)")
L_39:defineToggleSwitch("CB_MRP_RV", 4, 3030, 149, "Electric System", "CB MRP-RV (Marker Beacon Receiver and Radio Altimeter)")
L_39:defineToggleSwitch("CB_ISKRA", 4, 3031, 150, "Electric System", "CB RSBN (ISKRA)")
L_39:defineToggleSwitch("CB_EMERG_SRO", 4, 3032, 151, "Electric System", "CB IFF (SRO) Emergency Connection")
L_39:defineToggleSwitch("CB_EMERG_ISKRA", 4, 3033, 152, "Electric System", "CB RSBN (ISKRA) Emergency Connection")
L_39:defineToggleSwitch("CB_WING_TANKS", 4, 3034, 153, "Electric System", "CB Wing Tanks")
L_39:defineToggleSwitch("CB_RIO", 4, 3035, 154, "Electric System", "CB RIO-3 De-Icing Signal")
L_39:defineToggleSwitch("CB_SDU", 4, 3036, 155, "Electric System", "CB SDU")
L_39:defineToggleSwitch("CB_HEAT_SENSOR_AOA", 4, 3037, 628, "Electric System", "CB Heating Sensor AOA")
L_39:defineToggleSwitch("CB_WEAPON", 4, 3038, 629, "Electric System", "CB Weapon")
--defineToggleSwitch("CB_TANKS", 4, 3039, XXX,"Electric System", "CB Tanks")
L_39:defineToggleSwitch("CB_AIR_COND", 4, 3040, 211, "Electric System", "CB Air Conditioning")
L_39:defineToggleSwitch("CB_ANTI_ICE", 4, 3041, 212, "Electric System", "CB Anti-Ice")
L_39:defineToggleSwitch("CB_PITOT_L", 4, 3042, 213, "Electric System", "CB Pitot Left")
L_39:defineToggleSwitch("CB_PITOT_R", 4, 3043, 214, "Electric System", "CB Pitot Right")
L_39:defineToggleSwitch("CB_PT500C", 4, 3044, 215, "Electric System", "CB PT-500C")
L_39:defineToggleSwitch("CB_ARC", 4, 3045, 216, "Electric System", "CB ARC")
L_39:defineToggleSwitch("CB_SRO", 4, 3046, 217, "Electric System", "CB SRO")
L_39:defineToggleSwitch("CB_SEAT_HELMET", 4, 3047, 218, "Electric System", "CB Seat Helmet")
L_39:defineToggleSwitch("CB_GEARS", 4, 3048, 219, "Electric System", "CB Gears")
L_39:defineToggleSwitch("CB_CONTROL", 4, 3049, 220, "Electric System", "CB Control")
L_39:defineToggleSwitch("CB_SIGNALING", 4, 3050, 221, "Electric System", "CB Signaling")
L_39:defineToggleSwitch("CB_NAV_LIGHTS", 4, 3051, 222, "Electric System", "CB Nav. Lights")
L_39:defineToggleSwitch("CB_SPOTLIGHT_L", 4, 3052, 223, "Electric System", "CB Spotlight Left")
L_39:defineToggleSwitch("CB_SPOTLIGHT_R", 4, 3053, 224, "Electric System", "CB Spotlight Right")
L_39:defineToggleSwitch("CB_LIGHT_RED", 4, 3054, 225, "Electric System", "CB Red Lights")
L_39:defineToggleSwitch("CB_LIGHT_WHITE", 4, 3055, 226, "Electric System", "CB White Lights")
L_39:defineToggleSwitch("CB_START_PANEL", 4, 3056, 227, "Electric System", "CB Start Panel")
L_39:defineToggleSwitch("CB_BOOST_PUMP", 4, 3057, 228, "Electric System", "CB Booster Pump")
L_39:defineToggleSwitch("CB_INGNITION_1", 4, 3058, 229, "Electric System", "CB Ignition 1")
L_39:defineToggleSwitch("CB_INGNITION_2", 4, 3059, 230, "Electric System", "CB Ignition 2")
L_39:defineToggleSwitch("CB_ENG_INSTR", 4, 3060, 231, "Electric System", "CB Engine Instruments")
L_39:defineToggleSwitch("CB_FIRE", 4, 3061, 232, "Electric System", "CB Fire")
L_39:defineToggleSwitch("CB_EMERG_JETT", 4, 3062, 233, "Electric System", "CB Emergency Jettison")
L_39:defineToggleSwitch("CB_SARPP", 4, 3063, 234, "Electric System", "CB SARPP")
L_39:defineToggleSwitch("CB_SEAT_INSTRUCTOR", 4, 3064, 503, "Electric System", "CB Seat Instructor")
L_39:defineToggleSwitch("CB_SIGNAL_INSTRUCTOR", 4, 3065, 504, "Electric System", "CB Signal Instructor")
L_39:defineToggleSwitch("CB_WEAPON_INSTRUCTOR", 4, 3066, 505, "Electric System", "CB Weapon Instructor")
L_39:defineToggleSwitch("CB_GROUND_INTCOM", 4, 3067, 512, "Electric System", "CB Ground Intercom")
L_39:definePushButton("PITOT_HEAT_ON_L", 4, 3068, 294, "Electric System", "Standby (Left) Pitot Tube Heating ON Button")
L_39:definePushButton("PITOT_HEAT_OFF_L", 4, 3069, 292, "Electric System", "Standby (Left) Pitot Tube Heating OFF Button")
L_39:definePushButton("PITOT_HEAT_ON_R", 4, 3070, 295, "Electric System", "Main (Right) Pitot Tube Heating ON Button")
L_39:definePushButton("PITOT_HEAT_OFF_R", 4, 3071, 293, "Electric System", "Main (Right) Pitot Tube Heating OFF Button")

-- Lights System
L_39:defineTumb("FRONT_NAV_LIGHTS_FLASH", 20, 3003, 176, 0.5, { 0, 1 }, nil, false, "Lights System", "Front Navigation Lights Mode Control Switch, FLICKER/OFF/FIXED")
L_39:defineTumb("FRONT_NAV_LIGHTS_BRIGHT", 20, 3004, 175, 0.5, { 0, 1 }, nil, false, "Lights System", "Front Navigation Lights Intensity Control Switch, DIM(30%)/BRT(60%)/MAX(100%)")
L_39:define3PosTumb("FRONT_LAND_LIGHTS", 20, 3006, 311, "Lights System", "Front Taxi and Landing Lights Control Switch, TAXI/OFF/LANDING")
L_39:define3PosTumb("BACK_LAND_LIGHTS", 20, 3007, 486, "Lights System", "Back Taxi and Landing Lights Control Switch, TAXI/OFF/LANDING")
L_39:define3PosTumb("FRONT_INST_LIGHTS", 20, 3008, 330, "Lights System", "Front Instrument Lighting Switch, Red/OFF/White")
L_39:define3PosTumb("BACK_INST_LIGHTS", 20, 3010, 497, "Lights System", "Back Instrument Lighting Switch, Red/OFF/White")
L_39:definePotentiometer("FRONT_INST_LIGHTS_CON", 20, 3009, 331, { 0.1, 0.9 }, "Lights System", "Front Instrument Lights Intensity Knob")
L_39:definePotentiometer("BACK_INST_LIGHTS_CON", 20, 3011, 498, { 0.1, 0.9 }, "Lights System", "Back Instrument Lights Intensity Knob")
L_39:defineToggleSwitch("FRONT_EMERG_LIGHT", 20, 3005, 249, "Lights System", "Front Emergency Instrument Light Switch, ON/OFF")
L_39:definePotentiometer("FRONT_WARN_LIGHTS_CON", 20, 3012, 202, { 0, 1 }, "Lights System", "Front Warning-Light Intensity Knob")
L_39:definePushButton("FRONT_WARN_LIGHTS_TEST", 20, 3013, 203, "Lights System", "Front Warning-Light Check Button")
L_39:definePotentiometer("BACK_WARN_LIGHTS_CON", 20, 3014, 537, { 0, 1 }, "Lights System", "Back Warning-Light Intensity Knob")
L_39:definePushButton("BACK_WARN_LIGHTS_TEST", 20, 3015, 538, "Lights System", "Back Warning-Light Check Button")

-- Weapon System
L_39:defineToggleSwitch("FRONT_MASTER_ARM", 3, 3001, 254, "Weapon System", "Front CB Armament System Power Switch, ON/OFF")
L_39:defineToggleSwitch("L39C_FRONT_ROCKET_FIRE", 3, 3002, 255, "Weapon System", "L-39C FRONT CB UB-16 Rocket Firing Control Circuit Power Switch, ON/OFF")
L_39:defineToggleSwitch("L39ZA_FRONT_ROCKET_FIRE", 3, 3002, 255, "Weapon System", "L-39ZA FRONT CB Missile Firing Control Circuit Power Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_ASP_FKP", 3, 3003, 256, "Weapon System", "Front CB ASP-FKP (Gunsight and Gun Camera) Power Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_HEATING_SS", 3, 3004, 257, "Weapon System", "Front CB Missile Seeker Heating Circuit Power Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_GLOWING_SS", 3, 3005, 258, "Weapon System", "Front CB Missile Seeker Glowing Circuit Power Switch, ON/OFF")
L_39:definePotentiometer("FRONT_MISSILE_VOL", 3, 3006, 259, { 0, 1 }, "Weapon System", "Front Missile Seeker Tone Volume Knob")
L_39:defineToggleSwitch("FRONT_BOMB_EMERG_JETT", 3, 3009, 268, "Weapon System", "Front Arm/Safe Bombs Emergency Jettison Switch, LIVE/BLANK")
L_39:defineTumb("FRONT_ROCKET_MODE", 3, 3012, 271, 0.1, { 0.1, 0.3 }, nil, true, "Weapon System", "Front Rockets Firing Mode Selector Switch, AUT./2RS/4RS") --
L_39:defineToggleSwitch("BACK_BOMB_EMERG_JETT_COVER", 3, 3018, 508, "Weapon System", "Back Arm/Safe Bombs Emergency Jettison Switch Cover, OPEN/CLOSE")
L_39:define3PosTumb("BACK_BOMB_EMERG_JETT", 3, 3019, 509, "Weapon System", "Back Arm/Safe Bombs Emergency Jettison Switch, LIVE/BOMBS/BLANK")
L_39:defineToggleSwitch("BACK_EMERG_JETT_COVER", 3, 3020, 506, "Weapon System", "Back Emergency Jettison Switch Cover, OPEN/CLOSE")
L_39:defineToggleSwitch("BACK_EMERG_JETT", 3, 3021, 507, "Weapon System", "Back Emergency Jettison Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_FLARE_DISP", 3, 3013, 273, "Weapon System", "Front EKSR-46 Signal Flare Dispenser Power Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_FLARE_YE", 3, 3017, 274, "Weapon System", "Front EKSR-46 Yellow Signal Flare Launch Button")
L_39:defineToggleSwitch("FRONT_FLARE_GN", 3, 3014, 275, "Weapon System", "Front EKSR-46 Green Signal Flare Launch Button")
L_39:defineToggleSwitch("FRONT_FLARE_RD", 3, 3015, 276, "Weapon System", "Front EKSR-46 Red Signal Flare Launch Button")
L_39:defineToggleSwitch("FRONT_FLARE_WH", 3, 3016, 277, "Weapon System", "Front EKSR-46 White Signal Flare Launch Button")
L_39:defineTumb("FRONT_BOMB_REL_SEL", 3, 3007, 260, 2, { -1, 1 }, nil, false, "Weapon System", "Front Missile/Bomb Release Selector Switch, PORT(Left)/STARB-BOTH(Right for Missiles/Both)")
L_39:defineToggleSwitch("L39ZA_FRONT_GUN_SW_COVER", 3, 3041, 582, "Weapon System", "L-39ZA FRONT Gun+PK3 Switch Cover, OPEN/CLOSE")
L_39:defineToggleSwitch("L39ZA_FRONT_GUN_SW", 3, 3042, 583, "Weapon System", "L-39ZA FRONT Gun+PK3 Switch")
L_39:defineToggleSwitch("L39ZA_FRONT_IN_EMERG_JETT_COVER", 3, 3043, 589, "Weapon System", "L-39ZA FRONT Emergency Jettison Inboard Stations Switch Cover, OPEN/CLOSE")
L_39:defineToggleSwitch("L39ZA_FRONT_IN_EMERG_JETT", 3, 3044, 590, "Weapon System", "L-39ZA FRONT Emergency Jettison Inboard Stations Switch, ON/OFF")
L_39:defineTumb("L39ZA_FRONT_PYRO", 3, 3045, 607, 0.5, { 0, 1 }, nil, false, "Weapon System", "L-39ZA FRONT Pyro Charge Select")
L_39:definePushButton("L39ZA_FRONT_ARM_GUN", 3, 3046, 579, "Weapon System", "L-39ZA FRONT Pyro Charge Apply")
L_39:defineToggleSwitch("L39ZA_FRONT_CANNON", 3, 3047, 576, "Weapon System", "L-39ZA FRONT Gsh-23 Arm/Safe")
L_39:defineToggleSwitch("L39ZA_PYLON_OUT_ON", 3, 3048, 585, "Weapon System", "L-39ZA FRONT Outboard Stations Select")
L_39:definePushButton("L39ZA_PYLON_OUT_OFF", 3, 3049, 586, "Weapon System", "L-39ZA FRONT Outboard Stations Deselect")
L_39:defineToggleSwitch("L39ZA_PYLON_IN_ON", 3, 3050, 587, "Weapon System", "L-39ZA FRONT Inboard Stations Select")
L_39:definePushButton("L39ZA_PYLON_IN_OFF", 3, 3051, 588, "Weapon System", "L-39ZA FRONT Inboard Stations Deselect")
L_39:defineToggleSwitch("L39ZA_FRONT_CHARGE_GUN_OUT", 3, 3052, 577, "Weapon System", "L-39ZA FRONT Charge Outer Guns")
L_39:defineToggleSwitch("L39ZA_FRONT_CHARGE_GUN_IN", 3, 3053, 578, "Weapon System", "L-39ZA FRONT Charge Inner Guns")
L_39:defineToggleSwitch("L39ZA_FRONT_EMERG_MISSILE_COVER", 3, 3054, 591, "Weapon System", "L-39ZA FRONT Emergency Launch Missiles Cover")
L_39:definePushButton("L39ZA_FRONT_EMERG_MISSILE", 3, 3055, 592, "Weapon System", "L-39ZA FRONT Emergency Launch Missiles")
L_39:defineToggleSwitch("L39ZA_FRONT_ARM_GUN_OUT", 3, 3056, 597, "Weapon System", "L-39ZA FRONT Arm Outer Guns")
L_39:defineToggleSwitch("L39ZA_FRONT_ARM_GUN_IN", 3, 3057, 598, "Weapon System", "L-39ZA FRONT Arm Inner Guns")
L_39:defineToggleSwitch("L39ZA_FRONT_ARM_BOMBS", 3, 3058, 596, "Weapon System", "L-39ZA FRONT Arm Bombs")
L_39:define3PosTumb("L39ZA_FRONT_BOMB_SERIES", 3, 3059, 584, "Weapon System", "L-39ZA FRONT Bombs Series")
L_39:defineToggleSwitch("L39ZA_FRONT_OUT_EMERG_JETT_COVER", 3, 3010, 269, "Weapon System", "L-39ZA FRONT Emergency Jettison Outboard Stations Switch Cover, OPEN/CLOSE")
L_39:defineToggleSwitch("L39ZA_FRONT_OUT_EMERG_JETT", 3, 3011, 270, "Weapon System", "L-39ZA FRONT Emergency Jettison Outboard Stations Switch, ON/OFF")
L_39:defineToggleSwitch("L39ZA_FRONT_WAEPON_SW", 4, 3038, 629, "Weapon System", "L-39ZA FRONT CB Weapon Switch, ON/OFF")
L_39:definePushButton("L39ZA_FRONT_DEBLOCK_GUN", 3, 3077, 599, "Weapon System", "L-39ZA FRONT Deblock Guns")
L_39:defineToggleSwitch("L39C_FRONT_BOMB_EMERG_JETT_COVER", 3, 3008, 267, "Weapon System", "L-39C FRONT Arm/Safe Bombs Emergency Jettison Switch Cover, OPEN/CLOSE")
L_39:defineToggleSwitch("L39C_FRONT_EMERG_JETT_COVER", 3, 3010, 269, "Weapon System", "L-39C FRONT Emergency Jettison Switch Cover, OPEN/CLOSE")
L_39:defineToggleSwitch("L39C_FRONT_EMERG_JETT", 3, 3011, 270, "Weapon System", "L-39C FRONT Emergency Jettison Switch, ON/OFF")

-- Oxygen System
L_39:defineToggleSwitch("FRONT_OXY_EMERG", 30, 3004, 303, "Oxygen System", "Front Emergency Oxygen Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_OXY_SW", 30, 3006, 304, "Oxygen System", "Front Diluter Demand Switch, 100% / MIX")
L_39:defineToggleSwitch("FRONT_HELM_VENT", 30, 3008, 307, "Oxygen System", "Front Helmet Ventilation Switch, ON/OFF")
L_39:definePotentiometer("FRONT_OXY_SUPPLY_VALVE", 30, 3001, 306, { 0, 1 }, "Oxygen System", "Front Oxygen Supply Valve (CLOSE - CW, OPEN - CCW)")
L_39:defineToggleSwitch("BACK_OXY_EMERG", 30, 3005, 479, "Oxygen System", "Back Emergency Oxygen Switch, ON/OFF")
L_39:defineToggleSwitch("BACK_OXY_SW", 30, 3007, 480, "Oxygen System", "Back Diluter Demand Switch, 100% / MIX")
L_39:definePotentiometer("BACK_OXY_INTER_VALVE", 30, 3003, 484, { 0, 1 }, "Oxygen System", "Back Oxygen Interconnaction Valve (CLOSE - CW, OPEN - CCW)")
L_39:definePotentiometer("BACK_OXY_SUPPLY_VALVE", 30, 3002, 482, { 0, 1 }, "Oxygen System", "Back Oxygen Supply Valve (CLOSE - CW, OPEN - CCW)")

-- SARPP
L_39:defineToggleSwitch("FRONT_SARPP_REC_SWITCH", 36, 3001, 298, "SARPP", "Front SARPP Flight Recorder, ON/OFF")

-- Fuel System
L_39:defineToggleSwitch("FRONT_FUEL_SHUTOFF", 5, 3002, 296, "Fuel System", "Front Fuel Shut-Off Lever")
L_39:defineToggleSwitch("BACK_FUEL_SHUTOFF", 5, 3003, 475, "Fuel System", "Back Fuel Shut-Off Lever")

-- Air System
L_39:defineRotary("FRONT_PRESS_HANDLE", 7, 3001, 245, "Air System", "Front ECS and Pressurization Handle, OFF/CANOPIES SEALED/ECS ON")
L_39:defineRotary("BACK_PRESS_HANDLE", 7, 3002, 245, "Air System", "Back ECS and Pressurization Handle, OFF/CANOPIES SEALED/ECS ON")
L_39:defineTumb("FRONT_CABIN_HEAT_MODE", 7, 3004, 172, 0.05, { 0.0, 0.25 }, nil, false, "Air System", "Front Cabin Air Conditioning Control Switch, OFF/HEAT/COOL/AUTOMATIC")
L_39:definePotentiometer("FRONT_CABIN_TEMP", 7, 3003, 173, { 0, 1 }, "Air System", "Front Cabin Air Temperature Controller Rheostat")
L_39:defineTumb("FRONT_SUIT_COND_MODE", 7, 3006, 121, 0.05, { 0.0, 0.25 }, nil, false, "Air System", "Front Diffuser and Flight Suit Air Conditioning Control Switch, HEAT/AUTO/COOL")
L_39:definePotentiometer("FRONT_SUIT_TEMP", 7, 3005, 120, { 0, 1 }, "Air System", "Front Diffuser and Flight Suit Temperature Rheostat")
L_39:defineToggleSwitch("BACK_AIR_COND_COVER", 7, 3008, 510, "Air System", "Back Conditioning Shutoff Switch Cover, OPEN/CLOSE")
L_39:define3PosTumb("BACK_AIR_COND", 7, 3007, 511, "Air System", "Back Conditioning Shutoff Switch, OPEN/FRONT PILOT CONTROL/CLOSE")

-- Anti-Icing System
L_39:defineTumb("FRONT_ANTI_ICING", 7, 3009, 174, 0.1, { 0, 0.2 }, nil, false, "AntiICE", "Front De-Icing Mode Switch, MANUAL/AUTOMATIC/OFF")
L_39:definePushButton("FRONT_DE_ICE", 7, 3010, 183, "AntiICE", "Front RIO-3 De-Icing Sensor Heating Circuit Check Button")

-- Helmet Heating
L_39:definePushButton("FRONT_HELMET_QUICK", 7, 3011, 309, "Helm Heat", "Front Helmet Visor Quick Heating Button")
L_39:defineTumb("FRONT_HELMET_MODE", 7, 3012, 308, 0.5, { 0, 1 }, nil, false, "Helm Heat", "Front Helmet Heating Mode Switch, AUTO/OFF/ON")
L_39:definePotentiometer("FRONT_HELMET_TEMP", 7, 3013, 310, { 0, 1 }, "Helm Heat", "Front Helmet Heating Temperature Rheostat")

-- SPU-9
L_39:defineToggleSwitch("FRONT_SPU_RESERV", 34, 3004, 290, "SPU", "Front Reserve Intercom Switch, ON/OFF")
L_39:defineToggleSwitch("FRONT_SPU_ADF", 34, 3003, 291, "SPU", "Front ADF Audio Switch, ADF/OFF")
L_39:definePotentiometer("FRONT_SPU_VOL", 34, 3001, 288, { 0.0, 0.8 }, "SPU", "Front Intercom Volume Knob")
L_39:definePotentiometer("FRONT_RADIO_VOL", 34, 3002, 289, { 0.0, 0.8 }, "SPU", "Front Radio Volume Knob")
L_39:definePushButton("FRONT_RADIO_BTN", 34, 3005, 134, "SPU", "Front Radio Button")
L_39:definePushButton("FRONT_SPU_BTN", 34, 3006, 133, "SPU", "Front Intercom Button")
L_39:defineToggleSwitch("BACK_SPU_RESERV", 34, 3010, 473, "SPU", "Back Reserve Intercom Switch, ON/OFF")
L_39:defineToggleSwitch("BACK_SPU_ADF", 34, 3009, 474, "SPU", "Back ADF Audio Switch, ADF/OFF")
L_39:definePotentiometer("BACK_SPU_VOL", 34, 3007, 471, { 0.0, 0.8 }, "SPU", "Back Intercom Volume Knob")
L_39:definePotentiometer("BACK_RADIO_VOL", 34, 3008, 472, { 0.0, 0.8 }, "SPU", "Back Radio Volume Knob")
L_39:definePushButton("BACK_RADIO_BTN", 34, 3011, 547, "SPU", "Back Radio Button")
L_39:definePushButton("BACK_SPU_BTN", 34, 3012, 546, "SPU", "Back Intercom Button")

-- R-832M
L_39:defineToggleSwitch("FRONT_RADIO_CONTROL", 19, 3003, 287, "Radio", "Front Radio Control Switch - Flip for Control")
L_39:defineToggleSwitch("FRONT_RADIO_SQUELCH", 19, 3002, 286, "Radio", "Front Radio Squelch Switch, ON/OFF")
L_39:defineMultipositionSwitch("FRONT_RADIO_CHN", 19, 3001, 284, 20, 0.05, "Radio", "Front Radio Preset Channel Selector Knob")
L_39:defineToggleSwitch("BACK_RADIO_CONTROL", 19, 3006, 470, "Radio", "Back Radio Control Switch - Flip for Control")
L_39:defineToggleSwitch("BACK_RADIO_SQUELCH", 19, 3005, 469, "Radio", "Back Radio Squelch Switch, ON/OFF")
L_39:defineMultipositionSwitch("BACK_RADIO_CHN", 19, 3004, 468, 20, 0.05, "Radio", "Back Radio Preset Channel Selector Knob")

-- Engine Systems
L_39:definePushButton("FRONT_CONTROL_IV300", 6, 3001, 329, "Engine Systems", "Front IV-300 Engine Vibration Test Button")
L_39:defineToggleSwitch("FRONT_FIRE_COVER", 6, 3002, 327, "Engine Systems", "Front Fire Extinguish Button Cover")
L_39:definePushButton("FRONT_FIRE", 6, 3003, 328, "Engine Systems", "Front Fire Extinguish Button")
L_39:defineToggleSwitch("BACK_FIRE_COVER", 6, 3004, 495, "Engine Systems", "Back Fire Extinguish Button Cover")
L_39:definePushButton("BACK_FIRE", 6, 3005, 496, "Engine Systems", "Back Fire Extinguish Button")
L_39:define3PosTumb("FRONT_TEST_SSP", 6, 3006, 272, "Engine Systems", "Front Fire Warning Signal Test Switch I/OFF/II")
L_39:defineToggleSwitch("FRONT_RT12_OFF_COVER", 6, 3007, 323, "Engine Systems", "Front RT-12 JPT Regulator Manual Disable Switch Cover")
L_39:defineToggleSwitch("FRONT_RT12_OFF", 6, 3008, 324, "Engine Systems", "Front RT-12 JPT Regulator Manual Disable Switch")
L_39:defineToggleSwitch("FRONT_RT12_PW", 6, 3009, 243, "Engine Systems", "Front RT-12 JPT Regulator Power Switch")
L_39:define3PosTumb("FRONT_RT12_TEST", 6, 3010, 242, "Engine Systems", "Front RT-12 JPT Regulator Test Switch I/OFF/II")
L_39:defineToggleSwitch("BACK_EGT_CONTROL", 6, 3011, 499, "Engine Systems", "Back EGT Indicator Switch")

-- Control System
L_39:definePushButton("FRONT_FLAPS_0", 37, 3001, 281, "Control System", "Front Flaps Flight Position 0")
L_39:definePushButton("FRONT_FLAPS_25", 37, 3002, 282, "Control System", "Front Flaps Takeoff Position 25")
L_39:definePushButton("FRONT_FLAPS_44", 37, 3003, 283, "Control System", "Front Flaps Landing Position 44")
L_39:definePushButton("BACK_FLAPS_0", 37, 3004, 465, "Control System", "Back Flaps Flight Position 0")
L_39:definePushButton("BACK_FLAPS_25", 37, 3005, 466, "Control System", "Back Flaps Takeoff Position 25")
L_39:definePushButton("BACK_FLAPS_44", 37, 3006, 467, "Control System", "Back Flaps Landing Position 44")
L_39:defineToggleSwitch("BACK_THROTTLE_LIMIT", 37, 3021, 549, "Control System", "Back Throttle Limiter")
L_39:definePushButton("FRONT_AIR_BRAKE_BTN", 37, 3008, 135, "Control System", "Front Air Brake Push Switch")
L_39:defineToggleSwitch("FRONT_AIR_BRAKE_SW", 37, 3007, 136, "Control System", "Front Air Brake Switch")
L_39:define3PosTumb("BACK_AIR_BRAKE_SW", 37, 3009, 548, "Control System", "Back Air Brake Switch")
L_39:define3PosTumb("FRONT_GEAR_LEVER", 37, 3011, 118, "Control System", "Front Landing Gear Control Lever")
L_39:define3PosTumb("BACK_GEAR_LEVER", 37, 3012, 437, "Control System", "Back Landing Gear Control Lever")
L_39:definePotentiometer("FRONT_BRAKE_CONTROL", 37, 3016, 334, { -1, 1 }, "Control System", "Front Emergency/Parking Wheel Brake Lever")
L_39:definePotentiometer("BACK_BRAKE_CONTROL", 37, 3017, 501, { -1, 1 }, "Control System", "Back Emergency/Parking Wheel Brake Lever")
L_39:defineToggleSwitch("FRONT_BRAKE_CONTROL_LOCK", 37, 3024, 334, "Control System", "Front Parking Brake Lever Flag")
L_39:defineToggleSwitch("FRONT_EMERG_HYD", 35, 3001, 197, "Control System", "Front Main and Emergency Hydraulic Systems Interconnection Lever ON/OFF")
L_39:defineToggleSwitch("FRONT_EMERG_GEAR", 35, 3003, 194, "Control System", "Front Emergency Landing Gear Extension Lever ON/OFF")
L_39:defineToggleSwitch("FRONT_EMERG_FLAPS", 35, 3005, 195, "Control System", "Front Emergency Flaps Extension Lever ON/OFF")
L_39:defineToggleSwitch("FRONT_EMERG_GEN", 35, 3007, 196, "Control System", "Front RAT Emergency Generator Lever ON/OFF")
L_39:defineToggleSwitch("BACK_EMERG_HYD", 35, 3002, 536, "Control System", "Back Main and Emergency Hydraulic Systems Interconnection Lever ON/OFF")
L_39:defineToggleSwitch("BACK_EMERG_GEAR", 35, 3004, 533, "Control System", "Back Emergency Landing Gear Extension Lever ON/OFF")
L_39:defineToggleSwitch("BACK_EMERG_FLAPS", 35, 3006, 534, "Control System", "Back Emergency Flaps Extension Lever ON/OFF")
L_39:defineToggleSwitch("BACK_EMERG_GEN", 35, 3008, 535, "Control System", "Back RAT Emergency Generator Lever ON/OFF")
L_39:define3PosTumb("BACK_PRESS_TOTAL", 39, 3002, 456, "Control System", "Back Full Pressure Failure Lever, ON/STBY/FAILURE")
L_39:define3PosTumb("BACK_PRESS_STATIC", 39, 3001, 457, "Control System", "Back Static Pressure Failure Lever, ON/STBY/FAILURE")

-- Accelerometer
L_39:definePushButton("FRONT_G_RESET", 33, 3001, 89, "Accelerometer", "Front Reset G Limits Button")

-- Canopy
L_39:defineToggleSwitch("FRONT_CANOPY_HANDLE", 2, 3001, 998, "Canopy", "Front Canopy Handle")
L_39:defineToggleSwitch("BACK_CANOPY_HANDLE", 2, 3002, 999, "Canopy", "Back Canopy Handle")
L_39:defineToggleSwitch("FRONT_CANOPY_LOCK_HANDLE", 2, 3007, 285, "Canopy", "Front Canopy Lock Handle")
L_39:defineToggleSwitch("BACK_CANOPY_LOCK_HANDLE", 2, 3008, 485, "Canopy", "Back Canopy Lock Handle")
L_39:definePushButton("FRONT_CANOPY_JETT", 2, 3009, 244, "Canopy", "Front Canopy Emergency Jettison Handle")
L_39:definePushButton("BACK_CANOPY_JETT", 2, 3010, 539, "Canopy", "Back Canopy Emergency Jettison Handle")

-- Hood, Rear Cockpit
L_39:defineToggleSwitch("BACK_HOOD_CONTROL", 2, 3006, 1000, "Hood", "Back Instrument Flight Practice Hood Control Handle, EXTEND/RETRACT")

-- Pitot Selector
L_39:defineToggleSwitch("FRONT_PITOT_CONTROL", 37, 3022, 333, "Pitot", "Front Pitot Tube Selector Lever, STBY(Left)/MAIN(Right)")

-- Misc
L_39:defineToggleSwitch("FRONT_PANEL_HOOD", 0, 3003, 627, "Misc", "Front Panel Visor Extend")

------------------------------------ L-39 Readings --------------------------------------------------------------------

local function getRSBNNAV(dev0)
	return Module.round(dev0:get_argument_value(191) * 40 + 1)
end

local function getRSBNNAVS(dev0)
	return string.format("%.0f", dev0:get_argument_value(191) * 40 + 1)
end
L_39:defineIntegerFromGetter("FRONT_RSBN_CHAN_NAV_DISPLAY", getRSBNNAV, 40, "Readings", "Front RSBN NAV Channel Display")
L_39:defineString("FRONT_RSBN_CHAN_NAV_DISPLAY_STRING", getRSBNNAVS, 2, "Readings", "Front RSBN NAV Channel Display (string)")
--
local function getRSBNLAND(dev0)
	return Module.round(dev0:get_argument_value(192) * 40 + 1)
end

local function getRSBNLANDS(dev0)
	return string.format("%.0f", dev0:get_argument_value(192) * 40 + 1)
end
L_39:defineIntegerFromGetter("FRONT_RSBN_CHAN_LAND_DISPLAY", getRSBNLAND, 40, "Readings", "Front RSBN LAND Channel Display")
L_39:defineString("FRONT_RSBN_CHAN_LAND_DISPLAY_STRING", getRSBNLANDS, 2, "Readings", "Front RSBN LAND Channel Display (string)")
--
local function getRadioPresetChan_FRONT(dev0)
	return Module.round(dev0:get_argument_value(284) * 100 / 5)
end

local function getRadioPresetChan_FRONTS(dev0)
	return string.format("%.0f", dev0:get_argument_value(284) * 100 / 5)
end
L_39:defineIntegerFromGetter("FRONT_RADIO_CHN_DISPLAY", getRadioPresetChan_FRONT, 19, "Readings", "Front Radio Preset Channel Display")
L_39:defineString("FRONT_RADIO_CHN_DISPLAY_STRING", getRadioPresetChan_FRONTS, 2, "Readings", "Front Radio Preset Channel Display (string)")
--
local function getRadioPresetChan_BACK(dev0)
	return Module.round(dev0:get_argument_value(284) * 100 / 5)
end

local function getRadioPresetChan_BACKS(dev0)
	return string.format("%.0f", dev0:get_argument_value(284) * 100 / 5)
end
L_39:defineIntegerFromGetter("BACK_RADIO_CHN_DISPLAY", getRadioPresetChan_BACK, 19, "Readings", "Back Radio Preset Channel Display")
L_39:defineString("BACK_RADIO_CHN_DISPLAY_STRING", getRadioPresetChan_BACKS, 2, "Readings", "Back Radio Preset Channel Display (string)")

L_39:defineFloat("FRONT_CANOPY_POS", 139, { 0, 1 }, "Gauges", "Front Canopy Position")
L_39:defineFloat("BACK_CANOPY_POS", 140, { 0, 1 }, "Gauges", "Back Door Position")

L_39:defineReadWriteRadio("R832M_RADIO", 19, 7, 3, 1000, "R-832M Radio")

L_39:defineIndicatorLight("FRONT_STORE_LEFT", 618, "Warning, Caution and IndicatorLights", "Front Left Stores Lamp (green)")
L_39:defineIndicatorLight("FRONT_STORE_LEFT_INBOARD", 619, "Warning, Caution and IndicatorLights", "Front Left Inboard Stores Lamp (green)")
L_39:defineIndicatorLight("FRONT_STORE_RIGHT_INBOARD", 620, "Warning, Caution and IndicatorLights", "Front Right Inboard Stores Lamp (green)")
L_39:defineIndicatorLight("FRONT_STORE_RIGHT", 621, "Warning, Caution and IndicatorLights", "Front Right Stores Lamp (green)")
L_39:defineIndicatorLight("FRONT_PAYLOAD_INDICATOR_LEFT", 622, "Warning, Caution and IndicatorLights", "Front Left Payload Indicator Lamp (green)")
L_39:defineIndicatorLight("FRONT_PAYLOAD_INDICATOR_LEFT_INBOARD", 623, "Warning, Caution and IndicatorLights", "Front Left Inboard Payload Indicator Lamp (green)")
L_39:defineIndicatorLight("FRONT_PAYLOAD_INDICATOR_RIGHT_INBOARD", 624, "Warning, Caution and IndicatorLights", "Front Right Inboard Payload Indicator Lamp (green)")
L_39:defineIndicatorLight("FRONT_PAYLOAD_INDICATOR_RIGHT", 625, "Warning, Caution and IndicatorLights", "Front Right Payload Indicator Lamp (green)")

L_39:defineIndicatorLight("BACK_STORE_LEFT", 718, "Warning, Caution and IndicatorLights", "Back Left Stores Lamp (green)")
L_39:defineIndicatorLight("BACK_STORE_LEFT_INBOARD", 719, "Warning, Caution and IndicatorLights", "Back Left Inboard Stores Lamp (green)")
L_39:defineIndicatorLight("BACK_STORE_RIGHT_INBOARD", 720, "Warning, Caution and IndicatorLights", "Back Right Inboard Stores Lamp (green)")
L_39:defineIndicatorLight("BACK_STORE_RIGHT", 721, "Warning, Caution and IndicatorLights", "Back Right Stores Lamp (green)")
L_39:defineIndicatorLight("BACK_PAYLOAD_INDICATOR_LEFT", 722, "Warning, Caution and IndicatorLights", "Back Left Payload Indicator Lamp (green)")
L_39:defineIndicatorLight("BACK_PAYLOAD_INDICATOR_LEFT_INBOARD", 723, "Warning, Caution and IndicatorLights", "Back Left Inboard Payload Indicator Lamp (green)")
L_39:defineIndicatorLight("BACK_PAYLOAD_INDICATOR_RIGHT_INBOARD", 724, "Warning, Caution and IndicatorLights", "Back Right Inboard Payload Indicator Lamp (green)")
L_39:defineIndicatorLight("BACK_PAYLOAD_INDICATOR_RIGHT", 725, "Warning, Caution and IndicatorLights", "Back Right Payload Indicator Lamp (green)")

L_39:defineIndicatorLight("PUS_0_BOMBS", 266, "Warning, Caution and IndicatorLights", "Bomb PUS 0 Lamp (green)")
L_39:defineIndicatorLight("PUS_0", 608, "Warning, Caution and IndicatorLights", "PUS 0 Lamp (green)")
L_39:defineIndicatorLight("PUS_0_INNER", 609, "Warning, Caution and IndicatorLights", "Inner PUS 0 Lamp (green)")

return L_39
