local base = _G

module('me_toolbar') -- left toolbar

-- local SLayout = base.require('ScrollLayout')
-- local Widget = base.require('Widget')
local Window = base.require('Window')
local Button = base.require('Button')
local ToggleButton = base.require('ToggleButton')
local BScolor = base.require('BScolor')
local U = base.require('me_utilities')
local MapWindow = base.require('me_map_window')
form = base.require('me_toolbar_form')
local MsgWindow = base.require('MsgWindow')
local MissionModule = base.require('me_mission')
--local UnitsList = require('me_units_list');
base.require('i18n').setup(_M)


local cdata = {
    new_mission = _('Creating new mission'),
    new_mission_msg = _('Are you sure you want to create new mission? \nAll unsaved changes will be lost!'),
    open_mission_msg = _('Are you sure you want to open new mission? \nAll unsaved changes will be lost!'),
    yes = _('Yes'),
    no = _('No'),    
}

function create(x, y, w, h)
    form.create(x, y, w, h)

    b_new = form.b_new
    b_open = form.b_open
    b_save = form.b_save
    b_del = form.b_del
    b_run = form.b_run
    b_briefing = form.b_briefing
		b_coalitions = form.b_coalitions
    --	b_failures = form.b_failures
    b_weather = form.b_weather
    b_airplane = form.b_airplane
    b_helicopter = form.b_helicopter
    b_ship = form.b_ship
    b_vehicle = form.b_vehicle
    b_static = form.b_static
    b_goal = form.b_goal
    b_zone = form.b_zone
    b_template = form.b_template
    b_exit = form.b_exit
    b_map = form.b_map
    b_trig_zones_list = form.b_trig_zones_list
    b_unit_list = form.b_unit_list
    b_tape = form.b_tape;
    b_template = form.b_template;
    b_trigrules = form.b_trigrules
    b_options = form.b_options
	l_file = form.l_file
	l_mis = form.l_mis
	l_obj = form.l_obj
	
    --    ,       
    panels = {
        b_new = {base.panel_coalitions.show},
        b_open = {base.panel_openfile.show},
        b_save = {base.panel_file_dialog.show},
        b_del = {},
        b_run = {},
        b_briefing = {base.panel_briefing.show},
			b_coalitions = {base.panel_coalitions.show},
			-- b_failures = {base.panel_failures.show},
        b_weather = {base.panel_weather.show},
        b_airplane = {
                        base.panel_aircraft.show,
                        base.panel_summary.show,
                        base.panel_targeting.show,
                        base.panel_route.show,
                        base.panel_loadout.show,
                        base.panel_payload.show,
                        base.panel_fix_points.show,
        },
        b_helicopter = {
                        base.panel_aircraft.show,
                        base.panel_loadout.show,
                        base.panel_summary.show,
                        base.panel_route.show,
                        base.panel_targeting.show,
                        base.panel_payload.show,
                        base.panel_fix_points.show,
                        },
        b_ship = {
                    base.panel_ship.show,
                    base.panel_summary.show,
                    base.panel_route.show,
                    base.panel_targeting.show},
        b_vehicle = {
                        base.panel_vehicle.show,
                        base.panel_summary.show,
                        base.panel_route.show,
                        base.panel_targeting.show},
        b_static = {base.panel_static.show},
        b_goal = {base.panel_goal.showGoals},
        b_zone = {base.panel_zone.show},
        b_exit = {},
        b_map = {base.panel_map_options.show},
        b_options = {base.panel_mis_options.show},
        b_trig_zones_list = {base.panel_trig_zones_list.show},
        b_unit_list = {handleUnitList},
        b_tape = {
            function() 
                if MapWindow.tape then  
                    MapWindow.removeTapeObjects() 
                end 
            end
            },
        b_template = {base.panel_template.show},
        b_trigrules = {base.panel_trigrules.show},
        b_about = {base.panel_about.show},
        }

    function form.b_exit:onChange()
		base.MapWindow.unselectAll()		
		if (base.isPlannerMission() == true) then
			base.menubar.Exit();
			base.panel_autobriefing.setDoSave(true)
			base.panel_autobriefing.show(true)
		else
			base.menubar.onExit();
		end
    end
-- toggle buttons
    
  function form.b_save:onChange()
      MapWindow.unselectAll()
      MapWindow.mapView:updateUserList(true)
      untoggle_all_except(self)
      if self:getState() then
          if base.module_mission.mission.path and 
            not base.string.find(base.module_mission.mission.path, base.tempMissionName) then
              base.module_mission.save_mission(base.module_mission.mission.path)
              self:setState(false)
          else
              base.panel_file_dialog.resize(base.main_w - 390, base.top_toolbar_h, 390, base.main_h - base.top_toolbar_h - base.bottom_toolbar_h);
              base.panel_file_dialog.setStyle('savemission')
              base.panel_file_dialog.show(true)
          end
      else
          base.panel_file_dialog.show(false)
      end
  end --func
  
  function form.b_open:onChange()
      untoggle_all_except(self)
      if self:getState() then
            MapWindow.unselectAll()
          --base.panel_openfile.show(true)
          --base.panel_openfile.bCloseME = false
            if MissionModule.isMissionModified() then
                setButtonsEnabled(nil, false);
                local msgWindow = MsgWindow.new(cdata.open_mission_msg, cdata.new_mission, 'question', cdata.yes, cdata.no);
                local button = self;
                function msgWindow:onChange(str)
                    if str == cdata.yes then 
                        base.panel_file_dialog.resize(base.main_w - 390, base.top_toolbar_h, 390, base.main_h - base.top_toolbar_h - base.bottom_toolbar_h);
                        base.panel_file_dialog.setStyle('openmission')
                        base.panel_file_dialog.show(true)
                    else
                        button:setState(false)
                    end;
                    setButtonsEnabled(nil, true);
                    MsgWindow.onChange(self)
                end;
                msgWindow:setVisible(true);                
            else
                base.panel_file_dialog.resize(base.main_w - 390, base.top_toolbar_h, 390, base.main_h - base.top_toolbar_h - base.bottom_toolbar_h);
                base.panel_file_dialog.setStyle('openmission')
                base.panel_file_dialog.show(true)            
            end;
            self:setState(false);
      else
          --base.panel_openfile.show(false)
          base.panel_file_dialog.show(false)          
      end
  end --func
  
  function form.b_new:onChange()
       untoggle_all_except(self)
       local button = self;
       if self:getState() then
            --setButtonsEnabled(nil, false);
            --base.menubar.form.window:setEnabled(false);
            local msgWindow = MsgWindow.new(cdata.new_mission_msg, cdata.new_mission, 'question', cdata.yes, cdata.no);
            function msgWindow:onChange(str)
                if str == cdata.yes then 
                    base.panel_coalitions.load_default()
                    base.panel_coalitions.show(true) 
                else
                    button:setState(false)
                    setButtonsEnabled(nil, true);
                    base.menubar.form.window:setEnabled(true);
                end;
                MsgWindow.onChange(self)
            end;
            msgWindow:setVisible(true);        
       else
          setButtonsEnabled(nil, true);
          base.menubar.form.window:setEnabled(true);
          base.panel_coalitions.show(false)
       end
  end
  
  function form.b_del:onChange()
    base.menubar.onRemove()
  end
  
  function form.b_run:onChange()
    base.menubar.onFly()
  end
  
  function form.b_briefing:onChange()
    untoggle_all_except(self)
    base.panel_briefing.show(self:getState())
  end
	-- =============== HERE ===============================
    function form.b_coalitions:onChange()
      untoggle_all_except(self)
        base.panel_coalitions.show(self:getState())
	end
   --[[ 
  function form.b_failures:onChange()
      untoggle_all_except(self)
        base.panel_failures.show(self:getState())
  end
  ]]--
  function form.b_weather:onChange()
      untoggle_all_except(self)
        base.panel_weather.show(self:getState())
  end
  
  function form.b_trigrules:onChange()
      untoggle_all_except(self)
      base.panel_trigrules.show(self:getState())
  end


  function form.b_vehicle.onChange(self)
    untoggle_all_except(self)
    --     ,     .
    if #base.panel_coalitions.vdata.coalitions_country_names <= 0 or not base.panel_vehicle.vdata.country then
        self:setState(false)
        return
    end
    if self:getState() then
        MapWindow.unselectAll()
        base.panel_vehicle.vdata.tabs:selectTab(1)
        base.panel_vehicle.vdata.unit.number = 1
        base.panel_vehicle.vdata.unit.cur = 1
        --      
        --        .
        base.panel_vehicle.vdata.group = nil
        base.panel_route.vdata.group = nil
        base.panel_targeting.vdata.group = nil
        base.panel_summary.vdata.group = nil
        MapWindow.mapView:setState(MapWindow.creatingVehicleState)
        base.statusbar.updateState()
        base.panel_route.show(true)
        base.panel_vehicle.setSafeMode(true)
        base.panel_route.setSafeMode(true)
      else
          base.panel_route.show(false)
          base.panel_summary.show(false)
          base.panel_targeting.show(false)
    end
     base.panel_vehicle.show(self:getState())
  end --func

  function form.b_static.onChange(self)
      untoggle_all_except(self)
    if #base.panel_coalitions.vdata.coalitions_country_names <= 0 or not base.panel_static.vdata.country then
        self:setState(false)
        return
    end
      if self:getState() then
        MapWindow.unselectAll()
        --      
        --        .
        base.panel_static.vdata.group = nil
          MapWindow.mapView:setState(MapWindow.creatingStaticState)
        base.statusbar.updateState()
      end
      base.panel_static.show(self:getState())
  end --func

  function form.b_goal.onChange(self)
      untoggle_all_except(self)
      base.panel_goal.showGoals(self:getState())
  end --func

  function form.b_zone.onChange(self)
      untoggle_all_except(self)
      if self:getState() then
          MapWindow.mapView:setState(MapWindow.creatingZoneState)
          base.statusbar.updateState()
      end
      base.panel_zone.setSafeMode(true)
      base.panel_zone.currentZone = nil
      base.panel_zone.show(self:getState())
  end --func

  function form.b_template.onChange(self)
    untoggle_all_except(self)
    if self:getState() then
      MapWindow.mapView:setState(MapWindow.creatingTemplateState)
      base.statusbar.updateState()
    end
    base.panel_template.show(self:getState())
  end --func
  function form.b_ship.onChange(self)
    untoggle_all_except(self)
    if #base.panel_coalitions.vdata.coalitions_country_names <= 0 or not base.panel_ship.vdata.country then
        self:setState(false)
        return
    end
    if self:getState() then
        MapWindow.unselectAll()
        base.panel_ship.vdata.tabs:selectTab(1)
        base.panel_ship.vdata.unit.number = 1
        base.panel_ship.vdata.unit.cur = 1
        --      
        --        .
        base.panel_ship.vdata.group = nil
        base.panel_route.vdata.group = nil
        base.panel_targeting.vdata.group = nil
        base.panel_summary.vdata.group = nil
        MapWindow.mapView:setState(MapWindow.creatingShipState)
        base.statusbar.updateState()
        base.panel_route.show(true)
        base.panel_ship.setSafeMode(true)
        base.panel_route.setSafeMode(true)
      else
          base.panel_route.show(false)
          base.panel_summary.show(false)
          base.panel_targeting.show(false)
    end
      base.panel_ship.show(self:getState())
  end --func

  function form.b_helicopter.onChange(self)
    untoggle_all_except(self)
    if #base.panel_coalitions.vdata.coalitions_country_names <= 0 or not base.panel_aircraft.vdata.country then
        self:setState(false)
        return
    end
    if self:getState() then
        MapWindow.unselectAll()
        base.panel_aircraft.setView('helicopter');
        base.panel_aircraft.vdata.tabs:selectTab(1)
        base.panel_aircraft.vdata.unit.number = 1
        base.panel_aircraft.vdata.unit.cur = 1
        --      
        --        .
        base.panel_aircraft.vdata.group = nil
        base.panel_route.vdata.group = nil
        base.panel_payload.vdata.group = nil
        base.panel_targeting.vdata.group = nil
        base.panel_summary.vdata.group = nil
        MapWindow.mapView:setState(MapWindow.creatingHelicopterState)
        base.statusbar.updateState()
        base.panel_route.show(true)
        base.panel_aircraft.setSafeMode(true)
        base.panel_route.setSafeMode(true)
    else
        base.panel_summary.show(false)
        base.panel_targeting.show(false)
        base.panel_route.show(false)
        base.panel_loadout.show(false)
        base.panel_payload.show(false)
    end
	base.panel_aircraft.setDefaultAircraft()
	base.panel_aircraft.update()
    base.panel_aircraft.show(self:getState())
  end --func

  function form.b_airplane.onChange(self)
      untoggle_all_except(self)
      if #base.panel_coalitions.vdata.coalitions_country_names <= 0 or 
              not base.panel_aircraft.vdata.country 
      then
          self:setState(false)
          return
      end
      if self:getState() then
          base.panel_aircraft.setView('plane')		  
          base.panel_aircraft.vdata.tabs:selectTab(1)
          base.panel_aircraft.vdata.unit.number = 1
          base.panel_aircraft.vdata.unit.cur = 1
          MapWindow.unselectAll()
          --      
          --        .
          base.panel_aircraft.vdata.group = nil
          base.panel_route.vdata.group = nil
          base.panel_payload.vdata.group = nil
          base.panel_targeting.vdata.group = nil
          base.panel_summary.vdata.group = nil
          MapWindow.mapView:setState(MapWindow.creatingPlaneState)
          base.statusbar.updateState()
          base.panel_route.show(true)
          base.panel_aircraft.setSafeMode(true)
          base.panel_route.setSafeMode(true)
      else
          MapWindow.setPanState()
          base.panel_summary.show(false)
          base.panel_targeting.show(false)
          base.panel_route.show(false)
          base.panel_loadout.show(false)
          base.panel_payload.show(false)
      end
	  base.panel_aircraft.setDefaultAircraft()
	  base.panel_aircraft.update()
      base.panel_aircraft.show(self:getState())
  end --func

  function form.b_map.onChange(self)
      untoggle_all_except(self)
      if self:getState() then
          base.selected_mode_button = self
          base.panel_map_options.show(true)
      else
          base.panel_map_options.show(false)
      end
  end --func
  
  function form.b_options.onChange(self)
      untoggle_all_except(self)
      if self:getState() then
          base.selected_mode_button = self
          base.panel_mis_options.show(true)
      else
          base.panel_mis_options.show(false)
      end
  end --func
  
  
  function form.b_tape:onChange()
      untoggle_all_except(self)
    if self:getState() then
          base.selected_mode_button = self
        MapWindow.setTapeState()
      else
        if MapWindow.tape then
            MapWindow.removeTapeObjects()
        end
        MapWindow.setPanState()
    end
  end
  
  function form.b_trig_zones_list.onChange(self)
      untoggle_all_except(self)
    if self:getState() then
        base.panel_trig_zones_list.show(true)
      else
        base.panel_trig_zones_list.show(false)
    end
  end --func

  function form.b_unit_list.onChange(self)
    untoggle_all_except(self)
    if self:getState() then
        base.panel_units_list.show(true)
      else
        base.panel_units_list.show(false)
    end
  end --func
  setupKeyboard();
end

function setPlannerMission(planner_mission)
	if (planner_mission == true) then
		b_new:setVisible(false)
		b_open:setVisible(false)
		b_save:setVisible(false)
		b_del:setVisible(false)
		b_run:setVisible(false)
		b_briefing:setVisible(false)
		b_weather:setVisible(false)
		b_airplane:setVisible(false)
		b_helicopter:setVisible(false)
		b_ship:setVisible(false)
		b_vehicle:setVisible(false)
		b_static:setVisible(false)
		b_goal:setVisible(false)
		b_zone:setVisible(false)
		b_template:setVisible(false)
	   -- b_exit:setVisible(false)
		--b_map:setVisible(false)
		b_trig_zones_list:setVisible(false)
		b_unit_list:setVisible(false)
		--b_tape:setVisible(false)
		b_template:setVisible(false)
		b_trigrules:setVisible(false)
		b_options:setVisible(false)
		l_file:setVisible(false)
		l_mis:setVisible(false)
		l_obj:setVisible(false)
	else
		b_new:setVisible(true)
		b_open:setVisible(true)
		b_save:setVisible(true)
		b_del:setVisible(true)
		b_run:setVisible(true)
		b_briefing:setVisible(true)
		b_weather:setVisible(true)
		b_airplane:setVisible(true)
		b_helicopter:setVisible(true)
		b_ship:setVisible(true)
		b_vehicle:setVisible(true)
		b_static:setVisible(true)
		b_goal:setVisible(true)
		b_zone:setVisible(true)
		b_template:setVisible(true)
	   -- b_exit:setVisible(true)
		--b_map:setVisible(true)
		b_trig_zones_list:setVisible(true)
		b_unit_list:setVisible(true)
		--b_tape:setVisible(true)
		b_template:setVisible(true)
		b_trigrules:setVisible(true)
		b_options:setVisible(true)
		l_file:setVisible(true)
		l_mis:setVisible(true)
		l_obj:setVisible(true)
	end

end

function show(b)	
	setPlannerMission(base.isPlannerMission())
	form.window:setVisible(b)
end


function untoggle_all_except(c)
    MapWindow.setPanState()
    
    --   ,    
    local name = '';
    for k,v in base.pairs(_M) do
        if v == c then 
            name = k;
            --base.print('untoggle_all_except('..name..')');
            break;
        end;
    end;
    
    for button_name,button_panels in base.pairs(panels) do
        --       
        if (nil == _M[button_name]) or (c ~= _M[button_name]) then
            if _M[button_name] and _M[button_name].setState --[[and (_M[button_name] ~= b_unit_list)--]] then
                _M[button_name]:setState(false);
            end;
            --   ,   
            --        
            --base.print('button_name',button_name);
            for i = 1,#button_panels do 
                button_panels[i](false, _M[button_name]);
            end;
        end;
    end;
    base.panel_record_avi.show(false);
    
end;

function handleUnitList(b, button)
    if (button == b_airplane) or
            (button == b_helicopter) or
            (button == b_ship) or
            (button == b_vehicle) or
            (button == b_static) then
            base.panel_units_list.show(true);
    else
        base.panel_units_list.show(false);
        base.panel_summary.show(false)
        base.panel_targeting.show(false)
        base.panel_route.show(false)
        base.panel_loadout.show(false)
        base.panel_payload.show(false)
        base.panel_aircraft.show(false)

        base.panel_ship.show(false)
        base.panel_static.show(false)
        base.panel_vehicle.show(false)
        base.panel_weather.show(false)
      
    end;
    base.panel_units_list.show(b);
end;

function setButtonsEnabled(currentButton, state)
    local name = '';
    for k,v in base.pairs(_M) do
        if v == currentButton then 
            name = k;
            break;
        end;
    end;
    
    for button_name,button_panels in base.pairs(panels) do
        --       
        if _M[button_name] and (name ~= button_name) then
            _M[button_name]:setEnabled(state)
        end;
    end;
end;

function setupKeyboard()
    function toolbarCallback(self)
        self:setState(true);
        self.onChange(self)        
    end; 
    
    function escCallback()
        MapWindow.hideGroupPanels()
        base.panel_units_list.show(false);
        untoggle_all_except();
    end; 
    
    form.window:addKeyCombination( toolbarCallback, form.b_airplane,'a');
    form.window:addKeyCombination( toolbarCallback, form.b_helicopter,'h');
    form.window:addKeyCombination( toolbarCallback, form.b_ship,'s');
    form.window:addKeyCombination( toolbarCallback, form.b_vehicle,'u');
    form.window:addKeyCombination( toolbarCallback, form.b_static,'o');
    form.window:addKeyCombination( escCallback, nil,'escape');
end; 