local base = _G

module('me_ship')

--  LuaGUI
local Window = base.require('Window')
local Dial = base.require('Dial')
local EditBox = base.require('EditBox')
local CheckBox = base.require('CheckBox')
local Widget = base.require('Widget')
local Theme = base.require('Theme')

--   
local S = base.require('Serializer')

--  Black Shark
local BScolor = base.require('BScolor')  --  
local U = base.require('me_utilities')	--    
local MapWindow = base.require('me_map_window')
local crutches = base.require('me_crutches')  -- temporary crutches
local tabs = base.require('me_tabs')

base.require('i18n').setup(_M)


vdata = { }


function initModule()
    --    ( ,       ,
    --  IMHO     ,     )
    cdata = 
    {
        title = _('NAVY GROUP'),
        country = _('COUNTRY'), 
        name = _('NAME'),
        hidden = _('HIDDEN ON MAP'),
		visible = _('VISIBLE BEFORE START'),
        unit = {title = _('UNIT'), of = _('OF'), max = 99},
        type = { title = _('TYPE'), 
            list = {'Normandy CG-60 (TICONDEROGA Class Cruiser)', },	--    
        },
        unit_name = _('UNIT NAME'),
        skill = {title = _('SKILL'),
            list = crutches.getSkillsNames(false),	--  
        },
        heading = _('HEADING'),
		new_group_task = _('Nothing'),
        placeUnitOnSea = _('You are trying to place new ship on the land.\
Please move ship group to allow new ship to be created on water'),
    }

    --  /  (   - cdata.vdata_file)
    vdata.country = 'Russia'
    vdata.countries = {'Russia', 'UK', 'Ukraine', 'USA',}
    vdata.name = _('New Ship Group')
    vdata.unit = {number = 1, cur = 1}
    --      
    vdata.types = {'Neustrashimy 11540 FFG (NEUSTRASHIMY Class Frigate)',}	--       
    vdata.skills = { _('Average'), }
    vdata.names = { _('Unit #1'), }
end;


--    
--   : t - text, b - button, c - combo, sp - spin, sl - slider, e - edit, d - dial 
function create(x, y, w, h)
    window = Window.new(x, y, w, h)
    window:setTitleHeight(0)
    --window:getTheme():setColor(BScolor.dialog_prim)
    --      
    window:setTop(true)
 
    vdata.countries = base.panel_coalitions.vdata.coalitions_country_names   
    country_ship_list = {}
    for i,v in base.pairs(base.me_db.db.Countries) do
        local w = {}
        country_ship_list[v.Name] = w
        for j,u in base.pairs(v.Units.Ships.Ship) do
            base.table.insert(w, base.me_db.ship_by_CLSID[u.CLSID].Name)
        end
        base.table.sort(w)
    end
       
    -- 
    local t_title = U.create_header(cdata.title)
    t_title:setBounds(0, 0, w-U.widget_h, U.widget_h)
        window:addChild(t_title)
        
    --  
    b_close = U.create_close_button()
    b_close:setBounds(w-U.widget_h, 0, U.widget_h, U.widget_h)
    window:addChild(b_close)
    --    callback-    
    --  , 
    --         .
    
    
    function b_close:onChange()
        base.panel_route.show(false)
        base.panel_targeting.show(false)
        base.panel_summary.show(false)
        MapWindow.mapView:setState(MapWindow.panState)
        base.statusbar.updateState()
        show(false)
        base.toolbar.b_ship:setState(false)
        base.panel_units_list.show(false);
        MapWindow.unselectAll();
    end
    -- Country
    local t_country = Widget.new(cdata.country)
    t_country:setBounds(U.offset_w, U.widget_h+U.offset_h, U.text_w, U.widget_h)
    window:addChild(t_country)
        
    c_country = U.create_combo(vdata.countries)
    c_country:setReadonly(true)
    c_country:setBounds(U.offset_w+U.text_w+U.dist_w, U.widget_h+U.offset_h, 
        w-(U.offset_w*2+U.text_w+U.dist_w), U.widget_h)
    window:addChild(c_country)
    c_country:setText(vdata.country) 
    function c_country:onChange()
        --     ,     
        local country = self:getText()
        if #country_ship_list[country] == 0 then
            self:setText(vdata.country)
            return
        end
        vdata.country = self:getText()
        changeCountry(vdata.country)
        if vdata.group then
            local unit =  vdata.group.units[vdata.unit.cur];
            base.module_mission.relinkChildren(unit)
        end
    end
        
    -- Name
    local t_name = Widget.new(cdata.name)
    t_name:setBounds(U.offset_w, U.widget_h+U.offset_h+U.widget_h+U.dist_h, 
                U.text_w, U.widget_h)
    window:addChild(t_name)
    
    e_name = EditBox.new(vdata.name)
    e_name:setBounds(U.offset_w+U.text_w+U.dist_w, 
    U.widget_h+U.offset_h+U.widget_h+U.dist_h, 
    w-(U.offset_w*2+U.text_w+U.dist_w), U.widget_h)
    window:addChild(e_name)
    function e_name:onChange()
        vdata.name = base.module_mission.check_group_name(self:getText())
        if vdata.group then
            base.module_mission.renameGroup(vdata.group, vdata.name)
            base.panel_units_list.updateRow(vdata.group);
        end
    end

        -- Unit
        local t_unit = Widget.new(cdata.unit.title)
        t_unit:setBounds(U.offset_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*2, U.text_w, U.widget_h)
        window:addChild(t_unit)
           
        sp_unit = U.create_spin(1,vdata.unit.number,1,vdata.unit.cur)
        sp_unit:setBounds(U.offset_w+U.text_w+U.dist_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*2, U.spin_w*0.8, U.widget_h)
        window:addChild(sp_unit)
        function sp_unit:onChange()
            vdata.unit.cur = self:getValue()
            if vdata.group then
                for i=1,vdata.unit.number do
                    vdata.group.mapObjects.units[i].currColor = vdata.group.boss.boss.selectGroupColor
                end
                vdata.group.mapObjects.units[vdata.unit.cur].currColor = vdata.group.boss.boss.selectUnitColor
                if vdata.unit.cur == 1 then
                    vdata.group.mapObjects.route.points[1].currColor = vdata.group.boss.boss.selectUnitColor
                else
                    vdata.group.mapObjects.route.points[1].currColor = vdata.group.boss.boss.selectGroupColor
                end;
                base.module_mission.update_group_map_objects(vdata.group)
                e_unit_name:setText(vdata.group.units[vdata.unit.cur].name)
                updateHeading()
                base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
                base.panel_route.update()
            end
            c_type:setText(vdata.types[vdata.unit.cur]) 
            c_skill:setText(vdata.skills[vdata.unit.cur]) 
        end
        
        local t_of = Widget.new(cdata.unit.of)
        t_of:setBounds(U.offset_w+U.text_w+U.dist_w+U.spin_w*0.8+U.dist_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*2, U.text_w/4, U.widget_h)
        window:addChild(t_of)
    
        sp_of = U.create_spin(1,cdata.unit.max,1,vdata.unit.number)		   
        sp_of:setBounds(U.offset_w+U.text_w+U.dist_w+U.spin_w*0.8+U.dist_w+U.text_w/4+U.dist_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*2, U.spin_w*0.8, U.widget_h)		
        window:addChild(sp_of)
        function sp_of:onChange()
            local n = self:getValue()
            if n < vdata.unit.number then
                for i = vdata.unit.number, n+1, -1 do
                    base.table.remove(vdata.types, i)
                    base.table.remove(vdata.skills, i)
                    if vdata.group then
                        --       
                        base.module_mission.remove_unit(vdata.group.units[i])
                    end
                end
            elseif n > vdata.unit.number then				
                for i=vdata.unit.number+1,n do
                    if vdata.group then
                        local lat = vdata.group.lat - 0.00014 * (i - 1)
                        local long = vdata.group.long + 0.00014 * (i - 1)
                        warningCallback = function ()
                            MapWindow.showWarningWindow(cdata.placeUnitOnSea)
                        end; 
                        local res = MapWindow.checkSurface(vdata.group, lat, long, true, warningCallback);
                        if res == false then
                            local _n = n-1;
                            if _n >= 1 then
                                self:setValue(_n);
                            end;
                            return;
                        end;                        
                       -- base.table.insert(vdata.types, vdata.types[vdata.unit.cur])
					   -- base.table.insert(vdata.skills, vdata.skills[vdata.unit.cur])
					    base.table.insert(vdata.types, vdata.types[1])
                        base.table.insert(vdata.skills, vdata.skills[1])
                        --       
                        base.module_mission.insert_unit(vdata.group, 
                                vdata.types[1], cdata.skill.list[1], i, nil, 
                                lat, long, 
                                vdata.group.units[vdata.unit.cur].heading)
                    end
                end				
            end
            vdata.unit.number = n
            vdata.unit.cur = vdata.unit.number
            c_type:setText(vdata.types[vdata.unit.cur])
            if vdata.group then
                for i=1,vdata.unit.number do
                    vdata.group.mapObjects.units[i].currColor = vdata.group.boss.boss.selectGroupColor
                end
                vdata.group.mapObjects.route.points[1].currColor = vdata.group.boss.boss.selectGroupColor
                vdata.group.mapObjects.units[vdata.unit.cur].currColor = vdata.group.boss.boss.selectUnitColor
                base.module_mission.update_group_map_objects(vdata.group)
                            e_unit_name:setText(vdata.group.units[vdata.unit.cur].name)
            end
            sp_unit:setRange(1, vdata.unit.number)
            sp_unit:setValue(vdata.unit.cur)
            
            c_skill:setText(vdata.skills[vdata.unit.cur]) 
            base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
            base.panel_route.update()
            base.panel_units_list.updateRow(vdata.group);
        end
        
        -- Type
    local t_type = Widget.new(cdata.type.title)
    t_type:setBounds(U.offset_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*3,
                U.text_w, U.widget_h)
    window:addChild(t_type)

    local panel = Widget.new()
    panel:setTheme(Theme.newMEGroupPaneTheme())
    panel:setBounds(U.offset_w, h-U.widget_h+10, w-U.offset_w*2, U.widget_h)
    window:addChild(panel)
    
    c_type = U.create_combo(country_ship_list[vdata.country])
    c_type:setReadonly(true)
    c_type:setBounds(U.offset_w+U.text_w+U.dist_w, 
        U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*3, 
        w-(U.offset_w*2+U.text_w+U.dist_w), U.widget_h)
    window:addChild(c_type)
    c_type:setText(vdata.types[vdata.unit.cur]) 
    function c_type:onChange()
        vdata.types[vdata.unit.cur] = self:getText()
        if vdata.group then
            base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
            base.panel_route.update()
            --            .
            local unit =  vdata.group.units[vdata.unit.cur];
            unit.type = vdata.types[vdata.unit.cur]
            unit.CLSID = base.me_db.ship_by_name[vdata.types[vdata.unit.cur] ].CLSID
            MapWindow.updateSelectedGroup(vdata.group)
            MapWindow.mapView:updateUserList(true)
            base.module_mission.relinkChildren(unit)
        end
    end
        
        -- Unit name
        local t_unit_name = Widget.new(cdata.unit_name)
    t_unit_name:setBounds(U.offset_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*4, U.text_w, U.widget_h)
        window:addChild(t_unit_name)
        
        e_unit_name = EditBox.new('')
    e_unit_name:setBounds(U.offset_w+U.text_w+U.dist_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*4, w-(U.offset_w*2+U.text_w+U.dist_w), U.widget_h)
        window:addChild(e_unit_name)
        function e_unit_name:onChange()
            local name = self:getText()
            local group = vdata.group
            if group then
                local unit = group.units[vdata.unit.cur]
                base.module_mission.renameUnit(unit, name)
            else
                vdata.names[1] = name
            end
        end
        
        -- Skill
        local t_skill = Widget.new(cdata.skill.title)
    t_skill:setBounds(U.offset_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*5, U.text_w, U.widget_h)
        window:addChild(t_skill)
        
        c_skill = U.create_combo(cdata.skill.list)
                c_skill:setReadonly(true)
    c_skill:setBounds(U.offset_w+U.text_w+U.dist_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*5, w-(U.offset_w*2+U.text_w+U.dist_w), U.widget_h)
        window:addChild(c_skill)
        c_skill:setText(vdata.skills[vdata.unit.cur]) 
        function c_skill:onChange()
            vdata.skills[vdata.unit.cur] = self:getText()
            if vdata.group then
                vdata.group.units[vdata.unit.cur].skill = self:getText()
            end
        end

    -- Heading --------------------------------------------------------------
    t_heading = Widget.new(cdata.heading)
    t_heading:setBounds(U.offset_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*6, U.text_w, U.widget_h)
    window:addChild(t_heading)
    
    e_heading = U.create_spin(0, 359, 1, 0)
    e_heading:setBounds(U.offset_w+U.text_w+U.dist_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*6, w-(U.offset_w*2+U.text_w+U.dist_w) - 100, U.widget_h)
    window:addChild(e_heading)
    function e_heading:onChange()
        local n = self:getValue()
        vdata.group.units[vdata.unit.cur].heading = n*base.math.pi/180
        d_heading:setValue(n)
    end
    
    d_heading = Dial.new()
    d_heading:setRange(0, 359)
    d_heading:setBounds(U.offset_w+U.text_w+U.dist_w + w-(U.offset_w*2+U.text_w+U.dist_w) - 80, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*6, U.widget_h, U.widget_h)
    window:addChild(d_heading)
    --d_heading:setArrowSize(U.widget_h, U.widget_h)
    function d_heading:onChange()
            vdata.group.units[vdata.unit.cur].heading = self:getValue()*base.math.pi/180.0
            e_heading:setValue(base.math.floor(self:getValue()))
    end
        
	hiddenCheckbox = CheckBox.new(cdata.hidden);
	hiddenCheckbox:setBounds(U.offset_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*7, U.edit_w, U.widget_h)
	window:addChild(hiddenCheckbox);
	hiddenCheckbox.onChange = MapWindow.OnHiddenCheckboxChange;

    visibleCheckbox = CheckBox.new(cdata.visible)
    visibleCheckbox:setBounds(U.offset_w, U.widget_h+U.offset_h+(U.widget_h+U.dist_h)*8, U.edit_w, U.widget_h)
    function visibleCheckbox:onChange()
        if vdata.group then
            vdata.group.visible = self:getState();
        else
            self:setState(false)
        end;
    end;
    window:addChild(visibleCheckbox);
        
	vdata.tabs = tabs.createUnitTabs(true, window, 
		U.offset_w+5, h-U.widget_h-4)
        
--	update()
end


-------------------------------------------------------------------------------
function setPlannerMission(planner_mission)
	if (planner_mission == true) then
		c_country:setEnabled(false)
		e_name:setEnabled(false)
		sp_of:setEnabled(false)
		c_type:setEnabled(false)
		e_unit_name:setEnabled(false)
		c_skill:setEnabled(false)
		e_heading:setEnabled(false)
		d_heading:setEnabled(false)
		hiddenCheckbox:setVisible(false)
		visibleCheckbox:setVisible(false)
	else
		c_country:setEnabled(true)
		e_name:setEnabled(true)
		c_type:setEnabled(true)
		e_unit_name:setEnabled(true)
		c_skill:setEnabled(true)
		e_heading:setEnabled(true)
		d_heading:setEnabled(true)
		hiddenCheckbox:setVisible(true)
		visibleCheckbox:setVisible(true)
	end
	
end

-- / 
function show(b)
    if b == window:isVisible() then
        return
    end
	window:setVisible(b)
	if not b then
		vdata.group = nil
	else
		setPlannerMission(base.isPlannerMission())
	end
end

--    
function load(fName)
    base.dofile(fName)
    vdata = base.vdata
end

--    
function save(fName)
    local f = base.io.output(fName, 'w')
    if f then
        local s = S.new(f)
        s:serialize_simple('vdata', vdata)
        f:close()
    end
end

-- update heading controls
function updateHeading()
    local heading = 0;
    if vdata.group and (#vdata.group.route.points > 1) then
        e_heading:setVisible(false);
        d_heading:setVisible(false);
        t_heading:setVisible(false);
        local p1 = vdata.group.route.points[1];
        local p2 = vdata.group.route.points[2];
        
        local long1 = p1.long;
        local long2 = p2.long;
        local lat1 = p1.lat;
        local lat2 = p2.lat;
        
        if (long1 == long2) and (lat1 == lat2) then
            base.print('Waypoints equal!', p1.index, p2.index);
            heading = 0;
            if vdata.group then
                vdata.group.units[vdata.unit.cur].heading = heading;
            end
            return;
        end;
        
        
        local cos = base.math.cos;
        local sin = base.math.sin;
        local asin = base.math.asin;
        local acos = base.math.acos;
        local atan = base.math.atan;
        local atan2 = base.math.atan2;
        local pow = base.math.pow;
        local pi  = base.math.pi;
        local deg  = base.math.deg;

        local dl = long2 - long1;

        heading = - (atan2( ( cos(lat1)*sin(lat2) - sin(lat1)*cos(lat2)*cos(dl) ) , ( sin(dl)*cos(lat2) ) ) - pi/2);
        if vdata.group then
            vdata.group.units[vdata.unit.cur].heading = heading;
        end
            
        --base.print('azimuth', a, deg(a));
    else
        e_heading:setVisible(true);
        d_heading:setVisible(true);
        t_heading:setVisible(true);
        heading = 0
        if vdata.group then
            heading = base.math.floor(vdata.group.units[vdata.unit.cur].heading*180/base.math.pi)
        end
    end;
    e_heading:setValue(heading)
    d_heading:setValue(heading)
end

function update()
    --changeCountry(vdata.country)
    c_country:setText(vdata.country)
    e_name:setText(vdata.name) 
    sp_unit:setValue(vdata.unit.cur)
    sp_unit:setRange(1,vdata.unit.number) 
    sp_of:setValue(vdata.unit.number)
    U.fill_combo(c_type, country_ship_list[vdata.country]) 
    c_type:setText(vdata.types[vdata.unit.cur]) 
    if vdata.group then
        if vdata.group.units[vdata.unit.cur].name then 
            e_unit_name:setText(vdata.group.units[vdata.unit.cur].name)
        else
            e_unit_name:setText('')
        end
        vdata.types = {};
        for i = 1, #vdata.group.units do
            base.table.insert(vdata.types, vdata.group.units[i].type);
			--vdata.types[i] = vdata.group.units[i].type
        end;        
        hiddenCheckbox:setState(vdata.group.hidden);
		visibleCheckbox:setState(vdata.group.visible);
		
        base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
        base.panel_route.update()
    end
--	U.fill_combo(c_skill, vdata.skills) 
    c_skill:setText(vdata.skills[vdata.unit.cur])
    updateHeading()
end

function updateCountries(c)
    --         
    vdata.countries = {}
    for i=1,#c do
        if #country_ship_list[c[i] ] > 0 then
            base.table.insert(vdata.countries, c[i])
        end
    end
    if #vdata.countries > 0 then
        U.sortCountries(vdata.countries)
        U.fill_combo(c_country, vdata.countries)
        vdata.country = c_country:getText()
        if vdata.group then
			update()
		else
			changeCountry(vdata.country)
		end
    else
        vdata.country = nil
    end
end

function changeCountry(c)
    vdata.country = c
    for i=1,#vdata.types do
        vdata.types[i] = country_ship_list[vdata.country][1]
    end
    U.fill_combo(c_type, country_ship_list[vdata.country]) 
    c_type:setText(vdata.types[vdata.unit.cur]) 
    if vdata.group then
        --     . 
        local tbl = vdata.group.boss.ship.group
        if tbl then
            for i,v in base.pairs(tbl) do
                if v == vdata.group then
                    base.table.remove(tbl, i)
                    break
                end
            end
        end
        base.module_mission.remove_group_map_objects(vdata.group)
        --     .
        local c = base.module_mission.missionCountry[vdata.country]
        base.table.insert(c.ship.group, vdata.group)
        vdata.group.boss = c
        --    
        vdata.group.color = c.boss.color
        U.fill_combo(c_type, country_ship_list[vdata.country])
        --              .
        --   ,      .
        vdata.types = {}
        for i=1,#vdata.group.units do
            local unit = vdata.group.units[i]
            unit.type = country_ship_list[vdata.country][1]
            unit.CLSID = base.me_db.unit_by_name[unit.type].CLSID
            base.table.insert(vdata.types, unit.type)
        end
        c_type:setText(country_ship_list[vdata.country][1])
        base.panel_route.vdata.unit = vdata.group.units[vdata.unit.cur]
        base.panel_route.update()
        base.panel_targeting.update()
        MapWindow.updateSelectedGroup(vdata.group)
        MapWindow.mapView:updateUserList(true)
        base.panel_units_list.updateRow(vdata.group);
    end
end

-- disable editing of unsafe elements
function setSafeMode(enable)
    local e = not enable

    sp_unit:setEnabled(e)
    sp_of:setEnabled(e)
    vdata.tabs:setEnabled(e)
    e_heading:setEnabled(e)
    d_heading:setEnabled(e)
end

initModule();
