local base = _G

module('me_mission')

local S = base.require('Serializer')
local Color = base.require('Color')
local MapWindow = base.require('me_map_window')
local MsgWindow = base.require('MsgWindow')
--  Roads   C++       .
--  ,        
--         . 
local Roads = base.require('Roads')
--  edTerrain -      Black Shark.
--          
--   Land.lsa2     
--    .
--   edTerrain     
--  ,       Lua.
--       lua-edTerrain.dll.
--      Common.dll  Math.dll, 
--      .
local Terrain = base.require('edTerrain')
local zip = base.require('ziplua')
local minizip = base.require('minizip')
local Goal = base.require('me_goal')
local Trigger = base.require('me_trigrules')
local Gui = base.require('gui5')
local MenuBar = base.require('me_menubar')
local MainMenu = base.require('MainMenu')
local Window = base.require('Window')
local Button = base.require('Button')
local Debriefing = base.require('me_debriefing')
local U = base.require('me_utilities')
local T = base.require('tools')
local crutches = base.require('me_crutches')  -- temporary crutches
local lfs = base.require('lfs')
local AutoBriefingModule = base.require('me_autobriefing')
local i18n = base.require('i18n')
local route = base.require('me_route')
local MapView = base.require('MapView')
local LogBook = base.require('me_logbook')
local Failures = base.require('me_failures')


i18n.setup(_M)


-- minimum scale to show units in group
UNITS_SCALE = 25000

-- maximum unit ID number
local maxUnitId = 0

-- maximum group ID number
local maxGroupId = 0

-- maximum zone ID number
local maxZoneId = 0


--    
--[[
  group.mapObjects = {
    --   .
    units = {
      [1] = {
        index = 1,
      },
    },
    --  ,   ..
    zones = {
      [1] = {
      },
    },
    -- 
    route = {
      -- ,   ,       .
      line = {
        [1] = {
          [1] = {x=..., y=...},
          ...
        },
        ...
      },
      --  .
      points = {
        [1] = {
          index = 1,
        },
      },
      --    .
      numbers = {
        [1] = {
          index = 1,
        },
      },
      -- ,    .
      targets = {
        --      .
        [1] = {
          [1] = {
            index = 1,
          },
        },
      },
      --  ,    .
      targetNumbers = {
        --      .
        [1] = {
          [1] = {
            index = 1,
          },
        },
      },
      --  ,    .
      targetZones = {
        --      .
        [1] = {
          [1] = {
            index = 1,
          },
        },
      },
      --      .
      targetLines = {
        --      .
        [1] = {
          [1] = {
            index = 1,
          },
        },
      },
    },
  }
--]]


cdata =
{
  blue = 'BLUE',
  red = 'RED',
  newMission = _('New Mission.miz'),
}
coalitionColors =
{
  red = {
    color = Color.red_unselected,
    selectGroupColor = Color.red_group_selected,
    selectUnitColor = Color.red_unit_selected,
    selectWaypointColor = Color.red_waypoint_selected,
  },
  blue = {
    color = Color.blue_unselected,
    selectGroupColor = Color.blue_group_selected,
    selectUnitColor = Color.blue_unit_selected,
    selectWaypointColor = Color.blue_waypoint_selected,
  },
}

group_types = {
  'plane',
  'helicopter',
  'ship',
  'vehicle',
  'static',
  'complex',
}


resources = {};

--       - . 
--   .
function create()
    if not created then    
        create_new_mission()
        created  = true;
    end;  
end

-- find and write countries names
function fixCountriesNames(countries)
    for _tmp,v in base.pairs(countries) do
        v.name = base.me_db.country_by_id[v.id].Name
    end
end


-- convert categories IDs to categories names
function fixStaticCategories(coalition)
    for _tmp, country in base.pairs(coalition.country) do
        for _tmp, group in base.pairs(country.static.group) do
            group.units[1].category = crutches.staticCategoryIdToName(
                group.units[1].category)
        end
    end
end


-- substitude skills IDs by skills names
function fixUnitsSkills()
    for _tmp, v in base.pairs(unit_by_id) do
        if v.skill then
            v.skill = crutches.idToSkill(v.skill)
        end
    end
end

-- substitute tasks names with task IDs
function fixTasks()
    for _tmp, v in base.pairs(group_by_id) do
        if v.task then
            v.task = crutches.idToTask(v.task)
        end
    end
end

-- fix types of waypoints
function fixWaypointsTypes()
    for _tmp1, v in base.pairs(group_by_id) do
        if v.route and base.pairs(v.route.points) then
            for _tmp, w in base.pairs(v.route.points) do
                w.type = route.waypointActionToType(w.type, w.action)
                w.action = nil
            end
        end
    end
end

-- fix waypoint linkage
function fixWaypointsLinks()
    for _tmp, v in base.pairs(group_by_id) do
        if ("plane" == v.type) or ("helicopter" == v.type) then
            if v.route and base.pairs(v.route.points) then
                for _tmp, w in base.pairs(v.route.points) do
                    if w.linkParent then --     
                        local groupNum = w.linkParent
                        w.linkParent = nil
                        --   1- 
                        local unitInd, unit = base.next(unit_by_id);
                        linkWaypoint(w, group_by_id[groupNum], unit);
                    else
                        if w.linkUnit then --  
                            local unitNum = w.linkUnit
                            w.linkParent = nil
                            w.linkUnit = nil;
                            local unit = unit_by_id[unitNum];
                            local group = unit.boss;
                            linkWaypoint(w, group, unit);
                        end
                    end;
                end
            end
        end
    end
end


function isNumber(n)
    if nil ~= base.tonumber(n) then
        return true
    else
        return false
    end
end

-- convert airdromes from early versions
function fixAirdromes()
    for _tmp, v in base.pairs(group_by_id) do
        if ("plane" == v.type) or ("helicopter" == v.type) then
            if v.route and base.pairs(v.route.points) then
                for _tmp, w in base.pairs(v.route.points) do
                    if w.airdrome then
                        if w.linkUnit then
                            w.helipadId = w.linkUnit.units[1].unitId
                        else
                            if isNumber(w.airdrome) then
                                w.airdromeId = w.airdrome
                            else
                                w.helipadId = group_by_name[w.airdrome].units[1].unitId
                            end
                        end
                        w.airdrome = nil
                    end
                end
            end
        end
    end
end

--          
function extractMission(fName)
    local zipFile, err = minizip.unzOpen(fName, 'rb')
    if zipFile == nil then
        base.Gui.MessageBox("Can not read file " .. fName .. '\n' .. (err or ''), 'Error');
        return;
    end;
    local misStr
    if zipFile:unzLocateFile("mission") then misStr = zipFile:unzReadAllCurrentFile() end
    zipFile:unzClose()

    local fun, errStr = base.loadstring(misStr)
    if not fun then
        base.print("error loading mission", errStr)
        local w = MsgWindow.new(_('Error loading mission "') .. fName .. 
            '": ' .. errStr,  _('Error'), 'error', 'OK')
        w:setVisible(true);
        return
    end

    local env = { }
    base.setfenv(fun, env)
    fun()
    local mission = env.mission

    base.mission = nil
    return mission;
end;


-- bypassEditor == true     
function load(fName, bypassEditor)
    --     ,   ,    
    local zipFile, err = minizip.unzOpen(fName, 'rb')
    if zipFile == nil then
        base.Gui.MessageBox("Can not read file " .. fName .. '\n' .. (err or ''), 'Error');
        return false;
    end;

    local extOptions
    if zipFile:unzLocateFile('options') then
        local optStr = zipFile:unzReadAllCurrentFile()
        local fun, errStr = base.loadstring(optStr)
        if not fun then
            base.print("error loading mission options", errStr)
            local w = MsgWindow.new(_('Error loading mission "') .. fName .. 
                '" options: ' .. errStr,  _('Error'), 'error', 'OK')
            w:setVisible(true);
            return false
        end
        local env = { }
        base.setfenv(fun, env)
        fun()
        extOptions = env.options
    end

    local misStr
    if zipFile:unzLocateFile('mission') then
        misStr = zipFile:unzReadAllCurrentFile()
    end
    maxUnitId = 0
    maxGroupId = 0
    maxZoneId = 0

    unpackFiles(zipFile);
    zipFile:unzClose()

    local fun, errStr = base.loadstring(misStr)
    if not fun then
        base.print("error loading mission", errStr)
        local w = MsgWindow.new(_('Error loading mission "') .. fName .. 
            '": ' .. errStr,  _('Error'), 'error', 'OK')
        w:setVisible(true);
        return false
    end

    --      ,       .
    mapObjects = {}
    
    base.panel_aircraft.vdata.group = nil
    base.panel_aircraft.vdata.callsign = '';
    base.panel_aircraft.vdata.onboard_num = 0;
    base.panel_ship.vdata.group = nil
    base.panel_vehicle.vdata.group = nil
    base.panel_route.vdata.group = nil
    base.panel_payload.vdata.group = nil
    base.panel_targeting.vdata.group = nil
    base.panel_summary.vdata.group = nil
    group_by_name = {}
    group_by_id = {}
    groupNameIndex = 1000
    unit_by_name = {}
    unit_by_id = {}
    unitNameIndex = 0
    waypointNameIndex = 0
    target_by_name = {}
    targetNameIndex = 0
    zone_by_name = {}
    zone_by_id = {}
    zoneNameIndex = 0

    local env = { }
    base.setfenv(fun, env)
    fun()
    mission = env.mission

 
    mission.path = fName;
    base.mission = nil
    mission.mapElementsCreated = false;
 
    -- switch from countries IDs to countries names
    mission.coalitions = base.panel_coalitions.parseCoalitions(mission.coalitions)
 
    currentKey = mission.currentKey
    fixBriefingPictures()  
    if mission.start_time then
      base.panel_briefing.vdata.start_time = mission.start_time
      base.panel_briefing.update()
    end
    --       
    
    --       
    base.panel_coalitions.vdata.coalitions = mission.coalitions
    base.panel_coalitions.update_panels()
    --  
    --     
    --  
    mission.goals = Goal.loadGoals(mission.goals)
    mission.trigrules = Trigger.loadTriggers(mission.trigrules)
    
    missionCountry = {}
    countryCoalition = {}
	
	if mission.failures then
		U.copyTable(base.panel_failures.vdata, mission.failures)
		--base.U.traverseTable(base.panel_failures.vdata)		
	end
  
    for _k, color in base.pairs({'red', 'blue'}) do
        local coalition = mission.coalition[color]
        coalition.name = cdata[color]
        for k, v in base.pairs(coalitionColors[color]) do
            coalition[k] = v
        end
 
        fixCountriesNames(coalition.country)
        
        for i,v in base.pairs(coalition.country) do
            missionCountry[v.name] = v
            countryCoalition[v.name] = coalition
        end
       
        fixStaticCategories(coalition)
        createCoalitionObjects(coalition)
        updateOnboardNumbersCallsigns();
    end
    
    fixUnitsSkills()
    fixTasks()
    fixWaypointsTypes()
    fixWaypointsLinks()
    
    for id,unit in base.pairs(unit_by_id) do
        local group = unit.boss;
        if ( group.type == 'plane' ) or ( group.type == 'helicopter' ) then
            unit.callsign = convertCallsign(unit.callsign)
			if (unit.skill == crutches.getPlayerSkill()) then
				--    
				base.panel_failures.load_mission(unit.type)				
			end
        end;
    end;
    
    
    if (not mission.version) or (2 > mission.version) then
        fixAirdromes()
    end

    base.print('Mission '..fName..' loaded')
  
    if mission.triggers then
        if mission.triggers.zones then
            for i=1,#mission.triggers.zones do
                local zone = mission.triggers.zones[i]
                if not zone.zoneId then
                    maxZoneId = maxZoneId + 1
                    zone.zoneId = maxZoneId
                else
                    if zone.zoneId > maxZoneId then
                        maxZoneId = zone.zoneId
                    end
                end                
                zone.mapObjects = {}
                zone_by_name[zone.name] = zone;
                zone_by_id[zone.zoneId] = zone;
            end
        end
    end
  
    if not bypassEditor then
        MapWindow.show(true);
    end;

    
    mission.forcedOptions = mission.forcedOptions or {};
    base.panel_options.setForcedOptions(mission.forcedOptions)

    full_current_mission_path = fName
    mission.hasPlayer = isPlayerAvailable()
    base.statusbar.t_file:setText(U.extractFileName(fName));
    base.panel_coalitions.updateCountries()
    base.panel_units_list.updateCountriesCombo()
    originalMission = {};
    base.U.recursiveCopyTable(originalMission, mission);
	
	
	
	--base.panel_coalitions.vdata.theatre_of_war = mission.theatre_of_war,
    
    fixCallsigns(); --  ,        
    
    return true;
end

function updateOnboardNumbersCallsigns() 
    local panel = base.panel_aircraft;
    for coalitionInd, coalition in base.pairs(mission.coalition) do
        for countryInd, country in base.pairs(coalition.country) do
            for _tmp1, type in base.ipairs({'plane', 'helicopter'}) do
                local groups = country[type].group;
                for _tmp2, group in base.ipairs(groups) do
                    local units = group.units;
                    for _tmp3, unit in base.ipairs(units) do
                        if panel.vdata.onboard_num < (base.tonumber(unit.onboard_num) or 0) then
                            panel.vdata.onboard_num = base.tonumber(unit.onboard_num) or 0;
                            --base.print('unit.onboard_num',unit.onboard_num)
                        end;
                        -- if panel.vdata.callsign < (base.tonumber(unit.callsign) or 0) then
                            -- panel.vdata.callsign = base.tonumber(unit.callsign) or 0;
                            --base.print('unit.callsign',unit.callsign);
                        -- end;
                    end;
                end;
            end;
        end;
    end;
end;

function createMapElements()
    MapWindow.mapView:clearUserObjects()
    MapWindow.mapView:updateUserList(true)
    MapWindow.selectedGroup = nil

    if mission.map then
        MapWindow.mapView:setCamera(mission.map.centerX, mission.map.centerY)
        MapWindow.mapView:setScale(mission.map.zoom)
    end

    MapWindow.mapView:clearUserObjects()
    for id,group in base.pairs(group_by_id) do
        create_group_map_objects(group);
    end;
    
    if mission.triggers then
        if mission.triggers.zones then
            for i=1,#mission.triggers.zones do
                local zone = mission.triggers.zones[i]
                if not zone.hidden then
                    create_trigger_zone_map_object(zone)
                end;
            end
        end
    end

    MapWindow.mapView:updateUserList(true)
    mission.mapElementsCreated = true;
    --base.U.traverseTable(mission);
end;

--         .
function createCoalitionObjects(cltn)
    --base.print('creating coalition',cltn);
  local color = cltn.color
  for i,v in base.pairs(cltn.country) do
    v.boss = cltn
    for k,w in base.pairs(group_types) do
        --base.print('creating category ---->',k,w);
      if v[w] then
        for j,u in base.pairs(v[w].group) do
            --base.print('creating group',u.name);
            if (not u.units) or (0 >= #u.units) then
                base.print('BIG FAT WARNING: empty group detected', u.name)
                base.table.remove(v[w], j)
            else
              local nm = check_group_name(u.name)
              group_by_name[nm] = u
              if u.groupId then
                  if maxGroupId < u.groupId then
                      maxGroupId = u.groupId
                  end
              else 
                  -- mission in old format
                  maxGroupId = maxGroupId + 1
                  u.groupId = maxGroupId
              end
              while (group_by_id[u.groupId] ~= nil) do
                u.groupId = u.groupId + 1;
                --base.print('incrementing group Id to',u.groupId);
              end;
              group_by_id[u.groupId] = u
              u.name = nm
              u.boss = v
              u.type = w
              u.color = color
              for s,r in base.pairs(u.units) do
                if r.unitId then
                  if maxUnitId < r.unitId then
                      maxUnitId = r.unitId
                  end
                else
                    -- mission in old format
                    maxUnitId = maxUnitId + 1
                    r.unitId = maxUnitId
                end
                r.type = base.me_db.getDisplayNameByName(r.type)
                unit_by_id[r.unitId] = r
                if not r.name then
                  unitNameIndex = unitNameIndex+1
                  r.name = check_unit_name('Unit #1')
                end
                local un = check_unit_name(r.name)
                r.name = un
                local skill = r.skill or '';
                if _(skill) == crutches.getPlayerSkill() then
                    playerUnit = r;
                end;
              end
              if u.INUFixPoints then 
                for i = 1,#u.INUFixPoints do
                    u.INUFixPoints[i].boss = u;
                end
              end;
              create_group_objects(u);
            end
        end
      end
    end
  end
end


--    .
function create_new_mission(doNotCreateDefaultCoalitions)
  maxUnitId = 0
  maxGroupId = 0
  maxZoneId = 0
  clearTempFolder()
  mapObjects = {}
  if MapWindow.created then
      MapWindow.selectedGroup = nil;
      MapWindow.mapView:clearUserObjects()
      MapWindow.mapView:updateUserList(true)
  end;
  base.panel_aircraft.vdata.group = nil
  base.panel_ship.vdata.group = nil
  base.panel_vehicle.vdata.group = nil
  base.panel_route.vdata.group = nil
  base.panel_payload.vdata.group = nil
  base.panel_targeting.vdata.group = nil
  base.panel_summary.vdata.group = nil
  
  for name, module in base.pairs(base.package.loaded) do
    if 'table' == base.type(module) then
        local fun = module.initModule;
        if fun and ('function' == base.type(fun)) then
            fun()
        end;
    end
  end;
  
  resources = {};
  mission = {}
  currentKey = 0
  mapObjects = {}
  group_by_name = {}
  group_by_id = {}
  groupNameIndex = 1000
  unit_by_name = {}
  unit_by_id = {}
  unitNameIndex = 0
  waypointNameIndex = 0
  target_by_name = {}
  targetNameIndex = 0
  zone_by_name = {}
  zone_by_id = {}
  zoneNameIndex = 0
  mission.start_time = 43200;
  base.panel_briefing.vdata.start_time = mission.start_time
  base.panel_weather.loadDefaultWeather()
  mission.weather = U.copyTable(nil, base.panel_weather.vdata)

  base.panel_failures.clear()
  mission.failures = {}
  U.copyTable(mission.failures, base.panel_failures.vdata)
  

  mission.triggers = {}
  if (doNotCreateDefaultCoalitions ~= true) then
    base.panel_coalitions.loadDefaultCoalitions();
  end;
  mission.coalitions = base.panel_coalitions.vdata.coalitions
  mission.goals = { }
  mission.pictureFileNameR = {};
  mission.pictureFileNameB = {};

  mission.coalition = { }
  missionCountry = {}
  countryCoalition = {}

  for _k, color in base.pairs({'red', 'blue'}) do
      local coalition = { }
      mission.coalition[color] = coalition

      coalition.name = cdata[color]
      for k, v in base.pairs(coalitionColors[color]) do
          coalition[k] = v
      end
          
      coalition.airports = {}
      coalition.heliports = {}
      coalition.country = {}

      for i, v in base.pairs(mission.coalitions[color]) do
          local country = {
              id = base.tonumber(base.me_db.country_by_name[v].WorldID),
              boss = coalition, 
              name = v,
              plane = {group = {},},
              helicopter = {group = {},},
              ship = {group = {},},
              vehicle = {group = {},},
              static = {group = {},},
          }
        base.table.insert(coalition.country, country)
        missionCountry[v] = country
        countryCoalition[v] = coalition
      end
  end
        
  mission.forcedOptions = {}
  base.panel_options.setForcedOptions(mission.forcedOptions);
  
  base.statusbar.t_file:setText(cdata.newMission);
  base.panel_coalitions.updateCountries()
  
    originalMission = {};
    base.U.recursiveCopyTable(originalMission, mission);  
end


--      .
function unload_air_groups(u, type, cant)
  cant[type] = {group = {}}
  for k,w in base.pairs(u[type].group) do
    local gr = {
        groupId = w.groupId, 
        name = w.name, 
        start_time = w.start_time, 
        task = crutches.taskToId(w.task), 
		taskSelected = w.taskSelected,
        units = {}, 
        route = {points = {}}, 
        hidden = w.hidden}
    cant[type].group[k] = gr
    for l=1,#w.units do
      local s = w.units[l]
      if (nil == s.lat) and (nil == s.long) then
          s.lat = w.lat
          s.long = w.long
      end
      local uX, uY = MapWindow.mapView:convertRadiansToMeters(s.lat, s.long)
	  --base.print('name=',s.name,'s.callsign=',s.callsign)
      local un = {
              unitId = s.unitId,
              name = s.name, 
			  type = base.me_db.unit_by_CLSID[w.units[l].CLSID].ID, 
              CLSID = s.CLSID,
              skill = crutches.skillToId(s.skill), 
              onboard_num = base.tonumber(s.onboard_num),			  
              callsign = unloadCallsign(s.callsign), --base.tonumber(s.callsign),
              lat = s.lat,
              long = s.long,
              x = uX,
              y = uY,
              payload = {
                  fuel = s.payload.fuel,
                  chaff = s.payload.chaff,
                  flare = s.payload.flare,
                  gun = s.payload.gun,
                  pylons = {},
              }
          }
      if s.livery_id then
          un.livery_id = s.livery_id
      end
      if w.route.points[1].type.type == 'TakeOffParking' then
          un.start_type = 3
      elseif w.route.points[1].type.type == 'TakeOff' then
          un.start_type = 2
      end
      gr.units[l] = un
      for m, t in base.pairs(s.payload.pylons) do
        local pyl = {name = t.name, CLSID = t.CLSID}
        un.payload.pylons[m] = pyl
      end
    end
    for l=1,#w.route.points do
      local s = w.route.points[l]
      local uX, uY = MapWindow.mapView:convertRadiansToMeters(s.lat, s.long)
      local pt = {
          name = s.name,
          lat = s.lat,
          long = s.long,
          alt = s.alt,
          type = s.type.type,
          action = s.type.action,
          speed = s.speed,
          x = uX,
          y = uY,
          helipadId = s.helipadId,
          airdromeId = s.airdromeId,
      }
      if s.linkUnit then
          pt.linkUnit = s.linkUnit.unitId
      end
      if s.targets then
        pt.targets = {}
        for m=1, #s.targets do
          local r = s.targets[m]
          local uX, uY = MapWindow.mapView:convertRadiansToMeters(r.lat, r.long)
          local target = {
            name = r.name,
            lat = r.lat,
            long = r.long,
            radius = r.radius,
            weapon = r.weapon,
            categories = {
            },
            x = uX,
            y = uY,
          }
          for n,q in base.pairs(r.categories) do
              if r.categories then
                target.categories[n] = q
            end
          end
          pt.targets[m] = target
        end
      end
      gr.route.points[l] = pt
    end
    if w.INUFixPoints then
        gr.INUFixPoints = {};
        for i = 1, #w.INUFixPoints do
              local INUFixPoint = {
                lat = w.INUFixPoints[i].lat,
                long = w.INUFixPoints[i].long,
                index = w.INUFixPoints[i].index,
                x = w.INUFixPoints[i].x,
                y = w.INUFixPoints[i].y,
              }
            base.table.insert(gr.INUFixPoints, INUFixPoint)
        end;        
    end;
  end
end

--       .
function unload_nonair_groups(u, type, cant)
  cant[type] = {group = {}}
  for k,w in base.pairs(u[type].group) do
    local gr = {
        groupId = w.groupId,
        name = w.name, 
        start_time = w.start_time, 
        task = crutches.taskToId(w.task),
		taskSelected = w.taskSelected,
        units = {}, 
        route = {points = {}}, 
        hidden = w.hidden,
        visible = w.visible or false,
        }
    cant[type].group[k] = gr
    for l=1,#w.units do
      local s = w.units[l]
      local uX, uY = MapWindow.mapView:convertRadiansToMeters(s.lat, s.long)
      local heading = s.heading
      if not heading then
          heading = 0
      end
      local un = {
          unitId = s.unitId,
          name = s.name, 
          type = base.me_db.unit_by_CLSID[w.units[l].CLSID].ID, 
          CLSID = s.CLSID,
          skill = crutches.skillToId(s.skill),
          lat = s.lat,
          long = s.long,
          x = uX,
          y = uY,
          heading = heading,
      }
      gr.units[l] = un
    end 
    for l=1,#w.route.points do
      local s = w.route.points[l]
      local uX, uY = MapWindow.mapView:convertRadiansToMeters(s.lat, s.long)
      local pt = {
        name = s.name,
        lat = s.lat,
        long = s.long,
        alt = s.alt,
        speed = s.speed,
        type = s.type.type,
        action = s.type.action,
        x = uX,
        y = uY,
      }
      if s.targets then
        pt.targets = {}
        for m=1, #s.targets do
          local r = s.targets[m]
          local uX, uY = MapWindow.mapView:convertRadiansToMeters(r.lat, r.long)
          local target = {
            name = r.name,
            lat = r.lat,
            long = r.long,
            radius = r.radius,
            weapon = r.weapon,
            categories = {
            },
            x = uX,
            y = uY,
          }
          pt.targets[m] = target
        end
      end
      gr.route.points[l] = pt
    end
    if w.route.spans then
      gr.route.spans = w.route.spans
--      base.print('Unloading spans:', #gr.route.spans) 
    end
  end
end

--      .
function unload_static_groups(u, type, cant)
  cant[type] = {group = {}}
  for k,w in base.pairs(u[type].group) do
    local uX, uY = MapWindow.mapView:convertRadiansToMeters(w.lat, w.long)
    local gr = {
      groupId = w.groupId,
      name = w.name, 
      lat = w.lat, 
      long = w.long, 
      heading = w.heading,
      hidden = w.hidden,
      dead = w.dead,
      route = {points = {}}, 
      units = {
        [1] = {
          unitId = w.units[1].unitId,
          name = w.units[1].name,
          type = base.me_db.unit_by_CLSID[w.units[1].CLSID].ID, 
          CLSID = w.units[1].CLSID,
          category = crutches.staticCategoryNameToId(w.units[1].category), 
          shape_name = w.units[1].shape_name,
          rate = w.units[1].rate,
          lat = w.units[1].lat, 
          long = w.units[1].long, 
          heading = w.units[1].heading,
          x = uX,
          y = uY,
          heliport_callsign_id = w.units[1].heliport_callsign_id or 0,
		  heliport_frequency = w.units[1].heliport_frequency or 127.5000000
        }
      }
    }
    local uX, uY = MapWindow.mapView:convertRadiansToMeters(gr.lat, gr.long)
    local pt = {
      name = '',
      lat = gr.lat,
      long = gr.long,
      alt = 0,
      type = '',
      action = '',
      speed = 0,
      x = uX,
      y = uY,
    }
    base.table.insert(gr.route.points, pt);
    cant[type].group[k] = gr
  end
end

--      .
function unload()
  --    
  base.panel_loadout.save()
  local mapX, mapY = MapWindow.mapView:getCamera()

  Trigger.fixTriggers(mission.trigrules)
  Goal.fixGoals(mission.goals)
  U.copyTable(mission.failures, base.panel_failures.vdata)

  local um = {
		
    version = 2,
	--theatre_of_war = base.panel_coalitions.vdata.theatre_of_war,
    currentKey = currentKey,
    start_time = mission.start_time, 
    weather = mission.weather, 
    failures = mission.failures,
    triggers = {},
    coalitions = base.panel_coalitions.coalitionsToIds(mission.coalitions), 
    coalition = {},
    result = Goal.generateGoalFunc(mission.goals, 'OFFLINE'), -- Dmut: obsolete, to be removed in A-10
    resultBlue = Goal.generateGoalFunc(mission.goals, 'BLUE'), -- Dmut: obsolete, to be removed in A-10
    resultRed = Goal.generateGoalFunc(mission.goals, 'RED'), -- Dmut: obsolete, to be removed in A-10

    trigfunc = Trigger.generateTriggerFunc(mission.trigrules, false), -- Dmut: obsolete, to be removed in A-10
    trigfuncStartup = Trigger.generateTriggerFunc(mission.trigrules, true), -- Dmut: obsolete, to be removed in A-10
    trigflag = {}, -- ,      -- Dmut: obsolete, to be removed in A-10

    goals = Goal.saveGoals(mission.goals),
    trigrules = Trigger.saveTriggers(mission.trigrules),
    
    pictureFileNameR = mission.pictureFileNameR or {},
    pictureFileNameB = mission.pictureFileNameB or {},
    descriptionText = mission.descriptionText,
    descriptionRedTask = mission.descriptionRedTask,
    descriptionBlueTask = mission.descriptionBlueTask,
    sortie = mission.sortie,
    map = {
        centerX = mapX,
        centerY = mapY,
        zoom = MapWindow.mapView:getScale()
    },
    sounds = mission.sounds;
    forcedOptions = base.panel_options.forcedOptions;
  }
	--base.print('um=',um.theatre_of_war)
  
  um.result = um.result or {}
  um.result.offline = um.result.offline or {}
  um.result.offline.conditions = Goal.generateGoalConditions(mission.goals, 'OFFLINE') 
  um.result.offline.actions = Goal.generateGoalActions(mission.goals, 'OFFLINE') 
  um.result.offline.func = Goal.generateGoalFunc2(mission.goals, 'OFFLINE', 'mission.result.offline') 
  um.result.blue = um.result.blue or {}
  um.result.blue.conditions = Goal.generateGoalConditions(mission.goals, 'BLUE') 
  um.result.blue.actions = Goal.generateGoalActions(mission.goals, 'BLUE') 
  um.result.blue.func = Goal.generateGoalFunc2(mission.goals, 'BLUE', 'mission.result.blue')
  um.result.red = um.result.red or {}
  um.result.red.conditions = Goal.generateGoalConditions(mission.goals, 'RED') 
  um.result.red.actions = Goal.generateGoalActions(mission.goals, 'RED') 
  um.result.red.func = Goal.generateGoalFunc2(mission.goals, 'RED', 'mission.result.red')

  um.trig = um.trig or {}
  um.trig.flag = um.trig.flag or {}
  
  um.trig.custom = mission.trig and mission.trig.custom or {}
  um.trig.customStartup = mission.trig and (#mission.trig.customStartup>=8) and mission.trig.customStartup or
    {      
		"for i,t in ipairs(mission.result.red.conditions) do mission.result.red.conditions[i]=loadstring(t) end", 
		"for i,t in ipairs(mission.result.blue.conditions) do mission.result.blue.conditions[i]=loadstring(t) end", 
		"for i,t in ipairs(mission.result.offline.conditions) do mission.result.offline.conditions[i]=loadstring(t) end", 
		"for i,t in ipairs(mission.result.red.actions) do mission.result.red.actions[i]=loadstring(t) end", 
		"for i,t in ipairs(mission.result.blue.actions) do mission.result.blue.actions[i]=loadstring(t) end", 
		"for i,t in ipairs(mission.result.offline.actions) do mission.result.offline.actions[i]=loadstring(t) end", 
		"for i,t in ipairs(mission.trig.conditions) do mission.trig.conditions[i]=loadstring(t) end", 
		"for i,t in ipairs(mission.trig.actions) do mission.trig.actions[i]=loadstring(t) end", 
    }
	
  um.trig.conditions = Trigger.generateTriggerConditions(mission.trigrules)
  um.trig.actions = Trigger.generateTriggerActions(mission.trigrules) 
  um.trig.func = Trigger.generateTriggerFunc2(mission.trigrules, false)
  um.trig.funcStartup = Trigger.generateTriggerFunc2(mission.trigrules, true)
  um.customtrigfunc = mission.customtrigfunc

  for i=1,#um.trigfunc do um.trigflag[i] = true; end; -- Dmut: obsolete, to be removed in A-10
  for i=1, mission.trigrules and #mission.trigrules or 0 do um.trig.flag[i] = true; end;

  --base.print(mission.descriptionText)
  if mission.triggers and mission.triggers.zones then
    um.triggers.zones = {}
    for i=1,#mission.triggers.zones do
      local z = mission.triggers.zones[i]
      local uX, uY = MapWindow.mapView:convertRadiansToMeters(z.lat, z.long)
      --base.print('unloading trigger zones', uX, uY, z.lat, z.long, z, z.name)
      local zone = {
        zoneId = z.zoneId,
        name = z.name,
        lat = z.lat,
        long = z.long,
        radius = z.radius,
        color = {z.color[1],z.color[2],z.color[3],z.color[4]},
        x = uX,
        y = uY,
        hidden = z.hidden,
      }
      base.table.insert(um.triggers.zones, zone)
    end
  end
  --       ,     .
  --     .
  for i,v in base.pairs(mission.coalition) do
    local coal = {name = v.Name, country = {}}
    um.coalition[i] = coal
    for j,u in base.pairs(v.country) do
      local cant = {id = u.id, name = base.me_db.country_by_id[u.id].OldID }
      coal.country[j] = cant
      if u.plane then
        unload_air_groups(u, 'plane', cant)
      end
      if u.helicopter then
        unload_air_groups(u, 'helicopter', cant)
      end
      if u.ship then
        unload_nonair_groups(u, 'ship', cant)
      end
      if u.vehicle then
        unload_nonair_groups(u, 'vehicle', cant)
      end
      if u.static then
        unload_static_groups(u, 'static', cant)
      end
      if u.complex then
        unload_static_groups(u, 'complex', cant)
      end
    end
  end
  return um
end

--        .
function save_mission(fName, unpacked)
    --base.U.stack();
    AutoBriefingModule.missionFileName = fName
    local mis = unload()
	--base.U.traverseTable(mis.failures)
    save(fName, mis, unpacked)
end

function saveUnpackedMission(fName, mis)
    U.saveTable(fName, 'mission', mis)
end

--    .
function save(fName, mis, unpacked)
    --mis.path = fName;
    base.assert(not unpacked)

    local tempFileName = "temp.mis"
 
    local tempOptions = base.panel_options.enforceOptions();	

    --mis.options = nil
    saveUnpackedMission(tempFileName, mis)
    zip.ZipFile(fName, tempFileName, "mission")
    U.addTableToZip(fName, "options", tempOptions)
    --mis.options = tempOptions
    base.os.remove(tempFileName)
    packMissionResources(fName)

	
  --load(fName)
    originalMission = {};
    base.U.recursiveCopyTable(originalMission, mission);
    base.print(fName, 'saved');
end

--         .
function check_group_name(name)
  local nm = name
  local num = 0
  while group_by_name[nm] do
    num = num + 1
    local idx = base.string.find(nm, ' #')
    if idx then
        nm = base.string.sub(nm, 1, idx - 1)
    end
    nm = nm..' #' .. base.string.format("%03i", num)
  end
  return nm
end

--         .
function check_unit_name(name)
  local nm = name
  if not nm then
      nm = _('Unit #1')
  end
  local num = 0
  while unit_by_name[nm] do
    num = num + 1
    local idx = base.string.find(nm, ' #')
    if idx then
        nm = base.string.sub(nm, 1, idx - 1)
    end
    nm = nm..' #' .. base.string.format("%i", num)
  end
  return nm
end


--         .
function check_target_name(name)
  local nm = name
  if not nm or nm == '' then
    return nil
  end
  if target_by_name[nm] then
    targetNameIndex = targetNameIndex+1
    nm = nm..' #'..targetNameIndex
  end
  return nm
end

function check_zone_name(name)
  local nm = name
  if not nm or nm == '' then
    zoneNameIndex = zoneNameIndex+1
    return check_zone_name("New Trigger Zone "..' #'..zoneNameIndex)
  end
  if zone_by_name[nm] then
    zoneNameIndex = zoneNameIndex+1
    nm = nm..' #'..zoneNameIndex
  end
  return nm
end

--           
--   .
--  -      .
--          ,
--      .
--  type       - plane, helicopter, ship, vehicle, static.
--  name   ,     .
--  start_time       
--    .
--  lat, long       .
function create_group(country_name, type, name, start_time, lat, long)
  --  country_name      .
  local country = missionCountry[country_name]
  if not country[type] then
    country[type] = {group = {}}
  end
  maxGroupId = maxGroupId + 1
  local coalition = countryCoalition[country_name]
  local color = coalition.color
  local nm = check_group_name(name)
  local group = 
  {
    groupId = maxGroupId,
    boss = country,
    color = color,  --         
    type = type,
    name = nm,
    start_time = 0,
    lat = lat,
    long = long,
    units = {},
    --   mapObjects    ,  ,  ,
    --      .
    --        . ,  
    --   .
    --         mapObjects.
    mapObjects = {units = {}, zones = {},},
    hidden = false;
  }
  if type == 'static' then
    group.dead = false;
  end;
  --           group_by_name
  group_by_name[group.name] = group
  group_by_id[group.groupId] = group
  --if group.type ~= 'static' then
    group.route = {boss = group, points = {},}
    group.mapObjects.route = {line = {}, points = {}, numbers = {}, targets = {}, targetNumbers = {}, targetLines = {}, targetZones = {}}
    if group.type == 'vehicle' then
      --         ,
      --        .
      group.route.spans = {}
    end
  --else
    group.heading = 0
  --end
  base.table.insert(country[type].group, group)
  base.panel_units_list.update();
  base.panel_units_list.selectRow(group);
  return group
end

-- by Blindspot
-- Duplicates given group including units, waypoints, targets and the different payloads
function duplicate_group(group)

	local groupNew = create_group(group.boss.name, group.type, check_group_name(group.name), group.start_time, group.lat+0.00001, group.long+0.00001)
--	update_group_map_objects(groupNew)

	groupNew.hidden = group.hidden
	groupNew.task = group.task
	groupNew.taskSelected = group.taskSelected
	groupNew.start_time = group.start_time
	groupNew.task = group.task
	groupNew.visible = group.visible
	
	for a=1, #group.units do
		local u = group.units[a]
		local uNew = insert_unit(groupNew, u.type, u.skill, a, check_unit_name(u.name), u.lat+0.00001, u.long+0.00001, u.heading)
		
		if u.payload then
			uNew.payload = {}
			U.copyTable(uNew.payload, u.payload)
		end
	end;
	

	if group.route then
		if group.route.points then
			for a=1, #group.route.points do
				local wp = group.route.points[a]
				local wpNew = insert_waypoint(groupNew, a, wp.type, wp.lat, wp.long, wp.alt, wp.speed, wp.name)
				wpNew.action = wp.action
				if wp.airdromeId then
					wpNew.airdromeId = wp.airdromeId
				end
				if wp.targets then
					for b=1, #wp.targets do
						local tgt = wp.targets[b]
						local tgtNew = insert_target(wpNew, b, tgt.lat, tgt.long, tgt.radius, tgt.name)
						
						if tgt.categories then
							tgtNew.categories = {}
							U.copyTable(tgtNew.categories, tgt.categories)
						end
					end
				end
			end
		end
	end
	
	if groupNew.route and groupNew.route.points and #groupNew.route.points > 0 then
		local wpt = groupNew.route.points[1]
		MapWindow.move_waypoint(wpt.boss, wpt.index, wpt.lat+0.00001, wpt.long+0.00001)
	end
	
	create_group_objects(groupNew)
	update_group_map_objects(groupNew)
	return groupNew;
end;

--         .
function remove_group(group)
    --remove linked children objects
    for i,unit in base.ipairs(group.units) do 
        if unit.linkChildren then
            local toUnlink = { }
            for _tmp, v in base.pairs(unit.linkChildren) do
                base.table.insert(toUnlink, v)
                v.type = base.panel_route.actions.turningPoint
            end
            for _tmp, v in base.pairs(toUnlink) do
                unlinkWaypoint(v)
            end
        end
    end;

    if group.route then
        -- unlink each waypoint from ths group
        for _tmp, v in base.pairs(group.route.points) do
            if v.linkUnit then
                unlinkWaypoint(v)
            end
        end
    end

  remove_group_map_objects(group)
  MapWindow.mapView:updateUserList(true)
  --          ,    .
  --    
  for i,v in base.pairs(group.boss[group.type].group) do
    if v == group then
    --base.print('removing group', group.boss[group.type].group, group.boss[group.type].group[i].name)
      base.table.remove(group.boss[group.type].group, i)
      --U.traverseTable(group_by_name[group.name])
      for uk,unit in base.pairs(group.units) do
        --base.print('removing unit ',uk ,unit, unit.name);
		if (playerUnit == unit) then
			--base.print('=============playerUnit=========================')
			base.panel_failures.reset()			 --  
			playerUnit = nil
		end
        unit_by_name[unit.name] = nil;
        unit_by_id[unit.unitId] = nil;
      end;
      group_by_name[group.name] = nil
      group_by_id[group.groupId] = nil
      base.panel_units_list.update();      
      return
    end
  end
  base.print('group not found', group, group.name);
  base.panel_units_list.update();
end

function updateUnitZones(unit)
    removeUnitZones(unit);
    createUnitZones(unit);
end; 

function removeUnitZones(unit)
    local toRemove = {};
    local group = unit.boss;
    local unitZones = unit.zones or {};
    for tmp,unitZone in base.pairs(unitZones) do --   
        mapObjects[unitZone.id] = nil; --    
        base.table.insert(toRemove, unitZone);
    end
    unit.zones = nil;
    MapWindow.mapView:removeUserObjects(toRemove)
end; 

function createUnitZones(unit)
    local group = unit.boss;
    local stencil = 1
    if group.boss.boss.name ~= 'RED' then
        stencil = 2
    end
    local zoneDescr = {
        {
        name = "DetectionRange",
        code = 532,
        },
        {
        name = "ThreatRange",
        code = 531,
        },
    };
    for tmp,descr in base.ipairs(zoneDescr) do    
        local name = descr.name;
        local code = descr.code;
        local r = 0
        local udb = base.me_db.unit_by_CLSID[unit.CLSID]
        if udb then
          if udb[name] then
            r = udb[name]/6378136.3;
          end
        end
        if r > 0 then
            local lat = unit.lat
            local long = unit.long
            currentKey = currentKey+1
            local c = group.color
            local zone = {
              type = 'SQR',
              id = currentKey,
              key = currentKey,
              classKey = 'S0000000' .. code,
              userObject = unit,
              currColor = {c[1],c[2],c[3], 0.15},
              points = {[1] = {},},
              triangles = {},
              stencil = stencil,
            }
            unit.zones = unit.zones or {};
            base.table.insert(unit.zones, zone);
            mapObjects[zone.id] = zone
            local da = base.math.pi/16
            local asp = 1/base.math.cos(lat)
            for i=1,32 do
              local p = {
                y = long+r*base.math.sin(da*i)*asp,
                x = lat+r*base.math.cos(da*i),
              }
              base.table.insert(zone.points[1], p)
            end
            base.table.insert(zone.points[1], zone.points[1][1])

            local p1 = zone.points[1][1]
            for i=3,32 do
              local t = {}
              base.table.insert(t, p1)
              base.table.insert(t, zone.points[1][i])
              base.table.insert(t, zone.points[1][i-1])
              base.table.insert(zone.triangles, t)
            end
        end
    end;
    if unit.zones and (not group.hidden) then
        MapWindow.mapView:addUserObjects(unit.zones);
    end;
end; 

--         .
--    .
function create_target_zone(target)
  if target.radius <= 0 then
    return
  end
  local r = target.radius/6378136.3
  local lat = target.lat
  local long = target.long
  currentKey = currentKey+1
  local c = target.boss.boss.boss.boss.selectGroupColor
  local zone = {
    type = 'SQR',
    id = currentKey,
    key = currentKey,
    classKey = 'S0000000530',
    userObject = target,
    currColor = {c[1],c[2],c[3], 0.00},
    points = {[1] = {},},
    triangles = {},
  }
  mapObjects[zone.id] = zone
  local da = base.math.pi/16
  local asp = 1/base.math.cos(lat)
  for i=1,32 do
    local p = {
      y = long+r*base.math.sin(da*i)*asp,
      x = lat+r*base.math.cos(da*i),
    }
    base.table.insert(zone.points[1], p)
  end
  base.table.insert(zone.points[1], zone.points[1][1])
  
  local p1 = zone.points[1][1]
  for i=3,32 do
    local t = {}
    base.table.insert(t, p1)
    base.table.insert(t, zone.points[1][i])
    base.table.insert(t, zone.points[1][i-1])
    base.table.insert(zone.triangles, t)
  end 
  base.table.insert(target.boss.boss.mapObjects.route.targetZones[target.boss.index], target.index, zone)
end

--      .
function update_target_zone(target)
    if target.boss.boss ~= MapWindow.selectedGroup then
        return;
    end
  if target.radius <= 0 then
    local zone = base.table.remove(target.boss.boss.mapObjects.route.targetZones[target.boss.index], target.index)
    if zone then
      mapObjects[target.boss.boss.mapObjects.route.targetZones[target.boss.index][target.index].id] = nil
      MapWindow.mapView:removeUserObjects({zone})
    end
    return
  end
  local r = target.radius/6378136.3
  local lat = target.lat
  local long = target.long
  local zone = target.boss.boss.mapObjects.route.targetZones[target.boss.index][target.index]
  if not zone then
    create_target_zone(target)
    zone = target.boss.boss.mapObjects.route.targetZones[target.boss.index][target.index]
  end
  local da = base.math.pi/16
  local asp = 1/base.math.cos(lat)
  for i=1,32 do
    zone.points[1][i].y = long+r*base.math.sin(da*i)*asp
    zone.points[1][i].x = lat+r*base.math.cos(da*i)
  end
  MapWindow.mapView:removeUserObjects({zone})
  MapWindow.mapView:addUserObjects({zone})
end

function create_trigger_zone(name, lat, long, radius, color, zoneId)
  local scale = MapWindow.mapView:getScale()
  local coeff = scale/100000
  local r = radius/6378136.3
  local zone = {
    zoneId = zoneId,
    name = check_zone_name(name),
    lat = lat, 
    long = long,
    radius = radius,
    color = {color[1],color[2],color[3], color[4]},
    mapObjects = {},
  }
    if not zone.zoneId then
        maxZoneId = maxZoneId + 1
        zone.zoneId = maxZoneId
    else
        if zone.zoneId > maxZoneId then
            maxZoneId = zone.zoneId
        end
    end                
    zone_by_name[zone.name] = zone;
    zone_by_id[zone.zoneId] = zone;
  if not zone.hidden then 
    create_trigger_zone_map_object(zone);
  end;
  return zone;
end

---[[
function create_trigger_zone_map_object(zone)
  local scale = MapWindow.mapView:getScale()
  local coeff = scale/100000
  local r = zone.radius/6378136.3
  currentKey = currentKey+1
  local mapZoneCenter = {
    type = 'DOT',
    id = currentKey,
    key = currentKey,
    classKey = 'P0000000529',
    userObject = zone,
    currColor = {zone.color[1],zone.color[2],zone.color[3]},
    points = {[1] = {[1] = {x = zone.lat, y = zone.long},},},
  }
  mapObjects[mapZoneCenter.id] = mapZoneCenter
  zone.mapObjects.center = mapZoneCenter
  
  currentKey = currentKey+1
  local mapZone = {
    type = 'SQR',
    id = currentKey,
    key = currentKey,
    classKey = 'S0000000528',
    userObject = zone,
    currColor = {zone.color[1],zone.color[2],zone.color[3], zone.color[4]},
    points = {[1] = {},},
    triangles = {},
    stencil = 3,
  }
  local da = base.math.pi/16
  local asp = 1/base.math.cos(zone.lat)
  for i=1,32 do
    local p = {
      y = zone.long+r*base.math.sin(da*i)*asp,
      x = zone.lat+r*base.math.cos(da*i),
    }
    base.table.insert(mapZone.points[1], p)
  end
  base.table.insert(mapZone.points[1], mapZone.points[1][1])
  
  local p1 = mapZone.points[1][1]
  for i=3,32 do
    local t = {}
    base.table.insert(t, p1)
    base.table.insert(t, mapZone.points[1][i])
    base.table.insert(t, mapZone.points[1][i-1])
    base.table.insert(mapZone.triangles, t)
  end
  
  mapObjects[mapZone.id] = mapZone
  zone.mapObjects.zone = mapZone
  
  currentKey = currentKey+1
  local mapZoneName = {
    type = 'TIT',
    id = currentKey,
    key = currentKey,
    classKey = 'T0000000524',
    userObject = zone,
    currColor = {zone.color[1],zone.color[2],zone.color[3]},
    points = {
      [1] = {
        [1] = {x=zone.lat+0.00005*coeff, y=zone.long+0.0001*coeff},
        [2] = {x=zone.lat+0.00005*coeff, y=zone.long+0.0011*coeff},
      },
    },
    title = zone.name,
    semantics = {
      [1] = {code=9, value = zone.name,},
      [2] = {code=14, value = '5',},
      [3] = {code=94, value = '301',},
    },
  }
  mapObjects[mapZoneName.id] = mapZoneName
  zone.mapObjects.name = mapZoneName
  
  MapWindow.mapView:addUserObjects({mapZoneCenter, mapZone, mapZoneName})
  MapWindow.mapView:updateUserList(true)
end
--]]

function update_trigger_zone(zone)
  if zone.radius <= 0 or zone.hidden then
    return
  end
  local r = zone.radius/6378136.3
  local lat = zone.lat
  local long = zone.long
  local z = zone.mapObjects.zone
  local da = base.math.pi/16
  local asp = 1/base.math.cos(lat)
  for i=1,32 do
    z.points[1][i].y = long+r*base.math.sin(da*i)*asp
    z.points[1][i].x = lat+r*base.math.cos(da*i)
  end
  MapWindow.mapView:removeUserObjects({z})
  MapWindow.mapView:addUserObjects({z})
  MapWindow.mapView:updateUserList(true)
end

function remove_trigger_zone(zone)
  if zone then
    zone_by_name[zone.name] = nil
    zone_by_id[zone.zoneId] = nil
    for i=1,#mission.triggers.zones do
      if mission.triggers.zones[i].name == zone.name then
        base.table.remove(mission.triggers.zones, i)
        break
      end
    end
    MapWindow.mapView:removeUserObjects(zone.mapObjects)
    MapWindow.mapView:updateUserList(true)
  end
end


-- reset chaff and flares to default values
function setDefaultChaffFlare(group)
    for _k, unit in base.pairs(group.units) do
        local unitDef = base.me_db.unit_by_name[unit.type]
        unit.payload.chaff = unitDef.ChaffDefault
        unit.payload.flare = unitDef.FlareDefault
    end
end

-------------------------------------------------------------------------------
function isEnableAircraft()
	for i,v in base.pairs(mission.coalition) do
		local coal = {name = v.Name, country = {}}
		for j,u in base.pairs(v.country) do
			---local cant = {id = u.id, name = base.me_db.country_by_id[u.id].OldID }
			--coal.country[j] = cant
			
			if u.plane then
				if (u.plane.group) then 
					if (u.plane.group[1]) then
						return true
					end
				end
			end
			if u.helicopter then
				if (u.helicopter.group) then 
					if (u.helicopter.group[1]) then
						return true
					end
				end
			end
		 
		end
	end
	return false
end

--       .
--  index      . 
function insert_unit(group, type, skill, index, name_, lat_, long_, heading_)
    --base.print('inserting unit group, type, skill, index, name_, lat_, long_, heading_', group, type, skill, index, name_, lat_, long_, heading_)
  unitNameIndex = unitNameIndex+1
  maxUnitId = maxUnitId + 1
  local unit = 
  {
    unitId = maxUnitId,
    boss = group,
    name = check_unit_name(name_),
    type = type,
    CLSID = base.me_db.unit_by_name[type].CLSID,
    skill = skill,
    index = index,
    lat = lat_ or group.lat,
    long = long_ or group.long,
    heading = heading_ or 0,
  }
  if group.type ~= 'static' then
    unit.lat = lat_ or (group.lat - 0.000007 * (index - 1))
    unit.long = long_ or (group.long + 0.000007 * (index - 1))
  else
    if _('FARP') == type then
        unit.heliport_callsign_id = base.panel_static.c_heliport.id or 1;
		unit.heliport_frequency = base.panel_static.f_heliport.text or 127.5000000;
    end;
  end
  
  
  --       .
  if group.type == 'plane' or group.type == 'helicopter' then
    local unitDef = base.me_db.unit_by_name[type]
    unit.payload = {
      fuel = unitDef.MaxFuelWeight,
      chaff = unitDef.ChaffDefault,
      flare = unitDef.FlareDefault,
      gun = 100,
      pylons = {
      },
    }
    base.panel_payload.setDefaultLivery(unit)
    -- ,           
    local vd = base.panel_aircraft.vdata;
    vd.onboard_num = vd.onboard_num + 1;
    --vd.callsign = vd.callsign + 1;
    unit.onboard_num = vd.onboard_num;
    unit.callsign = base.panel_aircraft.getNewCallsign(unit);--vd.callsign;
  end
  
  base.table.insert(group.units, unit)
  
	if (unit.skill == crutches.getPlayerSkill()) then
		Failures.change_player_plane(false)
	end
  
  unit_by_name[unit.name] = unit
  unit_by_id[unit.unitId] = unit
  insert_unit_symbol(unit)
  --    /. 
  base.panel_units_list.update();
  return unit
end

-- change name of unit
-- if unit with new name already exists, returns false and doesn't 
-- change anything
function renameUnit(unit, newName)
    if unit_by_name[newName] then
        return false
    else
        if unit.name then
            unit_by_name[unit.name] = nil
        end
        unit.name = newName
        unit_by_name[newName] = unit
        return true
    end
end


-- change name of group
-- returns false if rename is not possible (group with such name already exists)
function renameGroup(group, newName)
    if group_by_name[newName] then
        return false
    else
        group_by_name[group.name] = nil
        group.name = newName
        group_by_name[newName] = group
        return true
    end
end


-- change name of trigger zone
-- returns false if rename is not possible (group with such name already exists)
function renameZone(zone, newName)
    if zone_by_name[newName] then
        return false
    else
        zone_by_name[zone.name] = nil
        zone.name = newName
        zone_by_name[newName] = zone
        return true
    end
end



--      .
function insert_unit_symbol(unit)
  local scale = MapWindow.mapView:getScale()
  local coeff = scale/100000
  local group = unit.boss
  local u = base.me_db.unit_by_CLSID[unit.CLSID]
  local cls = base.me_db.getClassKey(u.Name)
  if not cls then
    base.print('No class key for "'..u.Name..'"')
    --  
    cls = "P0091000076"
  end
  currentKey = currentKey+1;
  local object = {
      type = "DOT",      
      id = currentKey,
      key = currentKey,
      classKey = cls,
      currColor = group.color,
      heading = 0,
      userObject = unit, --        
      subclass = 'unit',
      points = {
        { 
            {},
        },
      },
  };
  mapObjects[object.id] = object
  if not group.lat then
    group.lat = group.route.points[1].lat
    group.long = group.route.points[1].long 
  end
  if group.type == 'static' then
    object.points[1][1]["x"] = group.lat
    object.points[1][1]["y"] = group.long
  else
    object.points[1][1]["x"] = group.lat-unit.index*0.0001*coeff
    object.points[1][1]["y"] = group.long+unit.index*0.0001*coeff
    --base.print('inserting unit symbol', currentKey,  unit.index, group.lat, group.long, object.points[1][1]["x"], object.points[1][1]["y"]);
  end
  base.table.insert(group.mapObjects.units, unit.index, object)
  
  if group.type == 'ship' or group.type == 'vehicle' then
    createUnitZones(unit);
  end
 
  
  --       
  for i=unit.index+1,#group.units do
    group.units[i].index = i
  end
  --         ,
  --    -  .
  for i=unit.index,#group.mapObjects.units do
      group.mapObjects.units[i].points[1][1].x = group.units[i].lat
      group.mapObjects.units[i].points[1][1].y = group.units[i].long
  end
end

--       .
function remove_unit(unit)
  local scale = MapWindow.mapView:getScale()
  local coeff = scale/100000
  local group = unit.boss;
  remove_unit_symbol(unit)
  base.table.remove(group.units, unit.index)
  unit_by_name[unit.name] = nil 
  unit_by_id[unit.unitId] = nil 
  --        , ,
  --    /.
  for i=unit.index,#group.units do
    group.units[i].index = i
  end
end

--      .
function remove_unit_symbol(unit)
  mapObjects[unit.boss.mapObjects.units[unit.index].id] = nil
  local t = {};
  base.table.insert(t, base.table.remove(unit.boss.mapObjects.units, unit.index));
  removeUnitZones(unit)
  MapWindow.mapView:removeUserObjects(t);
end

--        .
function remove_all_units(group)
  local toRemove = {}
  for i=1,#group.units do
    local unit = remove_unit_symbol(group.units[i])
    base.table.insert(toRemove, unit)
    unit_by_name[unit.name] = nil
  end
  group.units = {}
  MapWindow.mapView:removeUserObjects(toRemove) 
end

--         .
--  index        .
function insert_waypoint(group, index, type, lat, long, alt, speed, name)
  local height = U.getAltitude(lat, long)
  if group.type == 'plane' or group.type == 'helicopter' then
    height = base.math.max(height, alt) 
  end

  local wpt =
  {
    boss = group,
    index = index,
    name = name,
    type = type,
    lat = lat,
    long = long,
    alt = height,
    speed = speed,
    targets = {},
  }
  base.table.insert(group.route.points, index, wpt)
  
  if group.type == 'vehicle' then
    local pp = group.route.points[index-1]
    if pp then
      local s = {{lat=pp.lat,long=pp.long},{lat=wpt.lat,long=wpt.long}}
      base.table.insert(group.route.spans, index-1, s)
      if index < #group.route.points then
        local np = group.route.points[index+1]
        local ns = {{lat=wpt.lat,long=wpt.long},{lat=np.lat,long=np.long}}
        group.route.spans[index] = ns
      else
        --   - .
        local ns = {{lat=wpt.lat,long=wpt.long},{lat=wpt.lat,long=wpt.long}}
        group.route.spans[index] = ns
      end
    end
  end
  
  local symbol = create_waypoint_symbol(wpt)
  base.table.insert(group.mapObjects.route.points, wpt.index, symbol)
  local text = create_waypoint_text(wpt)
  base.table.insert(group.mapObjects.route.numbers, wpt.index, text)
  --    
  base.table.insert(group.mapObjects.route.targets, wpt.index, {})
  base.table.insert(group.mapObjects.route.targetLines, wpt.index, {})
  base.table.insert(group.mapObjects.route.targetNumbers, wpt.index, {})
  base.table.insert(group.mapObjects.route.targetZones, wpt.index, {})
  
  --      .
  for i=wpt.index+1,#group.route.points do
    local wpnt = group.route.points[i];
    wpnt.index = i
    -- for j,target in base.ipairs(wpnt.targets or {}) do 
        -- target.index = i;
    -- end    
  end
  
  build_route_line(group)
  
  for i=wpt.index+1,#group.mapObjects.route.numbers do
    local name = base.tostring(i)
    if group.route.points[i].name then
      name = name..':'..group.route.points[i].name
    end
    group.mapObjects.route.numbers[i].title = name
    for j,u in base.pairs(group.mapObjects.route.numbers[i].semantics) do
      if u.code == 9 then
        u.value = name
        break
      end
    end
  end 
  
  
  calc_route_length(group)
  base.panel_summary.update()
  if 'vehicle' == group.type then 
    base.panel_vehicle.updateHeading()
  elseif 'ship' == group.type then
    base.panel_ship.updateHeading()
  end;
  return wpt
end

function insert_INUFixPoint(group, lat, long, alt, color, x, y)
  group.INUFixPoints = group.INUFixPoints or {};
  local INUFixPoint =
  {
    boss = group,
    lat = lat,
    long = long,
    alt = alt,
    index = index,
    color = color,
    x = x,
    y = y,
  }
  base.table.insert(group.INUFixPoints, INUFixPoint)
  local symbol = create_INUFixPoint_symbol(INUFixPoint)
  symbol.currColor = group.boss.boss.selectWaypointColor;
  group.mapObjects.INUFixPoints = group.mapObjects.INUFixPoints or {};
  for i,object in base.ipairs(group.mapObjects.INUFixPoints) do 
    object.currColor = group.boss.boss.selectGroupColor;
  end
  base.table.insert(group.mapObjects.INUFixPoints, symbol)
  INUFixPoint.symbol = symbol;

  group.mapObjects.INUFixPoints_numbers = group.mapObjects.INUFixPoints_numbers or {}; 
  INUFixPoint.index = #group.INUFixPoints or 1;
  local text = create_INUFixPoint_text(INUFixPoint)
  text.currColor = group.boss.boss.selectWaypointColor;
  for i,object in base.ipairs(group.mapObjects.INUFixPoints_numbers) do 
    object.currColor = group.boss.boss.selectGroupColor;
  end
  base.table.insert(group.mapObjects.INUFixPoints_numbers, text)
  INUFixPoint.text = text;
  return INUFixPoint
end

--    . 
function set_waypoint_name(wpt, name)
  local group = wpt.boss
  local nm = name
  wpt.name = nm
  local obj = group.mapObjects.route.numbers[wpt.index]
  local title = base.tostring(wpt.index)
  if nm then
    title = title..':'..nm
  end 
  obj.title = title
  for j,u in base.pairs(obj.semantics) do
    if u.code == 9 then
      u.value = title
      break
    end
  end
  MapWindow.mapView:removeUserObjects({obj})
  MapWindow.mapView:addUserObjects({obj})
  MapWindow.mapView:updateUserList(true)
end

--   .
function set_target_name(target, name)
  if target.name then
    target_by_name[target.name] = nil
  end
  local wpt = target.boss
  local group = wpt.boss
  local nm = check_target_name(name)
  target.name = nm
  local obj = group.mapObjects.route.targetNumbers[wpt.index][target.index]
  local title = base.tostring(target.index)
  if nm then
    title = title..':'..nm
  end 
  obj.title = title
  for j,u in base.pairs(obj.semantics) do
    if u.code == 9 then
      u.value = title
      break
    end
  end
  MapWindow.mapView:removeUserObjects({obj})
  MapWindow.mapView:addUserObjects({obj})
  MapWindow.mapView:updateUserList(true)
end

--       .
function move_waypoint_to_road(wpt)
--  base.print('Roads.FindNearestPoint. lat, long:', wpt.lat, wpt.long)
  local lat, long = Roads.FindNearestPoint(wpt.lat, wpt.long, 40000.0)
--  base.print('Result. lat, long:', lat, long)
--  base.collectgarbage('collect')
  if lat then
    MapWindow.move_waypoint(wpt.boss, wpt.index, lat, long)
  end
  local points = wpt.boss.route.points
  if wpt.index > 1 and points[wpt.index-1].type.action == 'On Road' then
    local len, path = Roads.FindOptimalPath(points[wpt.index-1].lat, points[wpt.index-1].long, lat, long)
    if path and #path > 0 then
      wpt.boss.mapObjects.route.line.points[wpt.index-1] = path
      local s = {}
      for i=1,#path do
        base.table.insert(s, {lat=path[i].x, long=path[i].y})
      end
      wpt.boss.route.spans[wpt.index-1] = s
      MapWindow.mapView:removeUserObjects({wpt.boss.mapObjects.route.line})
      MapWindow.mapView:addUserObjects({wpt.boss.mapObjects.route.line})
      MapWindow.mapView:updateUserList(true)
    end
  end
  if wpt.index < #points and points[wpt.index+1].type.action == 'On Road' then
    local len, path = Roads.FindOptimalPath(lat, long, points[wpt.index+1].lat, points[wpt.index+1].long)
    if path and #path > 0 then
      wpt.boss.mapObjects.route.line.points[wpt.index] = path
      local s = {}
      for i=1,#path do
        base.table.insert(s, {lat=path[i].x, long=path[i].y})
      end
      wpt.boss.route.spans[wpt.index] = s
      MapWindow.mapView:removeUserObjects({wpt.boss.mapObjects.route.line})
      MapWindow.mapView:addUserObjects({wpt.boss.mapObjects.route.line})
      MapWindow.mapView:updateUserList(true)
    end
  end
  calc_route_length(wpt.boss)
  base.panel_summary.update()
end

function move_unit_to_road(unit)
--  base.print('Roads.FindNearestPoint. lat, long:', wpt.lat, wpt.long)
  local lat, long = Roads.FindNearestPoint(unit.lat, unit.long, 40000.0)
--  base.print('Result. lat, long:', lat, long)
--  base.collectgarbage('collect')
  if lat then
    MapWindow.move_unit(unit.boss, unit, lat, long)
    MapWindow.zoomIn();
    MapWindow.zoomOut();
  end
end

--     .
function make_waypoint_offroad(wpt)
    if wpt.boss.type == 'vehicle' then
  --       
  local points = wpt.boss.route.points
  if wpt.index > 1 then
    local p = points[wpt.index-1]
    wpt.boss.route.spans[wpt.index-1] = {{lat=p.lat, long=p.long}, {lat=wpt.lat, long=wpt.long}}
    wpt.boss.mapObjects.route.line.points[wpt.index-1] = {{x=p.lat, y=p.long}, {x=wpt.lat, y=wpt.long}}
    MapWindow.mapView:removeUserObjects({wpt.boss.mapObjects.route.line})
    MapWindow.mapView:addUserObjects({wpt.boss.mapObjects.route.line})
  end
  if wpt.index < #points then
    local p = points[wpt.index+1]
    wpt.boss.route.spans[wpt.index] = {{lat=wpt.lat, long=wpt.long}, {lat=p.lat, long=p.long}}
    wpt.boss.mapObjects.route.line.points[wpt.index] = {{x=wpt.lat, y=wpt.long}, {x=p.lat, y=p.long}}
    MapWindow.mapView:removeUserObjects({wpt.boss.mapObjects.route.line})
    MapWindow.mapView:addUserObjects({wpt.boss.mapObjects.route.line})
  end
  end
  calc_route_length(wpt.boss)
  base.panel_summary.update()
end


-- rebuild road route
function updateRoadRouteSegment(group, index)
  local wpt = group.route.points[index]
  if ('On Road' == wpt.type.action) then
      move_waypoint_to_road(wpt);
  end
end

--    .
function remove_waypoint(group, index)
  local wpt = group.route.points[index]
  if wpt.linkUnit then
    unlinkWaypoint(wpt)
  end
  local toRemove = {}
--  remove_route_line_point(wpt)
  base.table.insert(toRemove, group.mapObjects.route.line)
  if wpt.targets then
      while wpt.targets and (0 < #wpt.targets) do
          remove_target(wpt.targets[1], true)
      end
  end

  local ws = remove_waypoint_symbol(wpt)
  base.table.insert(toRemove, ws)
  local wt = remove_waypoint_text(wpt)
  base.table.insert(toRemove, wt)
  if group.route.spans then
    local spans = group.route.spans
    if index < #spans then
        local spanBefore = spans[index - 1]
        local pointBefore = spanBefore[#spanBefore]
        local pointAfter = spans[index + 1][1]
        pointBefore.lat = pointAfter.lat
        pointBefore.long = pointAfter.long
    end
    base.table.remove(spans, index)
  end

  base.table.remove(group.route.points, index)
  base.table.remove(group.mapObjects.route.targets, index)
  base.table.remove(group.mapObjects.route.targetLines, index)
  base.table.remove(group.mapObjects.route.targetNumbers, index)
  base.table.remove(group.mapObjects.route.targetZones, index)
  
  --      .
  --    group.mapObjects.route.targets[wptIdx]
  
  for i=1,#group.route.points do
    group.route.points[i].index = i
    group.mapObjects.route.numbers[i].title = base.tostring(i)
    for j,u in base.pairs(group.mapObjects.route.numbers[i].semantics) do
      if u.code == 9 then
        u.value = base.tostring(i)
        break
      end
    end
  end
  build_route_line(group)

    base.panel_route.vdata.wpt = group.route.points[index]
    if (index < 0) or (index > #group.route.points) then
        index = #group.route.points;
    end;
    
    base.panel_route.vdata.wpt = group.route.points[index]
    if (#group.units > 1) then 
        if (index ~= 1) then
            group.mapObjects.route.points[index].currColor = group.boss.boss.selectWaypointColor
        end;
    else
        group.mapObjects.route.points[index].currColor = group.boss.boss.selectWaypointColor
    end;
    group.mapObjects.route.numbers[index].currColor = group.boss.boss.selectWaypointColor
    group.mapObjects.route.line.currColor = group.boss.boss.selectGroupColor
  
  MapWindow.mapView:removeUserObjects(toRemove) 
  update_group_map_objects(group)

  if 1 < index then
      updateRoadRouteSegment(group, index - 1)
  end
  if #group.route.points >= index then
      updateRoadRouteSegment(group, index)
  end

  calc_route_length(group)
  base.panel_summary.update()
  if 'vehicle' == group.type then 
    base.panel_vehicle.updateHeading()
  elseif 'ship' == group.type then
    base.panel_ship.updateHeading()
  end;
  
end

function remove_INUFixPoint(group, index)
  local pt = group.INUFixPoints[index];
  local toRemove = {}
  local ws = remove_INUFixPoint_symbol(pt)
  base.table.insert(toRemove, ws)
  local wt = remove_INUFixPoint_text(pt)
  base.table.insert(toRemove, wt)
  base.table.remove(group.INUFixPoints, index)
  --      .
  for i=1,#group.INUFixPoints do
    group.INUFixPoints[i].index = i
    group.mapObjects.INUFixPoints_numbers[i].title = base.tostring(i)
    for j,u in base.pairs(group.mapObjects.INUFixPoints_numbers[i].semantics) do
      if u.code == 9 then
        u.value = base.tostring(i)
        break
      end
    end
  end
  base.panel_fix_points.vdata.selectedPoint = nil;
  base.panel_fix_points.update()
  MapWindow.mapView:removeUserObjects(toRemove) 
  update_group_map_objects(group)

end

--          .
--  wpt -        .
function remove_route_line_point(wpt)
  local points = wpt.boss.mapObjects.route.line.points
  if wpt.index == #points then
    --   ,     .
    local x = points[wpt.index-1][1].x
    local y = points[wpt.index-1][1].y
    points[wpt.index-1] = {{x=x,y=y},{x=x,y=y}}
  else
    --         .
    local x1 = points[wpt.index-1][1].x
    local y1 = points[wpt.index-1][1].y
    local x2 = points[wpt.index+1][1].x
    local y2 = points[wpt.index+1][1].y
    points[wpt.index-1] = {{x=x1,y=y1},{x=x2,y=y2}}
  end
  --   
  base.table.remove(points, wpt.index)
end

--       .
--  wpt -        .
function create_waypoint_symbol(wpt)
  local group = wpt.boss
  currentKey = currentKey+1
  --base.print('Waypoint', currentKey, wpt.lat, wpt.long);
  local object = {
    type = "DOT",
    id = currentKey,
    key = currentKey,
    waypoint = true,
    currColor = group.color,
    userObject = wpt,
    points = {
        { 
            {
                x = wpt.lat,
                y = wpt.long,            
            },
        },
    },
  };
  if 1 == wpt.index then
      local u = base.me_db.unit_by_CLSID[group.units[1].CLSID]
      local cls = base.me_db.getClassKey(u.Name)
      object.classKey = cls  --   
  else
      object.classKey = "P0091000041"  --   
  end
  mapObjects[object.id] = object
  return object 
end

function create_INUFixPoint_symbol(pt)
  local group = pt.boss
  currentKey = currentKey+1
  --base.print('INUpoint', currentKey, pt.lat, pt.long)
  local object = {
    type = "DOT",
    id = currentKey,
    key = currentKey,
    classKey = "P0091000206",
    objectcurrColor = group.color,
    userObject = pt,
    currColor = group.color,    
    points = {
            {
                {x = pt.lat, y = pt.long},
            },
        },
    }
  mapObjects[object.id] = object
  return object 
end

--        .
function remove_waypoint_symbol(wpt)
  mapObjects[wpt.boss.mapObjects.route.points[wpt.index].id] = nil
  return base.table.remove(wpt.boss.mapObjects.route.points, wpt.index)
end

function remove_INUFixPoint_symbol(pt)
  mapObjects[pt.boss.mapObjects.INUFixPoints[pt.index].id] = nil
  return base.table.remove(pt.boss.mapObjects.INUFixPoints, pt.index)
end

--       .
function remove_target_symbol(target)
    local wpt = target.boss;
    local targets = target.boss.boss.mapObjects.route.targets[wpt.index]
    local o = targets[target.index]
    if o then
        mapObjects[o.id] = nil
    end
    return base.table.remove(targets, target.index)
end

--       .
function remove_target_line(target)
    local wpt = target.boss;
    local lines = target.boss.boss.mapObjects.route.targetLines[wpt.index]
    local line = lines[target.index];
    mapObjects[line.id] = nil
    return base.table.remove(lines, target.index)
end

--       .
function remove_target_text(target)
    local wpt = target.boss;
    local targetNumbers = target.boss.boss.mapObjects.route.targetNumbers[wpt.index];
    local targetNumber = targetNumbers[target.index];  
    mapObjects[targetNumber.id] = nil
    return base.table.remove(targetNumbers, target.index)
end

--       .
function remove_target_zone(target)
    local wpt = target.boss;
    local zones = target.boss.boss.mapObjects.route.targetZones[wpt.index];
    local zone = zones[target.index];
    mapObjects[zone.id] = nil;
   return base.table.remove(zones, target.index);
end

--        .
--  wpt -        .
function create_waypoint_text(wpt)
  local scale = MapWindow.mapView:getScale()
  local coeff = scale/100000
  local group = wpt.boss
  local name = base.tostring(wpt.index)
  if wpt.name then
    name = name..':'..wpt.name
  end
  local text = {}
  text["type"] = "TIT"
  currentKey = currentKey+1
--  base.print('Number', currentKey)
  text["id"] = currentKey
  text["key"] = currentKey
  text["classKey"] = "T0000000524"
  text["currColor"] = group.color
  text["userObject"] = wpt  --          
  text["points"] = {}
  text["points"][1] = {}
  text["points"][1][1] = {}
  text["points"][1][1]["x"] = wpt.lat+0.00005*coeff
  text["points"][1][1]["y"] = wpt.long+0.00005*coeff
  text["points"][1][2] = {}
  text["points"][1][2]["x"] = wpt.lat+0.00005*coeff
  text["points"][1][2]["y"] = wpt.long+0.00105*coeff
  text["title"] = name
  text["semantics"] = {}
  text["semantics"][1] = {}
  text["semantics"][1]["value"] = name
  text["semantics"][1]["code"] = 9
  text["semantics"][2] = {}
  text["semantics"][2]["value"] = "5"
  text["semantics"][2]["code"] = 14
  text["semantics"][3] = {}
  text["semantics"][3]["value"] = "301"
  text["semantics"][3]["code"] = 94
  mapObjects[text.id] = text
  return text
end

function create_INUFixPoint_text(pt)
  local scale = MapWindow.mapView:getScale()
  local coeff = scale/100000
  local group = pt.boss
  local name = base.tostring(pt.index)
  if pt.name then
    name = name..':'..pt.name
  end
  local text = {}
  text["type"] = "TIT"
  currentKey = currentKey+1
--  base.print('Number', currentKey)
  text["id"] = currentKey
  text["key"] = currentKey
  text["classKey"] = "T0000000524"
  text["currColor"] = group.color
  text["userObject"] = pt  --          
  text["points"] = {}
  text["points"][1] = {}
  text["points"][1][1] = {}
  text["points"][1][1]["x"] = pt.lat+0.00005*coeff
  text["points"][1][1]["y"] = pt.long+0.00005*coeff
  text["points"][1][2] = {}
  text["points"][1][2]["x"] = pt.lat+0.00005*coeff
  text["points"][1][2]["y"] = pt.long+0.00105*coeff
  text["title"] = name
  text["semantics"] = {}
  text["semantics"][1] = {}
  text["semantics"][1]["value"] = name
  text["semantics"][1]["code"] = 9
  text["semantics"][2] = {}
  text["semantics"][2]["value"] = "5"
  text["semantics"][2]["code"] = 14
  text["semantics"][3] = {}
  text["semantics"][3]["value"] = "301"
  text["semantics"][3]["code"] = 94
  mapObjects[text.id] = text
  return text
end

--        .
function remove_waypoint_text(wpt)
  mapObjects[wpt.boss.mapObjects.route.numbers[wpt.index].id] = nil
  return base.table.remove(wpt.boss.mapObjects.route.numbers, wpt.index)
end

function remove_INUFixPoint_text(pt)
  mapObjects[pt.boss.mapObjects.INUFixPoints_numbers[pt.index].id] = nil
  return base.table.remove(pt.boss.mapObjects.INUFixPoints_numbers, pt.index)
end

--         .
function insert_target(wpt, index, lat, long, radius, name)
  local group = wpt.boss
  local target = {
    boss = wpt,
    index = index,
    name = name,
    lat = lat,
    long = long,
    radius = radius,    --     
    categories = {},  --    
  }
  if not wpt.targets then
    wpt.targets = {}
  end
  base.table.insert(wpt.targets, index, target)
  if not group.mapObjects.route.targets then
    group.mapObjects.route.targets = {}
  end 
  if not group.mapObjects.route.targets[wpt.index] then
    group.mapObjects.route.targets[wpt.index] = {}
    group.mapObjects.route.targetLines[wpt.index] = {}
    group.mapObjects.route.targetNumbers[wpt.index] = {}
    group.mapObjects.route.targetZones[wpt.index] = {}
  end
  create_target_zone(target)
  local line = create_target_line(target)
  base.table.insert(group.mapObjects.route.targetLines[wpt.index], target.index, line)
  local symbol = create_target_symbol(target)
  base.table.insert(group.mapObjects.route.targets[wpt.index], target.index, symbol)
  local text = create_target_text(target)
  base.table.insert(group.mapObjects.route.targetNumbers[wpt.index], target.index, text)
  --     . 
  for i=target.index+1,#wpt.targets do
    wpt.targets[i].index = i
  end
  for i=target.index+1,#group.mapObjects.route.targetNumbers[wpt.index] do
    local title = base.tostring(i)
    local name = group.route.points[i].name
    if name then
      title = title..':'..name
    end
    group.mapObjects.route.targetNumbers[wpt.index][i].title = title
    for j,u in base.pairs(group.mapObjects.route.targetNumbers[wpt.index][i].semantics) do
      if u.code == 9 then
        u.value = title
        break
      end
    end
  end 
  return target
end

--        .
function remove_target(target, doNotUpdateMap)
  --  , ,      .
  if target.name then
    target_by_name[target.name] = nil
  end
  local toRemove = {}
  local ts = remove_target_symbol(target)
  base.table.insert(toRemove, ts)
  local tt = remove_target_text(target)
  base.table.insert(toRemove, tt)
  local tz = remove_target_zone(target)
  base.table.insert(toRemove, tz)
  local tl = remove_target_line(target)
  base.table.insert(toRemove, tl)
  MapWindow.mapView:removeUserObjects(toRemove)
  --       .
  base.table.remove(target.boss.targets, target.index)
  --    .
  for i=target.index,#target.boss.targets do
    target.boss.targets[i].index = i  
  end
    
    -- local route = group.mapObjects.route;
    -- route.targets[wptIdx][target.index].currColor = waypointColor
    -- route.targetLines[wptIdx][target.index].currColor = waypointColor
    -- route.targetNumbers[wptIdx][target.index].currColor = waypointColor

  --      .
  local numbers = target.boss.boss.mapObjects.route.targetNumbers[target.boss.index]
  for i=target.index,#numbers do
    numbers[i].title = base.tostring(i) 
    for j,u in base.pairs(numbers[i].semantics) do
      if u.code == 9 then
        u.value = base.tostring(i)
        break
      end
    end
  end
  if not doNotUpdateMap then
    MapWindow.mapView:removeUserObjects(numbers)
    MapWindow.mapView:addUserObjects(numbers)
    MapWindow.mapView:updateUserList(true)
  end
end

--         .
function create_target_line(target)
  local wpt = target.boss
  local group = wpt.boss
  currentKey = currentKey+1
  local object = {
    type = 'LIN',
    id = currentKey,
    key = currentKey,
    classKey = 'L0091000301',
    currColor = group.color,
    userObject = target,
    points = {
      [1] = {
        [1] = {
          x = wpt.lat,
          y = wpt.long,
        },
        [2] = {
          x = target.lat,
          y = target.long,
        },
      },
    },
  }
  mapObjects[object.id] = object
  return object
end

--      .
function create_target_symbol(target)
  local wpt = target.boss
  local group = wpt.boss
  local object = {}
  object["type"] = "DOT"
  currentKey = currentKey+1
  object["id"] = currentKey
  object["key"] = currentKey
  object["classKey"] = "P0091000044"  --  
  object["currColor"] = group.color 
  object["userObject"] = target 
  object["points"] = {}
  object["points"][1] = {}
  object["points"][1][1] = {}
  object["points"][1][1]["x"] = target.lat
  object["points"][1][1]["y"] = target.long
  mapObjects[object.id] = object
  return object 
end

--      .
function create_target_text(target)
  local scale = MapWindow.mapView:getScale()
  local coeff = scale/100000
  local wpt = target.boss
  local group = wpt.boss
  local text = {}
  text["type"] = "TIT"
  currentKey = currentKey+1
  text["id"] = currentKey
  text["key"] = currentKey
  text["classKey"] = "T0000000524"
  text["currColor"] = group.color
  text["userObject"] = target --          
  text["points"] = {}
  text["points"][1] = {}
  text["points"][1][1] = {}
  text["points"][1][1]["x"] = target.lat+0.00005*coeff
  text["points"][1][1]["y"] = target.long+0.00005*coeff
  text["points"][1][2] = {}
  text["points"][1][2]["x"] = target.lat+0.00005*coeff
  text["points"][1][2]["y"] = target.long+0.00105*coeff
  local title = base.tostring(target.index)
  if target.name then
    title = title..':'..target.name
  end
  text["title"] = title
  text["semantics"] = {}
  text["semantics"][1] = {}
  text["semantics"][1]["value"] = title
  text["semantics"][1]["code"] = 9
  text["semantics"][2] = {}
  text["semantics"][2]["value"] = "5"
  text["semantics"][2]["code"] = 14
  text["semantics"][3] = {}
  text["semantics"][3]["value"] = "301"
  text["semantics"][3]["code"] = 94
  mapObjects[text.id] = text
  return text
end

--     .
function build_route_line(group)
  local line = group.mapObjects.route.line
  if not line.type then   
    line["type"] = "LIN"
    currentKey = currentKey+1
--    base.print('Line', currentKey)
    line["id"] = currentKey
    line["key"] = currentKey
    line["classKey"] = "L0093000000"
    line["currColor"] = group.color 
    line["userObject"] = group.route  --        
    mapObjects[line.id] = line
  end
  line["points"] = {} 
  if group.route.spans and #group.route.spans > 0 then
    for i=1,#group.route.spans-1 do
      local span = group.route.spans[i]
      local pts = {}
      base.table.insert(line.points, pts)
      for j=1,#span do
        local p = {x=span[j].lat, y=span[j].long}
        base.table.insert(pts, p)
      end 
    end
  else  
    for i=1,#group.route.points-1 do
      local wpt = group.route.points[i]
      local wptn = group.route.points[i+1]
      base.table.insert(line.points, wpt.index, {{x=wpt.lat, y=wpt.long}, {x=wptn.lat, y=wptn.long}})
    end
  end
  calc_route_length(group)
end

function calc_route_length(group)
  local dist = 0
  local len = {}
  if group.route.spans and #group.route.spans > 0 then
    for i=1,#group.route.spans do
      len[i] = 0
      local span = group.route.spans[i]
      for j=1,#span do
        if j < #span then
          local x1,z1 = Roads.xz(span[j].lat, span[j].long)
          local x2,z2 = Roads.xz(span[j+1].lat, span[j+1].long)
          local d = base.math.sqrt((x2-x1)*(x2-x1)+(z2-z1)*(z2-z1))
          len[i] = len[i] + d
          dist = dist + d
        end
      end 
    end
  else  
    for i=1,#group.route.points do
      len[i] = 0
      local wpt = group.route.points[i]
      if i < #group.route.points then
        local wptn = group.route.points[i+1]
        local x1,z1 = Roads.xz(wpt.lat, wpt.long)
        local x2,z2 = Roads.xz(wptn.lat, wptn.long)
        local d = base.math.sqrt((x2-x1)*(x2-x1)+(z2-z1)*(z2-z1))
        len[i] = d
        dist = dist + d
      end
    end
  end
  group.route.dist = dist
  group.route.len = len
  calc_route_range(group)
  if base.panel_summary.group == group then
    base.panel_summary.update()
  end
end

function calc_route_range(group)
  local range = 0
  local pts = {}
  for i=1,#group.route.points do
    local wpt = group.route.points[i]
    local x,z = Roads.xz(wpt.lat, wpt.long)
    base.table.insert(pts, {x=x,z=z})
  end 
  for i=1,#pts-1 do
    local p1 = pts[i]
    for j=i+1,#pts do
      local p2 = pts[j]
      local r2 = (p2.x-p1.x)*(p2.x-p1.x)+(p2.z-p1.z)*(p2.z-p1.z)
      if r2 > range then
        range = r2
      end
    end
  end
  group.route.range = base.math.sqrt(range)
end

--          ,
--       .
function create_group_objects(group)
    if group.route then
        group.route.boss = group
        if group.route.points and #group.route.points and group.route.points[1] then
            group.lat = group.route.points[1].lat
            group.long = group.route.points[1].long
            for i=1,#group.route.points do
                local wpt = group.route.points[i]
                wpt.boss = group
                wpt.index = i
                --      insert_route_line_point(wpt)
                if wpt.targets then
                    local targets = wpt.targets
                    for j=1,#targets do
                        local target = targets[j]
                        if target.name then
                            target_by_name[target.name] = target
                        end
                        target.boss = wpt
                        target.index = j
                    end
                end     
            end
            base.panel_summary.update()
        end
        for i=1,#group.units do
            local unit = group.units[i]
            if unit.name then
                unit_by_name[unit.name] = unit
            end
            unit.boss = group
            unit.index = i
        end
    else
        local unit = group.units[1]
        if unit.name then
            unit_by_name[unit.name] = unit
        end
        unit.boss = group
        unit.lat = group.lat
        unit.long = group.long
        unit.index = 1
    end
 
end

function create_group_map_objects(group)
    --base.print('create_group_map_objects',group.name);
  group.mapObjects = {units = {}, zones = {},}
  if group.route then
    group.mapObjects.route = {line = {}, points = {}, numbers = {}, targets = {}, targetLines = {}, targetNumbers = {}, targetZones = {},}
    if group.route.points and #group.route.points and group.route.points[1] then
      for i=1,#group.route.points do
        local wpt = group.route.points[i]
        local symbol = create_waypoint_symbol(wpt)
        base.table.insert(group.mapObjects.route.points, wpt.index, symbol)
        local text = create_waypoint_text(wpt)
        base.table.insert(group.mapObjects.route.numbers, wpt.index, text)      
        if wpt.targets and (#wpt.targets > 0) then
          local targets = wpt.targets
          for j=1,#targets do
            local target = targets[j]
            if not group.mapObjects.route.targets[i] then
              group.mapObjects.route.targets[i] = {}
              group.mapObjects.route.targetLines[i] = {}
              group.mapObjects.route.targetNumbers[i] = {}
              group.mapObjects.route.targetZones[i] = {}
            end
            if target.radius > 0 then
              create_target_zone(target)
            end
            local line = create_target_line(target)
            base.table.insert(group.mapObjects.route.targetLines[i], target.index, line)
            local symbol = create_target_symbol(target)
            base.table.insert(group.mapObjects.route.targets[i], target.index, symbol)
            local text = create_target_text(target)
            base.table.insert(group.mapObjects.route.targetNumbers[i], target.index, text)
          end
        else
          group.mapObjects.route.targets[wpt.index] = {}
          group.mapObjects.route.targetLines[wpt.index] = {}
          group.mapObjects.route.targetNumbers[wpt.index] = {}
          group.mapObjects.route.targetZones[wpt.index] = {}        
        end
      end
      build_route_line(group)
      calc_route_length(group)
      base.panel_summary.update()
    end
    for i=1,#group.units do
      local unit = group.units[i]
      insert_unit_symbol(unit)
    end
  else 
    local unit = group.units[1]
    insert_unit_symbol(unit)  
  end
  
  if group.INUFixPoints then
    group.mapObjects.INUFixPoints = {};
    for i = 1, #group.INUFixPoints do
        local INUFixPoint = group.INUFixPoints[i];
        local symbol = create_INUFixPoint_symbol(INUFixPoint)        
        INUFixPoint.symbol = symbol;
        base.table.insert(group.mapObjects.INUFixPoints, symbol)

        group.mapObjects.INUFixPoints_numbers = group.mapObjects.INUFixPoints_numbers or {}; 
        INUFixPoint.index = i;
        local text = create_INUFixPoint_text(INUFixPoint)
        INUFixPoint.text = text;
        base.table.insert(group.mapObjects.INUFixPoints_numbers, text)
    end;
  end;
  update_group_map_objects(group)
end

--      ,  
--    -    -   .
function scale_mission_map_objects(scale)
  local objects = {}
  local removeObjects = {}
  for i,v in base.pairs(mission.coalition) do
    for j,u in base.pairs(v.country) do
      if u.plane then
        for k,w in base.pairs(u.plane.group) do
          scale_group_map_objects(w, scale, objects, removeObjects)
        end
      end
      if u.helicopter then
        for k,w in base.pairs(u.helicopter.group) do
          scale_group_map_objects(w, scale, objects, removeObjects)
        end
      end
      if u.ship then
        for k,w in base.pairs(u.ship.group) do
          scale_group_map_objects(w, scale, objects, removeObjects)
        end
      end
      if u.vehicle then
        for k,w in base.pairs(u.vehicle.group) do
          scale_group_map_objects(w, scale, objects, removeObjects)
        end
      end
    end
  end
  local coeff = scale/100000
  if mission.triggers then
    if mission.triggers.zones then
      local zz = mission.triggers.zones
      for i=1,#zz do
        local z = zz[i]
        if z.mapObjects and (not z.hidden) then
          local nm = z.mapObjects.name
          nm.points[1][1]["x"] = z.lat+0.00005*coeff
          nm.points[1][1]["y"] = z.long+0.0001*coeff
          nm.points[1][2]["x"] = z.lat+0.00005*coeff
          nm.points[1][2]["y"] = z.long+0.0011*coeff
          base.table.insert(objects, nm)
        end
      end
    end
  end
  MapWindow.mapView:removeUserObjects(removeObjects)
  MapWindow.mapView:removeUserObjects(objects)
  MapWindow.mapView:addUserObjects(objects)
  MapWindow.mapView:updateUserList(true)
end

--          -
--        .
function scale_group_map_objects(group, scale, objects, toRemove)
  local coeff = scale/100000
  if group.hidden then
    return;
  end;
  local units = group.mapObjects.units
  --     
  for i=2,#units do --      ,..  -     
    local r = false; --   
    local unit = group.units[i];
    local udb = base.me_db.unit_by_CLSID[unit.CLSID]
    if udb then
        if (udb.DetectionRange and (udb.DetectionRange > 0)) 
            or (udb.ThreatRange and (udb.ThreatRange > 0)) then
            r = true;  -- -  
        end
    end
    if r then --  ,      
        base.table.insert(objects, units[i])
    else --  ,   -  
      if UNITS_SCALE >= scale then
          base.table.insert(objects, units[i])
      else
          base.table.insert(toRemove, units[i])
      end
    end;
  end
  if group.mapObjects.route then
    local nums = group.mapObjects.route.numbers
    for i=1,#nums do
      local num = nums[i]
      local wpt = group.route.points[i]
      --    
      num.points[1][1]["x"] = wpt.lat+0.00005*coeff
      num.points[1][1]["y"] = wpt.long+0.00005*coeff
      num.points[1][2]["x"] = wpt.lat+0.00005*coeff
      num.points[1][2]["y"] = wpt.long+0.00105*coeff
      base.table.insert(objects, num)
      local targets = wpt.targets
      if targets and (group == MapWindow.selectedGroup)then
        local tnums = group.mapObjects.route.targetNumbers[i]
        if tnums then
          for j=1,#tnums do
            local tnum = tnums[j]
            local target = targets[j]
            --   
            tnum.points[1][1]["x"] = target.lat+0.00005*coeff
            tnum.points[1][1]["y"] = target.long+0.00005*coeff
            tnum.points[1][2]["x"] = target.lat+0.00005*coeff
            tnum.points[1][2]["y"] = target.long+0.00105*coeff
            base.table.insert(objects, tnum)
          end
        end
      end
    end
  end
  
  if group.mapObjects.INUFixPoints_numbers and (group == MapWindow.selectedGroup) then
    local nums = group.mapObjects.INUFixPoints_numbers
    for i=1,#nums do
      local num = nums[i]
      local pt = num.userObject;
      --    
      num.points[1][1]["x"] = pt.lat+0.00005*coeff
      num.points[1][1]["y"] = pt.long+0.00005*coeff
      num.points[1][2]["x"] = pt.lat+0.00005*coeff
      num.points[1][2]["y"] = pt.long+0.00105*coeff
      base.table.insert(objects, num)
    end
  end
end


--         ,
--      .
function remove_group_map_objects(group)
  --      .
  local objects = {}
  for i,v in base.pairs(group.mapObjects.units) do
    --base.print('removing from map',v.userObject.name)
    base.table.insert(objects, v)
  end
  --     ,     
  --group.mapObjects.units = {}
  if group.mapObjects.route then
    base.table.insert(objects, group.mapObjects.route.line)
    for i,v in base.pairs(group.mapObjects.route.points) do
      base.table.insert(objects, v)
    end
    for i,v in base.pairs(group.mapObjects.route.numbers) do
      base.table.insert(objects, v)
    end
    for i,v in base.pairs(group.mapObjects.route.targets) do
      for j,u in base.pairs(v) do
--        base.print(u.key)
        base.table.insert(objects, u)
      end
    end
    for i,v in base.pairs(group.mapObjects.route.targetLines) do
      for j,u in base.pairs(v) do
--        base.print(u.key)
        base.table.insert(objects, u)
      end
    end
    for i,v in base.pairs(group.mapObjects.route.targetNumbers) do
      for j,u in base.pairs(v) do
--        base.print(u.key)
        base.table.insert(objects, u)
      end
    end
    for i,v in base.pairs(group.mapObjects.route.targetZones) do
      for j,u in base.pairs(v) do
--        base.print(u.key)
        base.table.insert(objects, u)
      end
    end
  --     ,     
    --group.mapObjects.route = {line = {}, points = {}, numbers = {}, targets = {}, targetLines = {}, targetNumbers = {}, targetZones = {},}
  end
    for i,unit in base.pairs(group.units) do
      removeUnitZones(unit);
    end
  if group.mapObjects.INUFixPoints then
    for i,v in base.pairs(group.mapObjects.INUFixPoints) do
        base.table.insert(objects, v)
    end;
  end;
  if group.mapObjects.INUFixPoints_numbers then
    for i,v in base.pairs(group.mapObjects.INUFixPoints_numbers) do
        base.table.insert(objects, v)
    end;
  end;
  MapWindow.mapView:removeUserObjects(objects)
  MapWindow.mapView:updateUserList(true)
end


-- append all objects from objects array to target array
function addAll(target, objects, skipFirst)
    if objects then
        for _tmp,v in base.pairs(objects) do
            if not skipFirst then
                base.table.insert(target, v)
            else
                skipFirst = false
            end
        end
    end
end

-- append all objects from arrays in objects array to target array
function addAll2(target, objects)
    if objects then
        for _tmp,v in base.pairs(objects) do
            addAll(target, v)
        end
    end
end

--       , ,    
--   ,      .
function update_group_map_objects(group)
    --  ,  
    if group.hidden then 
        return;
    end;
    
    local scale = MapWindow.mapView:getScale()
    local toRemove = {}
    local toCreate = {};
    if group.mapObjects.route and ('static' ~= group.type) then
        if group.mapObjects.route.line then
            base.table.insert(toRemove, group.mapObjects.route.line)
            base.table.insert(toCreate, group.mapObjects.route.line)
        end
        addAll(toRemove, group.mapObjects.route.points)
        addAll(toRemove, group.mapObjects.route.numbers)
        addAll(toCreate, group.mapObjects.route.points)
        addAll(toCreate, group.mapObjects.route.numbers)
        if group.mapObjects.INUFixPoints then
            addAll(toRemove, group.mapObjects.INUFixPoints)
            addAll(toRemove, group.mapObjects.INUFixPoints_numbers)
            if group == MapWindow.selectedGroup then
                addAll(toCreate, group.mapObjects.INUFixPoints)
                addAll(toCreate, group.mapObjects.INUFixPoints_numbers)
            end;
        end;
        addAll(toRemove, group.mapObjects.zones)
        addAll(toCreate, group.mapObjects.zones)
        
        addAll2(toRemove, group.mapObjects.route.targetZones)
        addAll2(toRemove, group.mapObjects.route.targetLines)
        addAll2(toRemove, group.mapObjects.route.targets)
        addAll2(toRemove, group.mapObjects.route.targetNumbers)
        if group == MapWindow.selectedGroup then
            addAll2(toCreate, group.mapObjects.route.targetZones)
            addAll2(toCreate, group.mapObjects.route.targetLines)
            addAll2(toCreate, group.mapObjects.route.targets)
            addAll2(toCreate, group.mapObjects.route.targetNumbers)            
        end;
    end
    if 'static' == group.type then
        addAll(toRemove, group.mapObjects.units)
        addAll(toCreate, group.mapObjects.units)
    else
        for i = 2, #group.mapObjects.units do --     ..          
                                              --      
            local unitSymbol = group.mapObjects.units[i] -- 
            base.table.insert(toRemove, unitSymbol); 
            local hasZone = false; --      (, )
            local unit = unitSymbol.userObject; 
            local udb = base.me_db.unit_by_CLSID[unit.CLSID] --    
            if udb then
                if (udb.DetectionRange and (udb.DetectionRange > 0)) 
                    or (udb.ThreatRange and (udb.ThreatRange > 0)) then
                    hasZone = true; --    - 
                end
            end            
            if hasZone then --         
                base.table.insert(toCreate, unitSymbol);
            else --  ,   -   
                if UNITS_SCALE >= scale then
                    base.table.insert(toCreate, unitSymbol);
                    -- addAll(toRemove, group.mapObjects.units, true)
                    -- addAll(toCreate, group.mapObjects.units, true)
                end;
            end;
        end
        for i,unit in base.ipairs(group.units) do 
            updateUnitZones(unit);
        end
    end
    MapWindow.mapView:removeUserObjects(toRemove)
    MapWindow.mapView:addUserObjects(toCreate)
    MapWindow.mapView:updateUserList(true)
end


-- run mission
function runMission(params, returnScreen) 
   local file;
   if U.startsWith(params.file, './') then
       file = 'BlackShark/' .. params.file;       
   else
       file = '"' .. params.file .. '"';
   end

   local trackFile =  base.mainPath .. '../Temp/' .. base.trackFileName;
   if U.startsWith(trackFile, './') then
       trackFile = 'BlackShark/' .. trackFile;       
   else
       trackFile = '"' .. trackFile .. '"';
   end
   
   base.START_PARAMS.command = params.command .. ' --trackfile ' .. trackFile;
   base.START_PARAMS.missionPath = file;
   base.START_PARAMS.returnScreen = returnScreen;
   base.START_PARAMS.realMissionPath = params.realMissionPath;
   
   if params.mission ~= nil then
    base.START_PARAMS.realMissionPath = params.mission;
    --base.print('mission ->',params.mission);
   end;
   
   base.RETURN_SCREEN = returnScreen;
   base.MISSION_PATH = file;
   
   if base.__DO_NOT_ERASE_DEBRIEF_LOG__ == nil then 
    base.os.remove(base.simPath .. 'temp/debrief.log');
   end;

   lfs.chdir('..');
    
   if base.MapWindow.created then
        MapView.close()
   end
   
   Gui.Quit();
end


function copyMission(dest, source)
    --base.print('copying ' .. source .. ' to ' .. dest);
    local mission = base.assert(base.io.open(source, 'rb'))
    local data  = mission:read('*a')
    
    local file = base.assert(base.io.open(dest, 'wb'))
    if file then        
        file:write(data)
        file:close();
    end
    mission:close()
end;


-- Run mission
-- zipFile - path to mission zip file
-- if backToMain equals to true main menu will be activated after debreifing
-- else mission editor will be opened
-- if return callback is not null, it will be called after debreifing exit
-- backToMain argument is ignored in such case
function play(params, returnScreen, doNotApplyOptions, doSave)
    Debriefing.setReturnScreen(returnScreen)
	--base.U.stack();  
    local destPath = base.mainPath .. '../Temp/' .. base.tempMissionName;
    local missionPath = mission.path;
    if returnScreen == 'training' then
        missionPath = params.file
    end;
    if (missionPath == '') or (missionPath == nil) then
        base.print('missionPath == nil or ""', params.file, returnScreen, destPath, mission.path);
    end;
    
	if (doSave == true) then
		base.print('save_mission')
		save_mission(destPath)
	else
		base.print('copyMission')
		copyMission(destPath, missionPath);
	end
	
	doNotApplyOptions = doNotApplyOptions or checkIntro(destPath)
	base.print('doNotApplyOptions=',doNotApplyOptions)
	
    if doNotApplyOptions ~= true then
        applyOptions(destPath, missionPath)
    end;
	
	applyPlayerName(destPath)
	
    --fixMissionPath(destPath, missionPath);
    params.file = destPath;
    params.realMissionPath = missionPath;
    
    runMission(params, returnScreen)    
end

function checkIntro(fName)
	res = false
	
    local zipFile = base.assert(minizip.unzOpen(fName, 'rb'))
    if zipFile:unzLocateFile('track_data/continue_track') then
        res = true;		
    end
	zipFile:unzClose();
	
	return res;
end

function fixMissionPath(path, pathToFix)
    --base.print('fixMissionPath: path, pathToFix',path, pathToFix);
    --mis.path = pathToFix;
    local tempFileName = base.mainPath .. '../Temp/path.tmp'
    --local tempFileName = 'm_path'
    local f = base.io.output(tempFileName, 'w')
    f:write(pathToFix);
    f:close();
end; 

function unpackFiles(zipFile)
    --clearTempFolder()
    resources = {};
    -- for t in zipFile:files() do
        -- base.print('t.filename',t.filename);
    -- end;
    zipFile:unzGoToFirstFile()
    while true do
        local filename = zipFile:unzGetCurrentFileName()
        if (filename ~= 'mission') and (filename ~= 'options') and (filename ~= 'path') and ('/' ~= base.string.sub(filename, -1, -1)) then
            --base.print('UNPACKING: '..filename)
            local dirName = base.tempMissionPath;
            --base.print(dirName)
            --for w in base.string.gmatch(filename, '%w+/') do
            for w in base.string.gmatch(filename, '[^><|?*:/\]+/') do 
                --base.print('w: ', w)
                dirName = dirName .. w;
                local a = lfs.attributes(dirName,'mode')
                if not a then
                    --base.print('creating dir: ', dirName)
                    lfs.mkdir(dirName);
                    --base.debug.debug();
                end;
            end;
            local data = base.assert(zipFile:unzReadAllCurrentFile())
            local fullPath = base.tempMissionPath .. filename;
            local file = base.assert(base.io.open(fullPath, 'wb'))
            resources[fullPath] = filename;
            if file then
                --base.print('    saving '..fullPath)
                file:write(data)
                file:close();
            end
        end;
        if not zipFile:unzGoToNextFile() then break end
    end
end;

function packMissionResources(fName)
    for k,v in base.pairs(resources) do
        --base.print('packing ',k,v);
        zip.ZipFile(fName, k, v , 'add');
    end;
end;

function clearTempFolder()
    local function eraseFolder(folder)
        for file in lfs.dir(folder) do
            --base.print(file)
            local a = base.assert(lfs.attributes(folder .. '/' .. file))
            if (a.mode == 'directory') and (file ~= '.') and (file ~= '..') then
                --base.print('erasing folder', file)
                eraseFolder(folder .. '/' .. file)
                lfs.rmdir(folder .. '/' .. file)
            elseif a.mode == 'file' then
                --base.print('erasing file', file)
                base.os.remove(folder .. '/' .. file)
            end;
        end
    end;

    local a;
    local dir = base.tempMissionPath;
    --base.print('clearing temp folder', dir);
    if not lfs.dir(dir)() then
        base.print('creating temporary dir '..dir)
        lfs.mkdir(dir);
    end;
    
    eraseFolder(dir);
    resources = {};
end;

function insertFileIntoMission(filePath, fileName, oldFileName)
    --          
    if not fileName then
        fileName = U.extractFileName(filePath)
    end;
    
   
    --   
    local file = base.assert(base.io.open(filePath, 'rb'))
    local data;
    if file then
        data = file:read('*a');
        file:close();
    else
        local w = MsgWindow.new('Can not open file for reading "'..filePath..'"', ' Warning', 'warning', 'OK')
        w:setVisible(true);
        return false;
    end;

    --     
    local fullPath = base.tempMissionPath .. fileName;
    --base.print('fullPath', fullPath);
    if resources[fullPath] then --     
        file = base.io.open(fullPath, 'rb') -- ,       
        if file then --    ,   
            file:close();
            local size = lfs.attributes(fullPath, 'size');
            --base.print('size', size,'#data', #data);
            if #data ~= size then
                --             
                --        
                local w = MsgWindow.new('File "'..fileName..'" with different size "' ..#data.. '" already present in mission', ' Warning', 'warning', 'OK')
                w:setVisible(true);
                return false;
            end;
            --          ,    
            return true;
        else --    ,     
            local w = MsgWindow.new('Can not open file for reading "'..fileName..'"', ' Warning', 'warning', 'OK')
            w:setVisible(true);
        end
    else --   ,    ,   
        if oldFileName and (oldFileName ~= '') then --    
            base.print('removing', base.tempMissionPath .. oldFileName);
            removeFileFromMission(oldFileName)
            --base.os.remove(base.tempMissionPath .. oldFileName)
        end;
    end;
    
    -- ()  
    file = base.assert(base.io.open(fullPath, 'wb'))
    if file then
        --base.print('saving '..fullPath)
        file:write(data)
        file:close();
    end
    resources[fullPath] = fileName;    
    return true;
end;

function removeFileFromMission(fileName)
    --base.print('removing', fileName);
    local fullPath = base.tempMissionPath .. fileName;
    fileName = U.extractFileName(fileName);
    local file = base.io.open(fullPath, 'rb')
    --base.print('removing', base.tempMissionPath .. fileName);
    if file then
        file:close();
        base.os.remove(fullPath);
    end;
    resources[fullPath] = nil;  
end;

function updateMissionResources(fileName)
    local path = mission.path or base.mainPath .. '../Temp/' .. base.tempMissionName;
    if fileName ~= nil then
        path = fileName;
    end;
    base.print('updating resources',path);
    --base.print( mission.path, base.mainPath .. '../Temp/Untitled.miz', path)
    local zipFile = base.assert(minizip.unzOpen(path, 'rb'))
    unpackFiles(zipFile);
    zipFile:unzClose();
end;


-- Link waypoint to parent group
function linkWaypoint(waypoint, parentGroup, unit)
    if waypoint.linkUnit then
        unlinkWaypoint(waypoint)
    end

    waypoint.linkUnit = unit;
    if not unit.linkChildren then
        unit.linkChildren = { }
    end
    base.table.insert(unit.linkChildren, waypoint)
end


-- remove element from table
function removeElement(table, element)
    local cnt = #table
    for i = 1, cnt do
        if table[i] == element then
            base.table.remove(table, i)
            return
        end
    end
end


-- Remove link from this waypoint to parent
function unlinkWaypoint(waypoint)
    if waypoint and waypoint.linkUnit then
        removeElement(waypoint.linkUnit.linkChildren, waypoint)
        waypoint.linkUnit = nil
    end
end


-- find unit with skill player
function isPlayerAvailable()
    local playerName = crutches.getPlayerSkill();
    for _tmp, u in base.pairs(unit_by_name) do
        if playerName == u.skill then
            return true
        end
    end
    return false
end

function saveTrack(fileName)
    local trackPath = '../Temp/' .. base.trackFileName;
    base.print('trackPath', trackPath);
	
	--   ""  
--	local zipFpath = base.mainPath .. trackPath
--	local birdsPath = base.mainPath ..'../Scripts/Aircrafts/_Common/birds.lua'
--	local birdsZipPath = 'Scripts/Aircrafts/_Common/birds.lua'
--	zip.ZipFile(zipFpath, birdsPath, birdsZipPath, 'add')
	
    local file = base.io.open(trackPath, 'rb')
    local data;
    if file then
        data = file:read('*a');
        file:close();
    else
        local w = MsgWindow.new(_('Can not open file for reading "')..trackPath..'"', _('Warning'), _('warning'), 'OK')
        w:setVisible(true);
        return false;
    end;
    file = base.io.open(fileName, 'wb')
    if file then
        base.print('saving '.. fileName)
        file:write(data)
        file:close();        
    else
        local w = MsgWindow.new(_('Can not open file for writing "')..trackPath..'"', _('Warning'), _('warning'), 'OK')
        w:setVisible(true);
        return false;
    end        
end; 

-- relink children units
function relinkChildren(unit)
    if (not unit) or (not unit.linkChildren) then
        return
    end

    local children = { }
    for k, v in base.pairs(unit.linkChildren) do
        base.table.insert(children, v)
    end
    
    for _tmp, v in base.pairs(children) do
        unlinkWaypoint(v)
        base.panel_route.attractToAirfield(v, v.boss, v.type)
    end
end

function fixBriefingPictures()
    mission.pictureFileNameR = mission.pictureFileNameR or {};
    if 'string' == base.type(mission.pictureFileNameR) then
        local name = mission.pictureFileNameR;
        mission.pictureFileNameR = {};
        if name ~= '' then
            base.table.insert(mission.pictureFileNameR, name);
        end;
    end;
    mission.pictureFileNameB = mission.pictureFileNameB or {};
    if 'string' == base.type(mission.pictureFileNameB) then
        local name = mission.pictureFileNameB;
        mission.pictureFileNameB = {};
        if name ~= '' then
            base.table.insert(mission.pictureFileNameB, name);
        end;
    end;
end; 

function applyOptions(fName, realMissionName)
    --base.print('fName, mission.path',fName, mission.path);
    fName = fName or mission.path;
    local zipFile = base.assert(minizip.unzOpen(fName, 'rb'))
    local misStr
    if zipFile:unzLocateFile('mission') then
        misStr = zipFile:unzReadAllCurrentFile()
    end
    
    unpackFiles(zipFile);
    zipFile:unzClose()

    local fun = base.loadstring(misStr);
    local env = {}
    base.setfenv(fun, env)
    fun()

    mis = env.mission
		
    --enforceOptions(mis);
    
    --base.print('applying options to ',fName);
    --save(fName, mis, false)
    
    local tempFileName = "temp.tmp"
    local f = base.io.open(tempFileName, 'wb')
    f:write(misStr);
    f:close();
    
    zip.ZipFile(fName, tempFileName, "mission");
    base.os.remove(tempFileName)
    
	--base.print("add playerName")
    --local tempOptions = base.panel_options.getOptions(); -- mis.options    
    local tempOptions = base.panel_options.enforceOptions(); -- mis.options   
	--tempOptions["playerName"] = LogBook.currentPlayer.player.callsign
    U.addTableToZip(fName, "options", tempOptions)
    --base.U.traverseTable(tempOptions)	
	
    packMissionResources(fName)
    
end; 

function applyPlayerName(fName)
    fName = fName or mission.path;
    local zipFile = base.assert(minizip.unzOpen(fName, 'rb'))
    local misStr
    if zipFile:unzLocateFile('mission') then
        misStr = zipFile:unzReadAllCurrentFile()
    end
	
	if zipFile:unzLocateFile('options') then
        optStr = zipFile:unzReadAllCurrentFile()
    end
    
    unpackFiles(zipFile);
    zipFile:unzClose()

    local fun = base.loadstring(optStr);
    local env = {}
    base.setfenv(fun, env)
    fun()
	
	--base.U.traverseTable(env)	
   
    local tempFileName = "temp.tmp"
    local f = base.io.open(tempFileName, 'wb')
    f:write(misStr);
    f:close();
    
    zip.ZipFile(fName, tempFileName, "mission");
    base.os.remove(tempFileName)
    
	base.print("add playerName")

    local tempOptions = env.options; -- mis.options   
	--base.print("==================================")
	--base.U.traverseTable(tempOptions)	
	tempOptions["playerName"] = LogBook.currentPlayer.player.callsign
    U.addTableToZip(fName, "options", tempOptions)
    --base.U.traverseTable(tempOptions)	
	--base.print("==================================")
    packMissionResources(fName)
    
end; 

function isMissionModified()
    local addIgnoredRecord = function(list, fieldName, containingField, distance)
        if list[fieldName] ~= nil then
            base.Gui.MessageBox("Field " .. fieldName .. ' already present', 'Error');
            return
        end;
        local rec = {};
        rec.containingField = containingField;
        rec.distance = distance;
        list[fieldName] = rec;
    end;
    local ignoredFields = {};
    addIgnoredRecord(ignoredFields, 'mapElementsCreated', '__RooT__', 1);
    addIgnoredRecord(ignoredFields, 'path', '__RooT__', 1);
    addIgnoredRecord(ignoredFields, 'dist', 'route', 1);
    addIgnoredRecord(ignoredFields, 'len', 'route', 1);
    addIgnoredRecord(ignoredFields, 'range', 'route', 1);
    addIgnoredRecord(ignoredFields, 'mapObjects');
    addIgnoredRecord(ignoredFields, 'dLong', 'units', 2);
    addIgnoredRecord(ignoredFields, 'dLat', 'units', 2);
    addIgnoredRecord(ignoredFields, 'zones', 'unit', 1);
    addIgnoredRecord(ignoredFields, 'symbol', 'INUFixPoints', 2);
    addIgnoredRecord(ignoredFields, 'text', 'INUFixPoints', 2);
    
    local identical = base.U.compareTables(originalMission, mission, ignoredFields);
    --base.U.traverseTable(originalMission, nil, '  ', 'original.lua');
    --base.U.traverseTable(mission, nil, '  ', 'mission.lua');
	--base.U.traverseTable(mission.failures, nil, '  ', 'original.lua');
    --base.U.traverseTable(base.panel_failures.vdata, nil, '  ', 'mission.lua');
    return not identical;
end; 

function isTrack(filePath)
    local zipFile = minizip.unzOpen(filePath, 'rb')
    local trackFlag = false;
    local introFlag = false;
    if zipFile ~= nil then
        zipFile:unzGoToFirstFile()
        while true do
            local fileName = zipFile:unzGetCurrentFileName();
            --base.print(fileName)
            if base.string.find(fileName, 'track_data') ~= nil then
                trackFlag = true;
                --base.print('-- TRACK');
                -- zipFile:unzClose();
                -- return true;
            end;
            if base.string.find(fileName, 'continue_track') ~= nil then
                introFlag = true;
                --base.print('-- INTRO');
            end;
            if not zipFile:unzGoToNextFile() then break end
        end
        zipFile:unzClose();
        if (trackFlag == true) and (introFlag == false) then 
            base.print('========== TRACK !!! ==========');
            return true -- track 
        else
            if (introFlag == true) then
                base.print('========== INTRO !!! ==========');
            end;
            return false
        end;
        return false;
    else
        return nil;
    end;
end; 

function checkMissionIntroduction(filePath)
    local filePath = filePath or mission.path;
    base.print('checking introduction',filePath);
    local zipFile = minizip.unzOpen(filePath, 'rb')
    if not zipFile then
        base.print("can't open mission file")
        return false
    end
    zipFile:unzGoToFirstFile()
    while true do
        local filename = zipFile:unzGetCurrentFileName()
        if (filename ~= 'mission') and (filename ~= 'options') and (filename ~= 'path') and ('/' ~= base.string.sub(filename, -1, -1)) then
            --base.print('filename', filename);
            if ( base.string.find(filename, 'continue_track') ~= nil) then
                base.print('introduction found');
                zipFile:unzClose()
                return true
            end;
        end;
        if not zipFile:unzGoToNextFile() then break end
    end
    zipFile:unzClose()
    base.print('introduction NOT found');
    return false
end; 

function fixCallsigns()
    local names = {'plane', 'helicopter'};
    for k, coalition in base.pairs(mission.coalition) do
        --base.print('coalition', k,coalition)
        for k,country in base.ipairs(coalition.country) do
            --base.print('country', k, country.name)
            for k, name in base.ipairs(names) do
                --base.print('name', k, name)
                for k, group in base.ipairs(country[name].group) do
                    --base.print('group', k, group.name)
                    for id,unit in base.pairs(group.units) do
                        local group = unit.boss;
                        --base.print(country.name .. ' - ' .. group.type .. ' unit ' .. base.tostring(id) .. ' callsign ', unit.callsign or 'nil')
                        if U.isWesternCountry(country.name) and (not base.panel_aircraft.isWesternCallsign(unit.callsign or '')) then
                            local newCallsign = base.panel_aircraft.getNewCallsign(unit);
                            --base.print('old: "' .. unit.callsign .. '", new: ' .. newCallsign)
                            unit.callsign = newCallsign;
                        end;
                    end;
                end;
            end;
        end;
    end;
end;

function unloadCallsign(callsign)
    local res = {
        name = callsign;
    };
    local num = base.tonumber(callsign);
    if num then 
        res[1] = base.tonumber(base.string.sub(callsign, 1, 1))
        res[2] = base.tonumber(base.string.sub(callsign, 2, 2))
        res[3] = base.tonumber(base.string.sub(callsign, 3, 3))
    else
        local str = base.string.match(callsign, '%a+');
        local i;
        for k,v in base.ipairs(base.panel_aircraft.natoCallsigns) do 
            if v == str then 
                i = k;
                break;
            end;
        end;
        res[1] = i;
        res[2] = base.tonumber(base.string.match(callsign, '%d'))
        res[3] = base.tonumber(base.string.match(callsign, '%d$'))  
    end;
    --base.print('unloading callsign', res.name);
    return res;
end;

function convertCallsign(callsign)
    if base.type(callsign) == 'table' then
        return callsign.name;
    elseif base.type(callsign) == 'number' then 
        return base.tostring(callsign);
    elseif base.type(callsign) == 'string' then
        return callsign;
    end;
end;

clearTempFolder();

